# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OntapVolumeArgs', 'OntapVolume']

@pulumi.input_type
class OntapVolumeArgs:
    def __init__(__self__, *,
                 junction_path: pulumi.Input[str],
                 size_in_megabytes: pulumi.Input[int],
                 storage_efficiency_enabled: pulumi.Input[bool],
                 storage_virtual_machine_id: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None,
                 security_style: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tiering_policy: Optional[pulumi.Input['OntapVolumeTieringPolicyArgs']] = None,
                 volume_type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a OntapVolume resource.
        :param pulumi.Input[str] junction_path: Specifies the location in the storage virtual machine's namespace where the volume is mounted. The junction_path must have a leading forward slash, such as `/vol3`
        :param pulumi.Input[int] size_in_megabytes: Specifies the size of the volume, in megabytes (MB), that you are creating.
        :param pulumi.Input[bool] storage_efficiency_enabled: Set to true to enable deduplication, compression, and compaction storage efficiency features on the volume.
        :param pulumi.Input[str] storage_virtual_machine_id: Specifies the storage virtual machine in which to create the volume.
        :param pulumi.Input[str] name: Specifies the tiering policy for the ONTAP volume for moving data to the capacity pool storage. Valid values are `SNAPSHOT_ONLY`, `AUTO`, `ALL`, `NONE`. Default value is `SNAPSHOT_ONLY`.
        :param pulumi.Input[str] security_style: Specifies the volume security style, Valid values are `UNIX`, `NTFS`, and `MIXED`. Default value is `UNIX`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the volume. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[str] volume_type: The type of volume, currently the only valid value is `ONTAP`.
        """
        pulumi.set(__self__, "junction_path", junction_path)
        pulumi.set(__self__, "size_in_megabytes", size_in_megabytes)
        pulumi.set(__self__, "storage_efficiency_enabled", storage_efficiency_enabled)
        pulumi.set(__self__, "storage_virtual_machine_id", storage_virtual_machine_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if security_style is not None:
            pulumi.set(__self__, "security_style", security_style)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tiering_policy is not None:
            pulumi.set(__self__, "tiering_policy", tiering_policy)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter(name="junctionPath")
    def junction_path(self) -> pulumi.Input[str]:
        """
        Specifies the location in the storage virtual machine's namespace where the volume is mounted. The junction_path must have a leading forward slash, such as `/vol3`
        """
        return pulumi.get(self, "junction_path")

    @junction_path.setter
    def junction_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "junction_path", value)

    @property
    @pulumi.getter(name="sizeInMegabytes")
    def size_in_megabytes(self) -> pulumi.Input[int]:
        """
        Specifies the size of the volume, in megabytes (MB), that you are creating.
        """
        return pulumi.get(self, "size_in_megabytes")

    @size_in_megabytes.setter
    def size_in_megabytes(self, value: pulumi.Input[int]):
        pulumi.set(self, "size_in_megabytes", value)

    @property
    @pulumi.getter(name="storageEfficiencyEnabled")
    def storage_efficiency_enabled(self) -> pulumi.Input[bool]:
        """
        Set to true to enable deduplication, compression, and compaction storage efficiency features on the volume.
        """
        return pulumi.get(self, "storage_efficiency_enabled")

    @storage_efficiency_enabled.setter
    def storage_efficiency_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "storage_efficiency_enabled", value)

    @property
    @pulumi.getter(name="storageVirtualMachineId")
    def storage_virtual_machine_id(self) -> pulumi.Input[str]:
        """
        Specifies the storage virtual machine in which to create the volume.
        """
        return pulumi.get(self, "storage_virtual_machine_id")

    @storage_virtual_machine_id.setter
    def storage_virtual_machine_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "storage_virtual_machine_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the tiering policy for the ONTAP volume for moving data to the capacity pool storage. Valid values are `SNAPSHOT_ONLY`, `AUTO`, `ALL`, `NONE`. Default value is `SNAPSHOT_ONLY`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="securityStyle")
    def security_style(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the volume security style, Valid values are `UNIX`, `NTFS`, and `MIXED`. Default value is `UNIX`.
        """
        return pulumi.get(self, "security_style")

    @security_style.setter
    def security_style(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_style", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the volume. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tieringPolicy")
    def tiering_policy(self) -> Optional[pulumi.Input['OntapVolumeTieringPolicyArgs']]:
        return pulumi.get(self, "tiering_policy")

    @tiering_policy.setter
    def tiering_policy(self, value: Optional[pulumi.Input['OntapVolumeTieringPolicyArgs']]):
        pulumi.set(self, "tiering_policy", value)

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of volume, currently the only valid value is `ONTAP`.
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_type", value)


@pulumi.input_type
class _OntapVolumeState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 file_system_id: Optional[pulumi.Input[str]] = None,
                 flexcache_endpoint_type: Optional[pulumi.Input[str]] = None,
                 junction_path: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ontap_volume_type: Optional[pulumi.Input[str]] = None,
                 security_style: Optional[pulumi.Input[str]] = None,
                 size_in_megabytes: Optional[pulumi.Input[int]] = None,
                 storage_efficiency_enabled: Optional[pulumi.Input[bool]] = None,
                 storage_virtual_machine_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tiering_policy: Optional[pulumi.Input['OntapVolumeTieringPolicyArgs']] = None,
                 uuid: Optional[pulumi.Input[str]] = None,
                 volume_type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering OntapVolume resources.
        :param pulumi.Input[str] arn: Amazon Resource Name of the volune.
        :param pulumi.Input[str] file_system_id: Describes the file system for the volume, e.g. `fs-12345679`
        :param pulumi.Input[str] flexcache_endpoint_type: Specifies the FlexCache endpoint type of the volume, Valid values are `NONE`, `ORIGIN`, `CACHE`. Default value is `NONE`. These can be set by the ONTAP CLI or API and are use with FlexCache feature.
        :param pulumi.Input[str] junction_path: Specifies the location in the storage virtual machine's namespace where the volume is mounted. The junction_path must have a leading forward slash, such as `/vol3`
        :param pulumi.Input[str] name: Specifies the tiering policy for the ONTAP volume for moving data to the capacity pool storage. Valid values are `SNAPSHOT_ONLY`, `AUTO`, `ALL`, `NONE`. Default value is `SNAPSHOT_ONLY`.
        :param pulumi.Input[str] ontap_volume_type: Specifies the type of volume, Valid values are `RW`, `DP`,  and `LS`. Default value is `RW`. These can be set by the ONTAP CLI or API. This setting is used as part of migration and replication [Migrating to Amazon FSx for NetApp ONTAP](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/migrating-fsx-ontap.html)
        :param pulumi.Input[str] security_style: Specifies the volume security style, Valid values are `UNIX`, `NTFS`, and `MIXED`. Default value is `UNIX`.
        :param pulumi.Input[int] size_in_megabytes: Specifies the size of the volume, in megabytes (MB), that you are creating.
        :param pulumi.Input[bool] storage_efficiency_enabled: Set to true to enable deduplication, compression, and compaction storage efficiency features on the volume.
        :param pulumi.Input[str] storage_virtual_machine_id: Specifies the storage virtual machine in which to create the volume.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the volume. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[str] uuid: The Volume's UUID (universally unique identifier).
        :param pulumi.Input[str] volume_type: The type of volume, currently the only valid value is `ONTAP`.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if file_system_id is not None:
            pulumi.set(__self__, "file_system_id", file_system_id)
        if flexcache_endpoint_type is not None:
            pulumi.set(__self__, "flexcache_endpoint_type", flexcache_endpoint_type)
        if junction_path is not None:
            pulumi.set(__self__, "junction_path", junction_path)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ontap_volume_type is not None:
            pulumi.set(__self__, "ontap_volume_type", ontap_volume_type)
        if security_style is not None:
            pulumi.set(__self__, "security_style", security_style)
        if size_in_megabytes is not None:
            pulumi.set(__self__, "size_in_megabytes", size_in_megabytes)
        if storage_efficiency_enabled is not None:
            pulumi.set(__self__, "storage_efficiency_enabled", storage_efficiency_enabled)
        if storage_virtual_machine_id is not None:
            pulumi.set(__self__, "storage_virtual_machine_id", storage_virtual_machine_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if tiering_policy is not None:
            pulumi.set(__self__, "tiering_policy", tiering_policy)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name of the volune.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> Optional[pulumi.Input[str]]:
        """
        Describes the file system for the volume, e.g. `fs-12345679`
        """
        return pulumi.get(self, "file_system_id")

    @file_system_id.setter
    def file_system_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_system_id", value)

    @property
    @pulumi.getter(name="flexcacheEndpointType")
    def flexcache_endpoint_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the FlexCache endpoint type of the volume, Valid values are `NONE`, `ORIGIN`, `CACHE`. Default value is `NONE`. These can be set by the ONTAP CLI or API and are use with FlexCache feature.
        """
        return pulumi.get(self, "flexcache_endpoint_type")

    @flexcache_endpoint_type.setter
    def flexcache_endpoint_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "flexcache_endpoint_type", value)

    @property
    @pulumi.getter(name="junctionPath")
    def junction_path(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the location in the storage virtual machine's namespace where the volume is mounted. The junction_path must have a leading forward slash, such as `/vol3`
        """
        return pulumi.get(self, "junction_path")

    @junction_path.setter
    def junction_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "junction_path", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the tiering policy for the ONTAP volume for moving data to the capacity pool storage. Valid values are `SNAPSHOT_ONLY`, `AUTO`, `ALL`, `NONE`. Default value is `SNAPSHOT_ONLY`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="ontapVolumeType")
    def ontap_volume_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the type of volume, Valid values are `RW`, `DP`,  and `LS`. Default value is `RW`. These can be set by the ONTAP CLI or API. This setting is used as part of migration and replication [Migrating to Amazon FSx for NetApp ONTAP](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/migrating-fsx-ontap.html)
        """
        return pulumi.get(self, "ontap_volume_type")

    @ontap_volume_type.setter
    def ontap_volume_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ontap_volume_type", value)

    @property
    @pulumi.getter(name="securityStyle")
    def security_style(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the volume security style, Valid values are `UNIX`, `NTFS`, and `MIXED`. Default value is `UNIX`.
        """
        return pulumi.get(self, "security_style")

    @security_style.setter
    def security_style(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_style", value)

    @property
    @pulumi.getter(name="sizeInMegabytes")
    def size_in_megabytes(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the size of the volume, in megabytes (MB), that you are creating.
        """
        return pulumi.get(self, "size_in_megabytes")

    @size_in_megabytes.setter
    def size_in_megabytes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size_in_megabytes", value)

    @property
    @pulumi.getter(name="storageEfficiencyEnabled")
    def storage_efficiency_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to true to enable deduplication, compression, and compaction storage efficiency features on the volume.
        """
        return pulumi.get(self, "storage_efficiency_enabled")

    @storage_efficiency_enabled.setter
    def storage_efficiency_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "storage_efficiency_enabled", value)

    @property
    @pulumi.getter(name="storageVirtualMachineId")
    def storage_virtual_machine_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the storage virtual machine in which to create the volume.
        """
        return pulumi.get(self, "storage_virtual_machine_id")

    @storage_virtual_machine_id.setter
    def storage_virtual_machine_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_virtual_machine_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the volume. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="tieringPolicy")
    def tiering_policy(self) -> Optional[pulumi.Input['OntapVolumeTieringPolicyArgs']]:
        return pulumi.get(self, "tiering_policy")

    @tiering_policy.setter
    def tiering_policy(self, value: Optional[pulumi.Input['OntapVolumeTieringPolicyArgs']]):
        pulumi.set(self, "tiering_policy", value)

    @property
    @pulumi.getter
    def uuid(self) -> Optional[pulumi.Input[str]]:
        """
        The Volume's UUID (universally unique identifier).
        """
        return pulumi.get(self, "uuid")

    @uuid.setter
    def uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uuid", value)

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of volume, currently the only valid value is `ONTAP`.
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_type", value)


class OntapVolume(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 junction_path: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 security_style: Optional[pulumi.Input[str]] = None,
                 size_in_megabytes: Optional[pulumi.Input[int]] = None,
                 storage_efficiency_enabled: Optional[pulumi.Input[bool]] = None,
                 storage_virtual_machine_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tiering_policy: Optional[pulumi.Input[pulumi.InputType['OntapVolumeTieringPolicyArgs']]] = None,
                 volume_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a FSx ONTAP Volume.
        See the [FSx ONTAP User Guide](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-volumes.html) for more information.

        ## Example Usage
        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.fsx.OntapVolume("test",
            junction_path="/test",
            size_in_megabytes=1024,
            storage_efficiency_enabled=True,
            storage_virtual_machine_id=aws_fsx_ontap_storage_virtual_machine["test"]["id"])
        ```
        ### Using Tiering Policy

        Additional information on tiering policy with ONTAP Volumes can be found in the [FSx ONTAP Guide](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-volumes.html).

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.fsx.OntapVolume("test",
            junction_path="/test",
            size_in_megabytes=1024,
            storage_efficiency_enabled=True,
            storage_virtual_machine_id=aws_fsx_ontap_storage_virtual_machine["test"]["id"],
            tiering_policy=aws.fsx.OntapVolumeTieringPolicyArgs(
                name="AUTO",
                cooling_period=31,
            ))
        ```

        ## Import

        FSx ONTAP volume can be imported using the `id`, e.g.,

        ```sh
         $ pulumi import aws:fsx/ontapVolume:OntapVolume example fsvol-12345678abcdef123
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] junction_path: Specifies the location in the storage virtual machine's namespace where the volume is mounted. The junction_path must have a leading forward slash, such as `/vol3`
        :param pulumi.Input[str] name: Specifies the tiering policy for the ONTAP volume for moving data to the capacity pool storage. Valid values are `SNAPSHOT_ONLY`, `AUTO`, `ALL`, `NONE`. Default value is `SNAPSHOT_ONLY`.
        :param pulumi.Input[str] security_style: Specifies the volume security style, Valid values are `UNIX`, `NTFS`, and `MIXED`. Default value is `UNIX`.
        :param pulumi.Input[int] size_in_megabytes: Specifies the size of the volume, in megabytes (MB), that you are creating.
        :param pulumi.Input[bool] storage_efficiency_enabled: Set to true to enable deduplication, compression, and compaction storage efficiency features on the volume.
        :param pulumi.Input[str] storage_virtual_machine_id: Specifies the storage virtual machine in which to create the volume.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the volume. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[str] volume_type: The type of volume, currently the only valid value is `ONTAP`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OntapVolumeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a FSx ONTAP Volume.
        See the [FSx ONTAP User Guide](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-volumes.html) for more information.

        ## Example Usage
        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.fsx.OntapVolume("test",
            junction_path="/test",
            size_in_megabytes=1024,
            storage_efficiency_enabled=True,
            storage_virtual_machine_id=aws_fsx_ontap_storage_virtual_machine["test"]["id"])
        ```
        ### Using Tiering Policy

        Additional information on tiering policy with ONTAP Volumes can be found in the [FSx ONTAP Guide](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-volumes.html).

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.fsx.OntapVolume("test",
            junction_path="/test",
            size_in_megabytes=1024,
            storage_efficiency_enabled=True,
            storage_virtual_machine_id=aws_fsx_ontap_storage_virtual_machine["test"]["id"],
            tiering_policy=aws.fsx.OntapVolumeTieringPolicyArgs(
                name="AUTO",
                cooling_period=31,
            ))
        ```

        ## Import

        FSx ONTAP volume can be imported using the `id`, e.g.,

        ```sh
         $ pulumi import aws:fsx/ontapVolume:OntapVolume example fsvol-12345678abcdef123
        ```

        :param str resource_name: The name of the resource.
        :param OntapVolumeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OntapVolumeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 junction_path: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 security_style: Optional[pulumi.Input[str]] = None,
                 size_in_megabytes: Optional[pulumi.Input[int]] = None,
                 storage_efficiency_enabled: Optional[pulumi.Input[bool]] = None,
                 storage_virtual_machine_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tiering_policy: Optional[pulumi.Input[pulumi.InputType['OntapVolumeTieringPolicyArgs']]] = None,
                 volume_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OntapVolumeArgs.__new__(OntapVolumeArgs)

            if junction_path is None and not opts.urn:
                raise TypeError("Missing required property 'junction_path'")
            __props__.__dict__["junction_path"] = junction_path
            __props__.__dict__["name"] = name
            __props__.__dict__["security_style"] = security_style
            if size_in_megabytes is None and not opts.urn:
                raise TypeError("Missing required property 'size_in_megabytes'")
            __props__.__dict__["size_in_megabytes"] = size_in_megabytes
            if storage_efficiency_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'storage_efficiency_enabled'")
            __props__.__dict__["storage_efficiency_enabled"] = storage_efficiency_enabled
            if storage_virtual_machine_id is None and not opts.urn:
                raise TypeError("Missing required property 'storage_virtual_machine_id'")
            __props__.__dict__["storage_virtual_machine_id"] = storage_virtual_machine_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tiering_policy"] = tiering_policy
            __props__.__dict__["volume_type"] = volume_type
            __props__.__dict__["arn"] = None
            __props__.__dict__["file_system_id"] = None
            __props__.__dict__["flexcache_endpoint_type"] = None
            __props__.__dict__["ontap_volume_type"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["uuid"] = None
        super(OntapVolume, __self__).__init__(
            'aws:fsx/ontapVolume:OntapVolume',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            file_system_id: Optional[pulumi.Input[str]] = None,
            flexcache_endpoint_type: Optional[pulumi.Input[str]] = None,
            junction_path: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            ontap_volume_type: Optional[pulumi.Input[str]] = None,
            security_style: Optional[pulumi.Input[str]] = None,
            size_in_megabytes: Optional[pulumi.Input[int]] = None,
            storage_efficiency_enabled: Optional[pulumi.Input[bool]] = None,
            storage_virtual_machine_id: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tiering_policy: Optional[pulumi.Input[pulumi.InputType['OntapVolumeTieringPolicyArgs']]] = None,
            uuid: Optional[pulumi.Input[str]] = None,
            volume_type: Optional[pulumi.Input[str]] = None) -> 'OntapVolume':
        """
        Get an existing OntapVolume resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: Amazon Resource Name of the volune.
        :param pulumi.Input[str] file_system_id: Describes the file system for the volume, e.g. `fs-12345679`
        :param pulumi.Input[str] flexcache_endpoint_type: Specifies the FlexCache endpoint type of the volume, Valid values are `NONE`, `ORIGIN`, `CACHE`. Default value is `NONE`. These can be set by the ONTAP CLI or API and are use with FlexCache feature.
        :param pulumi.Input[str] junction_path: Specifies the location in the storage virtual machine's namespace where the volume is mounted. The junction_path must have a leading forward slash, such as `/vol3`
        :param pulumi.Input[str] name: Specifies the tiering policy for the ONTAP volume for moving data to the capacity pool storage. Valid values are `SNAPSHOT_ONLY`, `AUTO`, `ALL`, `NONE`. Default value is `SNAPSHOT_ONLY`.
        :param pulumi.Input[str] ontap_volume_type: Specifies the type of volume, Valid values are `RW`, `DP`,  and `LS`. Default value is `RW`. These can be set by the ONTAP CLI or API. This setting is used as part of migration and replication [Migrating to Amazon FSx for NetApp ONTAP](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/migrating-fsx-ontap.html)
        :param pulumi.Input[str] security_style: Specifies the volume security style, Valid values are `UNIX`, `NTFS`, and `MIXED`. Default value is `UNIX`.
        :param pulumi.Input[int] size_in_megabytes: Specifies the size of the volume, in megabytes (MB), that you are creating.
        :param pulumi.Input[bool] storage_efficiency_enabled: Set to true to enable deduplication, compression, and compaction storage efficiency features on the volume.
        :param pulumi.Input[str] storage_virtual_machine_id: Specifies the storage virtual machine in which to create the volume.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the volume. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[str] uuid: The Volume's UUID (universally unique identifier).
        :param pulumi.Input[str] volume_type: The type of volume, currently the only valid value is `ONTAP`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OntapVolumeState.__new__(_OntapVolumeState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["file_system_id"] = file_system_id
        __props__.__dict__["flexcache_endpoint_type"] = flexcache_endpoint_type
        __props__.__dict__["junction_path"] = junction_path
        __props__.__dict__["name"] = name
        __props__.__dict__["ontap_volume_type"] = ontap_volume_type
        __props__.__dict__["security_style"] = security_style
        __props__.__dict__["size_in_megabytes"] = size_in_megabytes
        __props__.__dict__["storage_efficiency_enabled"] = storage_efficiency_enabled
        __props__.__dict__["storage_virtual_machine_id"] = storage_virtual_machine_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["tiering_policy"] = tiering_policy
        __props__.__dict__["uuid"] = uuid
        __props__.__dict__["volume_type"] = volume_type
        return OntapVolume(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        Amazon Resource Name of the volune.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> pulumi.Output[str]:
        """
        Describes the file system for the volume, e.g. `fs-12345679`
        """
        return pulumi.get(self, "file_system_id")

    @property
    @pulumi.getter(name="flexcacheEndpointType")
    def flexcache_endpoint_type(self) -> pulumi.Output[str]:
        """
        Specifies the FlexCache endpoint type of the volume, Valid values are `NONE`, `ORIGIN`, `CACHE`. Default value is `NONE`. These can be set by the ONTAP CLI or API and are use with FlexCache feature.
        """
        return pulumi.get(self, "flexcache_endpoint_type")

    @property
    @pulumi.getter(name="junctionPath")
    def junction_path(self) -> pulumi.Output[str]:
        """
        Specifies the location in the storage virtual machine's namespace where the volume is mounted. The junction_path must have a leading forward slash, such as `/vol3`
        """
        return pulumi.get(self, "junction_path")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the tiering policy for the ONTAP volume for moving data to the capacity pool storage. Valid values are `SNAPSHOT_ONLY`, `AUTO`, `ALL`, `NONE`. Default value is `SNAPSHOT_ONLY`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="ontapVolumeType")
    def ontap_volume_type(self) -> pulumi.Output[str]:
        """
        Specifies the type of volume, Valid values are `RW`, `DP`,  and `LS`. Default value is `RW`. These can be set by the ONTAP CLI or API. This setting is used as part of migration and replication [Migrating to Amazon FSx for NetApp ONTAP](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/migrating-fsx-ontap.html)
        """
        return pulumi.get(self, "ontap_volume_type")

    @property
    @pulumi.getter(name="securityStyle")
    def security_style(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the volume security style, Valid values are `UNIX`, `NTFS`, and `MIXED`. Default value is `UNIX`.
        """
        return pulumi.get(self, "security_style")

    @property
    @pulumi.getter(name="sizeInMegabytes")
    def size_in_megabytes(self) -> pulumi.Output[int]:
        """
        Specifies the size of the volume, in megabytes (MB), that you are creating.
        """
        return pulumi.get(self, "size_in_megabytes")

    @property
    @pulumi.getter(name="storageEfficiencyEnabled")
    def storage_efficiency_enabled(self) -> pulumi.Output[bool]:
        """
        Set to true to enable deduplication, compression, and compaction storage efficiency features on the volume.
        """
        return pulumi.get(self, "storage_efficiency_enabled")

    @property
    @pulumi.getter(name="storageVirtualMachineId")
    def storage_virtual_machine_id(self) -> pulumi.Output[str]:
        """
        Specifies the storage virtual machine in which to create the volume.
        """
        return pulumi.get(self, "storage_virtual_machine_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A map of tags to assign to the volume. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="tieringPolicy")
    def tiering_policy(self) -> pulumi.Output[Optional['outputs.OntapVolumeTieringPolicy']]:
        return pulumi.get(self, "tiering_policy")

    @property
    @pulumi.getter
    def uuid(self) -> pulumi.Output[str]:
        """
        The Volume's UUID (universally unique identifier).
        """
        return pulumi.get(self, "uuid")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> pulumi.Output[Optional[str]]:
        """
        The type of volume, currently the only valid value is `ONTAP`.
        """
        return pulumi.get(self, "volume_type")

