# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['BackupArgs', 'Backup']

@pulumi.input_type
class BackupArgs:
    def __init__(__self__, *,
                 file_system_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 volume_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Backup resource.
        :param pulumi.Input[str] file_system_id: The ID of the file system to back up. Required if backing up Lustre or Windows file systems.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the file system. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level. If you have set `copy_tags_to_backups` to true, and you specify one or more tags, no existing file system tags are copied from the file system to the backup.
        :param pulumi.Input[str] volume_id: The ID of the volume to back up. Required if backing up a ONTAP Volume.
        """
        if file_system_id is not None:
            pulumi.set(__self__, "file_system_id", file_system_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if volume_id is not None:
            pulumi.set(__self__, "volume_id", volume_id)

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the file system to back up. Required if backing up Lustre or Windows file systems.
        """
        return pulumi.get(self, "file_system_id")

    @file_system_id.setter
    def file_system_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_system_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the file system. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level. If you have set `copy_tags_to_backups` to true, and you specify one or more tags, no existing file system tags are copied from the file system to the backup.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the volume to back up. Required if backing up a ONTAP Volume.
        """
        return pulumi.get(self, "volume_id")

    @volume_id.setter
    def volume_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_id", value)


@pulumi.input_type
class _BackupState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 file_system_id: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 owner_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 volume_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Backup resources.
        :param pulumi.Input[str] arn: Amazon Resource Name of the backup.
        :param pulumi.Input[str] file_system_id: The ID of the file system to back up. Required if backing up Lustre or Windows file systems.
        :param pulumi.Input[str] kms_key_id: The ID of the AWS Key Management Service (AWS KMS) key used to encrypt the backup of the Amazon FSx file system's data at rest.
        :param pulumi.Input[str] owner_id: AWS account identifier that created the file system.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the file system. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level. If you have set `copy_tags_to_backups` to true, and you specify one or more tags, no existing file system tags are copied from the file system to the backup.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[str] type: The type of the file system backup.
        :param pulumi.Input[str] volume_id: The ID of the volume to back up. Required if backing up a ONTAP Volume.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if file_system_id is not None:
            pulumi.set(__self__, "file_system_id", file_system_id)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if owner_id is not None:
            pulumi.set(__self__, "owner_id", owner_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if volume_id is not None:
            pulumi.set(__self__, "volume_id", volume_id)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name of the backup.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the file system to back up. Required if backing up Lustre or Windows file systems.
        """
        return pulumi.get(self, "file_system_id")

    @file_system_id.setter
    def file_system_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_system_id", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the AWS Key Management Service (AWS KMS) key used to encrypt the backup of the Amazon FSx file system's data at rest.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> Optional[pulumi.Input[str]]:
        """
        AWS account identifier that created the file system.
        """
        return pulumi.get(self, "owner_id")

    @owner_id.setter
    def owner_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the file system. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level. If you have set `copy_tags_to_backups` to true, and you specify one or more tags, no existing file system tags are copied from the file system to the backup.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the file system backup.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the volume to back up. Required if backing up a ONTAP Volume.
        """
        return pulumi.get(self, "volume_id")

    @volume_id.setter
    def volume_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_id", value)


class Backup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 file_system_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 volume_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a FSx Backup resource.

        ## Lustre Example

        ```python
        import pulumi
        import pulumi_aws as aws

        example_lustre_file_system = aws.fsx.LustreFileSystem("exampleLustreFileSystem",
            storage_capacity=1200,
            subnet_ids=[aws_subnet["example"]["id"]],
            deployment_type="PERSISTENT_1",
            per_unit_storage_throughput=50)
        example_backup = aws.fsx.Backup("exampleBackup", file_system_id=example_lustre_file_system.id)
        ```

        ## Windows Example

        ```python
        import pulumi
        import pulumi_aws as aws

        example_windows_file_system = aws.fsx.WindowsFileSystem("exampleWindowsFileSystem",
            active_directory_id=aws_directory_service_directory["eample"]["id"],
            skip_final_backup=True,
            storage_capacity=32,
            subnet_ids=[aws_subnet["example1"]["id"]],
            throughput_capacity=8)
        example_backup = aws.fsx.Backup("exampleBackup", file_system_id=example_windows_file_system.id)
        ```

        ## ONTAP Example

        ```python
        import pulumi
        import pulumi_aws as aws

        example_ontap_volume = aws.fsx.OntapVolume("exampleOntapVolume",
            junction_path="/example",
            size_in_megabytes=1024,
            storage_efficiency_enabled=True,
            storage_virtual_machine_id=aws_fsx_ontap_storage_virtual_machine["test"]["id"])
        example_backup = aws.fsx.Backup("exampleBackup", volume_id=example_ontap_volume.id)
        ```

        ## OpenZFS Example

        ```python
        import pulumi
        import pulumi_aws as aws

        example_open_zfs_file_system = aws.fsx.OpenZfsFileSystem("exampleOpenZfsFileSystem",
            storage_capacity=64,
            subnet_ids=[aws_subnet["example"]["id"]],
            deployment_type="SINGLE_AZ_1",
            throughput_capacity=64)
        example_backup = aws.fsx.Backup("exampleBackup", file_system_id=example_open_zfs_file_system.id)
        ```

        ## Import

        FSx Backups can be imported using the `id`, e.g.,

        ```sh
         $ pulumi import aws:fsx/backup:Backup example fs-543ab12b1ca672f33
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] file_system_id: The ID of the file system to back up. Required if backing up Lustre or Windows file systems.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the file system. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level. If you have set `copy_tags_to_backups` to true, and you specify one or more tags, no existing file system tags are copied from the file system to the backup.
        :param pulumi.Input[str] volume_id: The ID of the volume to back up. Required if backing up a ONTAP Volume.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[BackupArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a FSx Backup resource.

        ## Lustre Example

        ```python
        import pulumi
        import pulumi_aws as aws

        example_lustre_file_system = aws.fsx.LustreFileSystem("exampleLustreFileSystem",
            storage_capacity=1200,
            subnet_ids=[aws_subnet["example"]["id"]],
            deployment_type="PERSISTENT_1",
            per_unit_storage_throughput=50)
        example_backup = aws.fsx.Backup("exampleBackup", file_system_id=example_lustre_file_system.id)
        ```

        ## Windows Example

        ```python
        import pulumi
        import pulumi_aws as aws

        example_windows_file_system = aws.fsx.WindowsFileSystem("exampleWindowsFileSystem",
            active_directory_id=aws_directory_service_directory["eample"]["id"],
            skip_final_backup=True,
            storage_capacity=32,
            subnet_ids=[aws_subnet["example1"]["id"]],
            throughput_capacity=8)
        example_backup = aws.fsx.Backup("exampleBackup", file_system_id=example_windows_file_system.id)
        ```

        ## ONTAP Example

        ```python
        import pulumi
        import pulumi_aws as aws

        example_ontap_volume = aws.fsx.OntapVolume("exampleOntapVolume",
            junction_path="/example",
            size_in_megabytes=1024,
            storage_efficiency_enabled=True,
            storage_virtual_machine_id=aws_fsx_ontap_storage_virtual_machine["test"]["id"])
        example_backup = aws.fsx.Backup("exampleBackup", volume_id=example_ontap_volume.id)
        ```

        ## OpenZFS Example

        ```python
        import pulumi
        import pulumi_aws as aws

        example_open_zfs_file_system = aws.fsx.OpenZfsFileSystem("exampleOpenZfsFileSystem",
            storage_capacity=64,
            subnet_ids=[aws_subnet["example"]["id"]],
            deployment_type="SINGLE_AZ_1",
            throughput_capacity=64)
        example_backup = aws.fsx.Backup("exampleBackup", file_system_id=example_open_zfs_file_system.id)
        ```

        ## Import

        FSx Backups can be imported using the `id`, e.g.,

        ```sh
         $ pulumi import aws:fsx/backup:Backup example fs-543ab12b1ca672f33
        ```

        :param str resource_name: The name of the resource.
        :param BackupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BackupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 file_system_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 volume_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BackupArgs.__new__(BackupArgs)

            __props__.__dict__["file_system_id"] = file_system_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["volume_id"] = volume_id
            __props__.__dict__["arn"] = None
            __props__.__dict__["kms_key_id"] = None
            __props__.__dict__["owner_id"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["type"] = None
        super(Backup, __self__).__init__(
            'aws:fsx/backup:Backup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            file_system_id: Optional[pulumi.Input[str]] = None,
            kms_key_id: Optional[pulumi.Input[str]] = None,
            owner_id: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            type: Optional[pulumi.Input[str]] = None,
            volume_id: Optional[pulumi.Input[str]] = None) -> 'Backup':
        """
        Get an existing Backup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: Amazon Resource Name of the backup.
        :param pulumi.Input[str] file_system_id: The ID of the file system to back up. Required if backing up Lustre or Windows file systems.
        :param pulumi.Input[str] kms_key_id: The ID of the AWS Key Management Service (AWS KMS) key used to encrypt the backup of the Amazon FSx file system's data at rest.
        :param pulumi.Input[str] owner_id: AWS account identifier that created the file system.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the file system. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level. If you have set `copy_tags_to_backups` to true, and you specify one or more tags, no existing file system tags are copied from the file system to the backup.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[str] type: The type of the file system backup.
        :param pulumi.Input[str] volume_id: The ID of the volume to back up. Required if backing up a ONTAP Volume.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BackupState.__new__(_BackupState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["file_system_id"] = file_system_id
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["owner_id"] = owner_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["type"] = type
        __props__.__dict__["volume_id"] = volume_id
        return Backup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        Amazon Resource Name of the backup.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the file system to back up. Required if backing up Lustre or Windows file systems.
        """
        return pulumi.get(self, "file_system_id")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[str]:
        """
        The ID of the AWS Key Management Service (AWS KMS) key used to encrypt the backup of the Amazon FSx file system's data at rest.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> pulumi.Output[str]:
        """
        AWS account identifier that created the file system.
        """
        return pulumi.get(self, "owner_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags to assign to the file system. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level. If you have set `copy_tags_to_backups` to true, and you specify one or more tags, no existing file system tags are copied from the file system to the backup.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the file system backup.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the volume to back up. Required if backing up a ONTAP Volume.
        """
        return pulumi.get(self, "volume_id")

