# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'DataRepositoryAssociationS3Args',
    'DataRepositoryAssociationS3AutoExportPolicyArgs',
    'DataRepositoryAssociationS3AutoImportPolicyArgs',
    'OntapFileSystemDiskIopsConfigurationArgs',
    'OntapFileSystemEndpointArgs',
    'OntapFileSystemEndpointInterclusterArgs',
    'OntapFileSystemEndpointManagementArgs',
    'OntapStorageVirtualMachineActiveDirectoryConfigurationArgs',
    'OntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfigurationArgs',
    'OntapStorageVirtualMachineEndpointArgs',
    'OntapStorageVirtualMachineEndpointIscseArgs',
    'OntapStorageVirtualMachineEndpointManagementArgs',
    'OntapStorageVirtualMachineEndpointNfArgs',
    'OntapStorageVirtualMachineEndpointSmbArgs',
    'OntapVolumeTieringPolicyArgs',
    'OpenZfsFileSystemDiskIopsConfigurationArgs',
    'OpenZfsFileSystemRootVolumeConfigurationArgs',
    'OpenZfsFileSystemRootVolumeConfigurationNfsExportsArgs',
    'OpenZfsFileSystemRootVolumeConfigurationNfsExportsClientConfigurationArgs',
    'OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuotaArgs',
    'OpenZfsVolumeNfsExportsArgs',
    'OpenZfsVolumeNfsExportsClientConfigurationArgs',
    'OpenZfsVolumeOriginSnapshotArgs',
    'OpenZfsVolumeUserAndGroupQuotaArgs',
    'WindowsFileSystemAuditLogConfigurationArgs',
    'WindowsFileSystemSelfManagedActiveDirectoryArgs',
]

@pulumi.input_type
class DataRepositoryAssociationS3Args:
    def __init__(__self__, *,
                 auto_export_policy: Optional[pulumi.Input['DataRepositoryAssociationS3AutoExportPolicyArgs']] = None,
                 auto_import_policy: Optional[pulumi.Input['DataRepositoryAssociationS3AutoImportPolicyArgs']] = None):
        """
        :param pulumi.Input['DataRepositoryAssociationS3AutoExportPolicyArgs'] auto_export_policy: Specifies the type of updated objects that will be automatically exported from your file system to the linked S3 bucket. See the `events` configuration block.
        :param pulumi.Input['DataRepositoryAssociationS3AutoImportPolicyArgs'] auto_import_policy: Specifies the type of updated objects that will be automatically imported from the linked S3 bucket to your file system. See the `events` configuration block.
        """
        if auto_export_policy is not None:
            pulumi.set(__self__, "auto_export_policy", auto_export_policy)
        if auto_import_policy is not None:
            pulumi.set(__self__, "auto_import_policy", auto_import_policy)

    @property
    @pulumi.getter(name="autoExportPolicy")
    def auto_export_policy(self) -> Optional[pulumi.Input['DataRepositoryAssociationS3AutoExportPolicyArgs']]:
        """
        Specifies the type of updated objects that will be automatically exported from your file system to the linked S3 bucket. See the `events` configuration block.
        """
        return pulumi.get(self, "auto_export_policy")

    @auto_export_policy.setter
    def auto_export_policy(self, value: Optional[pulumi.Input['DataRepositoryAssociationS3AutoExportPolicyArgs']]):
        pulumi.set(self, "auto_export_policy", value)

    @property
    @pulumi.getter(name="autoImportPolicy")
    def auto_import_policy(self) -> Optional[pulumi.Input['DataRepositoryAssociationS3AutoImportPolicyArgs']]:
        """
        Specifies the type of updated objects that will be automatically imported from the linked S3 bucket to your file system. See the `events` configuration block.
        """
        return pulumi.get(self, "auto_import_policy")

    @auto_import_policy.setter
    def auto_import_policy(self, value: Optional[pulumi.Input['DataRepositoryAssociationS3AutoImportPolicyArgs']]):
        pulumi.set(self, "auto_import_policy", value)


@pulumi.input_type
class DataRepositoryAssociationS3AutoExportPolicyArgs:
    def __init__(__self__, *,
                 events: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] events: A list of file event types to automatically export to your linked S3 bucket or import from the linked S3 bucket. Valid values are `NEW`, `CHANGED`, `DELETED`. Max of 3.
        """
        if events is not None:
            pulumi.set(__self__, "events", events)

    @property
    @pulumi.getter
    def events(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of file event types to automatically export to your linked S3 bucket or import from the linked S3 bucket. Valid values are `NEW`, `CHANGED`, `DELETED`. Max of 3.
        """
        return pulumi.get(self, "events")

    @events.setter
    def events(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "events", value)


@pulumi.input_type
class DataRepositoryAssociationS3AutoImportPolicyArgs:
    def __init__(__self__, *,
                 events: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] events: A list of file event types to automatically export to your linked S3 bucket or import from the linked S3 bucket. Valid values are `NEW`, `CHANGED`, `DELETED`. Max of 3.
        """
        if events is not None:
            pulumi.set(__self__, "events", events)

    @property
    @pulumi.getter
    def events(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of file event types to automatically export to your linked S3 bucket or import from the linked S3 bucket. Valid values are `NEW`, `CHANGED`, `DELETED`. Max of 3.
        """
        return pulumi.get(self, "events")

    @events.setter
    def events(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "events", value)


@pulumi.input_type
class OntapFileSystemDiskIopsConfigurationArgs:
    def __init__(__self__, *,
                 iops: Optional[pulumi.Input[int]] = None,
                 mode: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] iops: - The total number of SSD IOPS provisioned for the file system.
        :param pulumi.Input[str] mode: - Specifies whether the number of IOPS for the file system is using the system. Valid values are `AUTOMATIC` and `USER_PROVISIONED`. Default value is `AUTOMATIC`.
        """
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[int]]:
        """
        - The total number of SSD IOPS provisioned for the file system.
        """
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "iops", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[str]]:
        """
        - Specifies whether the number of IOPS for the file system is using the system. Valid values are `AUTOMATIC` and `USER_PROVISIONED`. Default value is `AUTOMATIC`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mode", value)


@pulumi.input_type
class OntapFileSystemEndpointArgs:
    def __init__(__self__, *,
                 interclusters: Optional[pulumi.Input[Sequence[pulumi.Input['OntapFileSystemEndpointInterclusterArgs']]]] = None,
                 managements: Optional[pulumi.Input[Sequence[pulumi.Input['OntapFileSystemEndpointManagementArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['OntapFileSystemEndpointInterclusterArgs']]] interclusters: An endpoint for managing your file system by setting up NetApp SnapMirror with other ONTAP systems. See Endpoint.
        :param pulumi.Input[Sequence[pulumi.Input['OntapFileSystemEndpointManagementArgs']]] managements: An endpoint for managing your file system using the NetApp ONTAP CLI and NetApp ONTAP API. See Endpoint.
        """
        if interclusters is not None:
            pulumi.set(__self__, "interclusters", interclusters)
        if managements is not None:
            pulumi.set(__self__, "managements", managements)

    @property
    @pulumi.getter
    def interclusters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OntapFileSystemEndpointInterclusterArgs']]]]:
        """
        An endpoint for managing your file system by setting up NetApp SnapMirror with other ONTAP systems. See Endpoint.
        """
        return pulumi.get(self, "interclusters")

    @interclusters.setter
    def interclusters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OntapFileSystemEndpointInterclusterArgs']]]]):
        pulumi.set(self, "interclusters", value)

    @property
    @pulumi.getter
    def managements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OntapFileSystemEndpointManagementArgs']]]]:
        """
        An endpoint for managing your file system using the NetApp ONTAP CLI and NetApp ONTAP API. See Endpoint.
        """
        return pulumi.get(self, "managements")

    @managements.setter
    def managements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OntapFileSystemEndpointManagementArgs']]]]):
        pulumi.set(self, "managements", value)


@pulumi.input_type
class OntapFileSystemEndpointInterclusterArgs:
    def __init__(__self__, *,
                 dns_name: Optional[pulumi.Input[str]] = None,
                 ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] dns_name: The Domain Name Service (DNS) name for the file system. You can mount your file system using its DNS name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_addresses: IP addresses of the file system endpoint.
        """
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[pulumi.Input[str]]:
        """
        The Domain Name Service (DNS) name for the file system. You can mount your file system using its DNS name.
        """
        return pulumi.get(self, "dns_name")

    @dns_name.setter
    def dns_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_name", value)

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        IP addresses of the file system endpoint.
        """
        return pulumi.get(self, "ip_addresses")

    @ip_addresses.setter
    def ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ip_addresses", value)


@pulumi.input_type
class OntapFileSystemEndpointManagementArgs:
    def __init__(__self__, *,
                 dns_name: Optional[pulumi.Input[str]] = None,
                 ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] dns_name: The Domain Name Service (DNS) name for the file system. You can mount your file system using its DNS name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_addresses: IP addresses of the file system endpoint.
        """
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[pulumi.Input[str]]:
        """
        The Domain Name Service (DNS) name for the file system. You can mount your file system using its DNS name.
        """
        return pulumi.get(self, "dns_name")

    @dns_name.setter
    def dns_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_name", value)

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        IP addresses of the file system endpoint.
        """
        return pulumi.get(self, "ip_addresses")

    @ip_addresses.setter
    def ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ip_addresses", value)


@pulumi.input_type
class OntapStorageVirtualMachineActiveDirectoryConfigurationArgs:
    def __init__(__self__, *,
                 netbios_name: Optional[pulumi.Input[str]] = None,
                 self_managed_active_directory_configuration: Optional[pulumi.Input['OntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfigurationArgs']] = None):
        """
        :param pulumi.Input[str] netbios_name: The NetBIOS name of the Active Directory computer object that will be created for your SVM. This is often the same as the SVM name but can be different. It is limited to 15 characters because of standard NetBIOS naming limits.
        """
        if netbios_name is not None:
            pulumi.set(__self__, "netbios_name", netbios_name)
        if self_managed_active_directory_configuration is not None:
            pulumi.set(__self__, "self_managed_active_directory_configuration", self_managed_active_directory_configuration)

    @property
    @pulumi.getter(name="netbiosName")
    def netbios_name(self) -> Optional[pulumi.Input[str]]:
        """
        The NetBIOS name of the Active Directory computer object that will be created for your SVM. This is often the same as the SVM name but can be different. It is limited to 15 characters because of standard NetBIOS naming limits.
        """
        return pulumi.get(self, "netbios_name")

    @netbios_name.setter
    def netbios_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "netbios_name", value)

    @property
    @pulumi.getter(name="selfManagedActiveDirectoryConfiguration")
    def self_managed_active_directory_configuration(self) -> Optional[pulumi.Input['OntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfigurationArgs']]:
        return pulumi.get(self, "self_managed_active_directory_configuration")

    @self_managed_active_directory_configuration.setter
    def self_managed_active_directory_configuration(self, value: Optional[pulumi.Input['OntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfigurationArgs']]):
        pulumi.set(self, "self_managed_active_directory_configuration", value)


@pulumi.input_type
class OntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfigurationArgs:
    def __init__(__self__, *,
                 dns_ips: pulumi.Input[Sequence[pulumi.Input[str]]],
                 domain_name: pulumi.Input[str],
                 password: pulumi.Input[str],
                 username: pulumi.Input[str],
                 file_system_administrators_group: Optional[pulumi.Input[str]] = None,
                 organizational_unit_distinguidshed_name: Optional[pulumi.Input[str]] = None,
                 organizational_unit_distinguished_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_ips: A list of up to three IP addresses of DNS servers or domain controllers in the self-managed AD directory.
        :param pulumi.Input[str] domain_name: The fully qualified domain name of the self-managed AD directory. For example, `corp.example.com`.
        :param pulumi.Input[str] password: The password for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
        :param pulumi.Input[str] username: The user name for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
        :param pulumi.Input[str] file_system_administrators_group: The name of the domain group whose members are granted administrative privileges for the SVM. The group that you specify must already exist in your domain. Defaults to `Domain Admins`.
        :param pulumi.Input[str] organizational_unit_distinguished_name: The fully qualified distinguished name of the organizational unit within your self-managed AD directory that the Windows File Server instance will join. For example, `OU=FSx,DC=yourdomain,DC=corp,DC=com`. Only accepts OU as the direct parent of the SVM. If none is provided, the SVM is created in the default location of your self-managed AD directory. To learn more, see [RFC 2253](https://tools.ietf.org/html/rfc2253).
        """
        pulumi.set(__self__, "dns_ips", dns_ips)
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)
        if file_system_administrators_group is not None:
            pulumi.set(__self__, "file_system_administrators_group", file_system_administrators_group)
        if organizational_unit_distinguidshed_name is not None:
            warnings.warn("""use 'organizational_unit_distinguished_name' instead""", DeprecationWarning)
            pulumi.log.warn("""organizational_unit_distinguidshed_name is deprecated: use 'organizational_unit_distinguished_name' instead""")
        if organizational_unit_distinguidshed_name is not None:
            pulumi.set(__self__, "organizational_unit_distinguidshed_name", organizational_unit_distinguidshed_name)
        if organizational_unit_distinguished_name is not None:
            pulumi.set(__self__, "organizational_unit_distinguished_name", organizational_unit_distinguished_name)

    @property
    @pulumi.getter(name="dnsIps")
    def dns_ips(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of up to three IP addresses of DNS servers or domain controllers in the self-managed AD directory.
        """
        return pulumi.get(self, "dns_ips")

    @dns_ips.setter
    def dns_ips(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "dns_ips", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[str]:
        """
        The fully qualified domain name of the self-managed AD directory. For example, `corp.example.com`.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        The password for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        The user name for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="fileSystemAdministratorsGroup")
    def file_system_administrators_group(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the domain group whose members are granted administrative privileges for the SVM. The group that you specify must already exist in your domain. Defaults to `Domain Admins`.
        """
        return pulumi.get(self, "file_system_administrators_group")

    @file_system_administrators_group.setter
    def file_system_administrators_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_system_administrators_group", value)

    @property
    @pulumi.getter(name="organizationalUnitDistinguidshedName")
    def organizational_unit_distinguidshed_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "organizational_unit_distinguidshed_name")

    @organizational_unit_distinguidshed_name.setter
    def organizational_unit_distinguidshed_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organizational_unit_distinguidshed_name", value)

    @property
    @pulumi.getter(name="organizationalUnitDistinguishedName")
    def organizational_unit_distinguished_name(self) -> Optional[pulumi.Input[str]]:
        """
        The fully qualified distinguished name of the organizational unit within your self-managed AD directory that the Windows File Server instance will join. For example, `OU=FSx,DC=yourdomain,DC=corp,DC=com`. Only accepts OU as the direct parent of the SVM. If none is provided, the SVM is created in the default location of your self-managed AD directory. To learn more, see [RFC 2253](https://tools.ietf.org/html/rfc2253).
        """
        return pulumi.get(self, "organizational_unit_distinguished_name")

    @organizational_unit_distinguished_name.setter
    def organizational_unit_distinguished_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organizational_unit_distinguished_name", value)


@pulumi.input_type
class OntapStorageVirtualMachineEndpointArgs:
    def __init__(__self__, *,
                 iscses: Optional[pulumi.Input[Sequence[pulumi.Input['OntapStorageVirtualMachineEndpointIscseArgs']]]] = None,
                 managements: Optional[pulumi.Input[Sequence[pulumi.Input['OntapStorageVirtualMachineEndpointManagementArgs']]]] = None,
                 nfs: Optional[pulumi.Input[Sequence[pulumi.Input['OntapStorageVirtualMachineEndpointNfArgs']]]] = None,
                 smbs: Optional[pulumi.Input[Sequence[pulumi.Input['OntapStorageVirtualMachineEndpointSmbArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['OntapStorageVirtualMachineEndpointIscseArgs']]] iscses: An endpoint for accessing data on your storage virtual machine via iSCSI protocol. See Endpoint.
        :param pulumi.Input[Sequence[pulumi.Input['OntapStorageVirtualMachineEndpointManagementArgs']]] managements: An endpoint for managing your file system using the NetApp ONTAP CLI and NetApp ONTAP API. See Endpoint.
        :param pulumi.Input[Sequence[pulumi.Input['OntapStorageVirtualMachineEndpointNfArgs']]] nfs: An endpoint for accessing data on your storage virtual machine via NFS protocol. See Endpoint.
        :param pulumi.Input[Sequence[pulumi.Input['OntapStorageVirtualMachineEndpointSmbArgs']]] smbs: An endpoint for accessing data on your storage virtual machine via SMB protocol. This is only set if an active_directory_configuration has been set. See Endpoint.
        """
        if iscses is not None:
            pulumi.set(__self__, "iscses", iscses)
        if managements is not None:
            pulumi.set(__self__, "managements", managements)
        if nfs is not None:
            pulumi.set(__self__, "nfs", nfs)
        if smbs is not None:
            pulumi.set(__self__, "smbs", smbs)

    @property
    @pulumi.getter
    def iscses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OntapStorageVirtualMachineEndpointIscseArgs']]]]:
        """
        An endpoint for accessing data on your storage virtual machine via iSCSI protocol. See Endpoint.
        """
        return pulumi.get(self, "iscses")

    @iscses.setter
    def iscses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OntapStorageVirtualMachineEndpointIscseArgs']]]]):
        pulumi.set(self, "iscses", value)

    @property
    @pulumi.getter
    def managements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OntapStorageVirtualMachineEndpointManagementArgs']]]]:
        """
        An endpoint for managing your file system using the NetApp ONTAP CLI and NetApp ONTAP API. See Endpoint.
        """
        return pulumi.get(self, "managements")

    @managements.setter
    def managements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OntapStorageVirtualMachineEndpointManagementArgs']]]]):
        pulumi.set(self, "managements", value)

    @property
    @pulumi.getter
    def nfs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OntapStorageVirtualMachineEndpointNfArgs']]]]:
        """
        An endpoint for accessing data on your storage virtual machine via NFS protocol. See Endpoint.
        """
        return pulumi.get(self, "nfs")

    @nfs.setter
    def nfs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OntapStorageVirtualMachineEndpointNfArgs']]]]):
        pulumi.set(self, "nfs", value)

    @property
    @pulumi.getter
    def smbs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OntapStorageVirtualMachineEndpointSmbArgs']]]]:
        """
        An endpoint for accessing data on your storage virtual machine via SMB protocol. This is only set if an active_directory_configuration has been set. See Endpoint.
        """
        return pulumi.get(self, "smbs")

    @smbs.setter
    def smbs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OntapStorageVirtualMachineEndpointSmbArgs']]]]):
        pulumi.set(self, "smbs", value)


@pulumi.input_type
class OntapStorageVirtualMachineEndpointIscseArgs:
    def __init__(__self__, *,
                 dns_name: Optional[pulumi.Input[str]] = None,
                 ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] dns_name: The Domain Name Service (DNS) name for the storage virtual machine. You can mount your storage virtual machine using its DNS name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_addresses: IP addresses of the storage virtual machine endpoint.
        """
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[pulumi.Input[str]]:
        """
        The Domain Name Service (DNS) name for the storage virtual machine. You can mount your storage virtual machine using its DNS name.
        """
        return pulumi.get(self, "dns_name")

    @dns_name.setter
    def dns_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_name", value)

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        IP addresses of the storage virtual machine endpoint.
        """
        return pulumi.get(self, "ip_addresses")

    @ip_addresses.setter
    def ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ip_addresses", value)


@pulumi.input_type
class OntapStorageVirtualMachineEndpointManagementArgs:
    def __init__(__self__, *,
                 dns_name: Optional[pulumi.Input[str]] = None,
                 ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] dns_name: The Domain Name Service (DNS) name for the storage virtual machine. You can mount your storage virtual machine using its DNS name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_addresses: IP addresses of the storage virtual machine endpoint.
        """
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[pulumi.Input[str]]:
        """
        The Domain Name Service (DNS) name for the storage virtual machine. You can mount your storage virtual machine using its DNS name.
        """
        return pulumi.get(self, "dns_name")

    @dns_name.setter
    def dns_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_name", value)

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        IP addresses of the storage virtual machine endpoint.
        """
        return pulumi.get(self, "ip_addresses")

    @ip_addresses.setter
    def ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ip_addresses", value)


@pulumi.input_type
class OntapStorageVirtualMachineEndpointNfArgs:
    def __init__(__self__, *,
                 dns_name: Optional[pulumi.Input[str]] = None,
                 ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] dns_name: The Domain Name Service (DNS) name for the storage virtual machine. You can mount your storage virtual machine using its DNS name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_addresses: IP addresses of the storage virtual machine endpoint.
        """
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[pulumi.Input[str]]:
        """
        The Domain Name Service (DNS) name for the storage virtual machine. You can mount your storage virtual machine using its DNS name.
        """
        return pulumi.get(self, "dns_name")

    @dns_name.setter
    def dns_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_name", value)

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        IP addresses of the storage virtual machine endpoint.
        """
        return pulumi.get(self, "ip_addresses")

    @ip_addresses.setter
    def ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ip_addresses", value)


@pulumi.input_type
class OntapStorageVirtualMachineEndpointSmbArgs:
    def __init__(__self__, *,
                 dns_name: Optional[pulumi.Input[str]] = None,
                 ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] dns_name: The Domain Name Service (DNS) name for the storage virtual machine. You can mount your storage virtual machine using its DNS name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_addresses: IP addresses of the storage virtual machine endpoint.
        """
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[pulumi.Input[str]]:
        """
        The Domain Name Service (DNS) name for the storage virtual machine. You can mount your storage virtual machine using its DNS name.
        """
        return pulumi.get(self, "dns_name")

    @dns_name.setter
    def dns_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_name", value)

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        IP addresses of the storage virtual machine endpoint.
        """
        return pulumi.get(self, "ip_addresses")

    @ip_addresses.setter
    def ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ip_addresses", value)


@pulumi.input_type
class OntapVolumeTieringPolicyArgs:
    def __init__(__self__, *,
                 cooling_period: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: Specifies the tiering policy for the ONTAP volume for moving data to the capacity pool storage. Valid values are `SNAPSHOT_ONLY`, `AUTO`, `ALL`, `NONE`. Default value is `SNAPSHOT_ONLY`.
        """
        if cooling_period is not None:
            pulumi.set(__self__, "cooling_period", cooling_period)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="coolingPeriod")
    def cooling_period(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "cooling_period")

    @cooling_period.setter
    def cooling_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cooling_period", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the tiering policy for the ONTAP volume for moving data to the capacity pool storage. Valid values are `SNAPSHOT_ONLY`, `AUTO`, `ALL`, `NONE`. Default value is `SNAPSHOT_ONLY`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class OpenZfsFileSystemDiskIopsConfigurationArgs:
    def __init__(__self__, *,
                 iops: Optional[pulumi.Input[int]] = None,
                 mode: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] iops: - The total number of SSD IOPS provisioned for the file system.
        :param pulumi.Input[str] mode: - Specifies whether the number of IOPS for the file system is using the system. Valid values are `AUTOMATIC` and `USER_PROVISIONED`. Default value is `AUTOMATIC`.
        """
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[int]]:
        """
        - The total number of SSD IOPS provisioned for the file system.
        """
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "iops", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[str]]:
        """
        - Specifies whether the number of IOPS for the file system is using the system. Valid values are `AUTOMATIC` and `USER_PROVISIONED`. Default value is `AUTOMATIC`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mode", value)


@pulumi.input_type
class OpenZfsFileSystemRootVolumeConfigurationArgs:
    def __init__(__self__, *,
                 copy_tags_to_snapshots: Optional[pulumi.Input[bool]] = None,
                 data_compression_type: Optional[pulumi.Input[str]] = None,
                 nfs_exports: Optional[pulumi.Input['OpenZfsFileSystemRootVolumeConfigurationNfsExportsArgs']] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 user_and_group_quotas: Optional[pulumi.Input[Sequence[pulumi.Input['OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuotaArgs']]]] = None):
        """
        :param pulumi.Input[bool] copy_tags_to_snapshots: - A boolean flag indicating whether tags for the file system should be copied to snapshots. The default value is false.
        :param pulumi.Input[str] data_compression_type: - Method used to compress the data on the volume. Valid values are `NONE` or `ZSTD`. Child volumes that don't specify compression option will inherit from parent volume. This option on file system applies to the root volume.
        :param pulumi.Input['OpenZfsFileSystemRootVolumeConfigurationNfsExportsArgs'] nfs_exports: - NFS export configuration for the root volume. Exactly 1 item. See NFS Exports Below.
        :param pulumi.Input[bool] read_only: - specifies whether the volume is read-only. Default is false.
        :param pulumi.Input[Sequence[pulumi.Input['OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuotaArgs']]] user_and_group_quotas: - Specify how much storage users or groups can use on the volume. Maximum of 100 items. See User and Group Quotas Below.
        """
        if copy_tags_to_snapshots is not None:
            pulumi.set(__self__, "copy_tags_to_snapshots", copy_tags_to_snapshots)
        if data_compression_type is not None:
            pulumi.set(__self__, "data_compression_type", data_compression_type)
        if nfs_exports is not None:
            pulumi.set(__self__, "nfs_exports", nfs_exports)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if user_and_group_quotas is not None:
            pulumi.set(__self__, "user_and_group_quotas", user_and_group_quotas)

    @property
    @pulumi.getter(name="copyTagsToSnapshots")
    def copy_tags_to_snapshots(self) -> Optional[pulumi.Input[bool]]:
        """
        - A boolean flag indicating whether tags for the file system should be copied to snapshots. The default value is false.
        """
        return pulumi.get(self, "copy_tags_to_snapshots")

    @copy_tags_to_snapshots.setter
    def copy_tags_to_snapshots(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "copy_tags_to_snapshots", value)

    @property
    @pulumi.getter(name="dataCompressionType")
    def data_compression_type(self) -> Optional[pulumi.Input[str]]:
        """
        - Method used to compress the data on the volume. Valid values are `NONE` or `ZSTD`. Child volumes that don't specify compression option will inherit from parent volume. This option on file system applies to the root volume.
        """
        return pulumi.get(self, "data_compression_type")

    @data_compression_type.setter
    def data_compression_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_compression_type", value)

    @property
    @pulumi.getter(name="nfsExports")
    def nfs_exports(self) -> Optional[pulumi.Input['OpenZfsFileSystemRootVolumeConfigurationNfsExportsArgs']]:
        """
        - NFS export configuration for the root volume. Exactly 1 item. See NFS Exports Below.
        """
        return pulumi.get(self, "nfs_exports")

    @nfs_exports.setter
    def nfs_exports(self, value: Optional[pulumi.Input['OpenZfsFileSystemRootVolumeConfigurationNfsExportsArgs']]):
        pulumi.set(self, "nfs_exports", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        - specifies whether the volume is read-only. Default is false.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter(name="userAndGroupQuotas")
    def user_and_group_quotas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuotaArgs']]]]:
        """
        - Specify how much storage users or groups can use on the volume. Maximum of 100 items. See User and Group Quotas Below.
        """
        return pulumi.get(self, "user_and_group_quotas")

    @user_and_group_quotas.setter
    def user_and_group_quotas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuotaArgs']]]]):
        pulumi.set(self, "user_and_group_quotas", value)


@pulumi.input_type
class OpenZfsFileSystemRootVolumeConfigurationNfsExportsArgs:
    def __init__(__self__, *,
                 client_configurations: pulumi.Input[Sequence[pulumi.Input['OpenZfsFileSystemRootVolumeConfigurationNfsExportsClientConfigurationArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['OpenZfsFileSystemRootVolumeConfigurationNfsExportsClientConfigurationArgs']]] client_configurations: - A list of configuration objects that contain the client and options for mounting the OpenZFS file system. Maximum of 25 items. See Client Configurations Below.
        """
        pulumi.set(__self__, "client_configurations", client_configurations)

    @property
    @pulumi.getter(name="clientConfigurations")
    def client_configurations(self) -> pulumi.Input[Sequence[pulumi.Input['OpenZfsFileSystemRootVolumeConfigurationNfsExportsClientConfigurationArgs']]]:
        """
        - A list of configuration objects that contain the client and options for mounting the OpenZFS file system. Maximum of 25 items. See Client Configurations Below.
        """
        return pulumi.get(self, "client_configurations")

    @client_configurations.setter
    def client_configurations(self, value: pulumi.Input[Sequence[pulumi.Input['OpenZfsFileSystemRootVolumeConfigurationNfsExportsClientConfigurationArgs']]]):
        pulumi.set(self, "client_configurations", value)


@pulumi.input_type
class OpenZfsFileSystemRootVolumeConfigurationNfsExportsClientConfigurationArgs:
    def __init__(__self__, *,
                 clients: pulumi.Input[str],
                 options: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        :param pulumi.Input[str] clients: - A value that specifies who can mount the file system. You can provide a wildcard character (*), an IP address (0.0.0.0), or a CIDR address (192.0.2.0/24. By default, Amazon FSx uses the wildcard character when specifying the client.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] options: -  The options to use when mounting the file system. Maximum of 20 items. See the [Linix NFS exports man page](https://linux.die.net/man/5/exports) for more information. `crossmount` and `sync` are used by default.
        """
        pulumi.set(__self__, "clients", clients)
        pulumi.set(__self__, "options", options)

    @property
    @pulumi.getter
    def clients(self) -> pulumi.Input[str]:
        """
        - A value that specifies who can mount the file system. You can provide a wildcard character (*), an IP address (0.0.0.0), or a CIDR address (192.0.2.0/24. By default, Amazon FSx uses the wildcard character when specifying the client.
        """
        return pulumi.get(self, "clients")

    @clients.setter
    def clients(self, value: pulumi.Input[str]):
        pulumi.set(self, "clients", value)

    @property
    @pulumi.getter
    def options(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        -  The options to use when mounting the file system. Maximum of 20 items. See the [Linix NFS exports man page](https://linux.die.net/man/5/exports) for more information. `crossmount` and `sync` are used by default.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "options", value)


@pulumi.input_type
class OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuotaArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[int],
                 storage_capacity_quota_gib: pulumi.Input[int],
                 type: pulumi.Input[str]):
        """
        :param pulumi.Input[int] id: - The ID of the user or group. Valid values between `0` and `2147483647`
        :param pulumi.Input[int] storage_capacity_quota_gib: - The amount of storage that the user or group can use in gibibytes (GiB). Valid values between `0` and `2147483647`
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "storage_capacity_quota_gib", storage_capacity_quota_gib)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[int]:
        """
        - The ID of the user or group. Valid values between `0` and `2147483647`
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[int]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="storageCapacityQuotaGib")
    def storage_capacity_quota_gib(self) -> pulumi.Input[int]:
        """
        - The amount of storage that the user or group can use in gibibytes (GiB). Valid values between `0` and `2147483647`
        """
        return pulumi.get(self, "storage_capacity_quota_gib")

    @storage_capacity_quota_gib.setter
    def storage_capacity_quota_gib(self, value: pulumi.Input[int]):
        pulumi.set(self, "storage_capacity_quota_gib", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class OpenZfsVolumeNfsExportsArgs:
    def __init__(__self__, *,
                 client_configurations: pulumi.Input[Sequence[pulumi.Input['OpenZfsVolumeNfsExportsClientConfigurationArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['OpenZfsVolumeNfsExportsClientConfigurationArgs']]] client_configurations: - A list of configuration objects that contain the client and options for mounting the OpenZFS file system. Maximum of 25 items. See Client Configurations Below.
        """
        pulumi.set(__self__, "client_configurations", client_configurations)

    @property
    @pulumi.getter(name="clientConfigurations")
    def client_configurations(self) -> pulumi.Input[Sequence[pulumi.Input['OpenZfsVolumeNfsExportsClientConfigurationArgs']]]:
        """
        - A list of configuration objects that contain the client and options for mounting the OpenZFS file system. Maximum of 25 items. See Client Configurations Below.
        """
        return pulumi.get(self, "client_configurations")

    @client_configurations.setter
    def client_configurations(self, value: pulumi.Input[Sequence[pulumi.Input['OpenZfsVolumeNfsExportsClientConfigurationArgs']]]):
        pulumi.set(self, "client_configurations", value)


@pulumi.input_type
class OpenZfsVolumeNfsExportsClientConfigurationArgs:
    def __init__(__self__, *,
                 clients: pulumi.Input[str],
                 options: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        :param pulumi.Input[str] clients: - A value that specifies who can mount the file system. You can provide a wildcard character (*), an IP address (0.0.0.0), or a CIDR address (192.0.2.0/24. By default, Amazon FSx uses the wildcard character when specifying the client.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] options: -  The options to use when mounting the file system. Maximum of 20 items. See the [Linix NFS exports man page](https://linux.die.net/man/5/exports) for more information. `crossmount` and `sync` are used by default.
        """
        pulumi.set(__self__, "clients", clients)
        pulumi.set(__self__, "options", options)

    @property
    @pulumi.getter
    def clients(self) -> pulumi.Input[str]:
        """
        - A value that specifies who can mount the file system. You can provide a wildcard character (*), an IP address (0.0.0.0), or a CIDR address (192.0.2.0/24. By default, Amazon FSx uses the wildcard character when specifying the client.
        """
        return pulumi.get(self, "clients")

    @clients.setter
    def clients(self, value: pulumi.Input[str]):
        pulumi.set(self, "clients", value)

    @property
    @pulumi.getter
    def options(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        -  The options to use when mounting the file system. Maximum of 20 items. See the [Linix NFS exports man page](https://linux.die.net/man/5/exports) for more information. `crossmount` and `sync` are used by default.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "options", value)


@pulumi.input_type
class OpenZfsVolumeOriginSnapshotArgs:
    def __init__(__self__, *,
                 copy_strategy: pulumi.Input[str],
                 snapshot_arn: pulumi.Input[str]):
        pulumi.set(__self__, "copy_strategy", copy_strategy)
        pulumi.set(__self__, "snapshot_arn", snapshot_arn)

    @property
    @pulumi.getter(name="copyStrategy")
    def copy_strategy(self) -> pulumi.Input[str]:
        return pulumi.get(self, "copy_strategy")

    @copy_strategy.setter
    def copy_strategy(self, value: pulumi.Input[str]):
        pulumi.set(self, "copy_strategy", value)

    @property
    @pulumi.getter(name="snapshotArn")
    def snapshot_arn(self) -> pulumi.Input[str]:
        return pulumi.get(self, "snapshot_arn")

    @snapshot_arn.setter
    def snapshot_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "snapshot_arn", value)


@pulumi.input_type
class OpenZfsVolumeUserAndGroupQuotaArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[int],
                 storage_capacity_quota_gib: pulumi.Input[int],
                 type: pulumi.Input[str]):
        """
        :param pulumi.Input[int] id: - The ID of the user or group. Valid values between `0` and `2147483647`
        :param pulumi.Input[int] storage_capacity_quota_gib: - The amount of storage that the user or group can use in gibibytes (GiB). Valid values between `0` and `2147483647`
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "storage_capacity_quota_gib", storage_capacity_quota_gib)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[int]:
        """
        - The ID of the user or group. Valid values between `0` and `2147483647`
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[int]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="storageCapacityQuotaGib")
    def storage_capacity_quota_gib(self) -> pulumi.Input[int]:
        """
        - The amount of storage that the user or group can use in gibibytes (GiB). Valid values between `0` and `2147483647`
        """
        return pulumi.get(self, "storage_capacity_quota_gib")

    @storage_capacity_quota_gib.setter
    def storage_capacity_quota_gib(self, value: pulumi.Input[int]):
        pulumi.set(self, "storage_capacity_quota_gib", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class WindowsFileSystemAuditLogConfigurationArgs:
    def __init__(__self__, *,
                 audit_log_destination: Optional[pulumi.Input[str]] = None,
                 file_access_audit_log_level: Optional[pulumi.Input[str]] = None,
                 file_share_access_audit_log_level: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] audit_log_destination: The Amazon Resource Name (ARN) for the destination of the audit logs. The destination can be any Amazon CloudWatch Logs log group ARN or Amazon Kinesis Data Firehose delivery stream ARN. Can be specified when `file_access_audit_log_level` and `file_share_access_audit_log_level` are not set to `DISABLED`. The name of the Amazon CloudWatch Logs log group must begin with the `/aws/fsx` prefix. The name of the Amazon Kinesis Data Firehouse delivery stream must begin with the `aws-fsx` prefix. If you do not provide a destination in `audit_log_destionation`, Amazon FSx will create and use a log stream in the CloudWatch Logs /aws/fsx/windows log group.
        :param pulumi.Input[str] file_access_audit_log_level: Sets which attempt type is logged by Amazon FSx for file and folder accesses. Valid values are `SUCCESS_ONLY`, `FAILURE_ONLY`, `SUCCESS_AND_FAILURE`, and `DISABLED`. Default value is `DISABLED`.
        :param pulumi.Input[str] file_share_access_audit_log_level: Sets which attempt type is logged by Amazon FSx for file share accesses. Valid values are `SUCCESS_ONLY`, `FAILURE_ONLY`, `SUCCESS_AND_FAILURE`, and `DISABLED`. Default value is `DISABLED`.
        """
        if audit_log_destination is not None:
            pulumi.set(__self__, "audit_log_destination", audit_log_destination)
        if file_access_audit_log_level is not None:
            pulumi.set(__self__, "file_access_audit_log_level", file_access_audit_log_level)
        if file_share_access_audit_log_level is not None:
            pulumi.set(__self__, "file_share_access_audit_log_level", file_share_access_audit_log_level)

    @property
    @pulumi.getter(name="auditLogDestination")
    def audit_log_destination(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) for the destination of the audit logs. The destination can be any Amazon CloudWatch Logs log group ARN or Amazon Kinesis Data Firehose delivery stream ARN. Can be specified when `file_access_audit_log_level` and `file_share_access_audit_log_level` are not set to `DISABLED`. The name of the Amazon CloudWatch Logs log group must begin with the `/aws/fsx` prefix. The name of the Amazon Kinesis Data Firehouse delivery stream must begin with the `aws-fsx` prefix. If you do not provide a destination in `audit_log_destionation`, Amazon FSx will create and use a log stream in the CloudWatch Logs /aws/fsx/windows log group.
        """
        return pulumi.get(self, "audit_log_destination")

    @audit_log_destination.setter
    def audit_log_destination(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "audit_log_destination", value)

    @property
    @pulumi.getter(name="fileAccessAuditLogLevel")
    def file_access_audit_log_level(self) -> Optional[pulumi.Input[str]]:
        """
        Sets which attempt type is logged by Amazon FSx for file and folder accesses. Valid values are `SUCCESS_ONLY`, `FAILURE_ONLY`, `SUCCESS_AND_FAILURE`, and `DISABLED`. Default value is `DISABLED`.
        """
        return pulumi.get(self, "file_access_audit_log_level")

    @file_access_audit_log_level.setter
    def file_access_audit_log_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_access_audit_log_level", value)

    @property
    @pulumi.getter(name="fileShareAccessAuditLogLevel")
    def file_share_access_audit_log_level(self) -> Optional[pulumi.Input[str]]:
        """
        Sets which attempt type is logged by Amazon FSx for file share accesses. Valid values are `SUCCESS_ONLY`, `FAILURE_ONLY`, `SUCCESS_AND_FAILURE`, and `DISABLED`. Default value is `DISABLED`.
        """
        return pulumi.get(self, "file_share_access_audit_log_level")

    @file_share_access_audit_log_level.setter
    def file_share_access_audit_log_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_share_access_audit_log_level", value)


@pulumi.input_type
class WindowsFileSystemSelfManagedActiveDirectoryArgs:
    def __init__(__self__, *,
                 dns_ips: pulumi.Input[Sequence[pulumi.Input[str]]],
                 domain_name: pulumi.Input[str],
                 password: pulumi.Input[str],
                 username: pulumi.Input[str],
                 file_system_administrators_group: Optional[pulumi.Input[str]] = None,
                 organizational_unit_distinguished_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_ips: A list of up to two IP addresses of DNS servers or domain controllers in the self-managed AD directory. The IP addresses need to be either in the same VPC CIDR range as the file system or in the private IP version 4 (IPv4) address ranges as specified in [RFC 1918](https://tools.ietf.org/html/rfc1918).
        :param pulumi.Input[str] domain_name: The fully qualified domain name of the self-managed AD directory. For example, `corp.example.com`.
        :param pulumi.Input[str] password: The password for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
        :param pulumi.Input[str] username: The user name for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
        :param pulumi.Input[str] file_system_administrators_group: The name of the domain group whose members are granted administrative privileges for the file system. Administrative privileges include taking ownership of files and folders, and setting audit controls (audit ACLs) on files and folders. The group that you specify must already exist in your domain. Defaults to `Domain Admins`.
        :param pulumi.Input[str] organizational_unit_distinguished_name: The fully qualified distinguished name of the organizational unit within your self-managed AD directory that the Windows File Server instance will join. For example, `OU=FSx,DC=yourdomain,DC=corp,DC=com`. Only accepts OU as the direct parent of the file system. If none is provided, the FSx file system is created in the default location of your self-managed AD directory. To learn more, see [RFC 2253](https://tools.ietf.org/html/rfc2253).
        """
        pulumi.set(__self__, "dns_ips", dns_ips)
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)
        if file_system_administrators_group is not None:
            pulumi.set(__self__, "file_system_administrators_group", file_system_administrators_group)
        if organizational_unit_distinguished_name is not None:
            pulumi.set(__self__, "organizational_unit_distinguished_name", organizational_unit_distinguished_name)

    @property
    @pulumi.getter(name="dnsIps")
    def dns_ips(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of up to two IP addresses of DNS servers or domain controllers in the self-managed AD directory. The IP addresses need to be either in the same VPC CIDR range as the file system or in the private IP version 4 (IPv4) address ranges as specified in [RFC 1918](https://tools.ietf.org/html/rfc1918).
        """
        return pulumi.get(self, "dns_ips")

    @dns_ips.setter
    def dns_ips(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "dns_ips", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[str]:
        """
        The fully qualified domain name of the self-managed AD directory. For example, `corp.example.com`.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        The password for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        The user name for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="fileSystemAdministratorsGroup")
    def file_system_administrators_group(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the domain group whose members are granted administrative privileges for the file system. Administrative privileges include taking ownership of files and folders, and setting audit controls (audit ACLs) on files and folders. The group that you specify must already exist in your domain. Defaults to `Domain Admins`.
        """
        return pulumi.get(self, "file_system_administrators_group")

    @file_system_administrators_group.setter
    def file_system_administrators_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_system_administrators_group", value)

    @property
    @pulumi.getter(name="organizationalUnitDistinguishedName")
    def organizational_unit_distinguished_name(self) -> Optional[pulumi.Input[str]]:
        """
        The fully qualified distinguished name of the organizational unit within your self-managed AD directory that the Windows File Server instance will join. For example, `OU=FSx,DC=yourdomain,DC=corp,DC=com`. Only accepts OU as the direct parent of the file system. If none is provided, the FSx file system is created in the default location of your self-managed AD directory. To learn more, see [RFC 2253](https://tools.ietf.org/html/rfc2253).
        """
        return pulumi.get(self, "organizational_unit_distinguished_name")

    @organizational_unit_distinguished_name.setter
    def organizational_unit_distinguished_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organizational_unit_distinguished_name", value)


