# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PolicyArgs', 'Policy']

@pulumi.input_type
class PolicyArgs:
    def __init__(__self__, *,
                 exclude_resource_tags: pulumi.Input[bool],
                 security_service_policy_data: pulumi.Input['PolicySecurityServicePolicyDataArgs'],
                 delete_all_policy_resources: Optional[pulumi.Input[bool]] = None,
                 exclude_map: Optional[pulumi.Input['PolicyExcludeMapArgs']] = None,
                 include_map: Optional[pulumi.Input['PolicyIncludeMapArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 remediation_enabled: Optional[pulumi.Input[bool]] = None,
                 resource_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 resource_type: Optional[pulumi.Input[str]] = None,
                 resource_type_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Policy resource.
        :param pulumi.Input[bool] exclude_resource_tags: A boolean value, if true the tags that are specified in the `resource_tags` are not protected by this policy. If set to false and resource_tags are populated, resources that contain tags will be protected by this policy.
        :param pulumi.Input['PolicySecurityServicePolicyDataArgs'] security_service_policy_data: The objects to include in Security Service Policy Data. Documented below.
        :param pulumi.Input[bool] delete_all_policy_resources: If true, the request will also perform a clean-up process. Defaults to `true`. More information can be found here [AWS Firewall Manager delete policy](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_DeletePolicy.html)
        :param pulumi.Input['PolicyExcludeMapArgs'] exclude_map: A map of lists of accounts and OU's to exclude from the policy.
        :param pulumi.Input['PolicyIncludeMapArgs'] include_map: A map of lists of accounts and OU's to include in the policy.
        :param pulumi.Input[str] name: The friendly name of the AWS Firewall Manager Policy.
        :param pulumi.Input[bool] remediation_enabled: A boolean value, indicates if the policy should automatically applied to resources that already exist in the account.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] resource_tags: A map of resource tags, that if present will filter protections on resources based on the exclude_resource_tags.
        :param pulumi.Input[str] resource_type: A resource type to protect. Conflicts with `resource_type_list`. See the [FMS API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html#fms-Type-Policy-ResourceType) for more information about supported values.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resource_type_lists: A list of resource types to protect. Conflicts with `resource_type`. See the [FMS API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html#fms-Type-Policy-ResourceType) for more information about supported values.
        """
        pulumi.set(__self__, "exclude_resource_tags", exclude_resource_tags)
        pulumi.set(__self__, "security_service_policy_data", security_service_policy_data)
        if delete_all_policy_resources is not None:
            pulumi.set(__self__, "delete_all_policy_resources", delete_all_policy_resources)
        if exclude_map is not None:
            pulumi.set(__self__, "exclude_map", exclude_map)
        if include_map is not None:
            pulumi.set(__self__, "include_map", include_map)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if remediation_enabled is not None:
            pulumi.set(__self__, "remediation_enabled", remediation_enabled)
        if resource_tags is not None:
            pulumi.set(__self__, "resource_tags", resource_tags)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if resource_type_lists is not None:
            pulumi.set(__self__, "resource_type_lists", resource_type_lists)

    @property
    @pulumi.getter(name="excludeResourceTags")
    def exclude_resource_tags(self) -> pulumi.Input[bool]:
        """
        A boolean value, if true the tags that are specified in the `resource_tags` are not protected by this policy. If set to false and resource_tags are populated, resources that contain tags will be protected by this policy.
        """
        return pulumi.get(self, "exclude_resource_tags")

    @exclude_resource_tags.setter
    def exclude_resource_tags(self, value: pulumi.Input[bool]):
        pulumi.set(self, "exclude_resource_tags", value)

    @property
    @pulumi.getter(name="securityServicePolicyData")
    def security_service_policy_data(self) -> pulumi.Input['PolicySecurityServicePolicyDataArgs']:
        """
        The objects to include in Security Service Policy Data. Documented below.
        """
        return pulumi.get(self, "security_service_policy_data")

    @security_service_policy_data.setter
    def security_service_policy_data(self, value: pulumi.Input['PolicySecurityServicePolicyDataArgs']):
        pulumi.set(self, "security_service_policy_data", value)

    @property
    @pulumi.getter(name="deleteAllPolicyResources")
    def delete_all_policy_resources(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the request will also perform a clean-up process. Defaults to `true`. More information can be found here [AWS Firewall Manager delete policy](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_DeletePolicy.html)
        """
        return pulumi.get(self, "delete_all_policy_resources")

    @delete_all_policy_resources.setter
    def delete_all_policy_resources(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_all_policy_resources", value)

    @property
    @pulumi.getter(name="excludeMap")
    def exclude_map(self) -> Optional[pulumi.Input['PolicyExcludeMapArgs']]:
        """
        A map of lists of accounts and OU's to exclude from the policy.
        """
        return pulumi.get(self, "exclude_map")

    @exclude_map.setter
    def exclude_map(self, value: Optional[pulumi.Input['PolicyExcludeMapArgs']]):
        pulumi.set(self, "exclude_map", value)

    @property
    @pulumi.getter(name="includeMap")
    def include_map(self) -> Optional[pulumi.Input['PolicyIncludeMapArgs']]:
        """
        A map of lists of accounts and OU's to include in the policy.
        """
        return pulumi.get(self, "include_map")

    @include_map.setter
    def include_map(self, value: Optional[pulumi.Input['PolicyIncludeMapArgs']]):
        pulumi.set(self, "include_map", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The friendly name of the AWS Firewall Manager Policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="remediationEnabled")
    def remediation_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean value, indicates if the policy should automatically applied to resources that already exist in the account.
        """
        return pulumi.get(self, "remediation_enabled")

    @remediation_enabled.setter
    def remediation_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "remediation_enabled", value)

    @property
    @pulumi.getter(name="resourceTags")
    def resource_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of resource tags, that if present will filter protections on resources based on the exclude_resource_tags.
        """
        return pulumi.get(self, "resource_tags")

    @resource_tags.setter
    def resource_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "resource_tags", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[str]]:
        """
        A resource type to protect. Conflicts with `resource_type_list`. See the [FMS API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html#fms-Type-Policy-ResourceType) for more information about supported values.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="resourceTypeLists")
    def resource_type_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of resource types to protect. Conflicts with `resource_type`. See the [FMS API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html#fms-Type-Policy-ResourceType) for more information about supported values.
        """
        return pulumi.get(self, "resource_type_lists")

    @resource_type_lists.setter
    def resource_type_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "resource_type_lists", value)


@pulumi.input_type
class _PolicyState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 delete_all_policy_resources: Optional[pulumi.Input[bool]] = None,
                 exclude_map: Optional[pulumi.Input['PolicyExcludeMapArgs']] = None,
                 exclude_resource_tags: Optional[pulumi.Input[bool]] = None,
                 include_map: Optional[pulumi.Input['PolicyIncludeMapArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 policy_update_token: Optional[pulumi.Input[str]] = None,
                 remediation_enabled: Optional[pulumi.Input[bool]] = None,
                 resource_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 resource_type: Optional[pulumi.Input[str]] = None,
                 resource_type_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 security_service_policy_data: Optional[pulumi.Input['PolicySecurityServicePolicyDataArgs']] = None):
        """
        Input properties used for looking up and filtering Policy resources.
        :param pulumi.Input[bool] delete_all_policy_resources: If true, the request will also perform a clean-up process. Defaults to `true`. More information can be found here [AWS Firewall Manager delete policy](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_DeletePolicy.html)
        :param pulumi.Input['PolicyExcludeMapArgs'] exclude_map: A map of lists of accounts and OU's to exclude from the policy.
        :param pulumi.Input[bool] exclude_resource_tags: A boolean value, if true the tags that are specified in the `resource_tags` are not protected by this policy. If set to false and resource_tags are populated, resources that contain tags will be protected by this policy.
        :param pulumi.Input['PolicyIncludeMapArgs'] include_map: A map of lists of accounts and OU's to include in the policy.
        :param pulumi.Input[str] name: The friendly name of the AWS Firewall Manager Policy.
        :param pulumi.Input[str] policy_update_token: A unique identifier for each update to the policy.
        :param pulumi.Input[bool] remediation_enabled: A boolean value, indicates if the policy should automatically applied to resources that already exist in the account.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] resource_tags: A map of resource tags, that if present will filter protections on resources based on the exclude_resource_tags.
        :param pulumi.Input[str] resource_type: A resource type to protect. Conflicts with `resource_type_list`. See the [FMS API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html#fms-Type-Policy-ResourceType) for more information about supported values.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resource_type_lists: A list of resource types to protect. Conflicts with `resource_type`. See the [FMS API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html#fms-Type-Policy-ResourceType) for more information about supported values.
        :param pulumi.Input['PolicySecurityServicePolicyDataArgs'] security_service_policy_data: The objects to include in Security Service Policy Data. Documented below.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if delete_all_policy_resources is not None:
            pulumi.set(__self__, "delete_all_policy_resources", delete_all_policy_resources)
        if exclude_map is not None:
            pulumi.set(__self__, "exclude_map", exclude_map)
        if exclude_resource_tags is not None:
            pulumi.set(__self__, "exclude_resource_tags", exclude_resource_tags)
        if include_map is not None:
            pulumi.set(__self__, "include_map", include_map)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy_update_token is not None:
            pulumi.set(__self__, "policy_update_token", policy_update_token)
        if remediation_enabled is not None:
            pulumi.set(__self__, "remediation_enabled", remediation_enabled)
        if resource_tags is not None:
            pulumi.set(__self__, "resource_tags", resource_tags)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if resource_type_lists is not None:
            pulumi.set(__self__, "resource_type_lists", resource_type_lists)
        if security_service_policy_data is not None:
            pulumi.set(__self__, "security_service_policy_data", security_service_policy_data)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="deleteAllPolicyResources")
    def delete_all_policy_resources(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the request will also perform a clean-up process. Defaults to `true`. More information can be found here [AWS Firewall Manager delete policy](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_DeletePolicy.html)
        """
        return pulumi.get(self, "delete_all_policy_resources")

    @delete_all_policy_resources.setter
    def delete_all_policy_resources(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_all_policy_resources", value)

    @property
    @pulumi.getter(name="excludeMap")
    def exclude_map(self) -> Optional[pulumi.Input['PolicyExcludeMapArgs']]:
        """
        A map of lists of accounts and OU's to exclude from the policy.
        """
        return pulumi.get(self, "exclude_map")

    @exclude_map.setter
    def exclude_map(self, value: Optional[pulumi.Input['PolicyExcludeMapArgs']]):
        pulumi.set(self, "exclude_map", value)

    @property
    @pulumi.getter(name="excludeResourceTags")
    def exclude_resource_tags(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean value, if true the tags that are specified in the `resource_tags` are not protected by this policy. If set to false and resource_tags are populated, resources that contain tags will be protected by this policy.
        """
        return pulumi.get(self, "exclude_resource_tags")

    @exclude_resource_tags.setter
    def exclude_resource_tags(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "exclude_resource_tags", value)

    @property
    @pulumi.getter(name="includeMap")
    def include_map(self) -> Optional[pulumi.Input['PolicyIncludeMapArgs']]:
        """
        A map of lists of accounts and OU's to include in the policy.
        """
        return pulumi.get(self, "include_map")

    @include_map.setter
    def include_map(self, value: Optional[pulumi.Input['PolicyIncludeMapArgs']]):
        pulumi.set(self, "include_map", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The friendly name of the AWS Firewall Manager Policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="policyUpdateToken")
    def policy_update_token(self) -> Optional[pulumi.Input[str]]:
        """
        A unique identifier for each update to the policy.
        """
        return pulumi.get(self, "policy_update_token")

    @policy_update_token.setter
    def policy_update_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_update_token", value)

    @property
    @pulumi.getter(name="remediationEnabled")
    def remediation_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean value, indicates if the policy should automatically applied to resources that already exist in the account.
        """
        return pulumi.get(self, "remediation_enabled")

    @remediation_enabled.setter
    def remediation_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "remediation_enabled", value)

    @property
    @pulumi.getter(name="resourceTags")
    def resource_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of resource tags, that if present will filter protections on resources based on the exclude_resource_tags.
        """
        return pulumi.get(self, "resource_tags")

    @resource_tags.setter
    def resource_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "resource_tags", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[str]]:
        """
        A resource type to protect. Conflicts with `resource_type_list`. See the [FMS API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html#fms-Type-Policy-ResourceType) for more information about supported values.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="resourceTypeLists")
    def resource_type_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of resource types to protect. Conflicts with `resource_type`. See the [FMS API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html#fms-Type-Policy-ResourceType) for more information about supported values.
        """
        return pulumi.get(self, "resource_type_lists")

    @resource_type_lists.setter
    def resource_type_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "resource_type_lists", value)

    @property
    @pulumi.getter(name="securityServicePolicyData")
    def security_service_policy_data(self) -> Optional[pulumi.Input['PolicySecurityServicePolicyDataArgs']]:
        """
        The objects to include in Security Service Policy Data. Documented below.
        """
        return pulumi.get(self, "security_service_policy_data")

    @security_service_policy_data.setter
    def security_service_policy_data(self, value: Optional[pulumi.Input['PolicySecurityServicePolicyDataArgs']]):
        pulumi.set(self, "security_service_policy_data", value)


class Policy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delete_all_policy_resources: Optional[pulumi.Input[bool]] = None,
                 exclude_map: Optional[pulumi.Input[pulumi.InputType['PolicyExcludeMapArgs']]] = None,
                 exclude_resource_tags: Optional[pulumi.Input[bool]] = None,
                 include_map: Optional[pulumi.Input[pulumi.InputType['PolicyIncludeMapArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 remediation_enabled: Optional[pulumi.Input[bool]] = None,
                 resource_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 resource_type: Optional[pulumi.Input[str]] = None,
                 resource_type_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 security_service_policy_data: Optional[pulumi.Input[pulumi.InputType['PolicySecurityServicePolicyDataArgs']]] = None,
                 __props__=None):
        """
        Provides a resource to create an AWS Firewall Manager policy. You need to be using AWS organizations and have enabled the Firewall Manager administrator account.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example_rule_group = aws.wafregional.RuleGroup("exampleRuleGroup", metric_name="WAFRuleGroupExample")
        example_policy = aws.fms.Policy("examplePolicy",
            exclude_resource_tags=False,
            remediation_enabled=False,
            resource_type_lists=["AWS::ElasticLoadBalancingV2::LoadBalancer"],
            security_service_policy_data=aws.fms.PolicySecurityServicePolicyDataArgs(
                type="WAF",
                managed_service_data=example_rule_group.id.apply(lambda id: json.dumps({
                    "type": "WAF",
                    "ruleGroups": [{
                        "id": id,
                        "overrideAction": {
                            "type": "COUNT",
                        },
                    }],
                    "defaultAction": {
                        "type": "BLOCK",
                    },
                    "overrideCustomerWebACLAssociation": False,
                })),
            ))
        ```

        ## Import

        Firewall Manager policies can be imported using the policy ID, e.g.,

        ```sh
         $ pulumi import aws:fms/policy:Policy example 5be49585-a7e3-4c49-dde1-a179fe4a619a
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] delete_all_policy_resources: If true, the request will also perform a clean-up process. Defaults to `true`. More information can be found here [AWS Firewall Manager delete policy](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_DeletePolicy.html)
        :param pulumi.Input[pulumi.InputType['PolicyExcludeMapArgs']] exclude_map: A map of lists of accounts and OU's to exclude from the policy.
        :param pulumi.Input[bool] exclude_resource_tags: A boolean value, if true the tags that are specified in the `resource_tags` are not protected by this policy. If set to false and resource_tags are populated, resources that contain tags will be protected by this policy.
        :param pulumi.Input[pulumi.InputType['PolicyIncludeMapArgs']] include_map: A map of lists of accounts and OU's to include in the policy.
        :param pulumi.Input[str] name: The friendly name of the AWS Firewall Manager Policy.
        :param pulumi.Input[bool] remediation_enabled: A boolean value, indicates if the policy should automatically applied to resources that already exist in the account.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] resource_tags: A map of resource tags, that if present will filter protections on resources based on the exclude_resource_tags.
        :param pulumi.Input[str] resource_type: A resource type to protect. Conflicts with `resource_type_list`. See the [FMS API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html#fms-Type-Policy-ResourceType) for more information about supported values.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resource_type_lists: A list of resource types to protect. Conflicts with `resource_type`. See the [FMS API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html#fms-Type-Policy-ResourceType) for more information about supported values.
        :param pulumi.Input[pulumi.InputType['PolicySecurityServicePolicyDataArgs']] security_service_policy_data: The objects to include in Security Service Policy Data. Documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to create an AWS Firewall Manager policy. You need to be using AWS organizations and have enabled the Firewall Manager administrator account.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example_rule_group = aws.wafregional.RuleGroup("exampleRuleGroup", metric_name="WAFRuleGroupExample")
        example_policy = aws.fms.Policy("examplePolicy",
            exclude_resource_tags=False,
            remediation_enabled=False,
            resource_type_lists=["AWS::ElasticLoadBalancingV2::LoadBalancer"],
            security_service_policy_data=aws.fms.PolicySecurityServicePolicyDataArgs(
                type="WAF",
                managed_service_data=example_rule_group.id.apply(lambda id: json.dumps({
                    "type": "WAF",
                    "ruleGroups": [{
                        "id": id,
                        "overrideAction": {
                            "type": "COUNT",
                        },
                    }],
                    "defaultAction": {
                        "type": "BLOCK",
                    },
                    "overrideCustomerWebACLAssociation": False,
                })),
            ))
        ```

        ## Import

        Firewall Manager policies can be imported using the policy ID, e.g.,

        ```sh
         $ pulumi import aws:fms/policy:Policy example 5be49585-a7e3-4c49-dde1-a179fe4a619a
        ```

        :param str resource_name: The name of the resource.
        :param PolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delete_all_policy_resources: Optional[pulumi.Input[bool]] = None,
                 exclude_map: Optional[pulumi.Input[pulumi.InputType['PolicyExcludeMapArgs']]] = None,
                 exclude_resource_tags: Optional[pulumi.Input[bool]] = None,
                 include_map: Optional[pulumi.Input[pulumi.InputType['PolicyIncludeMapArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 remediation_enabled: Optional[pulumi.Input[bool]] = None,
                 resource_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 resource_type: Optional[pulumi.Input[str]] = None,
                 resource_type_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 security_service_policy_data: Optional[pulumi.Input[pulumi.InputType['PolicySecurityServicePolicyDataArgs']]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PolicyArgs.__new__(PolicyArgs)

            __props__.__dict__["delete_all_policy_resources"] = delete_all_policy_resources
            __props__.__dict__["exclude_map"] = exclude_map
            if exclude_resource_tags is None and not opts.urn:
                raise TypeError("Missing required property 'exclude_resource_tags'")
            __props__.__dict__["exclude_resource_tags"] = exclude_resource_tags
            __props__.__dict__["include_map"] = include_map
            __props__.__dict__["name"] = name
            __props__.__dict__["remediation_enabled"] = remediation_enabled
            __props__.__dict__["resource_tags"] = resource_tags
            __props__.__dict__["resource_type"] = resource_type
            __props__.__dict__["resource_type_lists"] = resource_type_lists
            if security_service_policy_data is None and not opts.urn:
                raise TypeError("Missing required property 'security_service_policy_data'")
            __props__.__dict__["security_service_policy_data"] = security_service_policy_data
            __props__.__dict__["arn"] = None
            __props__.__dict__["policy_update_token"] = None
        super(Policy, __self__).__init__(
            'aws:fms/policy:Policy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            delete_all_policy_resources: Optional[pulumi.Input[bool]] = None,
            exclude_map: Optional[pulumi.Input[pulumi.InputType['PolicyExcludeMapArgs']]] = None,
            exclude_resource_tags: Optional[pulumi.Input[bool]] = None,
            include_map: Optional[pulumi.Input[pulumi.InputType['PolicyIncludeMapArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            policy_update_token: Optional[pulumi.Input[str]] = None,
            remediation_enabled: Optional[pulumi.Input[bool]] = None,
            resource_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            resource_type: Optional[pulumi.Input[str]] = None,
            resource_type_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            security_service_policy_data: Optional[pulumi.Input[pulumi.InputType['PolicySecurityServicePolicyDataArgs']]] = None) -> 'Policy':
        """
        Get an existing Policy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] delete_all_policy_resources: If true, the request will also perform a clean-up process. Defaults to `true`. More information can be found here [AWS Firewall Manager delete policy](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_DeletePolicy.html)
        :param pulumi.Input[pulumi.InputType['PolicyExcludeMapArgs']] exclude_map: A map of lists of accounts and OU's to exclude from the policy.
        :param pulumi.Input[bool] exclude_resource_tags: A boolean value, if true the tags that are specified in the `resource_tags` are not protected by this policy. If set to false and resource_tags are populated, resources that contain tags will be protected by this policy.
        :param pulumi.Input[pulumi.InputType['PolicyIncludeMapArgs']] include_map: A map of lists of accounts and OU's to include in the policy.
        :param pulumi.Input[str] name: The friendly name of the AWS Firewall Manager Policy.
        :param pulumi.Input[str] policy_update_token: A unique identifier for each update to the policy.
        :param pulumi.Input[bool] remediation_enabled: A boolean value, indicates if the policy should automatically applied to resources that already exist in the account.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] resource_tags: A map of resource tags, that if present will filter protections on resources based on the exclude_resource_tags.
        :param pulumi.Input[str] resource_type: A resource type to protect. Conflicts with `resource_type_list`. See the [FMS API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html#fms-Type-Policy-ResourceType) for more information about supported values.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resource_type_lists: A list of resource types to protect. Conflicts with `resource_type`. See the [FMS API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html#fms-Type-Policy-ResourceType) for more information about supported values.
        :param pulumi.Input[pulumi.InputType['PolicySecurityServicePolicyDataArgs']] security_service_policy_data: The objects to include in Security Service Policy Data. Documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PolicyState.__new__(_PolicyState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["delete_all_policy_resources"] = delete_all_policy_resources
        __props__.__dict__["exclude_map"] = exclude_map
        __props__.__dict__["exclude_resource_tags"] = exclude_resource_tags
        __props__.__dict__["include_map"] = include_map
        __props__.__dict__["name"] = name
        __props__.__dict__["policy_update_token"] = policy_update_token
        __props__.__dict__["remediation_enabled"] = remediation_enabled
        __props__.__dict__["resource_tags"] = resource_tags
        __props__.__dict__["resource_type"] = resource_type
        __props__.__dict__["resource_type_lists"] = resource_type_lists
        __props__.__dict__["security_service_policy_data"] = security_service_policy_data
        return Policy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="deleteAllPolicyResources")
    def delete_all_policy_resources(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, the request will also perform a clean-up process. Defaults to `true`. More information can be found here [AWS Firewall Manager delete policy](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_DeletePolicy.html)
        """
        return pulumi.get(self, "delete_all_policy_resources")

    @property
    @pulumi.getter(name="excludeMap")
    def exclude_map(self) -> pulumi.Output[Optional['outputs.PolicyExcludeMap']]:
        """
        A map of lists of accounts and OU's to exclude from the policy.
        """
        return pulumi.get(self, "exclude_map")

    @property
    @pulumi.getter(name="excludeResourceTags")
    def exclude_resource_tags(self) -> pulumi.Output[bool]:
        """
        A boolean value, if true the tags that are specified in the `resource_tags` are not protected by this policy. If set to false and resource_tags are populated, resources that contain tags will be protected by this policy.
        """
        return pulumi.get(self, "exclude_resource_tags")

    @property
    @pulumi.getter(name="includeMap")
    def include_map(self) -> pulumi.Output[Optional['outputs.PolicyIncludeMap']]:
        """
        A map of lists of accounts and OU's to include in the policy.
        """
        return pulumi.get(self, "include_map")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The friendly name of the AWS Firewall Manager Policy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="policyUpdateToken")
    def policy_update_token(self) -> pulumi.Output[str]:
        """
        A unique identifier for each update to the policy.
        """
        return pulumi.get(self, "policy_update_token")

    @property
    @pulumi.getter(name="remediationEnabled")
    def remediation_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        A boolean value, indicates if the policy should automatically applied to resources that already exist in the account.
        """
        return pulumi.get(self, "remediation_enabled")

    @property
    @pulumi.getter(name="resourceTags")
    def resource_tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A map of resource tags, that if present will filter protections on resources based on the exclude_resource_tags.
        """
        return pulumi.get(self, "resource_tags")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Output[str]:
        """
        A resource type to protect. Conflicts with `resource_type_list`. See the [FMS API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html#fms-Type-Policy-ResourceType) for more information about supported values.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="resourceTypeLists")
    def resource_type_lists(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of resource types to protect. Conflicts with `resource_type`. See the [FMS API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html#fms-Type-Policy-ResourceType) for more information about supported values.
        """
        return pulumi.get(self, "resource_type_lists")

    @property
    @pulumi.getter(name="securityServicePolicyData")
    def security_service_policy_data(self) -> pulumi.Output['outputs.PolicySecurityServicePolicyData']:
        """
        The objects to include in Security Service Policy Data. Documented below.
        """
        return pulumi.get(self, "security_service_policy_data")

