# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetIpamPreviewNextCidrResult',
    'AwaitableGetIpamPreviewNextCidrResult',
    'get_ipam_preview_next_cidr',
    'get_ipam_preview_next_cidr_output',
]

@pulumi.output_type
class GetIpamPreviewNextCidrResult:
    """
    A collection of values returned by getIpamPreviewNextCidr.
    """
    def __init__(__self__, cidr=None, disallowed_cidrs=None, id=None, ipam_pool_id=None, netmask_length=None):
        if cidr and not isinstance(cidr, str):
            raise TypeError("Expected argument 'cidr' to be a str")
        pulumi.set(__self__, "cidr", cidr)
        if disallowed_cidrs and not isinstance(disallowed_cidrs, list):
            raise TypeError("Expected argument 'disallowed_cidrs' to be a list")
        pulumi.set(__self__, "disallowed_cidrs", disallowed_cidrs)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ipam_pool_id and not isinstance(ipam_pool_id, str):
            raise TypeError("Expected argument 'ipam_pool_id' to be a str")
        pulumi.set(__self__, "ipam_pool_id", ipam_pool_id)
        if netmask_length and not isinstance(netmask_length, int):
            raise TypeError("Expected argument 'netmask_length' to be a int")
        pulumi.set(__self__, "netmask_length", netmask_length)

    @property
    @pulumi.getter
    def cidr(self) -> str:
        """
        The previewed CIDR from the pool.
        """
        return pulumi.get(self, "cidr")

    @property
    @pulumi.getter(name="disallowedCidrs")
    def disallowed_cidrs(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "disallowed_cidrs")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipamPoolId")
    def ipam_pool_id(self) -> str:
        return pulumi.get(self, "ipam_pool_id")

    @property
    @pulumi.getter(name="netmaskLength")
    def netmask_length(self) -> Optional[int]:
        return pulumi.get(self, "netmask_length")


class AwaitableGetIpamPreviewNextCidrResult(GetIpamPreviewNextCidrResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIpamPreviewNextCidrResult(
            cidr=self.cidr,
            disallowed_cidrs=self.disallowed_cidrs,
            id=self.id,
            ipam_pool_id=self.ipam_pool_id,
            netmask_length=self.netmask_length)


def get_ipam_preview_next_cidr(disallowed_cidrs: Optional[Sequence[str]] = None,
                               ipam_pool_id: Optional[str] = None,
                               netmask_length: Optional[int] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIpamPreviewNextCidrResult:
    """
    Use this data source to access information about an existing resource.

    :param Sequence[str] disallowed_cidrs: Exclude a particular CIDR range from being returned by the pool.
    :param str ipam_pool_id: The ID of the pool to which you want to assign a CIDR.
    :param int netmask_length: The netmask length of the CIDR you would like to preview from the IPAM pool.
    """
    __args__ = dict()
    __args__['disallowedCidrs'] = disallowed_cidrs
    __args__['ipamPoolId'] = ipam_pool_id
    __args__['netmaskLength'] = netmask_length
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws:ec2/getIpamPreviewNextCidr:getIpamPreviewNextCidr', __args__, opts=opts, typ=GetIpamPreviewNextCidrResult).value

    return AwaitableGetIpamPreviewNextCidrResult(
        cidr=__ret__.cidr,
        disallowed_cidrs=__ret__.disallowed_cidrs,
        id=__ret__.id,
        ipam_pool_id=__ret__.ipam_pool_id,
        netmask_length=__ret__.netmask_length)


@_utilities.lift_output_func(get_ipam_preview_next_cidr)
def get_ipam_preview_next_cidr_output(disallowed_cidrs: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                      ipam_pool_id: Optional[pulumi.Input[str]] = None,
                                      netmask_length: Optional[pulumi.Input[Optional[int]]] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetIpamPreviewNextCidrResult]:
    """
    Use this data source to access information about an existing resource.

    :param Sequence[str] disallowed_cidrs: Exclude a particular CIDR range from being returned by the pool.
    :param str ipam_pool_id: The ID of the pool to which you want to assign a CIDR.
    :param int netmask_length: The netmask length of the CIDR you would like to preview from the IPAM pool.
    """
    ...
