# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'EndpointElasticsearchSettings',
    'EndpointKafkaSettings',
    'EndpointKinesisSettings',
    'EndpointMongodbSettings',
    'EndpointS3Settings',
]

@pulumi.output_type
class EndpointElasticsearchSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointUri":
            suggest = "endpoint_uri"
        elif key == "serviceAccessRoleArn":
            suggest = "service_access_role_arn"
        elif key == "errorRetryDuration":
            suggest = "error_retry_duration"
        elif key == "fullLoadErrorPercentage":
            suggest = "full_load_error_percentage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointElasticsearchSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointElasticsearchSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointElasticsearchSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_uri: str,
                 service_access_role_arn: str,
                 error_retry_duration: Optional[int] = None,
                 full_load_error_percentage: Optional[int] = None):
        """
        :param str endpoint_uri: Endpoint for the Elasticsearch cluster.
        :param str service_access_role_arn: Amazon Resource Name (ARN) of the IAM Role with permissions to write to the Elasticsearch cluster.
        :param int error_retry_duration: Maximum number of seconds for which DMS retries failed API requests to the Elasticsearch cluster. Defaults to `300`.
        :param int full_load_error_percentage: Maximum percentage of records that can fail to be written before a full load operation stops. Defaults to `10`.
        """
        pulumi.set(__self__, "endpoint_uri", endpoint_uri)
        pulumi.set(__self__, "service_access_role_arn", service_access_role_arn)
        if error_retry_duration is not None:
            pulumi.set(__self__, "error_retry_duration", error_retry_duration)
        if full_load_error_percentage is not None:
            pulumi.set(__self__, "full_load_error_percentage", full_load_error_percentage)

    @property
    @pulumi.getter(name="endpointUri")
    def endpoint_uri(self) -> str:
        """
        Endpoint for the Elasticsearch cluster.
        """
        return pulumi.get(self, "endpoint_uri")

    @property
    @pulumi.getter(name="serviceAccessRoleArn")
    def service_access_role_arn(self) -> str:
        """
        Amazon Resource Name (ARN) of the IAM Role with permissions to write to the Elasticsearch cluster.
        """
        return pulumi.get(self, "service_access_role_arn")

    @property
    @pulumi.getter(name="errorRetryDuration")
    def error_retry_duration(self) -> Optional[int]:
        """
        Maximum number of seconds for which DMS retries failed API requests to the Elasticsearch cluster. Defaults to `300`.
        """
        return pulumi.get(self, "error_retry_duration")

    @property
    @pulumi.getter(name="fullLoadErrorPercentage")
    def full_load_error_percentage(self) -> Optional[int]:
        """
        Maximum percentage of records that can fail to be written before a full load operation stops. Defaults to `10`.
        """
        return pulumi.get(self, "full_load_error_percentage")


@pulumi.output_type
class EndpointKafkaSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "includeControlDetails":
            suggest = "include_control_details"
        elif key == "includeNullAndEmpty":
            suggest = "include_null_and_empty"
        elif key == "includePartitionValue":
            suggest = "include_partition_value"
        elif key == "includeTableAlterOperations":
            suggest = "include_table_alter_operations"
        elif key == "includeTransactionDetails":
            suggest = "include_transaction_details"
        elif key == "messageFormat":
            suggest = "message_format"
        elif key == "messageMaxBytes":
            suggest = "message_max_bytes"
        elif key == "noHexPrefix":
            suggest = "no_hex_prefix"
        elif key == "partitionIncludeSchemaTable":
            suggest = "partition_include_schema_table"
        elif key == "saslPassword":
            suggest = "sasl_password"
        elif key == "saslUsername":
            suggest = "sasl_username"
        elif key == "securityProtocol":
            suggest = "security_protocol"
        elif key == "sslCaCertificateArn":
            suggest = "ssl_ca_certificate_arn"
        elif key == "sslClientCertificateArn":
            suggest = "ssl_client_certificate_arn"
        elif key == "sslClientKeyArn":
            suggest = "ssl_client_key_arn"
        elif key == "sslClientKeyPassword":
            suggest = "ssl_client_key_password"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointKafkaSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointKafkaSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointKafkaSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 broker: str,
                 include_control_details: Optional[bool] = None,
                 include_null_and_empty: Optional[bool] = None,
                 include_partition_value: Optional[bool] = None,
                 include_table_alter_operations: Optional[bool] = None,
                 include_transaction_details: Optional[bool] = None,
                 message_format: Optional[str] = None,
                 message_max_bytes: Optional[int] = None,
                 no_hex_prefix: Optional[bool] = None,
                 partition_include_schema_table: Optional[bool] = None,
                 sasl_password: Optional[str] = None,
                 sasl_username: Optional[str] = None,
                 security_protocol: Optional[str] = None,
                 ssl_ca_certificate_arn: Optional[str] = None,
                 ssl_client_certificate_arn: Optional[str] = None,
                 ssl_client_key_arn: Optional[str] = None,
                 ssl_client_key_password: Optional[str] = None,
                 topic: Optional[str] = None):
        """
        :param str broker: Kafka broker location. Specify in the form broker-hostname-or-ip:port.
        :param bool include_control_details: Shows detailed control information for table definition, column definition, and table and column changes in the Kafka message output. The default is `false`.
        :param bool include_null_and_empty: Include NULL and empty columns for records migrated to the endpoint. The default is `false`.
        :param bool include_partition_value: Shows the partition value within the Kafka message output unless the partition type is `schema-table-type`. The default is `false`.
        :param bool include_table_alter_operations: Includes any data definition language (DDL) operations that change the table in the control data, such as `rename-table`, `drop-table`, `add-column`, `drop-column`, and `rename-column`. The default is `false`.
        :param bool include_transaction_details: Provides detailed transaction information from the source database. This information includes a commit timestamp, a log position, and values for `transaction_id`, previous `transaction_id`, and `transaction_record_id` (the record offset within a transaction). The default is `false`.
        :param str message_format: The output format for the records created on the endpoint. The message format is `JSON` (default) or `JSON_UNFORMATTED` (a single line with no tab).
        :param int message_max_bytes: The maximum size in bytes for records created on the endpoint The default is `1,000,000`.
        :param bool no_hex_prefix: Set this optional parameter to true to avoid adding a '0x' prefix to raw data in hexadecimal format. For example, by default, AWS DMS adds a '0x' prefix to the LOB column type in hexadecimal format moving from an Oracle source to a Kafka target. Use the `no_hex_prefix` endpoint setting to enable migration of RAW data type columns without adding the `'0x'` prefix.
        :param bool partition_include_schema_table: Prefixes schema and table names to partition values, when the partition type is `primary-key-type`. Doing this increases data distribution among Kafka partitions. For example, suppose that a SysBench schema has thousands of tables and each table has only limited range for a primary key. In this case, the same primary key is sent from thousands of tables to the same partition, which causes throttling. The default is `false`.
        :param str sasl_password: The secure password you created when you first set up your MSK cluster to validate a client identity and make an encrypted connection between server and client using SASL-SSL authentication.
        :param str sasl_username: The secure user name you created when you first set up your MSK cluster to validate a client identity and make an encrypted connection between server and client using SASL-SSL authentication.
        :param str security_protocol: Set secure connection to a Kafka target endpoint using Transport Layer Security (TLS). Options include `ssl-encryption`, `ssl-authentication`, and `sasl-ssl`. `sasl-ssl` requires `sasl_username` and `sasl_password`.
        :param str ssl_ca_certificate_arn: The Amazon Resource Name (ARN) for the private certificate authority (CA) cert that AWS DMS uses to securely connect to your Kafka target endpoint.
        :param str ssl_client_certificate_arn: The Amazon Resource Name (ARN) of the client certificate used to securely connect to a Kafka target endpoint.
        :param str ssl_client_key_arn: The Amazon Resource Name (ARN) for the client private key used to securely connect to a Kafka target endpoint.
        :param str ssl_client_key_password: The password for the client private key used to securely connect to a Kafka target endpoint.
        :param str topic: Kafka topic for migration. Defaults to `kafka-default-topic`.
        """
        pulumi.set(__self__, "broker", broker)
        if include_control_details is not None:
            pulumi.set(__self__, "include_control_details", include_control_details)
        if include_null_and_empty is not None:
            pulumi.set(__self__, "include_null_and_empty", include_null_and_empty)
        if include_partition_value is not None:
            pulumi.set(__self__, "include_partition_value", include_partition_value)
        if include_table_alter_operations is not None:
            pulumi.set(__self__, "include_table_alter_operations", include_table_alter_operations)
        if include_transaction_details is not None:
            pulumi.set(__self__, "include_transaction_details", include_transaction_details)
        if message_format is not None:
            pulumi.set(__self__, "message_format", message_format)
        if message_max_bytes is not None:
            pulumi.set(__self__, "message_max_bytes", message_max_bytes)
        if no_hex_prefix is not None:
            pulumi.set(__self__, "no_hex_prefix", no_hex_prefix)
        if partition_include_schema_table is not None:
            pulumi.set(__self__, "partition_include_schema_table", partition_include_schema_table)
        if sasl_password is not None:
            pulumi.set(__self__, "sasl_password", sasl_password)
        if sasl_username is not None:
            pulumi.set(__self__, "sasl_username", sasl_username)
        if security_protocol is not None:
            pulumi.set(__self__, "security_protocol", security_protocol)
        if ssl_ca_certificate_arn is not None:
            pulumi.set(__self__, "ssl_ca_certificate_arn", ssl_ca_certificate_arn)
        if ssl_client_certificate_arn is not None:
            pulumi.set(__self__, "ssl_client_certificate_arn", ssl_client_certificate_arn)
        if ssl_client_key_arn is not None:
            pulumi.set(__self__, "ssl_client_key_arn", ssl_client_key_arn)
        if ssl_client_key_password is not None:
            pulumi.set(__self__, "ssl_client_key_password", ssl_client_key_password)
        if topic is not None:
            pulumi.set(__self__, "topic", topic)

    @property
    @pulumi.getter
    def broker(self) -> str:
        """
        Kafka broker location. Specify in the form broker-hostname-or-ip:port.
        """
        return pulumi.get(self, "broker")

    @property
    @pulumi.getter(name="includeControlDetails")
    def include_control_details(self) -> Optional[bool]:
        """
        Shows detailed control information for table definition, column definition, and table and column changes in the Kafka message output. The default is `false`.
        """
        return pulumi.get(self, "include_control_details")

    @property
    @pulumi.getter(name="includeNullAndEmpty")
    def include_null_and_empty(self) -> Optional[bool]:
        """
        Include NULL and empty columns for records migrated to the endpoint. The default is `false`.
        """
        return pulumi.get(self, "include_null_and_empty")

    @property
    @pulumi.getter(name="includePartitionValue")
    def include_partition_value(self) -> Optional[bool]:
        """
        Shows the partition value within the Kafka message output unless the partition type is `schema-table-type`. The default is `false`.
        """
        return pulumi.get(self, "include_partition_value")

    @property
    @pulumi.getter(name="includeTableAlterOperations")
    def include_table_alter_operations(self) -> Optional[bool]:
        """
        Includes any data definition language (DDL) operations that change the table in the control data, such as `rename-table`, `drop-table`, `add-column`, `drop-column`, and `rename-column`. The default is `false`.
        """
        return pulumi.get(self, "include_table_alter_operations")

    @property
    @pulumi.getter(name="includeTransactionDetails")
    def include_transaction_details(self) -> Optional[bool]:
        """
        Provides detailed transaction information from the source database. This information includes a commit timestamp, a log position, and values for `transaction_id`, previous `transaction_id`, and `transaction_record_id` (the record offset within a transaction). The default is `false`.
        """
        return pulumi.get(self, "include_transaction_details")

    @property
    @pulumi.getter(name="messageFormat")
    def message_format(self) -> Optional[str]:
        """
        The output format for the records created on the endpoint. The message format is `JSON` (default) or `JSON_UNFORMATTED` (a single line with no tab).
        """
        return pulumi.get(self, "message_format")

    @property
    @pulumi.getter(name="messageMaxBytes")
    def message_max_bytes(self) -> Optional[int]:
        """
        The maximum size in bytes for records created on the endpoint The default is `1,000,000`.
        """
        return pulumi.get(self, "message_max_bytes")

    @property
    @pulumi.getter(name="noHexPrefix")
    def no_hex_prefix(self) -> Optional[bool]:
        """
        Set this optional parameter to true to avoid adding a '0x' prefix to raw data in hexadecimal format. For example, by default, AWS DMS adds a '0x' prefix to the LOB column type in hexadecimal format moving from an Oracle source to a Kafka target. Use the `no_hex_prefix` endpoint setting to enable migration of RAW data type columns without adding the `'0x'` prefix.
        """
        return pulumi.get(self, "no_hex_prefix")

    @property
    @pulumi.getter(name="partitionIncludeSchemaTable")
    def partition_include_schema_table(self) -> Optional[bool]:
        """
        Prefixes schema and table names to partition values, when the partition type is `primary-key-type`. Doing this increases data distribution among Kafka partitions. For example, suppose that a SysBench schema has thousands of tables and each table has only limited range for a primary key. In this case, the same primary key is sent from thousands of tables to the same partition, which causes throttling. The default is `false`.
        """
        return pulumi.get(self, "partition_include_schema_table")

    @property
    @pulumi.getter(name="saslPassword")
    def sasl_password(self) -> Optional[str]:
        """
        The secure password you created when you first set up your MSK cluster to validate a client identity and make an encrypted connection between server and client using SASL-SSL authentication.
        """
        return pulumi.get(self, "sasl_password")

    @property
    @pulumi.getter(name="saslUsername")
    def sasl_username(self) -> Optional[str]:
        """
        The secure user name you created when you first set up your MSK cluster to validate a client identity and make an encrypted connection between server and client using SASL-SSL authentication.
        """
        return pulumi.get(self, "sasl_username")

    @property
    @pulumi.getter(name="securityProtocol")
    def security_protocol(self) -> Optional[str]:
        """
        Set secure connection to a Kafka target endpoint using Transport Layer Security (TLS). Options include `ssl-encryption`, `ssl-authentication`, and `sasl-ssl`. `sasl-ssl` requires `sasl_username` and `sasl_password`.
        """
        return pulumi.get(self, "security_protocol")

    @property
    @pulumi.getter(name="sslCaCertificateArn")
    def ssl_ca_certificate_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) for the private certificate authority (CA) cert that AWS DMS uses to securely connect to your Kafka target endpoint.
        """
        return pulumi.get(self, "ssl_ca_certificate_arn")

    @property
    @pulumi.getter(name="sslClientCertificateArn")
    def ssl_client_certificate_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the client certificate used to securely connect to a Kafka target endpoint.
        """
        return pulumi.get(self, "ssl_client_certificate_arn")

    @property
    @pulumi.getter(name="sslClientKeyArn")
    def ssl_client_key_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) for the client private key used to securely connect to a Kafka target endpoint.
        """
        return pulumi.get(self, "ssl_client_key_arn")

    @property
    @pulumi.getter(name="sslClientKeyPassword")
    def ssl_client_key_password(self) -> Optional[str]:
        """
        The password for the client private key used to securely connect to a Kafka target endpoint.
        """
        return pulumi.get(self, "ssl_client_key_password")

    @property
    @pulumi.getter
    def topic(self) -> Optional[str]:
        """
        Kafka topic for migration. Defaults to `kafka-default-topic`.
        """
        return pulumi.get(self, "topic")


@pulumi.output_type
class EndpointKinesisSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "includeControlDetails":
            suggest = "include_control_details"
        elif key == "includeNullAndEmpty":
            suggest = "include_null_and_empty"
        elif key == "includePartitionValue":
            suggest = "include_partition_value"
        elif key == "includeTableAlterOperations":
            suggest = "include_table_alter_operations"
        elif key == "includeTransactionDetails":
            suggest = "include_transaction_details"
        elif key == "messageFormat":
            suggest = "message_format"
        elif key == "partitionIncludeSchemaTable":
            suggest = "partition_include_schema_table"
        elif key == "serviceAccessRoleArn":
            suggest = "service_access_role_arn"
        elif key == "streamArn":
            suggest = "stream_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointKinesisSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointKinesisSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointKinesisSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 include_control_details: Optional[bool] = None,
                 include_null_and_empty: Optional[bool] = None,
                 include_partition_value: Optional[bool] = None,
                 include_table_alter_operations: Optional[bool] = None,
                 include_transaction_details: Optional[bool] = None,
                 message_format: Optional[str] = None,
                 partition_include_schema_table: Optional[bool] = None,
                 service_access_role_arn: Optional[str] = None,
                 stream_arn: Optional[str] = None):
        """
        :param bool include_control_details: Shows detailed control information for table definition, column definition, and table and column changes in the Kinesis message output. The default is `false`.
        :param bool include_null_and_empty: Include NULL and empty columns in the target. The default is `false`.
        :param bool include_partition_value: Shows the partition value within the Kinesis message output, unless the partition type is schema-table-type. The default is `false`.
        :param bool include_table_alter_operations: Includes any data definition language (DDL) operations that change the table in the control data. The default is `false`.
        :param bool include_transaction_details: Provides detailed transaction information from the source database. The default is `false`.
        :param str message_format: Output format for the records created. Defaults to `json`. Valid values are `json` and `json_unformatted` (a single line with no tab).
        :param bool partition_include_schema_table: Prefixes schema and table names to partition values, when the partition type is primary-key-type. The default is `false`.
        :param str service_access_role_arn: Amazon Resource Name (ARN) of the IAM Role with permissions to write to the Kinesis data stream.
        :param str stream_arn: Amazon Resource Name (ARN) of the Kinesis data stream.
        """
        if include_control_details is not None:
            pulumi.set(__self__, "include_control_details", include_control_details)
        if include_null_and_empty is not None:
            pulumi.set(__self__, "include_null_and_empty", include_null_and_empty)
        if include_partition_value is not None:
            pulumi.set(__self__, "include_partition_value", include_partition_value)
        if include_table_alter_operations is not None:
            pulumi.set(__self__, "include_table_alter_operations", include_table_alter_operations)
        if include_transaction_details is not None:
            pulumi.set(__self__, "include_transaction_details", include_transaction_details)
        if message_format is not None:
            pulumi.set(__self__, "message_format", message_format)
        if partition_include_schema_table is not None:
            pulumi.set(__self__, "partition_include_schema_table", partition_include_schema_table)
        if service_access_role_arn is not None:
            pulumi.set(__self__, "service_access_role_arn", service_access_role_arn)
        if stream_arn is not None:
            pulumi.set(__self__, "stream_arn", stream_arn)

    @property
    @pulumi.getter(name="includeControlDetails")
    def include_control_details(self) -> Optional[bool]:
        """
        Shows detailed control information for table definition, column definition, and table and column changes in the Kinesis message output. The default is `false`.
        """
        return pulumi.get(self, "include_control_details")

    @property
    @pulumi.getter(name="includeNullAndEmpty")
    def include_null_and_empty(self) -> Optional[bool]:
        """
        Include NULL and empty columns in the target. The default is `false`.
        """
        return pulumi.get(self, "include_null_and_empty")

    @property
    @pulumi.getter(name="includePartitionValue")
    def include_partition_value(self) -> Optional[bool]:
        """
        Shows the partition value within the Kinesis message output, unless the partition type is schema-table-type. The default is `false`.
        """
        return pulumi.get(self, "include_partition_value")

    @property
    @pulumi.getter(name="includeTableAlterOperations")
    def include_table_alter_operations(self) -> Optional[bool]:
        """
        Includes any data definition language (DDL) operations that change the table in the control data. The default is `false`.
        """
        return pulumi.get(self, "include_table_alter_operations")

    @property
    @pulumi.getter(name="includeTransactionDetails")
    def include_transaction_details(self) -> Optional[bool]:
        """
        Provides detailed transaction information from the source database. The default is `false`.
        """
        return pulumi.get(self, "include_transaction_details")

    @property
    @pulumi.getter(name="messageFormat")
    def message_format(self) -> Optional[str]:
        """
        Output format for the records created. Defaults to `json`. Valid values are `json` and `json_unformatted` (a single line with no tab).
        """
        return pulumi.get(self, "message_format")

    @property
    @pulumi.getter(name="partitionIncludeSchemaTable")
    def partition_include_schema_table(self) -> Optional[bool]:
        """
        Prefixes schema and table names to partition values, when the partition type is primary-key-type. The default is `false`.
        """
        return pulumi.get(self, "partition_include_schema_table")

    @property
    @pulumi.getter(name="serviceAccessRoleArn")
    def service_access_role_arn(self) -> Optional[str]:
        """
        Amazon Resource Name (ARN) of the IAM Role with permissions to write to the Kinesis data stream.
        """
        return pulumi.get(self, "service_access_role_arn")

    @property
    @pulumi.getter(name="streamArn")
    def stream_arn(self) -> Optional[str]:
        """
        Amazon Resource Name (ARN) of the Kinesis data stream.
        """
        return pulumi.get(self, "stream_arn")


@pulumi.output_type
class EndpointMongodbSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authMechanism":
            suggest = "auth_mechanism"
        elif key == "authSource":
            suggest = "auth_source"
        elif key == "authType":
            suggest = "auth_type"
        elif key == "docsToInvestigate":
            suggest = "docs_to_investigate"
        elif key == "extractDocId":
            suggest = "extract_doc_id"
        elif key == "nestingLevel":
            suggest = "nesting_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointMongodbSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointMongodbSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointMongodbSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_mechanism: Optional[str] = None,
                 auth_source: Optional[str] = None,
                 auth_type: Optional[str] = None,
                 docs_to_investigate: Optional[str] = None,
                 extract_doc_id: Optional[str] = None,
                 nesting_level: Optional[str] = None):
        """
        :param str auth_mechanism: Authentication mechanism to access the MongoDB source endpoint. Defaults to `default`.
        :param str auth_source: Authentication database name. Not used when `auth_type` is `no`. Defaults to `admin`.
        :param str auth_type: Authentication type to access the MongoDB source endpoint. Defaults to `password`.
        :param str docs_to_investigate: Number of documents to preview to determine the document organization. Use this setting when `nesting_level` is set to `one`. Defaults to `1000`.
        :param str extract_doc_id: Document ID. Use this setting when `nesting_level` is set to `none`. Defaults to `false`.
        :param str nesting_level: Specifies either document or table mode. Defaults to `none`. Valid values are `one` (table mode) and `none` (document mode).
        """
        if auth_mechanism is not None:
            pulumi.set(__self__, "auth_mechanism", auth_mechanism)
        if auth_source is not None:
            pulumi.set(__self__, "auth_source", auth_source)
        if auth_type is not None:
            pulumi.set(__self__, "auth_type", auth_type)
        if docs_to_investigate is not None:
            pulumi.set(__self__, "docs_to_investigate", docs_to_investigate)
        if extract_doc_id is not None:
            pulumi.set(__self__, "extract_doc_id", extract_doc_id)
        if nesting_level is not None:
            pulumi.set(__self__, "nesting_level", nesting_level)

    @property
    @pulumi.getter(name="authMechanism")
    def auth_mechanism(self) -> Optional[str]:
        """
        Authentication mechanism to access the MongoDB source endpoint. Defaults to `default`.
        """
        return pulumi.get(self, "auth_mechanism")

    @property
    @pulumi.getter(name="authSource")
    def auth_source(self) -> Optional[str]:
        """
        Authentication database name. Not used when `auth_type` is `no`. Defaults to `admin`.
        """
        return pulumi.get(self, "auth_source")

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> Optional[str]:
        """
        Authentication type to access the MongoDB source endpoint. Defaults to `password`.
        """
        return pulumi.get(self, "auth_type")

    @property
    @pulumi.getter(name="docsToInvestigate")
    def docs_to_investigate(self) -> Optional[str]:
        """
        Number of documents to preview to determine the document organization. Use this setting when `nesting_level` is set to `one`. Defaults to `1000`.
        """
        return pulumi.get(self, "docs_to_investigate")

    @property
    @pulumi.getter(name="extractDocId")
    def extract_doc_id(self) -> Optional[str]:
        """
        Document ID. Use this setting when `nesting_level` is set to `none`. Defaults to `false`.
        """
        return pulumi.get(self, "extract_doc_id")

    @property
    @pulumi.getter(name="nestingLevel")
    def nesting_level(self) -> Optional[str]:
        """
        Specifies either document or table mode. Defaults to `none`. Valid values are `one` (table mode) and `none` (document mode).
        """
        return pulumi.get(self, "nesting_level")


@pulumi.output_type
class EndpointS3Settings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketFolder":
            suggest = "bucket_folder"
        elif key == "bucketName":
            suggest = "bucket_name"
        elif key == "compressionType":
            suggest = "compression_type"
        elif key == "csvDelimiter":
            suggest = "csv_delimiter"
        elif key == "csvRowDelimiter":
            suggest = "csv_row_delimiter"
        elif key == "dataFormat":
            suggest = "data_format"
        elif key == "datePartitionEnabled":
            suggest = "date_partition_enabled"
        elif key == "encryptionMode":
            suggest = "encryption_mode"
        elif key == "externalTableDefinition":
            suggest = "external_table_definition"
        elif key == "parquetTimestampInMillisecond":
            suggest = "parquet_timestamp_in_millisecond"
        elif key == "parquetVersion":
            suggest = "parquet_version"
        elif key == "serverSideEncryptionKmsKeyId":
            suggest = "server_side_encryption_kms_key_id"
        elif key == "serviceAccessRoleArn":
            suggest = "service_access_role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointS3Settings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointS3Settings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointS3Settings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_folder: Optional[str] = None,
                 bucket_name: Optional[str] = None,
                 compression_type: Optional[str] = None,
                 csv_delimiter: Optional[str] = None,
                 csv_row_delimiter: Optional[str] = None,
                 data_format: Optional[str] = None,
                 date_partition_enabled: Optional[bool] = None,
                 encryption_mode: Optional[str] = None,
                 external_table_definition: Optional[str] = None,
                 parquet_timestamp_in_millisecond: Optional[bool] = None,
                 parquet_version: Optional[str] = None,
                 server_side_encryption_kms_key_id: Optional[str] = None,
                 service_access_role_arn: Optional[str] = None):
        """
        :param str bucket_folder: S3 Bucket Object prefix.
        :param str bucket_name: S3 Bucket name.
        :param str compression_type: Set to compress target files. Defaults to `NONE`. Valid values are `GZIP` and `NONE`.
        :param str csv_delimiter: Delimiter used to separate columns in the source files. Defaults to `,`.
        :param str csv_row_delimiter: Delimiter used to separate rows in the source files. Defaults to `\n`.
        :param str data_format: The output format for the files that AWS DMS uses to create S3 objects. Defaults to `csv`. Valid values are `csv` and `parquet`.
        :param bool date_partition_enabled: Partition S3 bucket folders based on transaction commit dates. Defaults to `false`.
        :param str encryption_mode: The server-side encryption mode that you want to encrypt your .csv or .parquet object files copied to S3. Defaults to `SSE_S3`. Valid values are `SSE_S3` and `SSE_KMS`.
        :param str external_table_definition: JSON document that describes how AWS DMS should interpret the data.
        :param bool parquet_timestamp_in_millisecond: - Specifies the precision of any TIMESTAMP column values written to an S3 object file in .parquet format. Defaults to `false`.
        :param str parquet_version: The version of the .parquet file format. Defaults to `parquet-1-0`. Valid values are `parquet-1-0` and `parquet-2-0`.
        :param str server_side_encryption_kms_key_id: If you set encryptionMode to `SSE_KMS`, set this parameter to the Amazon Resource Name (ARN) for the AWS KMS key.
        :param str service_access_role_arn: Amazon Resource Name (ARN) of the IAM Role with permissions to read from or write to the S3 Bucket.
        """
        if bucket_folder is not None:
            pulumi.set(__self__, "bucket_folder", bucket_folder)
        if bucket_name is not None:
            pulumi.set(__self__, "bucket_name", bucket_name)
        if compression_type is not None:
            pulumi.set(__self__, "compression_type", compression_type)
        if csv_delimiter is not None:
            pulumi.set(__self__, "csv_delimiter", csv_delimiter)
        if csv_row_delimiter is not None:
            pulumi.set(__self__, "csv_row_delimiter", csv_row_delimiter)
        if data_format is not None:
            pulumi.set(__self__, "data_format", data_format)
        if date_partition_enabled is not None:
            pulumi.set(__self__, "date_partition_enabled", date_partition_enabled)
        if encryption_mode is not None:
            pulumi.set(__self__, "encryption_mode", encryption_mode)
        if external_table_definition is not None:
            pulumi.set(__self__, "external_table_definition", external_table_definition)
        if parquet_timestamp_in_millisecond is not None:
            pulumi.set(__self__, "parquet_timestamp_in_millisecond", parquet_timestamp_in_millisecond)
        if parquet_version is not None:
            pulumi.set(__self__, "parquet_version", parquet_version)
        if server_side_encryption_kms_key_id is not None:
            pulumi.set(__self__, "server_side_encryption_kms_key_id", server_side_encryption_kms_key_id)
        if service_access_role_arn is not None:
            pulumi.set(__self__, "service_access_role_arn", service_access_role_arn)

    @property
    @pulumi.getter(name="bucketFolder")
    def bucket_folder(self) -> Optional[str]:
        """
        S3 Bucket Object prefix.
        """
        return pulumi.get(self, "bucket_folder")

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> Optional[str]:
        """
        S3 Bucket name.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter(name="compressionType")
    def compression_type(self) -> Optional[str]:
        """
        Set to compress target files. Defaults to `NONE`. Valid values are `GZIP` and `NONE`.
        """
        return pulumi.get(self, "compression_type")

    @property
    @pulumi.getter(name="csvDelimiter")
    def csv_delimiter(self) -> Optional[str]:
        """
        Delimiter used to separate columns in the source files. Defaults to `,`.
        """
        return pulumi.get(self, "csv_delimiter")

    @property
    @pulumi.getter(name="csvRowDelimiter")
    def csv_row_delimiter(self) -> Optional[str]:
        """
        Delimiter used to separate rows in the source files. Defaults to `\n`.
        """
        return pulumi.get(self, "csv_row_delimiter")

    @property
    @pulumi.getter(name="dataFormat")
    def data_format(self) -> Optional[str]:
        """
        The output format for the files that AWS DMS uses to create S3 objects. Defaults to `csv`. Valid values are `csv` and `parquet`.
        """
        return pulumi.get(self, "data_format")

    @property
    @pulumi.getter(name="datePartitionEnabled")
    def date_partition_enabled(self) -> Optional[bool]:
        """
        Partition S3 bucket folders based on transaction commit dates. Defaults to `false`.
        """
        return pulumi.get(self, "date_partition_enabled")

    @property
    @pulumi.getter(name="encryptionMode")
    def encryption_mode(self) -> Optional[str]:
        """
        The server-side encryption mode that you want to encrypt your .csv or .parquet object files copied to S3. Defaults to `SSE_S3`. Valid values are `SSE_S3` and `SSE_KMS`.
        """
        return pulumi.get(self, "encryption_mode")

    @property
    @pulumi.getter(name="externalTableDefinition")
    def external_table_definition(self) -> Optional[str]:
        """
        JSON document that describes how AWS DMS should interpret the data.
        """
        return pulumi.get(self, "external_table_definition")

    @property
    @pulumi.getter(name="parquetTimestampInMillisecond")
    def parquet_timestamp_in_millisecond(self) -> Optional[bool]:
        """
        - Specifies the precision of any TIMESTAMP column values written to an S3 object file in .parquet format. Defaults to `false`.
        """
        return pulumi.get(self, "parquet_timestamp_in_millisecond")

    @property
    @pulumi.getter(name="parquetVersion")
    def parquet_version(self) -> Optional[str]:
        """
        The version of the .parquet file format. Defaults to `parquet-1-0`. Valid values are `parquet-1-0` and `parquet-2-0`.
        """
        return pulumi.get(self, "parquet_version")

    @property
    @pulumi.getter(name="serverSideEncryptionKmsKeyId")
    def server_side_encryption_kms_key_id(self) -> Optional[str]:
        """
        If you set encryptionMode to `SSE_KMS`, set this parameter to the Amazon Resource Name (ARN) for the AWS KMS key.
        """
        return pulumi.get(self, "server_side_encryption_kms_key_id")

    @property
    @pulumi.getter(name="serviceAccessRoleArn")
    def service_access_role_arn(self) -> Optional[str]:
        """
        Amazon Resource Name (ARN) of the IAM Role with permissions to read from or write to the S3 Bucket.
        """
        return pulumi.get(self, "service_access_role_arn")


