# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ConnectionConfirmationArgs', 'ConnectionConfirmation']

@pulumi.input_type
class ConnectionConfirmationArgs:
    def __init__(__self__, *,
                 connection_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a ConnectionConfirmation resource.
        :param pulumi.Input[str] connection_id: The ID of the hosted connection.
        """
        pulumi.set(__self__, "connection_id", connection_id)

    @property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> pulumi.Input[str]:
        """
        The ID of the hosted connection.
        """
        return pulumi.get(self, "connection_id")

    @connection_id.setter
    def connection_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "connection_id", value)


@pulumi.input_type
class _ConnectionConfirmationState:
    def __init__(__self__, *,
                 connection_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ConnectionConfirmation resources.
        :param pulumi.Input[str] connection_id: The ID of the hosted connection.
        """
        if connection_id is not None:
            pulumi.set(__self__, "connection_id", connection_id)

    @property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the hosted connection.
        """
        return pulumi.get(self, "connection_id")

    @connection_id.setter
    def connection_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_id", value)


class ConnectionConfirmation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a confirmation of the creation of the specified hosted connection on an interconnect.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        confirmation = aws.directconnect.ConnectionConfirmation("confirmation", connection_id="dxcon-ffabc123")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] connection_id: The ID of the hosted connection.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConnectionConfirmationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a confirmation of the creation of the specified hosted connection on an interconnect.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        confirmation = aws.directconnect.ConnectionConfirmation("confirmation", connection_id="dxcon-ffabc123")
        ```

        :param str resource_name: The name of the resource.
        :param ConnectionConfirmationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConnectionConfirmationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConnectionConfirmationArgs.__new__(ConnectionConfirmationArgs)

            if connection_id is None and not opts.urn:
                raise TypeError("Missing required property 'connection_id'")
            __props__.__dict__["connection_id"] = connection_id
        super(ConnectionConfirmation, __self__).__init__(
            'aws:directconnect/connectionConfirmation:ConnectionConfirmation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            connection_id: Optional[pulumi.Input[str]] = None) -> 'ConnectionConfirmation':
        """
        Get an existing ConnectionConfirmation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] connection_id: The ID of the hosted connection.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConnectionConfirmationState.__new__(_ConnectionConfirmationState)

        __props__.__dict__["connection_id"] = connection_id
        return ConnectionConfirmation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> pulumi.Output[str]:
        """
        The ID of the hosted connection.
        """
        return pulumi.get(self, "connection_id")

