# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'BotAssociationLexBot',
    'HoursOfOperationConfig',
    'HoursOfOperationConfigEndTime',
    'HoursOfOperationConfigStartTime',
    'QueueOutboundCallerConfig',
    'QuickConnectQuickConnectConfig',
    'QuickConnectQuickConnectConfigPhoneConfig',
    'QuickConnectQuickConnectConfigQueueConfig',
    'QuickConnectQuickConnectConfigUserConfig',
    'GetBotAssociationLexBotResult',
    'GetHoursOfOperationConfigResult',
    'GetHoursOfOperationConfigEndTimeResult',
    'GetHoursOfOperationConfigStartTimeResult',
    'GetQuickConnectQuickConnectConfigResult',
    'GetQuickConnectQuickConnectConfigPhoneConfigResult',
    'GetQuickConnectQuickConnectConfigQueueConfigResult',
    'GetQuickConnectQuickConnectConfigUserConfigResult',
]

@pulumi.output_type
class BotAssociationLexBot(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lexRegion":
            suggest = "lex_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotAssociationLexBot. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotAssociationLexBot.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotAssociationLexBot.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 lex_region: Optional[str] = None):
        """
        :param str name: The name of the Amazon Lex (V1) bot.
        :param str lex_region: The Region that the Amazon Lex (V1) bot was created in. Defaults to current region.
        """
        pulumi.set(__self__, "name", name)
        if lex_region is not None:
            pulumi.set(__self__, "lex_region", lex_region)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Amazon Lex (V1) bot.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="lexRegion")
    def lex_region(self) -> Optional[str]:
        """
        The Region that the Amazon Lex (V1) bot was created in. Defaults to current region.
        """
        return pulumi.get(self, "lex_region")


@pulumi.output_type
class HoursOfOperationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HoursOfOperationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HoursOfOperationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HoursOfOperationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day: str,
                 end_time: 'outputs.HoursOfOperationConfigEndTime',
                 start_time: 'outputs.HoursOfOperationConfigStartTime'):
        """
        :param str day: Specifies the day that the hours of operation applies to.
        :param 'HoursOfOperationConfigEndTimeArgs' end_time: A end time block specifies the time that your contact center closes. The `end_time` is documented below.
        :param 'HoursOfOperationConfigStartTimeArgs' start_time: A start time block specifies the time that your contact center opens. The `start_time` is documented below.
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter
    def day(self) -> str:
        """
        Specifies the day that the hours of operation applies to.
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> 'outputs.HoursOfOperationConfigEndTime':
        """
        A end time block specifies the time that your contact center closes. The `end_time` is documented below.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> 'outputs.HoursOfOperationConfigStartTime':
        """
        A start time block specifies the time that your contact center opens. The `start_time` is documented below.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class HoursOfOperationConfigEndTime(dict):
    def __init__(__self__, *,
                 hours: int,
                 minutes: int):
        """
        :param int hours: Specifies the hour of closing.
        :param int minutes: Specifies the minute of closing.
        """
        pulumi.set(__self__, "hours", hours)
        pulumi.set(__self__, "minutes", minutes)

    @property
    @pulumi.getter
    def hours(self) -> int:
        """
        Specifies the hour of closing.
        """
        return pulumi.get(self, "hours")

    @property
    @pulumi.getter
    def minutes(self) -> int:
        """
        Specifies the minute of closing.
        """
        return pulumi.get(self, "minutes")


@pulumi.output_type
class HoursOfOperationConfigStartTime(dict):
    def __init__(__self__, *,
                 hours: int,
                 minutes: int):
        """
        :param int hours: Specifies the hour of opening.
        :param int minutes: Specifies the minute of opening.
        """
        pulumi.set(__self__, "hours", hours)
        pulumi.set(__self__, "minutes", minutes)

    @property
    @pulumi.getter
    def hours(self) -> int:
        """
        Specifies the hour of opening.
        """
        return pulumi.get(self, "hours")

    @property
    @pulumi.getter
    def minutes(self) -> int:
        """
        Specifies the minute of opening.
        """
        return pulumi.get(self, "minutes")


@pulumi.output_type
class QueueOutboundCallerConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "outboundCallerIdName":
            suggest = "outbound_caller_id_name"
        elif key == "outboundCallerIdNumberId":
            suggest = "outbound_caller_id_number_id"
        elif key == "outboundFlowId":
            suggest = "outbound_flow_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QueueOutboundCallerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QueueOutboundCallerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QueueOutboundCallerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 outbound_caller_id_name: Optional[str] = None,
                 outbound_caller_id_number_id: Optional[str] = None,
                 outbound_flow_id: Optional[str] = None):
        """
        :param str outbound_caller_id_name: Specifies the caller ID name.
        :param str outbound_caller_id_number_id: Specifies the caller ID number.
        :param str outbound_flow_id: Specifies outbound whisper flow to be used during an outbound call.
        """
        if outbound_caller_id_name is not None:
            pulumi.set(__self__, "outbound_caller_id_name", outbound_caller_id_name)
        if outbound_caller_id_number_id is not None:
            pulumi.set(__self__, "outbound_caller_id_number_id", outbound_caller_id_number_id)
        if outbound_flow_id is not None:
            pulumi.set(__self__, "outbound_flow_id", outbound_flow_id)

    @property
    @pulumi.getter(name="outboundCallerIdName")
    def outbound_caller_id_name(self) -> Optional[str]:
        """
        Specifies the caller ID name.
        """
        return pulumi.get(self, "outbound_caller_id_name")

    @property
    @pulumi.getter(name="outboundCallerIdNumberId")
    def outbound_caller_id_number_id(self) -> Optional[str]:
        """
        Specifies the caller ID number.
        """
        return pulumi.get(self, "outbound_caller_id_number_id")

    @property
    @pulumi.getter(name="outboundFlowId")
    def outbound_flow_id(self) -> Optional[str]:
        """
        Specifies outbound whisper flow to be used during an outbound call.
        """
        return pulumi.get(self, "outbound_flow_id")


@pulumi.output_type
class QuickConnectQuickConnectConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "quickConnectType":
            suggest = "quick_connect_type"
        elif key == "phoneConfigs":
            suggest = "phone_configs"
        elif key == "queueConfigs":
            suggest = "queue_configs"
        elif key == "userConfigs":
            suggest = "user_configs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QuickConnectQuickConnectConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QuickConnectQuickConnectConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QuickConnectQuickConnectConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 quick_connect_type: str,
                 phone_configs: Optional[Sequence['outputs.QuickConnectQuickConnectConfigPhoneConfig']] = None,
                 queue_configs: Optional[Sequence['outputs.QuickConnectQuickConnectConfigQueueConfig']] = None,
                 user_configs: Optional[Sequence['outputs.QuickConnectQuickConnectConfigUserConfig']] = None):
        """
        :param str quick_connect_type: Specifies the configuration type of the quick connect. valid values are `PHONE_NUMBER`, `QUEUE`, `USER`.
        :param Sequence['QuickConnectQuickConnectConfigPhoneConfigArgs'] phone_configs: Specifies the phone configuration of the Quick Connect. This is required only if `quick_connect_type` is `PHONE_NUMBER`. The `phone_config` block is documented below.
        :param Sequence['QuickConnectQuickConnectConfigQueueConfigArgs'] queue_configs: Specifies the queue configuration of the Quick Connect. This is required only if `quick_connect_type` is `QUEUE`. The `queue_config` block is documented below.
        :param Sequence['QuickConnectQuickConnectConfigUserConfigArgs'] user_configs: Specifies the user configuration of the Quick Connect. This is required only if `quick_connect_type` is `USER`. The `user_config` block is documented below.
        """
        pulumi.set(__self__, "quick_connect_type", quick_connect_type)
        if phone_configs is not None:
            pulumi.set(__self__, "phone_configs", phone_configs)
        if queue_configs is not None:
            pulumi.set(__self__, "queue_configs", queue_configs)
        if user_configs is not None:
            pulumi.set(__self__, "user_configs", user_configs)

    @property
    @pulumi.getter(name="quickConnectType")
    def quick_connect_type(self) -> str:
        """
        Specifies the configuration type of the quick connect. valid values are `PHONE_NUMBER`, `QUEUE`, `USER`.
        """
        return pulumi.get(self, "quick_connect_type")

    @property
    @pulumi.getter(name="phoneConfigs")
    def phone_configs(self) -> Optional[Sequence['outputs.QuickConnectQuickConnectConfigPhoneConfig']]:
        """
        Specifies the phone configuration of the Quick Connect. This is required only if `quick_connect_type` is `PHONE_NUMBER`. The `phone_config` block is documented below.
        """
        return pulumi.get(self, "phone_configs")

    @property
    @pulumi.getter(name="queueConfigs")
    def queue_configs(self) -> Optional[Sequence['outputs.QuickConnectQuickConnectConfigQueueConfig']]:
        """
        Specifies the queue configuration of the Quick Connect. This is required only if `quick_connect_type` is `QUEUE`. The `queue_config` block is documented below.
        """
        return pulumi.get(self, "queue_configs")

    @property
    @pulumi.getter(name="userConfigs")
    def user_configs(self) -> Optional[Sequence['outputs.QuickConnectQuickConnectConfigUserConfig']]:
        """
        Specifies the user configuration of the Quick Connect. This is required only if `quick_connect_type` is `USER`. The `user_config` block is documented below.
        """
        return pulumi.get(self, "user_configs")


@pulumi.output_type
class QuickConnectQuickConnectConfigPhoneConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "phoneNumber":
            suggest = "phone_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QuickConnectQuickConnectConfigPhoneConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QuickConnectQuickConnectConfigPhoneConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QuickConnectQuickConnectConfigPhoneConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 phone_number: str):
        """
        :param str phone_number: Specifies the phone number in in E.164 format.
        """
        pulumi.set(__self__, "phone_number", phone_number)

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> str:
        """
        Specifies the phone number in in E.164 format.
        """
        return pulumi.get(self, "phone_number")


@pulumi.output_type
class QuickConnectQuickConnectConfigQueueConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contactFlowId":
            suggest = "contact_flow_id"
        elif key == "queueId":
            suggest = "queue_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QuickConnectQuickConnectConfigQueueConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QuickConnectQuickConnectConfigQueueConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QuickConnectQuickConnectConfigQueueConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 contact_flow_id: str,
                 queue_id: str):
        """
        :param str contact_flow_id: Specifies the identifier of the contact flow.
        :param str queue_id: Specifies the identifier for the queue.
        """
        pulumi.set(__self__, "contact_flow_id", contact_flow_id)
        pulumi.set(__self__, "queue_id", queue_id)

    @property
    @pulumi.getter(name="contactFlowId")
    def contact_flow_id(self) -> str:
        """
        Specifies the identifier of the contact flow.
        """
        return pulumi.get(self, "contact_flow_id")

    @property
    @pulumi.getter(name="queueId")
    def queue_id(self) -> str:
        """
        Specifies the identifier for the queue.
        """
        return pulumi.get(self, "queue_id")


@pulumi.output_type
class QuickConnectQuickConnectConfigUserConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contactFlowId":
            suggest = "contact_flow_id"
        elif key == "userId":
            suggest = "user_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QuickConnectQuickConnectConfigUserConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QuickConnectQuickConnectConfigUserConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QuickConnectQuickConnectConfigUserConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 contact_flow_id: str,
                 user_id: str):
        """
        :param str contact_flow_id: Specifies the identifier of the contact flow.
        :param str user_id: Specifies the identifier for the user.
        """
        pulumi.set(__self__, "contact_flow_id", contact_flow_id)
        pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="contactFlowId")
    def contact_flow_id(self) -> str:
        """
        Specifies the identifier of the contact flow.
        """
        return pulumi.get(self, "contact_flow_id")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> str:
        """
        Specifies the identifier for the user.
        """
        return pulumi.get(self, "user_id")


@pulumi.output_type
class GetBotAssociationLexBotResult(dict):
    def __init__(__self__, *,
                 lex_region: str,
                 name: str):
        """
        :param str lex_region: The Region that the Amazon Lex (V1) bot was created in.
        :param str name: The name of the Amazon Lex (V1) bot.
        """
        pulumi.set(__self__, "lex_region", lex_region)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="lexRegion")
    def lex_region(self) -> str:
        """
        The Region that the Amazon Lex (V1) bot was created in.
        """
        return pulumi.get(self, "lex_region")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Amazon Lex (V1) bot.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetHoursOfOperationConfigResult(dict):
    def __init__(__self__, *,
                 day: str,
                 end_times: Sequence['outputs.GetHoursOfOperationConfigEndTimeResult'],
                 start_times: Sequence['outputs.GetHoursOfOperationConfigStartTimeResult']):
        """
        :param str day: Specifies the day that the hours of operation applies to.
        :param Sequence['GetHoursOfOperationConfigEndTimeArgs'] end_times: A end time block specifies the time that your contact center closes. The `end_time` is documented below.
        :param Sequence['GetHoursOfOperationConfigStartTimeArgs'] start_times: A start time block specifies the time that your contact center opens. The `start_time` is documented below.
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "end_times", end_times)
        pulumi.set(__self__, "start_times", start_times)

    @property
    @pulumi.getter
    def day(self) -> str:
        """
        Specifies the day that the hours of operation applies to.
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter(name="endTimes")
    def end_times(self) -> Sequence['outputs.GetHoursOfOperationConfigEndTimeResult']:
        """
        A end time block specifies the time that your contact center closes. The `end_time` is documented below.
        """
        return pulumi.get(self, "end_times")

    @property
    @pulumi.getter(name="startTimes")
    def start_times(self) -> Sequence['outputs.GetHoursOfOperationConfigStartTimeResult']:
        """
        A start time block specifies the time that your contact center opens. The `start_time` is documented below.
        """
        return pulumi.get(self, "start_times")


@pulumi.output_type
class GetHoursOfOperationConfigEndTimeResult(dict):
    def __init__(__self__, *,
                 hours: int,
                 minutes: int):
        """
        :param int hours: Specifies the hour of opening.
        :param int minutes: Specifies the minute of opening.
        """
        pulumi.set(__self__, "hours", hours)
        pulumi.set(__self__, "minutes", minutes)

    @property
    @pulumi.getter
    def hours(self) -> int:
        """
        Specifies the hour of opening.
        """
        return pulumi.get(self, "hours")

    @property
    @pulumi.getter
    def minutes(self) -> int:
        """
        Specifies the minute of opening.
        """
        return pulumi.get(self, "minutes")


@pulumi.output_type
class GetHoursOfOperationConfigStartTimeResult(dict):
    def __init__(__self__, *,
                 hours: int,
                 minutes: int):
        """
        :param int hours: Specifies the hour of opening.
        :param int minutes: Specifies the minute of opening.
        """
        pulumi.set(__self__, "hours", hours)
        pulumi.set(__self__, "minutes", minutes)

    @property
    @pulumi.getter
    def hours(self) -> int:
        """
        Specifies the hour of opening.
        """
        return pulumi.get(self, "hours")

    @property
    @pulumi.getter
    def minutes(self) -> int:
        """
        Specifies the minute of opening.
        """
        return pulumi.get(self, "minutes")


@pulumi.output_type
class GetQuickConnectQuickConnectConfigResult(dict):
    def __init__(__self__, *,
                 phone_configs: Sequence['outputs.GetQuickConnectQuickConnectConfigPhoneConfigResult'],
                 queue_configs: Sequence['outputs.GetQuickConnectQuickConnectConfigQueueConfigResult'],
                 quick_connect_type: str,
                 user_configs: Sequence['outputs.GetQuickConnectQuickConnectConfigUserConfigResult']):
        """
        :param Sequence['GetQuickConnectQuickConnectConfigPhoneConfigArgs'] phone_configs: Specifies the phone configuration of the Quick Connect. This is returned only if `quick_connect_type` is `PHONE_NUMBER`. The `phone_config` block is documented below.
        :param Sequence['GetQuickConnectQuickConnectConfigQueueConfigArgs'] queue_configs: Specifies the queue configuration of the Quick Connect. This is returned only if `quick_connect_type` is `QUEUE`. The `queue_config` block is documented below.
        :param str quick_connect_type: Specifies the configuration type of the Quick Connect. Valid values are `PHONE_NUMBER`, `QUEUE`, `USER`.
        :param Sequence['GetQuickConnectQuickConnectConfigUserConfigArgs'] user_configs: Specifies the user configuration of the Quick Connect. This is returned only if `quick_connect_type` is `USER`. The `user_config` block is documented below.
        """
        pulumi.set(__self__, "phone_configs", phone_configs)
        pulumi.set(__self__, "queue_configs", queue_configs)
        pulumi.set(__self__, "quick_connect_type", quick_connect_type)
        pulumi.set(__self__, "user_configs", user_configs)

    @property
    @pulumi.getter(name="phoneConfigs")
    def phone_configs(self) -> Sequence['outputs.GetQuickConnectQuickConnectConfigPhoneConfigResult']:
        """
        Specifies the phone configuration of the Quick Connect. This is returned only if `quick_connect_type` is `PHONE_NUMBER`. The `phone_config` block is documented below.
        """
        return pulumi.get(self, "phone_configs")

    @property
    @pulumi.getter(name="queueConfigs")
    def queue_configs(self) -> Sequence['outputs.GetQuickConnectQuickConnectConfigQueueConfigResult']:
        """
        Specifies the queue configuration of the Quick Connect. This is returned only if `quick_connect_type` is `QUEUE`. The `queue_config` block is documented below.
        """
        return pulumi.get(self, "queue_configs")

    @property
    @pulumi.getter(name="quickConnectType")
    def quick_connect_type(self) -> str:
        """
        Specifies the configuration type of the Quick Connect. Valid values are `PHONE_NUMBER`, `QUEUE`, `USER`.
        """
        return pulumi.get(self, "quick_connect_type")

    @property
    @pulumi.getter(name="userConfigs")
    def user_configs(self) -> Sequence['outputs.GetQuickConnectQuickConnectConfigUserConfigResult']:
        """
        Specifies the user configuration of the Quick Connect. This is returned only if `quick_connect_type` is `USER`. The `user_config` block is documented below.
        """
        return pulumi.get(self, "user_configs")


@pulumi.output_type
class GetQuickConnectQuickConnectConfigPhoneConfigResult(dict):
    def __init__(__self__, *,
                 phone_number: str):
        """
        :param str phone_number: Specifies the phone number in in E.164 format.
        """
        pulumi.set(__self__, "phone_number", phone_number)

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> str:
        """
        Specifies the phone number in in E.164 format.
        """
        return pulumi.get(self, "phone_number")


@pulumi.output_type
class GetQuickConnectQuickConnectConfigQueueConfigResult(dict):
    def __init__(__self__, *,
                 contact_flow_id: str,
                 queue_id: str):
        """
        :param str contact_flow_id: Specifies the identifier of the contact flow.
        :param str queue_id: Specifies the identifier for the queue.
        """
        pulumi.set(__self__, "contact_flow_id", contact_flow_id)
        pulumi.set(__self__, "queue_id", queue_id)

    @property
    @pulumi.getter(name="contactFlowId")
    def contact_flow_id(self) -> str:
        """
        Specifies the identifier of the contact flow.
        """
        return pulumi.get(self, "contact_flow_id")

    @property
    @pulumi.getter(name="queueId")
    def queue_id(self) -> str:
        """
        Specifies the identifier for the queue.
        """
        return pulumi.get(self, "queue_id")


@pulumi.output_type
class GetQuickConnectQuickConnectConfigUserConfigResult(dict):
    def __init__(__self__, *,
                 contact_flow_id: str,
                 user_id: str):
        """
        :param str contact_flow_id: Specifies the identifier of the contact flow.
        :param str user_id: Specifies the identifier for the user.
        """
        pulumi.set(__self__, "contact_flow_id", contact_flow_id)
        pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="contactFlowId")
    def contact_flow_id(self) -> str:
        """
        Specifies the identifier of the contact flow.
        """
        return pulumi.get(self, "contact_flow_id")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> str:
        """
        Specifies the identifier for the user.
        """
        return pulumi.get(self, "user_id")


