# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['VoiceConnectorArgs', 'VoiceConnector']

@pulumi.input_type
class VoiceConnectorArgs:
    def __init__(__self__, *,
                 require_encryption: pulumi.Input[bool],
                 aws_region: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a VoiceConnector resource.
        :param pulumi.Input[bool] require_encryption: When enabled, requires encryption for the Amazon Chime Voice Connector.
        :param pulumi.Input[str] aws_region: The AWS Region in which the Amazon Chime Voice Connector is created. Default value: `us-east-1`
        :param pulumi.Input[str] name: The name of the Amazon Chime Voice Connector.
        """
        pulumi.set(__self__, "require_encryption", require_encryption)
        if aws_region is not None:
            pulumi.set(__self__, "aws_region", aws_region)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="requireEncryption")
    def require_encryption(self) -> pulumi.Input[bool]:
        """
        When enabled, requires encryption for the Amazon Chime Voice Connector.
        """
        return pulumi.get(self, "require_encryption")

    @require_encryption.setter
    def require_encryption(self, value: pulumi.Input[bool]):
        pulumi.set(self, "require_encryption", value)

    @property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS Region in which the Amazon Chime Voice Connector is created. Default value: `us-east-1`
        """
        return pulumi.get(self, "aws_region")

    @aws_region.setter
    def aws_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aws_region", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Amazon Chime Voice Connector.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _VoiceConnectorState:
    def __init__(__self__, *,
                 aws_region: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 outbound_host_name: Optional[pulumi.Input[str]] = None,
                 require_encryption: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering VoiceConnector resources.
        :param pulumi.Input[str] aws_region: The AWS Region in which the Amazon Chime Voice Connector is created. Default value: `us-east-1`
        :param pulumi.Input[str] name: The name of the Amazon Chime Voice Connector.
        :param pulumi.Input[str] outbound_host_name: The outbound host name for the Amazon Chime Voice Connector.
        :param pulumi.Input[bool] require_encryption: When enabled, requires encryption for the Amazon Chime Voice Connector.
        """
        if aws_region is not None:
            pulumi.set(__self__, "aws_region", aws_region)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if outbound_host_name is not None:
            pulumi.set(__self__, "outbound_host_name", outbound_host_name)
        if require_encryption is not None:
            pulumi.set(__self__, "require_encryption", require_encryption)

    @property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS Region in which the Amazon Chime Voice Connector is created. Default value: `us-east-1`
        """
        return pulumi.get(self, "aws_region")

    @aws_region.setter
    def aws_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aws_region", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Amazon Chime Voice Connector.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="outboundHostName")
    def outbound_host_name(self) -> Optional[pulumi.Input[str]]:
        """
        The outbound host name for the Amazon Chime Voice Connector.
        """
        return pulumi.get(self, "outbound_host_name")

    @outbound_host_name.setter
    def outbound_host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "outbound_host_name", value)

    @property
    @pulumi.getter(name="requireEncryption")
    def require_encryption(self) -> Optional[pulumi.Input[bool]]:
        """
        When enabled, requires encryption for the Amazon Chime Voice Connector.
        """
        return pulumi.get(self, "require_encryption")

    @require_encryption.setter
    def require_encryption(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_encryption", value)


class VoiceConnector(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_region: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 require_encryption: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Enables you to connect your phone system to the telephone network at a substantial cost savings by using SIP trunking.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.chime.VoiceConnector("test",
            aws_region="us-east-1",
            require_encryption=True)
        ```

        ## Import

        Configuration Recorder can be imported using the name, e.g.,

        ```sh
         $ pulumi import aws:chime/voiceConnector:VoiceConnector test example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] aws_region: The AWS Region in which the Amazon Chime Voice Connector is created. Default value: `us-east-1`
        :param pulumi.Input[str] name: The name of the Amazon Chime Voice Connector.
        :param pulumi.Input[bool] require_encryption: When enabled, requires encryption for the Amazon Chime Voice Connector.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VoiceConnectorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Enables you to connect your phone system to the telephone network at a substantial cost savings by using SIP trunking.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.chime.VoiceConnector("test",
            aws_region="us-east-1",
            require_encryption=True)
        ```

        ## Import

        Configuration Recorder can be imported using the name, e.g.,

        ```sh
         $ pulumi import aws:chime/voiceConnector:VoiceConnector test example
        ```

        :param str resource_name: The name of the resource.
        :param VoiceConnectorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VoiceConnectorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_region: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 require_encryption: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VoiceConnectorArgs.__new__(VoiceConnectorArgs)

            __props__.__dict__["aws_region"] = aws_region
            __props__.__dict__["name"] = name
            if require_encryption is None and not opts.urn:
                raise TypeError("Missing required property 'require_encryption'")
            __props__.__dict__["require_encryption"] = require_encryption
            __props__.__dict__["outbound_host_name"] = None
        super(VoiceConnector, __self__).__init__(
            'aws:chime/voiceConnector:VoiceConnector',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aws_region: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            outbound_host_name: Optional[pulumi.Input[str]] = None,
            require_encryption: Optional[pulumi.Input[bool]] = None) -> 'VoiceConnector':
        """
        Get an existing VoiceConnector resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] aws_region: The AWS Region in which the Amazon Chime Voice Connector is created. Default value: `us-east-1`
        :param pulumi.Input[str] name: The name of the Amazon Chime Voice Connector.
        :param pulumi.Input[str] outbound_host_name: The outbound host name for the Amazon Chime Voice Connector.
        :param pulumi.Input[bool] require_encryption: When enabled, requires encryption for the Amazon Chime Voice Connector.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VoiceConnectorState.__new__(_VoiceConnectorState)

        __props__.__dict__["aws_region"] = aws_region
        __props__.__dict__["name"] = name
        __props__.__dict__["outbound_host_name"] = outbound_host_name
        __props__.__dict__["require_encryption"] = require_encryption
        return VoiceConnector(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> pulumi.Output[Optional[str]]:
        """
        The AWS Region in which the Amazon Chime Voice Connector is created. Default value: `us-east-1`
        """
        return pulumi.get(self, "aws_region")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Amazon Chime Voice Connector.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outboundHostName")
    def outbound_host_name(self) -> pulumi.Output[str]:
        """
        The outbound host name for the Amazon Chime Voice Connector.
        """
        return pulumi.get(self, "outbound_host_name")

    @property
    @pulumi.getter(name="requireEncryption")
    def require_encryption(self) -> pulumi.Output[bool]:
        """
        When enabled, requires encryption for the Amazon Chime Voice Connector.
        """
        return pulumi.get(self, "require_encryption")

