# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'DataSourceDynamodbConfig',
    'DataSourceDynamodbConfigDeltaSyncConfig',
    'DataSourceElasticsearchConfig',
    'DataSourceHttpConfig',
    'DataSourceHttpConfigAuthorizationConfig',
    'DataSourceHttpConfigAuthorizationConfigAwsIamConfig',
    'DataSourceLambdaConfig',
    'DataSourceRelationalDatabaseConfig',
    'DataSourceRelationalDatabaseConfigHttpEndpointConfig',
    'FunctionSyncConfig',
    'FunctionSyncConfigLambdaConflictHandlerConfig',
    'GraphQLApiAdditionalAuthenticationProvider',
    'GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfig',
    'GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfig',
    'GraphQLApiAdditionalAuthenticationProviderUserPoolConfig',
    'GraphQLApiLambdaAuthorizerConfig',
    'GraphQLApiLogConfig',
    'GraphQLApiOpenidConnectConfig',
    'GraphQLApiUserPoolConfig',
    'ResolverCachingConfig',
    'ResolverPipelineConfig',
    'ResolverSyncConfig',
    'ResolverSyncConfigLambdaConflictHandlerConfig',
]

@pulumi.output_type
class DataSourceDynamodbConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tableName":
            suggest = "table_name"
        elif key == "deltaSyncConfig":
            suggest = "delta_sync_config"
        elif key == "useCallerCredentials":
            suggest = "use_caller_credentials"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceDynamodbConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceDynamodbConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceDynamodbConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 table_name: str,
                 delta_sync_config: Optional['outputs.DataSourceDynamodbConfigDeltaSyncConfig'] = None,
                 region: Optional[str] = None,
                 use_caller_credentials: Optional[bool] = None,
                 versioned: Optional[bool] = None):
        """
        :param str table_name: Name of the DynamoDB table.
        :param str region: AWS Region for RDS HTTP endpoint. Defaults to current region.
        :param bool use_caller_credentials: Set to `true` to use Amazon Cognito credentials with this data source.
        """
        pulumi.set(__self__, "table_name", table_name)
        if delta_sync_config is not None:
            pulumi.set(__self__, "delta_sync_config", delta_sync_config)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if use_caller_credentials is not None:
            pulumi.set(__self__, "use_caller_credentials", use_caller_credentials)
        if versioned is not None:
            pulumi.set(__self__, "versioned", versioned)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> str:
        """
        Name of the DynamoDB table.
        """
        return pulumi.get(self, "table_name")

    @property
    @pulumi.getter(name="deltaSyncConfig")
    def delta_sync_config(self) -> Optional['outputs.DataSourceDynamodbConfigDeltaSyncConfig']:
        return pulumi.get(self, "delta_sync_config")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        AWS Region for RDS HTTP endpoint. Defaults to current region.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="useCallerCredentials")
    def use_caller_credentials(self) -> Optional[bool]:
        """
        Set to `true` to use Amazon Cognito credentials with this data source.
        """
        return pulumi.get(self, "use_caller_credentials")

    @property
    @pulumi.getter
    def versioned(self) -> Optional[bool]:
        return pulumi.get(self, "versioned")


@pulumi.output_type
class DataSourceDynamodbConfigDeltaSyncConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deltaSyncTableName":
            suggest = "delta_sync_table_name"
        elif key == "baseTableTtl":
            suggest = "base_table_ttl"
        elif key == "deltaSyncTableTtl":
            suggest = "delta_sync_table_ttl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceDynamodbConfigDeltaSyncConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceDynamodbConfigDeltaSyncConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceDynamodbConfigDeltaSyncConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delta_sync_table_name: str,
                 base_table_ttl: Optional[int] = None,
                 delta_sync_table_ttl: Optional[int] = None):
        pulumi.set(__self__, "delta_sync_table_name", delta_sync_table_name)
        if base_table_ttl is not None:
            pulumi.set(__self__, "base_table_ttl", base_table_ttl)
        if delta_sync_table_ttl is not None:
            pulumi.set(__self__, "delta_sync_table_ttl", delta_sync_table_ttl)

    @property
    @pulumi.getter(name="deltaSyncTableName")
    def delta_sync_table_name(self) -> str:
        return pulumi.get(self, "delta_sync_table_name")

    @property
    @pulumi.getter(name="baseTableTtl")
    def base_table_ttl(self) -> Optional[int]:
        return pulumi.get(self, "base_table_ttl")

    @property
    @pulumi.getter(name="deltaSyncTableTtl")
    def delta_sync_table_ttl(self) -> Optional[int]:
        return pulumi.get(self, "delta_sync_table_ttl")


@pulumi.output_type
class DataSourceElasticsearchConfig(dict):
    def __init__(__self__, *,
                 endpoint: str,
                 region: Optional[str] = None):
        """
        :param str endpoint: HTTP URL.
        :param str region: AWS Region for RDS HTTP endpoint. Defaults to current region.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        HTTP URL.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        AWS Region for RDS HTTP endpoint. Defaults to current region.
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class DataSourceHttpConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizationConfig":
            suggest = "authorization_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceHttpConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceHttpConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceHttpConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint: str,
                 authorization_config: Optional['outputs.DataSourceHttpConfigAuthorizationConfig'] = None):
        """
        :param str endpoint: HTTP URL.
        :param 'DataSourceHttpConfigAuthorizationConfigArgs' authorization_config: The authorization configuration in case the HTTP endpoint requires authorization. See Authorization Config.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        if authorization_config is not None:
            pulumi.set(__self__, "authorization_config", authorization_config)

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        HTTP URL.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="authorizationConfig")
    def authorization_config(self) -> Optional['outputs.DataSourceHttpConfigAuthorizationConfig']:
        """
        The authorization configuration in case the HTTP endpoint requires authorization. See Authorization Config.
        """
        return pulumi.get(self, "authorization_config")


@pulumi.output_type
class DataSourceHttpConfigAuthorizationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizationType":
            suggest = "authorization_type"
        elif key == "awsIamConfig":
            suggest = "aws_iam_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceHttpConfigAuthorizationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceHttpConfigAuthorizationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceHttpConfigAuthorizationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorization_type: Optional[str] = None,
                 aws_iam_config: Optional['outputs.DataSourceHttpConfigAuthorizationConfigAwsIamConfig'] = None):
        """
        :param str authorization_type: The authorization type that the HTTP endpoint requires. Default values is `AWS_IAM`.
        :param 'DataSourceHttpConfigAuthorizationConfigAwsIamConfigArgs' aws_iam_config: The Identity and Access Management (IAM) settings. See AWS IAM Config.
        """
        if authorization_type is not None:
            pulumi.set(__self__, "authorization_type", authorization_type)
        if aws_iam_config is not None:
            pulumi.set(__self__, "aws_iam_config", aws_iam_config)

    @property
    @pulumi.getter(name="authorizationType")
    def authorization_type(self) -> Optional[str]:
        """
        The authorization type that the HTTP endpoint requires. Default values is `AWS_IAM`.
        """
        return pulumi.get(self, "authorization_type")

    @property
    @pulumi.getter(name="awsIamConfig")
    def aws_iam_config(self) -> Optional['outputs.DataSourceHttpConfigAuthorizationConfigAwsIamConfig']:
        """
        The Identity and Access Management (IAM) settings. See AWS IAM Config.
        """
        return pulumi.get(self, "aws_iam_config")


@pulumi.output_type
class DataSourceHttpConfigAuthorizationConfigAwsIamConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "signingRegion":
            suggest = "signing_region"
        elif key == "signingServiceName":
            suggest = "signing_service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceHttpConfigAuthorizationConfigAwsIamConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceHttpConfigAuthorizationConfigAwsIamConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceHttpConfigAuthorizationConfigAwsIamConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 signing_region: Optional[str] = None,
                 signing_service_name: Optional[str] = None):
        """
        :param str signing_region: The signing Amazon Web Services Region for IAM authorization.
        :param str signing_service_name: The signing service name for IAM authorization.
        """
        if signing_region is not None:
            pulumi.set(__self__, "signing_region", signing_region)
        if signing_service_name is not None:
            pulumi.set(__self__, "signing_service_name", signing_service_name)

    @property
    @pulumi.getter(name="signingRegion")
    def signing_region(self) -> Optional[str]:
        """
        The signing Amazon Web Services Region for IAM authorization.
        """
        return pulumi.get(self, "signing_region")

    @property
    @pulumi.getter(name="signingServiceName")
    def signing_service_name(self) -> Optional[str]:
        """
        The signing service name for IAM authorization.
        """
        return pulumi.get(self, "signing_service_name")


@pulumi.output_type
class DataSourceLambdaConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "functionArn":
            suggest = "function_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceLambdaConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceLambdaConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceLambdaConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 function_arn: str):
        """
        :param str function_arn: The ARN for the Lambda function.
        """
        pulumi.set(__self__, "function_arn", function_arn)

    @property
    @pulumi.getter(name="functionArn")
    def function_arn(self) -> str:
        """
        The ARN for the Lambda function.
        """
        return pulumi.get(self, "function_arn")


@pulumi.output_type
class DataSourceRelationalDatabaseConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpEndpointConfig":
            suggest = "http_endpoint_config"
        elif key == "sourceType":
            suggest = "source_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceRelationalDatabaseConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceRelationalDatabaseConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceRelationalDatabaseConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_endpoint_config: Optional['outputs.DataSourceRelationalDatabaseConfigHttpEndpointConfig'] = None,
                 source_type: Optional[str] = None):
        """
        :param 'DataSourceRelationalDatabaseConfigHttpEndpointConfigArgs' http_endpoint_config: The Amazon RDS HTTP endpoint configuration. See HTTP Endpoint Config.
        :param str source_type: Source type for the relational database. Valid values: `RDS_HTTP_ENDPOINT`.
        """
        if http_endpoint_config is not None:
            pulumi.set(__self__, "http_endpoint_config", http_endpoint_config)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)

    @property
    @pulumi.getter(name="httpEndpointConfig")
    def http_endpoint_config(self) -> Optional['outputs.DataSourceRelationalDatabaseConfigHttpEndpointConfig']:
        """
        The Amazon RDS HTTP endpoint configuration. See HTTP Endpoint Config.
        """
        return pulumi.get(self, "http_endpoint_config")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[str]:
        """
        Source type for the relational database. Valid values: `RDS_HTTP_ENDPOINT`.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class DataSourceRelationalDatabaseConfigHttpEndpointConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsSecretStoreArn":
            suggest = "aws_secret_store_arn"
        elif key == "dbClusterIdentifier":
            suggest = "db_cluster_identifier"
        elif key == "databaseName":
            suggest = "database_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceRelationalDatabaseConfigHttpEndpointConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceRelationalDatabaseConfigHttpEndpointConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceRelationalDatabaseConfigHttpEndpointConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aws_secret_store_arn: str,
                 db_cluster_identifier: str,
                 database_name: Optional[str] = None,
                 region: Optional[str] = None,
                 schema: Optional[str] = None):
        """
        :param str aws_secret_store_arn: AWS secret store ARN for database credentials.
        :param str db_cluster_identifier: Amazon RDS cluster identifier.
        :param str database_name: Logical database name.
        :param str region: AWS Region for RDS HTTP endpoint. Defaults to current region.
        :param str schema: Logical schema name.
        """
        pulumi.set(__self__, "aws_secret_store_arn", aws_secret_store_arn)
        pulumi.set(__self__, "db_cluster_identifier", db_cluster_identifier)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)

    @property
    @pulumi.getter(name="awsSecretStoreArn")
    def aws_secret_store_arn(self) -> str:
        """
        AWS secret store ARN for database credentials.
        """
        return pulumi.get(self, "aws_secret_store_arn")

    @property
    @pulumi.getter(name="dbClusterIdentifier")
    def db_cluster_identifier(self) -> str:
        """
        Amazon RDS cluster identifier.
        """
        return pulumi.get(self, "db_cluster_identifier")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[str]:
        """
        Logical database name.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        AWS Region for RDS HTTP endpoint. Defaults to current region.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def schema(self) -> Optional[str]:
        """
        Logical schema name.
        """
        return pulumi.get(self, "schema")


@pulumi.output_type
class FunctionSyncConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "conflictDetection":
            suggest = "conflict_detection"
        elif key == "conflictHandler":
            suggest = "conflict_handler"
        elif key == "lambdaConflictHandlerConfig":
            suggest = "lambda_conflict_handler_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionSyncConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionSyncConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionSyncConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 conflict_detection: Optional[str] = None,
                 conflict_handler: Optional[str] = None,
                 lambda_conflict_handler_config: Optional['outputs.FunctionSyncConfigLambdaConflictHandlerConfig'] = None):
        """
        :param str conflict_detection: The Conflict Detection strategy to use. Valid values are `NONE` and `VERSION`.
        :param str conflict_handler: The Conflict Resolution strategy to perform in the event of a conflict. Valid values are `NONE`, `OPTIMISTIC_CONCURRENCY`, `AUTOMERGE`, and `LAMBDA`.
        :param 'FunctionSyncConfigLambdaConflictHandlerConfigArgs' lambda_conflict_handler_config: The Lambda Conflict Handler Config when configuring `LAMBDA` as the Conflict Handler. See Lambda Conflict Handler Config.
        """
        if conflict_detection is not None:
            pulumi.set(__self__, "conflict_detection", conflict_detection)
        if conflict_handler is not None:
            pulumi.set(__self__, "conflict_handler", conflict_handler)
        if lambda_conflict_handler_config is not None:
            pulumi.set(__self__, "lambda_conflict_handler_config", lambda_conflict_handler_config)

    @property
    @pulumi.getter(name="conflictDetection")
    def conflict_detection(self) -> Optional[str]:
        """
        The Conflict Detection strategy to use. Valid values are `NONE` and `VERSION`.
        """
        return pulumi.get(self, "conflict_detection")

    @property
    @pulumi.getter(name="conflictHandler")
    def conflict_handler(self) -> Optional[str]:
        """
        The Conflict Resolution strategy to perform in the event of a conflict. Valid values are `NONE`, `OPTIMISTIC_CONCURRENCY`, `AUTOMERGE`, and `LAMBDA`.
        """
        return pulumi.get(self, "conflict_handler")

    @property
    @pulumi.getter(name="lambdaConflictHandlerConfig")
    def lambda_conflict_handler_config(self) -> Optional['outputs.FunctionSyncConfigLambdaConflictHandlerConfig']:
        """
        The Lambda Conflict Handler Config when configuring `LAMBDA` as the Conflict Handler. See Lambda Conflict Handler Config.
        """
        return pulumi.get(self, "lambda_conflict_handler_config")


@pulumi.output_type
class FunctionSyncConfigLambdaConflictHandlerConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lambdaConflictHandlerArn":
            suggest = "lambda_conflict_handler_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionSyncConfigLambdaConflictHandlerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionSyncConfigLambdaConflictHandlerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionSyncConfigLambdaConflictHandlerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lambda_conflict_handler_arn: Optional[str] = None):
        """
        :param str lambda_conflict_handler_arn: The Amazon Resource Name (ARN) for the Lambda function to use as the Conflict Handler.
        """
        if lambda_conflict_handler_arn is not None:
            pulumi.set(__self__, "lambda_conflict_handler_arn", lambda_conflict_handler_arn)

    @property
    @pulumi.getter(name="lambdaConflictHandlerArn")
    def lambda_conflict_handler_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) for the Lambda function to use as the Conflict Handler.
        """
        return pulumi.get(self, "lambda_conflict_handler_arn")


@pulumi.output_type
class GraphQLApiAdditionalAuthenticationProvider(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authenticationType":
            suggest = "authentication_type"
        elif key == "lambdaAuthorizerConfig":
            suggest = "lambda_authorizer_config"
        elif key == "openidConnectConfig":
            suggest = "openid_connect_config"
        elif key == "userPoolConfig":
            suggest = "user_pool_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GraphQLApiAdditionalAuthenticationProvider. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GraphQLApiAdditionalAuthenticationProvider.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GraphQLApiAdditionalAuthenticationProvider.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authentication_type: str,
                 lambda_authorizer_config: Optional['outputs.GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfig'] = None,
                 openid_connect_config: Optional['outputs.GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfig'] = None,
                 user_pool_config: Optional['outputs.GraphQLApiAdditionalAuthenticationProviderUserPoolConfig'] = None):
        """
        :param str authentication_type: The authentication type. Valid values: `API_KEY`, `AWS_IAM`, `AMAZON_COGNITO_USER_POOLS`, `OPENID_CONNECT`, `AWS_LAMBDA`
        :param 'GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfigArgs' lambda_authorizer_config: Nested argument containing Lambda authorizer configuration. Defined below.
        :param 'GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfigArgs' openid_connect_config: Nested argument containing OpenID Connect configuration. Defined below.
        :param 'GraphQLApiAdditionalAuthenticationProviderUserPoolConfigArgs' user_pool_config: The Amazon Cognito User Pool configuration. Defined below.
        """
        pulumi.set(__self__, "authentication_type", authentication_type)
        if lambda_authorizer_config is not None:
            pulumi.set(__self__, "lambda_authorizer_config", lambda_authorizer_config)
        if openid_connect_config is not None:
            pulumi.set(__self__, "openid_connect_config", openid_connect_config)
        if user_pool_config is not None:
            pulumi.set(__self__, "user_pool_config", user_pool_config)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> str:
        """
        The authentication type. Valid values: `API_KEY`, `AWS_IAM`, `AMAZON_COGNITO_USER_POOLS`, `OPENID_CONNECT`, `AWS_LAMBDA`
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter(name="lambdaAuthorizerConfig")
    def lambda_authorizer_config(self) -> Optional['outputs.GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfig']:
        """
        Nested argument containing Lambda authorizer configuration. Defined below.
        """
        return pulumi.get(self, "lambda_authorizer_config")

    @property
    @pulumi.getter(name="openidConnectConfig")
    def openid_connect_config(self) -> Optional['outputs.GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfig']:
        """
        Nested argument containing OpenID Connect configuration. Defined below.
        """
        return pulumi.get(self, "openid_connect_config")

    @property
    @pulumi.getter(name="userPoolConfig")
    def user_pool_config(self) -> Optional['outputs.GraphQLApiAdditionalAuthenticationProviderUserPoolConfig']:
        """
        The Amazon Cognito User Pool configuration. Defined below.
        """
        return pulumi.get(self, "user_pool_config")


@pulumi.output_type
class GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizerUri":
            suggest = "authorizer_uri"
        elif key == "authorizerResultTtlInSeconds":
            suggest = "authorizer_result_ttl_in_seconds"
        elif key == "identityValidationExpression":
            suggest = "identity_validation_expression"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorizer_uri: str,
                 authorizer_result_ttl_in_seconds: Optional[int] = None,
                 identity_validation_expression: Optional[str] = None):
        """
        :param str authorizer_uri: The ARN of the Lambda function to be called for authorization. Note: This Lambda function must have a resource-based policy assigned to it, to allow `lambda:InvokeFunction` from service principal `appsync.amazonaws.com`.
        :param int authorizer_result_ttl_in_seconds: The number of seconds a response should be cached for. The default is 5 minutes (300 seconds). The Lambda function can override this by returning a `ttlOverride` key in its response. A value of 0 disables caching of responses. Minimum value of 0. Maximum value of 3600.
        :param str identity_validation_expression: A regular expression for validation of tokens before the Lambda function is called.
        """
        pulumi.set(__self__, "authorizer_uri", authorizer_uri)
        if authorizer_result_ttl_in_seconds is not None:
            pulumi.set(__self__, "authorizer_result_ttl_in_seconds", authorizer_result_ttl_in_seconds)
        if identity_validation_expression is not None:
            pulumi.set(__self__, "identity_validation_expression", identity_validation_expression)

    @property
    @pulumi.getter(name="authorizerUri")
    def authorizer_uri(self) -> str:
        """
        The ARN of the Lambda function to be called for authorization. Note: This Lambda function must have a resource-based policy assigned to it, to allow `lambda:InvokeFunction` from service principal `appsync.amazonaws.com`.
        """
        return pulumi.get(self, "authorizer_uri")

    @property
    @pulumi.getter(name="authorizerResultTtlInSeconds")
    def authorizer_result_ttl_in_seconds(self) -> Optional[int]:
        """
        The number of seconds a response should be cached for. The default is 5 minutes (300 seconds). The Lambda function can override this by returning a `ttlOverride` key in its response. A value of 0 disables caching of responses. Minimum value of 0. Maximum value of 3600.
        """
        return pulumi.get(self, "authorizer_result_ttl_in_seconds")

    @property
    @pulumi.getter(name="identityValidationExpression")
    def identity_validation_expression(self) -> Optional[str]:
        """
        A regular expression for validation of tokens before the Lambda function is called.
        """
        return pulumi.get(self, "identity_validation_expression")


@pulumi.output_type
class GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authTtl":
            suggest = "auth_ttl"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "iatTtl":
            suggest = "iat_ttl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 issuer: str,
                 auth_ttl: Optional[int] = None,
                 client_id: Optional[str] = None,
                 iat_ttl: Optional[int] = None):
        """
        :param str issuer: Issuer for the OpenID Connect configuration. The issuer returned by discovery MUST exactly match the value of iss in the ID Token.
        :param int auth_ttl: Number of milliseconds a token is valid after being authenticated.
        :param str client_id: Client identifier of the Relying party at the OpenID identity provider. This identifier is typically obtained when the Relying party is registered with the OpenID identity provider. You can specify a regular expression so the AWS AppSync can validate against multiple client identifiers at a time.
        :param int iat_ttl: Number of milliseconds a token is valid after being issued to a user.
        """
        pulumi.set(__self__, "issuer", issuer)
        if auth_ttl is not None:
            pulumi.set(__self__, "auth_ttl", auth_ttl)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if iat_ttl is not None:
            pulumi.set(__self__, "iat_ttl", iat_ttl)

    @property
    @pulumi.getter
    def issuer(self) -> str:
        """
        Issuer for the OpenID Connect configuration. The issuer returned by discovery MUST exactly match the value of iss in the ID Token.
        """
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="authTtl")
    def auth_ttl(self) -> Optional[int]:
        """
        Number of milliseconds a token is valid after being authenticated.
        """
        return pulumi.get(self, "auth_ttl")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        Client identifier of the Relying party at the OpenID identity provider. This identifier is typically obtained when the Relying party is registered with the OpenID identity provider. You can specify a regular expression so the AWS AppSync can validate against multiple client identifiers at a time.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="iatTtl")
    def iat_ttl(self) -> Optional[int]:
        """
        Number of milliseconds a token is valid after being issued to a user.
        """
        return pulumi.get(self, "iat_ttl")


@pulumi.output_type
class GraphQLApiAdditionalAuthenticationProviderUserPoolConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userPoolId":
            suggest = "user_pool_id"
        elif key == "appIdClientRegex":
            suggest = "app_id_client_regex"
        elif key == "awsRegion":
            suggest = "aws_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GraphQLApiAdditionalAuthenticationProviderUserPoolConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GraphQLApiAdditionalAuthenticationProviderUserPoolConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GraphQLApiAdditionalAuthenticationProviderUserPoolConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 user_pool_id: str,
                 app_id_client_regex: Optional[str] = None,
                 aws_region: Optional[str] = None):
        """
        :param str user_pool_id: The user pool ID.
        :param str app_id_client_regex: A regular expression for validating the incoming Amazon Cognito User Pool app client ID.
        :param str aws_region: The AWS region in which the user pool was created.
        """
        pulumi.set(__self__, "user_pool_id", user_pool_id)
        if app_id_client_regex is not None:
            pulumi.set(__self__, "app_id_client_regex", app_id_client_regex)
        if aws_region is not None:
            pulumi.set(__self__, "aws_region", aws_region)

    @property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> str:
        """
        The user pool ID.
        """
        return pulumi.get(self, "user_pool_id")

    @property
    @pulumi.getter(name="appIdClientRegex")
    def app_id_client_regex(self) -> Optional[str]:
        """
        A regular expression for validating the incoming Amazon Cognito User Pool app client ID.
        """
        return pulumi.get(self, "app_id_client_regex")

    @property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> Optional[str]:
        """
        The AWS region in which the user pool was created.
        """
        return pulumi.get(self, "aws_region")


@pulumi.output_type
class GraphQLApiLambdaAuthorizerConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizerUri":
            suggest = "authorizer_uri"
        elif key == "authorizerResultTtlInSeconds":
            suggest = "authorizer_result_ttl_in_seconds"
        elif key == "identityValidationExpression":
            suggest = "identity_validation_expression"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GraphQLApiLambdaAuthorizerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GraphQLApiLambdaAuthorizerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GraphQLApiLambdaAuthorizerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorizer_uri: str,
                 authorizer_result_ttl_in_seconds: Optional[int] = None,
                 identity_validation_expression: Optional[str] = None):
        """
        :param str authorizer_uri: The ARN of the Lambda function to be called for authorization. Note: This Lambda function must have a resource-based policy assigned to it, to allow `lambda:InvokeFunction` from service principal `appsync.amazonaws.com`.
        :param int authorizer_result_ttl_in_seconds: The number of seconds a response should be cached for. The default is 5 minutes (300 seconds). The Lambda function can override this by returning a `ttlOverride` key in its response. A value of 0 disables caching of responses. Minimum value of 0. Maximum value of 3600.
        :param str identity_validation_expression: A regular expression for validation of tokens before the Lambda function is called.
        """
        pulumi.set(__self__, "authorizer_uri", authorizer_uri)
        if authorizer_result_ttl_in_seconds is not None:
            pulumi.set(__self__, "authorizer_result_ttl_in_seconds", authorizer_result_ttl_in_seconds)
        if identity_validation_expression is not None:
            pulumi.set(__self__, "identity_validation_expression", identity_validation_expression)

    @property
    @pulumi.getter(name="authorizerUri")
    def authorizer_uri(self) -> str:
        """
        The ARN of the Lambda function to be called for authorization. Note: This Lambda function must have a resource-based policy assigned to it, to allow `lambda:InvokeFunction` from service principal `appsync.amazonaws.com`.
        """
        return pulumi.get(self, "authorizer_uri")

    @property
    @pulumi.getter(name="authorizerResultTtlInSeconds")
    def authorizer_result_ttl_in_seconds(self) -> Optional[int]:
        """
        The number of seconds a response should be cached for. The default is 5 minutes (300 seconds). The Lambda function can override this by returning a `ttlOverride` key in its response. A value of 0 disables caching of responses. Minimum value of 0. Maximum value of 3600.
        """
        return pulumi.get(self, "authorizer_result_ttl_in_seconds")

    @property
    @pulumi.getter(name="identityValidationExpression")
    def identity_validation_expression(self) -> Optional[str]:
        """
        A regular expression for validation of tokens before the Lambda function is called.
        """
        return pulumi.get(self, "identity_validation_expression")


@pulumi.output_type
class GraphQLApiLogConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudwatchLogsRoleArn":
            suggest = "cloudwatch_logs_role_arn"
        elif key == "fieldLogLevel":
            suggest = "field_log_level"
        elif key == "excludeVerboseContent":
            suggest = "exclude_verbose_content"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GraphQLApiLogConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GraphQLApiLogConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GraphQLApiLogConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloudwatch_logs_role_arn: str,
                 field_log_level: str,
                 exclude_verbose_content: Optional[bool] = None):
        """
        :param str cloudwatch_logs_role_arn: Amazon Resource Name of the service role that AWS AppSync will assume to publish to Amazon CloudWatch logs in your account.
        :param str field_log_level: Field logging level. Valid values: `ALL`, `ERROR`, `NONE`.
        :param bool exclude_verbose_content: Set to TRUE to exclude sections that contain information such as headers, context, and evaluated mapping templates, regardless of logging  level. Valid values: `true`, `false`. Default value: `false`
        """
        pulumi.set(__self__, "cloudwatch_logs_role_arn", cloudwatch_logs_role_arn)
        pulumi.set(__self__, "field_log_level", field_log_level)
        if exclude_verbose_content is not None:
            pulumi.set(__self__, "exclude_verbose_content", exclude_verbose_content)

    @property
    @pulumi.getter(name="cloudwatchLogsRoleArn")
    def cloudwatch_logs_role_arn(self) -> str:
        """
        Amazon Resource Name of the service role that AWS AppSync will assume to publish to Amazon CloudWatch logs in your account.
        """
        return pulumi.get(self, "cloudwatch_logs_role_arn")

    @property
    @pulumi.getter(name="fieldLogLevel")
    def field_log_level(self) -> str:
        """
        Field logging level. Valid values: `ALL`, `ERROR`, `NONE`.
        """
        return pulumi.get(self, "field_log_level")

    @property
    @pulumi.getter(name="excludeVerboseContent")
    def exclude_verbose_content(self) -> Optional[bool]:
        """
        Set to TRUE to exclude sections that contain information such as headers, context, and evaluated mapping templates, regardless of logging  level. Valid values: `true`, `false`. Default value: `false`
        """
        return pulumi.get(self, "exclude_verbose_content")


@pulumi.output_type
class GraphQLApiOpenidConnectConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authTtl":
            suggest = "auth_ttl"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "iatTtl":
            suggest = "iat_ttl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GraphQLApiOpenidConnectConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GraphQLApiOpenidConnectConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GraphQLApiOpenidConnectConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 issuer: str,
                 auth_ttl: Optional[int] = None,
                 client_id: Optional[str] = None,
                 iat_ttl: Optional[int] = None):
        """
        :param str issuer: Issuer for the OpenID Connect configuration. The issuer returned by discovery MUST exactly match the value of iss in the ID Token.
        :param int auth_ttl: Number of milliseconds a token is valid after being authenticated.
        :param str client_id: Client identifier of the Relying party at the OpenID identity provider. This identifier is typically obtained when the Relying party is registered with the OpenID identity provider. You can specify a regular expression so the AWS AppSync can validate against multiple client identifiers at a time.
        :param int iat_ttl: Number of milliseconds a token is valid after being issued to a user.
        """
        pulumi.set(__self__, "issuer", issuer)
        if auth_ttl is not None:
            pulumi.set(__self__, "auth_ttl", auth_ttl)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if iat_ttl is not None:
            pulumi.set(__self__, "iat_ttl", iat_ttl)

    @property
    @pulumi.getter
    def issuer(self) -> str:
        """
        Issuer for the OpenID Connect configuration. The issuer returned by discovery MUST exactly match the value of iss in the ID Token.
        """
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="authTtl")
    def auth_ttl(self) -> Optional[int]:
        """
        Number of milliseconds a token is valid after being authenticated.
        """
        return pulumi.get(self, "auth_ttl")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        Client identifier of the Relying party at the OpenID identity provider. This identifier is typically obtained when the Relying party is registered with the OpenID identity provider. You can specify a regular expression so the AWS AppSync can validate against multiple client identifiers at a time.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="iatTtl")
    def iat_ttl(self) -> Optional[int]:
        """
        Number of milliseconds a token is valid after being issued to a user.
        """
        return pulumi.get(self, "iat_ttl")


@pulumi.output_type
class GraphQLApiUserPoolConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultAction":
            suggest = "default_action"
        elif key == "userPoolId":
            suggest = "user_pool_id"
        elif key == "appIdClientRegex":
            suggest = "app_id_client_regex"
        elif key == "awsRegion":
            suggest = "aws_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GraphQLApiUserPoolConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GraphQLApiUserPoolConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GraphQLApiUserPoolConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_action: str,
                 user_pool_id: str,
                 app_id_client_regex: Optional[str] = None,
                 aws_region: Optional[str] = None):
        """
        :param str default_action: The action that you want your GraphQL API to take when a request that uses Amazon Cognito User Pool authentication doesn't match the Amazon Cognito User Pool configuration. Valid: `ALLOW` and `DENY`
        :param str user_pool_id: The user pool ID.
        :param str app_id_client_regex: A regular expression for validating the incoming Amazon Cognito User Pool app client ID.
        :param str aws_region: The AWS region in which the user pool was created.
        """
        pulumi.set(__self__, "default_action", default_action)
        pulumi.set(__self__, "user_pool_id", user_pool_id)
        if app_id_client_regex is not None:
            pulumi.set(__self__, "app_id_client_regex", app_id_client_regex)
        if aws_region is not None:
            pulumi.set(__self__, "aws_region", aws_region)

    @property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> str:
        """
        The action that you want your GraphQL API to take when a request that uses Amazon Cognito User Pool authentication doesn't match the Amazon Cognito User Pool configuration. Valid: `ALLOW` and `DENY`
        """
        return pulumi.get(self, "default_action")

    @property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> str:
        """
        The user pool ID.
        """
        return pulumi.get(self, "user_pool_id")

    @property
    @pulumi.getter(name="appIdClientRegex")
    def app_id_client_regex(self) -> Optional[str]:
        """
        A regular expression for validating the incoming Amazon Cognito User Pool app client ID.
        """
        return pulumi.get(self, "app_id_client_regex")

    @property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> Optional[str]:
        """
        The AWS region in which the user pool was created.
        """
        return pulumi.get(self, "aws_region")


@pulumi.output_type
class ResolverCachingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cachingKeys":
            suggest = "caching_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResolverCachingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResolverCachingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResolverCachingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 caching_keys: Optional[Sequence[str]] = None,
                 ttl: Optional[int] = None):
        """
        :param Sequence[str] caching_keys: The list of caching key.
        :param int ttl: The TTL in seconds.
        """
        if caching_keys is not None:
            pulumi.set(__self__, "caching_keys", caching_keys)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter(name="cachingKeys")
    def caching_keys(self) -> Optional[Sequence[str]]:
        """
        The list of caching key.
        """
        return pulumi.get(self, "caching_keys")

    @property
    @pulumi.getter
    def ttl(self) -> Optional[int]:
        """
        The TTL in seconds.
        """
        return pulumi.get(self, "ttl")


@pulumi.output_type
class ResolverPipelineConfig(dict):
    def __init__(__self__, *,
                 functions: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] functions: The list of Function ID.
        """
        if functions is not None:
            pulumi.set(__self__, "functions", functions)

    @property
    @pulumi.getter
    def functions(self) -> Optional[Sequence[str]]:
        """
        The list of Function ID.
        """
        return pulumi.get(self, "functions")


@pulumi.output_type
class ResolverSyncConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "conflictDetection":
            suggest = "conflict_detection"
        elif key == "conflictHandler":
            suggest = "conflict_handler"
        elif key == "lambdaConflictHandlerConfig":
            suggest = "lambda_conflict_handler_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResolverSyncConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResolverSyncConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResolverSyncConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 conflict_detection: Optional[str] = None,
                 conflict_handler: Optional[str] = None,
                 lambda_conflict_handler_config: Optional['outputs.ResolverSyncConfigLambdaConflictHandlerConfig'] = None):
        """
        :param str conflict_detection: The Conflict Detection strategy to use. Valid values are `NONE` and `VERSION`.
        :param str conflict_handler: The Conflict Resolution strategy to perform in the event of a conflict. Valid values are `NONE`, `OPTIMISTIC_CONCURRENCY`, `AUTOMERGE`, and `LAMBDA`.
        :param 'ResolverSyncConfigLambdaConflictHandlerConfigArgs' lambda_conflict_handler_config: The Lambda Conflict Handler Config when configuring `LAMBDA` as the Conflict Handler. See Lambda Conflict Handler Config.
        """
        if conflict_detection is not None:
            pulumi.set(__self__, "conflict_detection", conflict_detection)
        if conflict_handler is not None:
            pulumi.set(__self__, "conflict_handler", conflict_handler)
        if lambda_conflict_handler_config is not None:
            pulumi.set(__self__, "lambda_conflict_handler_config", lambda_conflict_handler_config)

    @property
    @pulumi.getter(name="conflictDetection")
    def conflict_detection(self) -> Optional[str]:
        """
        The Conflict Detection strategy to use. Valid values are `NONE` and `VERSION`.
        """
        return pulumi.get(self, "conflict_detection")

    @property
    @pulumi.getter(name="conflictHandler")
    def conflict_handler(self) -> Optional[str]:
        """
        The Conflict Resolution strategy to perform in the event of a conflict. Valid values are `NONE`, `OPTIMISTIC_CONCURRENCY`, `AUTOMERGE`, and `LAMBDA`.
        """
        return pulumi.get(self, "conflict_handler")

    @property
    @pulumi.getter(name="lambdaConflictHandlerConfig")
    def lambda_conflict_handler_config(self) -> Optional['outputs.ResolverSyncConfigLambdaConflictHandlerConfig']:
        """
        The Lambda Conflict Handler Config when configuring `LAMBDA` as the Conflict Handler. See Lambda Conflict Handler Config.
        """
        return pulumi.get(self, "lambda_conflict_handler_config")


@pulumi.output_type
class ResolverSyncConfigLambdaConflictHandlerConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lambdaConflictHandlerArn":
            suggest = "lambda_conflict_handler_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResolverSyncConfigLambdaConflictHandlerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResolverSyncConfigLambdaConflictHandlerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResolverSyncConfigLambdaConflictHandlerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lambda_conflict_handler_arn: Optional[str] = None):
        """
        :param str lambda_conflict_handler_arn: The Amazon Resource Name (ARN) for the Lambda function to use as the Conflict Handler.
        """
        if lambda_conflict_handler_arn is not None:
            pulumi.set(__self__, "lambda_conflict_handler_arn", lambda_conflict_handler_arn)

    @property
    @pulumi.getter(name="lambdaConflictHandlerArn")
    def lambda_conflict_handler_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) for the Lambda function to use as the Conflict Handler.
        """
        return pulumi.get(self, "lambda_conflict_handler_arn")


