# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DataSourceArgs', 'DataSource']

@pulumi.input_type
class DataSourceArgs:
    def __init__(__self__, *,
                 api_id: pulumi.Input[str],
                 type: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 dynamodb_config: Optional[pulumi.Input['DataSourceDynamodbConfigArgs']] = None,
                 elasticsearch_config: Optional[pulumi.Input['DataSourceElasticsearchConfigArgs']] = None,
                 http_config: Optional[pulumi.Input['DataSourceHttpConfigArgs']] = None,
                 lambda_config: Optional[pulumi.Input['DataSourceLambdaConfigArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 relational_database_config: Optional[pulumi.Input['DataSourceRelationalDatabaseConfigArgs']] = None,
                 service_role_arn: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a DataSource resource.
        :param pulumi.Input[str] api_id: The API ID for the GraphQL API for the DataSource.
        :param pulumi.Input[str] type: The type of the DataSource. Valid values: `AWS_LAMBDA`, `AMAZON_DYNAMODB`, `AMAZON_ELASTICSEARCH`, `HTTP`, `NONE`, `RELATIONAL_DATABASE`.
        :param pulumi.Input[str] description: A description of the DataSource.
        :param pulumi.Input['DataSourceDynamodbConfigArgs'] dynamodb_config: DynamoDB settings. See below
        :param pulumi.Input['DataSourceElasticsearchConfigArgs'] elasticsearch_config: Amazon Elasticsearch settings. See below
        :param pulumi.Input['DataSourceHttpConfigArgs'] http_config: HTTP settings. See below
        :param pulumi.Input['DataSourceLambdaConfigArgs'] lambda_config: AWS Lambda settings. See below
        :param pulumi.Input[str] name: A user-supplied name for the DataSource.
        :param pulumi.Input['DataSourceRelationalDatabaseConfigArgs'] relational_database_config: AWS RDS settings. See Relational Database Config
        :param pulumi.Input[str] service_role_arn: The IAM service role ARN for the data source.
        """
        pulumi.set(__self__, "api_id", api_id)
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dynamodb_config is not None:
            pulumi.set(__self__, "dynamodb_config", dynamodb_config)
        if elasticsearch_config is not None:
            pulumi.set(__self__, "elasticsearch_config", elasticsearch_config)
        if http_config is not None:
            pulumi.set(__self__, "http_config", http_config)
        if lambda_config is not None:
            pulumi.set(__self__, "lambda_config", lambda_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if relational_database_config is not None:
            pulumi.set(__self__, "relational_database_config", relational_database_config)
        if service_role_arn is not None:
            pulumi.set(__self__, "service_role_arn", service_role_arn)

    @property
    @pulumi.getter(name="apiId")
    def api_id(self) -> pulumi.Input[str]:
        """
        The API ID for the GraphQL API for the DataSource.
        """
        return pulumi.get(self, "api_id")

    @api_id.setter
    def api_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "api_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the DataSource. Valid values: `AWS_LAMBDA`, `AMAZON_DYNAMODB`, `AMAZON_ELASTICSEARCH`, `HTTP`, `NONE`, `RELATIONAL_DATABASE`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the DataSource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="dynamodbConfig")
    def dynamodb_config(self) -> Optional[pulumi.Input['DataSourceDynamodbConfigArgs']]:
        """
        DynamoDB settings. See below
        """
        return pulumi.get(self, "dynamodb_config")

    @dynamodb_config.setter
    def dynamodb_config(self, value: Optional[pulumi.Input['DataSourceDynamodbConfigArgs']]):
        pulumi.set(self, "dynamodb_config", value)

    @property
    @pulumi.getter(name="elasticsearchConfig")
    def elasticsearch_config(self) -> Optional[pulumi.Input['DataSourceElasticsearchConfigArgs']]:
        """
        Amazon Elasticsearch settings. See below
        """
        return pulumi.get(self, "elasticsearch_config")

    @elasticsearch_config.setter
    def elasticsearch_config(self, value: Optional[pulumi.Input['DataSourceElasticsearchConfigArgs']]):
        pulumi.set(self, "elasticsearch_config", value)

    @property
    @pulumi.getter(name="httpConfig")
    def http_config(self) -> Optional[pulumi.Input['DataSourceHttpConfigArgs']]:
        """
        HTTP settings. See below
        """
        return pulumi.get(self, "http_config")

    @http_config.setter
    def http_config(self, value: Optional[pulumi.Input['DataSourceHttpConfigArgs']]):
        pulumi.set(self, "http_config", value)

    @property
    @pulumi.getter(name="lambdaConfig")
    def lambda_config(self) -> Optional[pulumi.Input['DataSourceLambdaConfigArgs']]:
        """
        AWS Lambda settings. See below
        """
        return pulumi.get(self, "lambda_config")

    @lambda_config.setter
    def lambda_config(self, value: Optional[pulumi.Input['DataSourceLambdaConfigArgs']]):
        pulumi.set(self, "lambda_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A user-supplied name for the DataSource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="relationalDatabaseConfig")
    def relational_database_config(self) -> Optional[pulumi.Input['DataSourceRelationalDatabaseConfigArgs']]:
        """
        AWS RDS settings. See Relational Database Config
        """
        return pulumi.get(self, "relational_database_config")

    @relational_database_config.setter
    def relational_database_config(self, value: Optional[pulumi.Input['DataSourceRelationalDatabaseConfigArgs']]):
        pulumi.set(self, "relational_database_config", value)

    @property
    @pulumi.getter(name="serviceRoleArn")
    def service_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The IAM service role ARN for the data source.
        """
        return pulumi.get(self, "service_role_arn")

    @service_role_arn.setter
    def service_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_role_arn", value)


@pulumi.input_type
class _DataSourceState:
    def __init__(__self__, *,
                 api_id: Optional[pulumi.Input[str]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dynamodb_config: Optional[pulumi.Input['DataSourceDynamodbConfigArgs']] = None,
                 elasticsearch_config: Optional[pulumi.Input['DataSourceElasticsearchConfigArgs']] = None,
                 http_config: Optional[pulumi.Input['DataSourceHttpConfigArgs']] = None,
                 lambda_config: Optional[pulumi.Input['DataSourceLambdaConfigArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 relational_database_config: Optional[pulumi.Input['DataSourceRelationalDatabaseConfigArgs']] = None,
                 service_role_arn: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DataSource resources.
        :param pulumi.Input[str] api_id: The API ID for the GraphQL API for the DataSource.
        :param pulumi.Input[str] arn: The ARN
        :param pulumi.Input[str] description: A description of the DataSource.
        :param pulumi.Input['DataSourceDynamodbConfigArgs'] dynamodb_config: DynamoDB settings. See below
        :param pulumi.Input['DataSourceElasticsearchConfigArgs'] elasticsearch_config: Amazon Elasticsearch settings. See below
        :param pulumi.Input['DataSourceHttpConfigArgs'] http_config: HTTP settings. See below
        :param pulumi.Input['DataSourceLambdaConfigArgs'] lambda_config: AWS Lambda settings. See below
        :param pulumi.Input[str] name: A user-supplied name for the DataSource.
        :param pulumi.Input['DataSourceRelationalDatabaseConfigArgs'] relational_database_config: AWS RDS settings. See Relational Database Config
        :param pulumi.Input[str] service_role_arn: The IAM service role ARN for the data source.
        :param pulumi.Input[str] type: The type of the DataSource. Valid values: `AWS_LAMBDA`, `AMAZON_DYNAMODB`, `AMAZON_ELASTICSEARCH`, `HTTP`, `NONE`, `RELATIONAL_DATABASE`.
        """
        if api_id is not None:
            pulumi.set(__self__, "api_id", api_id)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dynamodb_config is not None:
            pulumi.set(__self__, "dynamodb_config", dynamodb_config)
        if elasticsearch_config is not None:
            pulumi.set(__self__, "elasticsearch_config", elasticsearch_config)
        if http_config is not None:
            pulumi.set(__self__, "http_config", http_config)
        if lambda_config is not None:
            pulumi.set(__self__, "lambda_config", lambda_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if relational_database_config is not None:
            pulumi.set(__self__, "relational_database_config", relational_database_config)
        if service_role_arn is not None:
            pulumi.set(__self__, "service_role_arn", service_role_arn)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="apiId")
    def api_id(self) -> Optional[pulumi.Input[str]]:
        """
        The API ID for the GraphQL API for the DataSource.
        """
        return pulumi.get(self, "api_id")

    @api_id.setter
    def api_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_id", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the DataSource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="dynamodbConfig")
    def dynamodb_config(self) -> Optional[pulumi.Input['DataSourceDynamodbConfigArgs']]:
        """
        DynamoDB settings. See below
        """
        return pulumi.get(self, "dynamodb_config")

    @dynamodb_config.setter
    def dynamodb_config(self, value: Optional[pulumi.Input['DataSourceDynamodbConfigArgs']]):
        pulumi.set(self, "dynamodb_config", value)

    @property
    @pulumi.getter(name="elasticsearchConfig")
    def elasticsearch_config(self) -> Optional[pulumi.Input['DataSourceElasticsearchConfigArgs']]:
        """
        Amazon Elasticsearch settings. See below
        """
        return pulumi.get(self, "elasticsearch_config")

    @elasticsearch_config.setter
    def elasticsearch_config(self, value: Optional[pulumi.Input['DataSourceElasticsearchConfigArgs']]):
        pulumi.set(self, "elasticsearch_config", value)

    @property
    @pulumi.getter(name="httpConfig")
    def http_config(self) -> Optional[pulumi.Input['DataSourceHttpConfigArgs']]:
        """
        HTTP settings. See below
        """
        return pulumi.get(self, "http_config")

    @http_config.setter
    def http_config(self, value: Optional[pulumi.Input['DataSourceHttpConfigArgs']]):
        pulumi.set(self, "http_config", value)

    @property
    @pulumi.getter(name="lambdaConfig")
    def lambda_config(self) -> Optional[pulumi.Input['DataSourceLambdaConfigArgs']]:
        """
        AWS Lambda settings. See below
        """
        return pulumi.get(self, "lambda_config")

    @lambda_config.setter
    def lambda_config(self, value: Optional[pulumi.Input['DataSourceLambdaConfigArgs']]):
        pulumi.set(self, "lambda_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A user-supplied name for the DataSource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="relationalDatabaseConfig")
    def relational_database_config(self) -> Optional[pulumi.Input['DataSourceRelationalDatabaseConfigArgs']]:
        """
        AWS RDS settings. See Relational Database Config
        """
        return pulumi.get(self, "relational_database_config")

    @relational_database_config.setter
    def relational_database_config(self, value: Optional[pulumi.Input['DataSourceRelationalDatabaseConfigArgs']]):
        pulumi.set(self, "relational_database_config", value)

    @property
    @pulumi.getter(name="serviceRoleArn")
    def service_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The IAM service role ARN for the data source.
        """
        return pulumi.get(self, "service_role_arn")

    @service_role_arn.setter
    def service_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_role_arn", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the DataSource. Valid values: `AWS_LAMBDA`, `AMAZON_DYNAMODB`, `AMAZON_ELASTICSEARCH`, `HTTP`, `NONE`, `RELATIONAL_DATABASE`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class DataSource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dynamodb_config: Optional[pulumi.Input[pulumi.InputType['DataSourceDynamodbConfigArgs']]] = None,
                 elasticsearch_config: Optional[pulumi.Input[pulumi.InputType['DataSourceElasticsearchConfigArgs']]] = None,
                 http_config: Optional[pulumi.Input[pulumi.InputType['DataSourceHttpConfigArgs']]] = None,
                 lambda_config: Optional[pulumi.Input[pulumi.InputType['DataSourceLambdaConfigArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 relational_database_config: Optional[pulumi.Input[pulumi.InputType['DataSourceRelationalDatabaseConfigArgs']]] = None,
                 service_role_arn: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides an AppSync DataSource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example_table = aws.dynamodb.Table("exampleTable",
            read_capacity=1,
            write_capacity=1,
            hash_key="UserId",
            attributes=[aws.dynamodb.TableAttributeArgs(
                name="UserId",
                type="S",
            )])
        example_role = aws.iam.Role("exampleRole", assume_role_policy=\"\"\"{
          "Version": "2012-10-17",
          "Statement": [
            {
              "Action": "sts:AssumeRole",
              "Principal": {
                "Service": "appsync.amazonaws.com"
              },
              "Effect": "Allow"
            }
          ]
        }
        \"\"\")
        example_role_policy = aws.iam.RolePolicy("exampleRolePolicy",
            role=example_role.id,
            policy=example_table.arn.apply(lambda arn: f\"\"\"{{
          "Version": "2012-10-17",
          "Statement": [
            {{
              "Action": [
                "dynamodb:*"
              ],
              "Effect": "Allow",
              "Resource": [
                "{arn}"
              ]
            }}
          ]
        }}
        \"\"\"))
        example_graph_ql_api = aws.appsync.GraphQLApi("exampleGraphQLApi", authentication_type="API_KEY")
        example_data_source = aws.appsync.DataSource("exampleDataSource",
            api_id=example_graph_ql_api.id,
            name="tf_appsync_example",
            service_role_arn=example_role.arn,
            type="AMAZON_DYNAMODB",
            dynamodb_config=aws.appsync.DataSourceDynamodbConfigArgs(
                table_name=example_table.name,
            ))
        ```

        ## Import

        `aws_appsync_datasource` can be imported with their `api_id`, a hyphen, and `name`, e.g.,

        ```sh
         $ pulumi import aws:appsync/dataSource:DataSource example abcdef123456-example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] api_id: The API ID for the GraphQL API for the DataSource.
        :param pulumi.Input[str] description: A description of the DataSource.
        :param pulumi.Input[pulumi.InputType['DataSourceDynamodbConfigArgs']] dynamodb_config: DynamoDB settings. See below
        :param pulumi.Input[pulumi.InputType['DataSourceElasticsearchConfigArgs']] elasticsearch_config: Amazon Elasticsearch settings. See below
        :param pulumi.Input[pulumi.InputType['DataSourceHttpConfigArgs']] http_config: HTTP settings. See below
        :param pulumi.Input[pulumi.InputType['DataSourceLambdaConfigArgs']] lambda_config: AWS Lambda settings. See below
        :param pulumi.Input[str] name: A user-supplied name for the DataSource.
        :param pulumi.Input[pulumi.InputType['DataSourceRelationalDatabaseConfigArgs']] relational_database_config: AWS RDS settings. See Relational Database Config
        :param pulumi.Input[str] service_role_arn: The IAM service role ARN for the data source.
        :param pulumi.Input[str] type: The type of the DataSource. Valid values: `AWS_LAMBDA`, `AMAZON_DYNAMODB`, `AMAZON_ELASTICSEARCH`, `HTTP`, `NONE`, `RELATIONAL_DATABASE`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DataSourceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an AppSync DataSource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example_table = aws.dynamodb.Table("exampleTable",
            read_capacity=1,
            write_capacity=1,
            hash_key="UserId",
            attributes=[aws.dynamodb.TableAttributeArgs(
                name="UserId",
                type="S",
            )])
        example_role = aws.iam.Role("exampleRole", assume_role_policy=\"\"\"{
          "Version": "2012-10-17",
          "Statement": [
            {
              "Action": "sts:AssumeRole",
              "Principal": {
                "Service": "appsync.amazonaws.com"
              },
              "Effect": "Allow"
            }
          ]
        }
        \"\"\")
        example_role_policy = aws.iam.RolePolicy("exampleRolePolicy",
            role=example_role.id,
            policy=example_table.arn.apply(lambda arn: f\"\"\"{{
          "Version": "2012-10-17",
          "Statement": [
            {{
              "Action": [
                "dynamodb:*"
              ],
              "Effect": "Allow",
              "Resource": [
                "{arn}"
              ]
            }}
          ]
        }}
        \"\"\"))
        example_graph_ql_api = aws.appsync.GraphQLApi("exampleGraphQLApi", authentication_type="API_KEY")
        example_data_source = aws.appsync.DataSource("exampleDataSource",
            api_id=example_graph_ql_api.id,
            name="tf_appsync_example",
            service_role_arn=example_role.arn,
            type="AMAZON_DYNAMODB",
            dynamodb_config=aws.appsync.DataSourceDynamodbConfigArgs(
                table_name=example_table.name,
            ))
        ```

        ## Import

        `aws_appsync_datasource` can be imported with their `api_id`, a hyphen, and `name`, e.g.,

        ```sh
         $ pulumi import aws:appsync/dataSource:DataSource example abcdef123456-example
        ```

        :param str resource_name: The name of the resource.
        :param DataSourceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DataSourceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dynamodb_config: Optional[pulumi.Input[pulumi.InputType['DataSourceDynamodbConfigArgs']]] = None,
                 elasticsearch_config: Optional[pulumi.Input[pulumi.InputType['DataSourceElasticsearchConfigArgs']]] = None,
                 http_config: Optional[pulumi.Input[pulumi.InputType['DataSourceHttpConfigArgs']]] = None,
                 lambda_config: Optional[pulumi.Input[pulumi.InputType['DataSourceLambdaConfigArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 relational_database_config: Optional[pulumi.Input[pulumi.InputType['DataSourceRelationalDatabaseConfigArgs']]] = None,
                 service_role_arn: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DataSourceArgs.__new__(DataSourceArgs)

            if api_id is None and not opts.urn:
                raise TypeError("Missing required property 'api_id'")
            __props__.__dict__["api_id"] = api_id
            __props__.__dict__["description"] = description
            __props__.__dict__["dynamodb_config"] = dynamodb_config
            __props__.__dict__["elasticsearch_config"] = elasticsearch_config
            __props__.__dict__["http_config"] = http_config
            __props__.__dict__["lambda_config"] = lambda_config
            __props__.__dict__["name"] = name
            __props__.__dict__["relational_database_config"] = relational_database_config
            __props__.__dict__["service_role_arn"] = service_role_arn
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["arn"] = None
        super(DataSource, __self__).__init__(
            'aws:appsync/dataSource:DataSource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_id: Optional[pulumi.Input[str]] = None,
            arn: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            dynamodb_config: Optional[pulumi.Input[pulumi.InputType['DataSourceDynamodbConfigArgs']]] = None,
            elasticsearch_config: Optional[pulumi.Input[pulumi.InputType['DataSourceElasticsearchConfigArgs']]] = None,
            http_config: Optional[pulumi.Input[pulumi.InputType['DataSourceHttpConfigArgs']]] = None,
            lambda_config: Optional[pulumi.Input[pulumi.InputType['DataSourceLambdaConfigArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            relational_database_config: Optional[pulumi.Input[pulumi.InputType['DataSourceRelationalDatabaseConfigArgs']]] = None,
            service_role_arn: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'DataSource':
        """
        Get an existing DataSource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] api_id: The API ID for the GraphQL API for the DataSource.
        :param pulumi.Input[str] arn: The ARN
        :param pulumi.Input[str] description: A description of the DataSource.
        :param pulumi.Input[pulumi.InputType['DataSourceDynamodbConfigArgs']] dynamodb_config: DynamoDB settings. See below
        :param pulumi.Input[pulumi.InputType['DataSourceElasticsearchConfigArgs']] elasticsearch_config: Amazon Elasticsearch settings. See below
        :param pulumi.Input[pulumi.InputType['DataSourceHttpConfigArgs']] http_config: HTTP settings. See below
        :param pulumi.Input[pulumi.InputType['DataSourceLambdaConfigArgs']] lambda_config: AWS Lambda settings. See below
        :param pulumi.Input[str] name: A user-supplied name for the DataSource.
        :param pulumi.Input[pulumi.InputType['DataSourceRelationalDatabaseConfigArgs']] relational_database_config: AWS RDS settings. See Relational Database Config
        :param pulumi.Input[str] service_role_arn: The IAM service role ARN for the data source.
        :param pulumi.Input[str] type: The type of the DataSource. Valid values: `AWS_LAMBDA`, `AMAZON_DYNAMODB`, `AMAZON_ELASTICSEARCH`, `HTTP`, `NONE`, `RELATIONAL_DATABASE`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DataSourceState.__new__(_DataSourceState)

        __props__.__dict__["api_id"] = api_id
        __props__.__dict__["arn"] = arn
        __props__.__dict__["description"] = description
        __props__.__dict__["dynamodb_config"] = dynamodb_config
        __props__.__dict__["elasticsearch_config"] = elasticsearch_config
        __props__.__dict__["http_config"] = http_config
        __props__.__dict__["lambda_config"] = lambda_config
        __props__.__dict__["name"] = name
        __props__.__dict__["relational_database_config"] = relational_database_config
        __props__.__dict__["service_role_arn"] = service_role_arn
        __props__.__dict__["type"] = type
        return DataSource(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="apiId")
    def api_id(self) -> pulumi.Output[str]:
        """
        The API ID for the GraphQL API for the DataSource.
        """
        return pulumi.get(self, "api_id")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A description of the DataSource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="dynamodbConfig")
    def dynamodb_config(self) -> pulumi.Output[Optional['outputs.DataSourceDynamodbConfig']]:
        """
        DynamoDB settings. See below
        """
        return pulumi.get(self, "dynamodb_config")

    @property
    @pulumi.getter(name="elasticsearchConfig")
    def elasticsearch_config(self) -> pulumi.Output[Optional['outputs.DataSourceElasticsearchConfig']]:
        """
        Amazon Elasticsearch settings. See below
        """
        return pulumi.get(self, "elasticsearch_config")

    @property
    @pulumi.getter(name="httpConfig")
    def http_config(self) -> pulumi.Output[Optional['outputs.DataSourceHttpConfig']]:
        """
        HTTP settings. See below
        """
        return pulumi.get(self, "http_config")

    @property
    @pulumi.getter(name="lambdaConfig")
    def lambda_config(self) -> pulumi.Output[Optional['outputs.DataSourceLambdaConfig']]:
        """
        AWS Lambda settings. See below
        """
        return pulumi.get(self, "lambda_config")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A user-supplied name for the DataSource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="relationalDatabaseConfig")
    def relational_database_config(self) -> pulumi.Output[Optional['outputs.DataSourceRelationalDatabaseConfig']]:
        """
        AWS RDS settings. See Relational Database Config
        """
        return pulumi.get(self, "relational_database_config")

    @property
    @pulumi.getter(name="serviceRoleArn")
    def service_role_arn(self) -> pulumi.Output[Optional[str]]:
        """
        The IAM service role ARN for the data source.
        """
        return pulumi.get(self, "service_role_arn")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the DataSource. Valid values: `AWS_LAMBDA`, `AMAZON_DYNAMODB`, `AMAZON_ELASTICSEARCH`, `HTTP`, `NONE`, `RELATIONAL_DATABASE`.
        """
        return pulumi.get(self, "type")

