# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['HaproxyLayerArgs', 'HaproxyLayer']

@pulumi.input_type
class HaproxyLayerArgs:
    def __init__(__self__, *,
                 stack_id: pulumi.Input[str],
                 stats_password: pulumi.Input[str],
                 auto_assign_elastic_ips: Optional[pulumi.Input[bool]] = None,
                 auto_assign_public_ips: Optional[pulumi.Input[bool]] = None,
                 auto_healing: Optional[pulumi.Input[bool]] = None,
                 custom_configure_recipes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 custom_deploy_recipes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 custom_instance_profile_arn: Optional[pulumi.Input[str]] = None,
                 custom_json: Optional[pulumi.Input[str]] = None,
                 custom_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 custom_setup_recipes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 custom_shutdown_recipes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 custom_undeploy_recipes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 drain_elb_on_shutdown: Optional[pulumi.Input[bool]] = None,
                 ebs_volumes: Optional[pulumi.Input[Sequence[pulumi.Input['HaproxyLayerEbsVolumeArgs']]]] = None,
                 elastic_load_balancer: Optional[pulumi.Input[str]] = None,
                 healthcheck_method: Optional[pulumi.Input[str]] = None,
                 healthcheck_url: Optional[pulumi.Input[str]] = None,
                 install_updates_on_boot: Optional[pulumi.Input[bool]] = None,
                 instance_shutdown_timeout: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 stats_enabled: Optional[pulumi.Input[bool]] = None,
                 stats_url: Optional[pulumi.Input[str]] = None,
                 stats_user: Optional[pulumi.Input[str]] = None,
                 system_packages: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 use_ebs_optimized_instances: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a HaproxyLayer resource.
        :param pulumi.Input[str] stack_id: The id of the stack the layer will belong to.
        :param pulumi.Input[str] stats_password: The password to use for HAProxy stats.
        :param pulumi.Input[bool] auto_assign_elastic_ips: Whether to automatically assign an elastic IP address to the layer's instances.
        :param pulumi.Input[bool] auto_assign_public_ips: For stacks belonging to a VPC, whether to automatically assign a public IP address to each of the layer's instances.
        :param pulumi.Input[bool] auto_healing: Whether to enable auto-healing for the layer.
        :param pulumi.Input[str] custom_instance_profile_arn: The ARN of an IAM profile that will be used for the layer's instances.
        :param pulumi.Input[str] custom_json: Custom JSON attributes to apply to the layer.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] custom_security_group_ids: Ids for a set of security groups to apply to the layer's instances.
        :param pulumi.Input[bool] drain_elb_on_shutdown: Whether to enable Elastic Load Balancing connection draining.
        :param pulumi.Input[Sequence[pulumi.Input['HaproxyLayerEbsVolumeArgs']]] ebs_volumes: `ebs_volume` blocks, as described below, will each create an EBS volume and connect it to the layer's instances.
        :param pulumi.Input[str] elastic_load_balancer: Name of an Elastic Load Balancer to attach to this layer
        :param pulumi.Input[str] healthcheck_method: HTTP method to use for instance healthchecks. Defaults to "OPTIONS".
        :param pulumi.Input[str] healthcheck_url: URL path to use for instance healthchecks. Defaults to "/".
        :param pulumi.Input[bool] install_updates_on_boot: Whether to install OS and package updates on each instance when it boots.
        :param pulumi.Input[int] instance_shutdown_timeout: The time, in seconds, that OpsWorks will wait for Chef to complete after triggering the Shutdown event.
        :param pulumi.Input[str] name: A human-readable name for the layer.
        :param pulumi.Input[bool] stats_enabled: Whether to enable HAProxy stats.
        :param pulumi.Input[str] stats_url: The HAProxy stats URL. Defaults to "/haproxy?stats".
        :param pulumi.Input[str] stats_user: The username for HAProxy stats. Defaults to "opsworks".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] system_packages: Names of a set of system packages to install on the layer's instances.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[bool] use_ebs_optimized_instances: Whether to use EBS-optimized instances.
        """
        pulumi.set(__self__, "stack_id", stack_id)
        pulumi.set(__self__, "stats_password", stats_password)
        if auto_assign_elastic_ips is not None:
            pulumi.set(__self__, "auto_assign_elastic_ips", auto_assign_elastic_ips)
        if auto_assign_public_ips is not None:
            pulumi.set(__self__, "auto_assign_public_ips", auto_assign_public_ips)
        if auto_healing is not None:
            pulumi.set(__self__, "auto_healing", auto_healing)
        if custom_configure_recipes is not None:
            pulumi.set(__self__, "custom_configure_recipes", custom_configure_recipes)
        if custom_deploy_recipes is not None:
            pulumi.set(__self__, "custom_deploy_recipes", custom_deploy_recipes)
        if custom_instance_profile_arn is not None:
            pulumi.set(__self__, "custom_instance_profile_arn", custom_instance_profile_arn)
        if custom_json is not None:
            pulumi.set(__self__, "custom_json", custom_json)
        if custom_security_group_ids is not None:
            pulumi.set(__self__, "custom_security_group_ids", custom_security_group_ids)
        if custom_setup_recipes is not None:
            pulumi.set(__self__, "custom_setup_recipes", custom_setup_recipes)
        if custom_shutdown_recipes is not None:
            pulumi.set(__self__, "custom_shutdown_recipes", custom_shutdown_recipes)
        if custom_undeploy_recipes is not None:
            pulumi.set(__self__, "custom_undeploy_recipes", custom_undeploy_recipes)
        if drain_elb_on_shutdown is not None:
            pulumi.set(__self__, "drain_elb_on_shutdown", drain_elb_on_shutdown)
        if ebs_volumes is not None:
            pulumi.set(__self__, "ebs_volumes", ebs_volumes)
        if elastic_load_balancer is not None:
            pulumi.set(__self__, "elastic_load_balancer", elastic_load_balancer)
        if healthcheck_method is not None:
            pulumi.set(__self__, "healthcheck_method", healthcheck_method)
        if healthcheck_url is not None:
            pulumi.set(__self__, "healthcheck_url", healthcheck_url)
        if install_updates_on_boot is not None:
            pulumi.set(__self__, "install_updates_on_boot", install_updates_on_boot)
        if instance_shutdown_timeout is not None:
            pulumi.set(__self__, "instance_shutdown_timeout", instance_shutdown_timeout)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if stats_enabled is not None:
            pulumi.set(__self__, "stats_enabled", stats_enabled)
        if stats_url is not None:
            pulumi.set(__self__, "stats_url", stats_url)
        if stats_user is not None:
            pulumi.set(__self__, "stats_user", stats_user)
        if system_packages is not None:
            pulumi.set(__self__, "system_packages", system_packages)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if use_ebs_optimized_instances is not None:
            pulumi.set(__self__, "use_ebs_optimized_instances", use_ebs_optimized_instances)

    @property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> pulumi.Input[str]:
        """
        The id of the stack the layer will belong to.
        """
        return pulumi.get(self, "stack_id")

    @stack_id.setter
    def stack_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "stack_id", value)

    @property
    @pulumi.getter(name="statsPassword")
    def stats_password(self) -> pulumi.Input[str]:
        """
        The password to use for HAProxy stats.
        """
        return pulumi.get(self, "stats_password")

    @stats_password.setter
    def stats_password(self, value: pulumi.Input[str]):
        pulumi.set(self, "stats_password", value)

    @property
    @pulumi.getter(name="autoAssignElasticIps")
    def auto_assign_elastic_ips(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to automatically assign an elastic IP address to the layer's instances.
        """
        return pulumi.get(self, "auto_assign_elastic_ips")

    @auto_assign_elastic_ips.setter
    def auto_assign_elastic_ips(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_assign_elastic_ips", value)

    @property
    @pulumi.getter(name="autoAssignPublicIps")
    def auto_assign_public_ips(self) -> Optional[pulumi.Input[bool]]:
        """
        For stacks belonging to a VPC, whether to automatically assign a public IP address to each of the layer's instances.
        """
        return pulumi.get(self, "auto_assign_public_ips")

    @auto_assign_public_ips.setter
    def auto_assign_public_ips(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_assign_public_ips", value)

    @property
    @pulumi.getter(name="autoHealing")
    def auto_healing(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable auto-healing for the layer.
        """
        return pulumi.get(self, "auto_healing")

    @auto_healing.setter
    def auto_healing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_healing", value)

    @property
    @pulumi.getter(name="customConfigureRecipes")
    def custom_configure_recipes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "custom_configure_recipes")

    @custom_configure_recipes.setter
    def custom_configure_recipes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "custom_configure_recipes", value)

    @property
    @pulumi.getter(name="customDeployRecipes")
    def custom_deploy_recipes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "custom_deploy_recipes")

    @custom_deploy_recipes.setter
    def custom_deploy_recipes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "custom_deploy_recipes", value)

    @property
    @pulumi.getter(name="customInstanceProfileArn")
    def custom_instance_profile_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of an IAM profile that will be used for the layer's instances.
        """
        return pulumi.get(self, "custom_instance_profile_arn")

    @custom_instance_profile_arn.setter
    def custom_instance_profile_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_instance_profile_arn", value)

    @property
    @pulumi.getter(name="customJson")
    def custom_json(self) -> Optional[pulumi.Input[str]]:
        """
        Custom JSON attributes to apply to the layer.
        """
        return pulumi.get(self, "custom_json")

    @custom_json.setter
    def custom_json(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_json", value)

    @property
    @pulumi.getter(name="customSecurityGroupIds")
    def custom_security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Ids for a set of security groups to apply to the layer's instances.
        """
        return pulumi.get(self, "custom_security_group_ids")

    @custom_security_group_ids.setter
    def custom_security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "custom_security_group_ids", value)

    @property
    @pulumi.getter(name="customSetupRecipes")
    def custom_setup_recipes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "custom_setup_recipes")

    @custom_setup_recipes.setter
    def custom_setup_recipes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "custom_setup_recipes", value)

    @property
    @pulumi.getter(name="customShutdownRecipes")
    def custom_shutdown_recipes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "custom_shutdown_recipes")

    @custom_shutdown_recipes.setter
    def custom_shutdown_recipes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "custom_shutdown_recipes", value)

    @property
    @pulumi.getter(name="customUndeployRecipes")
    def custom_undeploy_recipes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "custom_undeploy_recipes")

    @custom_undeploy_recipes.setter
    def custom_undeploy_recipes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "custom_undeploy_recipes", value)

    @property
    @pulumi.getter(name="drainElbOnShutdown")
    def drain_elb_on_shutdown(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable Elastic Load Balancing connection draining.
        """
        return pulumi.get(self, "drain_elb_on_shutdown")

    @drain_elb_on_shutdown.setter
    def drain_elb_on_shutdown(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "drain_elb_on_shutdown", value)

    @property
    @pulumi.getter(name="ebsVolumes")
    def ebs_volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HaproxyLayerEbsVolumeArgs']]]]:
        """
        `ebs_volume` blocks, as described below, will each create an EBS volume and connect it to the layer's instances.
        """
        return pulumi.get(self, "ebs_volumes")

    @ebs_volumes.setter
    def ebs_volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HaproxyLayerEbsVolumeArgs']]]]):
        pulumi.set(self, "ebs_volumes", value)

    @property
    @pulumi.getter(name="elasticLoadBalancer")
    def elastic_load_balancer(self) -> Optional[pulumi.Input[str]]:
        """
        Name of an Elastic Load Balancer to attach to this layer
        """
        return pulumi.get(self, "elastic_load_balancer")

    @elastic_load_balancer.setter
    def elastic_load_balancer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "elastic_load_balancer", value)

    @property
    @pulumi.getter(name="healthcheckMethod")
    def healthcheck_method(self) -> Optional[pulumi.Input[str]]:
        """
        HTTP method to use for instance healthchecks. Defaults to "OPTIONS".
        """
        return pulumi.get(self, "healthcheck_method")

    @healthcheck_method.setter
    def healthcheck_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "healthcheck_method", value)

    @property
    @pulumi.getter(name="healthcheckUrl")
    def healthcheck_url(self) -> Optional[pulumi.Input[str]]:
        """
        URL path to use for instance healthchecks. Defaults to "/".
        """
        return pulumi.get(self, "healthcheck_url")

    @healthcheck_url.setter
    def healthcheck_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "healthcheck_url", value)

    @property
    @pulumi.getter(name="installUpdatesOnBoot")
    def install_updates_on_boot(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to install OS and package updates on each instance when it boots.
        """
        return pulumi.get(self, "install_updates_on_boot")

    @install_updates_on_boot.setter
    def install_updates_on_boot(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "install_updates_on_boot", value)

    @property
    @pulumi.getter(name="instanceShutdownTimeout")
    def instance_shutdown_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The time, in seconds, that OpsWorks will wait for Chef to complete after triggering the Shutdown event.
        """
        return pulumi.get(self, "instance_shutdown_timeout")

    @instance_shutdown_timeout.setter
    def instance_shutdown_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "instance_shutdown_timeout", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A human-readable name for the layer.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="statsEnabled")
    def stats_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable HAProxy stats.
        """
        return pulumi.get(self, "stats_enabled")

    @stats_enabled.setter
    def stats_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "stats_enabled", value)

    @property
    @pulumi.getter(name="statsUrl")
    def stats_url(self) -> Optional[pulumi.Input[str]]:
        """
        The HAProxy stats URL. Defaults to "/haproxy?stats".
        """
        return pulumi.get(self, "stats_url")

    @stats_url.setter
    def stats_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stats_url", value)

    @property
    @pulumi.getter(name="statsUser")
    def stats_user(self) -> Optional[pulumi.Input[str]]:
        """
        The username for HAProxy stats. Defaults to "opsworks".
        """
        return pulumi.get(self, "stats_user")

    @stats_user.setter
    def stats_user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stats_user", value)

    @property
    @pulumi.getter(name="systemPackages")
    def system_packages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Names of a set of system packages to install on the layer's instances.
        """
        return pulumi.get(self, "system_packages")

    @system_packages.setter
    def system_packages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "system_packages", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="useEbsOptimizedInstances")
    def use_ebs_optimized_instances(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to use EBS-optimized instances.
        """
        return pulumi.get(self, "use_ebs_optimized_instances")

    @use_ebs_optimized_instances.setter
    def use_ebs_optimized_instances(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_ebs_optimized_instances", value)


@pulumi.input_type
class _HaproxyLayerState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 auto_assign_elastic_ips: Optional[pulumi.Input[bool]] = None,
                 auto_assign_public_ips: Optional[pulumi.Input[bool]] = None,
                 auto_healing: Optional[pulumi.Input[bool]] = None,
                 custom_configure_recipes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 custom_deploy_recipes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 custom_instance_profile_arn: Optional[pulumi.Input[str]] = None,
                 custom_json: Optional[pulumi.Input[str]] = None,
                 custom_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 custom_setup_recipes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 custom_shutdown_recipes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 custom_undeploy_recipes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 drain_elb_on_shutdown: Optional[pulumi.Input[bool]] = None,
                 ebs_volumes: Optional[pulumi.Input[Sequence[pulumi.Input['HaproxyLayerEbsVolumeArgs']]]] = None,
                 elastic_load_balancer: Optional[pulumi.Input[str]] = None,
                 healthcheck_method: Optional[pulumi.Input[str]] = None,
                 healthcheck_url: Optional[pulumi.Input[str]] = None,
                 install_updates_on_boot: Optional[pulumi.Input[bool]] = None,
                 instance_shutdown_timeout: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 stack_id: Optional[pulumi.Input[str]] = None,
                 stats_enabled: Optional[pulumi.Input[bool]] = None,
                 stats_password: Optional[pulumi.Input[str]] = None,
                 stats_url: Optional[pulumi.Input[str]] = None,
                 stats_user: Optional[pulumi.Input[str]] = None,
                 system_packages: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 use_ebs_optimized_instances: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering HaproxyLayer resources.
        :param pulumi.Input[str] arn: The Amazon Resource Name(ARN) of the layer.
        :param pulumi.Input[bool] auto_assign_elastic_ips: Whether to automatically assign an elastic IP address to the layer's instances.
        :param pulumi.Input[bool] auto_assign_public_ips: For stacks belonging to a VPC, whether to automatically assign a public IP address to each of the layer's instances.
        :param pulumi.Input[bool] auto_healing: Whether to enable auto-healing for the layer.
        :param pulumi.Input[str] custom_instance_profile_arn: The ARN of an IAM profile that will be used for the layer's instances.
        :param pulumi.Input[str] custom_json: Custom JSON attributes to apply to the layer.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] custom_security_group_ids: Ids for a set of security groups to apply to the layer's instances.
        :param pulumi.Input[bool] drain_elb_on_shutdown: Whether to enable Elastic Load Balancing connection draining.
        :param pulumi.Input[Sequence[pulumi.Input['HaproxyLayerEbsVolumeArgs']]] ebs_volumes: `ebs_volume` blocks, as described below, will each create an EBS volume and connect it to the layer's instances.
        :param pulumi.Input[str] elastic_load_balancer: Name of an Elastic Load Balancer to attach to this layer
        :param pulumi.Input[str] healthcheck_method: HTTP method to use for instance healthchecks. Defaults to "OPTIONS".
        :param pulumi.Input[str] healthcheck_url: URL path to use for instance healthchecks. Defaults to "/".
        :param pulumi.Input[bool] install_updates_on_boot: Whether to install OS and package updates on each instance when it boots.
        :param pulumi.Input[int] instance_shutdown_timeout: The time, in seconds, that OpsWorks will wait for Chef to complete after triggering the Shutdown event.
        :param pulumi.Input[str] name: A human-readable name for the layer.
        :param pulumi.Input[str] stack_id: The id of the stack the layer will belong to.
        :param pulumi.Input[bool] stats_enabled: Whether to enable HAProxy stats.
        :param pulumi.Input[str] stats_password: The password to use for HAProxy stats.
        :param pulumi.Input[str] stats_url: The HAProxy stats URL. Defaults to "/haproxy?stats".
        :param pulumi.Input[str] stats_user: The username for HAProxy stats. Defaults to "opsworks".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] system_packages: Names of a set of system packages to install on the layer's instances.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider .
        :param pulumi.Input[bool] use_ebs_optimized_instances: Whether to use EBS-optimized instances.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if auto_assign_elastic_ips is not None:
            pulumi.set(__self__, "auto_assign_elastic_ips", auto_assign_elastic_ips)
        if auto_assign_public_ips is not None:
            pulumi.set(__self__, "auto_assign_public_ips", auto_assign_public_ips)
        if auto_healing is not None:
            pulumi.set(__self__, "auto_healing", auto_healing)
        if custom_configure_recipes is not None:
            pulumi.set(__self__, "custom_configure_recipes", custom_configure_recipes)
        if custom_deploy_recipes is not None:
            pulumi.set(__self__, "custom_deploy_recipes", custom_deploy_recipes)
        if custom_instance_profile_arn is not None:
            pulumi.set(__self__, "custom_instance_profile_arn", custom_instance_profile_arn)
        if custom_json is not None:
            pulumi.set(__self__, "custom_json", custom_json)
        if custom_security_group_ids is not None:
            pulumi.set(__self__, "custom_security_group_ids", custom_security_group_ids)
        if custom_setup_recipes is not None:
            pulumi.set(__self__, "custom_setup_recipes", custom_setup_recipes)
        if custom_shutdown_recipes is not None:
            pulumi.set(__self__, "custom_shutdown_recipes", custom_shutdown_recipes)
        if custom_undeploy_recipes is not None:
            pulumi.set(__self__, "custom_undeploy_recipes", custom_undeploy_recipes)
        if drain_elb_on_shutdown is not None:
            pulumi.set(__self__, "drain_elb_on_shutdown", drain_elb_on_shutdown)
        if ebs_volumes is not None:
            pulumi.set(__self__, "ebs_volumes", ebs_volumes)
        if elastic_load_balancer is not None:
            pulumi.set(__self__, "elastic_load_balancer", elastic_load_balancer)
        if healthcheck_method is not None:
            pulumi.set(__self__, "healthcheck_method", healthcheck_method)
        if healthcheck_url is not None:
            pulumi.set(__self__, "healthcheck_url", healthcheck_url)
        if install_updates_on_boot is not None:
            pulumi.set(__self__, "install_updates_on_boot", install_updates_on_boot)
        if instance_shutdown_timeout is not None:
            pulumi.set(__self__, "instance_shutdown_timeout", instance_shutdown_timeout)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if stack_id is not None:
            pulumi.set(__self__, "stack_id", stack_id)
        if stats_enabled is not None:
            pulumi.set(__self__, "stats_enabled", stats_enabled)
        if stats_password is not None:
            pulumi.set(__self__, "stats_password", stats_password)
        if stats_url is not None:
            pulumi.set(__self__, "stats_url", stats_url)
        if stats_user is not None:
            pulumi.set(__self__, "stats_user", stats_user)
        if system_packages is not None:
            pulumi.set(__self__, "system_packages", system_packages)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if use_ebs_optimized_instances is not None:
            pulumi.set(__self__, "use_ebs_optimized_instances", use_ebs_optimized_instances)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name(ARN) of the layer.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="autoAssignElasticIps")
    def auto_assign_elastic_ips(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to automatically assign an elastic IP address to the layer's instances.
        """
        return pulumi.get(self, "auto_assign_elastic_ips")

    @auto_assign_elastic_ips.setter
    def auto_assign_elastic_ips(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_assign_elastic_ips", value)

    @property
    @pulumi.getter(name="autoAssignPublicIps")
    def auto_assign_public_ips(self) -> Optional[pulumi.Input[bool]]:
        """
        For stacks belonging to a VPC, whether to automatically assign a public IP address to each of the layer's instances.
        """
        return pulumi.get(self, "auto_assign_public_ips")

    @auto_assign_public_ips.setter
    def auto_assign_public_ips(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_assign_public_ips", value)

    @property
    @pulumi.getter(name="autoHealing")
    def auto_healing(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable auto-healing for the layer.
        """
        return pulumi.get(self, "auto_healing")

    @auto_healing.setter
    def auto_healing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_healing", value)

    @property
    @pulumi.getter(name="customConfigureRecipes")
    def custom_configure_recipes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "custom_configure_recipes")

    @custom_configure_recipes.setter
    def custom_configure_recipes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "custom_configure_recipes", value)

    @property
    @pulumi.getter(name="customDeployRecipes")
    def custom_deploy_recipes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "custom_deploy_recipes")

    @custom_deploy_recipes.setter
    def custom_deploy_recipes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "custom_deploy_recipes", value)

    @property
    @pulumi.getter(name="customInstanceProfileArn")
    def custom_instance_profile_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of an IAM profile that will be used for the layer's instances.
        """
        return pulumi.get(self, "custom_instance_profile_arn")

    @custom_instance_profile_arn.setter
    def custom_instance_profile_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_instance_profile_arn", value)

    @property
    @pulumi.getter(name="customJson")
    def custom_json(self) -> Optional[pulumi.Input[str]]:
        """
        Custom JSON attributes to apply to the layer.
        """
        return pulumi.get(self, "custom_json")

    @custom_json.setter
    def custom_json(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_json", value)

    @property
    @pulumi.getter(name="customSecurityGroupIds")
    def custom_security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Ids for a set of security groups to apply to the layer's instances.
        """
        return pulumi.get(self, "custom_security_group_ids")

    @custom_security_group_ids.setter
    def custom_security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "custom_security_group_ids", value)

    @property
    @pulumi.getter(name="customSetupRecipes")
    def custom_setup_recipes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "custom_setup_recipes")

    @custom_setup_recipes.setter
    def custom_setup_recipes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "custom_setup_recipes", value)

    @property
    @pulumi.getter(name="customShutdownRecipes")
    def custom_shutdown_recipes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "custom_shutdown_recipes")

    @custom_shutdown_recipes.setter
    def custom_shutdown_recipes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "custom_shutdown_recipes", value)

    @property
    @pulumi.getter(name="customUndeployRecipes")
    def custom_undeploy_recipes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "custom_undeploy_recipes")

    @custom_undeploy_recipes.setter
    def custom_undeploy_recipes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "custom_undeploy_recipes", value)

    @property
    @pulumi.getter(name="drainElbOnShutdown")
    def drain_elb_on_shutdown(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable Elastic Load Balancing connection draining.
        """
        return pulumi.get(self, "drain_elb_on_shutdown")

    @drain_elb_on_shutdown.setter
    def drain_elb_on_shutdown(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "drain_elb_on_shutdown", value)

    @property
    @pulumi.getter(name="ebsVolumes")
    def ebs_volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HaproxyLayerEbsVolumeArgs']]]]:
        """
        `ebs_volume` blocks, as described below, will each create an EBS volume and connect it to the layer's instances.
        """
        return pulumi.get(self, "ebs_volumes")

    @ebs_volumes.setter
    def ebs_volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HaproxyLayerEbsVolumeArgs']]]]):
        pulumi.set(self, "ebs_volumes", value)

    @property
    @pulumi.getter(name="elasticLoadBalancer")
    def elastic_load_balancer(self) -> Optional[pulumi.Input[str]]:
        """
        Name of an Elastic Load Balancer to attach to this layer
        """
        return pulumi.get(self, "elastic_load_balancer")

    @elastic_load_balancer.setter
    def elastic_load_balancer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "elastic_load_balancer", value)

    @property
    @pulumi.getter(name="healthcheckMethod")
    def healthcheck_method(self) -> Optional[pulumi.Input[str]]:
        """
        HTTP method to use for instance healthchecks. Defaults to "OPTIONS".
        """
        return pulumi.get(self, "healthcheck_method")

    @healthcheck_method.setter
    def healthcheck_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "healthcheck_method", value)

    @property
    @pulumi.getter(name="healthcheckUrl")
    def healthcheck_url(self) -> Optional[pulumi.Input[str]]:
        """
        URL path to use for instance healthchecks. Defaults to "/".
        """
        return pulumi.get(self, "healthcheck_url")

    @healthcheck_url.setter
    def healthcheck_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "healthcheck_url", value)

    @property
    @pulumi.getter(name="installUpdatesOnBoot")
    def install_updates_on_boot(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to install OS and package updates on each instance when it boots.
        """
        return pulumi.get(self, "install_updates_on_boot")

    @install_updates_on_boot.setter
    def install_updates_on_boot(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "install_updates_on_boot", value)

    @property
    @pulumi.getter(name="instanceShutdownTimeout")
    def instance_shutdown_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The time, in seconds, that OpsWorks will wait for Chef to complete after triggering the Shutdown event.
        """
        return pulumi.get(self, "instance_shutdown_timeout")

    @instance_shutdown_timeout.setter
    def instance_shutdown_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "instance_shutdown_timeout", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A human-readable name for the layer.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the stack the layer will belong to.
        """
        return pulumi.get(self, "stack_id")

    @stack_id.setter
    def stack_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stack_id", value)

    @property
    @pulumi.getter(name="statsEnabled")
    def stats_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable HAProxy stats.
        """
        return pulumi.get(self, "stats_enabled")

    @stats_enabled.setter
    def stats_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "stats_enabled", value)

    @property
    @pulumi.getter(name="statsPassword")
    def stats_password(self) -> Optional[pulumi.Input[str]]:
        """
        The password to use for HAProxy stats.
        """
        return pulumi.get(self, "stats_password")

    @stats_password.setter
    def stats_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stats_password", value)

    @property
    @pulumi.getter(name="statsUrl")
    def stats_url(self) -> Optional[pulumi.Input[str]]:
        """
        The HAProxy stats URL. Defaults to "/haproxy?stats".
        """
        return pulumi.get(self, "stats_url")

    @stats_url.setter
    def stats_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stats_url", value)

    @property
    @pulumi.getter(name="statsUser")
    def stats_user(self) -> Optional[pulumi.Input[str]]:
        """
        The username for HAProxy stats. Defaults to "opsworks".
        """
        return pulumi.get(self, "stats_user")

    @stats_user.setter
    def stats_user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stats_user", value)

    @property
    @pulumi.getter(name="systemPackages")
    def system_packages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Names of a set of system packages to install on the layer's instances.
        """
        return pulumi.get(self, "system_packages")

    @system_packages.setter
    def system_packages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "system_packages", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider .
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="useEbsOptimizedInstances")
    def use_ebs_optimized_instances(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to use EBS-optimized instances.
        """
        return pulumi.get(self, "use_ebs_optimized_instances")

    @use_ebs_optimized_instances.setter
    def use_ebs_optimized_instances(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_ebs_optimized_instances", value)


class HaproxyLayer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_assign_elastic_ips: Optional[pulumi.Input[bool]] = None,
                 auto_assign_public_ips: Optional[pulumi.Input[bool]] = None,
                 auto_healing: Optional[pulumi.Input[bool]] = None,
                 custom_configure_recipes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 custom_deploy_recipes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 custom_instance_profile_arn: Optional[pulumi.Input[str]] = None,
                 custom_json: Optional[pulumi.Input[str]] = None,
                 custom_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 custom_setup_recipes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 custom_shutdown_recipes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 custom_undeploy_recipes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 drain_elb_on_shutdown: Optional[pulumi.Input[bool]] = None,
                 ebs_volumes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['HaproxyLayerEbsVolumeArgs']]]]] = None,
                 elastic_load_balancer: Optional[pulumi.Input[str]] = None,
                 healthcheck_method: Optional[pulumi.Input[str]] = None,
                 healthcheck_url: Optional[pulumi.Input[str]] = None,
                 install_updates_on_boot: Optional[pulumi.Input[bool]] = None,
                 instance_shutdown_timeout: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 stack_id: Optional[pulumi.Input[str]] = None,
                 stats_enabled: Optional[pulumi.Input[bool]] = None,
                 stats_password: Optional[pulumi.Input[str]] = None,
                 stats_url: Optional[pulumi.Input[str]] = None,
                 stats_user: Optional[pulumi.Input[str]] = None,
                 system_packages: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 use_ebs_optimized_instances: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Provides an OpsWorks haproxy layer resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        lb = aws.opsworks.HaproxyLayer("lb",
            stack_id=aws_opsworks_stack["main"]["id"],
            stats_password="foobarbaz")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_assign_elastic_ips: Whether to automatically assign an elastic IP address to the layer's instances.
        :param pulumi.Input[bool] auto_assign_public_ips: For stacks belonging to a VPC, whether to automatically assign a public IP address to each of the layer's instances.
        :param pulumi.Input[bool] auto_healing: Whether to enable auto-healing for the layer.
        :param pulumi.Input[str] custom_instance_profile_arn: The ARN of an IAM profile that will be used for the layer's instances.
        :param pulumi.Input[str] custom_json: Custom JSON attributes to apply to the layer.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] custom_security_group_ids: Ids for a set of security groups to apply to the layer's instances.
        :param pulumi.Input[bool] drain_elb_on_shutdown: Whether to enable Elastic Load Balancing connection draining.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['HaproxyLayerEbsVolumeArgs']]]] ebs_volumes: `ebs_volume` blocks, as described below, will each create an EBS volume and connect it to the layer's instances.
        :param pulumi.Input[str] elastic_load_balancer: Name of an Elastic Load Balancer to attach to this layer
        :param pulumi.Input[str] healthcheck_method: HTTP method to use for instance healthchecks. Defaults to "OPTIONS".
        :param pulumi.Input[str] healthcheck_url: URL path to use for instance healthchecks. Defaults to "/".
        :param pulumi.Input[bool] install_updates_on_boot: Whether to install OS and package updates on each instance when it boots.
        :param pulumi.Input[int] instance_shutdown_timeout: The time, in seconds, that OpsWorks will wait for Chef to complete after triggering the Shutdown event.
        :param pulumi.Input[str] name: A human-readable name for the layer.
        :param pulumi.Input[str] stack_id: The id of the stack the layer will belong to.
        :param pulumi.Input[bool] stats_enabled: Whether to enable HAProxy stats.
        :param pulumi.Input[str] stats_password: The password to use for HAProxy stats.
        :param pulumi.Input[str] stats_url: The HAProxy stats URL. Defaults to "/haproxy?stats".
        :param pulumi.Input[str] stats_user: The username for HAProxy stats. Defaults to "opsworks".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] system_packages: Names of a set of system packages to install on the layer's instances.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[bool] use_ebs_optimized_instances: Whether to use EBS-optimized instances.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HaproxyLayerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an OpsWorks haproxy layer resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        lb = aws.opsworks.HaproxyLayer("lb",
            stack_id=aws_opsworks_stack["main"]["id"],
            stats_password="foobarbaz")
        ```

        :param str resource_name: The name of the resource.
        :param HaproxyLayerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HaproxyLayerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_assign_elastic_ips: Optional[pulumi.Input[bool]] = None,
                 auto_assign_public_ips: Optional[pulumi.Input[bool]] = None,
                 auto_healing: Optional[pulumi.Input[bool]] = None,
                 custom_configure_recipes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 custom_deploy_recipes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 custom_instance_profile_arn: Optional[pulumi.Input[str]] = None,
                 custom_json: Optional[pulumi.Input[str]] = None,
                 custom_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 custom_setup_recipes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 custom_shutdown_recipes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 custom_undeploy_recipes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 drain_elb_on_shutdown: Optional[pulumi.Input[bool]] = None,
                 ebs_volumes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['HaproxyLayerEbsVolumeArgs']]]]] = None,
                 elastic_load_balancer: Optional[pulumi.Input[str]] = None,
                 healthcheck_method: Optional[pulumi.Input[str]] = None,
                 healthcheck_url: Optional[pulumi.Input[str]] = None,
                 install_updates_on_boot: Optional[pulumi.Input[bool]] = None,
                 instance_shutdown_timeout: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 stack_id: Optional[pulumi.Input[str]] = None,
                 stats_enabled: Optional[pulumi.Input[bool]] = None,
                 stats_password: Optional[pulumi.Input[str]] = None,
                 stats_url: Optional[pulumi.Input[str]] = None,
                 stats_user: Optional[pulumi.Input[str]] = None,
                 system_packages: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 use_ebs_optimized_instances: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HaproxyLayerArgs.__new__(HaproxyLayerArgs)

            __props__.__dict__["auto_assign_elastic_ips"] = auto_assign_elastic_ips
            __props__.__dict__["auto_assign_public_ips"] = auto_assign_public_ips
            __props__.__dict__["auto_healing"] = auto_healing
            __props__.__dict__["custom_configure_recipes"] = custom_configure_recipes
            __props__.__dict__["custom_deploy_recipes"] = custom_deploy_recipes
            __props__.__dict__["custom_instance_profile_arn"] = custom_instance_profile_arn
            __props__.__dict__["custom_json"] = custom_json
            __props__.__dict__["custom_security_group_ids"] = custom_security_group_ids
            __props__.__dict__["custom_setup_recipes"] = custom_setup_recipes
            __props__.__dict__["custom_shutdown_recipes"] = custom_shutdown_recipes
            __props__.__dict__["custom_undeploy_recipes"] = custom_undeploy_recipes
            __props__.__dict__["drain_elb_on_shutdown"] = drain_elb_on_shutdown
            __props__.__dict__["ebs_volumes"] = ebs_volumes
            __props__.__dict__["elastic_load_balancer"] = elastic_load_balancer
            __props__.__dict__["healthcheck_method"] = healthcheck_method
            __props__.__dict__["healthcheck_url"] = healthcheck_url
            __props__.__dict__["install_updates_on_boot"] = install_updates_on_boot
            __props__.__dict__["instance_shutdown_timeout"] = instance_shutdown_timeout
            __props__.__dict__["name"] = name
            if stack_id is None and not opts.urn:
                raise TypeError("Missing required property 'stack_id'")
            __props__.__dict__["stack_id"] = stack_id
            __props__.__dict__["stats_enabled"] = stats_enabled
            if stats_password is None and not opts.urn:
                raise TypeError("Missing required property 'stats_password'")
            __props__.__dict__["stats_password"] = stats_password
            __props__.__dict__["stats_url"] = stats_url
            __props__.__dict__["stats_user"] = stats_user
            __props__.__dict__["system_packages"] = system_packages
            __props__.__dict__["tags"] = tags
            __props__.__dict__["use_ebs_optimized_instances"] = use_ebs_optimized_instances
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
        super(HaproxyLayer, __self__).__init__(
            'aws:opsworks/haproxyLayer:HaproxyLayer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            auto_assign_elastic_ips: Optional[pulumi.Input[bool]] = None,
            auto_assign_public_ips: Optional[pulumi.Input[bool]] = None,
            auto_healing: Optional[pulumi.Input[bool]] = None,
            custom_configure_recipes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            custom_deploy_recipes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            custom_instance_profile_arn: Optional[pulumi.Input[str]] = None,
            custom_json: Optional[pulumi.Input[str]] = None,
            custom_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            custom_setup_recipes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            custom_shutdown_recipes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            custom_undeploy_recipes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            drain_elb_on_shutdown: Optional[pulumi.Input[bool]] = None,
            ebs_volumes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['HaproxyLayerEbsVolumeArgs']]]]] = None,
            elastic_load_balancer: Optional[pulumi.Input[str]] = None,
            healthcheck_method: Optional[pulumi.Input[str]] = None,
            healthcheck_url: Optional[pulumi.Input[str]] = None,
            install_updates_on_boot: Optional[pulumi.Input[bool]] = None,
            instance_shutdown_timeout: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            stack_id: Optional[pulumi.Input[str]] = None,
            stats_enabled: Optional[pulumi.Input[bool]] = None,
            stats_password: Optional[pulumi.Input[str]] = None,
            stats_url: Optional[pulumi.Input[str]] = None,
            stats_user: Optional[pulumi.Input[str]] = None,
            system_packages: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            use_ebs_optimized_instances: Optional[pulumi.Input[bool]] = None) -> 'HaproxyLayer':
        """
        Get an existing HaproxyLayer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: The Amazon Resource Name(ARN) of the layer.
        :param pulumi.Input[bool] auto_assign_elastic_ips: Whether to automatically assign an elastic IP address to the layer's instances.
        :param pulumi.Input[bool] auto_assign_public_ips: For stacks belonging to a VPC, whether to automatically assign a public IP address to each of the layer's instances.
        :param pulumi.Input[bool] auto_healing: Whether to enable auto-healing for the layer.
        :param pulumi.Input[str] custom_instance_profile_arn: The ARN of an IAM profile that will be used for the layer's instances.
        :param pulumi.Input[str] custom_json: Custom JSON attributes to apply to the layer.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] custom_security_group_ids: Ids for a set of security groups to apply to the layer's instances.
        :param pulumi.Input[bool] drain_elb_on_shutdown: Whether to enable Elastic Load Balancing connection draining.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['HaproxyLayerEbsVolumeArgs']]]] ebs_volumes: `ebs_volume` blocks, as described below, will each create an EBS volume and connect it to the layer's instances.
        :param pulumi.Input[str] elastic_load_balancer: Name of an Elastic Load Balancer to attach to this layer
        :param pulumi.Input[str] healthcheck_method: HTTP method to use for instance healthchecks. Defaults to "OPTIONS".
        :param pulumi.Input[str] healthcheck_url: URL path to use for instance healthchecks. Defaults to "/".
        :param pulumi.Input[bool] install_updates_on_boot: Whether to install OS and package updates on each instance when it boots.
        :param pulumi.Input[int] instance_shutdown_timeout: The time, in seconds, that OpsWorks will wait for Chef to complete after triggering the Shutdown event.
        :param pulumi.Input[str] name: A human-readable name for the layer.
        :param pulumi.Input[str] stack_id: The id of the stack the layer will belong to.
        :param pulumi.Input[bool] stats_enabled: Whether to enable HAProxy stats.
        :param pulumi.Input[str] stats_password: The password to use for HAProxy stats.
        :param pulumi.Input[str] stats_url: The HAProxy stats URL. Defaults to "/haproxy?stats".
        :param pulumi.Input[str] stats_user: The username for HAProxy stats. Defaults to "opsworks".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] system_packages: Names of a set of system packages to install on the layer's instances.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider .
        :param pulumi.Input[bool] use_ebs_optimized_instances: Whether to use EBS-optimized instances.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HaproxyLayerState.__new__(_HaproxyLayerState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["auto_assign_elastic_ips"] = auto_assign_elastic_ips
        __props__.__dict__["auto_assign_public_ips"] = auto_assign_public_ips
        __props__.__dict__["auto_healing"] = auto_healing
        __props__.__dict__["custom_configure_recipes"] = custom_configure_recipes
        __props__.__dict__["custom_deploy_recipes"] = custom_deploy_recipes
        __props__.__dict__["custom_instance_profile_arn"] = custom_instance_profile_arn
        __props__.__dict__["custom_json"] = custom_json
        __props__.__dict__["custom_security_group_ids"] = custom_security_group_ids
        __props__.__dict__["custom_setup_recipes"] = custom_setup_recipes
        __props__.__dict__["custom_shutdown_recipes"] = custom_shutdown_recipes
        __props__.__dict__["custom_undeploy_recipes"] = custom_undeploy_recipes
        __props__.__dict__["drain_elb_on_shutdown"] = drain_elb_on_shutdown
        __props__.__dict__["ebs_volumes"] = ebs_volumes
        __props__.__dict__["elastic_load_balancer"] = elastic_load_balancer
        __props__.__dict__["healthcheck_method"] = healthcheck_method
        __props__.__dict__["healthcheck_url"] = healthcheck_url
        __props__.__dict__["install_updates_on_boot"] = install_updates_on_boot
        __props__.__dict__["instance_shutdown_timeout"] = instance_shutdown_timeout
        __props__.__dict__["name"] = name
        __props__.__dict__["stack_id"] = stack_id
        __props__.__dict__["stats_enabled"] = stats_enabled
        __props__.__dict__["stats_password"] = stats_password
        __props__.__dict__["stats_url"] = stats_url
        __props__.__dict__["stats_user"] = stats_user
        __props__.__dict__["system_packages"] = system_packages
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["use_ebs_optimized_instances"] = use_ebs_optimized_instances
        return HaproxyLayer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name(ARN) of the layer.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="autoAssignElasticIps")
    def auto_assign_elastic_ips(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to automatically assign an elastic IP address to the layer's instances.
        """
        return pulumi.get(self, "auto_assign_elastic_ips")

    @property
    @pulumi.getter(name="autoAssignPublicIps")
    def auto_assign_public_ips(self) -> pulumi.Output[Optional[bool]]:
        """
        For stacks belonging to a VPC, whether to automatically assign a public IP address to each of the layer's instances.
        """
        return pulumi.get(self, "auto_assign_public_ips")

    @property
    @pulumi.getter(name="autoHealing")
    def auto_healing(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to enable auto-healing for the layer.
        """
        return pulumi.get(self, "auto_healing")

    @property
    @pulumi.getter(name="customConfigureRecipes")
    def custom_configure_recipes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        return pulumi.get(self, "custom_configure_recipes")

    @property
    @pulumi.getter(name="customDeployRecipes")
    def custom_deploy_recipes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        return pulumi.get(self, "custom_deploy_recipes")

    @property
    @pulumi.getter(name="customInstanceProfileArn")
    def custom_instance_profile_arn(self) -> pulumi.Output[Optional[str]]:
        """
        The ARN of an IAM profile that will be used for the layer's instances.
        """
        return pulumi.get(self, "custom_instance_profile_arn")

    @property
    @pulumi.getter(name="customJson")
    def custom_json(self) -> pulumi.Output[Optional[str]]:
        """
        Custom JSON attributes to apply to the layer.
        """
        return pulumi.get(self, "custom_json")

    @property
    @pulumi.getter(name="customSecurityGroupIds")
    def custom_security_group_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Ids for a set of security groups to apply to the layer's instances.
        """
        return pulumi.get(self, "custom_security_group_ids")

    @property
    @pulumi.getter(name="customSetupRecipes")
    def custom_setup_recipes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        return pulumi.get(self, "custom_setup_recipes")

    @property
    @pulumi.getter(name="customShutdownRecipes")
    def custom_shutdown_recipes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        return pulumi.get(self, "custom_shutdown_recipes")

    @property
    @pulumi.getter(name="customUndeployRecipes")
    def custom_undeploy_recipes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        return pulumi.get(self, "custom_undeploy_recipes")

    @property
    @pulumi.getter(name="drainElbOnShutdown")
    def drain_elb_on_shutdown(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to enable Elastic Load Balancing connection draining.
        """
        return pulumi.get(self, "drain_elb_on_shutdown")

    @property
    @pulumi.getter(name="ebsVolumes")
    def ebs_volumes(self) -> pulumi.Output[Optional[Sequence['outputs.HaproxyLayerEbsVolume']]]:
        """
        `ebs_volume` blocks, as described below, will each create an EBS volume and connect it to the layer's instances.
        """
        return pulumi.get(self, "ebs_volumes")

    @property
    @pulumi.getter(name="elasticLoadBalancer")
    def elastic_load_balancer(self) -> pulumi.Output[Optional[str]]:
        """
        Name of an Elastic Load Balancer to attach to this layer
        """
        return pulumi.get(self, "elastic_load_balancer")

    @property
    @pulumi.getter(name="healthcheckMethod")
    def healthcheck_method(self) -> pulumi.Output[Optional[str]]:
        """
        HTTP method to use for instance healthchecks. Defaults to "OPTIONS".
        """
        return pulumi.get(self, "healthcheck_method")

    @property
    @pulumi.getter(name="healthcheckUrl")
    def healthcheck_url(self) -> pulumi.Output[Optional[str]]:
        """
        URL path to use for instance healthchecks. Defaults to "/".
        """
        return pulumi.get(self, "healthcheck_url")

    @property
    @pulumi.getter(name="installUpdatesOnBoot")
    def install_updates_on_boot(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to install OS and package updates on each instance when it boots.
        """
        return pulumi.get(self, "install_updates_on_boot")

    @property
    @pulumi.getter(name="instanceShutdownTimeout")
    def instance_shutdown_timeout(self) -> pulumi.Output[Optional[int]]:
        """
        The time, in seconds, that OpsWorks will wait for Chef to complete after triggering the Shutdown event.
        """
        return pulumi.get(self, "instance_shutdown_timeout")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A human-readable name for the layer.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> pulumi.Output[str]:
        """
        The id of the stack the layer will belong to.
        """
        return pulumi.get(self, "stack_id")

    @property
    @pulumi.getter(name="statsEnabled")
    def stats_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to enable HAProxy stats.
        """
        return pulumi.get(self, "stats_enabled")

    @property
    @pulumi.getter(name="statsPassword")
    def stats_password(self) -> pulumi.Output[str]:
        """
        The password to use for HAProxy stats.
        """
        return pulumi.get(self, "stats_password")

    @property
    @pulumi.getter(name="statsUrl")
    def stats_url(self) -> pulumi.Output[Optional[str]]:
        """
        The HAProxy stats URL. Defaults to "/haproxy?stats".
        """
        return pulumi.get(self, "stats_url")

    @property
    @pulumi.getter(name="statsUser")
    def stats_user(self) -> pulumi.Output[Optional[str]]:
        """
        The username for HAProxy stats. Defaults to "opsworks".
        """
        return pulumi.get(self, "stats_user")

    @property
    @pulumi.getter(name="systemPackages")
    def system_packages(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Names of a set of system packages to install on the layer's instances.
        """
        return pulumi.get(self, "system_packages")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider .
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="useEbsOptimizedInstances")
    def use_ebs_optimized_instances(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to use EBS-optimized instances.
        """
        return pulumi.get(self, "use_ebs_optimized_instances")

