# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ScramSecretAssociationArgs', 'ScramSecretAssociation']

@pulumi.input_type
class ScramSecretAssociationArgs:
    def __init__(__self__, *,
                 cluster_arn: pulumi.Input[str],
                 secret_arn_lists: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        The set of arguments for constructing a ScramSecretAssociation resource.
        :param pulumi.Input[str] cluster_arn: Amazon Resource Name (ARN) of the MSK cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] secret_arn_lists: List of AWS Secrets Manager secret ARNs.
        """
        pulumi.set(__self__, "cluster_arn", cluster_arn)
        pulumi.set(__self__, "secret_arn_lists", secret_arn_lists)

    @property
    @pulumi.getter(name="clusterArn")
    def cluster_arn(self) -> pulumi.Input[str]:
        """
        Amazon Resource Name (ARN) of the MSK cluster.
        """
        return pulumi.get(self, "cluster_arn")

    @cluster_arn.setter
    def cluster_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_arn", value)

    @property
    @pulumi.getter(name="secretArnLists")
    def secret_arn_lists(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of AWS Secrets Manager secret ARNs.
        """
        return pulumi.get(self, "secret_arn_lists")

    @secret_arn_lists.setter
    def secret_arn_lists(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "secret_arn_lists", value)


@pulumi.input_type
class _ScramSecretAssociationState:
    def __init__(__self__, *,
                 cluster_arn: Optional[pulumi.Input[str]] = None,
                 secret_arn_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering ScramSecretAssociation resources.
        :param pulumi.Input[str] cluster_arn: Amazon Resource Name (ARN) of the MSK cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] secret_arn_lists: List of AWS Secrets Manager secret ARNs.
        """
        if cluster_arn is not None:
            pulumi.set(__self__, "cluster_arn", cluster_arn)
        if secret_arn_lists is not None:
            pulumi.set(__self__, "secret_arn_lists", secret_arn_lists)

    @property
    @pulumi.getter(name="clusterArn")
    def cluster_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name (ARN) of the MSK cluster.
        """
        return pulumi.get(self, "cluster_arn")

    @cluster_arn.setter
    def cluster_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_arn", value)

    @property
    @pulumi.getter(name="secretArnLists")
    def secret_arn_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of AWS Secrets Manager secret ARNs.
        """
        return pulumi.get(self, "secret_arn_lists")

    @secret_arn_lists.setter
    def secret_arn_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "secret_arn_lists", value)


class ScramSecretAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_arn: Optional[pulumi.Input[str]] = None,
                 secret_arn_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        ## Import

        MSK SCRAM Secret Associations can be imported using the `id` e.g.,

        ```sh
         $ pulumi import aws:msk/scramSecretAssociation:ScramSecretAssociation example arn:aws:kafka:us-west-2:123456789012:cluster/example/279c0212-d057-4dba-9aa9-1c4e5a25bfc7-3
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_arn: Amazon Resource Name (ARN) of the MSK cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] secret_arn_lists: List of AWS Secrets Manager secret ARNs.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ScramSecretAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        MSK SCRAM Secret Associations can be imported using the `id` e.g.,

        ```sh
         $ pulumi import aws:msk/scramSecretAssociation:ScramSecretAssociation example arn:aws:kafka:us-west-2:123456789012:cluster/example/279c0212-d057-4dba-9aa9-1c4e5a25bfc7-3
        ```

        :param str resource_name: The name of the resource.
        :param ScramSecretAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ScramSecretAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_arn: Optional[pulumi.Input[str]] = None,
                 secret_arn_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ScramSecretAssociationArgs.__new__(ScramSecretAssociationArgs)

            if cluster_arn is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_arn'")
            __props__.__dict__["cluster_arn"] = cluster_arn
            if secret_arn_lists is None and not opts.urn:
                raise TypeError("Missing required property 'secret_arn_lists'")
            __props__.__dict__["secret_arn_lists"] = secret_arn_lists
        super(ScramSecretAssociation, __self__).__init__(
            'aws:msk/scramSecretAssociation:ScramSecretAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_arn: Optional[pulumi.Input[str]] = None,
            secret_arn_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'ScramSecretAssociation':
        """
        Get an existing ScramSecretAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_arn: Amazon Resource Name (ARN) of the MSK cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] secret_arn_lists: List of AWS Secrets Manager secret ARNs.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ScramSecretAssociationState.__new__(_ScramSecretAssociationState)

        __props__.__dict__["cluster_arn"] = cluster_arn
        __props__.__dict__["secret_arn_lists"] = secret_arn_lists
        return ScramSecretAssociation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clusterArn")
    def cluster_arn(self) -> pulumi.Output[str]:
        """
        Amazon Resource Name (ARN) of the MSK cluster.
        """
        return pulumi.get(self, "cluster_arn")

    @property
    @pulumi.getter(name="secretArnLists")
    def secret_arn_lists(self) -> pulumi.Output[Sequence[str]]:
        """
        List of AWS Secrets Manager secret ARNs.
        """
        return pulumi.get(self, "secret_arn_lists")

