# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'OntapFileSystemDiskIopsConfigurationArgs',
    'OntapFileSystemEndpointArgs',
    'OntapFileSystemEndpointInterclusterArgs',
    'OntapFileSystemEndpointManagementArgs',
    'WindowsFileSystemAuditLogConfigurationArgs',
    'WindowsFileSystemSelfManagedActiveDirectoryArgs',
]

@pulumi.input_type
class OntapFileSystemDiskIopsConfigurationArgs:
    def __init__(__self__, *,
                 iops: Optional[pulumi.Input[int]] = None,
                 mode: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] iops: - The total number of SSD IOPS provisioned for the file system.
        :param pulumi.Input[str] mode: - Specifies whether the number of IOPS for the file system is using the system. Valid values are `AUTOMATIC` and `USER_PROVISIONED`. Default value is `AUTOMATIC`.
        """
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[int]]:
        """
        - The total number of SSD IOPS provisioned for the file system.
        """
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "iops", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[str]]:
        """
        - Specifies whether the number of IOPS for the file system is using the system. Valid values are `AUTOMATIC` and `USER_PROVISIONED`. Default value is `AUTOMATIC`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mode", value)


@pulumi.input_type
class OntapFileSystemEndpointArgs:
    def __init__(__self__, *,
                 interclusters: Optional[pulumi.Input[Sequence[pulumi.Input['OntapFileSystemEndpointInterclusterArgs']]]] = None,
                 managements: Optional[pulumi.Input[Sequence[pulumi.Input['OntapFileSystemEndpointManagementArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['OntapFileSystemEndpointInterclusterArgs']]] interclusters: An endpoint for managing your file system by setting up NetApp SnapMirror with other ONTAP systems. See Endpoint.
        :param pulumi.Input[Sequence[pulumi.Input['OntapFileSystemEndpointManagementArgs']]] managements: An endpoint for managing your file system using the NetApp ONTAP CLI and NetApp ONTAP API. See Endpoint.
        """
        if interclusters is not None:
            pulumi.set(__self__, "interclusters", interclusters)
        if managements is not None:
            pulumi.set(__self__, "managements", managements)

    @property
    @pulumi.getter
    def interclusters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OntapFileSystemEndpointInterclusterArgs']]]]:
        """
        An endpoint for managing your file system by setting up NetApp SnapMirror with other ONTAP systems. See Endpoint.
        """
        return pulumi.get(self, "interclusters")

    @interclusters.setter
    def interclusters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OntapFileSystemEndpointInterclusterArgs']]]]):
        pulumi.set(self, "interclusters", value)

    @property
    @pulumi.getter
    def managements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OntapFileSystemEndpointManagementArgs']]]]:
        """
        An endpoint for managing your file system using the NetApp ONTAP CLI and NetApp ONTAP API. See Endpoint.
        """
        return pulumi.get(self, "managements")

    @managements.setter
    def managements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OntapFileSystemEndpointManagementArgs']]]]):
        pulumi.set(self, "managements", value)


@pulumi.input_type
class OntapFileSystemEndpointInterclusterArgs:
    def __init__(__self__, *,
                 dns_name: Optional[pulumi.Input[str]] = None,
                 ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] dns_name: The Domain Name Service (DNS) name for the file system. You can mount your file system using its DNS name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_addresses: IP addresses of the file system endpoint.
        """
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[pulumi.Input[str]]:
        """
        The Domain Name Service (DNS) name for the file system. You can mount your file system using its DNS name.
        """
        return pulumi.get(self, "dns_name")

    @dns_name.setter
    def dns_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_name", value)

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        IP addresses of the file system endpoint.
        """
        return pulumi.get(self, "ip_addresses")

    @ip_addresses.setter
    def ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ip_addresses", value)


@pulumi.input_type
class OntapFileSystemEndpointManagementArgs:
    def __init__(__self__, *,
                 dns_name: Optional[pulumi.Input[str]] = None,
                 ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] dns_name: The Domain Name Service (DNS) name for the file system. You can mount your file system using its DNS name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_addresses: IP addresses of the file system endpoint.
        """
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[pulumi.Input[str]]:
        """
        The Domain Name Service (DNS) name for the file system. You can mount your file system using its DNS name.
        """
        return pulumi.get(self, "dns_name")

    @dns_name.setter
    def dns_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_name", value)

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        IP addresses of the file system endpoint.
        """
        return pulumi.get(self, "ip_addresses")

    @ip_addresses.setter
    def ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ip_addresses", value)


@pulumi.input_type
class WindowsFileSystemAuditLogConfigurationArgs:
    def __init__(__self__, *,
                 audit_log_destination: Optional[pulumi.Input[str]] = None,
                 file_access_audit_log_level: Optional[pulumi.Input[str]] = None,
                 file_share_access_audit_log_level: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] audit_log_destination: The Amazon Resource Name (ARN) for the destination of the audit logs. The destination can be any Amazon CloudWatch Logs log group ARN or Amazon Kinesis Data Firehose delivery stream ARN. Can be specified when `file_access_audit_log_level` and `file_share_access_audit_log_level` are not set to `DISABLED`. The name of the Amazon CloudWatch Logs log group must begin with the `/aws/fsx` prefix. The name of the Amazon Kinesis Data Firehouse delivery stream must begin with the `aws-fsx` prefix. If you do not provide a destination in `audit_log_destionation`, Amazon FSx will create and use a log stream in the CloudWatch Logs /aws/fsx/windows log group.
        :param pulumi.Input[str] file_access_audit_log_level: Sets which attempt type is logged by Amazon FSx for file and folder accesses. Valid values are `SUCCESS_ONLY`, `FAILURE_ONLY`, `SUCCESS_AND_FAILURE`, and `DISABLED`. Default value is `DISABLED`.
        :param pulumi.Input[str] file_share_access_audit_log_level: Sets which attempt type is logged by Amazon FSx for file share accesses. Valid values are `SUCCESS_ONLY`, `FAILURE_ONLY`, `SUCCESS_AND_FAILURE`, and `DISABLED`. Default value is `DISABLED`.
        """
        if audit_log_destination is not None:
            pulumi.set(__self__, "audit_log_destination", audit_log_destination)
        if file_access_audit_log_level is not None:
            pulumi.set(__self__, "file_access_audit_log_level", file_access_audit_log_level)
        if file_share_access_audit_log_level is not None:
            pulumi.set(__self__, "file_share_access_audit_log_level", file_share_access_audit_log_level)

    @property
    @pulumi.getter(name="auditLogDestination")
    def audit_log_destination(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) for the destination of the audit logs. The destination can be any Amazon CloudWatch Logs log group ARN or Amazon Kinesis Data Firehose delivery stream ARN. Can be specified when `file_access_audit_log_level` and `file_share_access_audit_log_level` are not set to `DISABLED`. The name of the Amazon CloudWatch Logs log group must begin with the `/aws/fsx` prefix. The name of the Amazon Kinesis Data Firehouse delivery stream must begin with the `aws-fsx` prefix. If you do not provide a destination in `audit_log_destionation`, Amazon FSx will create and use a log stream in the CloudWatch Logs /aws/fsx/windows log group.
        """
        return pulumi.get(self, "audit_log_destination")

    @audit_log_destination.setter
    def audit_log_destination(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "audit_log_destination", value)

    @property
    @pulumi.getter(name="fileAccessAuditLogLevel")
    def file_access_audit_log_level(self) -> Optional[pulumi.Input[str]]:
        """
        Sets which attempt type is logged by Amazon FSx for file and folder accesses. Valid values are `SUCCESS_ONLY`, `FAILURE_ONLY`, `SUCCESS_AND_FAILURE`, and `DISABLED`. Default value is `DISABLED`.
        """
        return pulumi.get(self, "file_access_audit_log_level")

    @file_access_audit_log_level.setter
    def file_access_audit_log_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_access_audit_log_level", value)

    @property
    @pulumi.getter(name="fileShareAccessAuditLogLevel")
    def file_share_access_audit_log_level(self) -> Optional[pulumi.Input[str]]:
        """
        Sets which attempt type is logged by Amazon FSx for file share accesses. Valid values are `SUCCESS_ONLY`, `FAILURE_ONLY`, `SUCCESS_AND_FAILURE`, and `DISABLED`. Default value is `DISABLED`.
        """
        return pulumi.get(self, "file_share_access_audit_log_level")

    @file_share_access_audit_log_level.setter
    def file_share_access_audit_log_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_share_access_audit_log_level", value)


@pulumi.input_type
class WindowsFileSystemSelfManagedActiveDirectoryArgs:
    def __init__(__self__, *,
                 dns_ips: pulumi.Input[Sequence[pulumi.Input[str]]],
                 domain_name: pulumi.Input[str],
                 password: pulumi.Input[str],
                 username: pulumi.Input[str],
                 file_system_administrators_group: Optional[pulumi.Input[str]] = None,
                 organizational_unit_distinguished_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_ips: A list of up to two IP addresses of DNS servers or domain controllers in the self-managed AD directory. The IP addresses need to be either in the same VPC CIDR range as the file system or in the private IP version 4 (IPv4) address ranges as specified in [RFC 1918](https://tools.ietf.org/html/rfc1918).
        :param pulumi.Input[str] domain_name: The fully qualified domain name of the self-managed AD directory. For example, `corp.example.com`.
        :param pulumi.Input[str] password: The password for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
        :param pulumi.Input[str] username: The user name for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
        :param pulumi.Input[str] file_system_administrators_group: The name of the domain group whose members are granted administrative privileges for the file system. Administrative privileges include taking ownership of files and folders, and setting audit controls (audit ACLs) on files and folders. The group that you specify must already exist in your domain. Defaults to `Domain Admins`.
        :param pulumi.Input[str] organizational_unit_distinguished_name: The fully qualified distinguished name of the organizational unit within your self-managed AD directory that the Windows File Server instance will join. For example, `OU=FSx,DC=yourdomain,DC=corp,DC=com`. Only accepts OU as the direct parent of the file system. If none is provided, the FSx file system is created in the default location of your self-managed AD directory. To learn more, see [RFC 2253](https://tools.ietf.org/html/rfc2253).
        """
        pulumi.set(__self__, "dns_ips", dns_ips)
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)
        if file_system_administrators_group is not None:
            pulumi.set(__self__, "file_system_administrators_group", file_system_administrators_group)
        if organizational_unit_distinguished_name is not None:
            pulumi.set(__self__, "organizational_unit_distinguished_name", organizational_unit_distinguished_name)

    @property
    @pulumi.getter(name="dnsIps")
    def dns_ips(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of up to two IP addresses of DNS servers or domain controllers in the self-managed AD directory. The IP addresses need to be either in the same VPC CIDR range as the file system or in the private IP version 4 (IPv4) address ranges as specified in [RFC 1918](https://tools.ietf.org/html/rfc1918).
        """
        return pulumi.get(self, "dns_ips")

    @dns_ips.setter
    def dns_ips(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "dns_ips", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[str]:
        """
        The fully qualified domain name of the self-managed AD directory. For example, `corp.example.com`.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        The password for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        The user name for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="fileSystemAdministratorsGroup")
    def file_system_administrators_group(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the domain group whose members are granted administrative privileges for the file system. Administrative privileges include taking ownership of files and folders, and setting audit controls (audit ACLs) on files and folders. The group that you specify must already exist in your domain. Defaults to `Domain Admins`.
        """
        return pulumi.get(self, "file_system_administrators_group")

    @file_system_administrators_group.setter
    def file_system_administrators_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_system_administrators_group", value)

    @property
    @pulumi.getter(name="organizationalUnitDistinguishedName")
    def organizational_unit_distinguished_name(self) -> Optional[pulumi.Input[str]]:
        """
        The fully qualified distinguished name of the organizational unit within your self-managed AD directory that the Windows File Server instance will join. For example, `OU=FSx,DC=yourdomain,DC=corp,DC=com`. Only accepts OU as the direct parent of the file system. If none is provided, the FSx file system is created in the default location of your self-managed AD directory. To learn more, see [RFC 2253](https://tools.ietf.org/html/rfc2253).
        """
        return pulumi.get(self, "organizational_unit_distinguished_name")

    @organizational_unit_distinguished_name.setter
    def organizational_unit_distinguished_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organizational_unit_distinguished_name", value)


