# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ManagedScalingPolicyArgs', 'ManagedScalingPolicy']

@pulumi.input_type
class ManagedScalingPolicyArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[str],
                 compute_limits: pulumi.Input[Sequence[pulumi.Input['ManagedScalingPolicyComputeLimitArgs']]]):
        """
        The set of arguments for constructing a ManagedScalingPolicy resource.
        :param pulumi.Input[str] cluster_id: The id of the EMR cluster
        :param pulumi.Input[Sequence[pulumi.Input['ManagedScalingPolicyComputeLimitArgs']]] compute_limits: Configuration block with compute limit settings. Described below.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "compute_limits", compute_limits)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[str]:
        """
        The id of the EMR cluster
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="computeLimits")
    def compute_limits(self) -> pulumi.Input[Sequence[pulumi.Input['ManagedScalingPolicyComputeLimitArgs']]]:
        """
        Configuration block with compute limit settings. Described below.
        """
        return pulumi.get(self, "compute_limits")

    @compute_limits.setter
    def compute_limits(self, value: pulumi.Input[Sequence[pulumi.Input['ManagedScalingPolicyComputeLimitArgs']]]):
        pulumi.set(self, "compute_limits", value)


@pulumi.input_type
class _ManagedScalingPolicyState:
    def __init__(__self__, *,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 compute_limits: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedScalingPolicyComputeLimitArgs']]]] = None):
        """
        Input properties used for looking up and filtering ManagedScalingPolicy resources.
        :param pulumi.Input[str] cluster_id: The id of the EMR cluster
        :param pulumi.Input[Sequence[pulumi.Input['ManagedScalingPolicyComputeLimitArgs']]] compute_limits: Configuration block with compute limit settings. Described below.
        """
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if compute_limits is not None:
            pulumi.set(__self__, "compute_limits", compute_limits)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the EMR cluster
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="computeLimits")
    def compute_limits(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedScalingPolicyComputeLimitArgs']]]]:
        """
        Configuration block with compute limit settings. Described below.
        """
        return pulumi.get(self, "compute_limits")

    @compute_limits.setter
    def compute_limits(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedScalingPolicyComputeLimitArgs']]]]):
        pulumi.set(self, "compute_limits", value)


class ManagedScalingPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 compute_limits: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ManagedScalingPolicyComputeLimitArgs']]]]] = None,
                 __props__=None):
        """
        Provides a Managed Scaling policy for EMR Cluster. With Amazon EMR versions 5.30.0 and later (except for Amazon EMR 6.0.0), you can enable EMR managed scaling to automatically increase or decrease the number of instances or units in your cluster based on workload. See [Using EMR Managed Scaling in Amazon EMR](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-managed-scaling.html) for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        sample = aws.emr.Cluster("sample",
            release_label="emr-5.30.0",
            master_instance_group=aws.emr.ClusterMasterInstanceGroupArgs(
                instance_type="m4.large",
            ),
            core_instance_group=aws.emr.ClusterCoreInstanceGroupArgs(
                instance_type="c4.large",
            ))
        # skip ...
        samplepolicy = aws.emr.ManagedScalingPolicy("samplepolicy",
            cluster_id=sample.id,
            compute_limits=[aws.emr.ManagedScalingPolicyComputeLimitArgs(
                unit_type="Instances",
                minimum_capacity_units=2,
                maximum_capacity_units=10,
                maximum_ondemand_capacity_units=2,
                maximum_core_capacity_units=10,
            )])
        ```

        ## Import

        EMR Managed Scaling Policies can be imported via the EMR Cluster identifier, e.g., console

        ```sh
         $ pulumi import aws:emr/managedScalingPolicy:ManagedScalingPolicy example j-123456ABCDEF
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_id: The id of the EMR cluster
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ManagedScalingPolicyComputeLimitArgs']]]] compute_limits: Configuration block with compute limit settings. Described below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedScalingPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Managed Scaling policy for EMR Cluster. With Amazon EMR versions 5.30.0 and later (except for Amazon EMR 6.0.0), you can enable EMR managed scaling to automatically increase or decrease the number of instances or units in your cluster based on workload. See [Using EMR Managed Scaling in Amazon EMR](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-managed-scaling.html) for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        sample = aws.emr.Cluster("sample",
            release_label="emr-5.30.0",
            master_instance_group=aws.emr.ClusterMasterInstanceGroupArgs(
                instance_type="m4.large",
            ),
            core_instance_group=aws.emr.ClusterCoreInstanceGroupArgs(
                instance_type="c4.large",
            ))
        # skip ...
        samplepolicy = aws.emr.ManagedScalingPolicy("samplepolicy",
            cluster_id=sample.id,
            compute_limits=[aws.emr.ManagedScalingPolicyComputeLimitArgs(
                unit_type="Instances",
                minimum_capacity_units=2,
                maximum_capacity_units=10,
                maximum_ondemand_capacity_units=2,
                maximum_core_capacity_units=10,
            )])
        ```

        ## Import

        EMR Managed Scaling Policies can be imported via the EMR Cluster identifier, e.g., console

        ```sh
         $ pulumi import aws:emr/managedScalingPolicy:ManagedScalingPolicy example j-123456ABCDEF
        ```

        :param str resource_name: The name of the resource.
        :param ManagedScalingPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedScalingPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 compute_limits: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ManagedScalingPolicyComputeLimitArgs']]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedScalingPolicyArgs.__new__(ManagedScalingPolicyArgs)

            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            if compute_limits is None and not opts.urn:
                raise TypeError("Missing required property 'compute_limits'")
            __props__.__dict__["compute_limits"] = compute_limits
        super(ManagedScalingPolicy, __self__).__init__(
            'aws:emr/managedScalingPolicy:ManagedScalingPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_id: Optional[pulumi.Input[str]] = None,
            compute_limits: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ManagedScalingPolicyComputeLimitArgs']]]]] = None) -> 'ManagedScalingPolicy':
        """
        Get an existing ManagedScalingPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_id: The id of the EMR cluster
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ManagedScalingPolicyComputeLimitArgs']]]] compute_limits: Configuration block with compute limit settings. Described below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedScalingPolicyState.__new__(_ManagedScalingPolicyState)

        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["compute_limits"] = compute_limits
        return ManagedScalingPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[str]:
        """
        The id of the EMR cluster
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="computeLimits")
    def compute_limits(self) -> pulumi.Output[Sequence['outputs.ManagedScalingPolicyComputeLimit']]:
        """
        Configuration block with compute limit settings. Described below.
        """
        return pulumi.get(self, "compute_limits")

