# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'ReplicationConfigurationReplicationConfiguration',
    'ReplicationConfigurationReplicationConfigurationRule',
    'ReplicationConfigurationReplicationConfigurationRuleDestination',
    'RepositoryEncryptionConfiguration',
    'RepositoryImageScanningConfiguration',
    'GetRepositoryEncryptionConfigurationResult',
    'GetRepositoryImageScanningConfigurationResult',
]

@pulumi.output_type
class ReplicationConfigurationReplicationConfiguration(dict):
    def __init__(__self__, *,
                 rule: 'outputs.ReplicationConfigurationReplicationConfigurationRule'):
        """
        :param 'ReplicationConfigurationReplicationConfigurationRuleArgs' rule: The replication rules for a replication configuration. See Rule.
        """
        pulumi.set(__self__, "rule", rule)

    @property
    @pulumi.getter
    def rule(self) -> 'outputs.ReplicationConfigurationReplicationConfigurationRule':
        """
        The replication rules for a replication configuration. See Rule.
        """
        return pulumi.get(self, "rule")


@pulumi.output_type
class ReplicationConfigurationReplicationConfigurationRule(dict):
    def __init__(__self__, *,
                 destinations: Sequence['outputs.ReplicationConfigurationReplicationConfigurationRuleDestination']):
        """
        :param Sequence['ReplicationConfigurationReplicationConfigurationRuleDestinationArgs'] destinations: the details of a replication destination. See Destination.
        """
        pulumi.set(__self__, "destinations", destinations)

    @property
    @pulumi.getter
    def destinations(self) -> Sequence['outputs.ReplicationConfigurationReplicationConfigurationRuleDestination']:
        """
        the details of a replication destination. See Destination.
        """
        return pulumi.get(self, "destinations")


@pulumi.output_type
class ReplicationConfigurationReplicationConfigurationRuleDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "registryId":
            suggest = "registry_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicationConfigurationReplicationConfigurationRuleDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicationConfigurationReplicationConfigurationRuleDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicationConfigurationReplicationConfigurationRuleDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 region: str,
                 registry_id: str):
        """
        :param str region: A Region to replicate to.
        :param str registry_id: The account ID of the destination registry to replicate to.
        """
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "registry_id", registry_id)

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        A Region to replicate to.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="registryId")
    def registry_id(self) -> str:
        """
        The account ID of the destination registry to replicate to.
        """
        return pulumi.get(self, "registry_id")


@pulumi.output_type
class RepositoryEncryptionConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionType":
            suggest = "encryption_type"
        elif key == "kmsKey":
            suggest = "kms_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryEncryptionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryEncryptionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryEncryptionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption_type: Optional[str] = None,
                 kms_key: Optional[str] = None):
        """
        :param str encryption_type: The encryption type to use for the repository. Valid values are `AES256` or `KMS`. Defaults to `AES256`.
        :param str kms_key: The ARN of the KMS key to use when `encryption_type` is `KMS`. If not specified, uses the default AWS managed key for ECR.
        """
        if encryption_type is not None:
            pulumi.set(__self__, "encryption_type", encryption_type)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)

    @property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> Optional[str]:
        """
        The encryption type to use for the repository. Valid values are `AES256` or `KMS`. Defaults to `AES256`.
        """
        return pulumi.get(self, "encryption_type")

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[str]:
        """
        The ARN of the KMS key to use when `encryption_type` is `KMS`. If not specified, uses the default AWS managed key for ECR.
        """
        return pulumi.get(self, "kms_key")


@pulumi.output_type
class RepositoryImageScanningConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scanOnPush":
            suggest = "scan_on_push"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryImageScanningConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryImageScanningConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryImageScanningConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 scan_on_push: bool):
        """
        :param bool scan_on_push: Indicates whether images are scanned after being pushed to the repository (true) or not scanned (false).
        """
        pulumi.set(__self__, "scan_on_push", scan_on_push)

    @property
    @pulumi.getter(name="scanOnPush")
    def scan_on_push(self) -> bool:
        """
        Indicates whether images are scanned after being pushed to the repository (true) or not scanned (false).
        """
        return pulumi.get(self, "scan_on_push")


@pulumi.output_type
class GetRepositoryEncryptionConfigurationResult(dict):
    def __init__(__self__, *,
                 encryption_type: str,
                 kms_key: str):
        """
        :param str encryption_type: The encryption type to use for the repository, either `AES256` or `KMS`.
        :param str kms_key: If `encryption_type` is `KMS`, the ARN of the KMS key used.
        """
        pulumi.set(__self__, "encryption_type", encryption_type)
        pulumi.set(__self__, "kms_key", kms_key)

    @property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> str:
        """
        The encryption type to use for the repository, either `AES256` or `KMS`.
        """
        return pulumi.get(self, "encryption_type")

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> str:
        """
        If `encryption_type` is `KMS`, the ARN of the KMS key used.
        """
        return pulumi.get(self, "kms_key")


@pulumi.output_type
class GetRepositoryImageScanningConfigurationResult(dict):
    def __init__(__self__, *,
                 scan_on_push: bool):
        """
        :param bool scan_on_push: Indicates whether images are scanned after being pushed to the repository.
        """
        pulumi.set(__self__, "scan_on_push", scan_on_push)

    @property
    @pulumi.getter(name="scanOnPush")
    def scan_on_push(self) -> bool:
        """
        Indicates whether images are scanned after being pushed to the repository.
        """
        return pulumi.get(self, "scan_on_push")


