# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SnapshotImportArgs', 'SnapshotImport']

@pulumi.input_type
class SnapshotImportArgs:
    def __init__(__self__, *,
                 disk_container: pulumi.Input['SnapshotImportDiskContainerArgs'],
                 client_data: Optional[pulumi.Input['SnapshotImportClientDataArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encrypted: Optional[pulumi.Input[bool]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 role_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a SnapshotImport resource.
        :param pulumi.Input['SnapshotImportDiskContainerArgs'] disk_container: Information about the disk container. Detailed below.
        :param pulumi.Input['SnapshotImportClientDataArgs'] client_data: The client-specific data. Detailed below.
        :param pulumi.Input[str] description: The description of the disk image being imported.
        :param pulumi.Input[bool] encrypted: Specifies whether the destination snapshot of the imported image should be encrypted. The default KMS key for EBS is used unless you specify a non-default KMS key using KmsKeyId.
        :param pulumi.Input[str] kms_key_id: An identifier for the symmetric KMS key to use when creating the encrypted snapshot. This parameter is only required if you want to use a non-default KMS key; if this parameter is not specified, the default KMS key for EBS is used. If a KmsKeyId is specified, the Encrypted flag must also be set.
        :param pulumi.Input[str] role_name: The name of the IAM Role the VM Import/Export service will assume. This role needs certain permissions. See https://docs.aws.amazon.com/vm-import/latest/userguide/vmie_prereqs.html#vmimport-role. Default: `vmimport`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the snapshot.
        """
        pulumi.set(__self__, "disk_container", disk_container)
        if client_data is not None:
            pulumi.set(__self__, "client_data", client_data)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="diskContainer")
    def disk_container(self) -> pulumi.Input['SnapshotImportDiskContainerArgs']:
        """
        Information about the disk container. Detailed below.
        """
        return pulumi.get(self, "disk_container")

    @disk_container.setter
    def disk_container(self, value: pulumi.Input['SnapshotImportDiskContainerArgs']):
        pulumi.set(self, "disk_container", value)

    @property
    @pulumi.getter(name="clientData")
    def client_data(self) -> Optional[pulumi.Input['SnapshotImportClientDataArgs']]:
        """
        The client-specific data. Detailed below.
        """
        return pulumi.get(self, "client_data")

    @client_data.setter
    def client_data(self, value: Optional[pulumi.Input['SnapshotImportClientDataArgs']]):
        pulumi.set(self, "client_data", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the disk image being imported.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the destination snapshot of the imported image should be encrypted. The default KMS key for EBS is used unless you specify a non-default KMS key using KmsKeyId.
        """
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypted", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        An identifier for the symmetric KMS key to use when creating the encrypted snapshot. This parameter is only required if you want to use a non-default KMS key; if this parameter is not specified, the default KMS key for EBS is used. If a KmsKeyId is specified, the Encrypted flag must also be set.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the IAM Role the VM Import/Export service will assume. This role needs certain permissions. See https://docs.aws.amazon.com/vm-import/latest/userguide/vmie_prereqs.html#vmimport-role. Default: `vmimport`
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the snapshot.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _SnapshotImportState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 client_data: Optional[pulumi.Input['SnapshotImportClientDataArgs']] = None,
                 data_encryption_key_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disk_container: Optional[pulumi.Input['SnapshotImportDiskContainerArgs']] = None,
                 encrypted: Optional[pulumi.Input[bool]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 owner_alias: Optional[pulumi.Input[str]] = None,
                 owner_id: Optional[pulumi.Input[str]] = None,
                 role_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 volume_size: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering SnapshotImport resources.
        :param pulumi.Input[str] arn: Amazon Resource Name (ARN) of the EBS Snapshot.
        :param pulumi.Input['SnapshotImportClientDataArgs'] client_data: The client-specific data. Detailed below.
        :param pulumi.Input[str] data_encryption_key_id: The data encryption key identifier for the snapshot.
        :param pulumi.Input[str] description: The description of the disk image being imported.
        :param pulumi.Input['SnapshotImportDiskContainerArgs'] disk_container: Information about the disk container. Detailed below.
        :param pulumi.Input[bool] encrypted: Specifies whether the destination snapshot of the imported image should be encrypted. The default KMS key for EBS is used unless you specify a non-default KMS key using KmsKeyId.
        :param pulumi.Input[str] kms_key_id: An identifier for the symmetric KMS key to use when creating the encrypted snapshot. This parameter is only required if you want to use a non-default KMS key; if this parameter is not specified, the default KMS key for EBS is used. If a KmsKeyId is specified, the Encrypted flag must also be set.
        :param pulumi.Input[str] owner_alias: Value from an Amazon-maintained list (`amazon`, `aws-marketplace`, `microsoft`) of snapshot owners.
        :param pulumi.Input[str] owner_id: The AWS account ID of the EBS snapshot owner.
        :param pulumi.Input[str] role_name: The name of the IAM Role the VM Import/Export service will assume. This role needs certain permissions. See https://docs.aws.amazon.com/vm-import/latest/userguide/vmie_prereqs.html#vmimport-role. Default: `vmimport`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the snapshot.
        :param pulumi.Input[int] volume_size: The size of the drive in GiBs.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if client_data is not None:
            pulumi.set(__self__, "client_data", client_data)
        if data_encryption_key_id is not None:
            pulumi.set(__self__, "data_encryption_key_id", data_encryption_key_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_container is not None:
            pulumi.set(__self__, "disk_container", disk_container)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if owner_alias is not None:
            pulumi.set(__self__, "owner_alias", owner_alias)
        if owner_id is not None:
            pulumi.set(__self__, "owner_id", owner_id)
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if volume_size is not None:
            pulumi.set(__self__, "volume_size", volume_size)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name (ARN) of the EBS Snapshot.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="clientData")
    def client_data(self) -> Optional[pulumi.Input['SnapshotImportClientDataArgs']]:
        """
        The client-specific data. Detailed below.
        """
        return pulumi.get(self, "client_data")

    @client_data.setter
    def client_data(self, value: Optional[pulumi.Input['SnapshotImportClientDataArgs']]):
        pulumi.set(self, "client_data", value)

    @property
    @pulumi.getter(name="dataEncryptionKeyId")
    def data_encryption_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The data encryption key identifier for the snapshot.
        """
        return pulumi.get(self, "data_encryption_key_id")

    @data_encryption_key_id.setter
    def data_encryption_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_encryption_key_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the disk image being imported.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="diskContainer")
    def disk_container(self) -> Optional[pulumi.Input['SnapshotImportDiskContainerArgs']]:
        """
        Information about the disk container. Detailed below.
        """
        return pulumi.get(self, "disk_container")

    @disk_container.setter
    def disk_container(self, value: Optional[pulumi.Input['SnapshotImportDiskContainerArgs']]):
        pulumi.set(self, "disk_container", value)

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the destination snapshot of the imported image should be encrypted. The default KMS key for EBS is used unless you specify a non-default KMS key using KmsKeyId.
        """
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypted", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        An identifier for the symmetric KMS key to use when creating the encrypted snapshot. This parameter is only required if you want to use a non-default KMS key; if this parameter is not specified, the default KMS key for EBS is used. If a KmsKeyId is specified, the Encrypted flag must also be set.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="ownerAlias")
    def owner_alias(self) -> Optional[pulumi.Input[str]]:
        """
        Value from an Amazon-maintained list (`amazon`, `aws-marketplace`, `microsoft`) of snapshot owners.
        """
        return pulumi.get(self, "owner_alias")

    @owner_alias.setter
    def owner_alias(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner_alias", value)

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS account ID of the EBS snapshot owner.
        """
        return pulumi.get(self, "owner_id")

    @owner_id.setter
    def owner_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner_id", value)

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the IAM Role the VM Import/Export service will assume. This role needs certain permissions. See https://docs.aws.amazon.com/vm-import/latest/userguide/vmie_prereqs.html#vmimport-role. Default: `vmimport`
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the snapshot.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> Optional[pulumi.Input[int]]:
        """
        The size of the drive in GiBs.
        """
        return pulumi.get(self, "volume_size")

    @volume_size.setter
    def volume_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "volume_size", value)


class SnapshotImport(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_data: Optional[pulumi.Input[pulumi.InputType['SnapshotImportClientDataArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disk_container: Optional[pulumi.Input[pulumi.InputType['SnapshotImportDiskContainerArgs']]] = None,
                 encrypted: Optional[pulumi.Input[bool]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 role_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Imports a disk image from S3 as a Snapshot.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ebs.SnapshotImport("example",
            disk_container=aws.ebs.SnapshotImportDiskContainerArgs(
                format="VHD",
                user_bucket=aws.ebs.SnapshotImportDiskContainerUserBucketArgs(
                    s3_bucket="disk-images",
                    s3_key="source.vhd",
                ),
            ),
            role_name="disk-image-import",
            tags={
                "Name": "HelloWorld",
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['SnapshotImportClientDataArgs']] client_data: The client-specific data. Detailed below.
        :param pulumi.Input[str] description: The description of the disk image being imported.
        :param pulumi.Input[pulumi.InputType['SnapshotImportDiskContainerArgs']] disk_container: Information about the disk container. Detailed below.
        :param pulumi.Input[bool] encrypted: Specifies whether the destination snapshot of the imported image should be encrypted. The default KMS key for EBS is used unless you specify a non-default KMS key using KmsKeyId.
        :param pulumi.Input[str] kms_key_id: An identifier for the symmetric KMS key to use when creating the encrypted snapshot. This parameter is only required if you want to use a non-default KMS key; if this parameter is not specified, the default KMS key for EBS is used. If a KmsKeyId is specified, the Encrypted flag must also be set.
        :param pulumi.Input[str] role_name: The name of the IAM Role the VM Import/Export service will assume. This role needs certain permissions. See https://docs.aws.amazon.com/vm-import/latest/userguide/vmie_prereqs.html#vmimport-role. Default: `vmimport`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the snapshot.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SnapshotImportArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Imports a disk image from S3 as a Snapshot.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ebs.SnapshotImport("example",
            disk_container=aws.ebs.SnapshotImportDiskContainerArgs(
                format="VHD",
                user_bucket=aws.ebs.SnapshotImportDiskContainerUserBucketArgs(
                    s3_bucket="disk-images",
                    s3_key="source.vhd",
                ),
            ),
            role_name="disk-image-import",
            tags={
                "Name": "HelloWorld",
            })
        ```

        :param str resource_name: The name of the resource.
        :param SnapshotImportArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SnapshotImportArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_data: Optional[pulumi.Input[pulumi.InputType['SnapshotImportClientDataArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disk_container: Optional[pulumi.Input[pulumi.InputType['SnapshotImportDiskContainerArgs']]] = None,
                 encrypted: Optional[pulumi.Input[bool]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 role_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SnapshotImportArgs.__new__(SnapshotImportArgs)

            __props__.__dict__["client_data"] = client_data
            __props__.__dict__["description"] = description
            if disk_container is None and not opts.urn:
                raise TypeError("Missing required property 'disk_container'")
            __props__.__dict__["disk_container"] = disk_container
            __props__.__dict__["encrypted"] = encrypted
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["role_name"] = role_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["data_encryption_key_id"] = None
            __props__.__dict__["owner_alias"] = None
            __props__.__dict__["owner_id"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["volume_size"] = None
        super(SnapshotImport, __self__).__init__(
            'aws:ebs/snapshotImport:SnapshotImport',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            client_data: Optional[pulumi.Input[pulumi.InputType['SnapshotImportClientDataArgs']]] = None,
            data_encryption_key_id: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            disk_container: Optional[pulumi.Input[pulumi.InputType['SnapshotImportDiskContainerArgs']]] = None,
            encrypted: Optional[pulumi.Input[bool]] = None,
            kms_key_id: Optional[pulumi.Input[str]] = None,
            owner_alias: Optional[pulumi.Input[str]] = None,
            owner_id: Optional[pulumi.Input[str]] = None,
            role_name: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            volume_size: Optional[pulumi.Input[int]] = None) -> 'SnapshotImport':
        """
        Get an existing SnapshotImport resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: Amazon Resource Name (ARN) of the EBS Snapshot.
        :param pulumi.Input[pulumi.InputType['SnapshotImportClientDataArgs']] client_data: The client-specific data. Detailed below.
        :param pulumi.Input[str] data_encryption_key_id: The data encryption key identifier for the snapshot.
        :param pulumi.Input[str] description: The description of the disk image being imported.
        :param pulumi.Input[pulumi.InputType['SnapshotImportDiskContainerArgs']] disk_container: Information about the disk container. Detailed below.
        :param pulumi.Input[bool] encrypted: Specifies whether the destination snapshot of the imported image should be encrypted. The default KMS key for EBS is used unless you specify a non-default KMS key using KmsKeyId.
        :param pulumi.Input[str] kms_key_id: An identifier for the symmetric KMS key to use when creating the encrypted snapshot. This parameter is only required if you want to use a non-default KMS key; if this parameter is not specified, the default KMS key for EBS is used. If a KmsKeyId is specified, the Encrypted flag must also be set.
        :param pulumi.Input[str] owner_alias: Value from an Amazon-maintained list (`amazon`, `aws-marketplace`, `microsoft`) of snapshot owners.
        :param pulumi.Input[str] owner_id: The AWS account ID of the EBS snapshot owner.
        :param pulumi.Input[str] role_name: The name of the IAM Role the VM Import/Export service will assume. This role needs certain permissions. See https://docs.aws.amazon.com/vm-import/latest/userguide/vmie_prereqs.html#vmimport-role. Default: `vmimport`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the snapshot.
        :param pulumi.Input[int] volume_size: The size of the drive in GiBs.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SnapshotImportState.__new__(_SnapshotImportState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["client_data"] = client_data
        __props__.__dict__["data_encryption_key_id"] = data_encryption_key_id
        __props__.__dict__["description"] = description
        __props__.__dict__["disk_container"] = disk_container
        __props__.__dict__["encrypted"] = encrypted
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["owner_alias"] = owner_alias
        __props__.__dict__["owner_id"] = owner_id
        __props__.__dict__["role_name"] = role_name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["volume_size"] = volume_size
        return SnapshotImport(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        Amazon Resource Name (ARN) of the EBS Snapshot.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="clientData")
    def client_data(self) -> pulumi.Output[Optional['outputs.SnapshotImportClientData']]:
        """
        The client-specific data. Detailed below.
        """
        return pulumi.get(self, "client_data")

    @property
    @pulumi.getter(name="dataEncryptionKeyId")
    def data_encryption_key_id(self) -> pulumi.Output[str]:
        """
        The data encryption key identifier for the snapshot.
        """
        return pulumi.get(self, "data_encryption_key_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of the disk image being imported.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="diskContainer")
    def disk_container(self) -> pulumi.Output['outputs.SnapshotImportDiskContainer']:
        """
        Information about the disk container. Detailed below.
        """
        return pulumi.get(self, "disk_container")

    @property
    @pulumi.getter
    def encrypted(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether the destination snapshot of the imported image should be encrypted. The default KMS key for EBS is used unless you specify a non-default KMS key using KmsKeyId.
        """
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[Optional[str]]:
        """
        An identifier for the symmetric KMS key to use when creating the encrypted snapshot. This parameter is only required if you want to use a non-default KMS key; if this parameter is not specified, the default KMS key for EBS is used. If a KmsKeyId is specified, the Encrypted flag must also be set.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="ownerAlias")
    def owner_alias(self) -> pulumi.Output[str]:
        """
        Value from an Amazon-maintained list (`amazon`, `aws-marketplace`, `microsoft`) of snapshot owners.
        """
        return pulumi.get(self, "owner_alias")

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> pulumi.Output[str]:
        """
        The AWS account ID of the EBS snapshot owner.
        """
        return pulumi.get(self, "owner_id")

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the IAM Role the VM Import/Export service will assume. This role needs certain permissions. See https://docs.aws.amazon.com/vm-import/latest/userguide/vmie_prereqs.html#vmimport-role. Default: `vmimport`
        """
        return pulumi.get(self, "role_name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A map of tags to assign to the snapshot.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> pulumi.Output[int]:
        """
        The size of the drive in GiBs.
        """
        return pulumi.get(self, "volume_size")

