# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['UserPoolArgs', 'UserPool']

@pulumi.input_type
class UserPoolArgs:
    def __init__(__self__, *,
                 account_recovery_setting: Optional[pulumi.Input['UserPoolAccountRecoverySettingArgs']] = None,
                 admin_create_user_config: Optional[pulumi.Input['UserPoolAdminCreateUserConfigArgs']] = None,
                 alias_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 auto_verified_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 device_configuration: Optional[pulumi.Input['UserPoolDeviceConfigurationArgs']] = None,
                 email_configuration: Optional[pulumi.Input['UserPoolEmailConfigurationArgs']] = None,
                 email_verification_message: Optional[pulumi.Input[str]] = None,
                 email_verification_subject: Optional[pulumi.Input[str]] = None,
                 lambda_config: Optional[pulumi.Input['UserPoolLambdaConfigArgs']] = None,
                 mfa_configuration: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password_policy: Optional[pulumi.Input['UserPoolPasswordPolicyArgs']] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input['UserPoolSchemaArgs']]]] = None,
                 sms_authentication_message: Optional[pulumi.Input[str]] = None,
                 sms_configuration: Optional[pulumi.Input['UserPoolSmsConfigurationArgs']] = None,
                 sms_verification_message: Optional[pulumi.Input[str]] = None,
                 software_token_mfa_configuration: Optional[pulumi.Input['UserPoolSoftwareTokenMfaConfigurationArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 user_pool_add_ons: Optional[pulumi.Input['UserPoolUserPoolAddOnsArgs']] = None,
                 username_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 username_configuration: Optional[pulumi.Input['UserPoolUsernameConfigurationArgs']] = None,
                 verification_message_template: Optional[pulumi.Input['UserPoolVerificationMessageTemplateArgs']] = None):
        """
        The set of arguments for constructing a UserPool resource.
        :param pulumi.Input['UserPoolAccountRecoverySettingArgs'] account_recovery_setting: Configuration block to define which verified available method a user can use to recover their forgotten password. Detailed below.
        :param pulumi.Input['UserPoolAdminCreateUserConfigArgs'] admin_create_user_config: Configuration block for creating a new user profile. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] alias_attributes: Attributes supported as an alias for this user pool. Valid values: `phone_number`, `email`, or `preferred_username`. Conflicts with `username_attributes`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] auto_verified_attributes: Attributes to be auto-verified. Valid values: `email`, `phone_number`.
        :param pulumi.Input['UserPoolDeviceConfigurationArgs'] device_configuration: Configuration block for the user pool's device tracking. Detailed below.
        :param pulumi.Input['UserPoolEmailConfigurationArgs'] email_configuration: Configuration block for configuring email. Detailed below.
        :param pulumi.Input[str] email_verification_message: String representing the email verification message. Conflicts with `verification_message_template` configuration block `email_message` argument.
        :param pulumi.Input[str] email_verification_subject: String representing the email verification subject. Conflicts with `verification_message_template` configuration block `email_subject` argument.
        :param pulumi.Input['UserPoolLambdaConfigArgs'] lambda_config: Configuration block for the AWS Lambda triggers associated with the user pool. Detailed below.
        :param pulumi.Input[str] mfa_configuration: Multi-Factor Authentication (MFA) configuration for the User Pool. Defaults of `OFF`. Valid values are `OFF` (MFA Tokens are not required), `ON` (MFA is required for all users to sign in; requires at least one of `sms_configuration` or `software_token_mfa_configuration` to be configured), or `OPTIONAL` (MFA Will be required only for individual users who have MFA Enabled; requires at least one of `sms_configuration` or `software_token_mfa_configuration` to be configured).
        :param pulumi.Input[str] name: Name of the attribute.
        :param pulumi.Input['UserPoolPasswordPolicyArgs'] password_policy: Configuration blocked for information about the user pool password policy. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input['UserPoolSchemaArgs']]] schemas: Configuration block for the schema attributes of a user pool. Detailed below. Schema attributes from the [standard attribute set](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#cognito-user-pools-standard-attributes) only need to be specified if they are different from the default configuration. Attributes can be added, but not modified or removed. Maximum of 50 attributes.
        :param pulumi.Input[str] sms_authentication_message: String representing the SMS authentication message. The Message must contain the `{####}` placeholder, which will be replaced with the code.
        :param pulumi.Input['UserPoolSmsConfigurationArgs'] sms_configuration: Configuration block for Short Message Service (SMS) settings. Detailed below. These settings apply to SMS user verification and SMS Multi-Factor Authentication (MFA). Due to Cognito API restrictions, the SMS configuration cannot be removed without recreating the Cognito User Pool. For user data safety, this resource will ignore the removal of this configuration by disabling drift detection.
        :param pulumi.Input[str] sms_verification_message: String representing the SMS verification message. Conflicts with `verification_message_template` configuration block `sms_message` argument.
        :param pulumi.Input['UserPoolSoftwareTokenMfaConfigurationArgs'] software_token_mfa_configuration: Configuration block for software token Mult-Factor Authentication (MFA) settings. Detailed below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the User Pool. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input['UserPoolUserPoolAddOnsArgs'] user_pool_add_ons: Configuration block for user pool add-ons to enable user pool advanced security mode features. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] username_attributes: Whether email addresses or phone numbers can be specified as usernames when a user signs up. Conflicts with `alias_attributes`.
        :param pulumi.Input['UserPoolUsernameConfigurationArgs'] username_configuration: Configuration block for username configuration. Detailed below.
        :param pulumi.Input['UserPoolVerificationMessageTemplateArgs'] verification_message_template: Configuration block for verification message templates. Detailed below.
        """
        if account_recovery_setting is not None:
            pulumi.set(__self__, "account_recovery_setting", account_recovery_setting)
        if admin_create_user_config is not None:
            pulumi.set(__self__, "admin_create_user_config", admin_create_user_config)
        if alias_attributes is not None:
            pulumi.set(__self__, "alias_attributes", alias_attributes)
        if auto_verified_attributes is not None:
            pulumi.set(__self__, "auto_verified_attributes", auto_verified_attributes)
        if device_configuration is not None:
            pulumi.set(__self__, "device_configuration", device_configuration)
        if email_configuration is not None:
            pulumi.set(__self__, "email_configuration", email_configuration)
        if email_verification_message is not None:
            pulumi.set(__self__, "email_verification_message", email_verification_message)
        if email_verification_subject is not None:
            pulumi.set(__self__, "email_verification_subject", email_verification_subject)
        if lambda_config is not None:
            pulumi.set(__self__, "lambda_config", lambda_config)
        if mfa_configuration is not None:
            pulumi.set(__self__, "mfa_configuration", mfa_configuration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password_policy is not None:
            pulumi.set(__self__, "password_policy", password_policy)
        if schemas is not None:
            pulumi.set(__self__, "schemas", schemas)
        if sms_authentication_message is not None:
            pulumi.set(__self__, "sms_authentication_message", sms_authentication_message)
        if sms_configuration is not None:
            pulumi.set(__self__, "sms_configuration", sms_configuration)
        if sms_verification_message is not None:
            pulumi.set(__self__, "sms_verification_message", sms_verification_message)
        if software_token_mfa_configuration is not None:
            pulumi.set(__self__, "software_token_mfa_configuration", software_token_mfa_configuration)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_pool_add_ons is not None:
            pulumi.set(__self__, "user_pool_add_ons", user_pool_add_ons)
        if username_attributes is not None:
            pulumi.set(__self__, "username_attributes", username_attributes)
        if username_configuration is not None:
            pulumi.set(__self__, "username_configuration", username_configuration)
        if verification_message_template is not None:
            pulumi.set(__self__, "verification_message_template", verification_message_template)

    @property
    @pulumi.getter(name="accountRecoverySetting")
    def account_recovery_setting(self) -> Optional[pulumi.Input['UserPoolAccountRecoverySettingArgs']]:
        """
        Configuration block to define which verified available method a user can use to recover their forgotten password. Detailed below.
        """
        return pulumi.get(self, "account_recovery_setting")

    @account_recovery_setting.setter
    def account_recovery_setting(self, value: Optional[pulumi.Input['UserPoolAccountRecoverySettingArgs']]):
        pulumi.set(self, "account_recovery_setting", value)

    @property
    @pulumi.getter(name="adminCreateUserConfig")
    def admin_create_user_config(self) -> Optional[pulumi.Input['UserPoolAdminCreateUserConfigArgs']]:
        """
        Configuration block for creating a new user profile. Detailed below.
        """
        return pulumi.get(self, "admin_create_user_config")

    @admin_create_user_config.setter
    def admin_create_user_config(self, value: Optional[pulumi.Input['UserPoolAdminCreateUserConfigArgs']]):
        pulumi.set(self, "admin_create_user_config", value)

    @property
    @pulumi.getter(name="aliasAttributes")
    def alias_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Attributes supported as an alias for this user pool. Valid values: `phone_number`, `email`, or `preferred_username`. Conflicts with `username_attributes`.
        """
        return pulumi.get(self, "alias_attributes")

    @alias_attributes.setter
    def alias_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "alias_attributes", value)

    @property
    @pulumi.getter(name="autoVerifiedAttributes")
    def auto_verified_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Attributes to be auto-verified. Valid values: `email`, `phone_number`.
        """
        return pulumi.get(self, "auto_verified_attributes")

    @auto_verified_attributes.setter
    def auto_verified_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "auto_verified_attributes", value)

    @property
    @pulumi.getter(name="deviceConfiguration")
    def device_configuration(self) -> Optional[pulumi.Input['UserPoolDeviceConfigurationArgs']]:
        """
        Configuration block for the user pool's device tracking. Detailed below.
        """
        return pulumi.get(self, "device_configuration")

    @device_configuration.setter
    def device_configuration(self, value: Optional[pulumi.Input['UserPoolDeviceConfigurationArgs']]):
        pulumi.set(self, "device_configuration", value)

    @property
    @pulumi.getter(name="emailConfiguration")
    def email_configuration(self) -> Optional[pulumi.Input['UserPoolEmailConfigurationArgs']]:
        """
        Configuration block for configuring email. Detailed below.
        """
        return pulumi.get(self, "email_configuration")

    @email_configuration.setter
    def email_configuration(self, value: Optional[pulumi.Input['UserPoolEmailConfigurationArgs']]):
        pulumi.set(self, "email_configuration", value)

    @property
    @pulumi.getter(name="emailVerificationMessage")
    def email_verification_message(self) -> Optional[pulumi.Input[str]]:
        """
        String representing the email verification message. Conflicts with `verification_message_template` configuration block `email_message` argument.
        """
        return pulumi.get(self, "email_verification_message")

    @email_verification_message.setter
    def email_verification_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email_verification_message", value)

    @property
    @pulumi.getter(name="emailVerificationSubject")
    def email_verification_subject(self) -> Optional[pulumi.Input[str]]:
        """
        String representing the email verification subject. Conflicts with `verification_message_template` configuration block `email_subject` argument.
        """
        return pulumi.get(self, "email_verification_subject")

    @email_verification_subject.setter
    def email_verification_subject(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email_verification_subject", value)

    @property
    @pulumi.getter(name="lambdaConfig")
    def lambda_config(self) -> Optional[pulumi.Input['UserPoolLambdaConfigArgs']]:
        """
        Configuration block for the AWS Lambda triggers associated with the user pool. Detailed below.
        """
        return pulumi.get(self, "lambda_config")

    @lambda_config.setter
    def lambda_config(self, value: Optional[pulumi.Input['UserPoolLambdaConfigArgs']]):
        pulumi.set(self, "lambda_config", value)

    @property
    @pulumi.getter(name="mfaConfiguration")
    def mfa_configuration(self) -> Optional[pulumi.Input[str]]:
        """
        Multi-Factor Authentication (MFA) configuration for the User Pool. Defaults of `OFF`. Valid values are `OFF` (MFA Tokens are not required), `ON` (MFA is required for all users to sign in; requires at least one of `sms_configuration` or `software_token_mfa_configuration` to be configured), or `OPTIONAL` (MFA Will be required only for individual users who have MFA Enabled; requires at least one of `sms_configuration` or `software_token_mfa_configuration` to be configured).
        """
        return pulumi.get(self, "mfa_configuration")

    @mfa_configuration.setter
    def mfa_configuration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mfa_configuration", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the attribute.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="passwordPolicy")
    def password_policy(self) -> Optional[pulumi.Input['UserPoolPasswordPolicyArgs']]:
        """
        Configuration blocked for information about the user pool password policy. Detailed below.
        """
        return pulumi.get(self, "password_policy")

    @password_policy.setter
    def password_policy(self, value: Optional[pulumi.Input['UserPoolPasswordPolicyArgs']]):
        pulumi.set(self, "password_policy", value)

    @property
    @pulumi.getter
    def schemas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserPoolSchemaArgs']]]]:
        """
        Configuration block for the schema attributes of a user pool. Detailed below. Schema attributes from the [standard attribute set](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#cognito-user-pools-standard-attributes) only need to be specified if they are different from the default configuration. Attributes can be added, but not modified or removed. Maximum of 50 attributes.
        """
        return pulumi.get(self, "schemas")

    @schemas.setter
    def schemas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserPoolSchemaArgs']]]]):
        pulumi.set(self, "schemas", value)

    @property
    @pulumi.getter(name="smsAuthenticationMessage")
    def sms_authentication_message(self) -> Optional[pulumi.Input[str]]:
        """
        String representing the SMS authentication message. The Message must contain the `{####}` placeholder, which will be replaced with the code.
        """
        return pulumi.get(self, "sms_authentication_message")

    @sms_authentication_message.setter
    def sms_authentication_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sms_authentication_message", value)

    @property
    @pulumi.getter(name="smsConfiguration")
    def sms_configuration(self) -> Optional[pulumi.Input['UserPoolSmsConfigurationArgs']]:
        """
        Configuration block for Short Message Service (SMS) settings. Detailed below. These settings apply to SMS user verification and SMS Multi-Factor Authentication (MFA). Due to Cognito API restrictions, the SMS configuration cannot be removed without recreating the Cognito User Pool. For user data safety, this resource will ignore the removal of this configuration by disabling drift detection.
        """
        return pulumi.get(self, "sms_configuration")

    @sms_configuration.setter
    def sms_configuration(self, value: Optional[pulumi.Input['UserPoolSmsConfigurationArgs']]):
        pulumi.set(self, "sms_configuration", value)

    @property
    @pulumi.getter(name="smsVerificationMessage")
    def sms_verification_message(self) -> Optional[pulumi.Input[str]]:
        """
        String representing the SMS verification message. Conflicts with `verification_message_template` configuration block `sms_message` argument.
        """
        return pulumi.get(self, "sms_verification_message")

    @sms_verification_message.setter
    def sms_verification_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sms_verification_message", value)

    @property
    @pulumi.getter(name="softwareTokenMfaConfiguration")
    def software_token_mfa_configuration(self) -> Optional[pulumi.Input['UserPoolSoftwareTokenMfaConfigurationArgs']]:
        """
        Configuration block for software token Mult-Factor Authentication (MFA) settings. Detailed below.
        """
        return pulumi.get(self, "software_token_mfa_configuration")

    @software_token_mfa_configuration.setter
    def software_token_mfa_configuration(self, value: Optional[pulumi.Input['UserPoolSoftwareTokenMfaConfigurationArgs']]):
        pulumi.set(self, "software_token_mfa_configuration", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags to assign to the User Pool. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="userPoolAddOns")
    def user_pool_add_ons(self) -> Optional[pulumi.Input['UserPoolUserPoolAddOnsArgs']]:
        """
        Configuration block for user pool add-ons to enable user pool advanced security mode features. Detailed below.
        """
        return pulumi.get(self, "user_pool_add_ons")

    @user_pool_add_ons.setter
    def user_pool_add_ons(self, value: Optional[pulumi.Input['UserPoolUserPoolAddOnsArgs']]):
        pulumi.set(self, "user_pool_add_ons", value)

    @property
    @pulumi.getter(name="usernameAttributes")
    def username_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Whether email addresses or phone numbers can be specified as usernames when a user signs up. Conflicts with `alias_attributes`.
        """
        return pulumi.get(self, "username_attributes")

    @username_attributes.setter
    def username_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "username_attributes", value)

    @property
    @pulumi.getter(name="usernameConfiguration")
    def username_configuration(self) -> Optional[pulumi.Input['UserPoolUsernameConfigurationArgs']]:
        """
        Configuration block for username configuration. Detailed below.
        """
        return pulumi.get(self, "username_configuration")

    @username_configuration.setter
    def username_configuration(self, value: Optional[pulumi.Input['UserPoolUsernameConfigurationArgs']]):
        pulumi.set(self, "username_configuration", value)

    @property
    @pulumi.getter(name="verificationMessageTemplate")
    def verification_message_template(self) -> Optional[pulumi.Input['UserPoolVerificationMessageTemplateArgs']]:
        """
        Configuration block for verification message templates. Detailed below.
        """
        return pulumi.get(self, "verification_message_template")

    @verification_message_template.setter
    def verification_message_template(self, value: Optional[pulumi.Input['UserPoolVerificationMessageTemplateArgs']]):
        pulumi.set(self, "verification_message_template", value)


@pulumi.input_type
class _UserPoolState:
    def __init__(__self__, *,
                 account_recovery_setting: Optional[pulumi.Input['UserPoolAccountRecoverySettingArgs']] = None,
                 admin_create_user_config: Optional[pulumi.Input['UserPoolAdminCreateUserConfigArgs']] = None,
                 alias_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 auto_verified_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 creation_date: Optional[pulumi.Input[str]] = None,
                 custom_domain: Optional[pulumi.Input[str]] = None,
                 device_configuration: Optional[pulumi.Input['UserPoolDeviceConfigurationArgs']] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 email_configuration: Optional[pulumi.Input['UserPoolEmailConfigurationArgs']] = None,
                 email_verification_message: Optional[pulumi.Input[str]] = None,
                 email_verification_subject: Optional[pulumi.Input[str]] = None,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 estimated_number_of_users: Optional[pulumi.Input[int]] = None,
                 lambda_config: Optional[pulumi.Input['UserPoolLambdaConfigArgs']] = None,
                 last_modified_date: Optional[pulumi.Input[str]] = None,
                 mfa_configuration: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password_policy: Optional[pulumi.Input['UserPoolPasswordPolicyArgs']] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input['UserPoolSchemaArgs']]]] = None,
                 sms_authentication_message: Optional[pulumi.Input[str]] = None,
                 sms_configuration: Optional[pulumi.Input['UserPoolSmsConfigurationArgs']] = None,
                 sms_verification_message: Optional[pulumi.Input[str]] = None,
                 software_token_mfa_configuration: Optional[pulumi.Input['UserPoolSoftwareTokenMfaConfigurationArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 user_pool_add_ons: Optional[pulumi.Input['UserPoolUserPoolAddOnsArgs']] = None,
                 username_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 username_configuration: Optional[pulumi.Input['UserPoolUsernameConfigurationArgs']] = None,
                 verification_message_template: Optional[pulumi.Input['UserPoolVerificationMessageTemplateArgs']] = None):
        """
        Input properties used for looking up and filtering UserPool resources.
        :param pulumi.Input['UserPoolAccountRecoverySettingArgs'] account_recovery_setting: Configuration block to define which verified available method a user can use to recover their forgotten password. Detailed below.
        :param pulumi.Input['UserPoolAdminCreateUserConfigArgs'] admin_create_user_config: Configuration block for creating a new user profile. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] alias_attributes: Attributes supported as an alias for this user pool. Valid values: `phone_number`, `email`, or `preferred_username`. Conflicts with `username_attributes`.
        :param pulumi.Input[str] arn: ARN of the user pool.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] auto_verified_attributes: Attributes to be auto-verified. Valid values: `email`, `phone_number`.
        :param pulumi.Input[str] creation_date: Date the user pool was created.
        :param pulumi.Input[str] custom_domain: A custom domain name that you provide to Amazon Cognito. This parameter applies only if you use a custom domain to host the sign-up and sign-in pages for your application. For example: `auth.example.com`.
        :param pulumi.Input['UserPoolDeviceConfigurationArgs'] device_configuration: Configuration block for the user pool's device tracking. Detailed below.
        :param pulumi.Input[str] domain: Holds the domain prefix if the user pool has a domain associated with it.
        :param pulumi.Input['UserPoolEmailConfigurationArgs'] email_configuration: Configuration block for configuring email. Detailed below.
        :param pulumi.Input[str] email_verification_message: String representing the email verification message. Conflicts with `verification_message_template` configuration block `email_message` argument.
        :param pulumi.Input[str] email_verification_subject: String representing the email verification subject. Conflicts with `verification_message_template` configuration block `email_subject` argument.
        :param pulumi.Input[str] endpoint: Endpoint name of the user pool. Example format: `cognito-idp.REGION.amazonaws.com/xxxx_yyyyy`
        :param pulumi.Input[int] estimated_number_of_users: A number estimating the size of the user pool.
        :param pulumi.Input['UserPoolLambdaConfigArgs'] lambda_config: Configuration block for the AWS Lambda triggers associated with the user pool. Detailed below.
        :param pulumi.Input[str] last_modified_date: Date the user pool was last modified.
        :param pulumi.Input[str] mfa_configuration: Multi-Factor Authentication (MFA) configuration for the User Pool. Defaults of `OFF`. Valid values are `OFF` (MFA Tokens are not required), `ON` (MFA is required for all users to sign in; requires at least one of `sms_configuration` or `software_token_mfa_configuration` to be configured), or `OPTIONAL` (MFA Will be required only for individual users who have MFA Enabled; requires at least one of `sms_configuration` or `software_token_mfa_configuration` to be configured).
        :param pulumi.Input[str] name: Name of the attribute.
        :param pulumi.Input['UserPoolPasswordPolicyArgs'] password_policy: Configuration blocked for information about the user pool password policy. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input['UserPoolSchemaArgs']]] schemas: Configuration block for the schema attributes of a user pool. Detailed below. Schema attributes from the [standard attribute set](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#cognito-user-pools-standard-attributes) only need to be specified if they are different from the default configuration. Attributes can be added, but not modified or removed. Maximum of 50 attributes.
        :param pulumi.Input[str] sms_authentication_message: String representing the SMS authentication message. The Message must contain the `{####}` placeholder, which will be replaced with the code.
        :param pulumi.Input['UserPoolSmsConfigurationArgs'] sms_configuration: Configuration block for Short Message Service (SMS) settings. Detailed below. These settings apply to SMS user verification and SMS Multi-Factor Authentication (MFA). Due to Cognito API restrictions, the SMS configuration cannot be removed without recreating the Cognito User Pool. For user data safety, this resource will ignore the removal of this configuration by disabling drift detection.
        :param pulumi.Input[str] sms_verification_message: String representing the SMS verification message. Conflicts with `verification_message_template` configuration block `sms_message` argument.
        :param pulumi.Input['UserPoolSoftwareTokenMfaConfigurationArgs'] software_token_mfa_configuration: Configuration block for software token Mult-Factor Authentication (MFA) settings. Detailed below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the User Pool. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider .
        :param pulumi.Input['UserPoolUserPoolAddOnsArgs'] user_pool_add_ons: Configuration block for user pool add-ons to enable user pool advanced security mode features. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] username_attributes: Whether email addresses or phone numbers can be specified as usernames when a user signs up. Conflicts with `alias_attributes`.
        :param pulumi.Input['UserPoolUsernameConfigurationArgs'] username_configuration: Configuration block for username configuration. Detailed below.
        :param pulumi.Input['UserPoolVerificationMessageTemplateArgs'] verification_message_template: Configuration block for verification message templates. Detailed below.
        """
        if account_recovery_setting is not None:
            pulumi.set(__self__, "account_recovery_setting", account_recovery_setting)
        if admin_create_user_config is not None:
            pulumi.set(__self__, "admin_create_user_config", admin_create_user_config)
        if alias_attributes is not None:
            pulumi.set(__self__, "alias_attributes", alias_attributes)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if auto_verified_attributes is not None:
            pulumi.set(__self__, "auto_verified_attributes", auto_verified_attributes)
        if creation_date is not None:
            pulumi.set(__self__, "creation_date", creation_date)
        if custom_domain is not None:
            pulumi.set(__self__, "custom_domain", custom_domain)
        if device_configuration is not None:
            pulumi.set(__self__, "device_configuration", device_configuration)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if email_configuration is not None:
            pulumi.set(__self__, "email_configuration", email_configuration)
        if email_verification_message is not None:
            pulumi.set(__self__, "email_verification_message", email_verification_message)
        if email_verification_subject is not None:
            pulumi.set(__self__, "email_verification_subject", email_verification_subject)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if estimated_number_of_users is not None:
            pulumi.set(__self__, "estimated_number_of_users", estimated_number_of_users)
        if lambda_config is not None:
            pulumi.set(__self__, "lambda_config", lambda_config)
        if last_modified_date is not None:
            pulumi.set(__self__, "last_modified_date", last_modified_date)
        if mfa_configuration is not None:
            pulumi.set(__self__, "mfa_configuration", mfa_configuration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password_policy is not None:
            pulumi.set(__self__, "password_policy", password_policy)
        if schemas is not None:
            pulumi.set(__self__, "schemas", schemas)
        if sms_authentication_message is not None:
            pulumi.set(__self__, "sms_authentication_message", sms_authentication_message)
        if sms_configuration is not None:
            pulumi.set(__self__, "sms_configuration", sms_configuration)
        if sms_verification_message is not None:
            pulumi.set(__self__, "sms_verification_message", sms_verification_message)
        if software_token_mfa_configuration is not None:
            pulumi.set(__self__, "software_token_mfa_configuration", software_token_mfa_configuration)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if user_pool_add_ons is not None:
            pulumi.set(__self__, "user_pool_add_ons", user_pool_add_ons)
        if username_attributes is not None:
            pulumi.set(__self__, "username_attributes", username_attributes)
        if username_configuration is not None:
            pulumi.set(__self__, "username_configuration", username_configuration)
        if verification_message_template is not None:
            pulumi.set(__self__, "verification_message_template", verification_message_template)

    @property
    @pulumi.getter(name="accountRecoverySetting")
    def account_recovery_setting(self) -> Optional[pulumi.Input['UserPoolAccountRecoverySettingArgs']]:
        """
        Configuration block to define which verified available method a user can use to recover their forgotten password. Detailed below.
        """
        return pulumi.get(self, "account_recovery_setting")

    @account_recovery_setting.setter
    def account_recovery_setting(self, value: Optional[pulumi.Input['UserPoolAccountRecoverySettingArgs']]):
        pulumi.set(self, "account_recovery_setting", value)

    @property
    @pulumi.getter(name="adminCreateUserConfig")
    def admin_create_user_config(self) -> Optional[pulumi.Input['UserPoolAdminCreateUserConfigArgs']]:
        """
        Configuration block for creating a new user profile. Detailed below.
        """
        return pulumi.get(self, "admin_create_user_config")

    @admin_create_user_config.setter
    def admin_create_user_config(self, value: Optional[pulumi.Input['UserPoolAdminCreateUserConfigArgs']]):
        pulumi.set(self, "admin_create_user_config", value)

    @property
    @pulumi.getter(name="aliasAttributes")
    def alias_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Attributes supported as an alias for this user pool. Valid values: `phone_number`, `email`, or `preferred_username`. Conflicts with `username_attributes`.
        """
        return pulumi.get(self, "alias_attributes")

    @alias_attributes.setter
    def alias_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "alias_attributes", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the user pool.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="autoVerifiedAttributes")
    def auto_verified_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Attributes to be auto-verified. Valid values: `email`, `phone_number`.
        """
        return pulumi.get(self, "auto_verified_attributes")

    @auto_verified_attributes.setter
    def auto_verified_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "auto_verified_attributes", value)

    @property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> Optional[pulumi.Input[str]]:
        """
        Date the user pool was created.
        """
        return pulumi.get(self, "creation_date")

    @creation_date.setter
    def creation_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_date", value)

    @property
    @pulumi.getter(name="customDomain")
    def custom_domain(self) -> Optional[pulumi.Input[str]]:
        """
        A custom domain name that you provide to Amazon Cognito. This parameter applies only if you use a custom domain to host the sign-up and sign-in pages for your application. For example: `auth.example.com`.
        """
        return pulumi.get(self, "custom_domain")

    @custom_domain.setter
    def custom_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_domain", value)

    @property
    @pulumi.getter(name="deviceConfiguration")
    def device_configuration(self) -> Optional[pulumi.Input['UserPoolDeviceConfigurationArgs']]:
        """
        Configuration block for the user pool's device tracking. Detailed below.
        """
        return pulumi.get(self, "device_configuration")

    @device_configuration.setter
    def device_configuration(self, value: Optional[pulumi.Input['UserPoolDeviceConfigurationArgs']]):
        pulumi.set(self, "device_configuration", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        Holds the domain prefix if the user pool has a domain associated with it.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="emailConfiguration")
    def email_configuration(self) -> Optional[pulumi.Input['UserPoolEmailConfigurationArgs']]:
        """
        Configuration block for configuring email. Detailed below.
        """
        return pulumi.get(self, "email_configuration")

    @email_configuration.setter
    def email_configuration(self, value: Optional[pulumi.Input['UserPoolEmailConfigurationArgs']]):
        pulumi.set(self, "email_configuration", value)

    @property
    @pulumi.getter(name="emailVerificationMessage")
    def email_verification_message(self) -> Optional[pulumi.Input[str]]:
        """
        String representing the email verification message. Conflicts with `verification_message_template` configuration block `email_message` argument.
        """
        return pulumi.get(self, "email_verification_message")

    @email_verification_message.setter
    def email_verification_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email_verification_message", value)

    @property
    @pulumi.getter(name="emailVerificationSubject")
    def email_verification_subject(self) -> Optional[pulumi.Input[str]]:
        """
        String representing the email verification subject. Conflicts with `verification_message_template` configuration block `email_subject` argument.
        """
        return pulumi.get(self, "email_verification_subject")

    @email_verification_subject.setter
    def email_verification_subject(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email_verification_subject", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        Endpoint name of the user pool. Example format: `cognito-idp.REGION.amazonaws.com/xxxx_yyyyy`
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter(name="estimatedNumberOfUsers")
    def estimated_number_of_users(self) -> Optional[pulumi.Input[int]]:
        """
        A number estimating the size of the user pool.
        """
        return pulumi.get(self, "estimated_number_of_users")

    @estimated_number_of_users.setter
    def estimated_number_of_users(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "estimated_number_of_users", value)

    @property
    @pulumi.getter(name="lambdaConfig")
    def lambda_config(self) -> Optional[pulumi.Input['UserPoolLambdaConfigArgs']]:
        """
        Configuration block for the AWS Lambda triggers associated with the user pool. Detailed below.
        """
        return pulumi.get(self, "lambda_config")

    @lambda_config.setter
    def lambda_config(self, value: Optional[pulumi.Input['UserPoolLambdaConfigArgs']]):
        pulumi.set(self, "lambda_config", value)

    @property
    @pulumi.getter(name="lastModifiedDate")
    def last_modified_date(self) -> Optional[pulumi.Input[str]]:
        """
        Date the user pool was last modified.
        """
        return pulumi.get(self, "last_modified_date")

    @last_modified_date.setter
    def last_modified_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_modified_date", value)

    @property
    @pulumi.getter(name="mfaConfiguration")
    def mfa_configuration(self) -> Optional[pulumi.Input[str]]:
        """
        Multi-Factor Authentication (MFA) configuration for the User Pool. Defaults of `OFF`. Valid values are `OFF` (MFA Tokens are not required), `ON` (MFA is required for all users to sign in; requires at least one of `sms_configuration` or `software_token_mfa_configuration` to be configured), or `OPTIONAL` (MFA Will be required only for individual users who have MFA Enabled; requires at least one of `sms_configuration` or `software_token_mfa_configuration` to be configured).
        """
        return pulumi.get(self, "mfa_configuration")

    @mfa_configuration.setter
    def mfa_configuration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mfa_configuration", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the attribute.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="passwordPolicy")
    def password_policy(self) -> Optional[pulumi.Input['UserPoolPasswordPolicyArgs']]:
        """
        Configuration blocked for information about the user pool password policy. Detailed below.
        """
        return pulumi.get(self, "password_policy")

    @password_policy.setter
    def password_policy(self, value: Optional[pulumi.Input['UserPoolPasswordPolicyArgs']]):
        pulumi.set(self, "password_policy", value)

    @property
    @pulumi.getter
    def schemas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserPoolSchemaArgs']]]]:
        """
        Configuration block for the schema attributes of a user pool. Detailed below. Schema attributes from the [standard attribute set](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#cognito-user-pools-standard-attributes) only need to be specified if they are different from the default configuration. Attributes can be added, but not modified or removed. Maximum of 50 attributes.
        """
        return pulumi.get(self, "schemas")

    @schemas.setter
    def schemas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserPoolSchemaArgs']]]]):
        pulumi.set(self, "schemas", value)

    @property
    @pulumi.getter(name="smsAuthenticationMessage")
    def sms_authentication_message(self) -> Optional[pulumi.Input[str]]:
        """
        String representing the SMS authentication message. The Message must contain the `{####}` placeholder, which will be replaced with the code.
        """
        return pulumi.get(self, "sms_authentication_message")

    @sms_authentication_message.setter
    def sms_authentication_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sms_authentication_message", value)

    @property
    @pulumi.getter(name="smsConfiguration")
    def sms_configuration(self) -> Optional[pulumi.Input['UserPoolSmsConfigurationArgs']]:
        """
        Configuration block for Short Message Service (SMS) settings. Detailed below. These settings apply to SMS user verification and SMS Multi-Factor Authentication (MFA). Due to Cognito API restrictions, the SMS configuration cannot be removed without recreating the Cognito User Pool. For user data safety, this resource will ignore the removal of this configuration by disabling drift detection.
        """
        return pulumi.get(self, "sms_configuration")

    @sms_configuration.setter
    def sms_configuration(self, value: Optional[pulumi.Input['UserPoolSmsConfigurationArgs']]):
        pulumi.set(self, "sms_configuration", value)

    @property
    @pulumi.getter(name="smsVerificationMessage")
    def sms_verification_message(self) -> Optional[pulumi.Input[str]]:
        """
        String representing the SMS verification message. Conflicts with `verification_message_template` configuration block `sms_message` argument.
        """
        return pulumi.get(self, "sms_verification_message")

    @sms_verification_message.setter
    def sms_verification_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sms_verification_message", value)

    @property
    @pulumi.getter(name="softwareTokenMfaConfiguration")
    def software_token_mfa_configuration(self) -> Optional[pulumi.Input['UserPoolSoftwareTokenMfaConfigurationArgs']]:
        """
        Configuration block for software token Mult-Factor Authentication (MFA) settings. Detailed below.
        """
        return pulumi.get(self, "software_token_mfa_configuration")

    @software_token_mfa_configuration.setter
    def software_token_mfa_configuration(self, value: Optional[pulumi.Input['UserPoolSoftwareTokenMfaConfigurationArgs']]):
        pulumi.set(self, "software_token_mfa_configuration", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags to assign to the User Pool. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider .
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="userPoolAddOns")
    def user_pool_add_ons(self) -> Optional[pulumi.Input['UserPoolUserPoolAddOnsArgs']]:
        """
        Configuration block for user pool add-ons to enable user pool advanced security mode features. Detailed below.
        """
        return pulumi.get(self, "user_pool_add_ons")

    @user_pool_add_ons.setter
    def user_pool_add_ons(self, value: Optional[pulumi.Input['UserPoolUserPoolAddOnsArgs']]):
        pulumi.set(self, "user_pool_add_ons", value)

    @property
    @pulumi.getter(name="usernameAttributes")
    def username_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Whether email addresses or phone numbers can be specified as usernames when a user signs up. Conflicts with `alias_attributes`.
        """
        return pulumi.get(self, "username_attributes")

    @username_attributes.setter
    def username_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "username_attributes", value)

    @property
    @pulumi.getter(name="usernameConfiguration")
    def username_configuration(self) -> Optional[pulumi.Input['UserPoolUsernameConfigurationArgs']]:
        """
        Configuration block for username configuration. Detailed below.
        """
        return pulumi.get(self, "username_configuration")

    @username_configuration.setter
    def username_configuration(self, value: Optional[pulumi.Input['UserPoolUsernameConfigurationArgs']]):
        pulumi.set(self, "username_configuration", value)

    @property
    @pulumi.getter(name="verificationMessageTemplate")
    def verification_message_template(self) -> Optional[pulumi.Input['UserPoolVerificationMessageTemplateArgs']]:
        """
        Configuration block for verification message templates. Detailed below.
        """
        return pulumi.get(self, "verification_message_template")

    @verification_message_template.setter
    def verification_message_template(self, value: Optional[pulumi.Input['UserPoolVerificationMessageTemplateArgs']]):
        pulumi.set(self, "verification_message_template", value)


class UserPool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_recovery_setting: Optional[pulumi.Input[pulumi.InputType['UserPoolAccountRecoverySettingArgs']]] = None,
                 admin_create_user_config: Optional[pulumi.Input[pulumi.InputType['UserPoolAdminCreateUserConfigArgs']]] = None,
                 alias_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 auto_verified_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 device_configuration: Optional[pulumi.Input[pulumi.InputType['UserPoolDeviceConfigurationArgs']]] = None,
                 email_configuration: Optional[pulumi.Input[pulumi.InputType['UserPoolEmailConfigurationArgs']]] = None,
                 email_verification_message: Optional[pulumi.Input[str]] = None,
                 email_verification_subject: Optional[pulumi.Input[str]] = None,
                 lambda_config: Optional[pulumi.Input[pulumi.InputType['UserPoolLambdaConfigArgs']]] = None,
                 mfa_configuration: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password_policy: Optional[pulumi.Input[pulumi.InputType['UserPoolPasswordPolicyArgs']]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['UserPoolSchemaArgs']]]]] = None,
                 sms_authentication_message: Optional[pulumi.Input[str]] = None,
                 sms_configuration: Optional[pulumi.Input[pulumi.InputType['UserPoolSmsConfigurationArgs']]] = None,
                 sms_verification_message: Optional[pulumi.Input[str]] = None,
                 software_token_mfa_configuration: Optional[pulumi.Input[pulumi.InputType['UserPoolSoftwareTokenMfaConfigurationArgs']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 user_pool_add_ons: Optional[pulumi.Input[pulumi.InputType['UserPoolUserPoolAddOnsArgs']]] = None,
                 username_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 username_configuration: Optional[pulumi.Input[pulumi.InputType['UserPoolUsernameConfigurationArgs']]] = None,
                 verification_message_template: Optional[pulumi.Input[pulumi.InputType['UserPoolVerificationMessageTemplateArgs']]] = None,
                 __props__=None):
        """
        Provides a Cognito User Pool resource.

        ## Example Usage
        ### Basic configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        pool = aws.cognito.UserPool("pool")
        ```
        ### Enabling SMS and Software Token Multi-Factor Authentication

        ```python
        import pulumi
        import pulumi_aws as aws

        # ... other configuration ...
        example = aws.cognito.UserPool("example",
            mfa_configuration="ON",
            sms_authentication_message="Your code is {####}",
            sms_configuration=aws.cognito.UserPoolSmsConfigurationArgs(
                external_id="example",
                sns_caller_arn=aws_iam_role["example"]["arn"],
            ),
            software_token_mfa_configuration=aws.cognito.UserPoolSoftwareTokenMfaConfigurationArgs(
                enabled=True,
            ))
        ```
        ### Using Account Recovery Setting

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.cognito.UserPool("test", account_recovery_setting=aws.cognito.UserPoolAccountRecoverySettingArgs(
            recovery_mechanisms=[
                aws.cognito.UserPoolAccountRecoverySettingRecoveryMechanismArgs(
                    name="verified_email",
                    priority=1,
                ),
                aws.cognito.UserPoolAccountRecoverySettingRecoveryMechanismArgs(
                    name="verified_phone_number",
                    priority=2,
                ),
            ],
        ))
        ```

        ## Import

        Cognito User Pools can be imported using the `id`, e.g.,

        ```sh
         $ pulumi import aws:cognito/userPool:UserPool pool <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['UserPoolAccountRecoverySettingArgs']] account_recovery_setting: Configuration block to define which verified available method a user can use to recover their forgotten password. Detailed below.
        :param pulumi.Input[pulumi.InputType['UserPoolAdminCreateUserConfigArgs']] admin_create_user_config: Configuration block for creating a new user profile. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] alias_attributes: Attributes supported as an alias for this user pool. Valid values: `phone_number`, `email`, or `preferred_username`. Conflicts with `username_attributes`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] auto_verified_attributes: Attributes to be auto-verified. Valid values: `email`, `phone_number`.
        :param pulumi.Input[pulumi.InputType['UserPoolDeviceConfigurationArgs']] device_configuration: Configuration block for the user pool's device tracking. Detailed below.
        :param pulumi.Input[pulumi.InputType['UserPoolEmailConfigurationArgs']] email_configuration: Configuration block for configuring email. Detailed below.
        :param pulumi.Input[str] email_verification_message: String representing the email verification message. Conflicts with `verification_message_template` configuration block `email_message` argument.
        :param pulumi.Input[str] email_verification_subject: String representing the email verification subject. Conflicts with `verification_message_template` configuration block `email_subject` argument.
        :param pulumi.Input[pulumi.InputType['UserPoolLambdaConfigArgs']] lambda_config: Configuration block for the AWS Lambda triggers associated with the user pool. Detailed below.
        :param pulumi.Input[str] mfa_configuration: Multi-Factor Authentication (MFA) configuration for the User Pool. Defaults of `OFF`. Valid values are `OFF` (MFA Tokens are not required), `ON` (MFA is required for all users to sign in; requires at least one of `sms_configuration` or `software_token_mfa_configuration` to be configured), or `OPTIONAL` (MFA Will be required only for individual users who have MFA Enabled; requires at least one of `sms_configuration` or `software_token_mfa_configuration` to be configured).
        :param pulumi.Input[str] name: Name of the attribute.
        :param pulumi.Input[pulumi.InputType['UserPoolPasswordPolicyArgs']] password_policy: Configuration blocked for information about the user pool password policy. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['UserPoolSchemaArgs']]]] schemas: Configuration block for the schema attributes of a user pool. Detailed below. Schema attributes from the [standard attribute set](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#cognito-user-pools-standard-attributes) only need to be specified if they are different from the default configuration. Attributes can be added, but not modified or removed. Maximum of 50 attributes.
        :param pulumi.Input[str] sms_authentication_message: String representing the SMS authentication message. The Message must contain the `{####}` placeholder, which will be replaced with the code.
        :param pulumi.Input[pulumi.InputType['UserPoolSmsConfigurationArgs']] sms_configuration: Configuration block for Short Message Service (SMS) settings. Detailed below. These settings apply to SMS user verification and SMS Multi-Factor Authentication (MFA). Due to Cognito API restrictions, the SMS configuration cannot be removed without recreating the Cognito User Pool. For user data safety, this resource will ignore the removal of this configuration by disabling drift detection.
        :param pulumi.Input[str] sms_verification_message: String representing the SMS verification message. Conflicts with `verification_message_template` configuration block `sms_message` argument.
        :param pulumi.Input[pulumi.InputType['UserPoolSoftwareTokenMfaConfigurationArgs']] software_token_mfa_configuration: Configuration block for software token Mult-Factor Authentication (MFA) settings. Detailed below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the User Pool. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[pulumi.InputType['UserPoolUserPoolAddOnsArgs']] user_pool_add_ons: Configuration block for user pool add-ons to enable user pool advanced security mode features. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] username_attributes: Whether email addresses or phone numbers can be specified as usernames when a user signs up. Conflicts with `alias_attributes`.
        :param pulumi.Input[pulumi.InputType['UserPoolUsernameConfigurationArgs']] username_configuration: Configuration block for username configuration. Detailed below.
        :param pulumi.Input[pulumi.InputType['UserPoolVerificationMessageTemplateArgs']] verification_message_template: Configuration block for verification message templates. Detailed below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[UserPoolArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cognito User Pool resource.

        ## Example Usage
        ### Basic configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        pool = aws.cognito.UserPool("pool")
        ```
        ### Enabling SMS and Software Token Multi-Factor Authentication

        ```python
        import pulumi
        import pulumi_aws as aws

        # ... other configuration ...
        example = aws.cognito.UserPool("example",
            mfa_configuration="ON",
            sms_authentication_message="Your code is {####}",
            sms_configuration=aws.cognito.UserPoolSmsConfigurationArgs(
                external_id="example",
                sns_caller_arn=aws_iam_role["example"]["arn"],
            ),
            software_token_mfa_configuration=aws.cognito.UserPoolSoftwareTokenMfaConfigurationArgs(
                enabled=True,
            ))
        ```
        ### Using Account Recovery Setting

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.cognito.UserPool("test", account_recovery_setting=aws.cognito.UserPoolAccountRecoverySettingArgs(
            recovery_mechanisms=[
                aws.cognito.UserPoolAccountRecoverySettingRecoveryMechanismArgs(
                    name="verified_email",
                    priority=1,
                ),
                aws.cognito.UserPoolAccountRecoverySettingRecoveryMechanismArgs(
                    name="verified_phone_number",
                    priority=2,
                ),
            ],
        ))
        ```

        ## Import

        Cognito User Pools can be imported using the `id`, e.g.,

        ```sh
         $ pulumi import aws:cognito/userPool:UserPool pool <id>
        ```

        :param str resource_name: The name of the resource.
        :param UserPoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserPoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_recovery_setting: Optional[pulumi.Input[pulumi.InputType['UserPoolAccountRecoverySettingArgs']]] = None,
                 admin_create_user_config: Optional[pulumi.Input[pulumi.InputType['UserPoolAdminCreateUserConfigArgs']]] = None,
                 alias_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 auto_verified_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 device_configuration: Optional[pulumi.Input[pulumi.InputType['UserPoolDeviceConfigurationArgs']]] = None,
                 email_configuration: Optional[pulumi.Input[pulumi.InputType['UserPoolEmailConfigurationArgs']]] = None,
                 email_verification_message: Optional[pulumi.Input[str]] = None,
                 email_verification_subject: Optional[pulumi.Input[str]] = None,
                 lambda_config: Optional[pulumi.Input[pulumi.InputType['UserPoolLambdaConfigArgs']]] = None,
                 mfa_configuration: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password_policy: Optional[pulumi.Input[pulumi.InputType['UserPoolPasswordPolicyArgs']]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['UserPoolSchemaArgs']]]]] = None,
                 sms_authentication_message: Optional[pulumi.Input[str]] = None,
                 sms_configuration: Optional[pulumi.Input[pulumi.InputType['UserPoolSmsConfigurationArgs']]] = None,
                 sms_verification_message: Optional[pulumi.Input[str]] = None,
                 software_token_mfa_configuration: Optional[pulumi.Input[pulumi.InputType['UserPoolSoftwareTokenMfaConfigurationArgs']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 user_pool_add_ons: Optional[pulumi.Input[pulumi.InputType['UserPoolUserPoolAddOnsArgs']]] = None,
                 username_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 username_configuration: Optional[pulumi.Input[pulumi.InputType['UserPoolUsernameConfigurationArgs']]] = None,
                 verification_message_template: Optional[pulumi.Input[pulumi.InputType['UserPoolVerificationMessageTemplateArgs']]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserPoolArgs.__new__(UserPoolArgs)

            __props__.__dict__["account_recovery_setting"] = account_recovery_setting
            __props__.__dict__["admin_create_user_config"] = admin_create_user_config
            __props__.__dict__["alias_attributes"] = alias_attributes
            __props__.__dict__["auto_verified_attributes"] = auto_verified_attributes
            __props__.__dict__["device_configuration"] = device_configuration
            __props__.__dict__["email_configuration"] = email_configuration
            __props__.__dict__["email_verification_message"] = email_verification_message
            __props__.__dict__["email_verification_subject"] = email_verification_subject
            __props__.__dict__["lambda_config"] = lambda_config
            __props__.__dict__["mfa_configuration"] = mfa_configuration
            __props__.__dict__["name"] = name
            __props__.__dict__["password_policy"] = password_policy
            __props__.__dict__["schemas"] = schemas
            __props__.__dict__["sms_authentication_message"] = sms_authentication_message
            __props__.__dict__["sms_configuration"] = sms_configuration
            __props__.__dict__["sms_verification_message"] = sms_verification_message
            __props__.__dict__["software_token_mfa_configuration"] = software_token_mfa_configuration
            __props__.__dict__["tags"] = tags
            __props__.__dict__["user_pool_add_ons"] = user_pool_add_ons
            __props__.__dict__["username_attributes"] = username_attributes
            __props__.__dict__["username_configuration"] = username_configuration
            __props__.__dict__["verification_message_template"] = verification_message_template
            __props__.__dict__["arn"] = None
            __props__.__dict__["creation_date"] = None
            __props__.__dict__["custom_domain"] = None
            __props__.__dict__["domain"] = None
            __props__.__dict__["endpoint"] = None
            __props__.__dict__["estimated_number_of_users"] = None
            __props__.__dict__["last_modified_date"] = None
            __props__.__dict__["tags_all"] = None
        super(UserPool, __self__).__init__(
            'aws:cognito/userPool:UserPool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_recovery_setting: Optional[pulumi.Input[pulumi.InputType['UserPoolAccountRecoverySettingArgs']]] = None,
            admin_create_user_config: Optional[pulumi.Input[pulumi.InputType['UserPoolAdminCreateUserConfigArgs']]] = None,
            alias_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            arn: Optional[pulumi.Input[str]] = None,
            auto_verified_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            creation_date: Optional[pulumi.Input[str]] = None,
            custom_domain: Optional[pulumi.Input[str]] = None,
            device_configuration: Optional[pulumi.Input[pulumi.InputType['UserPoolDeviceConfigurationArgs']]] = None,
            domain: Optional[pulumi.Input[str]] = None,
            email_configuration: Optional[pulumi.Input[pulumi.InputType['UserPoolEmailConfigurationArgs']]] = None,
            email_verification_message: Optional[pulumi.Input[str]] = None,
            email_verification_subject: Optional[pulumi.Input[str]] = None,
            endpoint: Optional[pulumi.Input[str]] = None,
            estimated_number_of_users: Optional[pulumi.Input[int]] = None,
            lambda_config: Optional[pulumi.Input[pulumi.InputType['UserPoolLambdaConfigArgs']]] = None,
            last_modified_date: Optional[pulumi.Input[str]] = None,
            mfa_configuration: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            password_policy: Optional[pulumi.Input[pulumi.InputType['UserPoolPasswordPolicyArgs']]] = None,
            schemas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['UserPoolSchemaArgs']]]]] = None,
            sms_authentication_message: Optional[pulumi.Input[str]] = None,
            sms_configuration: Optional[pulumi.Input[pulumi.InputType['UserPoolSmsConfigurationArgs']]] = None,
            sms_verification_message: Optional[pulumi.Input[str]] = None,
            software_token_mfa_configuration: Optional[pulumi.Input[pulumi.InputType['UserPoolSoftwareTokenMfaConfigurationArgs']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            user_pool_add_ons: Optional[pulumi.Input[pulumi.InputType['UserPoolUserPoolAddOnsArgs']]] = None,
            username_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            username_configuration: Optional[pulumi.Input[pulumi.InputType['UserPoolUsernameConfigurationArgs']]] = None,
            verification_message_template: Optional[pulumi.Input[pulumi.InputType['UserPoolVerificationMessageTemplateArgs']]] = None) -> 'UserPool':
        """
        Get an existing UserPool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['UserPoolAccountRecoverySettingArgs']] account_recovery_setting: Configuration block to define which verified available method a user can use to recover their forgotten password. Detailed below.
        :param pulumi.Input[pulumi.InputType['UserPoolAdminCreateUserConfigArgs']] admin_create_user_config: Configuration block for creating a new user profile. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] alias_attributes: Attributes supported as an alias for this user pool. Valid values: `phone_number`, `email`, or `preferred_username`. Conflicts with `username_attributes`.
        :param pulumi.Input[str] arn: ARN of the user pool.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] auto_verified_attributes: Attributes to be auto-verified. Valid values: `email`, `phone_number`.
        :param pulumi.Input[str] creation_date: Date the user pool was created.
        :param pulumi.Input[str] custom_domain: A custom domain name that you provide to Amazon Cognito. This parameter applies only if you use a custom domain to host the sign-up and sign-in pages for your application. For example: `auth.example.com`.
        :param pulumi.Input[pulumi.InputType['UserPoolDeviceConfigurationArgs']] device_configuration: Configuration block for the user pool's device tracking. Detailed below.
        :param pulumi.Input[str] domain: Holds the domain prefix if the user pool has a domain associated with it.
        :param pulumi.Input[pulumi.InputType['UserPoolEmailConfigurationArgs']] email_configuration: Configuration block for configuring email. Detailed below.
        :param pulumi.Input[str] email_verification_message: String representing the email verification message. Conflicts with `verification_message_template` configuration block `email_message` argument.
        :param pulumi.Input[str] email_verification_subject: String representing the email verification subject. Conflicts with `verification_message_template` configuration block `email_subject` argument.
        :param pulumi.Input[str] endpoint: Endpoint name of the user pool. Example format: `cognito-idp.REGION.amazonaws.com/xxxx_yyyyy`
        :param pulumi.Input[int] estimated_number_of_users: A number estimating the size of the user pool.
        :param pulumi.Input[pulumi.InputType['UserPoolLambdaConfigArgs']] lambda_config: Configuration block for the AWS Lambda triggers associated with the user pool. Detailed below.
        :param pulumi.Input[str] last_modified_date: Date the user pool was last modified.
        :param pulumi.Input[str] mfa_configuration: Multi-Factor Authentication (MFA) configuration for the User Pool. Defaults of `OFF`. Valid values are `OFF` (MFA Tokens are not required), `ON` (MFA is required for all users to sign in; requires at least one of `sms_configuration` or `software_token_mfa_configuration` to be configured), or `OPTIONAL` (MFA Will be required only for individual users who have MFA Enabled; requires at least one of `sms_configuration` or `software_token_mfa_configuration` to be configured).
        :param pulumi.Input[str] name: Name of the attribute.
        :param pulumi.Input[pulumi.InputType['UserPoolPasswordPolicyArgs']] password_policy: Configuration blocked for information about the user pool password policy. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['UserPoolSchemaArgs']]]] schemas: Configuration block for the schema attributes of a user pool. Detailed below. Schema attributes from the [standard attribute set](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#cognito-user-pools-standard-attributes) only need to be specified if they are different from the default configuration. Attributes can be added, but not modified or removed. Maximum of 50 attributes.
        :param pulumi.Input[str] sms_authentication_message: String representing the SMS authentication message. The Message must contain the `{####}` placeholder, which will be replaced with the code.
        :param pulumi.Input[pulumi.InputType['UserPoolSmsConfigurationArgs']] sms_configuration: Configuration block for Short Message Service (SMS) settings. Detailed below. These settings apply to SMS user verification and SMS Multi-Factor Authentication (MFA). Due to Cognito API restrictions, the SMS configuration cannot be removed without recreating the Cognito User Pool. For user data safety, this resource will ignore the removal of this configuration by disabling drift detection.
        :param pulumi.Input[str] sms_verification_message: String representing the SMS verification message. Conflicts with `verification_message_template` configuration block `sms_message` argument.
        :param pulumi.Input[pulumi.InputType['UserPoolSoftwareTokenMfaConfigurationArgs']] software_token_mfa_configuration: Configuration block for software token Mult-Factor Authentication (MFA) settings. Detailed below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the User Pool. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider .
        :param pulumi.Input[pulumi.InputType['UserPoolUserPoolAddOnsArgs']] user_pool_add_ons: Configuration block for user pool add-ons to enable user pool advanced security mode features. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] username_attributes: Whether email addresses or phone numbers can be specified as usernames when a user signs up. Conflicts with `alias_attributes`.
        :param pulumi.Input[pulumi.InputType['UserPoolUsernameConfigurationArgs']] username_configuration: Configuration block for username configuration. Detailed below.
        :param pulumi.Input[pulumi.InputType['UserPoolVerificationMessageTemplateArgs']] verification_message_template: Configuration block for verification message templates. Detailed below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserPoolState.__new__(_UserPoolState)

        __props__.__dict__["account_recovery_setting"] = account_recovery_setting
        __props__.__dict__["admin_create_user_config"] = admin_create_user_config
        __props__.__dict__["alias_attributes"] = alias_attributes
        __props__.__dict__["arn"] = arn
        __props__.__dict__["auto_verified_attributes"] = auto_verified_attributes
        __props__.__dict__["creation_date"] = creation_date
        __props__.__dict__["custom_domain"] = custom_domain
        __props__.__dict__["device_configuration"] = device_configuration
        __props__.__dict__["domain"] = domain
        __props__.__dict__["email_configuration"] = email_configuration
        __props__.__dict__["email_verification_message"] = email_verification_message
        __props__.__dict__["email_verification_subject"] = email_verification_subject
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["estimated_number_of_users"] = estimated_number_of_users
        __props__.__dict__["lambda_config"] = lambda_config
        __props__.__dict__["last_modified_date"] = last_modified_date
        __props__.__dict__["mfa_configuration"] = mfa_configuration
        __props__.__dict__["name"] = name
        __props__.__dict__["password_policy"] = password_policy
        __props__.__dict__["schemas"] = schemas
        __props__.__dict__["sms_authentication_message"] = sms_authentication_message
        __props__.__dict__["sms_configuration"] = sms_configuration
        __props__.__dict__["sms_verification_message"] = sms_verification_message
        __props__.__dict__["software_token_mfa_configuration"] = software_token_mfa_configuration
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["user_pool_add_ons"] = user_pool_add_ons
        __props__.__dict__["username_attributes"] = username_attributes
        __props__.__dict__["username_configuration"] = username_configuration
        __props__.__dict__["verification_message_template"] = verification_message_template
        return UserPool(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountRecoverySetting")
    def account_recovery_setting(self) -> pulumi.Output[Optional['outputs.UserPoolAccountRecoverySetting']]:
        """
        Configuration block to define which verified available method a user can use to recover their forgotten password. Detailed below.
        """
        return pulumi.get(self, "account_recovery_setting")

    @property
    @pulumi.getter(name="adminCreateUserConfig")
    def admin_create_user_config(self) -> pulumi.Output['outputs.UserPoolAdminCreateUserConfig']:
        """
        Configuration block for creating a new user profile. Detailed below.
        """
        return pulumi.get(self, "admin_create_user_config")

    @property
    @pulumi.getter(name="aliasAttributes")
    def alias_attributes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Attributes supported as an alias for this user pool. Valid values: `phone_number`, `email`, or `preferred_username`. Conflicts with `username_attributes`.
        """
        return pulumi.get(self, "alias_attributes")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        ARN of the user pool.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="autoVerifiedAttributes")
    def auto_verified_attributes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Attributes to be auto-verified. Valid values: `email`, `phone_number`.
        """
        return pulumi.get(self, "auto_verified_attributes")

    @property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> pulumi.Output[str]:
        """
        Date the user pool was created.
        """
        return pulumi.get(self, "creation_date")

    @property
    @pulumi.getter(name="customDomain")
    def custom_domain(self) -> pulumi.Output[str]:
        """
        A custom domain name that you provide to Amazon Cognito. This parameter applies only if you use a custom domain to host the sign-up and sign-in pages for your application. For example: `auth.example.com`.
        """
        return pulumi.get(self, "custom_domain")

    @property
    @pulumi.getter(name="deviceConfiguration")
    def device_configuration(self) -> pulumi.Output[Optional['outputs.UserPoolDeviceConfiguration']]:
        """
        Configuration block for the user pool's device tracking. Detailed below.
        """
        return pulumi.get(self, "device_configuration")

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Output[str]:
        """
        Holds the domain prefix if the user pool has a domain associated with it.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="emailConfiguration")
    def email_configuration(self) -> pulumi.Output[Optional['outputs.UserPoolEmailConfiguration']]:
        """
        Configuration block for configuring email. Detailed below.
        """
        return pulumi.get(self, "email_configuration")

    @property
    @pulumi.getter(name="emailVerificationMessage")
    def email_verification_message(self) -> pulumi.Output[str]:
        """
        String representing the email verification message. Conflicts with `verification_message_template` configuration block `email_message` argument.
        """
        return pulumi.get(self, "email_verification_message")

    @property
    @pulumi.getter(name="emailVerificationSubject")
    def email_verification_subject(self) -> pulumi.Output[str]:
        """
        String representing the email verification subject. Conflicts with `verification_message_template` configuration block `email_subject` argument.
        """
        return pulumi.get(self, "email_verification_subject")

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[str]:
        """
        Endpoint name of the user pool. Example format: `cognito-idp.REGION.amazonaws.com/xxxx_yyyyy`
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="estimatedNumberOfUsers")
    def estimated_number_of_users(self) -> pulumi.Output[int]:
        """
        A number estimating the size of the user pool.
        """
        return pulumi.get(self, "estimated_number_of_users")

    @property
    @pulumi.getter(name="lambdaConfig")
    def lambda_config(self) -> pulumi.Output[Optional['outputs.UserPoolLambdaConfig']]:
        """
        Configuration block for the AWS Lambda triggers associated with the user pool. Detailed below.
        """
        return pulumi.get(self, "lambda_config")

    @property
    @pulumi.getter(name="lastModifiedDate")
    def last_modified_date(self) -> pulumi.Output[str]:
        """
        Date the user pool was last modified.
        """
        return pulumi.get(self, "last_modified_date")

    @property
    @pulumi.getter(name="mfaConfiguration")
    def mfa_configuration(self) -> pulumi.Output[Optional[str]]:
        """
        Multi-Factor Authentication (MFA) configuration for the User Pool. Defaults of `OFF`. Valid values are `OFF` (MFA Tokens are not required), `ON` (MFA is required for all users to sign in; requires at least one of `sms_configuration` or `software_token_mfa_configuration` to be configured), or `OPTIONAL` (MFA Will be required only for individual users who have MFA Enabled; requires at least one of `sms_configuration` or `software_token_mfa_configuration` to be configured).
        """
        return pulumi.get(self, "mfa_configuration")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the attribute.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="passwordPolicy")
    def password_policy(self) -> pulumi.Output['outputs.UserPoolPasswordPolicy']:
        """
        Configuration blocked for information about the user pool password policy. Detailed below.
        """
        return pulumi.get(self, "password_policy")

    @property
    @pulumi.getter
    def schemas(self) -> pulumi.Output[Optional[Sequence['outputs.UserPoolSchema']]]:
        """
        Configuration block for the schema attributes of a user pool. Detailed below. Schema attributes from the [standard attribute set](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#cognito-user-pools-standard-attributes) only need to be specified if they are different from the default configuration. Attributes can be added, but not modified or removed. Maximum of 50 attributes.
        """
        return pulumi.get(self, "schemas")

    @property
    @pulumi.getter(name="smsAuthenticationMessage")
    def sms_authentication_message(self) -> pulumi.Output[Optional[str]]:
        """
        String representing the SMS authentication message. The Message must contain the `{####}` placeholder, which will be replaced with the code.
        """
        return pulumi.get(self, "sms_authentication_message")

    @property
    @pulumi.getter(name="smsConfiguration")
    def sms_configuration(self) -> pulumi.Output['outputs.UserPoolSmsConfiguration']:
        """
        Configuration block for Short Message Service (SMS) settings. Detailed below. These settings apply to SMS user verification and SMS Multi-Factor Authentication (MFA). Due to Cognito API restrictions, the SMS configuration cannot be removed without recreating the Cognito User Pool. For user data safety, this resource will ignore the removal of this configuration by disabling drift detection.
        """
        return pulumi.get(self, "sms_configuration")

    @property
    @pulumi.getter(name="smsVerificationMessage")
    def sms_verification_message(self) -> pulumi.Output[str]:
        """
        String representing the SMS verification message. Conflicts with `verification_message_template` configuration block `sms_message` argument.
        """
        return pulumi.get(self, "sms_verification_message")

    @property
    @pulumi.getter(name="softwareTokenMfaConfiguration")
    def software_token_mfa_configuration(self) -> pulumi.Output[Optional['outputs.UserPoolSoftwareTokenMfaConfiguration']]:
        """
        Configuration block for software token Mult-Factor Authentication (MFA) settings. Detailed below.
        """
        return pulumi.get(self, "software_token_mfa_configuration")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Map of tags to assign to the User Pool. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider .
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="userPoolAddOns")
    def user_pool_add_ons(self) -> pulumi.Output[Optional['outputs.UserPoolUserPoolAddOns']]:
        """
        Configuration block for user pool add-ons to enable user pool advanced security mode features. Detailed below.
        """
        return pulumi.get(self, "user_pool_add_ons")

    @property
    @pulumi.getter(name="usernameAttributes")
    def username_attributes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Whether email addresses or phone numbers can be specified as usernames when a user signs up. Conflicts with `alias_attributes`.
        """
        return pulumi.get(self, "username_attributes")

    @property
    @pulumi.getter(name="usernameConfiguration")
    def username_configuration(self) -> pulumi.Output[Optional['outputs.UserPoolUsernameConfiguration']]:
        """
        Configuration block for username configuration. Detailed below.
        """
        return pulumi.get(self, "username_configuration")

    @property
    @pulumi.getter(name="verificationMessageTemplate")
    def verification_message_template(self) -> pulumi.Output['outputs.UserPoolVerificationMessageTemplate']:
        """
        Configuration block for verification message templates. Detailed below.
        """
        return pulumi.get(self, "verification_message_template")

