# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['LogStreamArgs', 'LogStream']

@pulumi.input_type
class LogStreamArgs:
    def __init__(__self__, *,
                 log_group_name: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a LogStream resource.
        :param pulumi.Input[str] log_group_name: The name of the log group under which the log stream is to be created.
        :param pulumi.Input[str] name: The name of the log stream. Must not be longer than 512 characters and must not contain `:`
        """
        pulumi.set(__self__, "log_group_name", log_group_name)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="logGroupName")
    def log_group_name(self) -> pulumi.Input[str]:
        """
        The name of the log group under which the log stream is to be created.
        """
        return pulumi.get(self, "log_group_name")

    @log_group_name.setter
    def log_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "log_group_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the log stream. Must not be longer than 512 characters and must not contain `:`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _LogStreamState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 log_group_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering LogStream resources.
        :param pulumi.Input[str] arn: The Amazon Resource Name (ARN) specifying the log stream.
        :param pulumi.Input[str] log_group_name: The name of the log group under which the log stream is to be created.
        :param pulumi.Input[str] name: The name of the log stream. Must not be longer than 512 characters and must not contain `:`
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if log_group_name is not None:
            pulumi.set(__self__, "log_group_name", log_group_name)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) specifying the log stream.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="logGroupName")
    def log_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the log group under which the log stream is to be created.
        """
        return pulumi.get(self, "log_group_name")

    @log_group_name.setter
    def log_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_group_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the log stream. Must not be longer than 512 characters and must not contain `:`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


class LogStream(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 log_group_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a CloudWatch Log Stream resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        yada = aws.cloudwatch.LogGroup("yada")
        foo = aws.cloudwatch.LogStream("foo", log_group_name=yada.name)
        ```

        ## Import

        Cloudwatch Log Stream can be imported using the stream's `log_group_name` and `name`, e.g.,

        ```sh
         $ pulumi import aws:cloudwatch/logStream:LogStream foo Yada:SampleLogStream1234
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] log_group_name: The name of the log group under which the log stream is to be created.
        :param pulumi.Input[str] name: The name of the log stream. Must not be longer than 512 characters and must not contain `:`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LogStreamArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a CloudWatch Log Stream resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        yada = aws.cloudwatch.LogGroup("yada")
        foo = aws.cloudwatch.LogStream("foo", log_group_name=yada.name)
        ```

        ## Import

        Cloudwatch Log Stream can be imported using the stream's `log_group_name` and `name`, e.g.,

        ```sh
         $ pulumi import aws:cloudwatch/logStream:LogStream foo Yada:SampleLogStream1234
        ```

        :param str resource_name: The name of the resource.
        :param LogStreamArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LogStreamArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 log_group_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LogStreamArgs.__new__(LogStreamArgs)

            if log_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'log_group_name'")
            __props__.__dict__["log_group_name"] = log_group_name
            __props__.__dict__["name"] = name
            __props__.__dict__["arn"] = None
        super(LogStream, __self__).__init__(
            'aws:cloudwatch/logStream:LogStream',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            log_group_name: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None) -> 'LogStream':
        """
        Get an existing LogStream resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: The Amazon Resource Name (ARN) specifying the log stream.
        :param pulumi.Input[str] log_group_name: The name of the log group under which the log stream is to be created.
        :param pulumi.Input[str] name: The name of the log stream. Must not be longer than 512 characters and must not contain `:`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LogStreamState.__new__(_LogStreamState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["log_group_name"] = log_group_name
        __props__.__dict__["name"] = name
        return LogStream(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) specifying the log stream.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="logGroupName")
    def log_group_name(self) -> pulumi.Output[str]:
        """
        The name of the log group under which the log stream is to be created.
        """
        return pulumi.get(self, "log_group_name")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the log stream. Must not be longer than 512 characters and must not contain `:`
        """
        return pulumi.get(self, "name")

