# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetEventSourceResult',
    'AwaitableGetEventSourceResult',
    'get_event_source',
    'get_event_source_output',
]

@pulumi.output_type
class GetEventSourceResult:
    """
    A collection of values returned by getEventSource.
    """
    def __init__(__self__, arn=None, created_by=None, id=None, name=None, name_prefix=None, state=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if created_by and not isinstance(created_by, str):
            raise TypeError("Expected argument 'created_by' to be a str")
        pulumi.set(__self__, "created_by", created_by)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if name_prefix and not isinstance(name_prefix, str):
            raise TypeError("Expected argument 'name_prefix' to be a str")
        pulumi.set(__self__, "name_prefix", name_prefix)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        The ARN of the partner event source
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> str:
        """
        The name of the SaaS partner that created the event source
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the event source
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[str]:
        return pulumi.get(self, "name_prefix")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the event source (`ACTIVE` or `PENDING`)
        """
        return pulumi.get(self, "state")


class AwaitableGetEventSourceResult(GetEventSourceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEventSourceResult(
            arn=self.arn,
            created_by=self.created_by,
            id=self.id,
            name=self.name,
            name_prefix=self.name_prefix,
            state=self.state)


def get_event_source(name_prefix: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEventSourceResult:
    """
    Use this data source to get information about an EventBridge Partner Event Source. This data source will only return one partner event source. An error will be returned if multiple sources match the same name prefix.

    > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    examplepartner = aws.cloudwatch.get_event_source(name_prefix="aws.partner/examplepartner.com")
    ```


    :param str name_prefix: Specifying this limits the results to only those partner event sources with names that start with the specified prefix
    """
    __args__ = dict()
    __args__['namePrefix'] = name_prefix
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws:cloudwatch/getEventSource:getEventSource', __args__, opts=opts, typ=GetEventSourceResult).value

    return AwaitableGetEventSourceResult(
        arn=__ret__.arn,
        created_by=__ret__.created_by,
        id=__ret__.id,
        name=__ret__.name,
        name_prefix=__ret__.name_prefix,
        state=__ret__.state)


@_utilities.lift_output_func(get_event_source)
def get_event_source_output(name_prefix: Optional[pulumi.Input[Optional[str]]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetEventSourceResult]:
    """
    Use this data source to get information about an EventBridge Partner Event Source. This data source will only return one partner event source. An error will be returned if multiple sources match the same name prefix.

    > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    examplepartner = aws.cloudwatch.get_event_source(name_prefix="aws.partner/examplepartner.com")
    ```


    :param str name_prefix: Specifying this limits the results to only those partner event sources with names that start with the specified prefix
    """
    ...
