# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['OriginAccessIdentityArgs', 'OriginAccessIdentity']

@pulumi.input_type
class OriginAccessIdentityArgs:
    def __init__(__self__, *,
                 comment: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a OriginAccessIdentity resource.
        :param pulumi.Input[str] comment: An optional comment for the origin access identity.
        """
        if comment is not None:
            pulumi.set(__self__, "comment", comment)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        An optional comment for the origin access identity.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)


@pulumi.input_type
class _OriginAccessIdentityState:
    def __init__(__self__, *,
                 caller_reference: Optional[pulumi.Input[str]] = None,
                 cloudfront_access_identity_path: Optional[pulumi.Input[str]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 iam_arn: Optional[pulumi.Input[str]] = None,
                 s3_canonical_user_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering OriginAccessIdentity resources.
        :param pulumi.Input[str] caller_reference: Internal value used by CloudFront to allow future
               updates to the origin access identity.
        :param pulumi.Input[str] cloudfront_access_identity_path: A shortcut to the full path for the
               origin access identity to use in CloudFront, see below.
        :param pulumi.Input[str] comment: An optional comment for the origin access identity.
        :param pulumi.Input[str] etag: The current version of the origin access identity's information.
               For example: `E2QWRUHAPOMQZL`.
        :param pulumi.Input[str] iam_arn: A pre-generated ARN for use in S3 bucket policies (see below).
               Example: `arn:aws:iam::cloudfront:user/CloudFront Origin Access Identity
               E2QWRUHAPOMQZL`.
        :param pulumi.Input[str] s3_canonical_user_id: The Amazon S3 canonical user ID for the origin
               access identity, which you use when giving the origin access identity read
               permission to an object in Amazon S3.
        """
        if caller_reference is not None:
            pulumi.set(__self__, "caller_reference", caller_reference)
        if cloudfront_access_identity_path is not None:
            pulumi.set(__self__, "cloudfront_access_identity_path", cloudfront_access_identity_path)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if iam_arn is not None:
            pulumi.set(__self__, "iam_arn", iam_arn)
        if s3_canonical_user_id is not None:
            pulumi.set(__self__, "s3_canonical_user_id", s3_canonical_user_id)

    @property
    @pulumi.getter(name="callerReference")
    def caller_reference(self) -> Optional[pulumi.Input[str]]:
        """
        Internal value used by CloudFront to allow future
        updates to the origin access identity.
        """
        return pulumi.get(self, "caller_reference")

    @caller_reference.setter
    def caller_reference(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "caller_reference", value)

    @property
    @pulumi.getter(name="cloudfrontAccessIdentityPath")
    def cloudfront_access_identity_path(self) -> Optional[pulumi.Input[str]]:
        """
        A shortcut to the full path for the
        origin access identity to use in CloudFront, see below.
        """
        return pulumi.get(self, "cloudfront_access_identity_path")

    @cloudfront_access_identity_path.setter
    def cloudfront_access_identity_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloudfront_access_identity_path", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        An optional comment for the origin access identity.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        The current version of the origin access identity's information.
        For example: `E2QWRUHAPOMQZL`.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter(name="iamArn")
    def iam_arn(self) -> Optional[pulumi.Input[str]]:
        """
        A pre-generated ARN for use in S3 bucket policies (see below).
        Example: `arn:aws:iam::cloudfront:user/CloudFront Origin Access Identity
        E2QWRUHAPOMQZL`.
        """
        return pulumi.get(self, "iam_arn")

    @iam_arn.setter
    def iam_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iam_arn", value)

    @property
    @pulumi.getter(name="s3CanonicalUserId")
    def s3_canonical_user_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon S3 canonical user ID for the origin
        access identity, which you use when giving the origin access identity read
        permission to an object in Amazon S3.
        """
        return pulumi.get(self, "s3_canonical_user_id")

    @s3_canonical_user_id.setter
    def s3_canonical_user_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "s3_canonical_user_id", value)


class OriginAccessIdentity(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates an Amazon CloudFront origin access identity.

        For information about CloudFront distributions, see the
        [Amazon CloudFront Developer Guide](http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Introduction.html). For more information on generating
        origin access identities, see
        [Using an Origin Access Identity to Restrict Access to Your Amazon S3 Content][2].

        ## Example Usage

        The following example below creates a CloudFront origin access identity.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cloudfront.OriginAccessIdentity("example", comment="Some comment")
        ```
        ## Using With CloudFront

        Normally, when referencing an origin access identity in CloudFront, you need to
        prefix the ID with the `origin-access-identity/cloudfront/` special path.
        The `cloudfront_access_identity_path` allows this to be circumvented.
        The below snippet demonstrates use with the `s3_origin_config` structure for the
        `cloudfront.Distribution` resource:

        ```python
        import pulumi
        import pulumi_aws as aws

        # ... other configuration ...
        example = aws.cloudfront.Distribution("example", origins=[aws.cloudfront.DistributionOriginArgs(
            s3_origin_config=aws.cloudfront.DistributionOriginS3OriginConfigArgs(
                origin_access_identity=aws_cloudfront_origin_access_identity["example"]["cloudfront_access_identity_path"],
            ),
        )])
        ```

        ### Updating your bucket policy

        Note that the AWS API may translate the `s3_canonical_user_id` `CanonicalUser`
        principal into an `AWS` IAM ARN principal when supplied in an
        `s3.Bucket` bucket policy, causing spurious diffs. If
        you see this behaviour, use the `iam_arn` instead:

        ```python
        import pulumi
        import pulumi_aws as aws

        s3_policy = aws.iam.get_policy_document(statements=[aws.iam.GetPolicyDocumentStatementArgs(
            actions=["s3:GetObject"],
            resources=[f"{aws_s3_bucket['example']['arn']}/*"],
            principals=[aws.iam.GetPolicyDocumentStatementPrincipalArgs(
                type="AWS",
                identifiers=[aws_cloudfront_origin_access_identity["example"]["iam_arn"]],
            )],
        )])
        example = aws.s3.BucketPolicy("example",
            bucket=aws_s3_bucket["example"]["id"],
            policy=s3_policy.json)
        ```

        [1]: http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Introduction.html
        [2]: http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html

        ## Import

        Cloudfront Origin Access Identities can be imported using the `id`, e.g.,

        ```sh
         $ pulumi import aws:cloudfront/originAccessIdentity:OriginAccessIdentity origin_access E74FTE3AEXAMPLE
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] comment: An optional comment for the origin access identity.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[OriginAccessIdentityArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates an Amazon CloudFront origin access identity.

        For information about CloudFront distributions, see the
        [Amazon CloudFront Developer Guide](http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Introduction.html). For more information on generating
        origin access identities, see
        [Using an Origin Access Identity to Restrict Access to Your Amazon S3 Content][2].

        ## Example Usage

        The following example below creates a CloudFront origin access identity.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cloudfront.OriginAccessIdentity("example", comment="Some comment")
        ```
        ## Using With CloudFront

        Normally, when referencing an origin access identity in CloudFront, you need to
        prefix the ID with the `origin-access-identity/cloudfront/` special path.
        The `cloudfront_access_identity_path` allows this to be circumvented.
        The below snippet demonstrates use with the `s3_origin_config` structure for the
        `cloudfront.Distribution` resource:

        ```python
        import pulumi
        import pulumi_aws as aws

        # ... other configuration ...
        example = aws.cloudfront.Distribution("example", origins=[aws.cloudfront.DistributionOriginArgs(
            s3_origin_config=aws.cloudfront.DistributionOriginS3OriginConfigArgs(
                origin_access_identity=aws_cloudfront_origin_access_identity["example"]["cloudfront_access_identity_path"],
            ),
        )])
        ```

        ### Updating your bucket policy

        Note that the AWS API may translate the `s3_canonical_user_id` `CanonicalUser`
        principal into an `AWS` IAM ARN principal when supplied in an
        `s3.Bucket` bucket policy, causing spurious diffs. If
        you see this behaviour, use the `iam_arn` instead:

        ```python
        import pulumi
        import pulumi_aws as aws

        s3_policy = aws.iam.get_policy_document(statements=[aws.iam.GetPolicyDocumentStatementArgs(
            actions=["s3:GetObject"],
            resources=[f"{aws_s3_bucket['example']['arn']}/*"],
            principals=[aws.iam.GetPolicyDocumentStatementPrincipalArgs(
                type="AWS",
                identifiers=[aws_cloudfront_origin_access_identity["example"]["iam_arn"]],
            )],
        )])
        example = aws.s3.BucketPolicy("example",
            bucket=aws_s3_bucket["example"]["id"],
            policy=s3_policy.json)
        ```

        [1]: http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Introduction.html
        [2]: http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html

        ## Import

        Cloudfront Origin Access Identities can be imported using the `id`, e.g.,

        ```sh
         $ pulumi import aws:cloudfront/originAccessIdentity:OriginAccessIdentity origin_access E74FTE3AEXAMPLE
        ```

        :param str resource_name: The name of the resource.
        :param OriginAccessIdentityArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OriginAccessIdentityArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OriginAccessIdentityArgs.__new__(OriginAccessIdentityArgs)

            __props__.__dict__["comment"] = comment
            __props__.__dict__["caller_reference"] = None
            __props__.__dict__["cloudfront_access_identity_path"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["iam_arn"] = None
            __props__.__dict__["s3_canonical_user_id"] = None
        super(OriginAccessIdentity, __self__).__init__(
            'aws:cloudfront/originAccessIdentity:OriginAccessIdentity',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            caller_reference: Optional[pulumi.Input[str]] = None,
            cloudfront_access_identity_path: Optional[pulumi.Input[str]] = None,
            comment: Optional[pulumi.Input[str]] = None,
            etag: Optional[pulumi.Input[str]] = None,
            iam_arn: Optional[pulumi.Input[str]] = None,
            s3_canonical_user_id: Optional[pulumi.Input[str]] = None) -> 'OriginAccessIdentity':
        """
        Get an existing OriginAccessIdentity resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] caller_reference: Internal value used by CloudFront to allow future
               updates to the origin access identity.
        :param pulumi.Input[str] cloudfront_access_identity_path: A shortcut to the full path for the
               origin access identity to use in CloudFront, see below.
        :param pulumi.Input[str] comment: An optional comment for the origin access identity.
        :param pulumi.Input[str] etag: The current version of the origin access identity's information.
               For example: `E2QWRUHAPOMQZL`.
        :param pulumi.Input[str] iam_arn: A pre-generated ARN for use in S3 bucket policies (see below).
               Example: `arn:aws:iam::cloudfront:user/CloudFront Origin Access Identity
               E2QWRUHAPOMQZL`.
        :param pulumi.Input[str] s3_canonical_user_id: The Amazon S3 canonical user ID for the origin
               access identity, which you use when giving the origin access identity read
               permission to an object in Amazon S3.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OriginAccessIdentityState.__new__(_OriginAccessIdentityState)

        __props__.__dict__["caller_reference"] = caller_reference
        __props__.__dict__["cloudfront_access_identity_path"] = cloudfront_access_identity_path
        __props__.__dict__["comment"] = comment
        __props__.__dict__["etag"] = etag
        __props__.__dict__["iam_arn"] = iam_arn
        __props__.__dict__["s3_canonical_user_id"] = s3_canonical_user_id
        return OriginAccessIdentity(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="callerReference")
    def caller_reference(self) -> pulumi.Output[str]:
        """
        Internal value used by CloudFront to allow future
        updates to the origin access identity.
        """
        return pulumi.get(self, "caller_reference")

    @property
    @pulumi.getter(name="cloudfrontAccessIdentityPath")
    def cloudfront_access_identity_path(self) -> pulumi.Output[str]:
        """
        A shortcut to the full path for the
        origin access identity to use in CloudFront, see below.
        """
        return pulumi.get(self, "cloudfront_access_identity_path")

    @property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[str]]:
        """
        An optional comment for the origin access identity.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        """
        The current version of the origin access identity's information.
        For example: `E2QWRUHAPOMQZL`.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="iamArn")
    def iam_arn(self) -> pulumi.Output[str]:
        """
        A pre-generated ARN for use in S3 bucket policies (see below).
        Example: `arn:aws:iam::cloudfront:user/CloudFront Origin Access Identity
        E2QWRUHAPOMQZL`.
        """
        return pulumi.get(self, "iam_arn")

    @property
    @pulumi.getter(name="s3CanonicalUserId")
    def s3_canonical_user_id(self) -> pulumi.Output[str]:
        """
        The Amazon S3 canonical user ID for the origin
        access identity, which you use when giving the origin access identity read
        permission to an object in Amazon S3.
        """
        return pulumi.get(self, "s3_canonical_user_id")

