# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['KeyGroupArgs', 'KeyGroup']

@pulumi.input_type
class KeyGroupArgs:
    def __init__(__self__, *,
                 items: pulumi.Input[Sequence[pulumi.Input[str]]],
                 comment: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a KeyGroup resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] items: A list of the identifiers of the public keys in the key group.
        :param pulumi.Input[str] comment: A comment to describe the key group..
        :param pulumi.Input[str] name: A name to identify the key group.
        """
        pulumi.set(__self__, "items", items)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def items(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of the identifiers of the public keys in the key group.
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "items", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        A comment to describe the key group..
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A name to identify the key group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _KeyGroupState:
    def __init__(__self__, *,
                 comment: Optional[pulumi.Input[str]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering KeyGroup resources.
        :param pulumi.Input[str] comment: A comment to describe the key group..
        :param pulumi.Input[str] etag: The identifier for this version of the key group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] items: A list of the identifiers of the public keys in the key group.
        :param pulumi.Input[str] name: A name to identify the key group.
        """
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if items is not None:
            pulumi.set(__self__, "items", items)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        A comment to describe the key group..
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier for this version of the key group.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of the identifiers of the public keys in the key group.
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "items", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A name to identify the key group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


class KeyGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        The following example below creates a CloudFront key group.

        ```python
        import pulumi
        import pulumi_aws as aws

        example_public_key = aws.cloudfront.PublicKey("examplePublicKey",
            comment="example public key",
            encoded_key=(lambda path: open(path).read())("public_key.pem"))
        example_key_group = aws.cloudfront.KeyGroup("exampleKeyGroup",
            comment="example key group",
            items=[example_public_key.id])
        ```

        ## Import

        CloudFront Key Group can be imported using the `id`, e.g.,

        ```sh
         $ pulumi import aws:cloudfront/keyGroup:KeyGroup example 4b4f2r1c-315d-5c2e-f093-216t50jed10f
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] comment: A comment to describe the key group..
        :param pulumi.Input[Sequence[pulumi.Input[str]]] items: A list of the identifiers of the public keys in the key group.
        :param pulumi.Input[str] name: A name to identify the key group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KeyGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        The following example below creates a CloudFront key group.

        ```python
        import pulumi
        import pulumi_aws as aws

        example_public_key = aws.cloudfront.PublicKey("examplePublicKey",
            comment="example public key",
            encoded_key=(lambda path: open(path).read())("public_key.pem"))
        example_key_group = aws.cloudfront.KeyGroup("exampleKeyGroup",
            comment="example key group",
            items=[example_public_key.id])
        ```

        ## Import

        CloudFront Key Group can be imported using the `id`, e.g.,

        ```sh
         $ pulumi import aws:cloudfront/keyGroup:KeyGroup example 4b4f2r1c-315d-5c2e-f093-216t50jed10f
        ```

        :param str resource_name: The name of the resource.
        :param KeyGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KeyGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KeyGroupArgs.__new__(KeyGroupArgs)

            __props__.__dict__["comment"] = comment
            if items is None and not opts.urn:
                raise TypeError("Missing required property 'items'")
            __props__.__dict__["items"] = items
            __props__.__dict__["name"] = name
            __props__.__dict__["etag"] = None
        super(KeyGroup, __self__).__init__(
            'aws:cloudfront/keyGroup:KeyGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            comment: Optional[pulumi.Input[str]] = None,
            etag: Optional[pulumi.Input[str]] = None,
            items: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None) -> 'KeyGroup':
        """
        Get an existing KeyGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] comment: A comment to describe the key group..
        :param pulumi.Input[str] etag: The identifier for this version of the key group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] items: A list of the identifiers of the public keys in the key group.
        :param pulumi.Input[str] name: A name to identify the key group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KeyGroupState.__new__(_KeyGroupState)

        __props__.__dict__["comment"] = comment
        __props__.__dict__["etag"] = etag
        __props__.__dict__["items"] = items
        __props__.__dict__["name"] = name
        return KeyGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[str]]:
        """
        A comment to describe the key group..
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        """
        The identifier for this version of the key group.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def items(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of the identifiers of the public keys in the key group.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A name to identify the key group.
        """
        return pulumi.get(self, "name")

