# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'GroupInitialLifecycleHookArgs',
    'GroupInstanceRefreshArgs',
    'GroupInstanceRefreshPreferencesArgs',
    'GroupLaunchTemplateArgs',
    'GroupMixedInstancesPolicyArgs',
    'GroupMixedInstancesPolicyInstancesDistributionArgs',
    'GroupMixedInstancesPolicyLaunchTemplateArgs',
    'GroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecificationArgs',
    'GroupMixedInstancesPolicyLaunchTemplateOverrideArgs',
    'GroupMixedInstancesPolicyLaunchTemplateOverrideLaunchTemplateSpecificationArgs',
    'GroupTagArgs',
    'GroupWarmPoolArgs',
    'PolicyPredictiveScalingConfigurationArgs',
    'PolicyPredictiveScalingConfigurationMetricSpecificationArgs',
    'PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedLoadMetricSpecificationArgs',
    'PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedMetricPairSpecificationArgs',
    'PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedScalingMetricSpecificationArgs',
    'PolicyStepAdjustmentArgs',
    'PolicyTargetTrackingConfigurationArgs',
    'PolicyTargetTrackingConfigurationCustomizedMetricSpecificationArgs',
    'PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricDimensionArgs',
    'PolicyTargetTrackingConfigurationPredefinedMetricSpecificationArgs',
    'TagTagArgs',
    'GetAmiIdsFilterArgs',
]

@pulumi.input_type
class GroupInitialLifecycleHookArgs:
    def __init__(__self__, *,
                 lifecycle_transition: pulumi.Input[str],
                 name: pulumi.Input[str],
                 default_result: Optional[pulumi.Input[str]] = None,
                 heartbeat_timeout: Optional[pulumi.Input[int]] = None,
                 notification_metadata: Optional[pulumi.Input[str]] = None,
                 notification_target_arn: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The name of the Auto Scaling Group. By default generated by this provider. Conflicts with `name_prefix`.
        """
        pulumi.set(__self__, "lifecycle_transition", lifecycle_transition)
        pulumi.set(__self__, "name", name)
        if default_result is not None:
            pulumi.set(__self__, "default_result", default_result)
        if heartbeat_timeout is not None:
            pulumi.set(__self__, "heartbeat_timeout", heartbeat_timeout)
        if notification_metadata is not None:
            pulumi.set(__self__, "notification_metadata", notification_metadata)
        if notification_target_arn is not None:
            pulumi.set(__self__, "notification_target_arn", notification_target_arn)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="lifecycleTransition")
    def lifecycle_transition(self) -> pulumi.Input[str]:
        return pulumi.get(self, "lifecycle_transition")

    @lifecycle_transition.setter
    def lifecycle_transition(self, value: pulumi.Input[str]):
        pulumi.set(self, "lifecycle_transition", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the Auto Scaling Group. By default generated by this provider. Conflicts with `name_prefix`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="defaultResult")
    def default_result(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "default_result")

    @default_result.setter
    def default_result(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_result", value)

    @property
    @pulumi.getter(name="heartbeatTimeout")
    def heartbeat_timeout(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "heartbeat_timeout")

    @heartbeat_timeout.setter
    def heartbeat_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "heartbeat_timeout", value)

    @property
    @pulumi.getter(name="notificationMetadata")
    def notification_metadata(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "notification_metadata")

    @notification_metadata.setter
    def notification_metadata(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notification_metadata", value)

    @property
    @pulumi.getter(name="notificationTargetArn")
    def notification_target_arn(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "notification_target_arn")

    @notification_target_arn.setter
    def notification_target_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notification_target_arn", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_arn", value)


@pulumi.input_type
class GroupInstanceRefreshArgs:
    def __init__(__self__, *,
                 strategy: pulumi.Input[str],
                 preferences: Optional[pulumi.Input['GroupInstanceRefreshPreferencesArgs']] = None,
                 triggers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] strategy: The strategy to use for instance refresh. The only allowed value is `Rolling`. See [StartInstanceRefresh Action](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_StartInstanceRefresh.html#API_StartInstanceRefresh_RequestParameters) for more information.
        :param pulumi.Input['GroupInstanceRefreshPreferencesArgs'] preferences: Override default parameters for Instance Refresh.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] triggers: Set of additional property names that will trigger an Instance Refresh. A refresh will always be triggered by a change in any of `launch_configuration`, `launch_template`, or `mixed_instances_policy`.
        """
        pulumi.set(__self__, "strategy", strategy)
        if preferences is not None:
            pulumi.set(__self__, "preferences", preferences)
        if triggers is not None:
            pulumi.set(__self__, "triggers", triggers)

    @property
    @pulumi.getter
    def strategy(self) -> pulumi.Input[str]:
        """
        The strategy to use for instance refresh. The only allowed value is `Rolling`. See [StartInstanceRefresh Action](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_StartInstanceRefresh.html#API_StartInstanceRefresh_RequestParameters) for more information.
        """
        return pulumi.get(self, "strategy")

    @strategy.setter
    def strategy(self, value: pulumi.Input[str]):
        pulumi.set(self, "strategy", value)

    @property
    @pulumi.getter
    def preferences(self) -> Optional[pulumi.Input['GroupInstanceRefreshPreferencesArgs']]:
        """
        Override default parameters for Instance Refresh.
        """
        return pulumi.get(self, "preferences")

    @preferences.setter
    def preferences(self, value: Optional[pulumi.Input['GroupInstanceRefreshPreferencesArgs']]):
        pulumi.set(self, "preferences", value)

    @property
    @pulumi.getter
    def triggers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set of additional property names that will trigger an Instance Refresh. A refresh will always be triggered by a change in any of `launch_configuration`, `launch_template`, or `mixed_instances_policy`.
        """
        return pulumi.get(self, "triggers")

    @triggers.setter
    def triggers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "triggers", value)


@pulumi.input_type
class GroupInstanceRefreshPreferencesArgs:
    def __init__(__self__, *,
                 checkpoint_delay: Optional[pulumi.Input[str]] = None,
                 checkpoint_percentages: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 instance_warmup: Optional[pulumi.Input[str]] = None,
                 min_healthy_percentage: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] checkpoint_delay: The number of seconds to wait after a checkpoint. Defaults to `3600`.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] checkpoint_percentages: List of percentages for each checkpoint. Values must be unique and in ascending order. To replace all instances, the final number must be `100`.
        :param pulumi.Input[str] instance_warmup: The number of seconds until a newly launched instance is configured and ready to use. Default behavior is to use the Auto Scaling Group's health check grace period.
        :param pulumi.Input[int] min_healthy_percentage: The amount of capacity in the Auto Scaling group that must remain healthy during an instance refresh to allow the operation to continue, as a percentage of the desired capacity of the Auto Scaling group. Defaults to `90`.
        """
        if checkpoint_delay is not None:
            pulumi.set(__self__, "checkpoint_delay", checkpoint_delay)
        if checkpoint_percentages is not None:
            pulumi.set(__self__, "checkpoint_percentages", checkpoint_percentages)
        if instance_warmup is not None:
            pulumi.set(__self__, "instance_warmup", instance_warmup)
        if min_healthy_percentage is not None:
            pulumi.set(__self__, "min_healthy_percentage", min_healthy_percentage)

    @property
    @pulumi.getter(name="checkpointDelay")
    def checkpoint_delay(self) -> Optional[pulumi.Input[str]]:
        """
        The number of seconds to wait after a checkpoint. Defaults to `3600`.
        """
        return pulumi.get(self, "checkpoint_delay")

    @checkpoint_delay.setter
    def checkpoint_delay(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "checkpoint_delay", value)

    @property
    @pulumi.getter(name="checkpointPercentages")
    def checkpoint_percentages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        List of percentages for each checkpoint. Values must be unique and in ascending order. To replace all instances, the final number must be `100`.
        """
        return pulumi.get(self, "checkpoint_percentages")

    @checkpoint_percentages.setter
    def checkpoint_percentages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "checkpoint_percentages", value)

    @property
    @pulumi.getter(name="instanceWarmup")
    def instance_warmup(self) -> Optional[pulumi.Input[str]]:
        """
        The number of seconds until a newly launched instance is configured and ready to use. Default behavior is to use the Auto Scaling Group's health check grace period.
        """
        return pulumi.get(self, "instance_warmup")

    @instance_warmup.setter
    def instance_warmup(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_warmup", value)

    @property
    @pulumi.getter(name="minHealthyPercentage")
    def min_healthy_percentage(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of capacity in the Auto Scaling group that must remain healthy during an instance refresh to allow the operation to continue, as a percentage of the desired capacity of the Auto Scaling group. Defaults to `90`.
        """
        return pulumi.get(self, "min_healthy_percentage")

    @min_healthy_percentage.setter
    def min_healthy_percentage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_healthy_percentage", value)


@pulumi.input_type
class GroupLaunchTemplateArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] id: The ID of the launch template. Conflicts with `name`.
        :param pulumi.Input[str] name: The name of the Auto Scaling Group. By default generated by this provider. Conflicts with `name_prefix`.
        :param pulumi.Input[str] version: Template version. Can be version number, `$Latest`, or `$Default`. (Default: `$Default`).
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the launch template. Conflicts with `name`.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Auto Scaling Group. By default generated by this provider. Conflicts with `name_prefix`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Template version. Can be version number, `$Latest`, or `$Default`. (Default: `$Default`).
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class GroupMixedInstancesPolicyArgs:
    def __init__(__self__, *,
                 launch_template: pulumi.Input['GroupMixedInstancesPolicyLaunchTemplateArgs'],
                 instances_distribution: Optional[pulumi.Input['GroupMixedInstancesPolicyInstancesDistributionArgs']] = None):
        """
        :param pulumi.Input['GroupMixedInstancesPolicyLaunchTemplateArgs'] launch_template: Nested argument containing launch template settings along with the overrides to specify multiple instance types and weights. Defined below.
        :param pulumi.Input['GroupMixedInstancesPolicyInstancesDistributionArgs'] instances_distribution: Nested argument containing settings on how to mix on-demand and Spot instances in the Auto Scaling group. Defined below.
        """
        pulumi.set(__self__, "launch_template", launch_template)
        if instances_distribution is not None:
            pulumi.set(__self__, "instances_distribution", instances_distribution)

    @property
    @pulumi.getter(name="launchTemplate")
    def launch_template(self) -> pulumi.Input['GroupMixedInstancesPolicyLaunchTemplateArgs']:
        """
        Nested argument containing launch template settings along with the overrides to specify multiple instance types and weights. Defined below.
        """
        return pulumi.get(self, "launch_template")

    @launch_template.setter
    def launch_template(self, value: pulumi.Input['GroupMixedInstancesPolicyLaunchTemplateArgs']):
        pulumi.set(self, "launch_template", value)

    @property
    @pulumi.getter(name="instancesDistribution")
    def instances_distribution(self) -> Optional[pulumi.Input['GroupMixedInstancesPolicyInstancesDistributionArgs']]:
        """
        Nested argument containing settings on how to mix on-demand and Spot instances in the Auto Scaling group. Defined below.
        """
        return pulumi.get(self, "instances_distribution")

    @instances_distribution.setter
    def instances_distribution(self, value: Optional[pulumi.Input['GroupMixedInstancesPolicyInstancesDistributionArgs']]):
        pulumi.set(self, "instances_distribution", value)


@pulumi.input_type
class GroupMixedInstancesPolicyInstancesDistributionArgs:
    def __init__(__self__, *,
                 on_demand_allocation_strategy: Optional[pulumi.Input[str]] = None,
                 on_demand_base_capacity: Optional[pulumi.Input[int]] = None,
                 on_demand_percentage_above_base_capacity: Optional[pulumi.Input[int]] = None,
                 spot_allocation_strategy: Optional[pulumi.Input[str]] = None,
                 spot_instance_pools: Optional[pulumi.Input[int]] = None,
                 spot_max_price: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] on_demand_allocation_strategy: Strategy to use when launching on-demand instances. Valid values: `prioritized`. Default: `prioritized`.
        :param pulumi.Input[int] on_demand_base_capacity: Absolute minimum amount of desired capacity that must be fulfilled by on-demand instances. Default: `0`.
        :param pulumi.Input[int] on_demand_percentage_above_base_capacity: Percentage split between on-demand and Spot instances above the base on-demand capacity. Default: `100`.
        :param pulumi.Input[str] spot_allocation_strategy: How to allocate capacity across the Spot pools. Valid values: `lowest-price`, `capacity-optimized`, `capacity-optimized-prioritized`. Default: `lowest-price`.
        :param pulumi.Input[int] spot_instance_pools: Number of Spot pools per availability zone to allocate capacity. EC2 Auto Scaling selects the cheapest Spot pools and evenly allocates Spot capacity across the number of Spot pools that you specify. Only available with `spot_allocation_strategy` set to `lowest-price`. Otherwise it must be set to `0`, if it has been defined before. Default: `2`.
        :param pulumi.Input[str] spot_max_price: Maximum price per unit hour that the user is willing to pay for the Spot instances. Default: an empty string which means the on-demand price.
        """
        if on_demand_allocation_strategy is not None:
            pulumi.set(__self__, "on_demand_allocation_strategy", on_demand_allocation_strategy)
        if on_demand_base_capacity is not None:
            pulumi.set(__self__, "on_demand_base_capacity", on_demand_base_capacity)
        if on_demand_percentage_above_base_capacity is not None:
            pulumi.set(__self__, "on_demand_percentage_above_base_capacity", on_demand_percentage_above_base_capacity)
        if spot_allocation_strategy is not None:
            pulumi.set(__self__, "spot_allocation_strategy", spot_allocation_strategy)
        if spot_instance_pools is not None:
            pulumi.set(__self__, "spot_instance_pools", spot_instance_pools)
        if spot_max_price is not None:
            pulumi.set(__self__, "spot_max_price", spot_max_price)

    @property
    @pulumi.getter(name="onDemandAllocationStrategy")
    def on_demand_allocation_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        Strategy to use when launching on-demand instances. Valid values: `prioritized`. Default: `prioritized`.
        """
        return pulumi.get(self, "on_demand_allocation_strategy")

    @on_demand_allocation_strategy.setter
    def on_demand_allocation_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "on_demand_allocation_strategy", value)

    @property
    @pulumi.getter(name="onDemandBaseCapacity")
    def on_demand_base_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        Absolute minimum amount of desired capacity that must be fulfilled by on-demand instances. Default: `0`.
        """
        return pulumi.get(self, "on_demand_base_capacity")

    @on_demand_base_capacity.setter
    def on_demand_base_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "on_demand_base_capacity", value)

    @property
    @pulumi.getter(name="onDemandPercentageAboveBaseCapacity")
    def on_demand_percentage_above_base_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        Percentage split between on-demand and Spot instances above the base on-demand capacity. Default: `100`.
        """
        return pulumi.get(self, "on_demand_percentage_above_base_capacity")

    @on_demand_percentage_above_base_capacity.setter
    def on_demand_percentage_above_base_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "on_demand_percentage_above_base_capacity", value)

    @property
    @pulumi.getter(name="spotAllocationStrategy")
    def spot_allocation_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        How to allocate capacity across the Spot pools. Valid values: `lowest-price`, `capacity-optimized`, `capacity-optimized-prioritized`. Default: `lowest-price`.
        """
        return pulumi.get(self, "spot_allocation_strategy")

    @spot_allocation_strategy.setter
    def spot_allocation_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spot_allocation_strategy", value)

    @property
    @pulumi.getter(name="spotInstancePools")
    def spot_instance_pools(self) -> Optional[pulumi.Input[int]]:
        """
        Number of Spot pools per availability zone to allocate capacity. EC2 Auto Scaling selects the cheapest Spot pools and evenly allocates Spot capacity across the number of Spot pools that you specify. Only available with `spot_allocation_strategy` set to `lowest-price`. Otherwise it must be set to `0`, if it has been defined before. Default: `2`.
        """
        return pulumi.get(self, "spot_instance_pools")

    @spot_instance_pools.setter
    def spot_instance_pools(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "spot_instance_pools", value)

    @property
    @pulumi.getter(name="spotMaxPrice")
    def spot_max_price(self) -> Optional[pulumi.Input[str]]:
        """
        Maximum price per unit hour that the user is willing to pay for the Spot instances. Default: an empty string which means the on-demand price.
        """
        return pulumi.get(self, "spot_max_price")

    @spot_max_price.setter
    def spot_max_price(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spot_max_price", value)


@pulumi.input_type
class GroupMixedInstancesPolicyLaunchTemplateArgs:
    def __init__(__self__, *,
                 launch_template_specification: pulumi.Input['GroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecificationArgs'],
                 overrides: Optional[pulumi.Input[Sequence[pulumi.Input['GroupMixedInstancesPolicyLaunchTemplateOverrideArgs']]]] = None):
        """
        :param pulumi.Input['GroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecificationArgs'] launch_template_specification: Override the instance launch template specification in the Launch Template.
        :param pulumi.Input[Sequence[pulumi.Input['GroupMixedInstancesPolicyLaunchTemplateOverrideArgs']]] overrides: List of nested arguments provides the ability to specify multiple instance types. This will override the same parameter in the launch template. For on-demand instances, Auto Scaling considers the order of preference of instance types to launch based on the order specified in the overrides list. Defined below.
        """
        pulumi.set(__self__, "launch_template_specification", launch_template_specification)
        if overrides is not None:
            pulumi.set(__self__, "overrides", overrides)

    @property
    @pulumi.getter(name="launchTemplateSpecification")
    def launch_template_specification(self) -> pulumi.Input['GroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecificationArgs']:
        """
        Override the instance launch template specification in the Launch Template.
        """
        return pulumi.get(self, "launch_template_specification")

    @launch_template_specification.setter
    def launch_template_specification(self, value: pulumi.Input['GroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecificationArgs']):
        pulumi.set(self, "launch_template_specification", value)

    @property
    @pulumi.getter
    def overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GroupMixedInstancesPolicyLaunchTemplateOverrideArgs']]]]:
        """
        List of nested arguments provides the ability to specify multiple instance types. This will override the same parameter in the launch template. For on-demand instances, Auto Scaling considers the order of preference of instance types to launch based on the order specified in the overrides list. Defined below.
        """
        return pulumi.get(self, "overrides")

    @overrides.setter
    def overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GroupMixedInstancesPolicyLaunchTemplateOverrideArgs']]]]):
        pulumi.set(self, "overrides", value)


@pulumi.input_type
class GroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecificationArgs:
    def __init__(__self__, *,
                 launch_template_id: Optional[pulumi.Input[str]] = None,
                 launch_template_name: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] launch_template_id: The ID of the launch template. Conflicts with `launch_template_name`.
        :param pulumi.Input[str] launch_template_name: The name of the launch template. Conflicts with `launch_template_id`.
        :param pulumi.Input[str] version: Template version. Can be version number, `$Latest`, or `$Default`. (Default: `$Default`).
        """
        if launch_template_id is not None:
            pulumi.set(__self__, "launch_template_id", launch_template_id)
        if launch_template_name is not None:
            pulumi.set(__self__, "launch_template_name", launch_template_name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="launchTemplateId")
    def launch_template_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the launch template. Conflicts with `launch_template_name`.
        """
        return pulumi.get(self, "launch_template_id")

    @launch_template_id.setter
    def launch_template_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "launch_template_id", value)

    @property
    @pulumi.getter(name="launchTemplateName")
    def launch_template_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the launch template. Conflicts with `launch_template_id`.
        """
        return pulumi.get(self, "launch_template_name")

    @launch_template_name.setter
    def launch_template_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "launch_template_name", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Template version. Can be version number, `$Latest`, or `$Default`. (Default: `$Default`).
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class GroupMixedInstancesPolicyLaunchTemplateOverrideArgs:
    def __init__(__self__, *,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 launch_template_specification: Optional[pulumi.Input['GroupMixedInstancesPolicyLaunchTemplateOverrideLaunchTemplateSpecificationArgs']] = None,
                 weighted_capacity: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] instance_type: Override the instance type in the Launch Template.
        :param pulumi.Input['GroupMixedInstancesPolicyLaunchTemplateOverrideLaunchTemplateSpecificationArgs'] launch_template_specification: Override the instance launch template specification in the Launch Template.
        :param pulumi.Input[str] weighted_capacity: The number of capacity units, which gives the instance type a proportional weight to other instance types.
        """
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if launch_template_specification is not None:
            pulumi.set(__self__, "launch_template_specification", launch_template_specification)
        if weighted_capacity is not None:
            pulumi.set(__self__, "weighted_capacity", weighted_capacity)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        Override the instance type in the Launch Template.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="launchTemplateSpecification")
    def launch_template_specification(self) -> Optional[pulumi.Input['GroupMixedInstancesPolicyLaunchTemplateOverrideLaunchTemplateSpecificationArgs']]:
        """
        Override the instance launch template specification in the Launch Template.
        """
        return pulumi.get(self, "launch_template_specification")

    @launch_template_specification.setter
    def launch_template_specification(self, value: Optional[pulumi.Input['GroupMixedInstancesPolicyLaunchTemplateOverrideLaunchTemplateSpecificationArgs']]):
        pulumi.set(self, "launch_template_specification", value)

    @property
    @pulumi.getter(name="weightedCapacity")
    def weighted_capacity(self) -> Optional[pulumi.Input[str]]:
        """
        The number of capacity units, which gives the instance type a proportional weight to other instance types.
        """
        return pulumi.get(self, "weighted_capacity")

    @weighted_capacity.setter
    def weighted_capacity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "weighted_capacity", value)


@pulumi.input_type
class GroupMixedInstancesPolicyLaunchTemplateOverrideLaunchTemplateSpecificationArgs:
    def __init__(__self__, *,
                 launch_template_id: Optional[pulumi.Input[str]] = None,
                 launch_template_name: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] launch_template_id: The ID of the launch template. Conflicts with `launch_template_name`.
        :param pulumi.Input[str] launch_template_name: The name of the launch template. Conflicts with `launch_template_id`.
        :param pulumi.Input[str] version: Template version. Can be version number, `$Latest`, or `$Default`. (Default: `$Default`).
        """
        if launch_template_id is not None:
            pulumi.set(__self__, "launch_template_id", launch_template_id)
        if launch_template_name is not None:
            pulumi.set(__self__, "launch_template_name", launch_template_name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="launchTemplateId")
    def launch_template_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the launch template. Conflicts with `launch_template_name`.
        """
        return pulumi.get(self, "launch_template_id")

    @launch_template_id.setter
    def launch_template_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "launch_template_id", value)

    @property
    @pulumi.getter(name="launchTemplateName")
    def launch_template_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the launch template. Conflicts with `launch_template_id`.
        """
        return pulumi.get(self, "launch_template_name")

    @launch_template_name.setter
    def launch_template_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "launch_template_name", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Template version. Can be version number, `$Latest`, or `$Default`. (Default: `$Default`).
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class GroupTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 propagate_at_launch: pulumi.Input[bool],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] key: Key
        :param pulumi.Input[bool] propagate_at_launch: Enables propagation of the tag to
               Amazon EC2 instances launched via this ASG
        :param pulumi.Input[str] value: Value
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "propagate_at_launch", propagate_at_launch)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        Key
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="propagateAtLaunch")
    def propagate_at_launch(self) -> pulumi.Input[bool]:
        """
        Enables propagation of the tag to
        Amazon EC2 instances launched via this ASG
        """
        return pulumi.get(self, "propagate_at_launch")

    @propagate_at_launch.setter
    def propagate_at_launch(self, value: pulumi.Input[bool]):
        pulumi.set(self, "propagate_at_launch", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Value
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class GroupWarmPoolArgs:
    def __init__(__self__, *,
                 max_group_prepared_capacity: Optional[pulumi.Input[int]] = None,
                 min_size: Optional[pulumi.Input[int]] = None,
                 pool_state: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] max_group_prepared_capacity: Specifies the total maximum number of instances that are allowed to be in the warm pool or in any state except Terminated for the Auto Scaling group.
        :param pulumi.Input[int] min_size: Specifies the minimum number of instances to maintain in the warm pool. This helps you to ensure that there is always a certain number of warmed instances available to handle traffic spikes. Defaults to 0 if not specified.
        :param pulumi.Input[str] pool_state: Sets the instance state to transition to after the lifecycle hooks finish. Valid values are: Stopped (default) or Running.
        """
        if max_group_prepared_capacity is not None:
            pulumi.set(__self__, "max_group_prepared_capacity", max_group_prepared_capacity)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if pool_state is not None:
            pulumi.set(__self__, "pool_state", pool_state)

    @property
    @pulumi.getter(name="maxGroupPreparedCapacity")
    def max_group_prepared_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the total maximum number of instances that are allowed to be in the warm pool or in any state except Terminated for the Auto Scaling group.
        """
        return pulumi.get(self, "max_group_prepared_capacity")

    @max_group_prepared_capacity.setter
    def max_group_prepared_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_group_prepared_capacity", value)

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the minimum number of instances to maintain in the warm pool. This helps you to ensure that there is always a certain number of warmed instances available to handle traffic spikes. Defaults to 0 if not specified.
        """
        return pulumi.get(self, "min_size")

    @min_size.setter
    def min_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_size", value)

    @property
    @pulumi.getter(name="poolState")
    def pool_state(self) -> Optional[pulumi.Input[str]]:
        """
        Sets the instance state to transition to after the lifecycle hooks finish. Valid values are: Stopped (default) or Running.
        """
        return pulumi.get(self, "pool_state")

    @pool_state.setter
    def pool_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pool_state", value)


@pulumi.input_type
class PolicyPredictiveScalingConfigurationArgs:
    def __init__(__self__, *,
                 metric_specification: pulumi.Input['PolicyPredictiveScalingConfigurationMetricSpecificationArgs'],
                 max_capacity_breach_behavior: Optional[pulumi.Input[str]] = None,
                 max_capacity_buffer: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 scheduling_buffer_time: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input['PolicyPredictiveScalingConfigurationMetricSpecificationArgs'] metric_specification: This structure includes the metrics and target utilization to use for predictive scaling.
        :param pulumi.Input[str] max_capacity_breach_behavior: Defines the behavior that should be applied if the forecast capacity approaches or exceeds the maximum capacity of the Auto Scaling group. Valid values are `HonorMaxCapacity` or `IncreaseMaxCapacity`. Default is `HonorMaxCapacity`.
        :param pulumi.Input[str] max_capacity_buffer: The size of the capacity buffer to use when the forecast capacity is close to or exceeds the maximum capacity. Valid range is `0` to `100`. If set to `0`, Amazon EC2 Auto Scaling may scale capacity higher than the maximum capacity to equal but not exceed forecast capacity.
        :param pulumi.Input[str] mode: The predictive scaling mode. Valid values are `ForecastAndScale` and `ForecastOnly`. Default is `ForecastOnly`.
        :param pulumi.Input[str] scheduling_buffer_time: The amount of time, in seconds, by which the instance launch time can be advanced. Minimum is `0`.
        """
        pulumi.set(__self__, "metric_specification", metric_specification)
        if max_capacity_breach_behavior is not None:
            pulumi.set(__self__, "max_capacity_breach_behavior", max_capacity_breach_behavior)
        if max_capacity_buffer is not None:
            pulumi.set(__self__, "max_capacity_buffer", max_capacity_buffer)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if scheduling_buffer_time is not None:
            pulumi.set(__self__, "scheduling_buffer_time", scheduling_buffer_time)

    @property
    @pulumi.getter(name="metricSpecification")
    def metric_specification(self) -> pulumi.Input['PolicyPredictiveScalingConfigurationMetricSpecificationArgs']:
        """
        This structure includes the metrics and target utilization to use for predictive scaling.
        """
        return pulumi.get(self, "metric_specification")

    @metric_specification.setter
    def metric_specification(self, value: pulumi.Input['PolicyPredictiveScalingConfigurationMetricSpecificationArgs']):
        pulumi.set(self, "metric_specification", value)

    @property
    @pulumi.getter(name="maxCapacityBreachBehavior")
    def max_capacity_breach_behavior(self) -> Optional[pulumi.Input[str]]:
        """
        Defines the behavior that should be applied if the forecast capacity approaches or exceeds the maximum capacity of the Auto Scaling group. Valid values are `HonorMaxCapacity` or `IncreaseMaxCapacity`. Default is `HonorMaxCapacity`.
        """
        return pulumi.get(self, "max_capacity_breach_behavior")

    @max_capacity_breach_behavior.setter
    def max_capacity_breach_behavior(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_capacity_breach_behavior", value)

    @property
    @pulumi.getter(name="maxCapacityBuffer")
    def max_capacity_buffer(self) -> Optional[pulumi.Input[str]]:
        """
        The size of the capacity buffer to use when the forecast capacity is close to or exceeds the maximum capacity. Valid range is `0` to `100`. If set to `0`, Amazon EC2 Auto Scaling may scale capacity higher than the maximum capacity to equal but not exceed forecast capacity.
        """
        return pulumi.get(self, "max_capacity_buffer")

    @max_capacity_buffer.setter
    def max_capacity_buffer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_capacity_buffer", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[str]]:
        """
        The predictive scaling mode. Valid values are `ForecastAndScale` and `ForecastOnly`. Default is `ForecastOnly`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter(name="schedulingBufferTime")
    def scheduling_buffer_time(self) -> Optional[pulumi.Input[str]]:
        """
        The amount of time, in seconds, by which the instance launch time can be advanced. Minimum is `0`.
        """
        return pulumi.get(self, "scheduling_buffer_time")

    @scheduling_buffer_time.setter
    def scheduling_buffer_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scheduling_buffer_time", value)


@pulumi.input_type
class PolicyPredictiveScalingConfigurationMetricSpecificationArgs:
    def __init__(__self__, *,
                 target_value: pulumi.Input[int],
                 predefined_load_metric_specification: Optional[pulumi.Input['PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedLoadMetricSpecificationArgs']] = None,
                 predefined_metric_pair_specification: Optional[pulumi.Input['PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedMetricPairSpecificationArgs']] = None,
                 predefined_scaling_metric_specification: Optional[pulumi.Input['PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedScalingMetricSpecificationArgs']] = None):
        """
        :param pulumi.Input[int] target_value: The target value for the metric.
        :param pulumi.Input['PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedLoadMetricSpecificationArgs'] predefined_load_metric_specification: The load metric specification.
        :param pulumi.Input['PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedMetricPairSpecificationArgs'] predefined_metric_pair_specification: The metric pair specification from which Amazon EC2 Auto Scaling determines the appropriate scaling metric and load metric to use.
        :param pulumi.Input['PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedScalingMetricSpecificationArgs'] predefined_scaling_metric_specification: The scaling metric specification.
        """
        pulumi.set(__self__, "target_value", target_value)
        if predefined_load_metric_specification is not None:
            pulumi.set(__self__, "predefined_load_metric_specification", predefined_load_metric_specification)
        if predefined_metric_pair_specification is not None:
            pulumi.set(__self__, "predefined_metric_pair_specification", predefined_metric_pair_specification)
        if predefined_scaling_metric_specification is not None:
            pulumi.set(__self__, "predefined_scaling_metric_specification", predefined_scaling_metric_specification)

    @property
    @pulumi.getter(name="targetValue")
    def target_value(self) -> pulumi.Input[int]:
        """
        The target value for the metric.
        """
        return pulumi.get(self, "target_value")

    @target_value.setter
    def target_value(self, value: pulumi.Input[int]):
        pulumi.set(self, "target_value", value)

    @property
    @pulumi.getter(name="predefinedLoadMetricSpecification")
    def predefined_load_metric_specification(self) -> Optional[pulumi.Input['PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedLoadMetricSpecificationArgs']]:
        """
        The load metric specification.
        """
        return pulumi.get(self, "predefined_load_metric_specification")

    @predefined_load_metric_specification.setter
    def predefined_load_metric_specification(self, value: Optional[pulumi.Input['PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedLoadMetricSpecificationArgs']]):
        pulumi.set(self, "predefined_load_metric_specification", value)

    @property
    @pulumi.getter(name="predefinedMetricPairSpecification")
    def predefined_metric_pair_specification(self) -> Optional[pulumi.Input['PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedMetricPairSpecificationArgs']]:
        """
        The metric pair specification from which Amazon EC2 Auto Scaling determines the appropriate scaling metric and load metric to use.
        """
        return pulumi.get(self, "predefined_metric_pair_specification")

    @predefined_metric_pair_specification.setter
    def predefined_metric_pair_specification(self, value: Optional[pulumi.Input['PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedMetricPairSpecificationArgs']]):
        pulumi.set(self, "predefined_metric_pair_specification", value)

    @property
    @pulumi.getter(name="predefinedScalingMetricSpecification")
    def predefined_scaling_metric_specification(self) -> Optional[pulumi.Input['PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedScalingMetricSpecificationArgs']]:
        """
        The scaling metric specification.
        """
        return pulumi.get(self, "predefined_scaling_metric_specification")

    @predefined_scaling_metric_specification.setter
    def predefined_scaling_metric_specification(self, value: Optional[pulumi.Input['PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedScalingMetricSpecificationArgs']]):
        pulumi.set(self, "predefined_scaling_metric_specification", value)


@pulumi.input_type
class PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedLoadMetricSpecificationArgs:
    def __init__(__self__, *,
                 predefined_metric_type: pulumi.Input[str],
                 resource_label: pulumi.Input[str]):
        """
        :param pulumi.Input[str] predefined_metric_type: Describes a scaling metric for a predictive scaling policy. Valid values are `ASGAverageCPUUtilization`, `ASGAverageNetworkIn`, `ASGAverageNetworkOut`, or `ALBRequestCountPerTarget`.
        :param pulumi.Input[str] resource_label: A label that uniquely identifies a specific Application Load Balancer target group from which to determine the request count served by your Auto Scaling group.
        """
        pulumi.set(__self__, "predefined_metric_type", predefined_metric_type)
        pulumi.set(__self__, "resource_label", resource_label)

    @property
    @pulumi.getter(name="predefinedMetricType")
    def predefined_metric_type(self) -> pulumi.Input[str]:
        """
        Describes a scaling metric for a predictive scaling policy. Valid values are `ASGAverageCPUUtilization`, `ASGAverageNetworkIn`, `ASGAverageNetworkOut`, or `ALBRequestCountPerTarget`.
        """
        return pulumi.get(self, "predefined_metric_type")

    @predefined_metric_type.setter
    def predefined_metric_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "predefined_metric_type", value)

    @property
    @pulumi.getter(name="resourceLabel")
    def resource_label(self) -> pulumi.Input[str]:
        """
        A label that uniquely identifies a specific Application Load Balancer target group from which to determine the request count served by your Auto Scaling group.
        """
        return pulumi.get(self, "resource_label")

    @resource_label.setter
    def resource_label(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_label", value)


@pulumi.input_type
class PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedMetricPairSpecificationArgs:
    def __init__(__self__, *,
                 predefined_metric_type: pulumi.Input[str],
                 resource_label: pulumi.Input[str]):
        """
        :param pulumi.Input[str] predefined_metric_type: Describes a scaling metric for a predictive scaling policy. Valid values are `ASGAverageCPUUtilization`, `ASGAverageNetworkIn`, `ASGAverageNetworkOut`, or `ALBRequestCountPerTarget`.
        :param pulumi.Input[str] resource_label: A label that uniquely identifies a specific Application Load Balancer target group from which to determine the request count served by your Auto Scaling group.
        """
        pulumi.set(__self__, "predefined_metric_type", predefined_metric_type)
        pulumi.set(__self__, "resource_label", resource_label)

    @property
    @pulumi.getter(name="predefinedMetricType")
    def predefined_metric_type(self) -> pulumi.Input[str]:
        """
        Describes a scaling metric for a predictive scaling policy. Valid values are `ASGAverageCPUUtilization`, `ASGAverageNetworkIn`, `ASGAverageNetworkOut`, or `ALBRequestCountPerTarget`.
        """
        return pulumi.get(self, "predefined_metric_type")

    @predefined_metric_type.setter
    def predefined_metric_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "predefined_metric_type", value)

    @property
    @pulumi.getter(name="resourceLabel")
    def resource_label(self) -> pulumi.Input[str]:
        """
        A label that uniquely identifies a specific Application Load Balancer target group from which to determine the request count served by your Auto Scaling group.
        """
        return pulumi.get(self, "resource_label")

    @resource_label.setter
    def resource_label(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_label", value)


@pulumi.input_type
class PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedScalingMetricSpecificationArgs:
    def __init__(__self__, *,
                 predefined_metric_type: pulumi.Input[str],
                 resource_label: pulumi.Input[str]):
        """
        :param pulumi.Input[str] predefined_metric_type: Describes a scaling metric for a predictive scaling policy. Valid values are `ASGAverageCPUUtilization`, `ASGAverageNetworkIn`, `ASGAverageNetworkOut`, or `ALBRequestCountPerTarget`.
        :param pulumi.Input[str] resource_label: A label that uniquely identifies a specific Application Load Balancer target group from which to determine the request count served by your Auto Scaling group.
        """
        pulumi.set(__self__, "predefined_metric_type", predefined_metric_type)
        pulumi.set(__self__, "resource_label", resource_label)

    @property
    @pulumi.getter(name="predefinedMetricType")
    def predefined_metric_type(self) -> pulumi.Input[str]:
        """
        Describes a scaling metric for a predictive scaling policy. Valid values are `ASGAverageCPUUtilization`, `ASGAverageNetworkIn`, `ASGAverageNetworkOut`, or `ALBRequestCountPerTarget`.
        """
        return pulumi.get(self, "predefined_metric_type")

    @predefined_metric_type.setter
    def predefined_metric_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "predefined_metric_type", value)

    @property
    @pulumi.getter(name="resourceLabel")
    def resource_label(self) -> pulumi.Input[str]:
        """
        A label that uniquely identifies a specific Application Load Balancer target group from which to determine the request count served by your Auto Scaling group.
        """
        return pulumi.get(self, "resource_label")

    @resource_label.setter
    def resource_label(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_label", value)


@pulumi.input_type
class PolicyStepAdjustmentArgs:
    def __init__(__self__, *,
                 scaling_adjustment: pulumi.Input[int],
                 metric_interval_lower_bound: Optional[pulumi.Input[str]] = None,
                 metric_interval_upper_bound: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] scaling_adjustment: The number of members by which to
               scale, when the adjustment bounds are breached. A positive value scales
               up. A negative value scales down.
        :param pulumi.Input[str] metric_interval_lower_bound: The lower bound for the
               difference between the alarm threshold and the CloudWatch metric.
               Without a value, AWS will treat this bound as infinity.
        :param pulumi.Input[str] metric_interval_upper_bound: The upper bound for the
               difference between the alarm threshold and the CloudWatch metric.
               Without a value, AWS will treat this bound as infinity. The upper bound
               must be greater than the lower bound.
        """
        pulumi.set(__self__, "scaling_adjustment", scaling_adjustment)
        if metric_interval_lower_bound is not None:
            pulumi.set(__self__, "metric_interval_lower_bound", metric_interval_lower_bound)
        if metric_interval_upper_bound is not None:
            pulumi.set(__self__, "metric_interval_upper_bound", metric_interval_upper_bound)

    @property
    @pulumi.getter(name="scalingAdjustment")
    def scaling_adjustment(self) -> pulumi.Input[int]:
        """
        The number of members by which to
        scale, when the adjustment bounds are breached. A positive value scales
        up. A negative value scales down.
        """
        return pulumi.get(self, "scaling_adjustment")

    @scaling_adjustment.setter
    def scaling_adjustment(self, value: pulumi.Input[int]):
        pulumi.set(self, "scaling_adjustment", value)

    @property
    @pulumi.getter(name="metricIntervalLowerBound")
    def metric_interval_lower_bound(self) -> Optional[pulumi.Input[str]]:
        """
        The lower bound for the
        difference between the alarm threshold and the CloudWatch metric.
        Without a value, AWS will treat this bound as infinity.
        """
        return pulumi.get(self, "metric_interval_lower_bound")

    @metric_interval_lower_bound.setter
    def metric_interval_lower_bound(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric_interval_lower_bound", value)

    @property
    @pulumi.getter(name="metricIntervalUpperBound")
    def metric_interval_upper_bound(self) -> Optional[pulumi.Input[str]]:
        """
        The upper bound for the
        difference between the alarm threshold and the CloudWatch metric.
        Without a value, AWS will treat this bound as infinity. The upper bound
        must be greater than the lower bound.
        """
        return pulumi.get(self, "metric_interval_upper_bound")

    @metric_interval_upper_bound.setter
    def metric_interval_upper_bound(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric_interval_upper_bound", value)


@pulumi.input_type
class PolicyTargetTrackingConfigurationArgs:
    def __init__(__self__, *,
                 target_value: pulumi.Input[float],
                 customized_metric_specification: Optional[pulumi.Input['PolicyTargetTrackingConfigurationCustomizedMetricSpecificationArgs']] = None,
                 disable_scale_in: Optional[pulumi.Input[bool]] = None,
                 predefined_metric_specification: Optional[pulumi.Input['PolicyTargetTrackingConfigurationPredefinedMetricSpecificationArgs']] = None):
        """
        :param pulumi.Input[float] target_value: The target value for the metric.
        :param pulumi.Input['PolicyTargetTrackingConfigurationCustomizedMetricSpecificationArgs'] customized_metric_specification: A customized metric. Conflicts with `predefined_metric_specification`.
        :param pulumi.Input[bool] disable_scale_in: Indicates whether scale in by the target tracking policy is disabled.
        :param pulumi.Input['PolicyTargetTrackingConfigurationPredefinedMetricSpecificationArgs'] predefined_metric_specification: A predefined metric. Conflicts with `customized_metric_specification`.
        """
        pulumi.set(__self__, "target_value", target_value)
        if customized_metric_specification is not None:
            pulumi.set(__self__, "customized_metric_specification", customized_metric_specification)
        if disable_scale_in is not None:
            pulumi.set(__self__, "disable_scale_in", disable_scale_in)
        if predefined_metric_specification is not None:
            pulumi.set(__self__, "predefined_metric_specification", predefined_metric_specification)

    @property
    @pulumi.getter(name="targetValue")
    def target_value(self) -> pulumi.Input[float]:
        """
        The target value for the metric.
        """
        return pulumi.get(self, "target_value")

    @target_value.setter
    def target_value(self, value: pulumi.Input[float]):
        pulumi.set(self, "target_value", value)

    @property
    @pulumi.getter(name="customizedMetricSpecification")
    def customized_metric_specification(self) -> Optional[pulumi.Input['PolicyTargetTrackingConfigurationCustomizedMetricSpecificationArgs']]:
        """
        A customized metric. Conflicts with `predefined_metric_specification`.
        """
        return pulumi.get(self, "customized_metric_specification")

    @customized_metric_specification.setter
    def customized_metric_specification(self, value: Optional[pulumi.Input['PolicyTargetTrackingConfigurationCustomizedMetricSpecificationArgs']]):
        pulumi.set(self, "customized_metric_specification", value)

    @property
    @pulumi.getter(name="disableScaleIn")
    def disable_scale_in(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether scale in by the target tracking policy is disabled.
        """
        return pulumi.get(self, "disable_scale_in")

    @disable_scale_in.setter
    def disable_scale_in(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_scale_in", value)

    @property
    @pulumi.getter(name="predefinedMetricSpecification")
    def predefined_metric_specification(self) -> Optional[pulumi.Input['PolicyTargetTrackingConfigurationPredefinedMetricSpecificationArgs']]:
        """
        A predefined metric. Conflicts with `customized_metric_specification`.
        """
        return pulumi.get(self, "predefined_metric_specification")

    @predefined_metric_specification.setter
    def predefined_metric_specification(self, value: Optional[pulumi.Input['PolicyTargetTrackingConfigurationPredefinedMetricSpecificationArgs']]):
        pulumi.set(self, "predefined_metric_specification", value)


@pulumi.input_type
class PolicyTargetTrackingConfigurationCustomizedMetricSpecificationArgs:
    def __init__(__self__, *,
                 metric_name: pulumi.Input[str],
                 namespace: pulumi.Input[str],
                 statistic: pulumi.Input[str],
                 metric_dimensions: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricDimensionArgs']]]] = None,
                 unit: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] metric_name: The name of the metric.
        :param pulumi.Input[str] namespace: The namespace of the metric.
        :param pulumi.Input[str] statistic: The statistic of the metric.
        :param pulumi.Input[Sequence[pulumi.Input['PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricDimensionArgs']]] metric_dimensions: The dimensions of the metric.
        :param pulumi.Input[str] unit: The unit of the metric.
        """
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "statistic", statistic)
        if metric_dimensions is not None:
            pulumi.set(__self__, "metric_dimensions", metric_dimensions)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Input[str]:
        """
        The name of the metric.
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "metric_name", value)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[str]:
        """
        The namespace of the metric.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def statistic(self) -> pulumi.Input[str]:
        """
        The statistic of the metric.
        """
        return pulumi.get(self, "statistic")

    @statistic.setter
    def statistic(self, value: pulumi.Input[str]):
        pulumi.set(self, "statistic", value)

    @property
    @pulumi.getter(name="metricDimensions")
    def metric_dimensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricDimensionArgs']]]]:
        """
        The dimensions of the metric.
        """
        return pulumi.get(self, "metric_dimensions")

    @metric_dimensions.setter
    def metric_dimensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricDimensionArgs']]]]):
        pulumi.set(self, "metric_dimensions", value)

    @property
    @pulumi.getter
    def unit(self) -> Optional[pulumi.Input[str]]:
        """
        The unit of the metric.
        """
        return pulumi.get(self, "unit")

    @unit.setter
    def unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unit", value)


@pulumi.input_type
class PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricDimensionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] name: The name of the dimension.
        :param pulumi.Input[str] value: The value of the dimension.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the dimension.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value of the dimension.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class PolicyTargetTrackingConfigurationPredefinedMetricSpecificationArgs:
    def __init__(__self__, *,
                 predefined_metric_type: pulumi.Input[str],
                 resource_label: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] predefined_metric_type: Describes a scaling metric for a predictive scaling policy. Valid values are `ASGAverageCPUUtilization`, `ASGAverageNetworkIn`, `ASGAverageNetworkOut`, or `ALBRequestCountPerTarget`.
        :param pulumi.Input[str] resource_label: A label that uniquely identifies a specific Application Load Balancer target group from which to determine the request count served by your Auto Scaling group.
        """
        pulumi.set(__self__, "predefined_metric_type", predefined_metric_type)
        if resource_label is not None:
            pulumi.set(__self__, "resource_label", resource_label)

    @property
    @pulumi.getter(name="predefinedMetricType")
    def predefined_metric_type(self) -> pulumi.Input[str]:
        """
        Describes a scaling metric for a predictive scaling policy. Valid values are `ASGAverageCPUUtilization`, `ASGAverageNetworkIn`, `ASGAverageNetworkOut`, or `ALBRequestCountPerTarget`.
        """
        return pulumi.get(self, "predefined_metric_type")

    @predefined_metric_type.setter
    def predefined_metric_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "predefined_metric_type", value)

    @property
    @pulumi.getter(name="resourceLabel")
    def resource_label(self) -> Optional[pulumi.Input[str]]:
        """
        A label that uniquely identifies a specific Application Load Balancer target group from which to determine the request count served by your Auto Scaling group.
        """
        return pulumi.get(self, "resource_label")

    @resource_label.setter
    def resource_label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_label", value)


@pulumi.input_type
class TagTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 propagate_at_launch: pulumi.Input[bool],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] key: Tag name.
        :param pulumi.Input[bool] propagate_at_launch: Whether to propagate the tags to instances launched by the ASG.
        :param pulumi.Input[str] value: Tag value.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "propagate_at_launch", propagate_at_launch)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        Tag name.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="propagateAtLaunch")
    def propagate_at_launch(self) -> pulumi.Input[bool]:
        """
        Whether to propagate the tags to instances launched by the ASG.
        """
        return pulumi.get(self, "propagate_at_launch")

    @propagate_at_launch.setter
    def propagate_at_launch(self, value: pulumi.Input[bool]):
        pulumi.set(self, "propagate_at_launch", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Tag value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class GetAmiIdsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the filter. The valid values are: `auto-scaling-group`, `key`, `value`, and `propagate-at-launch`.
        :param Sequence[str] values: The value of the filter.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the filter. The valid values are: `auto-scaling-group`, `key`, `value`, and `propagate-at-launch`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The value of the filter.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


