# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'DataSourceDynamodbConfig',
    'DataSourceElasticsearchConfig',
    'DataSourceHttpConfig',
    'DataSourceLambdaConfig',
    'GraphQLApiAdditionalAuthenticationProvider',
    'GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfig',
    'GraphQLApiAdditionalAuthenticationProviderUserPoolConfig',
    'GraphQLApiLogConfig',
    'GraphQLApiOpenidConnectConfig',
    'GraphQLApiUserPoolConfig',
    'ResolverCachingConfig',
    'ResolverPipelineConfig',
]

@pulumi.output_type
class DataSourceDynamodbConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tableName":
            suggest = "table_name"
        elif key == "useCallerCredentials":
            suggest = "use_caller_credentials"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceDynamodbConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceDynamodbConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceDynamodbConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 table_name: str,
                 region: Optional[str] = None,
                 use_caller_credentials: Optional[bool] = None):
        """
        :param str table_name: Name of the DynamoDB table.
        :param str region: AWS region of Elasticsearch domain. Defaults to current region.
        :param bool use_caller_credentials: Set to `true` to use Amazon Cognito credentials with this data source.
        """
        pulumi.set(__self__, "table_name", table_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if use_caller_credentials is not None:
            pulumi.set(__self__, "use_caller_credentials", use_caller_credentials)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> str:
        """
        Name of the DynamoDB table.
        """
        return pulumi.get(self, "table_name")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        AWS region of Elasticsearch domain. Defaults to current region.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="useCallerCredentials")
    def use_caller_credentials(self) -> Optional[bool]:
        """
        Set to `true` to use Amazon Cognito credentials with this data source.
        """
        return pulumi.get(self, "use_caller_credentials")


@pulumi.output_type
class DataSourceElasticsearchConfig(dict):
    def __init__(__self__, *,
                 endpoint: str,
                 region: Optional[str] = None):
        """
        :param str endpoint: HTTP URL.
        :param str region: AWS region of Elasticsearch domain. Defaults to current region.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        HTTP URL.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        AWS region of Elasticsearch domain. Defaults to current region.
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class DataSourceHttpConfig(dict):
    def __init__(__self__, *,
                 endpoint: str):
        """
        :param str endpoint: HTTP URL.
        """
        pulumi.set(__self__, "endpoint", endpoint)

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        HTTP URL.
        """
        return pulumi.get(self, "endpoint")


@pulumi.output_type
class DataSourceLambdaConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "functionArn":
            suggest = "function_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceLambdaConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceLambdaConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceLambdaConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 function_arn: str):
        """
        :param str function_arn: The ARN for the Lambda function.
        """
        pulumi.set(__self__, "function_arn", function_arn)

    @property
    @pulumi.getter(name="functionArn")
    def function_arn(self) -> str:
        """
        The ARN for the Lambda function.
        """
        return pulumi.get(self, "function_arn")


@pulumi.output_type
class GraphQLApiAdditionalAuthenticationProvider(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authenticationType":
            suggest = "authentication_type"
        elif key == "openidConnectConfig":
            suggest = "openid_connect_config"
        elif key == "userPoolConfig":
            suggest = "user_pool_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GraphQLApiAdditionalAuthenticationProvider. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GraphQLApiAdditionalAuthenticationProvider.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GraphQLApiAdditionalAuthenticationProvider.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authentication_type: str,
                 openid_connect_config: Optional['outputs.GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfig'] = None,
                 user_pool_config: Optional['outputs.GraphQLApiAdditionalAuthenticationProviderUserPoolConfig'] = None):
        """
        :param str authentication_type: The authentication type. Valid values: `API_KEY`, `AWS_IAM`, `AMAZON_COGNITO_USER_POOLS`, `OPENID_CONNECT`
        :param 'GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfigArgs' openid_connect_config: Nested argument containing OpenID Connect configuration. Defined below.
        :param 'GraphQLApiAdditionalAuthenticationProviderUserPoolConfigArgs' user_pool_config: The Amazon Cognito User Pool configuration. Defined below.
        """
        pulumi.set(__self__, "authentication_type", authentication_type)
        if openid_connect_config is not None:
            pulumi.set(__self__, "openid_connect_config", openid_connect_config)
        if user_pool_config is not None:
            pulumi.set(__self__, "user_pool_config", user_pool_config)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> str:
        """
        The authentication type. Valid values: `API_KEY`, `AWS_IAM`, `AMAZON_COGNITO_USER_POOLS`, `OPENID_CONNECT`
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter(name="openidConnectConfig")
    def openid_connect_config(self) -> Optional['outputs.GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfig']:
        """
        Nested argument containing OpenID Connect configuration. Defined below.
        """
        return pulumi.get(self, "openid_connect_config")

    @property
    @pulumi.getter(name="userPoolConfig")
    def user_pool_config(self) -> Optional['outputs.GraphQLApiAdditionalAuthenticationProviderUserPoolConfig']:
        """
        The Amazon Cognito User Pool configuration. Defined below.
        """
        return pulumi.get(self, "user_pool_config")


@pulumi.output_type
class GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authTtl":
            suggest = "auth_ttl"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "iatTtl":
            suggest = "iat_ttl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 issuer: str,
                 auth_ttl: Optional[int] = None,
                 client_id: Optional[str] = None,
                 iat_ttl: Optional[int] = None):
        """
        :param str issuer: Issuer for the OpenID Connect configuration. The issuer returned by discovery MUST exactly match the value of iss in the ID Token.
        :param int auth_ttl: Number of milliseconds a token is valid after being authenticated.
        :param str client_id: Client identifier of the Relying party at the OpenID identity provider. This identifier is typically obtained when the Relying party is registered with the OpenID identity provider. You can specify a regular expression so the AWS AppSync can validate against multiple client identifiers at a time.
        :param int iat_ttl: Number of milliseconds a token is valid after being issued to a user.
        """
        pulumi.set(__self__, "issuer", issuer)
        if auth_ttl is not None:
            pulumi.set(__self__, "auth_ttl", auth_ttl)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if iat_ttl is not None:
            pulumi.set(__self__, "iat_ttl", iat_ttl)

    @property
    @pulumi.getter
    def issuer(self) -> str:
        """
        Issuer for the OpenID Connect configuration. The issuer returned by discovery MUST exactly match the value of iss in the ID Token.
        """
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="authTtl")
    def auth_ttl(self) -> Optional[int]:
        """
        Number of milliseconds a token is valid after being authenticated.
        """
        return pulumi.get(self, "auth_ttl")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        Client identifier of the Relying party at the OpenID identity provider. This identifier is typically obtained when the Relying party is registered with the OpenID identity provider. You can specify a regular expression so the AWS AppSync can validate against multiple client identifiers at a time.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="iatTtl")
    def iat_ttl(self) -> Optional[int]:
        """
        Number of milliseconds a token is valid after being issued to a user.
        """
        return pulumi.get(self, "iat_ttl")


@pulumi.output_type
class GraphQLApiAdditionalAuthenticationProviderUserPoolConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userPoolId":
            suggest = "user_pool_id"
        elif key == "appIdClientRegex":
            suggest = "app_id_client_regex"
        elif key == "awsRegion":
            suggest = "aws_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GraphQLApiAdditionalAuthenticationProviderUserPoolConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GraphQLApiAdditionalAuthenticationProviderUserPoolConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GraphQLApiAdditionalAuthenticationProviderUserPoolConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 user_pool_id: str,
                 app_id_client_regex: Optional[str] = None,
                 aws_region: Optional[str] = None):
        """
        :param str user_pool_id: The user pool ID.
        :param str app_id_client_regex: A regular expression for validating the incoming Amazon Cognito User Pool app client ID.
        :param str aws_region: The AWS region in which the user pool was created.
        """
        pulumi.set(__self__, "user_pool_id", user_pool_id)
        if app_id_client_regex is not None:
            pulumi.set(__self__, "app_id_client_regex", app_id_client_regex)
        if aws_region is not None:
            pulumi.set(__self__, "aws_region", aws_region)

    @property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> str:
        """
        The user pool ID.
        """
        return pulumi.get(self, "user_pool_id")

    @property
    @pulumi.getter(name="appIdClientRegex")
    def app_id_client_regex(self) -> Optional[str]:
        """
        A regular expression for validating the incoming Amazon Cognito User Pool app client ID.
        """
        return pulumi.get(self, "app_id_client_regex")

    @property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> Optional[str]:
        """
        The AWS region in which the user pool was created.
        """
        return pulumi.get(self, "aws_region")


@pulumi.output_type
class GraphQLApiLogConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudwatchLogsRoleArn":
            suggest = "cloudwatch_logs_role_arn"
        elif key == "fieldLogLevel":
            suggest = "field_log_level"
        elif key == "excludeVerboseContent":
            suggest = "exclude_verbose_content"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GraphQLApiLogConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GraphQLApiLogConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GraphQLApiLogConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloudwatch_logs_role_arn: str,
                 field_log_level: str,
                 exclude_verbose_content: Optional[bool] = None):
        """
        :param str cloudwatch_logs_role_arn: Amazon Resource Name of the service role that AWS AppSync will assume to publish to Amazon CloudWatch logs in your account.
        :param str field_log_level: Field logging level. Valid values: `ALL`, `ERROR`, `NONE`.
        :param bool exclude_verbose_content: Set to TRUE to exclude sections that contain information such as headers, context, and evaluated mapping templates, regardless of logging  level. Valid values: `true`, `false`. Default value: `false`
        """
        pulumi.set(__self__, "cloudwatch_logs_role_arn", cloudwatch_logs_role_arn)
        pulumi.set(__self__, "field_log_level", field_log_level)
        if exclude_verbose_content is not None:
            pulumi.set(__self__, "exclude_verbose_content", exclude_verbose_content)

    @property
    @pulumi.getter(name="cloudwatchLogsRoleArn")
    def cloudwatch_logs_role_arn(self) -> str:
        """
        Amazon Resource Name of the service role that AWS AppSync will assume to publish to Amazon CloudWatch logs in your account.
        """
        return pulumi.get(self, "cloudwatch_logs_role_arn")

    @property
    @pulumi.getter(name="fieldLogLevel")
    def field_log_level(self) -> str:
        """
        Field logging level. Valid values: `ALL`, `ERROR`, `NONE`.
        """
        return pulumi.get(self, "field_log_level")

    @property
    @pulumi.getter(name="excludeVerboseContent")
    def exclude_verbose_content(self) -> Optional[bool]:
        """
        Set to TRUE to exclude sections that contain information such as headers, context, and evaluated mapping templates, regardless of logging  level. Valid values: `true`, `false`. Default value: `false`
        """
        return pulumi.get(self, "exclude_verbose_content")


@pulumi.output_type
class GraphQLApiOpenidConnectConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authTtl":
            suggest = "auth_ttl"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "iatTtl":
            suggest = "iat_ttl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GraphQLApiOpenidConnectConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GraphQLApiOpenidConnectConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GraphQLApiOpenidConnectConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 issuer: str,
                 auth_ttl: Optional[int] = None,
                 client_id: Optional[str] = None,
                 iat_ttl: Optional[int] = None):
        """
        :param str issuer: Issuer for the OpenID Connect configuration. The issuer returned by discovery MUST exactly match the value of iss in the ID Token.
        :param int auth_ttl: Number of milliseconds a token is valid after being authenticated.
        :param str client_id: Client identifier of the Relying party at the OpenID identity provider. This identifier is typically obtained when the Relying party is registered with the OpenID identity provider. You can specify a regular expression so the AWS AppSync can validate against multiple client identifiers at a time.
        :param int iat_ttl: Number of milliseconds a token is valid after being issued to a user.
        """
        pulumi.set(__self__, "issuer", issuer)
        if auth_ttl is not None:
            pulumi.set(__self__, "auth_ttl", auth_ttl)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if iat_ttl is not None:
            pulumi.set(__self__, "iat_ttl", iat_ttl)

    @property
    @pulumi.getter
    def issuer(self) -> str:
        """
        Issuer for the OpenID Connect configuration. The issuer returned by discovery MUST exactly match the value of iss in the ID Token.
        """
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="authTtl")
    def auth_ttl(self) -> Optional[int]:
        """
        Number of milliseconds a token is valid after being authenticated.
        """
        return pulumi.get(self, "auth_ttl")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        Client identifier of the Relying party at the OpenID identity provider. This identifier is typically obtained when the Relying party is registered with the OpenID identity provider. You can specify a regular expression so the AWS AppSync can validate against multiple client identifiers at a time.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="iatTtl")
    def iat_ttl(self) -> Optional[int]:
        """
        Number of milliseconds a token is valid after being issued to a user.
        """
        return pulumi.get(self, "iat_ttl")


@pulumi.output_type
class GraphQLApiUserPoolConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultAction":
            suggest = "default_action"
        elif key == "userPoolId":
            suggest = "user_pool_id"
        elif key == "appIdClientRegex":
            suggest = "app_id_client_regex"
        elif key == "awsRegion":
            suggest = "aws_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GraphQLApiUserPoolConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GraphQLApiUserPoolConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GraphQLApiUserPoolConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_action: str,
                 user_pool_id: str,
                 app_id_client_regex: Optional[str] = None,
                 aws_region: Optional[str] = None):
        """
        :param str default_action: The action that you want your GraphQL API to take when a request that uses Amazon Cognito User Pool authentication doesn't match the Amazon Cognito User Pool configuration. Valid: `ALLOW` and `DENY`
        :param str user_pool_id: The user pool ID.
        :param str app_id_client_regex: A regular expression for validating the incoming Amazon Cognito User Pool app client ID.
        :param str aws_region: The AWS region in which the user pool was created.
        """
        pulumi.set(__self__, "default_action", default_action)
        pulumi.set(__self__, "user_pool_id", user_pool_id)
        if app_id_client_regex is not None:
            pulumi.set(__self__, "app_id_client_regex", app_id_client_regex)
        if aws_region is not None:
            pulumi.set(__self__, "aws_region", aws_region)

    @property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> str:
        """
        The action that you want your GraphQL API to take when a request that uses Amazon Cognito User Pool authentication doesn't match the Amazon Cognito User Pool configuration. Valid: `ALLOW` and `DENY`
        """
        return pulumi.get(self, "default_action")

    @property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> str:
        """
        The user pool ID.
        """
        return pulumi.get(self, "user_pool_id")

    @property
    @pulumi.getter(name="appIdClientRegex")
    def app_id_client_regex(self) -> Optional[str]:
        """
        A regular expression for validating the incoming Amazon Cognito User Pool app client ID.
        """
        return pulumi.get(self, "app_id_client_regex")

    @property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> Optional[str]:
        """
        The AWS region in which the user pool was created.
        """
        return pulumi.get(self, "aws_region")


@pulumi.output_type
class ResolverCachingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cachingKeys":
            suggest = "caching_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResolverCachingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResolverCachingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResolverCachingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 caching_keys: Optional[Sequence[str]] = None,
                 ttl: Optional[int] = None):
        """
        :param Sequence[str] caching_keys: The list of caching key.
        :param int ttl: The TTL in seconds.
        """
        if caching_keys is not None:
            pulumi.set(__self__, "caching_keys", caching_keys)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter(name="cachingKeys")
    def caching_keys(self) -> Optional[Sequence[str]]:
        """
        The list of caching key.
        """
        return pulumi.get(self, "caching_keys")

    @property
    @pulumi.getter
    def ttl(self) -> Optional[int]:
        """
        The TTL in seconds.
        """
        return pulumi.get(self, "ttl")


@pulumi.output_type
class ResolverPipelineConfig(dict):
    def __init__(__self__, *,
                 functions: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] functions: The list of Function ID.
        """
        if functions is not None:
            pulumi.set(__self__, "functions", functions)

    @property
    @pulumi.getter
    def functions(self) -> Optional[Sequence[str]]:
        """
        The list of Function ID.
        """
        return pulumi.get(self, "functions")


