# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['StackArgs', 'Stack']

@pulumi.input_type
class StackArgs:
    def __init__(__self__, *,
                 access_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['StackAccessEndpointArgs']]]] = None,
                 application_settings: Optional[pulumi.Input['StackApplicationSettingsArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 embed_host_domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 feedback_url: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 redirect_url: Optional[pulumi.Input[str]] = None,
                 storage_connectors: Optional[pulumi.Input[Sequence[pulumi.Input['StackStorageConnectorArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 user_settings: Optional[pulumi.Input[Sequence[pulumi.Input['StackUserSettingArgs']]]] = None):
        """
        The set of arguments for constructing a Stack resource.
        :param pulumi.Input['StackApplicationSettingsArgs'] application_settings: Settings for application settings persistence.
        :param pulumi.Input[str] description: Description for the AppStream stack.
        :param pulumi.Input[str] display_name: Stack name to display.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] embed_host_domains: Domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions.
        :param pulumi.Input[str] feedback_url: URL that users are redirected to after they click the Send Feedback link. If no URL is specified, no Send Feedback link is displayed. .
        :param pulumi.Input[str] name: Unique name for the AppStream stack.
        :param pulumi.Input[str] redirect_url: URL that users are redirected to after their streaming session ends.
        :param pulumi.Input[Sequence[pulumi.Input['StackStorageConnectorArgs']]] storage_connectors: Configuration block for the storage connectors to enable. See below.
        :param pulumi.Input[Sequence[pulumi.Input['StackUserSettingArgs']]] user_settings: Configuration block for the actions that are enabled or disabled for users during their streaming sessions. By default, these actions are enabled. See below.
        """
        if access_endpoints is not None:
            pulumi.set(__self__, "access_endpoints", access_endpoints)
        if application_settings is not None:
            pulumi.set(__self__, "application_settings", application_settings)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if embed_host_domains is not None:
            pulumi.set(__self__, "embed_host_domains", embed_host_domains)
        if feedback_url is not None:
            pulumi.set(__self__, "feedback_url", feedback_url)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if redirect_url is not None:
            pulumi.set(__self__, "redirect_url", redirect_url)
        if storage_connectors is not None:
            pulumi.set(__self__, "storage_connectors", storage_connectors)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_settings is not None:
            pulumi.set(__self__, "user_settings", user_settings)

    @property
    @pulumi.getter(name="accessEndpoints")
    def access_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StackAccessEndpointArgs']]]]:
        return pulumi.get(self, "access_endpoints")

    @access_endpoints.setter
    def access_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StackAccessEndpointArgs']]]]):
        pulumi.set(self, "access_endpoints", value)

    @property
    @pulumi.getter(name="applicationSettings")
    def application_settings(self) -> Optional[pulumi.Input['StackApplicationSettingsArgs']]:
        """
        Settings for application settings persistence.
        """
        return pulumi.get(self, "application_settings")

    @application_settings.setter
    def application_settings(self, value: Optional[pulumi.Input['StackApplicationSettingsArgs']]):
        pulumi.set(self, "application_settings", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description for the AppStream stack.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Stack name to display.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="embedHostDomains")
    def embed_host_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions.
        """
        return pulumi.get(self, "embed_host_domains")

    @embed_host_domains.setter
    def embed_host_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "embed_host_domains", value)

    @property
    @pulumi.getter(name="feedbackUrl")
    def feedback_url(self) -> Optional[pulumi.Input[str]]:
        """
        URL that users are redirected to after they click the Send Feedback link. If no URL is specified, no Send Feedback link is displayed. .
        """
        return pulumi.get(self, "feedback_url")

    @feedback_url.setter
    def feedback_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "feedback_url", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name for the AppStream stack.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="redirectUrl")
    def redirect_url(self) -> Optional[pulumi.Input[str]]:
        """
        URL that users are redirected to after their streaming session ends.
        """
        return pulumi.get(self, "redirect_url")

    @redirect_url.setter
    def redirect_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "redirect_url", value)

    @property
    @pulumi.getter(name="storageConnectors")
    def storage_connectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StackStorageConnectorArgs']]]]:
        """
        Configuration block for the storage connectors to enable. See below.
        """
        return pulumi.get(self, "storage_connectors")

    @storage_connectors.setter
    def storage_connectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StackStorageConnectorArgs']]]]):
        pulumi.set(self, "storage_connectors", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="userSettings")
    def user_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StackUserSettingArgs']]]]:
        """
        Configuration block for the actions that are enabled or disabled for users during their streaming sessions. By default, these actions are enabled. See below.
        """
        return pulumi.get(self, "user_settings")

    @user_settings.setter
    def user_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StackUserSettingArgs']]]]):
        pulumi.set(self, "user_settings", value)


@pulumi.input_type
class _StackState:
    def __init__(__self__, *,
                 access_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['StackAccessEndpointArgs']]]] = None,
                 application_settings: Optional[pulumi.Input['StackApplicationSettingsArgs']] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 created_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 embed_host_domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 feedback_url: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 redirect_url: Optional[pulumi.Input[str]] = None,
                 storage_connectors: Optional[pulumi.Input[Sequence[pulumi.Input['StackStorageConnectorArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 user_settings: Optional[pulumi.Input[Sequence[pulumi.Input['StackUserSettingArgs']]]] = None):
        """
        Input properties used for looking up and filtering Stack resources.
        :param pulumi.Input['StackApplicationSettingsArgs'] application_settings: Settings for application settings persistence.
        :param pulumi.Input[str] arn: ARN of the appstream stack.
        :param pulumi.Input[str] created_time: Date and time, in UTC and extended RFC 3339 format, when the stack was created.
        :param pulumi.Input[str] description: Description for the AppStream stack.
        :param pulumi.Input[str] display_name: Stack name to display.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] embed_host_domains: Domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions.
        :param pulumi.Input[str] feedback_url: URL that users are redirected to after they click the Send Feedback link. If no URL is specified, no Send Feedback link is displayed. .
        :param pulumi.Input[str] name: Unique name for the AppStream stack.
        :param pulumi.Input[str] redirect_url: URL that users are redirected to after their streaming session ends.
        :param pulumi.Input[Sequence[pulumi.Input['StackStorageConnectorArgs']]] storage_connectors: Configuration block for the storage connectors to enable. See below.
        :param pulumi.Input[Sequence[pulumi.Input['StackUserSettingArgs']]] user_settings: Configuration block for the actions that are enabled or disabled for users during their streaming sessions. By default, these actions are enabled. See below.
        """
        if access_endpoints is not None:
            pulumi.set(__self__, "access_endpoints", access_endpoints)
        if application_settings is not None:
            pulumi.set(__self__, "application_settings", application_settings)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if created_time is not None:
            pulumi.set(__self__, "created_time", created_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if embed_host_domains is not None:
            pulumi.set(__self__, "embed_host_domains", embed_host_domains)
        if feedback_url is not None:
            pulumi.set(__self__, "feedback_url", feedback_url)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if redirect_url is not None:
            pulumi.set(__self__, "redirect_url", redirect_url)
        if storage_connectors is not None:
            pulumi.set(__self__, "storage_connectors", storage_connectors)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if user_settings is not None:
            pulumi.set(__self__, "user_settings", user_settings)

    @property
    @pulumi.getter(name="accessEndpoints")
    def access_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StackAccessEndpointArgs']]]]:
        return pulumi.get(self, "access_endpoints")

    @access_endpoints.setter
    def access_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StackAccessEndpointArgs']]]]):
        pulumi.set(self, "access_endpoints", value)

    @property
    @pulumi.getter(name="applicationSettings")
    def application_settings(self) -> Optional[pulumi.Input['StackApplicationSettingsArgs']]:
        """
        Settings for application settings persistence.
        """
        return pulumi.get(self, "application_settings")

    @application_settings.setter
    def application_settings(self, value: Optional[pulumi.Input['StackApplicationSettingsArgs']]):
        pulumi.set(self, "application_settings", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the appstream stack.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[pulumi.Input[str]]:
        """
        Date and time, in UTC and extended RFC 3339 format, when the stack was created.
        """
        return pulumi.get(self, "created_time")

    @created_time.setter
    def created_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description for the AppStream stack.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Stack name to display.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="embedHostDomains")
    def embed_host_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions.
        """
        return pulumi.get(self, "embed_host_domains")

    @embed_host_domains.setter
    def embed_host_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "embed_host_domains", value)

    @property
    @pulumi.getter(name="feedbackUrl")
    def feedback_url(self) -> Optional[pulumi.Input[str]]:
        """
        URL that users are redirected to after they click the Send Feedback link. If no URL is specified, no Send Feedback link is displayed. .
        """
        return pulumi.get(self, "feedback_url")

    @feedback_url.setter
    def feedback_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "feedback_url", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name for the AppStream stack.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="redirectUrl")
    def redirect_url(self) -> Optional[pulumi.Input[str]]:
        """
        URL that users are redirected to after their streaming session ends.
        """
        return pulumi.get(self, "redirect_url")

    @redirect_url.setter
    def redirect_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "redirect_url", value)

    @property
    @pulumi.getter(name="storageConnectors")
    def storage_connectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StackStorageConnectorArgs']]]]:
        """
        Configuration block for the storage connectors to enable. See below.
        """
        return pulumi.get(self, "storage_connectors")

    @storage_connectors.setter
    def storage_connectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StackStorageConnectorArgs']]]]):
        pulumi.set(self, "storage_connectors", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="userSettings")
    def user_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StackUserSettingArgs']]]]:
        """
        Configuration block for the actions that are enabled or disabled for users during their streaming sessions. By default, these actions are enabled. See below.
        """
        return pulumi.get(self, "user_settings")

    @user_settings.setter
    def user_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StackUserSettingArgs']]]]):
        pulumi.set(self, "user_settings", value)


class Stack(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['StackAccessEndpointArgs']]]]] = None,
                 application_settings: Optional[pulumi.Input[pulumi.InputType['StackApplicationSettingsArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 embed_host_domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 feedback_url: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 redirect_url: Optional[pulumi.Input[str]] = None,
                 storage_connectors: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['StackStorageConnectorArgs']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 user_settings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['StackUserSettingArgs']]]]] = None,
                 __props__=None):
        """
        Provides an AppStream stack.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.appstream.Stack("example",
            application_settings=aws.appstream.StackApplicationSettingsArgs(
                enabled=True,
                settings_group="SettingsGroup",
            ),
            description="stack description",
            display_name="stack display name",
            feedback_url="http://your-domain/feedback",
            redirect_url="http://your-domain/redirect",
            storage_connectors=[aws.appstream.StackStorageConnectorArgs(
                connector_type="HOMEFOLDERS",
            )],
            tags={
                "TagName": "TagValue",
            },
            user_settings=[
                aws.appstream.StackUserSettingArgs(
                    action="CLIPBOARD_COPY_FROM_LOCAL_DEVICE",
                    permission="ENABLED",
                ),
                aws.appstream.StackUserSettingArgs(
                    action="CLIPBOARD_COPY_TO_LOCAL_DEVICE",
                    permission="ENABLED",
                ),
                aws.appstream.StackUserSettingArgs(
                    action="FILE_UPLOAD",
                    permission="ENABLED",
                ),
                aws.appstream.StackUserSettingArgs(
                    action="FILE_DOWNLOAD",
                    permission="ENABLED",
                ),
            ])
        ```

        ## Import

        `aws_appstream_stack` can be imported using the id, e.g.,

        ```sh
         $ pulumi import aws:appstream/stack:Stack example stackID
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['StackApplicationSettingsArgs']] application_settings: Settings for application settings persistence.
        :param pulumi.Input[str] description: Description for the AppStream stack.
        :param pulumi.Input[str] display_name: Stack name to display.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] embed_host_domains: Domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions.
        :param pulumi.Input[str] feedback_url: URL that users are redirected to after they click the Send Feedback link. If no URL is specified, no Send Feedback link is displayed. .
        :param pulumi.Input[str] name: Unique name for the AppStream stack.
        :param pulumi.Input[str] redirect_url: URL that users are redirected to after their streaming session ends.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['StackStorageConnectorArgs']]]] storage_connectors: Configuration block for the storage connectors to enable. See below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['StackUserSettingArgs']]]] user_settings: Configuration block for the actions that are enabled or disabled for users during their streaming sessions. By default, these actions are enabled. See below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[StackArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an AppStream stack.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.appstream.Stack("example",
            application_settings=aws.appstream.StackApplicationSettingsArgs(
                enabled=True,
                settings_group="SettingsGroup",
            ),
            description="stack description",
            display_name="stack display name",
            feedback_url="http://your-domain/feedback",
            redirect_url="http://your-domain/redirect",
            storage_connectors=[aws.appstream.StackStorageConnectorArgs(
                connector_type="HOMEFOLDERS",
            )],
            tags={
                "TagName": "TagValue",
            },
            user_settings=[
                aws.appstream.StackUserSettingArgs(
                    action="CLIPBOARD_COPY_FROM_LOCAL_DEVICE",
                    permission="ENABLED",
                ),
                aws.appstream.StackUserSettingArgs(
                    action="CLIPBOARD_COPY_TO_LOCAL_DEVICE",
                    permission="ENABLED",
                ),
                aws.appstream.StackUserSettingArgs(
                    action="FILE_UPLOAD",
                    permission="ENABLED",
                ),
                aws.appstream.StackUserSettingArgs(
                    action="FILE_DOWNLOAD",
                    permission="ENABLED",
                ),
            ])
        ```

        ## Import

        `aws_appstream_stack` can be imported using the id, e.g.,

        ```sh
         $ pulumi import aws:appstream/stack:Stack example stackID
        ```

        :param str resource_name: The name of the resource.
        :param StackArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StackArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['StackAccessEndpointArgs']]]]] = None,
                 application_settings: Optional[pulumi.Input[pulumi.InputType['StackApplicationSettingsArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 embed_host_domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 feedback_url: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 redirect_url: Optional[pulumi.Input[str]] = None,
                 storage_connectors: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['StackStorageConnectorArgs']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 user_settings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['StackUserSettingArgs']]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StackArgs.__new__(StackArgs)

            __props__.__dict__["access_endpoints"] = access_endpoints
            __props__.__dict__["application_settings"] = application_settings
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["embed_host_domains"] = embed_host_domains
            __props__.__dict__["feedback_url"] = feedback_url
            __props__.__dict__["name"] = name
            __props__.__dict__["redirect_url"] = redirect_url
            __props__.__dict__["storage_connectors"] = storage_connectors
            __props__.__dict__["tags"] = tags
            __props__.__dict__["user_settings"] = user_settings
            __props__.__dict__["arn"] = None
            __props__.__dict__["created_time"] = None
            __props__.__dict__["tags_all"] = None
        super(Stack, __self__).__init__(
            'aws:appstream/stack:Stack',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['StackAccessEndpointArgs']]]]] = None,
            application_settings: Optional[pulumi.Input[pulumi.InputType['StackApplicationSettingsArgs']]] = None,
            arn: Optional[pulumi.Input[str]] = None,
            created_time: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            embed_host_domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            feedback_url: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            redirect_url: Optional[pulumi.Input[str]] = None,
            storage_connectors: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['StackStorageConnectorArgs']]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            user_settings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['StackUserSettingArgs']]]]] = None) -> 'Stack':
        """
        Get an existing Stack resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['StackApplicationSettingsArgs']] application_settings: Settings for application settings persistence.
        :param pulumi.Input[str] arn: ARN of the appstream stack.
        :param pulumi.Input[str] created_time: Date and time, in UTC and extended RFC 3339 format, when the stack was created.
        :param pulumi.Input[str] description: Description for the AppStream stack.
        :param pulumi.Input[str] display_name: Stack name to display.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] embed_host_domains: Domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions.
        :param pulumi.Input[str] feedback_url: URL that users are redirected to after they click the Send Feedback link. If no URL is specified, no Send Feedback link is displayed. .
        :param pulumi.Input[str] name: Unique name for the AppStream stack.
        :param pulumi.Input[str] redirect_url: URL that users are redirected to after their streaming session ends.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['StackStorageConnectorArgs']]]] storage_connectors: Configuration block for the storage connectors to enable. See below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['StackUserSettingArgs']]]] user_settings: Configuration block for the actions that are enabled or disabled for users during their streaming sessions. By default, these actions are enabled. See below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StackState.__new__(_StackState)

        __props__.__dict__["access_endpoints"] = access_endpoints
        __props__.__dict__["application_settings"] = application_settings
        __props__.__dict__["arn"] = arn
        __props__.__dict__["created_time"] = created_time
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["embed_host_domains"] = embed_host_domains
        __props__.__dict__["feedback_url"] = feedback_url
        __props__.__dict__["name"] = name
        __props__.__dict__["redirect_url"] = redirect_url
        __props__.__dict__["storage_connectors"] = storage_connectors
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["user_settings"] = user_settings
        return Stack(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessEndpoints")
    def access_endpoints(self) -> pulumi.Output[Sequence['outputs.StackAccessEndpoint']]:
        return pulumi.get(self, "access_endpoints")

    @property
    @pulumi.getter(name="applicationSettings")
    def application_settings(self) -> pulumi.Output['outputs.StackApplicationSettings']:
        """
        Settings for application settings persistence.
        """
        return pulumi.get(self, "application_settings")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        ARN of the appstream stack.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> pulumi.Output[str]:
        """
        Date and time, in UTC and extended RFC 3339 format, when the stack was created.
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Description for the AppStream stack.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        Stack name to display.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="embedHostDomains")
    def embed_host_domains(self) -> pulumi.Output[Sequence[str]]:
        """
        Domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions.
        """
        return pulumi.get(self, "embed_host_domains")

    @property
    @pulumi.getter(name="feedbackUrl")
    def feedback_url(self) -> pulumi.Output[str]:
        """
        URL that users are redirected to after they click the Send Feedback link. If no URL is specified, no Send Feedback link is displayed. .
        """
        return pulumi.get(self, "feedback_url")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Unique name for the AppStream stack.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="redirectUrl")
    def redirect_url(self) -> pulumi.Output[str]:
        """
        URL that users are redirected to after their streaming session ends.
        """
        return pulumi.get(self, "redirect_url")

    @property
    @pulumi.getter(name="storageConnectors")
    def storage_connectors(self) -> pulumi.Output[Sequence['outputs.StackStorageConnector']]:
        """
        Configuration block for the storage connectors to enable. See below.
        """
        return pulumi.get(self, "storage_connectors")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="userSettings")
    def user_settings(self) -> pulumi.Output[Sequence['outputs.StackUserSetting']]:
        """
        Configuration block for the actions that are enabled or disabled for users during their streaming sessions. By default, these actions are enabled. See below.
        """
        return pulumi.get(self, "user_settings")

