# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'ConfigurationProfileValidator',
    'EnvironmentMonitor',
]

@pulumi.output_type
class ConfigurationProfileValidator(dict):
    def __init__(__self__, *,
                 type: str,
                 content: Optional[str] = None):
        """
        :param str type: The type of validator. Valid values: `JSON_SCHEMA` and `LAMBDA`.
        :param str content: Either the JSON Schema content or the Amazon Resource Name (ARN) of an AWS Lambda function.
        """
        pulumi.set(__self__, "type", type)
        if content is not None:
            pulumi.set(__self__, "content", content)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of validator. Valid values: `JSON_SCHEMA` and `LAMBDA`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def content(self) -> Optional[str]:
        """
        Either the JSON Schema content or the Amazon Resource Name (ARN) of an AWS Lambda function.
        """
        return pulumi.get(self, "content")


@pulumi.output_type
class EnvironmentMonitor(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alarmArn":
            suggest = "alarm_arn"
        elif key == "alarmRoleArn":
            suggest = "alarm_role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentMonitor. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentMonitor.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentMonitor.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alarm_arn: str,
                 alarm_role_arn: Optional[str] = None):
        """
        :param str alarm_arn: ARN of the Amazon CloudWatch alarm.
        :param str alarm_role_arn: ARN of an IAM role for AWS AppConfig to monitor `alarm_arn`.
        """
        pulumi.set(__self__, "alarm_arn", alarm_arn)
        if alarm_role_arn is not None:
            pulumi.set(__self__, "alarm_role_arn", alarm_role_arn)

    @property
    @pulumi.getter(name="alarmArn")
    def alarm_arn(self) -> str:
        """
        ARN of the Amazon CloudWatch alarm.
        """
        return pulumi.get(self, "alarm_arn")

    @property
    @pulumi.getter(name="alarmRoleArn")
    def alarm_role_arn(self) -> Optional[str]:
        """
        ARN of an IAM role for AWS AppConfig to monitor `alarm_arn`.
        """
        return pulumi.get(self, "alarm_role_arn")


