# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AppArgs', 'App']

@pulumi.input_type
class AppArgs:
    def __init__(__self__, *,
                 access_token: Optional[pulumi.Input[str]] = None,
                 auto_branch_creation_config: Optional[pulumi.Input['AppAutoBranchCreationConfigArgs']] = None,
                 auto_branch_creation_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 basic_auth_credentials: Optional[pulumi.Input[str]] = None,
                 build_spec: Optional[pulumi.Input[str]] = None,
                 custom_rules: Optional[pulumi.Input[Sequence[pulumi.Input['AppCustomRuleArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_auto_branch_creation: Optional[pulumi.Input[bool]] = None,
                 enable_basic_auth: Optional[pulumi.Input[bool]] = None,
                 enable_branch_auto_build: Optional[pulumi.Input[bool]] = None,
                 enable_branch_auto_deletion: Optional[pulumi.Input[bool]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 iam_service_role_arn: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 oauth_token: Optional[pulumi.Input[str]] = None,
                 platform: Optional[pulumi.Input[str]] = None,
                 repository: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a App resource.
        :param pulumi.Input[str] access_token: The personal access token for a third-party source control system for an Amplify app. The personal access token is used to create a webhook and a read-only deploy key. The token is not stored.
        :param pulumi.Input['AppAutoBranchCreationConfigArgs'] auto_branch_creation_config: The automated branch creation configuration for an Amplify app. An `auto_branch_creation_config` block is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] auto_branch_creation_patterns: The automated branch creation glob patterns for an Amplify app.
        :param pulumi.Input[str] basic_auth_credentials: The credentials for basic authorization for an Amplify app.
        :param pulumi.Input[str] build_spec: The [build specification](https://docs.aws.amazon.com/amplify/latest/userguide/build-settings.html) (build spec) for an Amplify app.
        :param pulumi.Input[Sequence[pulumi.Input['AppCustomRuleArgs']]] custom_rules: The custom rewrite and redirect rules for an Amplify app. A `custom_rule` block is documented below.
        :param pulumi.Input[str] description: The description for an Amplify app.
        :param pulumi.Input[bool] enable_auto_branch_creation: Enables automated branch creation for an Amplify app.
        :param pulumi.Input[bool] enable_basic_auth: Enables basic authorization for an Amplify app. This will apply to all branches that are part of this app.
        :param pulumi.Input[bool] enable_branch_auto_build: Enables auto-building of branches for the Amplify App.
        :param pulumi.Input[bool] enable_branch_auto_deletion: Automatically disconnects a branch in the Amplify Console when you delete a branch from your Git repository.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] environment_variables: The environment variables map for an Amplify app.
        :param pulumi.Input[str] iam_service_role_arn: The AWS Identity and Access Management (IAM) service role for an Amplify app.
        :param pulumi.Input[str] name: The name for an Amplify app.
        :param pulumi.Input[str] oauth_token: The OAuth token for a third-party source control system for an Amplify app. The OAuth token is used to create a webhook and a read-only deploy key. The OAuth token is not stored.
        :param pulumi.Input[str] platform: The platform or framework for an Amplify app. Valid values: `WEB`.
        :param pulumi.Input[str] repository: The repository for an Amplify app.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        if access_token is not None:
            pulumi.set(__self__, "access_token", access_token)
        if auto_branch_creation_config is not None:
            pulumi.set(__self__, "auto_branch_creation_config", auto_branch_creation_config)
        if auto_branch_creation_patterns is not None:
            pulumi.set(__self__, "auto_branch_creation_patterns", auto_branch_creation_patterns)
        if basic_auth_credentials is not None:
            pulumi.set(__self__, "basic_auth_credentials", basic_auth_credentials)
        if build_spec is not None:
            pulumi.set(__self__, "build_spec", build_spec)
        if custom_rules is not None:
            pulumi.set(__self__, "custom_rules", custom_rules)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_auto_branch_creation is not None:
            pulumi.set(__self__, "enable_auto_branch_creation", enable_auto_branch_creation)
        if enable_basic_auth is not None:
            pulumi.set(__self__, "enable_basic_auth", enable_basic_auth)
        if enable_branch_auto_build is not None:
            pulumi.set(__self__, "enable_branch_auto_build", enable_branch_auto_build)
        if enable_branch_auto_deletion is not None:
            pulumi.set(__self__, "enable_branch_auto_deletion", enable_branch_auto_deletion)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if iam_service_role_arn is not None:
            pulumi.set(__self__, "iam_service_role_arn", iam_service_role_arn)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oauth_token is not None:
            pulumi.set(__self__, "oauth_token", oauth_token)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> Optional[pulumi.Input[str]]:
        """
        The personal access token for a third-party source control system for an Amplify app. The personal access token is used to create a webhook and a read-only deploy key. The token is not stored.
        """
        return pulumi.get(self, "access_token")

    @access_token.setter
    def access_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_token", value)

    @property
    @pulumi.getter(name="autoBranchCreationConfig")
    def auto_branch_creation_config(self) -> Optional[pulumi.Input['AppAutoBranchCreationConfigArgs']]:
        """
        The automated branch creation configuration for an Amplify app. An `auto_branch_creation_config` block is documented below.
        """
        return pulumi.get(self, "auto_branch_creation_config")

    @auto_branch_creation_config.setter
    def auto_branch_creation_config(self, value: Optional[pulumi.Input['AppAutoBranchCreationConfigArgs']]):
        pulumi.set(self, "auto_branch_creation_config", value)

    @property
    @pulumi.getter(name="autoBranchCreationPatterns")
    def auto_branch_creation_patterns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The automated branch creation glob patterns for an Amplify app.
        """
        return pulumi.get(self, "auto_branch_creation_patterns")

    @auto_branch_creation_patterns.setter
    def auto_branch_creation_patterns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "auto_branch_creation_patterns", value)

    @property
    @pulumi.getter(name="basicAuthCredentials")
    def basic_auth_credentials(self) -> Optional[pulumi.Input[str]]:
        """
        The credentials for basic authorization for an Amplify app.
        """
        return pulumi.get(self, "basic_auth_credentials")

    @basic_auth_credentials.setter
    def basic_auth_credentials(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "basic_auth_credentials", value)

    @property
    @pulumi.getter(name="buildSpec")
    def build_spec(self) -> Optional[pulumi.Input[str]]:
        """
        The [build specification](https://docs.aws.amazon.com/amplify/latest/userguide/build-settings.html) (build spec) for an Amplify app.
        """
        return pulumi.get(self, "build_spec")

    @build_spec.setter
    def build_spec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "build_spec", value)

    @property
    @pulumi.getter(name="customRules")
    def custom_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppCustomRuleArgs']]]]:
        """
        The custom rewrite and redirect rules for an Amplify app. A `custom_rule` block is documented below.
        """
        return pulumi.get(self, "custom_rules")

    @custom_rules.setter
    def custom_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppCustomRuleArgs']]]]):
        pulumi.set(self, "custom_rules", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description for an Amplify app.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enableAutoBranchCreation")
    def enable_auto_branch_creation(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables automated branch creation for an Amplify app.
        """
        return pulumi.get(self, "enable_auto_branch_creation")

    @enable_auto_branch_creation.setter
    def enable_auto_branch_creation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_auto_branch_creation", value)

    @property
    @pulumi.getter(name="enableBasicAuth")
    def enable_basic_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables basic authorization for an Amplify app. This will apply to all branches that are part of this app.
        """
        return pulumi.get(self, "enable_basic_auth")

    @enable_basic_auth.setter
    def enable_basic_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_basic_auth", value)

    @property
    @pulumi.getter(name="enableBranchAutoBuild")
    def enable_branch_auto_build(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables auto-building of branches for the Amplify App.
        """
        return pulumi.get(self, "enable_branch_auto_build")

    @enable_branch_auto_build.setter
    def enable_branch_auto_build(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_branch_auto_build", value)

    @property
    @pulumi.getter(name="enableBranchAutoDeletion")
    def enable_branch_auto_deletion(self) -> Optional[pulumi.Input[bool]]:
        """
        Automatically disconnects a branch in the Amplify Console when you delete a branch from your Git repository.
        """
        return pulumi.get(self, "enable_branch_auto_deletion")

    @enable_branch_auto_deletion.setter
    def enable_branch_auto_deletion(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_branch_auto_deletion", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The environment variables map for an Amplify app.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter(name="iamServiceRoleArn")
    def iam_service_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS Identity and Access Management (IAM) service role for an Amplify app.
        """
        return pulumi.get(self, "iam_service_role_arn")

    @iam_service_role_arn.setter
    def iam_service_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iam_service_role_arn", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name for an Amplify app.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="oauthToken")
    def oauth_token(self) -> Optional[pulumi.Input[str]]:
        """
        The OAuth token for a third-party source control system for an Amplify app. The OAuth token is used to create a webhook and a read-only deploy key. The OAuth token is not stored.
        """
        return pulumi.get(self, "oauth_token")

    @oauth_token.setter
    def oauth_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth_token", value)

    @property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input[str]]:
        """
        The platform or framework for an Amplify app. Valid values: `WEB`.
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "platform", value)

    @property
    @pulumi.getter
    def repository(self) -> Optional[pulumi.Input[str]]:
        """
        The repository for an Amplify app.
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repository", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _AppState:
    def __init__(__self__, *,
                 access_token: Optional[pulumi.Input[str]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 auto_branch_creation_config: Optional[pulumi.Input['AppAutoBranchCreationConfigArgs']] = None,
                 auto_branch_creation_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 basic_auth_credentials: Optional[pulumi.Input[str]] = None,
                 build_spec: Optional[pulumi.Input[str]] = None,
                 custom_rules: Optional[pulumi.Input[Sequence[pulumi.Input['AppCustomRuleArgs']]]] = None,
                 default_domain: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_auto_branch_creation: Optional[pulumi.Input[bool]] = None,
                 enable_basic_auth: Optional[pulumi.Input[bool]] = None,
                 enable_branch_auto_build: Optional[pulumi.Input[bool]] = None,
                 enable_branch_auto_deletion: Optional[pulumi.Input[bool]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 iam_service_role_arn: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 oauth_token: Optional[pulumi.Input[str]] = None,
                 platform: Optional[pulumi.Input[str]] = None,
                 production_branches: Optional[pulumi.Input[Sequence[pulumi.Input['AppProductionBranchArgs']]]] = None,
                 repository: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering App resources.
        :param pulumi.Input[str] access_token: The personal access token for a third-party source control system for an Amplify app. The personal access token is used to create a webhook and a read-only deploy key. The token is not stored.
        :param pulumi.Input[str] arn: The Amazon Resource Name (ARN) of the Amplify app.
        :param pulumi.Input['AppAutoBranchCreationConfigArgs'] auto_branch_creation_config: The automated branch creation configuration for an Amplify app. An `auto_branch_creation_config` block is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] auto_branch_creation_patterns: The automated branch creation glob patterns for an Amplify app.
        :param pulumi.Input[str] basic_auth_credentials: The credentials for basic authorization for an Amplify app.
        :param pulumi.Input[str] build_spec: The [build specification](https://docs.aws.amazon.com/amplify/latest/userguide/build-settings.html) (build spec) for an Amplify app.
        :param pulumi.Input[Sequence[pulumi.Input['AppCustomRuleArgs']]] custom_rules: The custom rewrite and redirect rules for an Amplify app. A `custom_rule` block is documented below.
        :param pulumi.Input[str] default_domain: The default domain for the Amplify app.
        :param pulumi.Input[str] description: The description for an Amplify app.
        :param pulumi.Input[bool] enable_auto_branch_creation: Enables automated branch creation for an Amplify app.
        :param pulumi.Input[bool] enable_basic_auth: Enables basic authorization for an Amplify app. This will apply to all branches that are part of this app.
        :param pulumi.Input[bool] enable_branch_auto_build: Enables auto-building of branches for the Amplify App.
        :param pulumi.Input[bool] enable_branch_auto_deletion: Automatically disconnects a branch in the Amplify Console when you delete a branch from your Git repository.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] environment_variables: The environment variables map for an Amplify app.
        :param pulumi.Input[str] iam_service_role_arn: The AWS Identity and Access Management (IAM) service role for an Amplify app.
        :param pulumi.Input[str] name: The name for an Amplify app.
        :param pulumi.Input[str] oauth_token: The OAuth token for a third-party source control system for an Amplify app. The OAuth token is used to create a webhook and a read-only deploy key. The OAuth token is not stored.
        :param pulumi.Input[str] platform: The platform or framework for an Amplify app. Valid values: `WEB`.
        :param pulumi.Input[Sequence[pulumi.Input['AppProductionBranchArgs']]] production_branches: Describes the information about a production branch for an Amplify app. A `production_branch` block is documented below.
        :param pulumi.Input[str] repository: The repository for an Amplify app.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if access_token is not None:
            pulumi.set(__self__, "access_token", access_token)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if auto_branch_creation_config is not None:
            pulumi.set(__self__, "auto_branch_creation_config", auto_branch_creation_config)
        if auto_branch_creation_patterns is not None:
            pulumi.set(__self__, "auto_branch_creation_patterns", auto_branch_creation_patterns)
        if basic_auth_credentials is not None:
            pulumi.set(__self__, "basic_auth_credentials", basic_auth_credentials)
        if build_spec is not None:
            pulumi.set(__self__, "build_spec", build_spec)
        if custom_rules is not None:
            pulumi.set(__self__, "custom_rules", custom_rules)
        if default_domain is not None:
            pulumi.set(__self__, "default_domain", default_domain)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_auto_branch_creation is not None:
            pulumi.set(__self__, "enable_auto_branch_creation", enable_auto_branch_creation)
        if enable_basic_auth is not None:
            pulumi.set(__self__, "enable_basic_auth", enable_basic_auth)
        if enable_branch_auto_build is not None:
            pulumi.set(__self__, "enable_branch_auto_build", enable_branch_auto_build)
        if enable_branch_auto_deletion is not None:
            pulumi.set(__self__, "enable_branch_auto_deletion", enable_branch_auto_deletion)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if iam_service_role_arn is not None:
            pulumi.set(__self__, "iam_service_role_arn", iam_service_role_arn)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oauth_token is not None:
            pulumi.set(__self__, "oauth_token", oauth_token)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if production_branches is not None:
            pulumi.set(__self__, "production_branches", production_branches)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> Optional[pulumi.Input[str]]:
        """
        The personal access token for a third-party source control system for an Amplify app. The personal access token is used to create a webhook and a read-only deploy key. The token is not stored.
        """
        return pulumi.get(self, "access_token")

    @access_token.setter
    def access_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_token", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the Amplify app.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="autoBranchCreationConfig")
    def auto_branch_creation_config(self) -> Optional[pulumi.Input['AppAutoBranchCreationConfigArgs']]:
        """
        The automated branch creation configuration for an Amplify app. An `auto_branch_creation_config` block is documented below.
        """
        return pulumi.get(self, "auto_branch_creation_config")

    @auto_branch_creation_config.setter
    def auto_branch_creation_config(self, value: Optional[pulumi.Input['AppAutoBranchCreationConfigArgs']]):
        pulumi.set(self, "auto_branch_creation_config", value)

    @property
    @pulumi.getter(name="autoBranchCreationPatterns")
    def auto_branch_creation_patterns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The automated branch creation glob patterns for an Amplify app.
        """
        return pulumi.get(self, "auto_branch_creation_patterns")

    @auto_branch_creation_patterns.setter
    def auto_branch_creation_patterns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "auto_branch_creation_patterns", value)

    @property
    @pulumi.getter(name="basicAuthCredentials")
    def basic_auth_credentials(self) -> Optional[pulumi.Input[str]]:
        """
        The credentials for basic authorization for an Amplify app.
        """
        return pulumi.get(self, "basic_auth_credentials")

    @basic_auth_credentials.setter
    def basic_auth_credentials(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "basic_auth_credentials", value)

    @property
    @pulumi.getter(name="buildSpec")
    def build_spec(self) -> Optional[pulumi.Input[str]]:
        """
        The [build specification](https://docs.aws.amazon.com/amplify/latest/userguide/build-settings.html) (build spec) for an Amplify app.
        """
        return pulumi.get(self, "build_spec")

    @build_spec.setter
    def build_spec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "build_spec", value)

    @property
    @pulumi.getter(name="customRules")
    def custom_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppCustomRuleArgs']]]]:
        """
        The custom rewrite and redirect rules for an Amplify app. A `custom_rule` block is documented below.
        """
        return pulumi.get(self, "custom_rules")

    @custom_rules.setter
    def custom_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppCustomRuleArgs']]]]):
        pulumi.set(self, "custom_rules", value)

    @property
    @pulumi.getter(name="defaultDomain")
    def default_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The default domain for the Amplify app.
        """
        return pulumi.get(self, "default_domain")

    @default_domain.setter
    def default_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_domain", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description for an Amplify app.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enableAutoBranchCreation")
    def enable_auto_branch_creation(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables automated branch creation for an Amplify app.
        """
        return pulumi.get(self, "enable_auto_branch_creation")

    @enable_auto_branch_creation.setter
    def enable_auto_branch_creation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_auto_branch_creation", value)

    @property
    @pulumi.getter(name="enableBasicAuth")
    def enable_basic_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables basic authorization for an Amplify app. This will apply to all branches that are part of this app.
        """
        return pulumi.get(self, "enable_basic_auth")

    @enable_basic_auth.setter
    def enable_basic_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_basic_auth", value)

    @property
    @pulumi.getter(name="enableBranchAutoBuild")
    def enable_branch_auto_build(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables auto-building of branches for the Amplify App.
        """
        return pulumi.get(self, "enable_branch_auto_build")

    @enable_branch_auto_build.setter
    def enable_branch_auto_build(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_branch_auto_build", value)

    @property
    @pulumi.getter(name="enableBranchAutoDeletion")
    def enable_branch_auto_deletion(self) -> Optional[pulumi.Input[bool]]:
        """
        Automatically disconnects a branch in the Amplify Console when you delete a branch from your Git repository.
        """
        return pulumi.get(self, "enable_branch_auto_deletion")

    @enable_branch_auto_deletion.setter
    def enable_branch_auto_deletion(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_branch_auto_deletion", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The environment variables map for an Amplify app.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter(name="iamServiceRoleArn")
    def iam_service_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS Identity and Access Management (IAM) service role for an Amplify app.
        """
        return pulumi.get(self, "iam_service_role_arn")

    @iam_service_role_arn.setter
    def iam_service_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iam_service_role_arn", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name for an Amplify app.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="oauthToken")
    def oauth_token(self) -> Optional[pulumi.Input[str]]:
        """
        The OAuth token for a third-party source control system for an Amplify app. The OAuth token is used to create a webhook and a read-only deploy key. The OAuth token is not stored.
        """
        return pulumi.get(self, "oauth_token")

    @oauth_token.setter
    def oauth_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth_token", value)

    @property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input[str]]:
        """
        The platform or framework for an Amplify app. Valid values: `WEB`.
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "platform", value)

    @property
    @pulumi.getter(name="productionBranches")
    def production_branches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppProductionBranchArgs']]]]:
        """
        Describes the information about a production branch for an Amplify app. A `production_branch` block is documented below.
        """
        return pulumi.get(self, "production_branches")

    @production_branches.setter
    def production_branches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppProductionBranchArgs']]]]):
        pulumi.set(self, "production_branches", value)

    @property
    @pulumi.getter
    def repository(self) -> Optional[pulumi.Input[str]]:
        """
        The repository for an Amplify app.
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repository", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)


class App(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_token: Optional[pulumi.Input[str]] = None,
                 auto_branch_creation_config: Optional[pulumi.Input[pulumi.InputType['AppAutoBranchCreationConfigArgs']]] = None,
                 auto_branch_creation_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 basic_auth_credentials: Optional[pulumi.Input[str]] = None,
                 build_spec: Optional[pulumi.Input[str]] = None,
                 custom_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AppCustomRuleArgs']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_auto_branch_creation: Optional[pulumi.Input[bool]] = None,
                 enable_basic_auth: Optional[pulumi.Input[bool]] = None,
                 enable_branch_auto_build: Optional[pulumi.Input[bool]] = None,
                 enable_branch_auto_deletion: Optional[pulumi.Input[bool]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 iam_service_role_arn: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 oauth_token: Optional[pulumi.Input[str]] = None,
                 platform: Optional[pulumi.Input[str]] = None,
                 repository: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        ## Import

        Amplify App can be imported using Amplify App ID (appId), e.g.,

        ```sh
         $ pulumi import aws:amplify/app:App example d2ypk4k47z8u6
        ```

         App ID can be obtained from App ARN (e.g., `arn:aws:amplify:us-east-1:12345678:apps/d2ypk4k47z8u6`).

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_token: The personal access token for a third-party source control system for an Amplify app. The personal access token is used to create a webhook and a read-only deploy key. The token is not stored.
        :param pulumi.Input[pulumi.InputType['AppAutoBranchCreationConfigArgs']] auto_branch_creation_config: The automated branch creation configuration for an Amplify app. An `auto_branch_creation_config` block is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] auto_branch_creation_patterns: The automated branch creation glob patterns for an Amplify app.
        :param pulumi.Input[str] basic_auth_credentials: The credentials for basic authorization for an Amplify app.
        :param pulumi.Input[str] build_spec: The [build specification](https://docs.aws.amazon.com/amplify/latest/userguide/build-settings.html) (build spec) for an Amplify app.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AppCustomRuleArgs']]]] custom_rules: The custom rewrite and redirect rules for an Amplify app. A `custom_rule` block is documented below.
        :param pulumi.Input[str] description: The description for an Amplify app.
        :param pulumi.Input[bool] enable_auto_branch_creation: Enables automated branch creation for an Amplify app.
        :param pulumi.Input[bool] enable_basic_auth: Enables basic authorization for an Amplify app. This will apply to all branches that are part of this app.
        :param pulumi.Input[bool] enable_branch_auto_build: Enables auto-building of branches for the Amplify App.
        :param pulumi.Input[bool] enable_branch_auto_deletion: Automatically disconnects a branch in the Amplify Console when you delete a branch from your Git repository.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] environment_variables: The environment variables map for an Amplify app.
        :param pulumi.Input[str] iam_service_role_arn: The AWS Identity and Access Management (IAM) service role for an Amplify app.
        :param pulumi.Input[str] name: The name for an Amplify app.
        :param pulumi.Input[str] oauth_token: The OAuth token for a third-party source control system for an Amplify app. The OAuth token is used to create a webhook and a read-only deploy key. The OAuth token is not stored.
        :param pulumi.Input[str] platform: The platform or framework for an Amplify app. Valid values: `WEB`.
        :param pulumi.Input[str] repository: The repository for an Amplify app.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AppArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Amplify App can be imported using Amplify App ID (appId), e.g.,

        ```sh
         $ pulumi import aws:amplify/app:App example d2ypk4k47z8u6
        ```

         App ID can be obtained from App ARN (e.g., `arn:aws:amplify:us-east-1:12345678:apps/d2ypk4k47z8u6`).

        :param str resource_name: The name of the resource.
        :param AppArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_token: Optional[pulumi.Input[str]] = None,
                 auto_branch_creation_config: Optional[pulumi.Input[pulumi.InputType['AppAutoBranchCreationConfigArgs']]] = None,
                 auto_branch_creation_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 basic_auth_credentials: Optional[pulumi.Input[str]] = None,
                 build_spec: Optional[pulumi.Input[str]] = None,
                 custom_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AppCustomRuleArgs']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_auto_branch_creation: Optional[pulumi.Input[bool]] = None,
                 enable_basic_auth: Optional[pulumi.Input[bool]] = None,
                 enable_branch_auto_build: Optional[pulumi.Input[bool]] = None,
                 enable_branch_auto_deletion: Optional[pulumi.Input[bool]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 iam_service_role_arn: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 oauth_token: Optional[pulumi.Input[str]] = None,
                 platform: Optional[pulumi.Input[str]] = None,
                 repository: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppArgs.__new__(AppArgs)

            __props__.__dict__["access_token"] = access_token
            __props__.__dict__["auto_branch_creation_config"] = auto_branch_creation_config
            __props__.__dict__["auto_branch_creation_patterns"] = auto_branch_creation_patterns
            __props__.__dict__["basic_auth_credentials"] = basic_auth_credentials
            __props__.__dict__["build_spec"] = build_spec
            __props__.__dict__["custom_rules"] = custom_rules
            __props__.__dict__["description"] = description
            __props__.__dict__["enable_auto_branch_creation"] = enable_auto_branch_creation
            __props__.__dict__["enable_basic_auth"] = enable_basic_auth
            __props__.__dict__["enable_branch_auto_build"] = enable_branch_auto_build
            __props__.__dict__["enable_branch_auto_deletion"] = enable_branch_auto_deletion
            __props__.__dict__["environment_variables"] = environment_variables
            __props__.__dict__["iam_service_role_arn"] = iam_service_role_arn
            __props__.__dict__["name"] = name
            __props__.__dict__["oauth_token"] = oauth_token
            __props__.__dict__["platform"] = platform
            __props__.__dict__["repository"] = repository
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["default_domain"] = None
            __props__.__dict__["production_branches"] = None
            __props__.__dict__["tags_all"] = None
        super(App, __self__).__init__(
            'aws:amplify/app:App',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_token: Optional[pulumi.Input[str]] = None,
            arn: Optional[pulumi.Input[str]] = None,
            auto_branch_creation_config: Optional[pulumi.Input[pulumi.InputType['AppAutoBranchCreationConfigArgs']]] = None,
            auto_branch_creation_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            basic_auth_credentials: Optional[pulumi.Input[str]] = None,
            build_spec: Optional[pulumi.Input[str]] = None,
            custom_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AppCustomRuleArgs']]]]] = None,
            default_domain: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            enable_auto_branch_creation: Optional[pulumi.Input[bool]] = None,
            enable_basic_auth: Optional[pulumi.Input[bool]] = None,
            enable_branch_auto_build: Optional[pulumi.Input[bool]] = None,
            enable_branch_auto_deletion: Optional[pulumi.Input[bool]] = None,
            environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            iam_service_role_arn: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            oauth_token: Optional[pulumi.Input[str]] = None,
            platform: Optional[pulumi.Input[str]] = None,
            production_branches: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AppProductionBranchArgs']]]]] = None,
            repository: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None) -> 'App':
        """
        Get an existing App resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_token: The personal access token for a third-party source control system for an Amplify app. The personal access token is used to create a webhook and a read-only deploy key. The token is not stored.
        :param pulumi.Input[str] arn: The Amazon Resource Name (ARN) of the Amplify app.
        :param pulumi.Input[pulumi.InputType['AppAutoBranchCreationConfigArgs']] auto_branch_creation_config: The automated branch creation configuration for an Amplify app. An `auto_branch_creation_config` block is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] auto_branch_creation_patterns: The automated branch creation glob patterns for an Amplify app.
        :param pulumi.Input[str] basic_auth_credentials: The credentials for basic authorization for an Amplify app.
        :param pulumi.Input[str] build_spec: The [build specification](https://docs.aws.amazon.com/amplify/latest/userguide/build-settings.html) (build spec) for an Amplify app.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AppCustomRuleArgs']]]] custom_rules: The custom rewrite and redirect rules for an Amplify app. A `custom_rule` block is documented below.
        :param pulumi.Input[str] default_domain: The default domain for the Amplify app.
        :param pulumi.Input[str] description: The description for an Amplify app.
        :param pulumi.Input[bool] enable_auto_branch_creation: Enables automated branch creation for an Amplify app.
        :param pulumi.Input[bool] enable_basic_auth: Enables basic authorization for an Amplify app. This will apply to all branches that are part of this app.
        :param pulumi.Input[bool] enable_branch_auto_build: Enables auto-building of branches for the Amplify App.
        :param pulumi.Input[bool] enable_branch_auto_deletion: Automatically disconnects a branch in the Amplify Console when you delete a branch from your Git repository.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] environment_variables: The environment variables map for an Amplify app.
        :param pulumi.Input[str] iam_service_role_arn: The AWS Identity and Access Management (IAM) service role for an Amplify app.
        :param pulumi.Input[str] name: The name for an Amplify app.
        :param pulumi.Input[str] oauth_token: The OAuth token for a third-party source control system for an Amplify app. The OAuth token is used to create a webhook and a read-only deploy key. The OAuth token is not stored.
        :param pulumi.Input[str] platform: The platform or framework for an Amplify app. Valid values: `WEB`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AppProductionBranchArgs']]]] production_branches: Describes the information about a production branch for an Amplify app. A `production_branch` block is documented below.
        :param pulumi.Input[str] repository: The repository for an Amplify app.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppState.__new__(_AppState)

        __props__.__dict__["access_token"] = access_token
        __props__.__dict__["arn"] = arn
        __props__.__dict__["auto_branch_creation_config"] = auto_branch_creation_config
        __props__.__dict__["auto_branch_creation_patterns"] = auto_branch_creation_patterns
        __props__.__dict__["basic_auth_credentials"] = basic_auth_credentials
        __props__.__dict__["build_spec"] = build_spec
        __props__.__dict__["custom_rules"] = custom_rules
        __props__.__dict__["default_domain"] = default_domain
        __props__.__dict__["description"] = description
        __props__.__dict__["enable_auto_branch_creation"] = enable_auto_branch_creation
        __props__.__dict__["enable_basic_auth"] = enable_basic_auth
        __props__.__dict__["enable_branch_auto_build"] = enable_branch_auto_build
        __props__.__dict__["enable_branch_auto_deletion"] = enable_branch_auto_deletion
        __props__.__dict__["environment_variables"] = environment_variables
        __props__.__dict__["iam_service_role_arn"] = iam_service_role_arn
        __props__.__dict__["name"] = name
        __props__.__dict__["oauth_token"] = oauth_token
        __props__.__dict__["platform"] = platform
        __props__.__dict__["production_branches"] = production_branches
        __props__.__dict__["repository"] = repository
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return App(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> pulumi.Output[Optional[str]]:
        """
        The personal access token for a third-party source control system for an Amplify app. The personal access token is used to create a webhook and a read-only deploy key. The token is not stored.
        """
        return pulumi.get(self, "access_token")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the Amplify app.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="autoBranchCreationConfig")
    def auto_branch_creation_config(self) -> pulumi.Output['outputs.AppAutoBranchCreationConfig']:
        """
        The automated branch creation configuration for an Amplify app. An `auto_branch_creation_config` block is documented below.
        """
        return pulumi.get(self, "auto_branch_creation_config")

    @property
    @pulumi.getter(name="autoBranchCreationPatterns")
    def auto_branch_creation_patterns(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The automated branch creation glob patterns for an Amplify app.
        """
        return pulumi.get(self, "auto_branch_creation_patterns")

    @property
    @pulumi.getter(name="basicAuthCredentials")
    def basic_auth_credentials(self) -> pulumi.Output[Optional[str]]:
        """
        The credentials for basic authorization for an Amplify app.
        """
        return pulumi.get(self, "basic_auth_credentials")

    @property
    @pulumi.getter(name="buildSpec")
    def build_spec(self) -> pulumi.Output[str]:
        """
        The [build specification](https://docs.aws.amazon.com/amplify/latest/userguide/build-settings.html) (build spec) for an Amplify app.
        """
        return pulumi.get(self, "build_spec")

    @property
    @pulumi.getter(name="customRules")
    def custom_rules(self) -> pulumi.Output[Optional[Sequence['outputs.AppCustomRule']]]:
        """
        The custom rewrite and redirect rules for an Amplify app. A `custom_rule` block is documented below.
        """
        return pulumi.get(self, "custom_rules")

    @property
    @pulumi.getter(name="defaultDomain")
    def default_domain(self) -> pulumi.Output[str]:
        """
        The default domain for the Amplify app.
        """
        return pulumi.get(self, "default_domain")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description for an Amplify app.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enableAutoBranchCreation")
    def enable_auto_branch_creation(self) -> pulumi.Output[Optional[bool]]:
        """
        Enables automated branch creation for an Amplify app.
        """
        return pulumi.get(self, "enable_auto_branch_creation")

    @property
    @pulumi.getter(name="enableBasicAuth")
    def enable_basic_auth(self) -> pulumi.Output[Optional[bool]]:
        """
        Enables basic authorization for an Amplify app. This will apply to all branches that are part of this app.
        """
        return pulumi.get(self, "enable_basic_auth")

    @property
    @pulumi.getter(name="enableBranchAutoBuild")
    def enable_branch_auto_build(self) -> pulumi.Output[Optional[bool]]:
        """
        Enables auto-building of branches for the Amplify App.
        """
        return pulumi.get(self, "enable_branch_auto_build")

    @property
    @pulumi.getter(name="enableBranchAutoDeletion")
    def enable_branch_auto_deletion(self) -> pulumi.Output[Optional[bool]]:
        """
        Automatically disconnects a branch in the Amplify Console when you delete a branch from your Git repository.
        """
        return pulumi.get(self, "enable_branch_auto_deletion")

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        The environment variables map for an Amplify app.
        """
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter(name="iamServiceRoleArn")
    def iam_service_role_arn(self) -> pulumi.Output[Optional[str]]:
        """
        The AWS Identity and Access Management (IAM) service role for an Amplify app.
        """
        return pulumi.get(self, "iam_service_role_arn")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name for an Amplify app.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="oauthToken")
    def oauth_token(self) -> pulumi.Output[Optional[str]]:
        """
        The OAuth token for a third-party source control system for an Amplify app. The OAuth token is used to create a webhook and a read-only deploy key. The OAuth token is not stored.
        """
        return pulumi.get(self, "oauth_token")

    @property
    @pulumi.getter
    def platform(self) -> pulumi.Output[Optional[str]]:
        """
        The platform or framework for an Amplify app. Valid values: `WEB`.
        """
        return pulumi.get(self, "platform")

    @property
    @pulumi.getter(name="productionBranches")
    def production_branches(self) -> pulumi.Output[Sequence['outputs.AppProductionBranch']]:
        """
        Describes the information about a production branch for an Amplify app. A `production_branch` block is documented below.
        """
        return pulumi.get(self, "production_branches")

    @property
    @pulumi.getter
    def repository(self) -> pulumi.Output[Optional[str]]:
        """
        The repository for an Amplify app.
        """
        return pulumi.get(self, "repository")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

