# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetPatchBaselineResult',
    'AwaitableGetPatchBaselineResult',
    'get_patch_baseline',
]

@pulumi.output_type
class GetPatchBaselineResult:
    """
    A collection of values returned by getPatchBaseline.
    """
    def __init__(__self__, default_baseline=None, description=None, id=None, name=None, name_prefix=None, operating_system=None, owner=None):
        if default_baseline and not isinstance(default_baseline, bool):
            raise TypeError("Expected argument 'default_baseline' to be a bool")
        pulumi.set(__self__, "default_baseline", default_baseline)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if name_prefix and not isinstance(name_prefix, str):
            raise TypeError("Expected argument 'name_prefix' to be a str")
        pulumi.set(__self__, "name_prefix", name_prefix)
        if operating_system and not isinstance(operating_system, str):
            raise TypeError("Expected argument 'operating_system' to be a str")
        pulumi.set(__self__, "operating_system", operating_system)
        if owner and not isinstance(owner, str):
            raise TypeError("Expected argument 'owner' to be a str")
        pulumi.set(__self__, "owner", owner)

    @property
    @pulumi.getter(name="defaultBaseline")
    def default_baseline(self) -> Optional[bool]:
        return pulumi.get(self, "default_baseline")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the baseline.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the baseline.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[str]:
        return pulumi.get(self, "name_prefix")

    @property
    @pulumi.getter(name="operatingSystem")
    def operating_system(self) -> Optional[str]:
        return pulumi.get(self, "operating_system")

    @property
    @pulumi.getter
    def owner(self) -> str:
        return pulumi.get(self, "owner")


class AwaitableGetPatchBaselineResult(GetPatchBaselineResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPatchBaselineResult(
            default_baseline=self.default_baseline,
            description=self.description,
            id=self.id,
            name=self.name,
            name_prefix=self.name_prefix,
            operating_system=self.operating_system,
            owner=self.owner)


def get_patch_baseline(default_baseline: Optional[bool] = None,
                       name_prefix: Optional[str] = None,
                       operating_system: Optional[str] = None,
                       owner: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPatchBaselineResult:
    """
    Provides an SSM Patch Baseline data source. Useful if you wish to reuse the default baselines provided.

    ## Example Usage

    To retrieve a baseline provided by AWS:

    ```python
    import pulumi
    import pulumi_aws as aws

    centos = aws.ssm.get_patch_baseline(name_prefix="AWS-",
        operating_system="CENTOS",
        owner="AWS")
    ```

    To retrieve a baseline on your account:

    ```python
    import pulumi
    import pulumi_aws as aws

    default_custom = aws.ssm.get_patch_baseline(default_baseline=True,
        name_prefix="MyCustomBaseline",
        operating_system="WINDOWS",
        owner="Self")
    ```


    :param bool default_baseline: Filters the results against the baselines default_baseline field.
    :param str name_prefix: Filter results by the baseline name prefix.
    :param str operating_system: The specified OS for the baseline.
    :param str owner: The owner of the baseline. Valid values: `All`, `AWS`, `Self` (the current account).
    """
    __args__ = dict()
    __args__['defaultBaseline'] = default_baseline
    __args__['namePrefix'] = name_prefix
    __args__['operatingSystem'] = operating_system
    __args__['owner'] = owner
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws:ssm/getPatchBaseline:getPatchBaseline', __args__, opts=opts, typ=GetPatchBaselineResult).value

    return AwaitableGetPatchBaselineResult(
        default_baseline=__ret__.default_baseline,
        description=__ret__.description,
        id=__ret__.id,
        name=__ret__.name,
        name_prefix=__ret__.name_prefix,
        operating_system=__ret__.operating_system,
        owner=__ret__.owner)
