# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetDocumentResult',
    'AwaitableGetDocumentResult',
    'get_document',
]

@pulumi.output_type
class GetDocumentResult:
    """
    A collection of values returned by getDocument.
    """
    def __init__(__self__, arn=None, content=None, document_format=None, document_type=None, document_version=None, id=None, name=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if content and not isinstance(content, str):
            raise TypeError("Expected argument 'content' to be a str")
        pulumi.set(__self__, "content", content)
        if document_format and not isinstance(document_format, str):
            raise TypeError("Expected argument 'document_format' to be a str")
        pulumi.set(__self__, "document_format", document_format)
        if document_type and not isinstance(document_type, str):
            raise TypeError("Expected argument 'document_type' to be a str")
        pulumi.set(__self__, "document_type", document_type)
        if document_version and not isinstance(document_version, str):
            raise TypeError("Expected argument 'document_version' to be a str")
        pulumi.set(__self__, "document_version", document_version)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        The ARN of the document.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def content(self) -> str:
        """
        The contents of the document.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="documentFormat")
    def document_format(self) -> Optional[str]:
        return pulumi.get(self, "document_format")

    @property
    @pulumi.getter(name="documentType")
    def document_type(self) -> str:
        """
        The type of the document.
        """
        return pulumi.get(self, "document_type")

    @property
    @pulumi.getter(name="documentVersion")
    def document_version(self) -> Optional[str]:
        return pulumi.get(self, "document_version")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")


class AwaitableGetDocumentResult(GetDocumentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDocumentResult(
            arn=self.arn,
            content=self.content,
            document_format=self.document_format,
            document_type=self.document_type,
            document_version=self.document_version,
            id=self.id,
            name=self.name)


def get_document(document_format: Optional[str] = None,
                 document_version: Optional[str] = None,
                 name: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDocumentResult:
    """
    Gets the contents of the specified Systems Manager document.

    ## Example Usage

    To get the contents of the document owned by AWS.

    ```python
    import pulumi
    import pulumi_aws as aws

    foo = aws.ssm.get_document(name="AWS-GatherSoftwareInventory",
        document_format="YAML")
    pulumi.export("content", foo.content)
    ```

    To get the contents of the custom document.

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.ssm.get_document(name=aws_ssm_document["test"]["name"],
        document_format="JSON")
    ```


    :param str document_format: Returns the document in the specified format. The document format can be either JSON or YAML. JSON is the default format.
    :param str document_version: The document version for which you want information.
    :param str name: The name of the Systems Manager document.
    """
    __args__ = dict()
    __args__['documentFormat'] = document_format
    __args__['documentVersion'] = document_version
    __args__['name'] = name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws:ssm/getDocument:getDocument', __args__, opts=opts, typ=GetDocumentResult).value

    return AwaitableGetDocumentResult(
        arn=__ret__.arn,
        content=__ret__.content,
        document_format=__ret__.document_format,
        document_type=__ret__.document_type,
        document_version=__ret__.document_version,
        id=__ret__.id,
        name=__ret__.name)
