# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['TopicPolicyArgs', 'TopicPolicy']

@pulumi.input_type
class TopicPolicyArgs:
    def __init__(__self__, *,
                 arn: pulumi.Input[str],
                 policy: pulumi.Input[str]):
        """
        The set of arguments for constructing a TopicPolicy resource.
        :param pulumi.Input[str] arn: The ARN of the SNS topic
        :param pulumi.Input[str] policy: The fully-formed AWS policy as JSON.
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "policy", policy)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Input[str]:
        """
        The ARN of the SNS topic
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def policy(self) -> pulumi.Input[str]:
        """
        The fully-formed AWS policy as JSON.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: pulumi.Input[str]):
        pulumi.set(self, "policy", value)


@pulumi.input_type
class _TopicPolicyState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 owner: Optional[pulumi.Input[str]] = None,
                 policy: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering TopicPolicy resources.
        :param pulumi.Input[str] arn: The ARN of the SNS topic
        :param pulumi.Input[str] owner: The AWS Account ID of the SNS topic owner
        :param pulumi.Input[str] policy: The fully-formed AWS policy as JSON.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the SNS topic
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS Account ID of the SNS topic owner
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[str]]:
        """
        The fully-formed AWS policy as JSON.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy", value)


class TopicPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 policy: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides an SNS topic policy resource

        > **NOTE:** If a Principal is specified as just an AWS account ID rather than an ARN, AWS silently converts it to the ARN for the root user, causing future deployments to differ. To avoid this problem, just specify the full ARN, e.g. `arn:aws:iam::123456789012:root`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.sns.Topic("test")
        sns_topic_policy = test.arn.apply(lambda arn: aws.iam.get_policy_document(policy_id="__default_policy_ID",
            statements=[aws.iam.GetPolicyDocumentStatementArgs(
                actions=[
                    "SNS:Subscribe",
                    "SNS:SetTopicAttributes",
                    "SNS:RemovePermission",
                    "SNS:Receive",
                    "SNS:Publish",
                    "SNS:ListSubscriptionsByTopic",
                    "SNS:GetTopicAttributes",
                    "SNS:DeleteTopic",
                    "SNS:AddPermission",
                ],
                conditions=[aws.iam.GetPolicyDocumentStatementConditionArgs(
                    test="StringEquals",
                    variable="AWS:SourceOwner",
                    values=[var["account-id"]],
                )],
                effect="Allow",
                principals=[aws.iam.GetPolicyDocumentStatementPrincipalArgs(
                    type="AWS",
                    identifiers=["*"],
                )],
                resources=[arn],
                sid="__default_statement_ID",
            )]))
        default = aws.sns.TopicPolicy("default",
            arn=test.arn,
            policy=sns_topic_policy.json)
        ```

        ## Import

        SNS Topic Policy can be imported using the topic ARN, e.g.

        ```sh
         $ pulumi import aws:sns/topicPolicy:TopicPolicy user_updates arn:aws:sns:us-west-2:0123456789012:my-topic
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: The ARN of the SNS topic
        :param pulumi.Input[str] policy: The fully-formed AWS policy as JSON.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TopicPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an SNS topic policy resource

        > **NOTE:** If a Principal is specified as just an AWS account ID rather than an ARN, AWS silently converts it to the ARN for the root user, causing future deployments to differ. To avoid this problem, just specify the full ARN, e.g. `arn:aws:iam::123456789012:root`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.sns.Topic("test")
        sns_topic_policy = test.arn.apply(lambda arn: aws.iam.get_policy_document(policy_id="__default_policy_ID",
            statements=[aws.iam.GetPolicyDocumentStatementArgs(
                actions=[
                    "SNS:Subscribe",
                    "SNS:SetTopicAttributes",
                    "SNS:RemovePermission",
                    "SNS:Receive",
                    "SNS:Publish",
                    "SNS:ListSubscriptionsByTopic",
                    "SNS:GetTopicAttributes",
                    "SNS:DeleteTopic",
                    "SNS:AddPermission",
                ],
                conditions=[aws.iam.GetPolicyDocumentStatementConditionArgs(
                    test="StringEquals",
                    variable="AWS:SourceOwner",
                    values=[var["account-id"]],
                )],
                effect="Allow",
                principals=[aws.iam.GetPolicyDocumentStatementPrincipalArgs(
                    type="AWS",
                    identifiers=["*"],
                )],
                resources=[arn],
                sid="__default_statement_ID",
            )]))
        default = aws.sns.TopicPolicy("default",
            arn=test.arn,
            policy=sns_topic_policy.json)
        ```

        ## Import

        SNS Topic Policy can be imported using the topic ARN, e.g.

        ```sh
         $ pulumi import aws:sns/topicPolicy:TopicPolicy user_updates arn:aws:sns:us-west-2:0123456789012:my-topic
        ```

        :param str resource_name: The name of the resource.
        :param TopicPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TopicPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 policy: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TopicPolicyArgs.__new__(TopicPolicyArgs)

            if arn is None and not opts.urn:
                raise TypeError("Missing required property 'arn'")
            __props__.__dict__["arn"] = arn
            if policy is None and not opts.urn:
                raise TypeError("Missing required property 'policy'")
            __props__.__dict__["policy"] = policy
            __props__.__dict__["owner"] = None
        super(TopicPolicy, __self__).__init__(
            'aws:sns/topicPolicy:TopicPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            owner: Optional[pulumi.Input[str]] = None,
            policy: Optional[pulumi.Input[str]] = None) -> 'TopicPolicy':
        """
        Get an existing TopicPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: The ARN of the SNS topic
        :param pulumi.Input[str] owner: The AWS Account ID of the SNS topic owner
        :param pulumi.Input[str] policy: The fully-formed AWS policy as JSON.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TopicPolicyState.__new__(_TopicPolicyState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["owner"] = owner
        __props__.__dict__["policy"] = policy
        return TopicPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the SNS topic
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def owner(self) -> pulumi.Output[str]:
        """
        The AWS Account ID of the SNS topic owner
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter
    def policy(self) -> pulumi.Output[str]:
        """
        The fully-formed AWS policy as JSON.
        """
        return pulumi.get(self, "policy")

