# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['TopicArgs', 'Topic']

@pulumi.input_type
class TopicArgs:
    def __init__(__self__, *,
                 application_failure_feedback_role_arn: Optional[pulumi.Input[str]] = None,
                 application_success_feedback_role_arn: Optional[pulumi.Input[str]] = None,
                 application_success_feedback_sample_rate: Optional[pulumi.Input[int]] = None,
                 content_based_deduplication: Optional[pulumi.Input[bool]] = None,
                 delivery_policy: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 fifo_topic: Optional[pulumi.Input[bool]] = None,
                 firehose_failure_feedback_role_arn: Optional[pulumi.Input[str]] = None,
                 firehose_success_feedback_role_arn: Optional[pulumi.Input[str]] = None,
                 firehose_success_feedback_sample_rate: Optional[pulumi.Input[int]] = None,
                 http_failure_feedback_role_arn: Optional[pulumi.Input[str]] = None,
                 http_success_feedback_role_arn: Optional[pulumi.Input[str]] = None,
                 http_success_feedback_sample_rate: Optional[pulumi.Input[int]] = None,
                 kms_master_key_id: Optional[pulumi.Input[str]] = None,
                 lambda_failure_feedback_role_arn: Optional[pulumi.Input[str]] = None,
                 lambda_success_feedback_role_arn: Optional[pulumi.Input[str]] = None,
                 lambda_success_feedback_sample_rate: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 policy: Optional[pulumi.Input[str]] = None,
                 sqs_failure_feedback_role_arn: Optional[pulumi.Input[str]] = None,
                 sqs_success_feedback_role_arn: Optional[pulumi.Input[str]] = None,
                 sqs_success_feedback_sample_rate: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Topic resource.
        :param pulumi.Input[str] application_failure_feedback_role_arn: IAM role for failure feedback
        :param pulumi.Input[str] application_success_feedback_role_arn: The IAM role permitted to receive success feedback for this topic
        :param pulumi.Input[int] application_success_feedback_sample_rate: Percentage of success to sample
        :param pulumi.Input[bool] content_based_deduplication: Enables content-based deduplication for FIFO topics. For more information, see the [related documentation](https://docs.aws.amazon.com/sns/latest/dg/fifo-message-dedup.html)
        :param pulumi.Input[str] delivery_policy: The SNS delivery policy. More on [AWS documentation](https://docs.aws.amazon.com/sns/latest/dg/DeliveryPolicies.html)
        :param pulumi.Input[str] display_name: The display name for the topic
        :param pulumi.Input[bool] fifo_topic: Boolean indicating whether or not to create a FIFO (first-in-first-out) topic (default is `false`).
        :param pulumi.Input[str] firehose_failure_feedback_role_arn: IAM role for failure feedback
        :param pulumi.Input[str] firehose_success_feedback_role_arn: The IAM role permitted to receive success feedback for this topic
        :param pulumi.Input[int] firehose_success_feedback_sample_rate: Percentage of success to sample
        :param pulumi.Input[str] http_failure_feedback_role_arn: IAM role for failure feedback
        :param pulumi.Input[str] http_success_feedback_role_arn: The IAM role permitted to receive success feedback for this topic
        :param pulumi.Input[int] http_success_feedback_sample_rate: Percentage of success to sample
        :param pulumi.Input[str] kms_master_key_id: The ID of an AWS-managed customer master key (CMK) for Amazon SNS or a custom CMK. For more information, see [Key Terms](https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html#sse-key-terms)
        :param pulumi.Input[str] lambda_failure_feedback_role_arn: IAM role for failure feedback
        :param pulumi.Input[str] lambda_success_feedback_role_arn: The IAM role permitted to receive success feedback for this topic
        :param pulumi.Input[int] lambda_success_feedback_sample_rate: Percentage of success to sample
        :param pulumi.Input[str] name: The name of the topic. Topic names must be made up of only uppercase and lowercase ASCII letters, numbers, underscores, and hyphens, and must be between 1 and 256 characters long. For a FIFO (first-in-first-out) topic, the name must end with the `.fifo` suffix. If omitted, this provider will assign a random, unique name. Conflicts with `name_prefix`
        :param pulumi.Input[str] name_prefix: Creates a unique name beginning with the specified prefix. Conflicts with `name`
        :param pulumi.Input[str] policy: The fully-formed AWS policy as JSON.
        :param pulumi.Input[str] sqs_failure_feedback_role_arn: IAM role for failure feedback
        :param pulumi.Input[str] sqs_success_feedback_role_arn: The IAM role permitted to receive success feedback for this topic
        :param pulumi.Input[int] sqs_success_feedback_sample_rate: Percentage of success to sample
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. .If configured with a provider `defaultTags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider .
        """
        if application_failure_feedback_role_arn is not None:
            pulumi.set(__self__, "application_failure_feedback_role_arn", application_failure_feedback_role_arn)
        if application_success_feedback_role_arn is not None:
            pulumi.set(__self__, "application_success_feedback_role_arn", application_success_feedback_role_arn)
        if application_success_feedback_sample_rate is not None:
            pulumi.set(__self__, "application_success_feedback_sample_rate", application_success_feedback_sample_rate)
        if content_based_deduplication is not None:
            pulumi.set(__self__, "content_based_deduplication", content_based_deduplication)
        if delivery_policy is not None:
            pulumi.set(__self__, "delivery_policy", delivery_policy)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if fifo_topic is not None:
            pulumi.set(__self__, "fifo_topic", fifo_topic)
        if firehose_failure_feedback_role_arn is not None:
            pulumi.set(__self__, "firehose_failure_feedback_role_arn", firehose_failure_feedback_role_arn)
        if firehose_success_feedback_role_arn is not None:
            pulumi.set(__self__, "firehose_success_feedback_role_arn", firehose_success_feedback_role_arn)
        if firehose_success_feedback_sample_rate is not None:
            pulumi.set(__self__, "firehose_success_feedback_sample_rate", firehose_success_feedback_sample_rate)
        if http_failure_feedback_role_arn is not None:
            pulumi.set(__self__, "http_failure_feedback_role_arn", http_failure_feedback_role_arn)
        if http_success_feedback_role_arn is not None:
            pulumi.set(__self__, "http_success_feedback_role_arn", http_success_feedback_role_arn)
        if http_success_feedback_sample_rate is not None:
            pulumi.set(__self__, "http_success_feedback_sample_rate", http_success_feedback_sample_rate)
        if kms_master_key_id is not None:
            pulumi.set(__self__, "kms_master_key_id", kms_master_key_id)
        if lambda_failure_feedback_role_arn is not None:
            pulumi.set(__self__, "lambda_failure_feedback_role_arn", lambda_failure_feedback_role_arn)
        if lambda_success_feedback_role_arn is not None:
            pulumi.set(__self__, "lambda_success_feedback_role_arn", lambda_success_feedback_role_arn)
        if lambda_success_feedback_sample_rate is not None:
            pulumi.set(__self__, "lambda_success_feedback_sample_rate", lambda_success_feedback_sample_rate)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if sqs_failure_feedback_role_arn is not None:
            pulumi.set(__self__, "sqs_failure_feedback_role_arn", sqs_failure_feedback_role_arn)
        if sqs_success_feedback_role_arn is not None:
            pulumi.set(__self__, "sqs_success_feedback_role_arn", sqs_success_feedback_role_arn)
        if sqs_success_feedback_sample_rate is not None:
            pulumi.set(__self__, "sqs_success_feedback_sample_rate", sqs_success_feedback_sample_rate)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @property
    @pulumi.getter(name="applicationFailureFeedbackRoleArn")
    def application_failure_feedback_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        IAM role for failure feedback
        """
        return pulumi.get(self, "application_failure_feedback_role_arn")

    @application_failure_feedback_role_arn.setter
    def application_failure_feedback_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_failure_feedback_role_arn", value)

    @property
    @pulumi.getter(name="applicationSuccessFeedbackRoleArn")
    def application_success_feedback_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The IAM role permitted to receive success feedback for this topic
        """
        return pulumi.get(self, "application_success_feedback_role_arn")

    @application_success_feedback_role_arn.setter
    def application_success_feedback_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_success_feedback_role_arn", value)

    @property
    @pulumi.getter(name="applicationSuccessFeedbackSampleRate")
    def application_success_feedback_sample_rate(self) -> Optional[pulumi.Input[int]]:
        """
        Percentage of success to sample
        """
        return pulumi.get(self, "application_success_feedback_sample_rate")

    @application_success_feedback_sample_rate.setter
    def application_success_feedback_sample_rate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "application_success_feedback_sample_rate", value)

    @property
    @pulumi.getter(name="contentBasedDeduplication")
    def content_based_deduplication(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables content-based deduplication for FIFO topics. For more information, see the [related documentation](https://docs.aws.amazon.com/sns/latest/dg/fifo-message-dedup.html)
        """
        return pulumi.get(self, "content_based_deduplication")

    @content_based_deduplication.setter
    def content_based_deduplication(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "content_based_deduplication", value)

    @property
    @pulumi.getter(name="deliveryPolicy")
    def delivery_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The SNS delivery policy. More on [AWS documentation](https://docs.aws.amazon.com/sns/latest/dg/DeliveryPolicies.html)
        """
        return pulumi.get(self, "delivery_policy")

    @delivery_policy.setter
    def delivery_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delivery_policy", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name for the topic
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="fifoTopic")
    def fifo_topic(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean indicating whether or not to create a FIFO (first-in-first-out) topic (default is `false`).
        """
        return pulumi.get(self, "fifo_topic")

    @fifo_topic.setter
    def fifo_topic(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "fifo_topic", value)

    @property
    @pulumi.getter(name="firehoseFailureFeedbackRoleArn")
    def firehose_failure_feedback_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        IAM role for failure feedback
        """
        return pulumi.get(self, "firehose_failure_feedback_role_arn")

    @firehose_failure_feedback_role_arn.setter
    def firehose_failure_feedback_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "firehose_failure_feedback_role_arn", value)

    @property
    @pulumi.getter(name="firehoseSuccessFeedbackRoleArn")
    def firehose_success_feedback_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The IAM role permitted to receive success feedback for this topic
        """
        return pulumi.get(self, "firehose_success_feedback_role_arn")

    @firehose_success_feedback_role_arn.setter
    def firehose_success_feedback_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "firehose_success_feedback_role_arn", value)

    @property
    @pulumi.getter(name="firehoseSuccessFeedbackSampleRate")
    def firehose_success_feedback_sample_rate(self) -> Optional[pulumi.Input[int]]:
        """
        Percentage of success to sample
        """
        return pulumi.get(self, "firehose_success_feedback_sample_rate")

    @firehose_success_feedback_sample_rate.setter
    def firehose_success_feedback_sample_rate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "firehose_success_feedback_sample_rate", value)

    @property
    @pulumi.getter(name="httpFailureFeedbackRoleArn")
    def http_failure_feedback_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        IAM role for failure feedback
        """
        return pulumi.get(self, "http_failure_feedback_role_arn")

    @http_failure_feedback_role_arn.setter
    def http_failure_feedback_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_failure_feedback_role_arn", value)

    @property
    @pulumi.getter(name="httpSuccessFeedbackRoleArn")
    def http_success_feedback_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The IAM role permitted to receive success feedback for this topic
        """
        return pulumi.get(self, "http_success_feedback_role_arn")

    @http_success_feedback_role_arn.setter
    def http_success_feedback_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_success_feedback_role_arn", value)

    @property
    @pulumi.getter(name="httpSuccessFeedbackSampleRate")
    def http_success_feedback_sample_rate(self) -> Optional[pulumi.Input[int]]:
        """
        Percentage of success to sample
        """
        return pulumi.get(self, "http_success_feedback_sample_rate")

    @http_success_feedback_sample_rate.setter
    def http_success_feedback_sample_rate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "http_success_feedback_sample_rate", value)

    @property
    @pulumi.getter(name="kmsMasterKeyId")
    def kms_master_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of an AWS-managed customer master key (CMK) for Amazon SNS or a custom CMK. For more information, see [Key Terms](https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html#sse-key-terms)
        """
        return pulumi.get(self, "kms_master_key_id")

    @kms_master_key_id.setter
    def kms_master_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_master_key_id", value)

    @property
    @pulumi.getter(name="lambdaFailureFeedbackRoleArn")
    def lambda_failure_feedback_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        IAM role for failure feedback
        """
        return pulumi.get(self, "lambda_failure_feedback_role_arn")

    @lambda_failure_feedback_role_arn.setter
    def lambda_failure_feedback_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lambda_failure_feedback_role_arn", value)

    @property
    @pulumi.getter(name="lambdaSuccessFeedbackRoleArn")
    def lambda_success_feedback_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The IAM role permitted to receive success feedback for this topic
        """
        return pulumi.get(self, "lambda_success_feedback_role_arn")

    @lambda_success_feedback_role_arn.setter
    def lambda_success_feedback_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lambda_success_feedback_role_arn", value)

    @property
    @pulumi.getter(name="lambdaSuccessFeedbackSampleRate")
    def lambda_success_feedback_sample_rate(self) -> Optional[pulumi.Input[int]]:
        """
        Percentage of success to sample
        """
        return pulumi.get(self, "lambda_success_feedback_sample_rate")

    @lambda_success_feedback_sample_rate.setter
    def lambda_success_feedback_sample_rate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "lambda_success_feedback_sample_rate", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the topic. Topic names must be made up of only uppercase and lowercase ASCII letters, numbers, underscores, and hyphens, and must be between 1 and 256 characters long. For a FIFO (first-in-first-out) topic, the name must end with the `.fifo` suffix. If omitted, this provider will assign a random, unique name. Conflicts with `name_prefix`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Creates a unique name beginning with the specified prefix. Conflicts with `name`
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_prefix", value)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[str]]:
        """
        The fully-formed AWS policy as JSON.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter(name="sqsFailureFeedbackRoleArn")
    def sqs_failure_feedback_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        IAM role for failure feedback
        """
        return pulumi.get(self, "sqs_failure_feedback_role_arn")

    @sqs_failure_feedback_role_arn.setter
    def sqs_failure_feedback_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sqs_failure_feedback_role_arn", value)

    @property
    @pulumi.getter(name="sqsSuccessFeedbackRoleArn")
    def sqs_success_feedback_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The IAM role permitted to receive success feedback for this topic
        """
        return pulumi.get(self, "sqs_success_feedback_role_arn")

    @sqs_success_feedback_role_arn.setter
    def sqs_success_feedback_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sqs_success_feedback_role_arn", value)

    @property
    @pulumi.getter(name="sqsSuccessFeedbackSampleRate")
    def sqs_success_feedback_sample_rate(self) -> Optional[pulumi.Input[int]]:
        """
        Percentage of success to sample
        """
        return pulumi.get(self, "sqs_success_feedback_sample_rate")

    @sqs_success_feedback_sample_rate.setter
    def sqs_success_feedback_sample_rate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sqs_success_feedback_sample_rate", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of resource tags. .If configured with a provider `defaultTags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider .
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)


@pulumi.input_type
class _TopicState:
    def __init__(__self__, *,
                 application_failure_feedback_role_arn: Optional[pulumi.Input[str]] = None,
                 application_success_feedback_role_arn: Optional[pulumi.Input[str]] = None,
                 application_success_feedback_sample_rate: Optional[pulumi.Input[int]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 content_based_deduplication: Optional[pulumi.Input[bool]] = None,
                 delivery_policy: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 fifo_topic: Optional[pulumi.Input[bool]] = None,
                 firehose_failure_feedback_role_arn: Optional[pulumi.Input[str]] = None,
                 firehose_success_feedback_role_arn: Optional[pulumi.Input[str]] = None,
                 firehose_success_feedback_sample_rate: Optional[pulumi.Input[int]] = None,
                 http_failure_feedback_role_arn: Optional[pulumi.Input[str]] = None,
                 http_success_feedback_role_arn: Optional[pulumi.Input[str]] = None,
                 http_success_feedback_sample_rate: Optional[pulumi.Input[int]] = None,
                 kms_master_key_id: Optional[pulumi.Input[str]] = None,
                 lambda_failure_feedback_role_arn: Optional[pulumi.Input[str]] = None,
                 lambda_success_feedback_role_arn: Optional[pulumi.Input[str]] = None,
                 lambda_success_feedback_sample_rate: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 owner: Optional[pulumi.Input[str]] = None,
                 policy: Optional[pulumi.Input[str]] = None,
                 sqs_failure_feedback_role_arn: Optional[pulumi.Input[str]] = None,
                 sqs_success_feedback_role_arn: Optional[pulumi.Input[str]] = None,
                 sqs_success_feedback_sample_rate: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering Topic resources.
        :param pulumi.Input[str] application_failure_feedback_role_arn: IAM role for failure feedback
        :param pulumi.Input[str] application_success_feedback_role_arn: The IAM role permitted to receive success feedback for this topic
        :param pulumi.Input[int] application_success_feedback_sample_rate: Percentage of success to sample
        :param pulumi.Input[str] arn: The ARN of the SNS topic, as a more obvious property (clone of id)
        :param pulumi.Input[bool] content_based_deduplication: Enables content-based deduplication for FIFO topics. For more information, see the [related documentation](https://docs.aws.amazon.com/sns/latest/dg/fifo-message-dedup.html)
        :param pulumi.Input[str] delivery_policy: The SNS delivery policy. More on [AWS documentation](https://docs.aws.amazon.com/sns/latest/dg/DeliveryPolicies.html)
        :param pulumi.Input[str] display_name: The display name for the topic
        :param pulumi.Input[bool] fifo_topic: Boolean indicating whether or not to create a FIFO (first-in-first-out) topic (default is `false`).
        :param pulumi.Input[str] firehose_failure_feedback_role_arn: IAM role for failure feedback
        :param pulumi.Input[str] firehose_success_feedback_role_arn: The IAM role permitted to receive success feedback for this topic
        :param pulumi.Input[int] firehose_success_feedback_sample_rate: Percentage of success to sample
        :param pulumi.Input[str] http_failure_feedback_role_arn: IAM role for failure feedback
        :param pulumi.Input[str] http_success_feedback_role_arn: The IAM role permitted to receive success feedback for this topic
        :param pulumi.Input[int] http_success_feedback_sample_rate: Percentage of success to sample
        :param pulumi.Input[str] kms_master_key_id: The ID of an AWS-managed customer master key (CMK) for Amazon SNS or a custom CMK. For more information, see [Key Terms](https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html#sse-key-terms)
        :param pulumi.Input[str] lambda_failure_feedback_role_arn: IAM role for failure feedback
        :param pulumi.Input[str] lambda_success_feedback_role_arn: The IAM role permitted to receive success feedback for this topic
        :param pulumi.Input[int] lambda_success_feedback_sample_rate: Percentage of success to sample
        :param pulumi.Input[str] name: The name of the topic. Topic names must be made up of only uppercase and lowercase ASCII letters, numbers, underscores, and hyphens, and must be between 1 and 256 characters long. For a FIFO (first-in-first-out) topic, the name must end with the `.fifo` suffix. If omitted, this provider will assign a random, unique name. Conflicts with `name_prefix`
        :param pulumi.Input[str] name_prefix: Creates a unique name beginning with the specified prefix. Conflicts with `name`
        :param pulumi.Input[str] owner: The AWS Account ID of the SNS topic owner
        :param pulumi.Input[str] policy: The fully-formed AWS policy as JSON.
        :param pulumi.Input[str] sqs_failure_feedback_role_arn: IAM role for failure feedback
        :param pulumi.Input[str] sqs_success_feedback_role_arn: The IAM role permitted to receive success feedback for this topic
        :param pulumi.Input[int] sqs_success_feedback_sample_rate: Percentage of success to sample
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. .If configured with a provider `defaultTags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider .
        """
        if application_failure_feedback_role_arn is not None:
            pulumi.set(__self__, "application_failure_feedback_role_arn", application_failure_feedback_role_arn)
        if application_success_feedback_role_arn is not None:
            pulumi.set(__self__, "application_success_feedback_role_arn", application_success_feedback_role_arn)
        if application_success_feedback_sample_rate is not None:
            pulumi.set(__self__, "application_success_feedback_sample_rate", application_success_feedback_sample_rate)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if content_based_deduplication is not None:
            pulumi.set(__self__, "content_based_deduplication", content_based_deduplication)
        if delivery_policy is not None:
            pulumi.set(__self__, "delivery_policy", delivery_policy)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if fifo_topic is not None:
            pulumi.set(__self__, "fifo_topic", fifo_topic)
        if firehose_failure_feedback_role_arn is not None:
            pulumi.set(__self__, "firehose_failure_feedback_role_arn", firehose_failure_feedback_role_arn)
        if firehose_success_feedback_role_arn is not None:
            pulumi.set(__self__, "firehose_success_feedback_role_arn", firehose_success_feedback_role_arn)
        if firehose_success_feedback_sample_rate is not None:
            pulumi.set(__self__, "firehose_success_feedback_sample_rate", firehose_success_feedback_sample_rate)
        if http_failure_feedback_role_arn is not None:
            pulumi.set(__self__, "http_failure_feedback_role_arn", http_failure_feedback_role_arn)
        if http_success_feedback_role_arn is not None:
            pulumi.set(__self__, "http_success_feedback_role_arn", http_success_feedback_role_arn)
        if http_success_feedback_sample_rate is not None:
            pulumi.set(__self__, "http_success_feedback_sample_rate", http_success_feedback_sample_rate)
        if kms_master_key_id is not None:
            pulumi.set(__self__, "kms_master_key_id", kms_master_key_id)
        if lambda_failure_feedback_role_arn is not None:
            pulumi.set(__self__, "lambda_failure_feedback_role_arn", lambda_failure_feedback_role_arn)
        if lambda_success_feedback_role_arn is not None:
            pulumi.set(__self__, "lambda_success_feedback_role_arn", lambda_success_feedback_role_arn)
        if lambda_success_feedback_sample_rate is not None:
            pulumi.set(__self__, "lambda_success_feedback_sample_rate", lambda_success_feedback_sample_rate)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if sqs_failure_feedback_role_arn is not None:
            pulumi.set(__self__, "sqs_failure_feedback_role_arn", sqs_failure_feedback_role_arn)
        if sqs_success_feedback_role_arn is not None:
            pulumi.set(__self__, "sqs_success_feedback_role_arn", sqs_success_feedback_role_arn)
        if sqs_success_feedback_sample_rate is not None:
            pulumi.set(__self__, "sqs_success_feedback_sample_rate", sqs_success_feedback_sample_rate)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @property
    @pulumi.getter(name="applicationFailureFeedbackRoleArn")
    def application_failure_feedback_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        IAM role for failure feedback
        """
        return pulumi.get(self, "application_failure_feedback_role_arn")

    @application_failure_feedback_role_arn.setter
    def application_failure_feedback_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_failure_feedback_role_arn", value)

    @property
    @pulumi.getter(name="applicationSuccessFeedbackRoleArn")
    def application_success_feedback_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The IAM role permitted to receive success feedback for this topic
        """
        return pulumi.get(self, "application_success_feedback_role_arn")

    @application_success_feedback_role_arn.setter
    def application_success_feedback_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_success_feedback_role_arn", value)

    @property
    @pulumi.getter(name="applicationSuccessFeedbackSampleRate")
    def application_success_feedback_sample_rate(self) -> Optional[pulumi.Input[int]]:
        """
        Percentage of success to sample
        """
        return pulumi.get(self, "application_success_feedback_sample_rate")

    @application_success_feedback_sample_rate.setter
    def application_success_feedback_sample_rate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "application_success_feedback_sample_rate", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the SNS topic, as a more obvious property (clone of id)
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="contentBasedDeduplication")
    def content_based_deduplication(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables content-based deduplication for FIFO topics. For more information, see the [related documentation](https://docs.aws.amazon.com/sns/latest/dg/fifo-message-dedup.html)
        """
        return pulumi.get(self, "content_based_deduplication")

    @content_based_deduplication.setter
    def content_based_deduplication(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "content_based_deduplication", value)

    @property
    @pulumi.getter(name="deliveryPolicy")
    def delivery_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The SNS delivery policy. More on [AWS documentation](https://docs.aws.amazon.com/sns/latest/dg/DeliveryPolicies.html)
        """
        return pulumi.get(self, "delivery_policy")

    @delivery_policy.setter
    def delivery_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delivery_policy", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name for the topic
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="fifoTopic")
    def fifo_topic(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean indicating whether or not to create a FIFO (first-in-first-out) topic (default is `false`).
        """
        return pulumi.get(self, "fifo_topic")

    @fifo_topic.setter
    def fifo_topic(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "fifo_topic", value)

    @property
    @pulumi.getter(name="firehoseFailureFeedbackRoleArn")
    def firehose_failure_feedback_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        IAM role for failure feedback
        """
        return pulumi.get(self, "firehose_failure_feedback_role_arn")

    @firehose_failure_feedback_role_arn.setter
    def firehose_failure_feedback_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "firehose_failure_feedback_role_arn", value)

    @property
    @pulumi.getter(name="firehoseSuccessFeedbackRoleArn")
    def firehose_success_feedback_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The IAM role permitted to receive success feedback for this topic
        """
        return pulumi.get(self, "firehose_success_feedback_role_arn")

    @firehose_success_feedback_role_arn.setter
    def firehose_success_feedback_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "firehose_success_feedback_role_arn", value)

    @property
    @pulumi.getter(name="firehoseSuccessFeedbackSampleRate")
    def firehose_success_feedback_sample_rate(self) -> Optional[pulumi.Input[int]]:
        """
        Percentage of success to sample
        """
        return pulumi.get(self, "firehose_success_feedback_sample_rate")

    @firehose_success_feedback_sample_rate.setter
    def firehose_success_feedback_sample_rate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "firehose_success_feedback_sample_rate", value)

    @property
    @pulumi.getter(name="httpFailureFeedbackRoleArn")
    def http_failure_feedback_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        IAM role for failure feedback
        """
        return pulumi.get(self, "http_failure_feedback_role_arn")

    @http_failure_feedback_role_arn.setter
    def http_failure_feedback_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_failure_feedback_role_arn", value)

    @property
    @pulumi.getter(name="httpSuccessFeedbackRoleArn")
    def http_success_feedback_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The IAM role permitted to receive success feedback for this topic
        """
        return pulumi.get(self, "http_success_feedback_role_arn")

    @http_success_feedback_role_arn.setter
    def http_success_feedback_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_success_feedback_role_arn", value)

    @property
    @pulumi.getter(name="httpSuccessFeedbackSampleRate")
    def http_success_feedback_sample_rate(self) -> Optional[pulumi.Input[int]]:
        """
        Percentage of success to sample
        """
        return pulumi.get(self, "http_success_feedback_sample_rate")

    @http_success_feedback_sample_rate.setter
    def http_success_feedback_sample_rate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "http_success_feedback_sample_rate", value)

    @property
    @pulumi.getter(name="kmsMasterKeyId")
    def kms_master_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of an AWS-managed customer master key (CMK) for Amazon SNS or a custom CMK. For more information, see [Key Terms](https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html#sse-key-terms)
        """
        return pulumi.get(self, "kms_master_key_id")

    @kms_master_key_id.setter
    def kms_master_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_master_key_id", value)

    @property
    @pulumi.getter(name="lambdaFailureFeedbackRoleArn")
    def lambda_failure_feedback_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        IAM role for failure feedback
        """
        return pulumi.get(self, "lambda_failure_feedback_role_arn")

    @lambda_failure_feedback_role_arn.setter
    def lambda_failure_feedback_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lambda_failure_feedback_role_arn", value)

    @property
    @pulumi.getter(name="lambdaSuccessFeedbackRoleArn")
    def lambda_success_feedback_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The IAM role permitted to receive success feedback for this topic
        """
        return pulumi.get(self, "lambda_success_feedback_role_arn")

    @lambda_success_feedback_role_arn.setter
    def lambda_success_feedback_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lambda_success_feedback_role_arn", value)

    @property
    @pulumi.getter(name="lambdaSuccessFeedbackSampleRate")
    def lambda_success_feedback_sample_rate(self) -> Optional[pulumi.Input[int]]:
        """
        Percentage of success to sample
        """
        return pulumi.get(self, "lambda_success_feedback_sample_rate")

    @lambda_success_feedback_sample_rate.setter
    def lambda_success_feedback_sample_rate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "lambda_success_feedback_sample_rate", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the topic. Topic names must be made up of only uppercase and lowercase ASCII letters, numbers, underscores, and hyphens, and must be between 1 and 256 characters long. For a FIFO (first-in-first-out) topic, the name must end with the `.fifo` suffix. If omitted, this provider will assign a random, unique name. Conflicts with `name_prefix`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Creates a unique name beginning with the specified prefix. Conflicts with `name`
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_prefix", value)

    @property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS Account ID of the SNS topic owner
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[str]]:
        """
        The fully-formed AWS policy as JSON.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter(name="sqsFailureFeedbackRoleArn")
    def sqs_failure_feedback_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        IAM role for failure feedback
        """
        return pulumi.get(self, "sqs_failure_feedback_role_arn")

    @sqs_failure_feedback_role_arn.setter
    def sqs_failure_feedback_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sqs_failure_feedback_role_arn", value)

    @property
    @pulumi.getter(name="sqsSuccessFeedbackRoleArn")
    def sqs_success_feedback_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The IAM role permitted to receive success feedback for this topic
        """
        return pulumi.get(self, "sqs_success_feedback_role_arn")

    @sqs_success_feedback_role_arn.setter
    def sqs_success_feedback_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sqs_success_feedback_role_arn", value)

    @property
    @pulumi.getter(name="sqsSuccessFeedbackSampleRate")
    def sqs_success_feedback_sample_rate(self) -> Optional[pulumi.Input[int]]:
        """
        Percentage of success to sample
        """
        return pulumi.get(self, "sqs_success_feedback_sample_rate")

    @sqs_success_feedback_sample_rate.setter
    def sqs_success_feedback_sample_rate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sqs_success_feedback_sample_rate", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of resource tags. .If configured with a provider `defaultTags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider .
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)


class Topic(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_failure_feedback_role_arn: Optional[pulumi.Input[str]] = None,
                 application_success_feedback_role_arn: Optional[pulumi.Input[str]] = None,
                 application_success_feedback_sample_rate: Optional[pulumi.Input[int]] = None,
                 content_based_deduplication: Optional[pulumi.Input[bool]] = None,
                 delivery_policy: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 fifo_topic: Optional[pulumi.Input[bool]] = None,
                 firehose_failure_feedback_role_arn: Optional[pulumi.Input[str]] = None,
                 firehose_success_feedback_role_arn: Optional[pulumi.Input[str]] = None,
                 firehose_success_feedback_sample_rate: Optional[pulumi.Input[int]] = None,
                 http_failure_feedback_role_arn: Optional[pulumi.Input[str]] = None,
                 http_success_feedback_role_arn: Optional[pulumi.Input[str]] = None,
                 http_success_feedback_sample_rate: Optional[pulumi.Input[int]] = None,
                 kms_master_key_id: Optional[pulumi.Input[str]] = None,
                 lambda_failure_feedback_role_arn: Optional[pulumi.Input[str]] = None,
                 lambda_success_feedback_role_arn: Optional[pulumi.Input[str]] = None,
                 lambda_success_feedback_sample_rate: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 policy: Optional[pulumi.Input[str]] = None,
                 sqs_failure_feedback_role_arn: Optional[pulumi.Input[str]] = None,
                 sqs_success_feedback_role_arn: Optional[pulumi.Input[str]] = None,
                 sqs_success_feedback_sample_rate: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Provides an SNS topic resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        user_updates = aws.sns.Topic("userUpdates")
        ```
        ## Example with Delivery Policy

        ```python
        import pulumi
        import pulumi_aws as aws

        user_updates = aws.sns.Topic("userUpdates", delivery_policy=\"\"\"{
          "http": {
            "defaultHealthyRetryPolicy": {
              "minDelayTarget": 20,
              "maxDelayTarget": 20,
              "numRetries": 3,
              "numMaxDelayRetries": 0,
              "numNoDelayRetries": 0,
              "numMinDelayRetries": 0,
              "backoffFunction": "linear"
            },
            "disableSubscriptionOverrides": false,
            "defaultThrottlePolicy": {
              "maxReceivesPerSecond": 1
            }
          }
        }

        \"\"\")
        ```

        ## Example with Server-side encryption (SSE)

        ```python
        import pulumi
        import pulumi_aws as aws

        user_updates = aws.sns.Topic("userUpdates", kms_master_key_id="alias/aws/sns")
        ```

        ## Example with First-In-First-Out (FIFO)

        ```python
        import pulumi
        import pulumi_aws as aws

        user_updates = aws.sns.Topic("userUpdates",
            content_based_deduplication=True,
            fifo_topic=True)
        ```

        ## Message Delivery Status Arguments

        The `<endpoint>_success_feedback_role_arn` and `<endpoint>_failure_feedback_role_arn` arguments are used to give Amazon SNS write access to use CloudWatch Logs on your behalf. The `<endpoint>_success_feedback_sample_rate` argument is for specifying the sample rate percentage (0-100) of successfully delivered messages. After you configure the  `<endpoint>_failure_feedback_role_arn` argument, then all failed message deliveries generate CloudWatch Logs.

        ## Import

        SNS Topics can be imported using the `topic arn`, e.g.

        ```sh
         $ pulumi import aws:sns/topic:Topic user_updates arn:aws:sns:us-west-2:0123456789012:my-topic
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_failure_feedback_role_arn: IAM role for failure feedback
        :param pulumi.Input[str] application_success_feedback_role_arn: The IAM role permitted to receive success feedback for this topic
        :param pulumi.Input[int] application_success_feedback_sample_rate: Percentage of success to sample
        :param pulumi.Input[bool] content_based_deduplication: Enables content-based deduplication for FIFO topics. For more information, see the [related documentation](https://docs.aws.amazon.com/sns/latest/dg/fifo-message-dedup.html)
        :param pulumi.Input[str] delivery_policy: The SNS delivery policy. More on [AWS documentation](https://docs.aws.amazon.com/sns/latest/dg/DeliveryPolicies.html)
        :param pulumi.Input[str] display_name: The display name for the topic
        :param pulumi.Input[bool] fifo_topic: Boolean indicating whether or not to create a FIFO (first-in-first-out) topic (default is `false`).
        :param pulumi.Input[str] firehose_failure_feedback_role_arn: IAM role for failure feedback
        :param pulumi.Input[str] firehose_success_feedback_role_arn: The IAM role permitted to receive success feedback for this topic
        :param pulumi.Input[int] firehose_success_feedback_sample_rate: Percentage of success to sample
        :param pulumi.Input[str] http_failure_feedback_role_arn: IAM role for failure feedback
        :param pulumi.Input[str] http_success_feedback_role_arn: The IAM role permitted to receive success feedback for this topic
        :param pulumi.Input[int] http_success_feedback_sample_rate: Percentage of success to sample
        :param pulumi.Input[str] kms_master_key_id: The ID of an AWS-managed customer master key (CMK) for Amazon SNS or a custom CMK. For more information, see [Key Terms](https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html#sse-key-terms)
        :param pulumi.Input[str] lambda_failure_feedback_role_arn: IAM role for failure feedback
        :param pulumi.Input[str] lambda_success_feedback_role_arn: The IAM role permitted to receive success feedback for this topic
        :param pulumi.Input[int] lambda_success_feedback_sample_rate: Percentage of success to sample
        :param pulumi.Input[str] name: The name of the topic. Topic names must be made up of only uppercase and lowercase ASCII letters, numbers, underscores, and hyphens, and must be between 1 and 256 characters long. For a FIFO (first-in-first-out) topic, the name must end with the `.fifo` suffix. If omitted, this provider will assign a random, unique name. Conflicts with `name_prefix`
        :param pulumi.Input[str] name_prefix: Creates a unique name beginning with the specified prefix. Conflicts with `name`
        :param pulumi.Input[str] policy: The fully-formed AWS policy as JSON.
        :param pulumi.Input[str] sqs_failure_feedback_role_arn: IAM role for failure feedback
        :param pulumi.Input[str] sqs_success_feedback_role_arn: The IAM role permitted to receive success feedback for this topic
        :param pulumi.Input[int] sqs_success_feedback_sample_rate: Percentage of success to sample
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. .If configured with a provider `defaultTags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider .
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[TopicArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an SNS topic resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        user_updates = aws.sns.Topic("userUpdates")
        ```
        ## Example with Delivery Policy

        ```python
        import pulumi
        import pulumi_aws as aws

        user_updates = aws.sns.Topic("userUpdates", delivery_policy=\"\"\"{
          "http": {
            "defaultHealthyRetryPolicy": {
              "minDelayTarget": 20,
              "maxDelayTarget": 20,
              "numRetries": 3,
              "numMaxDelayRetries": 0,
              "numNoDelayRetries": 0,
              "numMinDelayRetries": 0,
              "backoffFunction": "linear"
            },
            "disableSubscriptionOverrides": false,
            "defaultThrottlePolicy": {
              "maxReceivesPerSecond": 1
            }
          }
        }

        \"\"\")
        ```

        ## Example with Server-side encryption (SSE)

        ```python
        import pulumi
        import pulumi_aws as aws

        user_updates = aws.sns.Topic("userUpdates", kms_master_key_id="alias/aws/sns")
        ```

        ## Example with First-In-First-Out (FIFO)

        ```python
        import pulumi
        import pulumi_aws as aws

        user_updates = aws.sns.Topic("userUpdates",
            content_based_deduplication=True,
            fifo_topic=True)
        ```

        ## Message Delivery Status Arguments

        The `<endpoint>_success_feedback_role_arn` and `<endpoint>_failure_feedback_role_arn` arguments are used to give Amazon SNS write access to use CloudWatch Logs on your behalf. The `<endpoint>_success_feedback_sample_rate` argument is for specifying the sample rate percentage (0-100) of successfully delivered messages. After you configure the  `<endpoint>_failure_feedback_role_arn` argument, then all failed message deliveries generate CloudWatch Logs.

        ## Import

        SNS Topics can be imported using the `topic arn`, e.g.

        ```sh
         $ pulumi import aws:sns/topic:Topic user_updates arn:aws:sns:us-west-2:0123456789012:my-topic
        ```

        :param str resource_name: The name of the resource.
        :param TopicArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TopicArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_failure_feedback_role_arn: Optional[pulumi.Input[str]] = None,
                 application_success_feedback_role_arn: Optional[pulumi.Input[str]] = None,
                 application_success_feedback_sample_rate: Optional[pulumi.Input[int]] = None,
                 content_based_deduplication: Optional[pulumi.Input[bool]] = None,
                 delivery_policy: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 fifo_topic: Optional[pulumi.Input[bool]] = None,
                 firehose_failure_feedback_role_arn: Optional[pulumi.Input[str]] = None,
                 firehose_success_feedback_role_arn: Optional[pulumi.Input[str]] = None,
                 firehose_success_feedback_sample_rate: Optional[pulumi.Input[int]] = None,
                 http_failure_feedback_role_arn: Optional[pulumi.Input[str]] = None,
                 http_success_feedback_role_arn: Optional[pulumi.Input[str]] = None,
                 http_success_feedback_sample_rate: Optional[pulumi.Input[int]] = None,
                 kms_master_key_id: Optional[pulumi.Input[str]] = None,
                 lambda_failure_feedback_role_arn: Optional[pulumi.Input[str]] = None,
                 lambda_success_feedback_role_arn: Optional[pulumi.Input[str]] = None,
                 lambda_success_feedback_sample_rate: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 policy: Optional[pulumi.Input[str]] = None,
                 sqs_failure_feedback_role_arn: Optional[pulumi.Input[str]] = None,
                 sqs_success_feedback_role_arn: Optional[pulumi.Input[str]] = None,
                 sqs_success_feedback_sample_rate: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TopicArgs.__new__(TopicArgs)

            __props__.__dict__["application_failure_feedback_role_arn"] = application_failure_feedback_role_arn
            __props__.__dict__["application_success_feedback_role_arn"] = application_success_feedback_role_arn
            __props__.__dict__["application_success_feedback_sample_rate"] = application_success_feedback_sample_rate
            __props__.__dict__["content_based_deduplication"] = content_based_deduplication
            __props__.__dict__["delivery_policy"] = delivery_policy
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["fifo_topic"] = fifo_topic
            __props__.__dict__["firehose_failure_feedback_role_arn"] = firehose_failure_feedback_role_arn
            __props__.__dict__["firehose_success_feedback_role_arn"] = firehose_success_feedback_role_arn
            __props__.__dict__["firehose_success_feedback_sample_rate"] = firehose_success_feedback_sample_rate
            __props__.__dict__["http_failure_feedback_role_arn"] = http_failure_feedback_role_arn
            __props__.__dict__["http_success_feedback_role_arn"] = http_success_feedback_role_arn
            __props__.__dict__["http_success_feedback_sample_rate"] = http_success_feedback_sample_rate
            __props__.__dict__["kms_master_key_id"] = kms_master_key_id
            __props__.__dict__["lambda_failure_feedback_role_arn"] = lambda_failure_feedback_role_arn
            __props__.__dict__["lambda_success_feedback_role_arn"] = lambda_success_feedback_role_arn
            __props__.__dict__["lambda_success_feedback_sample_rate"] = lambda_success_feedback_sample_rate
            __props__.__dict__["name"] = name
            __props__.__dict__["name_prefix"] = name_prefix
            __props__.__dict__["policy"] = policy
            __props__.__dict__["sqs_failure_feedback_role_arn"] = sqs_failure_feedback_role_arn
            __props__.__dict__["sqs_success_feedback_role_arn"] = sqs_success_feedback_role_arn
            __props__.__dict__["sqs_success_feedback_sample_rate"] = sqs_success_feedback_sample_rate
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tags_all"] = tags_all
            __props__.__dict__["arn"] = None
            __props__.__dict__["owner"] = None
        super(Topic, __self__).__init__(
            'aws:sns/topic:Topic',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_failure_feedback_role_arn: Optional[pulumi.Input[str]] = None,
            application_success_feedback_role_arn: Optional[pulumi.Input[str]] = None,
            application_success_feedback_sample_rate: Optional[pulumi.Input[int]] = None,
            arn: Optional[pulumi.Input[str]] = None,
            content_based_deduplication: Optional[pulumi.Input[bool]] = None,
            delivery_policy: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            fifo_topic: Optional[pulumi.Input[bool]] = None,
            firehose_failure_feedback_role_arn: Optional[pulumi.Input[str]] = None,
            firehose_success_feedback_role_arn: Optional[pulumi.Input[str]] = None,
            firehose_success_feedback_sample_rate: Optional[pulumi.Input[int]] = None,
            http_failure_feedback_role_arn: Optional[pulumi.Input[str]] = None,
            http_success_feedback_role_arn: Optional[pulumi.Input[str]] = None,
            http_success_feedback_sample_rate: Optional[pulumi.Input[int]] = None,
            kms_master_key_id: Optional[pulumi.Input[str]] = None,
            lambda_failure_feedback_role_arn: Optional[pulumi.Input[str]] = None,
            lambda_success_feedback_role_arn: Optional[pulumi.Input[str]] = None,
            lambda_success_feedback_sample_rate: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            name_prefix: Optional[pulumi.Input[str]] = None,
            owner: Optional[pulumi.Input[str]] = None,
            policy: Optional[pulumi.Input[str]] = None,
            sqs_failure_feedback_role_arn: Optional[pulumi.Input[str]] = None,
            sqs_success_feedback_role_arn: Optional[pulumi.Input[str]] = None,
            sqs_success_feedback_sample_rate: Optional[pulumi.Input[int]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None) -> 'Topic':
        """
        Get an existing Topic resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_failure_feedback_role_arn: IAM role for failure feedback
        :param pulumi.Input[str] application_success_feedback_role_arn: The IAM role permitted to receive success feedback for this topic
        :param pulumi.Input[int] application_success_feedback_sample_rate: Percentage of success to sample
        :param pulumi.Input[str] arn: The ARN of the SNS topic, as a more obvious property (clone of id)
        :param pulumi.Input[bool] content_based_deduplication: Enables content-based deduplication for FIFO topics. For more information, see the [related documentation](https://docs.aws.amazon.com/sns/latest/dg/fifo-message-dedup.html)
        :param pulumi.Input[str] delivery_policy: The SNS delivery policy. More on [AWS documentation](https://docs.aws.amazon.com/sns/latest/dg/DeliveryPolicies.html)
        :param pulumi.Input[str] display_name: The display name for the topic
        :param pulumi.Input[bool] fifo_topic: Boolean indicating whether or not to create a FIFO (first-in-first-out) topic (default is `false`).
        :param pulumi.Input[str] firehose_failure_feedback_role_arn: IAM role for failure feedback
        :param pulumi.Input[str] firehose_success_feedback_role_arn: The IAM role permitted to receive success feedback for this topic
        :param pulumi.Input[int] firehose_success_feedback_sample_rate: Percentage of success to sample
        :param pulumi.Input[str] http_failure_feedback_role_arn: IAM role for failure feedback
        :param pulumi.Input[str] http_success_feedback_role_arn: The IAM role permitted to receive success feedback for this topic
        :param pulumi.Input[int] http_success_feedback_sample_rate: Percentage of success to sample
        :param pulumi.Input[str] kms_master_key_id: The ID of an AWS-managed customer master key (CMK) for Amazon SNS or a custom CMK. For more information, see [Key Terms](https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html#sse-key-terms)
        :param pulumi.Input[str] lambda_failure_feedback_role_arn: IAM role for failure feedback
        :param pulumi.Input[str] lambda_success_feedback_role_arn: The IAM role permitted to receive success feedback for this topic
        :param pulumi.Input[int] lambda_success_feedback_sample_rate: Percentage of success to sample
        :param pulumi.Input[str] name: The name of the topic. Topic names must be made up of only uppercase and lowercase ASCII letters, numbers, underscores, and hyphens, and must be between 1 and 256 characters long. For a FIFO (first-in-first-out) topic, the name must end with the `.fifo` suffix. If omitted, this provider will assign a random, unique name. Conflicts with `name_prefix`
        :param pulumi.Input[str] name_prefix: Creates a unique name beginning with the specified prefix. Conflicts with `name`
        :param pulumi.Input[str] owner: The AWS Account ID of the SNS topic owner
        :param pulumi.Input[str] policy: The fully-formed AWS policy as JSON.
        :param pulumi.Input[str] sqs_failure_feedback_role_arn: IAM role for failure feedback
        :param pulumi.Input[str] sqs_success_feedback_role_arn: The IAM role permitted to receive success feedback for this topic
        :param pulumi.Input[int] sqs_success_feedback_sample_rate: Percentage of success to sample
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. .If configured with a provider `defaultTags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider .
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TopicState.__new__(_TopicState)

        __props__.__dict__["application_failure_feedback_role_arn"] = application_failure_feedback_role_arn
        __props__.__dict__["application_success_feedback_role_arn"] = application_success_feedback_role_arn
        __props__.__dict__["application_success_feedback_sample_rate"] = application_success_feedback_sample_rate
        __props__.__dict__["arn"] = arn
        __props__.__dict__["content_based_deduplication"] = content_based_deduplication
        __props__.__dict__["delivery_policy"] = delivery_policy
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["fifo_topic"] = fifo_topic
        __props__.__dict__["firehose_failure_feedback_role_arn"] = firehose_failure_feedback_role_arn
        __props__.__dict__["firehose_success_feedback_role_arn"] = firehose_success_feedback_role_arn
        __props__.__dict__["firehose_success_feedback_sample_rate"] = firehose_success_feedback_sample_rate
        __props__.__dict__["http_failure_feedback_role_arn"] = http_failure_feedback_role_arn
        __props__.__dict__["http_success_feedback_role_arn"] = http_success_feedback_role_arn
        __props__.__dict__["http_success_feedback_sample_rate"] = http_success_feedback_sample_rate
        __props__.__dict__["kms_master_key_id"] = kms_master_key_id
        __props__.__dict__["lambda_failure_feedback_role_arn"] = lambda_failure_feedback_role_arn
        __props__.__dict__["lambda_success_feedback_role_arn"] = lambda_success_feedback_role_arn
        __props__.__dict__["lambda_success_feedback_sample_rate"] = lambda_success_feedback_sample_rate
        __props__.__dict__["name"] = name
        __props__.__dict__["name_prefix"] = name_prefix
        __props__.__dict__["owner"] = owner
        __props__.__dict__["policy"] = policy
        __props__.__dict__["sqs_failure_feedback_role_arn"] = sqs_failure_feedback_role_arn
        __props__.__dict__["sqs_success_feedback_role_arn"] = sqs_success_feedback_role_arn
        __props__.__dict__["sqs_success_feedback_sample_rate"] = sqs_success_feedback_sample_rate
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return Topic(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationFailureFeedbackRoleArn")
    def application_failure_feedback_role_arn(self) -> pulumi.Output[Optional[str]]:
        """
        IAM role for failure feedback
        """
        return pulumi.get(self, "application_failure_feedback_role_arn")

    @property
    @pulumi.getter(name="applicationSuccessFeedbackRoleArn")
    def application_success_feedback_role_arn(self) -> pulumi.Output[Optional[str]]:
        """
        The IAM role permitted to receive success feedback for this topic
        """
        return pulumi.get(self, "application_success_feedback_role_arn")

    @property
    @pulumi.getter(name="applicationSuccessFeedbackSampleRate")
    def application_success_feedback_sample_rate(self) -> pulumi.Output[Optional[int]]:
        """
        Percentage of success to sample
        """
        return pulumi.get(self, "application_success_feedback_sample_rate")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the SNS topic, as a more obvious property (clone of id)
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="contentBasedDeduplication")
    def content_based_deduplication(self) -> pulumi.Output[Optional[bool]]:
        """
        Enables content-based deduplication for FIFO topics. For more information, see the [related documentation](https://docs.aws.amazon.com/sns/latest/dg/fifo-message-dedup.html)
        """
        return pulumi.get(self, "content_based_deduplication")

    @property
    @pulumi.getter(name="deliveryPolicy")
    def delivery_policy(self) -> pulumi.Output[Optional[str]]:
        """
        The SNS delivery policy. More on [AWS documentation](https://docs.aws.amazon.com/sns/latest/dg/DeliveryPolicies.html)
        """
        return pulumi.get(self, "delivery_policy")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[str]]:
        """
        The display name for the topic
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="fifoTopic")
    def fifo_topic(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean indicating whether or not to create a FIFO (first-in-first-out) topic (default is `false`).
        """
        return pulumi.get(self, "fifo_topic")

    @property
    @pulumi.getter(name="firehoseFailureFeedbackRoleArn")
    def firehose_failure_feedback_role_arn(self) -> pulumi.Output[Optional[str]]:
        """
        IAM role for failure feedback
        """
        return pulumi.get(self, "firehose_failure_feedback_role_arn")

    @property
    @pulumi.getter(name="firehoseSuccessFeedbackRoleArn")
    def firehose_success_feedback_role_arn(self) -> pulumi.Output[Optional[str]]:
        """
        The IAM role permitted to receive success feedback for this topic
        """
        return pulumi.get(self, "firehose_success_feedback_role_arn")

    @property
    @pulumi.getter(name="firehoseSuccessFeedbackSampleRate")
    def firehose_success_feedback_sample_rate(self) -> pulumi.Output[Optional[int]]:
        """
        Percentage of success to sample
        """
        return pulumi.get(self, "firehose_success_feedback_sample_rate")

    @property
    @pulumi.getter(name="httpFailureFeedbackRoleArn")
    def http_failure_feedback_role_arn(self) -> pulumi.Output[Optional[str]]:
        """
        IAM role for failure feedback
        """
        return pulumi.get(self, "http_failure_feedback_role_arn")

    @property
    @pulumi.getter(name="httpSuccessFeedbackRoleArn")
    def http_success_feedback_role_arn(self) -> pulumi.Output[Optional[str]]:
        """
        The IAM role permitted to receive success feedback for this topic
        """
        return pulumi.get(self, "http_success_feedback_role_arn")

    @property
    @pulumi.getter(name="httpSuccessFeedbackSampleRate")
    def http_success_feedback_sample_rate(self) -> pulumi.Output[Optional[int]]:
        """
        Percentage of success to sample
        """
        return pulumi.get(self, "http_success_feedback_sample_rate")

    @property
    @pulumi.getter(name="kmsMasterKeyId")
    def kms_master_key_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of an AWS-managed customer master key (CMK) for Amazon SNS or a custom CMK. For more information, see [Key Terms](https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html#sse-key-terms)
        """
        return pulumi.get(self, "kms_master_key_id")

    @property
    @pulumi.getter(name="lambdaFailureFeedbackRoleArn")
    def lambda_failure_feedback_role_arn(self) -> pulumi.Output[Optional[str]]:
        """
        IAM role for failure feedback
        """
        return pulumi.get(self, "lambda_failure_feedback_role_arn")

    @property
    @pulumi.getter(name="lambdaSuccessFeedbackRoleArn")
    def lambda_success_feedback_role_arn(self) -> pulumi.Output[Optional[str]]:
        """
        The IAM role permitted to receive success feedback for this topic
        """
        return pulumi.get(self, "lambda_success_feedback_role_arn")

    @property
    @pulumi.getter(name="lambdaSuccessFeedbackSampleRate")
    def lambda_success_feedback_sample_rate(self) -> pulumi.Output[Optional[int]]:
        """
        Percentage of success to sample
        """
        return pulumi.get(self, "lambda_success_feedback_sample_rate")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the topic. Topic names must be made up of only uppercase and lowercase ASCII letters, numbers, underscores, and hyphens, and must be between 1 and 256 characters long. For a FIFO (first-in-first-out) topic, the name must end with the `.fifo` suffix. If omitted, this provider will assign a random, unique name. Conflicts with `name_prefix`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> pulumi.Output[str]:
        """
        Creates a unique name beginning with the specified prefix. Conflicts with `name`
        """
        return pulumi.get(self, "name_prefix")

    @property
    @pulumi.getter
    def owner(self) -> pulumi.Output[str]:
        """
        The AWS Account ID of the SNS topic owner
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter
    def policy(self) -> pulumi.Output[str]:
        """
        The fully-formed AWS policy as JSON.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter(name="sqsFailureFeedbackRoleArn")
    def sqs_failure_feedback_role_arn(self) -> pulumi.Output[Optional[str]]:
        """
        IAM role for failure feedback
        """
        return pulumi.get(self, "sqs_failure_feedback_role_arn")

    @property
    @pulumi.getter(name="sqsSuccessFeedbackRoleArn")
    def sqs_success_feedback_role_arn(self) -> pulumi.Output[Optional[str]]:
        """
        The IAM role permitted to receive success feedback for this topic
        """
        return pulumi.get(self, "sqs_success_feedback_role_arn")

    @property
    @pulumi.getter(name="sqsSuccessFeedbackSampleRate")
    def sqs_success_feedback_sample_rate(self) -> pulumi.Output[Optional[int]]:
        """
        Percentage of success to sample
        """
        return pulumi.get(self, "sqs_success_feedback_sample_rate")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Key-value map of resource tags. .If configured with a provider `defaultTags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider .
        """
        return pulumi.get(self, "tags_all")

