# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['TagOptionArgs', 'TagOption']

@pulumi.input_type
class TagOptionArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str],
                 active: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a TagOption resource.
        :param pulumi.Input[str] key: Tag option key.
        :param pulumi.Input[str] value: Tag option value.
        :param pulumi.Input[bool] active: Whether tag option is active. Default is `true`.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)
        if active is not None:
            pulumi.set(__self__, "active", active)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        Tag option key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Tag option value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether tag option is active. Default is `true`.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "active", value)


@pulumi.input_type
class _TagOptionState:
    def __init__(__self__, *,
                 active: Optional[pulumi.Input[bool]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 owner: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering TagOption resources.
        :param pulumi.Input[bool] active: Whether tag option is active. Default is `true`.
        :param pulumi.Input[str] key: Tag option key.
        :param pulumi.Input[str] value: Tag option value.
        """
        if active is not None:
            pulumi.set(__self__, "active", active)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether tag option is active. Default is `true`.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        Tag option key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Tag option value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


class TagOption(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[bool]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a Service Catalog Tag Option.

        ## Example Usage
        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.servicecatalog.TagOption("example",
            key="nyckel",
            value="värde")
        ```

        ## Import

        `aws_servicecatalog_tag_option` can be imported using the tag option ID, e.g.

        ```sh
         $ pulumi import aws:servicecatalog/tagOption:TagOption example tag-pjtvagohlyo3m
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] active: Whether tag option is active. Default is `true`.
        :param pulumi.Input[str] key: Tag option key.
        :param pulumi.Input[str] value: Tag option value.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TagOptionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Service Catalog Tag Option.

        ## Example Usage
        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.servicecatalog.TagOption("example",
            key="nyckel",
            value="värde")
        ```

        ## Import

        `aws_servicecatalog_tag_option` can be imported using the tag option ID, e.g.

        ```sh
         $ pulumi import aws:servicecatalog/tagOption:TagOption example tag-pjtvagohlyo3m
        ```

        :param str resource_name: The name of the resource.
        :param TagOptionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TagOptionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[bool]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TagOptionArgs.__new__(TagOptionArgs)

            __props__.__dict__["active"] = active
            if key is None and not opts.urn:
                raise TypeError("Missing required property 'key'")
            __props__.__dict__["key"] = key
            if value is None and not opts.urn:
                raise TypeError("Missing required property 'value'")
            __props__.__dict__["value"] = value
            __props__.__dict__["owner"] = None
        super(TagOption, __self__).__init__(
            'aws:servicecatalog/tagOption:TagOption',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active: Optional[pulumi.Input[bool]] = None,
            key: Optional[pulumi.Input[str]] = None,
            owner: Optional[pulumi.Input[str]] = None,
            value: Optional[pulumi.Input[str]] = None) -> 'TagOption':
        """
        Get an existing TagOption resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] active: Whether tag option is active. Default is `true`.
        :param pulumi.Input[str] key: Tag option key.
        :param pulumi.Input[str] value: Tag option value.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TagOptionState.__new__(_TagOptionState)

        __props__.__dict__["active"] = active
        __props__.__dict__["key"] = key
        __props__.__dict__["owner"] = owner
        __props__.__dict__["value"] = value
        return TagOption(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def active(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether tag option is active. Default is `true`.
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[str]:
        """
        Tag option key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def owner(self) -> pulumi.Output[str]:
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter
    def value(self) -> pulumi.Output[str]:
        """
        Tag option value.
        """
        return pulumi.get(self, "value")

