# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProvisionedProductArgs', 'ProvisionedProduct']

@pulumi.input_type
class ProvisionedProductArgs:
    def __init__(__self__, *,
                 accept_language: Optional[pulumi.Input[str]] = None,
                 ignore_errors: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notification_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 path_id: Optional[pulumi.Input[str]] = None,
                 path_name: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 product_name: Optional[pulumi.Input[str]] = None,
                 provisioning_artifact_id: Optional[pulumi.Input[str]] = None,
                 provisioning_artifact_name: Optional[pulumi.Input[str]] = None,
                 provisioning_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ProvisionedProductProvisioningParameterArgs']]]] = None,
                 retain_physical_resources: Optional[pulumi.Input[bool]] = None,
                 stack_set_provisioning_preferences: Optional[pulumi.Input['ProvisionedProductStackSetProvisioningPreferencesArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a ProvisionedProduct resource.
        :param pulumi.Input[str] accept_language: Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
        :param pulumi.Input[bool] ignore_errors: _Only applies to deleting._ If set to `true`, AWS Service Catalog stops managing the specified provisioned product even if it cannot delete the underlying resources. The default value is `false`.
        :param pulumi.Input[str] name: User-friendly name of the provisioned product.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] notification_arns: Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related events.
        :param pulumi.Input[str] path_id: Path identifier of the product. This value is optional if the product has a default path, and required if the product has more than one path. To list the paths for a product, use `servicecatalog.getLaunchPaths`. When required, you must provide `path_id` or `path_name`, but not both.
        :param pulumi.Input[str] path_name: Name of the path. You must provide `path_id` or `path_name`, but not both.
        :param pulumi.Input[str] product_id: Product identifier. For example, `prod-abcdzk7xy33qa`. You must provide `product_id` or `product_name`, but not both.
        :param pulumi.Input[str] product_name: Name of the product. You must provide `product_id` or `product_name`, but not both.
        :param pulumi.Input[str] provisioning_artifact_id: Identifier of the provisioning artifact. For example, `pa-4abcdjnxjj6ne`. You must provide the `provisioning_artifact_id` or `provisioning_artifact_name`, but not both.
        :param pulumi.Input[str] provisioning_artifact_name: Name of the provisioning artifact. You must provide the `provisioning_artifact_id` or `provisioning_artifact_name`, but not both.
        :param pulumi.Input[Sequence[pulumi.Input['ProvisionedProductProvisioningParameterArgs']]] provisioning_parameters: Configuration block with parameters specified by the administrator that are required for provisioning the product. See details below.
        :param pulumi.Input[bool] retain_physical_resources: _Only applies to deleting._ Whether to delete the Service Catalog provisioned product but leave the CloudFormation stack, stack set, or the underlying resources of the deleted provisioned product. The default value is `false`.
        :param pulumi.Input['ProvisionedProductStackSetProvisioningPreferencesArgs'] stack_set_provisioning_preferences: Configuration block with information about the provisioning preferences for a stack set. See details below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tags to apply to the provisioned product. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if accept_language is not None:
            pulumi.set(__self__, "accept_language", accept_language)
        if ignore_errors is not None:
            pulumi.set(__self__, "ignore_errors", ignore_errors)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notification_arns is not None:
            pulumi.set(__self__, "notification_arns", notification_arns)
        if path_id is not None:
            pulumi.set(__self__, "path_id", path_id)
        if path_name is not None:
            pulumi.set(__self__, "path_name", path_name)
        if product_id is not None:
            pulumi.set(__self__, "product_id", product_id)
        if product_name is not None:
            pulumi.set(__self__, "product_name", product_name)
        if provisioning_artifact_id is not None:
            pulumi.set(__self__, "provisioning_artifact_id", provisioning_artifact_id)
        if provisioning_artifact_name is not None:
            pulumi.set(__self__, "provisioning_artifact_name", provisioning_artifact_name)
        if provisioning_parameters is not None:
            pulumi.set(__self__, "provisioning_parameters", provisioning_parameters)
        if retain_physical_resources is not None:
            pulumi.set(__self__, "retain_physical_resources", retain_physical_resources)
        if stack_set_provisioning_preferences is not None:
            pulumi.set(__self__, "stack_set_provisioning_preferences", stack_set_provisioning_preferences)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @property
    @pulumi.getter(name="acceptLanguage")
    def accept_language(self) -> Optional[pulumi.Input[str]]:
        """
        Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
        """
        return pulumi.get(self, "accept_language")

    @accept_language.setter
    def accept_language(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "accept_language", value)

    @property
    @pulumi.getter(name="ignoreErrors")
    def ignore_errors(self) -> Optional[pulumi.Input[bool]]:
        """
        _Only applies to deleting._ If set to `true`, AWS Service Catalog stops managing the specified provisioned product even if it cannot delete the underlying resources. The default value is `false`.
        """
        return pulumi.get(self, "ignore_errors")

    @ignore_errors.setter
    def ignore_errors(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_errors", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        User-friendly name of the provisioned product.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="notificationArns")
    def notification_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related events.
        """
        return pulumi.get(self, "notification_arns")

    @notification_arns.setter
    def notification_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "notification_arns", value)

    @property
    @pulumi.getter(name="pathId")
    def path_id(self) -> Optional[pulumi.Input[str]]:
        """
        Path identifier of the product. This value is optional if the product has a default path, and required if the product has more than one path. To list the paths for a product, use `servicecatalog.getLaunchPaths`. When required, you must provide `path_id` or `path_name`, but not both.
        """
        return pulumi.get(self, "path_id")

    @path_id.setter
    def path_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path_id", value)

    @property
    @pulumi.getter(name="pathName")
    def path_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the path. You must provide `path_id` or `path_name`, but not both.
        """
        return pulumi.get(self, "path_name")

    @path_name.setter
    def path_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path_name", value)

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> Optional[pulumi.Input[str]]:
        """
        Product identifier. For example, `prod-abcdzk7xy33qa`. You must provide `product_id` or `product_name`, but not both.
        """
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product_id", value)

    @property
    @pulumi.getter(name="productName")
    def product_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the product. You must provide `product_id` or `product_name`, but not both.
        """
        return pulumi.get(self, "product_name")

    @product_name.setter
    def product_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product_name", value)

    @property
    @pulumi.getter(name="provisioningArtifactId")
    def provisioning_artifact_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the provisioning artifact. For example, `pa-4abcdjnxjj6ne`. You must provide the `provisioning_artifact_id` or `provisioning_artifact_name`, but not both.
        """
        return pulumi.get(self, "provisioning_artifact_id")

    @provisioning_artifact_id.setter
    def provisioning_artifact_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provisioning_artifact_id", value)

    @property
    @pulumi.getter(name="provisioningArtifactName")
    def provisioning_artifact_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the provisioning artifact. You must provide the `provisioning_artifact_id` or `provisioning_artifact_name`, but not both.
        """
        return pulumi.get(self, "provisioning_artifact_name")

    @provisioning_artifact_name.setter
    def provisioning_artifact_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provisioning_artifact_name", value)

    @property
    @pulumi.getter(name="provisioningParameters")
    def provisioning_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProvisionedProductProvisioningParameterArgs']]]]:
        """
        Configuration block with parameters specified by the administrator that are required for provisioning the product. See details below.
        """
        return pulumi.get(self, "provisioning_parameters")

    @provisioning_parameters.setter
    def provisioning_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProvisionedProductProvisioningParameterArgs']]]]):
        pulumi.set(self, "provisioning_parameters", value)

    @property
    @pulumi.getter(name="retainPhysicalResources")
    def retain_physical_resources(self) -> Optional[pulumi.Input[bool]]:
        """
        _Only applies to deleting._ Whether to delete the Service Catalog provisioned product but leave the CloudFormation stack, stack set, or the underlying resources of the deleted provisioned product. The default value is `false`.
        """
        return pulumi.get(self, "retain_physical_resources")

    @retain_physical_resources.setter
    def retain_physical_resources(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "retain_physical_resources", value)

    @property
    @pulumi.getter(name="stackSetProvisioningPreferences")
    def stack_set_provisioning_preferences(self) -> Optional[pulumi.Input['ProvisionedProductStackSetProvisioningPreferencesArgs']]:
        """
        Configuration block with information about the provisioning preferences for a stack set. See details below.
        """
        return pulumi.get(self, "stack_set_provisioning_preferences")

    @stack_set_provisioning_preferences.setter
    def stack_set_provisioning_preferences(self, value: Optional[pulumi.Input['ProvisionedProductStackSetProvisioningPreferencesArgs']]):
        pulumi.set(self, "stack_set_provisioning_preferences", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tags to apply to the provisioned product. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)


@pulumi.input_type
class _ProvisionedProductState:
    def __init__(__self__, *,
                 accept_language: Optional[pulumi.Input[str]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 cloudwatch_dashboard_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 created_time: Optional[pulumi.Input[str]] = None,
                 ignore_errors: Optional[pulumi.Input[bool]] = None,
                 last_provisioning_record_id: Optional[pulumi.Input[str]] = None,
                 last_record_id: Optional[pulumi.Input[str]] = None,
                 last_successful_provisioning_record_id: Optional[pulumi.Input[str]] = None,
                 launch_role_arn: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notification_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 path_id: Optional[pulumi.Input[str]] = None,
                 path_name: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 product_name: Optional[pulumi.Input[str]] = None,
                 provisioning_artifact_id: Optional[pulumi.Input[str]] = None,
                 provisioning_artifact_name: Optional[pulumi.Input[str]] = None,
                 provisioning_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ProvisionedProductProvisioningParameterArgs']]]] = None,
                 retain_physical_resources: Optional[pulumi.Input[bool]] = None,
                 stack_set_provisioning_preferences: Optional[pulumi.Input['ProvisionedProductStackSetProvisioningPreferencesArgs']] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 status_message: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ProvisionedProduct resources.
        :param pulumi.Input[str] accept_language: Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
        :param pulumi.Input[str] arn: ARN of the provisioned product.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] cloudwatch_dashboard_names: Set of CloudWatch dashboards that were created when provisioning the product.
        :param pulumi.Input[str] created_time: Time when the provisioned product was created.
        :param pulumi.Input[bool] ignore_errors: _Only applies to deleting._ If set to `true`, AWS Service Catalog stops managing the specified provisioned product even if it cannot delete the underlying resources. The default value is `false`.
        :param pulumi.Input[str] last_provisioning_record_id: Record identifier of the last request performed on this provisioned product of the following types: `ProvisionedProduct`, `UpdateProvisionedProduct`, `ExecuteProvisionedProductPlan`, `TerminateProvisionedProduct`.
        :param pulumi.Input[str] last_record_id: Record identifier of the last request performed on this provisioned product.
        :param pulumi.Input[str] last_successful_provisioning_record_id: Record identifier of the last successful request performed on this provisioned product of the following types: `ProvisionedProduct`, `UpdateProvisionedProduct`, `ExecuteProvisionedProductPlan`, `TerminateProvisionedProduct`.
        :param pulumi.Input[str] launch_role_arn: ARN of the launch role associated with the provisioned product.
        :param pulumi.Input[str] name: User-friendly name of the provisioned product.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] notification_arns: Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related events.
        :param pulumi.Input[str] path_id: Path identifier of the product. This value is optional if the product has a default path, and required if the product has more than one path. To list the paths for a product, use `servicecatalog.getLaunchPaths`. When required, you must provide `path_id` or `path_name`, but not both.
        :param pulumi.Input[str] path_name: Name of the path. You must provide `path_id` or `path_name`, but not both.
        :param pulumi.Input[str] product_id: Product identifier. For example, `prod-abcdzk7xy33qa`. You must provide `product_id` or `product_name`, but not both.
        :param pulumi.Input[str] product_name: Name of the product. You must provide `product_id` or `product_name`, but not both.
        :param pulumi.Input[str] provisioning_artifact_id: Identifier of the provisioning artifact. For example, `pa-4abcdjnxjj6ne`. You must provide the `provisioning_artifact_id` or `provisioning_artifact_name`, but not both.
        :param pulumi.Input[str] provisioning_artifact_name: Name of the provisioning artifact. You must provide the `provisioning_artifact_id` or `provisioning_artifact_name`, but not both.
        :param pulumi.Input[Sequence[pulumi.Input['ProvisionedProductProvisioningParameterArgs']]] provisioning_parameters: Configuration block with parameters specified by the administrator that are required for provisioning the product. See details below.
        :param pulumi.Input[bool] retain_physical_resources: _Only applies to deleting._ Whether to delete the Service Catalog provisioned product but leave the CloudFormation stack, stack set, or the underlying resources of the deleted provisioned product. The default value is `false`.
        :param pulumi.Input['ProvisionedProductStackSetProvisioningPreferencesArgs'] stack_set_provisioning_preferences: Configuration block with information about the provisioning preferences for a stack set. See details below.
        :param pulumi.Input[str] status: Current status of the provisioned product. See meanings below.
        :param pulumi.Input[str] status_message: Current status message of the provisioned product.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tags to apply to the provisioned product. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[str] type: Type of provisioned product. Valid values are `CFN_STACK` and `CFN_STACKSET`.
        """
        if accept_language is not None:
            pulumi.set(__self__, "accept_language", accept_language)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if cloudwatch_dashboard_names is not None:
            pulumi.set(__self__, "cloudwatch_dashboard_names", cloudwatch_dashboard_names)
        if created_time is not None:
            pulumi.set(__self__, "created_time", created_time)
        if ignore_errors is not None:
            pulumi.set(__self__, "ignore_errors", ignore_errors)
        if last_provisioning_record_id is not None:
            pulumi.set(__self__, "last_provisioning_record_id", last_provisioning_record_id)
        if last_record_id is not None:
            pulumi.set(__self__, "last_record_id", last_record_id)
        if last_successful_provisioning_record_id is not None:
            pulumi.set(__self__, "last_successful_provisioning_record_id", last_successful_provisioning_record_id)
        if launch_role_arn is not None:
            pulumi.set(__self__, "launch_role_arn", launch_role_arn)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notification_arns is not None:
            pulumi.set(__self__, "notification_arns", notification_arns)
        if path_id is not None:
            pulumi.set(__self__, "path_id", path_id)
        if path_name is not None:
            pulumi.set(__self__, "path_name", path_name)
        if product_id is not None:
            pulumi.set(__self__, "product_id", product_id)
        if product_name is not None:
            pulumi.set(__self__, "product_name", product_name)
        if provisioning_artifact_id is not None:
            pulumi.set(__self__, "provisioning_artifact_id", provisioning_artifact_id)
        if provisioning_artifact_name is not None:
            pulumi.set(__self__, "provisioning_artifact_name", provisioning_artifact_name)
        if provisioning_parameters is not None:
            pulumi.set(__self__, "provisioning_parameters", provisioning_parameters)
        if retain_physical_resources is not None:
            pulumi.set(__self__, "retain_physical_resources", retain_physical_resources)
        if stack_set_provisioning_preferences is not None:
            pulumi.set(__self__, "stack_set_provisioning_preferences", stack_set_provisioning_preferences)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if status_message is not None:
            pulumi.set(__self__, "status_message", status_message)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="acceptLanguage")
    def accept_language(self) -> Optional[pulumi.Input[str]]:
        """
        Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
        """
        return pulumi.get(self, "accept_language")

    @accept_language.setter
    def accept_language(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "accept_language", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the provisioned product.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="cloudwatchDashboardNames")
    def cloudwatch_dashboard_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set of CloudWatch dashboards that were created when provisioning the product.
        """
        return pulumi.get(self, "cloudwatch_dashboard_names")

    @cloudwatch_dashboard_names.setter
    def cloudwatch_dashboard_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "cloudwatch_dashboard_names", value)

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time when the provisioned product was created.
        """
        return pulumi.get(self, "created_time")

    @created_time.setter
    def created_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_time", value)

    @property
    @pulumi.getter(name="ignoreErrors")
    def ignore_errors(self) -> Optional[pulumi.Input[bool]]:
        """
        _Only applies to deleting._ If set to `true`, AWS Service Catalog stops managing the specified provisioned product even if it cannot delete the underlying resources. The default value is `false`.
        """
        return pulumi.get(self, "ignore_errors")

    @ignore_errors.setter
    def ignore_errors(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_errors", value)

    @property
    @pulumi.getter(name="lastProvisioningRecordId")
    def last_provisioning_record_id(self) -> Optional[pulumi.Input[str]]:
        """
        Record identifier of the last request performed on this provisioned product of the following types: `ProvisionedProduct`, `UpdateProvisionedProduct`, `ExecuteProvisionedProductPlan`, `TerminateProvisionedProduct`.
        """
        return pulumi.get(self, "last_provisioning_record_id")

    @last_provisioning_record_id.setter
    def last_provisioning_record_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_provisioning_record_id", value)

    @property
    @pulumi.getter(name="lastRecordId")
    def last_record_id(self) -> Optional[pulumi.Input[str]]:
        """
        Record identifier of the last request performed on this provisioned product.
        """
        return pulumi.get(self, "last_record_id")

    @last_record_id.setter
    def last_record_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_record_id", value)

    @property
    @pulumi.getter(name="lastSuccessfulProvisioningRecordId")
    def last_successful_provisioning_record_id(self) -> Optional[pulumi.Input[str]]:
        """
        Record identifier of the last successful request performed on this provisioned product of the following types: `ProvisionedProduct`, `UpdateProvisionedProduct`, `ExecuteProvisionedProductPlan`, `TerminateProvisionedProduct`.
        """
        return pulumi.get(self, "last_successful_provisioning_record_id")

    @last_successful_provisioning_record_id.setter
    def last_successful_provisioning_record_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_successful_provisioning_record_id", value)

    @property
    @pulumi.getter(name="launchRoleArn")
    def launch_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the launch role associated with the provisioned product.
        """
        return pulumi.get(self, "launch_role_arn")

    @launch_role_arn.setter
    def launch_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "launch_role_arn", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        User-friendly name of the provisioned product.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="notificationArns")
    def notification_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related events.
        """
        return pulumi.get(self, "notification_arns")

    @notification_arns.setter
    def notification_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "notification_arns", value)

    @property
    @pulumi.getter(name="pathId")
    def path_id(self) -> Optional[pulumi.Input[str]]:
        """
        Path identifier of the product. This value is optional if the product has a default path, and required if the product has more than one path. To list the paths for a product, use `servicecatalog.getLaunchPaths`. When required, you must provide `path_id` or `path_name`, but not both.
        """
        return pulumi.get(self, "path_id")

    @path_id.setter
    def path_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path_id", value)

    @property
    @pulumi.getter(name="pathName")
    def path_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the path. You must provide `path_id` or `path_name`, but not both.
        """
        return pulumi.get(self, "path_name")

    @path_name.setter
    def path_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path_name", value)

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> Optional[pulumi.Input[str]]:
        """
        Product identifier. For example, `prod-abcdzk7xy33qa`. You must provide `product_id` or `product_name`, but not both.
        """
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product_id", value)

    @property
    @pulumi.getter(name="productName")
    def product_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the product. You must provide `product_id` or `product_name`, but not both.
        """
        return pulumi.get(self, "product_name")

    @product_name.setter
    def product_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product_name", value)

    @property
    @pulumi.getter(name="provisioningArtifactId")
    def provisioning_artifact_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the provisioning artifact. For example, `pa-4abcdjnxjj6ne`. You must provide the `provisioning_artifact_id` or `provisioning_artifact_name`, but not both.
        """
        return pulumi.get(self, "provisioning_artifact_id")

    @provisioning_artifact_id.setter
    def provisioning_artifact_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provisioning_artifact_id", value)

    @property
    @pulumi.getter(name="provisioningArtifactName")
    def provisioning_artifact_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the provisioning artifact. You must provide the `provisioning_artifact_id` or `provisioning_artifact_name`, but not both.
        """
        return pulumi.get(self, "provisioning_artifact_name")

    @provisioning_artifact_name.setter
    def provisioning_artifact_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provisioning_artifact_name", value)

    @property
    @pulumi.getter(name="provisioningParameters")
    def provisioning_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProvisionedProductProvisioningParameterArgs']]]]:
        """
        Configuration block with parameters specified by the administrator that are required for provisioning the product. See details below.
        """
        return pulumi.get(self, "provisioning_parameters")

    @provisioning_parameters.setter
    def provisioning_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProvisionedProductProvisioningParameterArgs']]]]):
        pulumi.set(self, "provisioning_parameters", value)

    @property
    @pulumi.getter(name="retainPhysicalResources")
    def retain_physical_resources(self) -> Optional[pulumi.Input[bool]]:
        """
        _Only applies to deleting._ Whether to delete the Service Catalog provisioned product but leave the CloudFormation stack, stack set, or the underlying resources of the deleted provisioned product. The default value is `false`.
        """
        return pulumi.get(self, "retain_physical_resources")

    @retain_physical_resources.setter
    def retain_physical_resources(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "retain_physical_resources", value)

    @property
    @pulumi.getter(name="stackSetProvisioningPreferences")
    def stack_set_provisioning_preferences(self) -> Optional[pulumi.Input['ProvisionedProductStackSetProvisioningPreferencesArgs']]:
        """
        Configuration block with information about the provisioning preferences for a stack set. See details below.
        """
        return pulumi.get(self, "stack_set_provisioning_preferences")

    @stack_set_provisioning_preferences.setter
    def stack_set_provisioning_preferences(self, value: Optional[pulumi.Input['ProvisionedProductStackSetProvisioningPreferencesArgs']]):
        pulumi.set(self, "stack_set_provisioning_preferences", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Current status of the provisioned product. See meanings below.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> Optional[pulumi.Input[str]]:
        """
        Current status message of the provisioned product.
        """
        return pulumi.get(self, "status_message")

    @status_message.setter
    def status_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status_message", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tags to apply to the provisioned product. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of provisioned product. Valid values are `CFN_STACK` and `CFN_STACKSET`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class ProvisionedProduct(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accept_language: Optional[pulumi.Input[str]] = None,
                 ignore_errors: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notification_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 path_id: Optional[pulumi.Input[str]] = None,
                 path_name: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 product_name: Optional[pulumi.Input[str]] = None,
                 provisioning_artifact_id: Optional[pulumi.Input[str]] = None,
                 provisioning_artifact_name: Optional[pulumi.Input[str]] = None,
                 provisioning_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProvisionedProductProvisioningParameterArgs']]]]] = None,
                 retain_physical_resources: Optional[pulumi.Input[bool]] = None,
                 stack_set_provisioning_preferences: Optional[pulumi.Input[pulumi.InputType['ProvisionedProductStackSetProvisioningPreferencesArgs']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        This resource provisions and manages a Service Catalog provisioned product.

        A provisioned product is a resourced instance of a product. For example, provisioning a product based on a CloudFormation template launches a CloudFormation stack and its underlying resources.

        Like this resource, the `aws_servicecatalog_record` data source also provides information about a provisioned product. Although a Service Catalog record provides some overlapping information with this resource, a record is tied to a provisioned product event, such as provisioning, termination, and updating.

        > **Tip:** If you include conflicted keys as tags, AWS will report an error, "Parameter validation failed: Missing required parameter in Tags[N]:Value".

        > **Tip:** A "provisioning artifact" is also referred to as a "version." A "distributor" is also referred to as a "vendor."

        ## Example Usage

        ## Import

        `aws_servicecatalog_provisioned_product` can be imported using the provisioned product ID, e.g.

        ```sh
         $ pulumi import aws:servicecatalog/provisionedProduct:ProvisionedProduct example pp-dnigbtea24ste
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] accept_language: Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
        :param pulumi.Input[bool] ignore_errors: _Only applies to deleting._ If set to `true`, AWS Service Catalog stops managing the specified provisioned product even if it cannot delete the underlying resources. The default value is `false`.
        :param pulumi.Input[str] name: User-friendly name of the provisioned product.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] notification_arns: Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related events.
        :param pulumi.Input[str] path_id: Path identifier of the product. This value is optional if the product has a default path, and required if the product has more than one path. To list the paths for a product, use `servicecatalog.getLaunchPaths`. When required, you must provide `path_id` or `path_name`, but not both.
        :param pulumi.Input[str] path_name: Name of the path. You must provide `path_id` or `path_name`, but not both.
        :param pulumi.Input[str] product_id: Product identifier. For example, `prod-abcdzk7xy33qa`. You must provide `product_id` or `product_name`, but not both.
        :param pulumi.Input[str] product_name: Name of the product. You must provide `product_id` or `product_name`, but not both.
        :param pulumi.Input[str] provisioning_artifact_id: Identifier of the provisioning artifact. For example, `pa-4abcdjnxjj6ne`. You must provide the `provisioning_artifact_id` or `provisioning_artifact_name`, but not both.
        :param pulumi.Input[str] provisioning_artifact_name: Name of the provisioning artifact. You must provide the `provisioning_artifact_id` or `provisioning_artifact_name`, but not both.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProvisionedProductProvisioningParameterArgs']]]] provisioning_parameters: Configuration block with parameters specified by the administrator that are required for provisioning the product. See details below.
        :param pulumi.Input[bool] retain_physical_resources: _Only applies to deleting._ Whether to delete the Service Catalog provisioned product but leave the CloudFormation stack, stack set, or the underlying resources of the deleted provisioned product. The default value is `false`.
        :param pulumi.Input[pulumi.InputType['ProvisionedProductStackSetProvisioningPreferencesArgs']] stack_set_provisioning_preferences: Configuration block with information about the provisioning preferences for a stack set. See details below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tags to apply to the provisioned product. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProvisionedProductArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provisions and manages a Service Catalog provisioned product.

        A provisioned product is a resourced instance of a product. For example, provisioning a product based on a CloudFormation template launches a CloudFormation stack and its underlying resources.

        Like this resource, the `aws_servicecatalog_record` data source also provides information about a provisioned product. Although a Service Catalog record provides some overlapping information with this resource, a record is tied to a provisioned product event, such as provisioning, termination, and updating.

        > **Tip:** If you include conflicted keys as tags, AWS will report an error, "Parameter validation failed: Missing required parameter in Tags[N]:Value".

        > **Tip:** A "provisioning artifact" is also referred to as a "version." A "distributor" is also referred to as a "vendor."

        ## Example Usage

        ## Import

        `aws_servicecatalog_provisioned_product` can be imported using the provisioned product ID, e.g.

        ```sh
         $ pulumi import aws:servicecatalog/provisionedProduct:ProvisionedProduct example pp-dnigbtea24ste
        ```

        :param str resource_name: The name of the resource.
        :param ProvisionedProductArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProvisionedProductArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accept_language: Optional[pulumi.Input[str]] = None,
                 ignore_errors: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notification_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 path_id: Optional[pulumi.Input[str]] = None,
                 path_name: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 product_name: Optional[pulumi.Input[str]] = None,
                 provisioning_artifact_id: Optional[pulumi.Input[str]] = None,
                 provisioning_artifact_name: Optional[pulumi.Input[str]] = None,
                 provisioning_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProvisionedProductProvisioningParameterArgs']]]]] = None,
                 retain_physical_resources: Optional[pulumi.Input[bool]] = None,
                 stack_set_provisioning_preferences: Optional[pulumi.Input[pulumi.InputType['ProvisionedProductStackSetProvisioningPreferencesArgs']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProvisionedProductArgs.__new__(ProvisionedProductArgs)

            __props__.__dict__["accept_language"] = accept_language
            __props__.__dict__["ignore_errors"] = ignore_errors
            __props__.__dict__["name"] = name
            __props__.__dict__["notification_arns"] = notification_arns
            __props__.__dict__["path_id"] = path_id
            __props__.__dict__["path_name"] = path_name
            __props__.__dict__["product_id"] = product_id
            __props__.__dict__["product_name"] = product_name
            __props__.__dict__["provisioning_artifact_id"] = provisioning_artifact_id
            __props__.__dict__["provisioning_artifact_name"] = provisioning_artifact_name
            __props__.__dict__["provisioning_parameters"] = provisioning_parameters
            __props__.__dict__["retain_physical_resources"] = retain_physical_resources
            __props__.__dict__["stack_set_provisioning_preferences"] = stack_set_provisioning_preferences
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tags_all"] = tags_all
            __props__.__dict__["arn"] = None
            __props__.__dict__["cloudwatch_dashboard_names"] = None
            __props__.__dict__["created_time"] = None
            __props__.__dict__["last_provisioning_record_id"] = None
            __props__.__dict__["last_record_id"] = None
            __props__.__dict__["last_successful_provisioning_record_id"] = None
            __props__.__dict__["launch_role_arn"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["status_message"] = None
            __props__.__dict__["type"] = None
        super(ProvisionedProduct, __self__).__init__(
            'aws:servicecatalog/provisionedProduct:ProvisionedProduct',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accept_language: Optional[pulumi.Input[str]] = None,
            arn: Optional[pulumi.Input[str]] = None,
            cloudwatch_dashboard_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            created_time: Optional[pulumi.Input[str]] = None,
            ignore_errors: Optional[pulumi.Input[bool]] = None,
            last_provisioning_record_id: Optional[pulumi.Input[str]] = None,
            last_record_id: Optional[pulumi.Input[str]] = None,
            last_successful_provisioning_record_id: Optional[pulumi.Input[str]] = None,
            launch_role_arn: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            notification_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            path_id: Optional[pulumi.Input[str]] = None,
            path_name: Optional[pulumi.Input[str]] = None,
            product_id: Optional[pulumi.Input[str]] = None,
            product_name: Optional[pulumi.Input[str]] = None,
            provisioning_artifact_id: Optional[pulumi.Input[str]] = None,
            provisioning_artifact_name: Optional[pulumi.Input[str]] = None,
            provisioning_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProvisionedProductProvisioningParameterArgs']]]]] = None,
            retain_physical_resources: Optional[pulumi.Input[bool]] = None,
            stack_set_provisioning_preferences: Optional[pulumi.Input[pulumi.InputType['ProvisionedProductStackSetProvisioningPreferencesArgs']]] = None,
            status: Optional[pulumi.Input[str]] = None,
            status_message: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'ProvisionedProduct':
        """
        Get an existing ProvisionedProduct resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] accept_language: Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
        :param pulumi.Input[str] arn: ARN of the provisioned product.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] cloudwatch_dashboard_names: Set of CloudWatch dashboards that were created when provisioning the product.
        :param pulumi.Input[str] created_time: Time when the provisioned product was created.
        :param pulumi.Input[bool] ignore_errors: _Only applies to deleting._ If set to `true`, AWS Service Catalog stops managing the specified provisioned product even if it cannot delete the underlying resources. The default value is `false`.
        :param pulumi.Input[str] last_provisioning_record_id: Record identifier of the last request performed on this provisioned product of the following types: `ProvisionedProduct`, `UpdateProvisionedProduct`, `ExecuteProvisionedProductPlan`, `TerminateProvisionedProduct`.
        :param pulumi.Input[str] last_record_id: Record identifier of the last request performed on this provisioned product.
        :param pulumi.Input[str] last_successful_provisioning_record_id: Record identifier of the last successful request performed on this provisioned product of the following types: `ProvisionedProduct`, `UpdateProvisionedProduct`, `ExecuteProvisionedProductPlan`, `TerminateProvisionedProduct`.
        :param pulumi.Input[str] launch_role_arn: ARN of the launch role associated with the provisioned product.
        :param pulumi.Input[str] name: User-friendly name of the provisioned product.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] notification_arns: Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related events.
        :param pulumi.Input[str] path_id: Path identifier of the product. This value is optional if the product has a default path, and required if the product has more than one path. To list the paths for a product, use `servicecatalog.getLaunchPaths`. When required, you must provide `path_id` or `path_name`, but not both.
        :param pulumi.Input[str] path_name: Name of the path. You must provide `path_id` or `path_name`, but not both.
        :param pulumi.Input[str] product_id: Product identifier. For example, `prod-abcdzk7xy33qa`. You must provide `product_id` or `product_name`, but not both.
        :param pulumi.Input[str] product_name: Name of the product. You must provide `product_id` or `product_name`, but not both.
        :param pulumi.Input[str] provisioning_artifact_id: Identifier of the provisioning artifact. For example, `pa-4abcdjnxjj6ne`. You must provide the `provisioning_artifact_id` or `provisioning_artifact_name`, but not both.
        :param pulumi.Input[str] provisioning_artifact_name: Name of the provisioning artifact. You must provide the `provisioning_artifact_id` or `provisioning_artifact_name`, but not both.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProvisionedProductProvisioningParameterArgs']]]] provisioning_parameters: Configuration block with parameters specified by the administrator that are required for provisioning the product. See details below.
        :param pulumi.Input[bool] retain_physical_resources: _Only applies to deleting._ Whether to delete the Service Catalog provisioned product but leave the CloudFormation stack, stack set, or the underlying resources of the deleted provisioned product. The default value is `false`.
        :param pulumi.Input[pulumi.InputType['ProvisionedProductStackSetProvisioningPreferencesArgs']] stack_set_provisioning_preferences: Configuration block with information about the provisioning preferences for a stack set. See details below.
        :param pulumi.Input[str] status: Current status of the provisioned product. See meanings below.
        :param pulumi.Input[str] status_message: Current status message of the provisioned product.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tags to apply to the provisioned product. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[str] type: Type of provisioned product. Valid values are `CFN_STACK` and `CFN_STACKSET`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProvisionedProductState.__new__(_ProvisionedProductState)

        __props__.__dict__["accept_language"] = accept_language
        __props__.__dict__["arn"] = arn
        __props__.__dict__["cloudwatch_dashboard_names"] = cloudwatch_dashboard_names
        __props__.__dict__["created_time"] = created_time
        __props__.__dict__["ignore_errors"] = ignore_errors
        __props__.__dict__["last_provisioning_record_id"] = last_provisioning_record_id
        __props__.__dict__["last_record_id"] = last_record_id
        __props__.__dict__["last_successful_provisioning_record_id"] = last_successful_provisioning_record_id
        __props__.__dict__["launch_role_arn"] = launch_role_arn
        __props__.__dict__["name"] = name
        __props__.__dict__["notification_arns"] = notification_arns
        __props__.__dict__["path_id"] = path_id
        __props__.__dict__["path_name"] = path_name
        __props__.__dict__["product_id"] = product_id
        __props__.__dict__["product_name"] = product_name
        __props__.__dict__["provisioning_artifact_id"] = provisioning_artifact_id
        __props__.__dict__["provisioning_artifact_name"] = provisioning_artifact_name
        __props__.__dict__["provisioning_parameters"] = provisioning_parameters
        __props__.__dict__["retain_physical_resources"] = retain_physical_resources
        __props__.__dict__["stack_set_provisioning_preferences"] = stack_set_provisioning_preferences
        __props__.__dict__["status"] = status
        __props__.__dict__["status_message"] = status_message
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["type"] = type
        return ProvisionedProduct(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="acceptLanguage")
    def accept_language(self) -> pulumi.Output[Optional[str]]:
        """
        Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
        """
        return pulumi.get(self, "accept_language")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        ARN of the provisioned product.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="cloudwatchDashboardNames")
    def cloudwatch_dashboard_names(self) -> pulumi.Output[Sequence[str]]:
        """
        Set of CloudWatch dashboards that were created when provisioning the product.
        """
        return pulumi.get(self, "cloudwatch_dashboard_names")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> pulumi.Output[str]:
        """
        Time when the provisioned product was created.
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter(name="ignoreErrors")
    def ignore_errors(self) -> pulumi.Output[Optional[bool]]:
        """
        _Only applies to deleting._ If set to `true`, AWS Service Catalog stops managing the specified provisioned product even if it cannot delete the underlying resources. The default value is `false`.
        """
        return pulumi.get(self, "ignore_errors")

    @property
    @pulumi.getter(name="lastProvisioningRecordId")
    def last_provisioning_record_id(self) -> pulumi.Output[str]:
        """
        Record identifier of the last request performed on this provisioned product of the following types: `ProvisionedProduct`, `UpdateProvisionedProduct`, `ExecuteProvisionedProductPlan`, `TerminateProvisionedProduct`.
        """
        return pulumi.get(self, "last_provisioning_record_id")

    @property
    @pulumi.getter(name="lastRecordId")
    def last_record_id(self) -> pulumi.Output[str]:
        """
        Record identifier of the last request performed on this provisioned product.
        """
        return pulumi.get(self, "last_record_id")

    @property
    @pulumi.getter(name="lastSuccessfulProvisioningRecordId")
    def last_successful_provisioning_record_id(self) -> pulumi.Output[str]:
        """
        Record identifier of the last successful request performed on this provisioned product of the following types: `ProvisionedProduct`, `UpdateProvisionedProduct`, `ExecuteProvisionedProductPlan`, `TerminateProvisionedProduct`.
        """
        return pulumi.get(self, "last_successful_provisioning_record_id")

    @property
    @pulumi.getter(name="launchRoleArn")
    def launch_role_arn(self) -> pulumi.Output[str]:
        """
        ARN of the launch role associated with the provisioned product.
        """
        return pulumi.get(self, "launch_role_arn")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        User-friendly name of the provisioned product.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="notificationArns")
    def notification_arns(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related events.
        """
        return pulumi.get(self, "notification_arns")

    @property
    @pulumi.getter(name="pathId")
    def path_id(self) -> pulumi.Output[str]:
        """
        Path identifier of the product. This value is optional if the product has a default path, and required if the product has more than one path. To list the paths for a product, use `servicecatalog.getLaunchPaths`. When required, you must provide `path_id` or `path_name`, but not both.
        """
        return pulumi.get(self, "path_id")

    @property
    @pulumi.getter(name="pathName")
    def path_name(self) -> pulumi.Output[Optional[str]]:
        """
        Name of the path. You must provide `path_id` or `path_name`, but not both.
        """
        return pulumi.get(self, "path_name")

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> pulumi.Output[str]:
        """
        Product identifier. For example, `prod-abcdzk7xy33qa`. You must provide `product_id` or `product_name`, but not both.
        """
        return pulumi.get(self, "product_id")

    @property
    @pulumi.getter(name="productName")
    def product_name(self) -> pulumi.Output[Optional[str]]:
        """
        Name of the product. You must provide `product_id` or `product_name`, but not both.
        """
        return pulumi.get(self, "product_name")

    @property
    @pulumi.getter(name="provisioningArtifactId")
    def provisioning_artifact_id(self) -> pulumi.Output[str]:
        """
        Identifier of the provisioning artifact. For example, `pa-4abcdjnxjj6ne`. You must provide the `provisioning_artifact_id` or `provisioning_artifact_name`, but not both.
        """
        return pulumi.get(self, "provisioning_artifact_id")

    @property
    @pulumi.getter(name="provisioningArtifactName")
    def provisioning_artifact_name(self) -> pulumi.Output[Optional[str]]:
        """
        Name of the provisioning artifact. You must provide the `provisioning_artifact_id` or `provisioning_artifact_name`, but not both.
        """
        return pulumi.get(self, "provisioning_artifact_name")

    @property
    @pulumi.getter(name="provisioningParameters")
    def provisioning_parameters(self) -> pulumi.Output[Optional[Sequence['outputs.ProvisionedProductProvisioningParameter']]]:
        """
        Configuration block with parameters specified by the administrator that are required for provisioning the product. See details below.
        """
        return pulumi.get(self, "provisioning_parameters")

    @property
    @pulumi.getter(name="retainPhysicalResources")
    def retain_physical_resources(self) -> pulumi.Output[Optional[bool]]:
        """
        _Only applies to deleting._ Whether to delete the Service Catalog provisioned product but leave the CloudFormation stack, stack set, or the underlying resources of the deleted provisioned product. The default value is `false`.
        """
        return pulumi.get(self, "retain_physical_resources")

    @property
    @pulumi.getter(name="stackSetProvisioningPreferences")
    def stack_set_provisioning_preferences(self) -> pulumi.Output[Optional['outputs.ProvisionedProductStackSetProvisioningPreferences']]:
        """
        Configuration block with information about the provisioning preferences for a stack set. See details below.
        """
        return pulumi.get(self, "stack_set_provisioning_preferences")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Current status of the provisioned product. See meanings below.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> pulumi.Output[str]:
        """
        Current status message of the provisioned product.
        """
        return pulumi.get(self, "status_message")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Tags to apply to the provisioned product. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Type of provisioned product. Valid values are `CFN_STACK` and `CFN_STACKSET`.
        """
        return pulumi.get(self, "type")

