# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'AppImageConfigKernelGatewayImageConfig',
    'AppImageConfigKernelGatewayImageConfigFileSystemConfig',
    'AppImageConfigKernelGatewayImageConfigKernelSpec',
    'AppResourceSpec',
    'CodeRepositoryGitConfig',
    'DomainDefaultUserSettings',
    'DomainDefaultUserSettingsJupyterServerAppSettings',
    'DomainDefaultUserSettingsJupyterServerAppSettingsDefaultResourceSpec',
    'DomainDefaultUserSettingsKernelGatewayAppSettings',
    'DomainDefaultUserSettingsKernelGatewayAppSettingsCustomImage',
    'DomainDefaultUserSettingsKernelGatewayAppSettingsDefaultResourceSpec',
    'DomainDefaultUserSettingsSharingSettings',
    'DomainDefaultUserSettingsTensorBoardAppSettings',
    'DomainDefaultUserSettingsTensorBoardAppSettingsDefaultResourceSpec',
    'DomainRetentionPolicy',
    'EndpointConfigurationDataCaptureConfig',
    'EndpointConfigurationDataCaptureConfigCaptureContentTypeHeader',
    'EndpointConfigurationDataCaptureConfigCaptureOption',
    'EndpointConfigurationProductionVariant',
    'FeatureGroupFeatureDefinition',
    'FeatureGroupOfflineStoreConfig',
    'FeatureGroupOfflineStoreConfigDataCatalogConfig',
    'FeatureGroupOfflineStoreConfigS3StorageConfig',
    'FeatureGroupOnlineStoreConfig',
    'FeatureGroupOnlineStoreConfigSecurityConfig',
    'ModelContainer',
    'ModelContainerImageConfig',
    'ModelPrimaryContainer',
    'ModelPrimaryContainerImageConfig',
    'ModelVpcConfig',
    'UserProfileUserSettings',
    'UserProfileUserSettingsJupyterServerAppSettings',
    'UserProfileUserSettingsJupyterServerAppSettingsDefaultResourceSpec',
    'UserProfileUserSettingsKernelGatewayAppSettings',
    'UserProfileUserSettingsKernelGatewayAppSettingsCustomImage',
    'UserProfileUserSettingsKernelGatewayAppSettingsDefaultResourceSpec',
    'UserProfileUserSettingsSharingSettings',
    'UserProfileUserSettingsTensorBoardAppSettings',
    'UserProfileUserSettingsTensorBoardAppSettingsDefaultResourceSpec',
]

@pulumi.output_type
class AppImageConfigKernelGatewayImageConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kernelSpec":
            suggest = "kernel_spec"
        elif key == "fileSystemConfig":
            suggest = "file_system_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppImageConfigKernelGatewayImageConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppImageConfigKernelGatewayImageConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppImageConfigKernelGatewayImageConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kernel_spec: 'outputs.AppImageConfigKernelGatewayImageConfigKernelSpec',
                 file_system_config: Optional['outputs.AppImageConfigKernelGatewayImageConfigFileSystemConfig'] = None):
        """
        :param 'AppImageConfigKernelGatewayImageConfigKernelSpecArgs' kernel_spec: The default branch for the Git repository. See Kernel Spec details below.
        :param 'AppImageConfigKernelGatewayImageConfigFileSystemConfigArgs' file_system_config: The URL where the Git repository is located. See File System Config details below.
        """
        pulumi.set(__self__, "kernel_spec", kernel_spec)
        if file_system_config is not None:
            pulumi.set(__self__, "file_system_config", file_system_config)

    @property
    @pulumi.getter(name="kernelSpec")
    def kernel_spec(self) -> 'outputs.AppImageConfigKernelGatewayImageConfigKernelSpec':
        """
        The default branch for the Git repository. See Kernel Spec details below.
        """
        return pulumi.get(self, "kernel_spec")

    @property
    @pulumi.getter(name="fileSystemConfig")
    def file_system_config(self) -> Optional['outputs.AppImageConfigKernelGatewayImageConfigFileSystemConfig']:
        """
        The URL where the Git repository is located. See File System Config details below.
        """
        return pulumi.get(self, "file_system_config")


@pulumi.output_type
class AppImageConfigKernelGatewayImageConfigFileSystemConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultGid":
            suggest = "default_gid"
        elif key == "defaultUid":
            suggest = "default_uid"
        elif key == "mountPath":
            suggest = "mount_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppImageConfigKernelGatewayImageConfigFileSystemConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppImageConfigKernelGatewayImageConfigFileSystemConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppImageConfigKernelGatewayImageConfigFileSystemConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_gid: Optional[int] = None,
                 default_uid: Optional[int] = None,
                 mount_path: Optional[str] = None):
        """
        :param int default_gid: The default POSIX group ID (GID). If not specified, defaults to `100`. Valid values are `0` and `100`.
        :param int default_uid: The default POSIX user ID (UID). If not specified, defaults to `1000`. Valid values are `0` and `1000`.
        :param str mount_path: The path within the image to mount the user's EFS home directory. The directory should be empty. If not specified, defaults to `/home/sagemaker-user`.
        """
        if default_gid is not None:
            pulumi.set(__self__, "default_gid", default_gid)
        if default_uid is not None:
            pulumi.set(__self__, "default_uid", default_uid)
        if mount_path is not None:
            pulumi.set(__self__, "mount_path", mount_path)

    @property
    @pulumi.getter(name="defaultGid")
    def default_gid(self) -> Optional[int]:
        """
        The default POSIX group ID (GID). If not specified, defaults to `100`. Valid values are `0` and `100`.
        """
        return pulumi.get(self, "default_gid")

    @property
    @pulumi.getter(name="defaultUid")
    def default_uid(self) -> Optional[int]:
        """
        The default POSIX user ID (UID). If not specified, defaults to `1000`. Valid values are `0` and `1000`.
        """
        return pulumi.get(self, "default_uid")

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> Optional[str]:
        """
        The path within the image to mount the user's EFS home directory. The directory should be empty. If not specified, defaults to `/home/sagemaker-user`.
        """
        return pulumi.get(self, "mount_path")


@pulumi.output_type
class AppImageConfigKernelGatewayImageConfigKernelSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppImageConfigKernelGatewayImageConfigKernelSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppImageConfigKernelGatewayImageConfigKernelSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppImageConfigKernelGatewayImageConfigKernelSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 display_name: Optional[str] = None):
        """
        :param str name: The name of the kernel.
        :param str display_name: The display name of the kernel.
        """
        pulumi.set(__self__, "name", name)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the kernel.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The display name of the kernel.
        """
        return pulumi.get(self, "display_name")


@pulumi.output_type
class AppResourceSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "sagemakerImageArn":
            suggest = "sagemaker_image_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppResourceSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppResourceSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppResourceSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: Optional[str] = None,
                 sagemaker_image_arn: Optional[str] = None):
        """
        :param str instance_type: The instance type that the image version runs on. For valid values see [Sagemaker Instance Types](https://docs.aws.amazon.com/sagemaker/latest/dg/notebooks-available-instance-types.html).
        :param str sagemaker_image_arn: The ARN of the SageMaker image that the image version belongs to.
        """
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if sagemaker_image_arn is not None:
            pulumi.set(__self__, "sagemaker_image_arn", sagemaker_image_arn)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[str]:
        """
        The instance type that the image version runs on. For valid values see [Sagemaker Instance Types](https://docs.aws.amazon.com/sagemaker/latest/dg/notebooks-available-instance-types.html).
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="sagemakerImageArn")
    def sagemaker_image_arn(self) -> Optional[str]:
        """
        The ARN of the SageMaker image that the image version belongs to.
        """
        return pulumi.get(self, "sagemaker_image_arn")


@pulumi.output_type
class CodeRepositoryGitConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repositoryUrl":
            suggest = "repository_url"
        elif key == "secretArn":
            suggest = "secret_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CodeRepositoryGitConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CodeRepositoryGitConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CodeRepositoryGitConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 repository_url: str,
                 branch: Optional[str] = None,
                 secret_arn: Optional[str] = None):
        """
        :param str repository_url: The URL where the Git repository is located.
        :param str branch: The default branch for the Git repository.
        :param str secret_arn: The Amazon Resource Name (ARN) of the AWS Secrets Manager secret that contains the credentials used to access the git repository. The secret must have a staging label of AWSCURRENT and must be in the following format: `{"username": UserName, "password": Password}`
        """
        pulumi.set(__self__, "repository_url", repository_url)
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if secret_arn is not None:
            pulumi.set(__self__, "secret_arn", secret_arn)

    @property
    @pulumi.getter(name="repositoryUrl")
    def repository_url(self) -> str:
        """
        The URL where the Git repository is located.
        """
        return pulumi.get(self, "repository_url")

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The default branch for the Git repository.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the AWS Secrets Manager secret that contains the credentials used to access the git repository. The secret must have a staging label of AWSCURRENT and must be in the following format: `{"username": UserName, "password": Password}`
        """
        return pulumi.get(self, "secret_arn")


@pulumi.output_type
class DomainDefaultUserSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executionRole":
            suggest = "execution_role"
        elif key == "jupyterServerAppSettings":
            suggest = "jupyter_server_app_settings"
        elif key == "kernelGatewayAppSettings":
            suggest = "kernel_gateway_app_settings"
        elif key == "securityGroups":
            suggest = "security_groups"
        elif key == "sharingSettings":
            suggest = "sharing_settings"
        elif key == "tensorBoardAppSettings":
            suggest = "tensor_board_app_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainDefaultUserSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainDefaultUserSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainDefaultUserSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execution_role: str,
                 jupyter_server_app_settings: Optional['outputs.DomainDefaultUserSettingsJupyterServerAppSettings'] = None,
                 kernel_gateway_app_settings: Optional['outputs.DomainDefaultUserSettingsKernelGatewayAppSettings'] = None,
                 security_groups: Optional[Sequence[str]] = None,
                 sharing_settings: Optional['outputs.DomainDefaultUserSettingsSharingSettings'] = None,
                 tensor_board_app_settings: Optional['outputs.DomainDefaultUserSettingsTensorBoardAppSettings'] = None):
        """
        :param str execution_role: The execution role ARN for the user.
        :param 'DomainDefaultUserSettingsJupyterServerAppSettingsArgs' jupyter_server_app_settings: The Jupyter server's app settings. See Jupyter Server App Settings below.
        :param 'DomainDefaultUserSettingsKernelGatewayAppSettingsArgs' kernel_gateway_app_settings: The kernel gateway app settings. See Kernel Gateway App Settings below.
        :param Sequence[str] security_groups: The security groups.
        :param 'DomainDefaultUserSettingsSharingSettingsArgs' sharing_settings: The sharing settings. See Sharing Settings below.
        :param 'DomainDefaultUserSettingsTensorBoardAppSettingsArgs' tensor_board_app_settings: The TensorBoard app settings. See TensorBoard App Settings below.
        """
        pulumi.set(__self__, "execution_role", execution_role)
        if jupyter_server_app_settings is not None:
            pulumi.set(__self__, "jupyter_server_app_settings", jupyter_server_app_settings)
        if kernel_gateway_app_settings is not None:
            pulumi.set(__self__, "kernel_gateway_app_settings", kernel_gateway_app_settings)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if sharing_settings is not None:
            pulumi.set(__self__, "sharing_settings", sharing_settings)
        if tensor_board_app_settings is not None:
            pulumi.set(__self__, "tensor_board_app_settings", tensor_board_app_settings)

    @property
    @pulumi.getter(name="executionRole")
    def execution_role(self) -> str:
        """
        The execution role ARN for the user.
        """
        return pulumi.get(self, "execution_role")

    @property
    @pulumi.getter(name="jupyterServerAppSettings")
    def jupyter_server_app_settings(self) -> Optional['outputs.DomainDefaultUserSettingsJupyterServerAppSettings']:
        """
        The Jupyter server's app settings. See Jupyter Server App Settings below.
        """
        return pulumi.get(self, "jupyter_server_app_settings")

    @property
    @pulumi.getter(name="kernelGatewayAppSettings")
    def kernel_gateway_app_settings(self) -> Optional['outputs.DomainDefaultUserSettingsKernelGatewayAppSettings']:
        """
        The kernel gateway app settings. See Kernel Gateway App Settings below.
        """
        return pulumi.get(self, "kernel_gateway_app_settings")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[Sequence[str]]:
        """
        The security groups.
        """
        return pulumi.get(self, "security_groups")

    @property
    @pulumi.getter(name="sharingSettings")
    def sharing_settings(self) -> Optional['outputs.DomainDefaultUserSettingsSharingSettings']:
        """
        The sharing settings. See Sharing Settings below.
        """
        return pulumi.get(self, "sharing_settings")

    @property
    @pulumi.getter(name="tensorBoardAppSettings")
    def tensor_board_app_settings(self) -> Optional['outputs.DomainDefaultUserSettingsTensorBoardAppSettings']:
        """
        The TensorBoard app settings. See TensorBoard App Settings below.
        """
        return pulumi.get(self, "tensor_board_app_settings")


@pulumi.output_type
class DomainDefaultUserSettingsJupyterServerAppSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultResourceSpec":
            suggest = "default_resource_spec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainDefaultUserSettingsJupyterServerAppSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainDefaultUserSettingsJupyterServerAppSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainDefaultUserSettingsJupyterServerAppSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_resource_spec: Optional['outputs.DomainDefaultUserSettingsJupyterServerAppSettingsDefaultResourceSpec'] = None):
        """
        :param 'DomainDefaultUserSettingsJupyterServerAppSettingsDefaultResourceSpecArgs' default_resource_spec: The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
        """
        if default_resource_spec is not None:
            pulumi.set(__self__, "default_resource_spec", default_resource_spec)

    @property
    @pulumi.getter(name="defaultResourceSpec")
    def default_resource_spec(self) -> Optional['outputs.DomainDefaultUserSettingsJupyterServerAppSettingsDefaultResourceSpec']:
        """
        The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
        """
        return pulumi.get(self, "default_resource_spec")


@pulumi.output_type
class DomainDefaultUserSettingsJupyterServerAppSettingsDefaultResourceSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "sagemakerImageArn":
            suggest = "sagemaker_image_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainDefaultUserSettingsJupyterServerAppSettingsDefaultResourceSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainDefaultUserSettingsJupyterServerAppSettingsDefaultResourceSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainDefaultUserSettingsJupyterServerAppSettingsDefaultResourceSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: Optional[str] = None,
                 sagemaker_image_arn: Optional[str] = None):
        """
        :param str instance_type: The instance type that the image version runs on.. For valid values see [Sagemaker Instance Types](https://docs.aws.amazon.com/sagemaker/latest/dg/notebooks-available-instance-types.html).
        :param str sagemaker_image_arn: The ARN of the SageMaker image that the image version belongs to.
        """
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if sagemaker_image_arn is not None:
            pulumi.set(__self__, "sagemaker_image_arn", sagemaker_image_arn)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[str]:
        """
        The instance type that the image version runs on.. For valid values see [Sagemaker Instance Types](https://docs.aws.amazon.com/sagemaker/latest/dg/notebooks-available-instance-types.html).
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="sagemakerImageArn")
    def sagemaker_image_arn(self) -> Optional[str]:
        """
        The ARN of the SageMaker image that the image version belongs to.
        """
        return pulumi.get(self, "sagemaker_image_arn")


@pulumi.output_type
class DomainDefaultUserSettingsKernelGatewayAppSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customImages":
            suggest = "custom_images"
        elif key == "defaultResourceSpec":
            suggest = "default_resource_spec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainDefaultUserSettingsKernelGatewayAppSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainDefaultUserSettingsKernelGatewayAppSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainDefaultUserSettingsKernelGatewayAppSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_images: Optional[Sequence['outputs.DomainDefaultUserSettingsKernelGatewayAppSettingsCustomImage']] = None,
                 default_resource_spec: Optional['outputs.DomainDefaultUserSettingsKernelGatewayAppSettingsDefaultResourceSpec'] = None):
        """
        :param Sequence['DomainDefaultUserSettingsKernelGatewayAppSettingsCustomImageArgs'] custom_images: A list of custom SageMaker images that are configured to run as a KernelGateway app. see Custom Image below.
        :param 'DomainDefaultUserSettingsKernelGatewayAppSettingsDefaultResourceSpecArgs' default_resource_spec: The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
        """
        if custom_images is not None:
            pulumi.set(__self__, "custom_images", custom_images)
        if default_resource_spec is not None:
            pulumi.set(__self__, "default_resource_spec", default_resource_spec)

    @property
    @pulumi.getter(name="customImages")
    def custom_images(self) -> Optional[Sequence['outputs.DomainDefaultUserSettingsKernelGatewayAppSettingsCustomImage']]:
        """
        A list of custom SageMaker images that are configured to run as a KernelGateway app. see Custom Image below.
        """
        return pulumi.get(self, "custom_images")

    @property
    @pulumi.getter(name="defaultResourceSpec")
    def default_resource_spec(self) -> Optional['outputs.DomainDefaultUserSettingsKernelGatewayAppSettingsDefaultResourceSpec']:
        """
        The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
        """
        return pulumi.get(self, "default_resource_spec")


@pulumi.output_type
class DomainDefaultUserSettingsKernelGatewayAppSettingsCustomImage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appImageConfigName":
            suggest = "app_image_config_name"
        elif key == "imageName":
            suggest = "image_name"
        elif key == "imageVersionNumber":
            suggest = "image_version_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainDefaultUserSettingsKernelGatewayAppSettingsCustomImage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainDefaultUserSettingsKernelGatewayAppSettingsCustomImage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainDefaultUserSettingsKernelGatewayAppSettingsCustomImage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_image_config_name: str,
                 image_name: str,
                 image_version_number: Optional[int] = None):
        """
        :param str app_image_config_name: The name of the App Image Config.
        :param str image_name: The name of the Custom Image.
        :param int image_version_number: The version number of the Custom Image.
        """
        pulumi.set(__self__, "app_image_config_name", app_image_config_name)
        pulumi.set(__self__, "image_name", image_name)
        if image_version_number is not None:
            pulumi.set(__self__, "image_version_number", image_version_number)

    @property
    @pulumi.getter(name="appImageConfigName")
    def app_image_config_name(self) -> str:
        """
        The name of the App Image Config.
        """
        return pulumi.get(self, "app_image_config_name")

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> str:
        """
        The name of the Custom Image.
        """
        return pulumi.get(self, "image_name")

    @property
    @pulumi.getter(name="imageVersionNumber")
    def image_version_number(self) -> Optional[int]:
        """
        The version number of the Custom Image.
        """
        return pulumi.get(self, "image_version_number")


@pulumi.output_type
class DomainDefaultUserSettingsKernelGatewayAppSettingsDefaultResourceSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "sagemakerImageArn":
            suggest = "sagemaker_image_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainDefaultUserSettingsKernelGatewayAppSettingsDefaultResourceSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainDefaultUserSettingsKernelGatewayAppSettingsDefaultResourceSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainDefaultUserSettingsKernelGatewayAppSettingsDefaultResourceSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: Optional[str] = None,
                 sagemaker_image_arn: Optional[str] = None):
        """
        :param str instance_type: The instance type that the image version runs on.. For valid values see [Sagemaker Instance Types](https://docs.aws.amazon.com/sagemaker/latest/dg/notebooks-available-instance-types.html).
        :param str sagemaker_image_arn: The ARN of the SageMaker image that the image version belongs to.
        """
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if sagemaker_image_arn is not None:
            pulumi.set(__self__, "sagemaker_image_arn", sagemaker_image_arn)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[str]:
        """
        The instance type that the image version runs on.. For valid values see [Sagemaker Instance Types](https://docs.aws.amazon.com/sagemaker/latest/dg/notebooks-available-instance-types.html).
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="sagemakerImageArn")
    def sagemaker_image_arn(self) -> Optional[str]:
        """
        The ARN of the SageMaker image that the image version belongs to.
        """
        return pulumi.get(self, "sagemaker_image_arn")


@pulumi.output_type
class DomainDefaultUserSettingsSharingSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "notebookOutputOption":
            suggest = "notebook_output_option"
        elif key == "s3KmsKeyId":
            suggest = "s3_kms_key_id"
        elif key == "s3OutputPath":
            suggest = "s3_output_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainDefaultUserSettingsSharingSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainDefaultUserSettingsSharingSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainDefaultUserSettingsSharingSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 notebook_output_option: Optional[str] = None,
                 s3_kms_key_id: Optional[str] = None,
                 s3_output_path: Optional[str] = None):
        """
        :param str notebook_output_option: Whether to include the notebook cell output when sharing the notebook. The default is `Disabled`. Valid values are `Allowed` and `Disabled`.
        :param str s3_kms_key_id: When `notebook_output_option` is Allowed, the AWS Key Management Service (KMS) encryption key ID used to encrypt the notebook cell output in the Amazon S3 bucket.
        :param str s3_output_path: When `notebook_output_option` is Allowed, the Amazon S3 bucket used to save the notebook cell output.
        """
        if notebook_output_option is not None:
            pulumi.set(__self__, "notebook_output_option", notebook_output_option)
        if s3_kms_key_id is not None:
            pulumi.set(__self__, "s3_kms_key_id", s3_kms_key_id)
        if s3_output_path is not None:
            pulumi.set(__self__, "s3_output_path", s3_output_path)

    @property
    @pulumi.getter(name="notebookOutputOption")
    def notebook_output_option(self) -> Optional[str]:
        """
        Whether to include the notebook cell output when sharing the notebook. The default is `Disabled`. Valid values are `Allowed` and `Disabled`.
        """
        return pulumi.get(self, "notebook_output_option")

    @property
    @pulumi.getter(name="s3KmsKeyId")
    def s3_kms_key_id(self) -> Optional[str]:
        """
        When `notebook_output_option` is Allowed, the AWS Key Management Service (KMS) encryption key ID used to encrypt the notebook cell output in the Amazon S3 bucket.
        """
        return pulumi.get(self, "s3_kms_key_id")

    @property
    @pulumi.getter(name="s3OutputPath")
    def s3_output_path(self) -> Optional[str]:
        """
        When `notebook_output_option` is Allowed, the Amazon S3 bucket used to save the notebook cell output.
        """
        return pulumi.get(self, "s3_output_path")


@pulumi.output_type
class DomainDefaultUserSettingsTensorBoardAppSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultResourceSpec":
            suggest = "default_resource_spec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainDefaultUserSettingsTensorBoardAppSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainDefaultUserSettingsTensorBoardAppSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainDefaultUserSettingsTensorBoardAppSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_resource_spec: Optional['outputs.DomainDefaultUserSettingsTensorBoardAppSettingsDefaultResourceSpec'] = None):
        """
        :param 'DomainDefaultUserSettingsTensorBoardAppSettingsDefaultResourceSpecArgs' default_resource_spec: The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
        """
        if default_resource_spec is not None:
            pulumi.set(__self__, "default_resource_spec", default_resource_spec)

    @property
    @pulumi.getter(name="defaultResourceSpec")
    def default_resource_spec(self) -> Optional['outputs.DomainDefaultUserSettingsTensorBoardAppSettingsDefaultResourceSpec']:
        """
        The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
        """
        return pulumi.get(self, "default_resource_spec")


@pulumi.output_type
class DomainDefaultUserSettingsTensorBoardAppSettingsDefaultResourceSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "sagemakerImageArn":
            suggest = "sagemaker_image_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainDefaultUserSettingsTensorBoardAppSettingsDefaultResourceSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainDefaultUserSettingsTensorBoardAppSettingsDefaultResourceSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainDefaultUserSettingsTensorBoardAppSettingsDefaultResourceSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: Optional[str] = None,
                 sagemaker_image_arn: Optional[str] = None):
        """
        :param str instance_type: The instance type that the image version runs on.. For valid values see [Sagemaker Instance Types](https://docs.aws.amazon.com/sagemaker/latest/dg/notebooks-available-instance-types.html).
        :param str sagemaker_image_arn: The ARN of the SageMaker image that the image version belongs to.
        """
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if sagemaker_image_arn is not None:
            pulumi.set(__self__, "sagemaker_image_arn", sagemaker_image_arn)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[str]:
        """
        The instance type that the image version runs on.. For valid values see [Sagemaker Instance Types](https://docs.aws.amazon.com/sagemaker/latest/dg/notebooks-available-instance-types.html).
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="sagemakerImageArn")
    def sagemaker_image_arn(self) -> Optional[str]:
        """
        The ARN of the SageMaker image that the image version belongs to.
        """
        return pulumi.get(self, "sagemaker_image_arn")


@pulumi.output_type
class DomainRetentionPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "homeEfsFileSystem":
            suggest = "home_efs_file_system"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainRetentionPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainRetentionPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainRetentionPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 home_efs_file_system: Optional[str] = None):
        """
        :param str home_efs_file_system: The retention policy for data stored on an Amazon Elastic File System (EFS) volume. Default value is `Retain`.
        """
        if home_efs_file_system is not None:
            pulumi.set(__self__, "home_efs_file_system", home_efs_file_system)

    @property
    @pulumi.getter(name="homeEfsFileSystem")
    def home_efs_file_system(self) -> Optional[str]:
        """
        The retention policy for data stored on an Amazon Elastic File System (EFS) volume. Default value is `Retain`.
        """
        return pulumi.get(self, "home_efs_file_system")


@pulumi.output_type
class EndpointConfigurationDataCaptureConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "captureOptions":
            suggest = "capture_options"
        elif key == "destinationS3Uri":
            suggest = "destination_s3_uri"
        elif key == "initialSamplingPercentage":
            suggest = "initial_sampling_percentage"
        elif key == "captureContentTypeHeader":
            suggest = "capture_content_type_header"
        elif key == "enableCapture":
            suggest = "enable_capture"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointConfigurationDataCaptureConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointConfigurationDataCaptureConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointConfigurationDataCaptureConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capture_options: Sequence['outputs.EndpointConfigurationDataCaptureConfigCaptureOption'],
                 destination_s3_uri: str,
                 initial_sampling_percentage: int,
                 capture_content_type_header: Optional['outputs.EndpointConfigurationDataCaptureConfigCaptureContentTypeHeader'] = None,
                 enable_capture: Optional[bool] = None,
                 kms_key_id: Optional[str] = None):
        """
        :param Sequence['EndpointConfigurationDataCaptureConfigCaptureOptionArgs'] capture_options: Specifies what data to capture. Fields are documented below.
        :param str destination_s3_uri: The URL for S3 location where the captured data is stored.
        :param int initial_sampling_percentage: Portion of data to capture. Should be between 0 and 100.
        :param 'EndpointConfigurationDataCaptureConfigCaptureContentTypeHeaderArgs' capture_content_type_header: The content type headers to capture. Fields are documented below.
        :param bool enable_capture: Flag to enable data capture. Defaults to `false`.
        :param str kms_key_id: Amazon Resource Name (ARN) of a AWS Key Management Service key that Amazon SageMaker uses to encrypt the captured data on Amazon S3.
        """
        pulumi.set(__self__, "capture_options", capture_options)
        pulumi.set(__self__, "destination_s3_uri", destination_s3_uri)
        pulumi.set(__self__, "initial_sampling_percentage", initial_sampling_percentage)
        if capture_content_type_header is not None:
            pulumi.set(__self__, "capture_content_type_header", capture_content_type_header)
        if enable_capture is not None:
            pulumi.set(__self__, "enable_capture", enable_capture)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)

    @property
    @pulumi.getter(name="captureOptions")
    def capture_options(self) -> Sequence['outputs.EndpointConfigurationDataCaptureConfigCaptureOption']:
        """
        Specifies what data to capture. Fields are documented below.
        """
        return pulumi.get(self, "capture_options")

    @property
    @pulumi.getter(name="destinationS3Uri")
    def destination_s3_uri(self) -> str:
        """
        The URL for S3 location where the captured data is stored.
        """
        return pulumi.get(self, "destination_s3_uri")

    @property
    @pulumi.getter(name="initialSamplingPercentage")
    def initial_sampling_percentage(self) -> int:
        """
        Portion of data to capture. Should be between 0 and 100.
        """
        return pulumi.get(self, "initial_sampling_percentage")

    @property
    @pulumi.getter(name="captureContentTypeHeader")
    def capture_content_type_header(self) -> Optional['outputs.EndpointConfigurationDataCaptureConfigCaptureContentTypeHeader']:
        """
        The content type headers to capture. Fields are documented below.
        """
        return pulumi.get(self, "capture_content_type_header")

    @property
    @pulumi.getter(name="enableCapture")
    def enable_capture(self) -> Optional[bool]:
        """
        Flag to enable data capture. Defaults to `false`.
        """
        return pulumi.get(self, "enable_capture")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        Amazon Resource Name (ARN) of a AWS Key Management Service key that Amazon SageMaker uses to encrypt the captured data on Amazon S3.
        """
        return pulumi.get(self, "kms_key_id")


@pulumi.output_type
class EndpointConfigurationDataCaptureConfigCaptureContentTypeHeader(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "csvContentTypes":
            suggest = "csv_content_types"
        elif key == "jsonContentTypes":
            suggest = "json_content_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointConfigurationDataCaptureConfigCaptureContentTypeHeader. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointConfigurationDataCaptureConfigCaptureContentTypeHeader.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointConfigurationDataCaptureConfigCaptureContentTypeHeader.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 csv_content_types: Optional[Sequence[str]] = None,
                 json_content_types: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] csv_content_types: The CSV content type headers to capture.
        :param Sequence[str] json_content_types: The JSON content type headers to capture.
        """
        if csv_content_types is not None:
            pulumi.set(__self__, "csv_content_types", csv_content_types)
        if json_content_types is not None:
            pulumi.set(__self__, "json_content_types", json_content_types)

    @property
    @pulumi.getter(name="csvContentTypes")
    def csv_content_types(self) -> Optional[Sequence[str]]:
        """
        The CSV content type headers to capture.
        """
        return pulumi.get(self, "csv_content_types")

    @property
    @pulumi.getter(name="jsonContentTypes")
    def json_content_types(self) -> Optional[Sequence[str]]:
        """
        The JSON content type headers to capture.
        """
        return pulumi.get(self, "json_content_types")


@pulumi.output_type
class EndpointConfigurationDataCaptureConfigCaptureOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "captureMode":
            suggest = "capture_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointConfigurationDataCaptureConfigCaptureOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointConfigurationDataCaptureConfigCaptureOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointConfigurationDataCaptureConfigCaptureOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capture_mode: str):
        """
        :param str capture_mode: Specifies the data to be captured. Should be one of `Input` or `Output`.
        """
        pulumi.set(__self__, "capture_mode", capture_mode)

    @property
    @pulumi.getter(name="captureMode")
    def capture_mode(self) -> str:
        """
        Specifies the data to be captured. Should be one of `Input` or `Output`.
        """
        return pulumi.get(self, "capture_mode")


@pulumi.output_type
class EndpointConfigurationProductionVariant(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "initialInstanceCount":
            suggest = "initial_instance_count"
        elif key == "instanceType":
            suggest = "instance_type"
        elif key == "modelName":
            suggest = "model_name"
        elif key == "acceleratorType":
            suggest = "accelerator_type"
        elif key == "initialVariantWeight":
            suggest = "initial_variant_weight"
        elif key == "variantName":
            suggest = "variant_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointConfigurationProductionVariant. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointConfigurationProductionVariant.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointConfigurationProductionVariant.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 initial_instance_count: int,
                 instance_type: str,
                 model_name: str,
                 accelerator_type: Optional[str] = None,
                 initial_variant_weight: Optional[float] = None,
                 variant_name: Optional[str] = None):
        """
        :param int initial_instance_count: Initial number of instances used for auto-scaling.
        :param str instance_type: The type of instance to start.
        :param str model_name: The name of the model to use.
        :param str accelerator_type: The size of the Elastic Inference (EI) instance to use for the production variant.
        :param float initial_variant_weight: Determines initial traffic distribution among all of the models that you specify in the endpoint configuration. If unspecified, it defaults to 1.0.
        :param str variant_name: The name of the variant. If omitted, this provider will assign a random, unique name.
        """
        pulumi.set(__self__, "initial_instance_count", initial_instance_count)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "model_name", model_name)
        if accelerator_type is not None:
            pulumi.set(__self__, "accelerator_type", accelerator_type)
        if initial_variant_weight is not None:
            pulumi.set(__self__, "initial_variant_weight", initial_variant_weight)
        if variant_name is not None:
            pulumi.set(__self__, "variant_name", variant_name)

    @property
    @pulumi.getter(name="initialInstanceCount")
    def initial_instance_count(self) -> int:
        """
        Initial number of instances used for auto-scaling.
        """
        return pulumi.get(self, "initial_instance_count")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        The type of instance to start.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="modelName")
    def model_name(self) -> str:
        """
        The name of the model to use.
        """
        return pulumi.get(self, "model_name")

    @property
    @pulumi.getter(name="acceleratorType")
    def accelerator_type(self) -> Optional[str]:
        """
        The size of the Elastic Inference (EI) instance to use for the production variant.
        """
        return pulumi.get(self, "accelerator_type")

    @property
    @pulumi.getter(name="initialVariantWeight")
    def initial_variant_weight(self) -> Optional[float]:
        """
        Determines initial traffic distribution among all of the models that you specify in the endpoint configuration. If unspecified, it defaults to 1.0.
        """
        return pulumi.get(self, "initial_variant_weight")

    @property
    @pulumi.getter(name="variantName")
    def variant_name(self) -> Optional[str]:
        """
        The name of the variant. If omitted, this provider will assign a random, unique name.
        """
        return pulumi.get(self, "variant_name")


@pulumi.output_type
class FeatureGroupFeatureDefinition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "featureName":
            suggest = "feature_name"
        elif key == "featureType":
            suggest = "feature_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FeatureGroupFeatureDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FeatureGroupFeatureDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FeatureGroupFeatureDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 feature_name: Optional[str] = None,
                 feature_type: Optional[str] = None):
        """
        :param str feature_name: The name of a feature. `feature_name` cannot be any of the following: `is_deleted`, `write_time`, `api_invocation_time`.
        :param str feature_type: The value type of a feature. Valid values are `Integral`, `Fractional`, or `String`.
        """
        if feature_name is not None:
            pulumi.set(__self__, "feature_name", feature_name)
        if feature_type is not None:
            pulumi.set(__self__, "feature_type", feature_type)

    @property
    @pulumi.getter(name="featureName")
    def feature_name(self) -> Optional[str]:
        """
        The name of a feature. `feature_name` cannot be any of the following: `is_deleted`, `write_time`, `api_invocation_time`.
        """
        return pulumi.get(self, "feature_name")

    @property
    @pulumi.getter(name="featureType")
    def feature_type(self) -> Optional[str]:
        """
        The value type of a feature. Valid values are `Integral`, `Fractional`, or `String`.
        """
        return pulumi.get(self, "feature_type")


@pulumi.output_type
class FeatureGroupOfflineStoreConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3StorageConfig":
            suggest = "s3_storage_config"
        elif key == "dataCatalogConfig":
            suggest = "data_catalog_config"
        elif key == "disableGlueTableCreation":
            suggest = "disable_glue_table_creation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FeatureGroupOfflineStoreConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FeatureGroupOfflineStoreConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FeatureGroupOfflineStoreConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_storage_config: 'outputs.FeatureGroupOfflineStoreConfigS3StorageConfig',
                 data_catalog_config: Optional['outputs.FeatureGroupOfflineStoreConfigDataCatalogConfig'] = None,
                 disable_glue_table_creation: Optional[bool] = None):
        """
        :param 'FeatureGroupOfflineStoreConfigS3StorageConfigArgs' s3_storage_config: The Amazon Simple Storage (Amazon S3) location of OfflineStore. See S3 Storage Config Below.
        :param 'FeatureGroupOfflineStoreConfigDataCatalogConfigArgs' data_catalog_config: The meta data of the Glue table that is autogenerated when an OfflineStore is created. See Data Catalog Config Below.
        :param bool disable_glue_table_creation: Set to `true` to turn Online Store On.
        """
        pulumi.set(__self__, "s3_storage_config", s3_storage_config)
        if data_catalog_config is not None:
            pulumi.set(__self__, "data_catalog_config", data_catalog_config)
        if disable_glue_table_creation is not None:
            pulumi.set(__self__, "disable_glue_table_creation", disable_glue_table_creation)

    @property
    @pulumi.getter(name="s3StorageConfig")
    def s3_storage_config(self) -> 'outputs.FeatureGroupOfflineStoreConfigS3StorageConfig':
        """
        The Amazon Simple Storage (Amazon S3) location of OfflineStore. See S3 Storage Config Below.
        """
        return pulumi.get(self, "s3_storage_config")

    @property
    @pulumi.getter(name="dataCatalogConfig")
    def data_catalog_config(self) -> Optional['outputs.FeatureGroupOfflineStoreConfigDataCatalogConfig']:
        """
        The meta data of the Glue table that is autogenerated when an OfflineStore is created. See Data Catalog Config Below.
        """
        return pulumi.get(self, "data_catalog_config")

    @property
    @pulumi.getter(name="disableGlueTableCreation")
    def disable_glue_table_creation(self) -> Optional[bool]:
        """
        Set to `true` to turn Online Store On.
        """
        return pulumi.get(self, "disable_glue_table_creation")


@pulumi.output_type
class FeatureGroupOfflineStoreConfigDataCatalogConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tableName":
            suggest = "table_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FeatureGroupOfflineStoreConfigDataCatalogConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FeatureGroupOfflineStoreConfigDataCatalogConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FeatureGroupOfflineStoreConfigDataCatalogConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 catalog: Optional[str] = None,
                 database: Optional[str] = None,
                 table_name: Optional[str] = None):
        """
        :param str catalog: The name of the Glue table catalog.
        :param str database: The name of the Glue table database.
        :param str table_name: The name of the Glue table.
        """
        if catalog is not None:
            pulumi.set(__self__, "catalog", catalog)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if table_name is not None:
            pulumi.set(__self__, "table_name", table_name)

    @property
    @pulumi.getter
    def catalog(self) -> Optional[str]:
        """
        The name of the Glue table catalog.
        """
        return pulumi.get(self, "catalog")

    @property
    @pulumi.getter
    def database(self) -> Optional[str]:
        """
        The name of the Glue table database.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> Optional[str]:
        """
        The name of the Glue table.
        """
        return pulumi.get(self, "table_name")


@pulumi.output_type
class FeatureGroupOfflineStoreConfigS3StorageConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Uri":
            suggest = "s3_uri"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FeatureGroupOfflineStoreConfigS3StorageConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FeatureGroupOfflineStoreConfigS3StorageConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FeatureGroupOfflineStoreConfigS3StorageConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_uri: str,
                 kms_key_id: Optional[str] = None):
        """
        :param str s3_uri: The S3 URI, or location in Amazon S3, of OfflineStore.
        :param str kms_key_id: The ID of the AWS Key Management Service (AWS KMS) key that SageMaker Feature Store uses to encrypt the Amazon S3 objects at rest using Amazon S3 server-side encryption.
        """
        pulumi.set(__self__, "s3_uri", s3_uri)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> str:
        """
        The S3 URI, or location in Amazon S3, of OfflineStore.
        """
        return pulumi.get(self, "s3_uri")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        The ID of the AWS Key Management Service (AWS KMS) key that SageMaker Feature Store uses to encrypt the Amazon S3 objects at rest using Amazon S3 server-side encryption.
        """
        return pulumi.get(self, "kms_key_id")


@pulumi.output_type
class FeatureGroupOnlineStoreConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableOnlineStore":
            suggest = "enable_online_store"
        elif key == "securityConfig":
            suggest = "security_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FeatureGroupOnlineStoreConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FeatureGroupOnlineStoreConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FeatureGroupOnlineStoreConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_online_store: Optional[bool] = None,
                 security_config: Optional['outputs.FeatureGroupOnlineStoreConfigSecurityConfig'] = None):
        """
        :param bool enable_online_store: Set to `true` to disable the automatic creation of an AWS Glue table when configuring an OfflineStore.
        :param 'FeatureGroupOnlineStoreConfigSecurityConfigArgs' security_config: Security config for at-rest encryption of your OnlineStore. See Security Config Below.
        """
        if enable_online_store is not None:
            pulumi.set(__self__, "enable_online_store", enable_online_store)
        if security_config is not None:
            pulumi.set(__self__, "security_config", security_config)

    @property
    @pulumi.getter(name="enableOnlineStore")
    def enable_online_store(self) -> Optional[bool]:
        """
        Set to `true` to disable the automatic creation of an AWS Glue table when configuring an OfflineStore.
        """
        return pulumi.get(self, "enable_online_store")

    @property
    @pulumi.getter(name="securityConfig")
    def security_config(self) -> Optional['outputs.FeatureGroupOnlineStoreConfigSecurityConfig']:
        """
        Security config for at-rest encryption of your OnlineStore. See Security Config Below.
        """
        return pulumi.get(self, "security_config")


@pulumi.output_type
class FeatureGroupOnlineStoreConfigSecurityConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyId":
            suggest = "kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FeatureGroupOnlineStoreConfigSecurityConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FeatureGroupOnlineStoreConfigSecurityConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FeatureGroupOnlineStoreConfigSecurityConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_id: Optional[str] = None):
        """
        :param str kms_key_id: The ID of the AWS Key Management Service (AWS KMS) key that SageMaker Feature Store uses to encrypt the Amazon S3 objects at rest using Amazon S3 server-side encryption.
        """
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        The ID of the AWS Key Management Service (AWS KMS) key that SageMaker Feature Store uses to encrypt the Amazon S3 objects at rest using Amazon S3 server-side encryption.
        """
        return pulumi.get(self, "kms_key_id")


@pulumi.output_type
class ModelContainer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerHostname":
            suggest = "container_hostname"
        elif key == "imageConfig":
            suggest = "image_config"
        elif key == "modelDataUrl":
            suggest = "model_data_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelContainer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelContainer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelContainer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image: str,
                 container_hostname: Optional[str] = None,
                 environment: Optional[Mapping[str, str]] = None,
                 image_config: Optional['outputs.ModelContainerImageConfig'] = None,
                 mode: Optional[str] = None,
                 model_data_url: Optional[str] = None):
        """
        :param str image: The registry path where the inference code image is stored in Amazon ECR.
        :param str container_hostname: The DNS host name for the container.
        :param Mapping[str, str] environment: Environment variables for the Docker container.
               A list of key value pairs.
        :param 'ModelContainerImageConfigArgs' image_config: Specifies whether the model container is in Amazon ECR or a private Docker registry accessible from your Amazon Virtual Private Cloud (VPC). For more information see [Using a Private Docker Registry for Real-Time Inference Containers](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-containers-inference-private.html). see Image Config.
        :param str mode: The container hosts value `SingleModel/MultiModel`. The default value is `SingleModel`.
        :param str model_data_url: The URL for the S3 location where model artifacts are stored.
        """
        pulumi.set(__self__, "image", image)
        if container_hostname is not None:
            pulumi.set(__self__, "container_hostname", container_hostname)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if image_config is not None:
            pulumi.set(__self__, "image_config", image_config)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if model_data_url is not None:
            pulumi.set(__self__, "model_data_url", model_data_url)

    @property
    @pulumi.getter
    def image(self) -> str:
        """
        The registry path where the inference code image is stored in Amazon ECR.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="containerHostname")
    def container_hostname(self) -> Optional[str]:
        """
        The DNS host name for the container.
        """
        return pulumi.get(self, "container_hostname")

    @property
    @pulumi.getter
    def environment(self) -> Optional[Mapping[str, str]]:
        """
        Environment variables for the Docker container.
        A list of key value pairs.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="imageConfig")
    def image_config(self) -> Optional['outputs.ModelContainerImageConfig']:
        """
        Specifies whether the model container is in Amazon ECR or a private Docker registry accessible from your Amazon Virtual Private Cloud (VPC). For more information see [Using a Private Docker Registry for Real-Time Inference Containers](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-containers-inference-private.html). see Image Config.
        """
        return pulumi.get(self, "image_config")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        The container hosts value `SingleModel/MultiModel`. The default value is `SingleModel`.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="modelDataUrl")
    def model_data_url(self) -> Optional[str]:
        """
        The URL for the S3 location where model artifacts are stored.
        """
        return pulumi.get(self, "model_data_url")


@pulumi.output_type
class ModelContainerImageConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repositoryAccessMode":
            suggest = "repository_access_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelContainerImageConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelContainerImageConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelContainerImageConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 repository_access_mode: str):
        """
        :param str repository_access_mode: Specifies whether the model container is in Amazon ECR or a private Docker registry accessible from your Amazon Virtual Private Cloud (VPC). Allowed values are: `Platform` and `Vpc`.
        """
        pulumi.set(__self__, "repository_access_mode", repository_access_mode)

    @property
    @pulumi.getter(name="repositoryAccessMode")
    def repository_access_mode(self) -> str:
        """
        Specifies whether the model container is in Amazon ECR or a private Docker registry accessible from your Amazon Virtual Private Cloud (VPC). Allowed values are: `Platform` and `Vpc`.
        """
        return pulumi.get(self, "repository_access_mode")


@pulumi.output_type
class ModelPrimaryContainer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerHostname":
            suggest = "container_hostname"
        elif key == "imageConfig":
            suggest = "image_config"
        elif key == "modelDataUrl":
            suggest = "model_data_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelPrimaryContainer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelPrimaryContainer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelPrimaryContainer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image: str,
                 container_hostname: Optional[str] = None,
                 environment: Optional[Mapping[str, str]] = None,
                 image_config: Optional['outputs.ModelPrimaryContainerImageConfig'] = None,
                 mode: Optional[str] = None,
                 model_data_url: Optional[str] = None):
        """
        :param str image: The registry path where the inference code image is stored in Amazon ECR.
        :param str container_hostname: The DNS host name for the container.
        :param Mapping[str, str] environment: Environment variables for the Docker container.
               A list of key value pairs.
        :param 'ModelPrimaryContainerImageConfigArgs' image_config: Specifies whether the model container is in Amazon ECR or a private Docker registry accessible from your Amazon Virtual Private Cloud (VPC). For more information see [Using a Private Docker Registry for Real-Time Inference Containers](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-containers-inference-private.html). see Image Config.
        :param str mode: The container hosts value `SingleModel/MultiModel`. The default value is `SingleModel`.
        :param str model_data_url: The URL for the S3 location where model artifacts are stored.
        """
        pulumi.set(__self__, "image", image)
        if container_hostname is not None:
            pulumi.set(__self__, "container_hostname", container_hostname)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if image_config is not None:
            pulumi.set(__self__, "image_config", image_config)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if model_data_url is not None:
            pulumi.set(__self__, "model_data_url", model_data_url)

    @property
    @pulumi.getter
    def image(self) -> str:
        """
        The registry path where the inference code image is stored in Amazon ECR.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="containerHostname")
    def container_hostname(self) -> Optional[str]:
        """
        The DNS host name for the container.
        """
        return pulumi.get(self, "container_hostname")

    @property
    @pulumi.getter
    def environment(self) -> Optional[Mapping[str, str]]:
        """
        Environment variables for the Docker container.
        A list of key value pairs.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="imageConfig")
    def image_config(self) -> Optional['outputs.ModelPrimaryContainerImageConfig']:
        """
        Specifies whether the model container is in Amazon ECR or a private Docker registry accessible from your Amazon Virtual Private Cloud (VPC). For more information see [Using a Private Docker Registry for Real-Time Inference Containers](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-containers-inference-private.html). see Image Config.
        """
        return pulumi.get(self, "image_config")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        The container hosts value `SingleModel/MultiModel`. The default value is `SingleModel`.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="modelDataUrl")
    def model_data_url(self) -> Optional[str]:
        """
        The URL for the S3 location where model artifacts are stored.
        """
        return pulumi.get(self, "model_data_url")


@pulumi.output_type
class ModelPrimaryContainerImageConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repositoryAccessMode":
            suggest = "repository_access_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelPrimaryContainerImageConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelPrimaryContainerImageConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelPrimaryContainerImageConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 repository_access_mode: str):
        """
        :param str repository_access_mode: Specifies whether the model container is in Amazon ECR or a private Docker registry accessible from your Amazon Virtual Private Cloud (VPC). Allowed values are: `Platform` and `Vpc`.
        """
        pulumi.set(__self__, "repository_access_mode", repository_access_mode)

    @property
    @pulumi.getter(name="repositoryAccessMode")
    def repository_access_mode(self) -> str:
        """
        Specifies whether the model container is in Amazon ECR or a private Docker registry accessible from your Amazon Virtual Private Cloud (VPC). Allowed values are: `Platform` and `Vpc`.
        """
        return pulumi.get(self, "repository_access_mode")


@pulumi.output_type
class ModelVpcConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "securityGroupIds":
            suggest = "security_group_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelVpcConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelVpcConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelVpcConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 security_group_ids: Sequence[str],
                 subnets: Sequence[str]):
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "subnets", subnets)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[str]:
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter
    def subnets(self) -> Sequence[str]:
        return pulumi.get(self, "subnets")


@pulumi.output_type
class UserProfileUserSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executionRole":
            suggest = "execution_role"
        elif key == "jupyterServerAppSettings":
            suggest = "jupyter_server_app_settings"
        elif key == "kernelGatewayAppSettings":
            suggest = "kernel_gateway_app_settings"
        elif key == "securityGroups":
            suggest = "security_groups"
        elif key == "sharingSettings":
            suggest = "sharing_settings"
        elif key == "tensorBoardAppSettings":
            suggest = "tensor_board_app_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserProfileUserSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserProfileUserSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserProfileUserSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execution_role: str,
                 jupyter_server_app_settings: Optional['outputs.UserProfileUserSettingsJupyterServerAppSettings'] = None,
                 kernel_gateway_app_settings: Optional['outputs.UserProfileUserSettingsKernelGatewayAppSettings'] = None,
                 security_groups: Optional[Sequence[str]] = None,
                 sharing_settings: Optional['outputs.UserProfileUserSettingsSharingSettings'] = None,
                 tensor_board_app_settings: Optional['outputs.UserProfileUserSettingsTensorBoardAppSettings'] = None):
        """
        :param str execution_role: The execution role ARN for the user.
        :param 'UserProfileUserSettingsJupyterServerAppSettingsArgs' jupyter_server_app_settings: The Jupyter server's app settings. See Jupyter Server App Settings below.
        :param 'UserProfileUserSettingsKernelGatewayAppSettingsArgs' kernel_gateway_app_settings: The kernel gateway app settings. See Kernel Gateway App Settings below.
        :param Sequence[str] security_groups: The security groups.
        :param 'UserProfileUserSettingsSharingSettingsArgs' sharing_settings: The sharing settings. See Sharing Settings below.
        :param 'UserProfileUserSettingsTensorBoardAppSettingsArgs' tensor_board_app_settings: The TensorBoard app settings. See TensorBoard App Settings below.
        """
        pulumi.set(__self__, "execution_role", execution_role)
        if jupyter_server_app_settings is not None:
            pulumi.set(__self__, "jupyter_server_app_settings", jupyter_server_app_settings)
        if kernel_gateway_app_settings is not None:
            pulumi.set(__self__, "kernel_gateway_app_settings", kernel_gateway_app_settings)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if sharing_settings is not None:
            pulumi.set(__self__, "sharing_settings", sharing_settings)
        if tensor_board_app_settings is not None:
            pulumi.set(__self__, "tensor_board_app_settings", tensor_board_app_settings)

    @property
    @pulumi.getter(name="executionRole")
    def execution_role(self) -> str:
        """
        The execution role ARN for the user.
        """
        return pulumi.get(self, "execution_role")

    @property
    @pulumi.getter(name="jupyterServerAppSettings")
    def jupyter_server_app_settings(self) -> Optional['outputs.UserProfileUserSettingsJupyterServerAppSettings']:
        """
        The Jupyter server's app settings. See Jupyter Server App Settings below.
        """
        return pulumi.get(self, "jupyter_server_app_settings")

    @property
    @pulumi.getter(name="kernelGatewayAppSettings")
    def kernel_gateway_app_settings(self) -> Optional['outputs.UserProfileUserSettingsKernelGatewayAppSettings']:
        """
        The kernel gateway app settings. See Kernel Gateway App Settings below.
        """
        return pulumi.get(self, "kernel_gateway_app_settings")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[Sequence[str]]:
        """
        The security groups.
        """
        return pulumi.get(self, "security_groups")

    @property
    @pulumi.getter(name="sharingSettings")
    def sharing_settings(self) -> Optional['outputs.UserProfileUserSettingsSharingSettings']:
        """
        The sharing settings. See Sharing Settings below.
        """
        return pulumi.get(self, "sharing_settings")

    @property
    @pulumi.getter(name="tensorBoardAppSettings")
    def tensor_board_app_settings(self) -> Optional['outputs.UserProfileUserSettingsTensorBoardAppSettings']:
        """
        The TensorBoard app settings. See TensorBoard App Settings below.
        """
        return pulumi.get(self, "tensor_board_app_settings")


@pulumi.output_type
class UserProfileUserSettingsJupyterServerAppSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultResourceSpec":
            suggest = "default_resource_spec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserProfileUserSettingsJupyterServerAppSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserProfileUserSettingsJupyterServerAppSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserProfileUserSettingsJupyterServerAppSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_resource_spec: 'outputs.UserProfileUserSettingsJupyterServerAppSettingsDefaultResourceSpec'):
        """
        :param 'UserProfileUserSettingsJupyterServerAppSettingsDefaultResourceSpecArgs' default_resource_spec: The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
        """
        pulumi.set(__self__, "default_resource_spec", default_resource_spec)

    @property
    @pulumi.getter(name="defaultResourceSpec")
    def default_resource_spec(self) -> 'outputs.UserProfileUserSettingsJupyterServerAppSettingsDefaultResourceSpec':
        """
        The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
        """
        return pulumi.get(self, "default_resource_spec")


@pulumi.output_type
class UserProfileUserSettingsJupyterServerAppSettingsDefaultResourceSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "sagemakerImageArn":
            suggest = "sagemaker_image_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserProfileUserSettingsJupyterServerAppSettingsDefaultResourceSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserProfileUserSettingsJupyterServerAppSettingsDefaultResourceSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserProfileUserSettingsJupyterServerAppSettingsDefaultResourceSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: Optional[str] = None,
                 sagemaker_image_arn: Optional[str] = None):
        """
        :param str instance_type: The instance type.
        :param str sagemaker_image_arn: The Amazon Resource Name (ARN) of the SageMaker image created on the instance.
        """
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if sagemaker_image_arn is not None:
            pulumi.set(__self__, "sagemaker_image_arn", sagemaker_image_arn)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[str]:
        """
        The instance type.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="sagemakerImageArn")
    def sagemaker_image_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the SageMaker image created on the instance.
        """
        return pulumi.get(self, "sagemaker_image_arn")


@pulumi.output_type
class UserProfileUserSettingsKernelGatewayAppSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultResourceSpec":
            suggest = "default_resource_spec"
        elif key == "customImages":
            suggest = "custom_images"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserProfileUserSettingsKernelGatewayAppSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserProfileUserSettingsKernelGatewayAppSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserProfileUserSettingsKernelGatewayAppSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_resource_spec: 'outputs.UserProfileUserSettingsKernelGatewayAppSettingsDefaultResourceSpec',
                 custom_images: Optional[Sequence['outputs.UserProfileUserSettingsKernelGatewayAppSettingsCustomImage']] = None):
        """
        :param 'UserProfileUserSettingsKernelGatewayAppSettingsDefaultResourceSpecArgs' default_resource_spec: The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
        :param Sequence['UserProfileUserSettingsKernelGatewayAppSettingsCustomImageArgs'] custom_images: A list of custom SageMaker images that are configured to run as a KernelGateway app. see Custom Image below.
        """
        pulumi.set(__self__, "default_resource_spec", default_resource_spec)
        if custom_images is not None:
            pulumi.set(__self__, "custom_images", custom_images)

    @property
    @pulumi.getter(name="defaultResourceSpec")
    def default_resource_spec(self) -> 'outputs.UserProfileUserSettingsKernelGatewayAppSettingsDefaultResourceSpec':
        """
        The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
        """
        return pulumi.get(self, "default_resource_spec")

    @property
    @pulumi.getter(name="customImages")
    def custom_images(self) -> Optional[Sequence['outputs.UserProfileUserSettingsKernelGatewayAppSettingsCustomImage']]:
        """
        A list of custom SageMaker images that are configured to run as a KernelGateway app. see Custom Image below.
        """
        return pulumi.get(self, "custom_images")


@pulumi.output_type
class UserProfileUserSettingsKernelGatewayAppSettingsCustomImage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appImageConfigName":
            suggest = "app_image_config_name"
        elif key == "imageName":
            suggest = "image_name"
        elif key == "imageVersionNumber":
            suggest = "image_version_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserProfileUserSettingsKernelGatewayAppSettingsCustomImage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserProfileUserSettingsKernelGatewayAppSettingsCustomImage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserProfileUserSettingsKernelGatewayAppSettingsCustomImage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_image_config_name: str,
                 image_name: str,
                 image_version_number: Optional[int] = None):
        """
        :param str app_image_config_name: The name of the App Image Config.
        :param str image_name: The name of the Custom Image.
        :param int image_version_number: The version number of the Custom Image.
        """
        pulumi.set(__self__, "app_image_config_name", app_image_config_name)
        pulumi.set(__self__, "image_name", image_name)
        if image_version_number is not None:
            pulumi.set(__self__, "image_version_number", image_version_number)

    @property
    @pulumi.getter(name="appImageConfigName")
    def app_image_config_name(self) -> str:
        """
        The name of the App Image Config.
        """
        return pulumi.get(self, "app_image_config_name")

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> str:
        """
        The name of the Custom Image.
        """
        return pulumi.get(self, "image_name")

    @property
    @pulumi.getter(name="imageVersionNumber")
    def image_version_number(self) -> Optional[int]:
        """
        The version number of the Custom Image.
        """
        return pulumi.get(self, "image_version_number")


@pulumi.output_type
class UserProfileUserSettingsKernelGatewayAppSettingsDefaultResourceSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "sagemakerImageArn":
            suggest = "sagemaker_image_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserProfileUserSettingsKernelGatewayAppSettingsDefaultResourceSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserProfileUserSettingsKernelGatewayAppSettingsDefaultResourceSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserProfileUserSettingsKernelGatewayAppSettingsDefaultResourceSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: Optional[str] = None,
                 sagemaker_image_arn: Optional[str] = None):
        """
        :param str instance_type: The instance type.
        :param str sagemaker_image_arn: The Amazon Resource Name (ARN) of the SageMaker image created on the instance.
        """
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if sagemaker_image_arn is not None:
            pulumi.set(__self__, "sagemaker_image_arn", sagemaker_image_arn)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[str]:
        """
        The instance type.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="sagemakerImageArn")
    def sagemaker_image_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the SageMaker image created on the instance.
        """
        return pulumi.get(self, "sagemaker_image_arn")


@pulumi.output_type
class UserProfileUserSettingsSharingSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "notebookOutputOption":
            suggest = "notebook_output_option"
        elif key == "s3KmsKeyId":
            suggest = "s3_kms_key_id"
        elif key == "s3OutputPath":
            suggest = "s3_output_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserProfileUserSettingsSharingSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserProfileUserSettingsSharingSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserProfileUserSettingsSharingSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 notebook_output_option: Optional[str] = None,
                 s3_kms_key_id: Optional[str] = None,
                 s3_output_path: Optional[str] = None):
        """
        :param str notebook_output_option: Whether to include the notebook cell output when sharing the notebook. The default is `Disabled`. Valid values are `Allowed` and `Disabled`.
        :param str s3_kms_key_id: When `notebook_output_option` is Allowed, the AWS Key Management Service (KMS) encryption key ID used to encrypt the notebook cell output in the Amazon S3 bucket.
        :param str s3_output_path: When `notebook_output_option` is Allowed, the Amazon S3 bucket used to save the notebook cell output.
        """
        if notebook_output_option is not None:
            pulumi.set(__self__, "notebook_output_option", notebook_output_option)
        if s3_kms_key_id is not None:
            pulumi.set(__self__, "s3_kms_key_id", s3_kms_key_id)
        if s3_output_path is not None:
            pulumi.set(__self__, "s3_output_path", s3_output_path)

    @property
    @pulumi.getter(name="notebookOutputOption")
    def notebook_output_option(self) -> Optional[str]:
        """
        Whether to include the notebook cell output when sharing the notebook. The default is `Disabled`. Valid values are `Allowed` and `Disabled`.
        """
        return pulumi.get(self, "notebook_output_option")

    @property
    @pulumi.getter(name="s3KmsKeyId")
    def s3_kms_key_id(self) -> Optional[str]:
        """
        When `notebook_output_option` is Allowed, the AWS Key Management Service (KMS) encryption key ID used to encrypt the notebook cell output in the Amazon S3 bucket.
        """
        return pulumi.get(self, "s3_kms_key_id")

    @property
    @pulumi.getter(name="s3OutputPath")
    def s3_output_path(self) -> Optional[str]:
        """
        When `notebook_output_option` is Allowed, the Amazon S3 bucket used to save the notebook cell output.
        """
        return pulumi.get(self, "s3_output_path")


@pulumi.output_type
class UserProfileUserSettingsTensorBoardAppSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultResourceSpec":
            suggest = "default_resource_spec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserProfileUserSettingsTensorBoardAppSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserProfileUserSettingsTensorBoardAppSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserProfileUserSettingsTensorBoardAppSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_resource_spec: 'outputs.UserProfileUserSettingsTensorBoardAppSettingsDefaultResourceSpec'):
        """
        :param 'UserProfileUserSettingsTensorBoardAppSettingsDefaultResourceSpecArgs' default_resource_spec: The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
        """
        pulumi.set(__self__, "default_resource_spec", default_resource_spec)

    @property
    @pulumi.getter(name="defaultResourceSpec")
    def default_resource_spec(self) -> 'outputs.UserProfileUserSettingsTensorBoardAppSettingsDefaultResourceSpec':
        """
        The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
        """
        return pulumi.get(self, "default_resource_spec")


@pulumi.output_type
class UserProfileUserSettingsTensorBoardAppSettingsDefaultResourceSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "sagemakerImageArn":
            suggest = "sagemaker_image_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserProfileUserSettingsTensorBoardAppSettingsDefaultResourceSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserProfileUserSettingsTensorBoardAppSettingsDefaultResourceSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserProfileUserSettingsTensorBoardAppSettingsDefaultResourceSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: Optional[str] = None,
                 sagemaker_image_arn: Optional[str] = None):
        """
        :param str instance_type: The instance type.
        :param str sagemaker_image_arn: The Amazon Resource Name (ARN) of the SageMaker image created on the instance.
        """
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if sagemaker_image_arn is not None:
            pulumi.set(__self__, "sagemaker_image_arn", sagemaker_image_arn)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[str]:
        """
        The instance type.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="sagemakerImageArn")
    def sagemaker_image_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the SageMaker image created on the instance.
        """
        return pulumi.get(self, "sagemaker_image_arn")


