# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DomainArgs', 'Domain']

@pulumi.input_type
class DomainArgs:
    def __init__(__self__, *,
                 auth_mode: pulumi.Input[str],
                 default_user_settings: pulumi.Input['DomainDefaultUserSettingsArgs'],
                 domain_name: pulumi.Input[str],
                 subnet_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 vpc_id: pulumi.Input[str],
                 app_network_access_type: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 retention_policy: Optional[pulumi.Input['DomainRetentionPolicyArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Domain resource.
        :param pulumi.Input[str] auth_mode: The mode of authentication that members use to access the domain. Valid values are `IAM` and `SSO`.
        :param pulumi.Input['DomainDefaultUserSettingsArgs'] default_user_settings: The default user settings. See Default User Settings below.
        :param pulumi.Input[str] domain_name: The domain name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: The VPC subnets that Studio uses for communication.
        :param pulumi.Input[str] vpc_id: The ID of the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.
        :param pulumi.Input[str] app_network_access_type: Specifies the VPC used for non-EFS traffic. The default value is `PublicInternetOnly`. Valid values are `PublicInternetOnly` and `VpcOnly`.
        :param pulumi.Input[str] kms_key_id: The AWS KMS customer managed CMK used to encrypt the EFS volume attached to the domain.
        :param pulumi.Input['DomainRetentionPolicyArgs'] retention_policy: The retention policy for this domain, which specifies whether resources will be retained after the Domain is deleted. By default, all resources are retained. See Retention Policy below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider .
        """
        pulumi.set(__self__, "auth_mode", auth_mode)
        pulumi.set(__self__, "default_user_settings", default_user_settings)
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if app_network_access_type is not None:
            pulumi.set(__self__, "app_network_access_type", app_network_access_type)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if retention_policy is not None:
            pulumi.set(__self__, "retention_policy", retention_policy)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @property
    @pulumi.getter(name="authMode")
    def auth_mode(self) -> pulumi.Input[str]:
        """
        The mode of authentication that members use to access the domain. Valid values are `IAM` and `SSO`.
        """
        return pulumi.get(self, "auth_mode")

    @auth_mode.setter
    def auth_mode(self, value: pulumi.Input[str]):
        pulumi.set(self, "auth_mode", value)

    @property
    @pulumi.getter(name="defaultUserSettings")
    def default_user_settings(self) -> pulumi.Input['DomainDefaultUserSettingsArgs']:
        """
        The default user settings. See Default User Settings below.
        """
        return pulumi.get(self, "default_user_settings")

    @default_user_settings.setter
    def default_user_settings(self, value: pulumi.Input['DomainDefaultUserSettingsArgs']):
        pulumi.set(self, "default_user_settings", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[str]:
        """
        The domain name.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The VPC subnets that Studio uses for communication.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        The ID of the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="appNetworkAccessType")
    def app_network_access_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the VPC used for non-EFS traffic. The default value is `PublicInternetOnly`. Valid values are `PublicInternetOnly` and `VpcOnly`.
        """
        return pulumi.get(self, "app_network_access_type")

    @app_network_access_type.setter
    def app_network_access_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_network_access_type", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS KMS customer managed CMK used to encrypt the EFS volume attached to the domain.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> Optional[pulumi.Input['DomainRetentionPolicyArgs']]:
        """
        The retention policy for this domain, which specifies whether resources will be retained after the Domain is deleted. By default, all resources are retained. See Retention Policy below.
        """
        return pulumi.get(self, "retention_policy")

    @retention_policy.setter
    def retention_policy(self, value: Optional[pulumi.Input['DomainRetentionPolicyArgs']]):
        pulumi.set(self, "retention_policy", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider .
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)


@pulumi.input_type
class _DomainState:
    def __init__(__self__, *,
                 app_network_access_type: Optional[pulumi.Input[str]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 auth_mode: Optional[pulumi.Input[str]] = None,
                 default_user_settings: Optional[pulumi.Input['DomainDefaultUserSettingsArgs']] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 home_efs_file_system_id: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 retention_policy: Optional[pulumi.Input['DomainRetentionPolicyArgs']] = None,
                 single_sign_on_managed_application_instance_id: Optional[pulumi.Input[str]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Domain resources.
        :param pulumi.Input[str] app_network_access_type: Specifies the VPC used for non-EFS traffic. The default value is `PublicInternetOnly`. Valid values are `PublicInternetOnly` and `VpcOnly`.
        :param pulumi.Input[str] arn: The Amazon Resource Name (ARN) assigned by AWS to this Domain.
        :param pulumi.Input[str] auth_mode: The mode of authentication that members use to access the domain. Valid values are `IAM` and `SSO`.
        :param pulumi.Input['DomainDefaultUserSettingsArgs'] default_user_settings: The default user settings. See Default User Settings below.
        :param pulumi.Input[str] domain_name: The domain name.
        :param pulumi.Input[str] home_efs_file_system_id: The ID of the Amazon Elastic File System (EFS) managed by this Domain.
        :param pulumi.Input[str] kms_key_id: The AWS KMS customer managed CMK used to encrypt the EFS volume attached to the domain.
        :param pulumi.Input['DomainRetentionPolicyArgs'] retention_policy: The retention policy for this domain, which specifies whether resources will be retained after the Domain is deleted. By default, all resources are retained. See Retention Policy below.
        :param pulumi.Input[str] single_sign_on_managed_application_instance_id: The SSO managed application instance ID.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: The VPC subnets that Studio uses for communication.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider .
        :param pulumi.Input[str] url: The domain's URL.
        :param pulumi.Input[str] vpc_id: The ID of the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.
        """
        if app_network_access_type is not None:
            pulumi.set(__self__, "app_network_access_type", app_network_access_type)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if auth_mode is not None:
            pulumi.set(__self__, "auth_mode", auth_mode)
        if default_user_settings is not None:
            pulumi.set(__self__, "default_user_settings", default_user_settings)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if home_efs_file_system_id is not None:
            pulumi.set(__self__, "home_efs_file_system_id", home_efs_file_system_id)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if retention_policy is not None:
            pulumi.set(__self__, "retention_policy", retention_policy)
        if single_sign_on_managed_application_instance_id is not None:
            pulumi.set(__self__, "single_sign_on_managed_application_instance_id", single_sign_on_managed_application_instance_id)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="appNetworkAccessType")
    def app_network_access_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the VPC used for non-EFS traffic. The default value is `PublicInternetOnly`. Valid values are `PublicInternetOnly` and `VpcOnly`.
        """
        return pulumi.get(self, "app_network_access_type")

    @app_network_access_type.setter
    def app_network_access_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_network_access_type", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) assigned by AWS to this Domain.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="authMode")
    def auth_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The mode of authentication that members use to access the domain. Valid values are `IAM` and `SSO`.
        """
        return pulumi.get(self, "auth_mode")

    @auth_mode.setter
    def auth_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_mode", value)

    @property
    @pulumi.getter(name="defaultUserSettings")
    def default_user_settings(self) -> Optional[pulumi.Input['DomainDefaultUserSettingsArgs']]:
        """
        The default user settings. See Default User Settings below.
        """
        return pulumi.get(self, "default_user_settings")

    @default_user_settings.setter
    def default_user_settings(self, value: Optional[pulumi.Input['DomainDefaultUserSettingsArgs']]):
        pulumi.set(self, "default_user_settings", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        The domain name.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="homeEfsFileSystemId")
    def home_efs_file_system_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Amazon Elastic File System (EFS) managed by this Domain.
        """
        return pulumi.get(self, "home_efs_file_system_id")

    @home_efs_file_system_id.setter
    def home_efs_file_system_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "home_efs_file_system_id", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS KMS customer managed CMK used to encrypt the EFS volume attached to the domain.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> Optional[pulumi.Input['DomainRetentionPolicyArgs']]:
        """
        The retention policy for this domain, which specifies whether resources will be retained after the Domain is deleted. By default, all resources are retained. See Retention Policy below.
        """
        return pulumi.get(self, "retention_policy")

    @retention_policy.setter
    def retention_policy(self, value: Optional[pulumi.Input['DomainRetentionPolicyArgs']]):
        pulumi.set(self, "retention_policy", value)

    @property
    @pulumi.getter(name="singleSignOnManagedApplicationInstanceId")
    def single_sign_on_managed_application_instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The SSO managed application instance ID.
        """
        return pulumi.get(self, "single_sign_on_managed_application_instance_id")

    @single_sign_on_managed_application_instance_id.setter
    def single_sign_on_managed_application_instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "single_sign_on_managed_application_instance_id", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The VPC subnets that Studio uses for communication.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider .
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        The domain's URL.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class Domain(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_network_access_type: Optional[pulumi.Input[str]] = None,
                 auth_mode: Optional[pulumi.Input[str]] = None,
                 default_user_settings: Optional[pulumi.Input[pulumi.InputType['DomainDefaultUserSettingsArgs']]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 retention_policy: Optional[pulumi.Input[pulumi.InputType['DomainRetentionPolicyArgs']]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Sagemaker Domain resource.

        ## Example Usage
        ### Basic usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example_domain = aws.sagemaker.Domain("exampleDomain",
            domain_name="example",
            auth_mode="IAM",
            vpc_id=aws_vpc["test"]["id"],
            subnet_ids=[aws_subnet["test"]["id"]],
            default_user_settings=aws.sagemaker.DomainDefaultUserSettingsArgs(
                execution_role=aws_iam_role["test"]["arn"],
            ))
        example_policy_document = aws.iam.get_policy_document(statements=[aws.iam.GetPolicyDocumentStatementArgs(
            actions=["sts:AssumeRole"],
            principals=[aws.iam.GetPolicyDocumentStatementPrincipalArgs(
                type="Service",
                identifiers=["sagemaker.amazonaws.com"],
            )],
        )])
        example_role = aws.iam.Role("exampleRole",
            path="/",
            assume_role_policy=example_policy_document.json)
        ```
        ### Using Custom Images

        ```python
        import pulumi
        import pulumi_aws as aws

        test_image = aws.sagemaker.Image("testImage",
            image_name="example",
            role_arn=aws_iam_role["test"]["arn"])
        test_app_image_config = aws.sagemaker.AppImageConfig("testAppImageConfig",
            app_image_config_name="example",
            kernel_gateway_image_config=aws.sagemaker.AppImageConfigKernelGatewayImageConfigArgs(
                kernel_spec=aws.sagemaker.AppImageConfigKernelGatewayImageConfigKernelSpecArgs(
                    name="example",
                ),
            ))
        test_image_version = aws.sagemaker.ImageVersion("testImageVersion",
            image_name=test_image.id,
            base_image="base-image")
        test_domain = aws.sagemaker.Domain("testDomain",
            domain_name="example",
            auth_mode="IAM",
            vpc_id=aws_vpc["test"]["id"],
            subnet_ids=[aws_subnet["test"]["id"]],
            default_user_settings=aws.sagemaker.DomainDefaultUserSettingsArgs(
                execution_role=aws_iam_role["test"]["arn"],
                kernel_gateway_app_settings=aws.sagemaker.DomainDefaultUserSettingsKernelGatewayAppSettingsArgs(
                    custom_images=[aws.sagemaker.DomainDefaultUserSettingsKernelGatewayAppSettingsCustomImageArgs(
                        app_image_config_name=test_app_image_config.app_image_config_name,
                        image_name=test_image_version.image_name,
                    )],
                ),
            ))
        ```

        ## Import

        Sagemaker Code Domains can be imported using the `id`, e.g.

        ```sh
         $ pulumi import aws:sagemaker/domain:Domain test_domain d-8jgsjtilstu8
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] app_network_access_type: Specifies the VPC used for non-EFS traffic. The default value is `PublicInternetOnly`. Valid values are `PublicInternetOnly` and `VpcOnly`.
        :param pulumi.Input[str] auth_mode: The mode of authentication that members use to access the domain. Valid values are `IAM` and `SSO`.
        :param pulumi.Input[pulumi.InputType['DomainDefaultUserSettingsArgs']] default_user_settings: The default user settings. See Default User Settings below.
        :param pulumi.Input[str] domain_name: The domain name.
        :param pulumi.Input[str] kms_key_id: The AWS KMS customer managed CMK used to encrypt the EFS volume attached to the domain.
        :param pulumi.Input[pulumi.InputType['DomainRetentionPolicyArgs']] retention_policy: The retention policy for this domain, which specifies whether resources will be retained after the Domain is deleted. By default, all resources are retained. See Retention Policy below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: The VPC subnets that Studio uses for communication.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider .
        :param pulumi.Input[str] vpc_id: The ID of the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Sagemaker Domain resource.

        ## Example Usage
        ### Basic usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example_domain = aws.sagemaker.Domain("exampleDomain",
            domain_name="example",
            auth_mode="IAM",
            vpc_id=aws_vpc["test"]["id"],
            subnet_ids=[aws_subnet["test"]["id"]],
            default_user_settings=aws.sagemaker.DomainDefaultUserSettingsArgs(
                execution_role=aws_iam_role["test"]["arn"],
            ))
        example_policy_document = aws.iam.get_policy_document(statements=[aws.iam.GetPolicyDocumentStatementArgs(
            actions=["sts:AssumeRole"],
            principals=[aws.iam.GetPolicyDocumentStatementPrincipalArgs(
                type="Service",
                identifiers=["sagemaker.amazonaws.com"],
            )],
        )])
        example_role = aws.iam.Role("exampleRole",
            path="/",
            assume_role_policy=example_policy_document.json)
        ```
        ### Using Custom Images

        ```python
        import pulumi
        import pulumi_aws as aws

        test_image = aws.sagemaker.Image("testImage",
            image_name="example",
            role_arn=aws_iam_role["test"]["arn"])
        test_app_image_config = aws.sagemaker.AppImageConfig("testAppImageConfig",
            app_image_config_name="example",
            kernel_gateway_image_config=aws.sagemaker.AppImageConfigKernelGatewayImageConfigArgs(
                kernel_spec=aws.sagemaker.AppImageConfigKernelGatewayImageConfigKernelSpecArgs(
                    name="example",
                ),
            ))
        test_image_version = aws.sagemaker.ImageVersion("testImageVersion",
            image_name=test_image.id,
            base_image="base-image")
        test_domain = aws.sagemaker.Domain("testDomain",
            domain_name="example",
            auth_mode="IAM",
            vpc_id=aws_vpc["test"]["id"],
            subnet_ids=[aws_subnet["test"]["id"]],
            default_user_settings=aws.sagemaker.DomainDefaultUserSettingsArgs(
                execution_role=aws_iam_role["test"]["arn"],
                kernel_gateway_app_settings=aws.sagemaker.DomainDefaultUserSettingsKernelGatewayAppSettingsArgs(
                    custom_images=[aws.sagemaker.DomainDefaultUserSettingsKernelGatewayAppSettingsCustomImageArgs(
                        app_image_config_name=test_app_image_config.app_image_config_name,
                        image_name=test_image_version.image_name,
                    )],
                ),
            ))
        ```

        ## Import

        Sagemaker Code Domains can be imported using the `id`, e.g.

        ```sh
         $ pulumi import aws:sagemaker/domain:Domain test_domain d-8jgsjtilstu8
        ```

        :param str resource_name: The name of the resource.
        :param DomainArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_network_access_type: Optional[pulumi.Input[str]] = None,
                 auth_mode: Optional[pulumi.Input[str]] = None,
                 default_user_settings: Optional[pulumi.Input[pulumi.InputType['DomainDefaultUserSettingsArgs']]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 retention_policy: Optional[pulumi.Input[pulumi.InputType['DomainRetentionPolicyArgs']]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainArgs.__new__(DomainArgs)

            __props__.__dict__["app_network_access_type"] = app_network_access_type
            if auth_mode is None and not opts.urn:
                raise TypeError("Missing required property 'auth_mode'")
            __props__.__dict__["auth_mode"] = auth_mode
            if default_user_settings is None and not opts.urn:
                raise TypeError("Missing required property 'default_user_settings'")
            __props__.__dict__["default_user_settings"] = default_user_settings
            if domain_name is None and not opts.urn:
                raise TypeError("Missing required property 'domain_name'")
            __props__.__dict__["domain_name"] = domain_name
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["retention_policy"] = retention_policy
            if subnet_ids is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_ids'")
            __props__.__dict__["subnet_ids"] = subnet_ids
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tags_all"] = tags_all
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["arn"] = None
            __props__.__dict__["home_efs_file_system_id"] = None
            __props__.__dict__["single_sign_on_managed_application_instance_id"] = None
            __props__.__dict__["url"] = None
        super(Domain, __self__).__init__(
            'aws:sagemaker/domain:Domain',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_network_access_type: Optional[pulumi.Input[str]] = None,
            arn: Optional[pulumi.Input[str]] = None,
            auth_mode: Optional[pulumi.Input[str]] = None,
            default_user_settings: Optional[pulumi.Input[pulumi.InputType['DomainDefaultUserSettingsArgs']]] = None,
            domain_name: Optional[pulumi.Input[str]] = None,
            home_efs_file_system_id: Optional[pulumi.Input[str]] = None,
            kms_key_id: Optional[pulumi.Input[str]] = None,
            retention_policy: Optional[pulumi.Input[pulumi.InputType['DomainRetentionPolicyArgs']]] = None,
            single_sign_on_managed_application_instance_id: Optional[pulumi.Input[str]] = None,
            subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            url: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'Domain':
        """
        Get an existing Domain resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] app_network_access_type: Specifies the VPC used for non-EFS traffic. The default value is `PublicInternetOnly`. Valid values are `PublicInternetOnly` and `VpcOnly`.
        :param pulumi.Input[str] arn: The Amazon Resource Name (ARN) assigned by AWS to this Domain.
        :param pulumi.Input[str] auth_mode: The mode of authentication that members use to access the domain. Valid values are `IAM` and `SSO`.
        :param pulumi.Input[pulumi.InputType['DomainDefaultUserSettingsArgs']] default_user_settings: The default user settings. See Default User Settings below.
        :param pulumi.Input[str] domain_name: The domain name.
        :param pulumi.Input[str] home_efs_file_system_id: The ID of the Amazon Elastic File System (EFS) managed by this Domain.
        :param pulumi.Input[str] kms_key_id: The AWS KMS customer managed CMK used to encrypt the EFS volume attached to the domain.
        :param pulumi.Input[pulumi.InputType['DomainRetentionPolicyArgs']] retention_policy: The retention policy for this domain, which specifies whether resources will be retained after the Domain is deleted. By default, all resources are retained. See Retention Policy below.
        :param pulumi.Input[str] single_sign_on_managed_application_instance_id: The SSO managed application instance ID.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: The VPC subnets that Studio uses for communication.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider .
        :param pulumi.Input[str] url: The domain's URL.
        :param pulumi.Input[str] vpc_id: The ID of the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainState.__new__(_DomainState)

        __props__.__dict__["app_network_access_type"] = app_network_access_type
        __props__.__dict__["arn"] = arn
        __props__.__dict__["auth_mode"] = auth_mode
        __props__.__dict__["default_user_settings"] = default_user_settings
        __props__.__dict__["domain_name"] = domain_name
        __props__.__dict__["home_efs_file_system_id"] = home_efs_file_system_id
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["retention_policy"] = retention_policy
        __props__.__dict__["single_sign_on_managed_application_instance_id"] = single_sign_on_managed_application_instance_id
        __props__.__dict__["subnet_ids"] = subnet_ids
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["url"] = url
        __props__.__dict__["vpc_id"] = vpc_id
        return Domain(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="appNetworkAccessType")
    def app_network_access_type(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the VPC used for non-EFS traffic. The default value is `PublicInternetOnly`. Valid values are `PublicInternetOnly` and `VpcOnly`.
        """
        return pulumi.get(self, "app_network_access_type")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) assigned by AWS to this Domain.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="authMode")
    def auth_mode(self) -> pulumi.Output[str]:
        """
        The mode of authentication that members use to access the domain. Valid values are `IAM` and `SSO`.
        """
        return pulumi.get(self, "auth_mode")

    @property
    @pulumi.getter(name="defaultUserSettings")
    def default_user_settings(self) -> pulumi.Output['outputs.DomainDefaultUserSettings']:
        """
        The default user settings. See Default User Settings below.
        """
        return pulumi.get(self, "default_user_settings")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[str]:
        """
        The domain name.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="homeEfsFileSystemId")
    def home_efs_file_system_id(self) -> pulumi.Output[str]:
        """
        The ID of the Amazon Elastic File System (EFS) managed by this Domain.
        """
        return pulumi.get(self, "home_efs_file_system_id")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[Optional[str]]:
        """
        The AWS KMS customer managed CMK used to encrypt the EFS volume attached to the domain.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> pulumi.Output[Optional['outputs.DomainRetentionPolicy']]:
        """
        The retention policy for this domain, which specifies whether resources will be retained after the Domain is deleted. By default, all resources are retained. See Retention Policy below.
        """
        return pulumi.get(self, "retention_policy")

    @property
    @pulumi.getter(name="singleSignOnManagedApplicationInstanceId")
    def single_sign_on_managed_application_instance_id(self) -> pulumi.Output[str]:
        """
        The SSO managed application instance ID.
        """
        return pulumi.get(self, "single_sign_on_managed_application_instance_id")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        The VPC subnets that Studio uses for communication.
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider .
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[str]:
        """
        The domain's URL.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        The ID of the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.
        """
        return pulumi.get(self, "vpc_id")

