# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'BucketLifecycleConfigurationRule',
    'BucketLifecycleConfigurationRuleAbortIncompleteMultipartUpload',
    'BucketLifecycleConfigurationRuleExpiration',
    'BucketLifecycleConfigurationRuleFilter',
]

@pulumi.output_type
class BucketLifecycleConfigurationRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "abortIncompleteMultipartUpload":
            suggest = "abort_incomplete_multipart_upload"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLifecycleConfigurationRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLifecycleConfigurationRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLifecycleConfigurationRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 abort_incomplete_multipart_upload: Optional['outputs.BucketLifecycleConfigurationRuleAbortIncompleteMultipartUpload'] = None,
                 expiration: Optional['outputs.BucketLifecycleConfigurationRuleExpiration'] = None,
                 filter: Optional['outputs.BucketLifecycleConfigurationRuleFilter'] = None,
                 status: Optional[str] = None):
        """
        :param str id: Unique identifier for the rule.
        :param 'BucketLifecycleConfigurationRuleAbortIncompleteMultipartUploadArgs' abort_incomplete_multipart_upload: Configuration block containing settings for abort incomplete multipart upload.
        :param 'BucketLifecycleConfigurationRuleExpirationArgs' expiration: Configuration block containing settings for expiration of objects.
        :param 'BucketLifecycleConfigurationRuleFilterArgs' filter: Configuration block containing settings for filtering.
        :param str status: Status of the rule. Valid values: `Enabled` and `Disabled`. Defaults to `Enabled`.
        """
        pulumi.set(__self__, "id", id)
        if abort_incomplete_multipart_upload is not None:
            pulumi.set(__self__, "abort_incomplete_multipart_upload", abort_incomplete_multipart_upload)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique identifier for the rule.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="abortIncompleteMultipartUpload")
    def abort_incomplete_multipart_upload(self) -> Optional['outputs.BucketLifecycleConfigurationRuleAbortIncompleteMultipartUpload']:
        """
        Configuration block containing settings for abort incomplete multipart upload.
        """
        return pulumi.get(self, "abort_incomplete_multipart_upload")

    @property
    @pulumi.getter
    def expiration(self) -> Optional['outputs.BucketLifecycleConfigurationRuleExpiration']:
        """
        Configuration block containing settings for expiration of objects.
        """
        return pulumi.get(self, "expiration")

    @property
    @pulumi.getter
    def filter(self) -> Optional['outputs.BucketLifecycleConfigurationRuleFilter']:
        """
        Configuration block containing settings for filtering.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Status of the rule. Valid values: `Enabled` and `Disabled`. Defaults to `Enabled`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class BucketLifecycleConfigurationRuleAbortIncompleteMultipartUpload(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "daysAfterInitiation":
            suggest = "days_after_initiation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLifecycleConfigurationRuleAbortIncompleteMultipartUpload. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLifecycleConfigurationRuleAbortIncompleteMultipartUpload.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLifecycleConfigurationRuleAbortIncompleteMultipartUpload.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 days_after_initiation: int):
        """
        :param int days_after_initiation: Number of days after which Amazon S3 aborts an incomplete multipart upload.
        """
        pulumi.set(__self__, "days_after_initiation", days_after_initiation)

    @property
    @pulumi.getter(name="daysAfterInitiation")
    def days_after_initiation(self) -> int:
        """
        Number of days after which Amazon S3 aborts an incomplete multipart upload.
        """
        return pulumi.get(self, "days_after_initiation")


@pulumi.output_type
class BucketLifecycleConfigurationRuleExpiration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expiredObjectDeleteMarker":
            suggest = "expired_object_delete_marker"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLifecycleConfigurationRuleExpiration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLifecycleConfigurationRuleExpiration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLifecycleConfigurationRuleExpiration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 date: Optional[str] = None,
                 days: Optional[int] = None,
                 expired_object_delete_marker: Optional[bool] = None):
        """
        :param str date: Date the object is to be deleted. Should be in `YYYY-MM-DD` date format, e.g. `2020-09-30`.
        :param int days: Number of days before the object is to be deleted.
        :param bool expired_object_delete_marker: Enable to remove a delete marker with no noncurrent versions. Cannot be specified with `date` or `days`.
        """
        if date is not None:
            pulumi.set(__self__, "date", date)
        if days is not None:
            pulumi.set(__self__, "days", days)
        if expired_object_delete_marker is not None:
            pulumi.set(__self__, "expired_object_delete_marker", expired_object_delete_marker)

    @property
    @pulumi.getter
    def date(self) -> Optional[str]:
        """
        Date the object is to be deleted. Should be in `YYYY-MM-DD` date format, e.g. `2020-09-30`.
        """
        return pulumi.get(self, "date")

    @property
    @pulumi.getter
    def days(self) -> Optional[int]:
        """
        Number of days before the object is to be deleted.
        """
        return pulumi.get(self, "days")

    @property
    @pulumi.getter(name="expiredObjectDeleteMarker")
    def expired_object_delete_marker(self) -> Optional[bool]:
        """
        Enable to remove a delete marker with no noncurrent versions. Cannot be specified with `date` or `days`.
        """
        return pulumi.get(self, "expired_object_delete_marker")


@pulumi.output_type
class BucketLifecycleConfigurationRuleFilter(dict):
    def __init__(__self__, *,
                 prefix: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        :param str prefix: Object prefix for rule filtering.
        :param Mapping[str, str] tags: Key-value map of object tags for rule filtering.
        """
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        Object prefix for rule filtering.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Key-value map of object tags for rule filtering.
        """
        return pulumi.get(self, "tags")


