# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AccessPointPublicAccessBlockConfiguration',
    'AccessPointVpcConfiguration',
    'AnalyticsConfigurationFilter',
    'AnalyticsConfigurationStorageClassAnalysis',
    'AnalyticsConfigurationStorageClassAnalysisDataExport',
    'AnalyticsConfigurationStorageClassAnalysisDataExportDestination',
    'AnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestination',
    'BucketCorsRule',
    'BucketGrant',
    'BucketLifecycleRule',
    'BucketLifecycleRuleExpiration',
    'BucketLifecycleRuleNoncurrentVersionExpiration',
    'BucketLifecycleRuleNoncurrentVersionTransition',
    'BucketLifecycleRuleTransition',
    'BucketLogging',
    'BucketMetricFilter',
    'BucketNotificationLambdaFunction',
    'BucketNotificationQueue',
    'BucketNotificationTopic',
    'BucketObjectLockConfiguration',
    'BucketObjectLockConfigurationRule',
    'BucketObjectLockConfigurationRuleDefaultRetention',
    'BucketOwnershipControlsRule',
    'BucketReplicationConfiguration',
    'BucketReplicationConfigurationRule',
    'BucketReplicationConfigurationRuleDestination',
    'BucketReplicationConfigurationRuleDestinationAccessControlTranslation',
    'BucketReplicationConfigurationRuleFilter',
    'BucketReplicationConfigurationRuleSourceSelectionCriteria',
    'BucketReplicationConfigurationRuleSourceSelectionCriteriaSseKmsEncryptedObjects',
    'BucketServerSideEncryptionConfiguration',
    'BucketServerSideEncryptionConfigurationRule',
    'BucketServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefault',
    'BucketVersioning',
    'BucketWebsite',
    'InventoryDestination',
    'InventoryDestinationBucket',
    'InventoryDestinationBucketEncryption',
    'InventoryDestinationBucketEncryptionSseKms',
    'InventoryDestinationBucketEncryptionSseS3',
    'InventoryFilter',
    'InventorySchedule',
    'ObjectCopyGrant',
]

@pulumi.output_type
class AccessPointPublicAccessBlockConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blockPublicAcls":
            suggest = "block_public_acls"
        elif key == "blockPublicPolicy":
            suggest = "block_public_policy"
        elif key == "ignorePublicAcls":
            suggest = "ignore_public_acls"
        elif key == "restrictPublicBuckets":
            suggest = "restrict_public_buckets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessPointPublicAccessBlockConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessPointPublicAccessBlockConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessPointPublicAccessBlockConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 block_public_acls: Optional[bool] = None,
                 block_public_policy: Optional[bool] = None,
                 ignore_public_acls: Optional[bool] = None,
                 restrict_public_buckets: Optional[bool] = None):
        """
        :param bool block_public_acls: Whether Amazon S3 should block public ACLs for buckets in this account. Defaults to `true`. Enabling this setting does not affect existing policies or ACLs. When set to `true` causes the following behavior:
               * PUT Bucket acl and PUT Object acl calls fail if the specified ACL is public.
               * PUT Object calls fail if the request includes a public ACL.
               * PUT Bucket calls fail if the request includes a public ACL.
        :param bool block_public_policy: Whether Amazon S3 should block public bucket policies for buckets in this account. Defaults to `true`. Enabling this setting does not affect existing bucket policies. When set to `true` causes Amazon S3 to:
               * Reject calls to PUT Bucket policy if the specified bucket policy allows public access.
        :param bool ignore_public_acls: Whether Amazon S3 should ignore public ACLs for buckets in this account. Defaults to `true`. Enabling this setting does not affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set. When set to `true` causes Amazon S3 to:
               * Ignore all public ACLs on buckets in this account and any objects that they contain.
        :param bool restrict_public_buckets: Whether Amazon S3 should restrict public bucket policies for buckets in this account. Defaults to `true`. Enabling this setting does not affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked. When set to `true`:
               * Only the bucket owner and AWS Services can access buckets with public policies.
        """
        if block_public_acls is not None:
            pulumi.set(__self__, "block_public_acls", block_public_acls)
        if block_public_policy is not None:
            pulumi.set(__self__, "block_public_policy", block_public_policy)
        if ignore_public_acls is not None:
            pulumi.set(__self__, "ignore_public_acls", ignore_public_acls)
        if restrict_public_buckets is not None:
            pulumi.set(__self__, "restrict_public_buckets", restrict_public_buckets)

    @property
    @pulumi.getter(name="blockPublicAcls")
    def block_public_acls(self) -> Optional[bool]:
        """
        Whether Amazon S3 should block public ACLs for buckets in this account. Defaults to `true`. Enabling this setting does not affect existing policies or ACLs. When set to `true` causes the following behavior:
        * PUT Bucket acl and PUT Object acl calls fail if the specified ACL is public.
        * PUT Object calls fail if the request includes a public ACL.
        * PUT Bucket calls fail if the request includes a public ACL.
        """
        return pulumi.get(self, "block_public_acls")

    @property
    @pulumi.getter(name="blockPublicPolicy")
    def block_public_policy(self) -> Optional[bool]:
        """
        Whether Amazon S3 should block public bucket policies for buckets in this account. Defaults to `true`. Enabling this setting does not affect existing bucket policies. When set to `true` causes Amazon S3 to:
        * Reject calls to PUT Bucket policy if the specified bucket policy allows public access.
        """
        return pulumi.get(self, "block_public_policy")

    @property
    @pulumi.getter(name="ignorePublicAcls")
    def ignore_public_acls(self) -> Optional[bool]:
        """
        Whether Amazon S3 should ignore public ACLs for buckets in this account. Defaults to `true`. Enabling this setting does not affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set. When set to `true` causes Amazon S3 to:
        * Ignore all public ACLs on buckets in this account and any objects that they contain.
        """
        return pulumi.get(self, "ignore_public_acls")

    @property
    @pulumi.getter(name="restrictPublicBuckets")
    def restrict_public_buckets(self) -> Optional[bool]:
        """
        Whether Amazon S3 should restrict public bucket policies for buckets in this account. Defaults to `true`. Enabling this setting does not affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked. When set to `true`:
        * Only the bucket owner and AWS Services can access buckets with public policies.
        """
        return pulumi.get(self, "restrict_public_buckets")


@pulumi.output_type
class AccessPointVpcConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vpcId":
            suggest = "vpc_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessPointVpcConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessPointVpcConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessPointVpcConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vpc_id: str):
        """
        :param str vpc_id: This access point will only allow connections from the specified VPC ID.
        """
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        This access point will only allow connections from the specified VPC ID.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class AnalyticsConfigurationFilter(dict):
    def __init__(__self__, *,
                 prefix: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        :param str prefix: Object prefix for filtering.
        :param Mapping[str, str] tags: Set of object tags for filtering.
        """
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        Object prefix for filtering.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Set of object tags for filtering.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class AnalyticsConfigurationStorageClassAnalysis(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataExport":
            suggest = "data_export"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnalyticsConfigurationStorageClassAnalysis. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnalyticsConfigurationStorageClassAnalysis.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnalyticsConfigurationStorageClassAnalysis.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_export: 'outputs.AnalyticsConfigurationStorageClassAnalysisDataExport'):
        """
        :param 'AnalyticsConfigurationStorageClassAnalysisDataExportArgs' data_export: Data export configuration (documented below).
        """
        pulumi.set(__self__, "data_export", data_export)

    @property
    @pulumi.getter(name="dataExport")
    def data_export(self) -> 'outputs.AnalyticsConfigurationStorageClassAnalysisDataExport':
        """
        Data export configuration (documented below).
        """
        return pulumi.get(self, "data_export")


@pulumi.output_type
class AnalyticsConfigurationStorageClassAnalysisDataExport(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "outputSchemaVersion":
            suggest = "output_schema_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnalyticsConfigurationStorageClassAnalysisDataExport. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnalyticsConfigurationStorageClassAnalysisDataExport.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnalyticsConfigurationStorageClassAnalysisDataExport.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination: 'outputs.AnalyticsConfigurationStorageClassAnalysisDataExportDestination',
                 output_schema_version: Optional[str] = None):
        """
        :param 'AnalyticsConfigurationStorageClassAnalysisDataExportDestinationArgs' destination: Specifies the destination for the exported analytics data (documented below).
        :param str output_schema_version: The schema version of exported analytics data. Allowed values: `V_1`. Default value: `V_1`.
        """
        pulumi.set(__self__, "destination", destination)
        if output_schema_version is not None:
            pulumi.set(__self__, "output_schema_version", output_schema_version)

    @property
    @pulumi.getter
    def destination(self) -> 'outputs.AnalyticsConfigurationStorageClassAnalysisDataExportDestination':
        """
        Specifies the destination for the exported analytics data (documented below).
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter(name="outputSchemaVersion")
    def output_schema_version(self) -> Optional[str]:
        """
        The schema version of exported analytics data. Allowed values: `V_1`. Default value: `V_1`.
        """
        return pulumi.get(self, "output_schema_version")


@pulumi.output_type
class AnalyticsConfigurationStorageClassAnalysisDataExportDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3BucketDestination":
            suggest = "s3_bucket_destination"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnalyticsConfigurationStorageClassAnalysisDataExportDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnalyticsConfigurationStorageClassAnalysisDataExportDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnalyticsConfigurationStorageClassAnalysisDataExportDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_bucket_destination: 'outputs.AnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestination'):
        """
        :param 'AnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestinationArgs' s3_bucket_destination: Analytics data export currently only supports an S3 bucket destination (documented below).
        """
        pulumi.set(__self__, "s3_bucket_destination", s3_bucket_destination)

    @property
    @pulumi.getter(name="s3BucketDestination")
    def s3_bucket_destination(self) -> 'outputs.AnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestination':
        """
        Analytics data export currently only supports an S3 bucket destination (documented below).
        """
        return pulumi.get(self, "s3_bucket_destination")


@pulumi.output_type
class AnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketArn":
            suggest = "bucket_arn"
        elif key == "bucketAccountId":
            suggest = "bucket_account_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_arn: str,
                 bucket_account_id: Optional[str] = None,
                 format: Optional[str] = None,
                 prefix: Optional[str] = None):
        """
        :param str bucket_arn: The ARN of the destination bucket.
        :param str bucket_account_id: The account ID that owns the destination bucket.
        :param str format: The output format of exported analytics data. Allowed values: `CSV`. Default value: `CSV`.
        :param str prefix: Object prefix for filtering.
        """
        pulumi.set(__self__, "bucket_arn", bucket_arn)
        if bucket_account_id is not None:
            pulumi.set(__self__, "bucket_account_id", bucket_account_id)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter(name="bucketArn")
    def bucket_arn(self) -> str:
        """
        The ARN of the destination bucket.
        """
        return pulumi.get(self, "bucket_arn")

    @property
    @pulumi.getter(name="bucketAccountId")
    def bucket_account_id(self) -> Optional[str]:
        """
        The account ID that owns the destination bucket.
        """
        return pulumi.get(self, "bucket_account_id")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        The output format of exported analytics data. Allowed values: `CSV`. Default value: `CSV`.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        Object prefix for filtering.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class BucketCorsRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedMethods":
            suggest = "allowed_methods"
        elif key == "allowedOrigins":
            suggest = "allowed_origins"
        elif key == "allowedHeaders":
            suggest = "allowed_headers"
        elif key == "exposeHeaders":
            suggest = "expose_headers"
        elif key == "maxAgeSeconds":
            suggest = "max_age_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketCorsRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketCorsRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketCorsRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_methods: Sequence[str],
                 allowed_origins: Sequence[str],
                 allowed_headers: Optional[Sequence[str]] = None,
                 expose_headers: Optional[Sequence[str]] = None,
                 max_age_seconds: Optional[int] = None):
        """
        :param Sequence[str] allowed_methods: Specifies which methods are allowed. Can be `GET`, `PUT`, `POST`, `DELETE` or `HEAD`.
        :param Sequence[str] allowed_origins: Specifies which origins are allowed.
        :param Sequence[str] allowed_headers: Specifies which headers are allowed.
        :param Sequence[str] expose_headers: Specifies expose header in the response.
        :param int max_age_seconds: Specifies time in seconds that browser can cache the response for a preflight request.
        """
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        if allowed_headers is not None:
            pulumi.set(__self__, "allowed_headers", allowed_headers)
        if expose_headers is not None:
            pulumi.set(__self__, "expose_headers", expose_headers)
        if max_age_seconds is not None:
            pulumi.set(__self__, "max_age_seconds", max_age_seconds)

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Sequence[str]:
        """
        Specifies which methods are allowed. Can be `GET`, `PUT`, `POST`, `DELETE` or `HEAD`.
        """
        return pulumi.get(self, "allowed_methods")

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Sequence[str]:
        """
        Specifies which origins are allowed.
        """
        return pulumi.get(self, "allowed_origins")

    @property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Optional[Sequence[str]]:
        """
        Specifies which headers are allowed.
        """
        return pulumi.get(self, "allowed_headers")

    @property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Optional[Sequence[str]]:
        """
        Specifies expose header in the response.
        """
        return pulumi.get(self, "expose_headers")

    @property
    @pulumi.getter(name="maxAgeSeconds")
    def max_age_seconds(self) -> Optional[int]:
        """
        Specifies time in seconds that browser can cache the response for a preflight request.
        """
        return pulumi.get(self, "max_age_seconds")


@pulumi.output_type
class BucketGrant(dict):
    def __init__(__self__, *,
                 permissions: Sequence[str],
                 type: str,
                 id: Optional[str] = None,
                 uri: Optional[str] = None):
        """
        :param Sequence[str] permissions: List of permissions to apply for grantee. Valid values are `READ`, `WRITE`, `READ_ACP`, `WRITE_ACP`, `FULL_CONTROL`.
        :param str type: - Type of grantee to apply for. Valid values are `CanonicalUser` and `Group`. `AmazonCustomerByEmail` is not supported.
        :param str id: Canonical user id to grant for. Used only when `type` is `CanonicalUser`.
        :param str uri: Uri address to grant for. Used only when `type` is `Group`.
        """
        pulumi.set(__self__, "permissions", permissions)
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def permissions(self) -> Sequence[str]:
        """
        List of permissions to apply for grantee. Valid values are `READ`, `WRITE`, `READ_ACP`, `WRITE_ACP`, `FULL_CONTROL`.
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        - Type of grantee to apply for. Valid values are `CanonicalUser` and `Group`. `AmazonCustomerByEmail` is not supported.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Canonical user id to grant for. Used only when `type` is `CanonicalUser`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def uri(self) -> Optional[str]:
        """
        Uri address to grant for. Used only when `type` is `Group`.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class BucketLifecycleRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "abortIncompleteMultipartUploadDays":
            suggest = "abort_incomplete_multipart_upload_days"
        elif key == "noncurrentVersionExpiration":
            suggest = "noncurrent_version_expiration"
        elif key == "noncurrentVersionTransitions":
            suggest = "noncurrent_version_transitions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLifecycleRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLifecycleRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLifecycleRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 abort_incomplete_multipart_upload_days: Optional[int] = None,
                 expiration: Optional['outputs.BucketLifecycleRuleExpiration'] = None,
                 id: Optional[str] = None,
                 noncurrent_version_expiration: Optional['outputs.BucketLifecycleRuleNoncurrentVersionExpiration'] = None,
                 noncurrent_version_transitions: Optional[Sequence['outputs.BucketLifecycleRuleNoncurrentVersionTransition']] = None,
                 prefix: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None,
                 transitions: Optional[Sequence['outputs.BucketLifecycleRuleTransition']] = None):
        """
        :param bool enabled: Specifies lifecycle rule status.
        :param int abort_incomplete_multipart_upload_days: Specifies the number of days after initiating a multipart upload when the multipart upload must be completed.
        :param 'BucketLifecycleRuleExpirationArgs' expiration: Specifies a period in the object's expire (documented below).
        :param str id: Unique identifier for the rule. Must be less than or equal to 255 characters in length.
        :param 'BucketLifecycleRuleNoncurrentVersionExpirationArgs' noncurrent_version_expiration: Specifies when noncurrent object versions expire (documented below).
        :param Sequence['BucketLifecycleRuleNoncurrentVersionTransitionArgs'] noncurrent_version_transitions: Specifies when noncurrent object versions transitions (documented below).
        :param str prefix: Object key prefix identifying one or more objects to which the rule applies.
        :param Mapping[str, str] tags: Specifies object tags key and value.
        :param Sequence['BucketLifecycleRuleTransitionArgs'] transitions: Specifies a period in the object's transitions (documented below).
        """
        pulumi.set(__self__, "enabled", enabled)
        if abort_incomplete_multipart_upload_days is not None:
            pulumi.set(__self__, "abort_incomplete_multipart_upload_days", abort_incomplete_multipart_upload_days)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if noncurrent_version_expiration is not None:
            pulumi.set(__self__, "noncurrent_version_expiration", noncurrent_version_expiration)
        if noncurrent_version_transitions is not None:
            pulumi.set(__self__, "noncurrent_version_transitions", noncurrent_version_transitions)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if transitions is not None:
            pulumi.set(__self__, "transitions", transitions)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Specifies lifecycle rule status.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="abortIncompleteMultipartUploadDays")
    def abort_incomplete_multipart_upload_days(self) -> Optional[int]:
        """
        Specifies the number of days after initiating a multipart upload when the multipart upload must be completed.
        """
        return pulumi.get(self, "abort_incomplete_multipart_upload_days")

    @property
    @pulumi.getter
    def expiration(self) -> Optional['outputs.BucketLifecycleRuleExpiration']:
        """
        Specifies a period in the object's expire (documented below).
        """
        return pulumi.get(self, "expiration")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Unique identifier for the rule. Must be less than or equal to 255 characters in length.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="noncurrentVersionExpiration")
    def noncurrent_version_expiration(self) -> Optional['outputs.BucketLifecycleRuleNoncurrentVersionExpiration']:
        """
        Specifies when noncurrent object versions expire (documented below).
        """
        return pulumi.get(self, "noncurrent_version_expiration")

    @property
    @pulumi.getter(name="noncurrentVersionTransitions")
    def noncurrent_version_transitions(self) -> Optional[Sequence['outputs.BucketLifecycleRuleNoncurrentVersionTransition']]:
        """
        Specifies when noncurrent object versions transitions (documented below).
        """
        return pulumi.get(self, "noncurrent_version_transitions")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        Object key prefix identifying one or more objects to which the rule applies.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Specifies object tags key and value.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def transitions(self) -> Optional[Sequence['outputs.BucketLifecycleRuleTransition']]:
        """
        Specifies a period in the object's transitions (documented below).
        """
        return pulumi.get(self, "transitions")


@pulumi.output_type
class BucketLifecycleRuleExpiration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expiredObjectDeleteMarker":
            suggest = "expired_object_delete_marker"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLifecycleRuleExpiration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLifecycleRuleExpiration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLifecycleRuleExpiration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 date: Optional[str] = None,
                 days: Optional[int] = None,
                 expired_object_delete_marker: Optional[bool] = None):
        """
        :param str date: Specifies the date after which you want the corresponding action to take effect.
        :param int days: Specifies the number of days after object creation when the specific rule action takes effect.
        :param bool expired_object_delete_marker: On a versioned bucket (versioning-enabled or versioning-suspended bucket), you can add this element in the lifecycle configuration to direct Amazon S3 to delete expired object delete markers. This cannot be specified with Days or Date in a Lifecycle Expiration Policy.
        """
        if date is not None:
            pulumi.set(__self__, "date", date)
        if days is not None:
            pulumi.set(__self__, "days", days)
        if expired_object_delete_marker is not None:
            pulumi.set(__self__, "expired_object_delete_marker", expired_object_delete_marker)

    @property
    @pulumi.getter
    def date(self) -> Optional[str]:
        """
        Specifies the date after which you want the corresponding action to take effect.
        """
        return pulumi.get(self, "date")

    @property
    @pulumi.getter
    def days(self) -> Optional[int]:
        """
        Specifies the number of days after object creation when the specific rule action takes effect.
        """
        return pulumi.get(self, "days")

    @property
    @pulumi.getter(name="expiredObjectDeleteMarker")
    def expired_object_delete_marker(self) -> Optional[bool]:
        """
        On a versioned bucket (versioning-enabled or versioning-suspended bucket), you can add this element in the lifecycle configuration to direct Amazon S3 to delete expired object delete markers. This cannot be specified with Days or Date in a Lifecycle Expiration Policy.
        """
        return pulumi.get(self, "expired_object_delete_marker")


@pulumi.output_type
class BucketLifecycleRuleNoncurrentVersionExpiration(dict):
    def __init__(__self__, *,
                 days: Optional[int] = None):
        """
        :param int days: Specifies the number of days noncurrent object versions expire.
        """
        if days is not None:
            pulumi.set(__self__, "days", days)

    @property
    @pulumi.getter
    def days(self) -> Optional[int]:
        """
        Specifies the number of days noncurrent object versions expire.
        """
        return pulumi.get(self, "days")


@pulumi.output_type
class BucketLifecycleRuleNoncurrentVersionTransition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageClass":
            suggest = "storage_class"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLifecycleRuleNoncurrentVersionTransition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLifecycleRuleNoncurrentVersionTransition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLifecycleRuleNoncurrentVersionTransition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_class: str,
                 days: Optional[int] = None):
        """
        :param str storage_class: Specifies the Amazon S3 storage class to which you want the noncurrent object versions to transition. Can be `ONEZONE_IA`, `STANDARD_IA`, `INTELLIGENT_TIERING`, `GLACIER`, or `DEEP_ARCHIVE`.
        :param int days: Specifies the number of days noncurrent object versions transition.
        """
        pulumi.set(__self__, "storage_class", storage_class)
        if days is not None:
            pulumi.set(__self__, "days", days)

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> str:
        """
        Specifies the Amazon S3 storage class to which you want the noncurrent object versions to transition. Can be `ONEZONE_IA`, `STANDARD_IA`, `INTELLIGENT_TIERING`, `GLACIER`, or `DEEP_ARCHIVE`.
        """
        return pulumi.get(self, "storage_class")

    @property
    @pulumi.getter
    def days(self) -> Optional[int]:
        """
        Specifies the number of days noncurrent object versions transition.
        """
        return pulumi.get(self, "days")


@pulumi.output_type
class BucketLifecycleRuleTransition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageClass":
            suggest = "storage_class"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLifecycleRuleTransition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLifecycleRuleTransition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLifecycleRuleTransition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_class: str,
                 date: Optional[str] = None,
                 days: Optional[int] = None):
        """
        :param str storage_class: Specifies the Amazon S3 storage class to which you want the object to transition. Can be `ONEZONE_IA`, `STANDARD_IA`, `INTELLIGENT_TIERING`, `GLACIER`, or `DEEP_ARCHIVE`.
        :param str date: Specifies the date after which you want the corresponding action to take effect.
        :param int days: Specifies the number of days after object creation when the specific rule action takes effect.
        """
        pulumi.set(__self__, "storage_class", storage_class)
        if date is not None:
            pulumi.set(__self__, "date", date)
        if days is not None:
            pulumi.set(__self__, "days", days)

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> str:
        """
        Specifies the Amazon S3 storage class to which you want the object to transition. Can be `ONEZONE_IA`, `STANDARD_IA`, `INTELLIGENT_TIERING`, `GLACIER`, or `DEEP_ARCHIVE`.
        """
        return pulumi.get(self, "storage_class")

    @property
    @pulumi.getter
    def date(self) -> Optional[str]:
        """
        Specifies the date after which you want the corresponding action to take effect.
        """
        return pulumi.get(self, "date")

    @property
    @pulumi.getter
    def days(self) -> Optional[int]:
        """
        Specifies the number of days after object creation when the specific rule action takes effect.
        """
        return pulumi.get(self, "days")


@pulumi.output_type
class BucketLogging(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetBucket":
            suggest = "target_bucket"
        elif key == "targetPrefix":
            suggest = "target_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLogging. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLogging.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLogging.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_bucket: str,
                 target_prefix: Optional[str] = None):
        """
        :param str target_bucket: The name of the bucket that will receive the log objects.
        :param str target_prefix: To specify a key prefix for log objects.
        """
        pulumi.set(__self__, "target_bucket", target_bucket)
        if target_prefix is not None:
            pulumi.set(__self__, "target_prefix", target_prefix)

    @property
    @pulumi.getter(name="targetBucket")
    def target_bucket(self) -> str:
        """
        The name of the bucket that will receive the log objects.
        """
        return pulumi.get(self, "target_bucket")

    @property
    @pulumi.getter(name="targetPrefix")
    def target_prefix(self) -> Optional[str]:
        """
        To specify a key prefix for log objects.
        """
        return pulumi.get(self, "target_prefix")


@pulumi.output_type
class BucketMetricFilter(dict):
    def __init__(__self__, *,
                 prefix: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        :param str prefix: Object prefix for filtering (singular).
        :param Mapping[str, str] tags: Object tags for filtering (up to 10).
        """
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        Object prefix for filtering (singular).
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Object tags for filtering (up to 10).
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class BucketNotificationLambdaFunction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filterPrefix":
            suggest = "filter_prefix"
        elif key == "filterSuffix":
            suggest = "filter_suffix"
        elif key == "lambdaFunctionArn":
            suggest = "lambda_function_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketNotificationLambdaFunction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketNotificationLambdaFunction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketNotificationLambdaFunction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 events: Sequence[str],
                 filter_prefix: Optional[str] = None,
                 filter_suffix: Optional[str] = None,
                 id: Optional[str] = None,
                 lambda_function_arn: Optional[str] = None):
        """
        :param Sequence[str] events: Specifies [event](http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html#notification-how-to-event-types-and-destinations) for which to send notifications.
        :param str filter_prefix: Specifies object key name prefix.
        :param str filter_suffix: Specifies object key name suffix.
        :param str id: Specifies unique identifier for each of the notification configurations.
        :param str lambda_function_arn: Specifies Amazon Lambda function ARN.
        """
        pulumi.set(__self__, "events", events)
        if filter_prefix is not None:
            pulumi.set(__self__, "filter_prefix", filter_prefix)
        if filter_suffix is not None:
            pulumi.set(__self__, "filter_suffix", filter_suffix)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if lambda_function_arn is not None:
            pulumi.set(__self__, "lambda_function_arn", lambda_function_arn)

    @property
    @pulumi.getter
    def events(self) -> Sequence[str]:
        """
        Specifies [event](http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html#notification-how-to-event-types-and-destinations) for which to send notifications.
        """
        return pulumi.get(self, "events")

    @property
    @pulumi.getter(name="filterPrefix")
    def filter_prefix(self) -> Optional[str]:
        """
        Specifies object key name prefix.
        """
        return pulumi.get(self, "filter_prefix")

    @property
    @pulumi.getter(name="filterSuffix")
    def filter_suffix(self) -> Optional[str]:
        """
        Specifies object key name suffix.
        """
        return pulumi.get(self, "filter_suffix")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Specifies unique identifier for each of the notification configurations.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lambdaFunctionArn")
    def lambda_function_arn(self) -> Optional[str]:
        """
        Specifies Amazon Lambda function ARN.
        """
        return pulumi.get(self, "lambda_function_arn")


@pulumi.output_type
class BucketNotificationQueue(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queueArn":
            suggest = "queue_arn"
        elif key == "filterPrefix":
            suggest = "filter_prefix"
        elif key == "filterSuffix":
            suggest = "filter_suffix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketNotificationQueue. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketNotificationQueue.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketNotificationQueue.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 events: Sequence[str],
                 queue_arn: str,
                 filter_prefix: Optional[str] = None,
                 filter_suffix: Optional[str] = None,
                 id: Optional[str] = None):
        """
        :param Sequence[str] events: Specifies [event](http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html#notification-how-to-event-types-and-destinations) for which to send notifications.
        :param str queue_arn: Specifies Amazon SQS queue ARN.
        :param str filter_prefix: Specifies object key name prefix.
        :param str filter_suffix: Specifies object key name suffix.
        :param str id: Specifies unique identifier for each of the notification configurations.
        """
        pulumi.set(__self__, "events", events)
        pulumi.set(__self__, "queue_arn", queue_arn)
        if filter_prefix is not None:
            pulumi.set(__self__, "filter_prefix", filter_prefix)
        if filter_suffix is not None:
            pulumi.set(__self__, "filter_suffix", filter_suffix)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def events(self) -> Sequence[str]:
        """
        Specifies [event](http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html#notification-how-to-event-types-and-destinations) for which to send notifications.
        """
        return pulumi.get(self, "events")

    @property
    @pulumi.getter(name="queueArn")
    def queue_arn(self) -> str:
        """
        Specifies Amazon SQS queue ARN.
        """
        return pulumi.get(self, "queue_arn")

    @property
    @pulumi.getter(name="filterPrefix")
    def filter_prefix(self) -> Optional[str]:
        """
        Specifies object key name prefix.
        """
        return pulumi.get(self, "filter_prefix")

    @property
    @pulumi.getter(name="filterSuffix")
    def filter_suffix(self) -> Optional[str]:
        """
        Specifies object key name suffix.
        """
        return pulumi.get(self, "filter_suffix")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Specifies unique identifier for each of the notification configurations.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class BucketNotificationTopic(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "topicArn":
            suggest = "topic_arn"
        elif key == "filterPrefix":
            suggest = "filter_prefix"
        elif key == "filterSuffix":
            suggest = "filter_suffix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketNotificationTopic. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketNotificationTopic.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketNotificationTopic.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 events: Sequence[str],
                 topic_arn: str,
                 filter_prefix: Optional[str] = None,
                 filter_suffix: Optional[str] = None,
                 id: Optional[str] = None):
        """
        :param Sequence[str] events: Specifies [event](http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html#notification-how-to-event-types-and-destinations) for which to send notifications.
        :param str topic_arn: Specifies Amazon SNS topic ARN.
        :param str filter_prefix: Specifies object key name prefix.
        :param str filter_suffix: Specifies object key name suffix.
        :param str id: Specifies unique identifier for each of the notification configurations.
        """
        pulumi.set(__self__, "events", events)
        pulumi.set(__self__, "topic_arn", topic_arn)
        if filter_prefix is not None:
            pulumi.set(__self__, "filter_prefix", filter_prefix)
        if filter_suffix is not None:
            pulumi.set(__self__, "filter_suffix", filter_suffix)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def events(self) -> Sequence[str]:
        """
        Specifies [event](http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html#notification-how-to-event-types-and-destinations) for which to send notifications.
        """
        return pulumi.get(self, "events")

    @property
    @pulumi.getter(name="topicArn")
    def topic_arn(self) -> str:
        """
        Specifies Amazon SNS topic ARN.
        """
        return pulumi.get(self, "topic_arn")

    @property
    @pulumi.getter(name="filterPrefix")
    def filter_prefix(self) -> Optional[str]:
        """
        Specifies object key name prefix.
        """
        return pulumi.get(self, "filter_prefix")

    @property
    @pulumi.getter(name="filterSuffix")
    def filter_suffix(self) -> Optional[str]:
        """
        Specifies object key name suffix.
        """
        return pulumi.get(self, "filter_suffix")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Specifies unique identifier for each of the notification configurations.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class BucketObjectLockConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectLockEnabled":
            suggest = "object_lock_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketObjectLockConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketObjectLockConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketObjectLockConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_lock_enabled: str,
                 rule: Optional['outputs.BucketObjectLockConfigurationRule'] = None):
        """
        :param str object_lock_enabled: Indicates whether this bucket has an Object Lock configuration enabled. Valid value is `Enabled`.
        :param 'BucketObjectLockConfigurationRuleArgs' rule: The Object Lock rule in place for this bucket.
        """
        pulumi.set(__self__, "object_lock_enabled", object_lock_enabled)
        if rule is not None:
            pulumi.set(__self__, "rule", rule)

    @property
    @pulumi.getter(name="objectLockEnabled")
    def object_lock_enabled(self) -> str:
        """
        Indicates whether this bucket has an Object Lock configuration enabled. Valid value is `Enabled`.
        """
        return pulumi.get(self, "object_lock_enabled")

    @property
    @pulumi.getter
    def rule(self) -> Optional['outputs.BucketObjectLockConfigurationRule']:
        """
        The Object Lock rule in place for this bucket.
        """
        return pulumi.get(self, "rule")


@pulumi.output_type
class BucketObjectLockConfigurationRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultRetention":
            suggest = "default_retention"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketObjectLockConfigurationRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketObjectLockConfigurationRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketObjectLockConfigurationRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_retention: 'outputs.BucketObjectLockConfigurationRuleDefaultRetention'):
        """
        :param 'BucketObjectLockConfigurationRuleDefaultRetentionArgs' default_retention: The default retention period that you want to apply to new objects placed in this bucket.
        """
        pulumi.set(__self__, "default_retention", default_retention)

    @property
    @pulumi.getter(name="defaultRetention")
    def default_retention(self) -> 'outputs.BucketObjectLockConfigurationRuleDefaultRetention':
        """
        The default retention period that you want to apply to new objects placed in this bucket.
        """
        return pulumi.get(self, "default_retention")


@pulumi.output_type
class BucketObjectLockConfigurationRuleDefaultRetention(dict):
    def __init__(__self__, *,
                 mode: str,
                 days: Optional[int] = None,
                 years: Optional[int] = None):
        """
        :param str mode: The default Object Lock retention mode you want to apply to new objects placed in this bucket. Valid values are `GOVERNANCE` and `COMPLIANCE`.
        :param int days: The number of days that you want to specify for the default retention period.
        :param int years: The number of years that you want to specify for the default retention period.
        """
        pulumi.set(__self__, "mode", mode)
        if days is not None:
            pulumi.set(__self__, "days", days)
        if years is not None:
            pulumi.set(__self__, "years", years)

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        The default Object Lock retention mode you want to apply to new objects placed in this bucket. Valid values are `GOVERNANCE` and `COMPLIANCE`.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def days(self) -> Optional[int]:
        """
        The number of days that you want to specify for the default retention period.
        """
        return pulumi.get(self, "days")

    @property
    @pulumi.getter
    def years(self) -> Optional[int]:
        """
        The number of years that you want to specify for the default retention period.
        """
        return pulumi.get(self, "years")


@pulumi.output_type
class BucketOwnershipControlsRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectOwnership":
            suggest = "object_ownership"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketOwnershipControlsRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketOwnershipControlsRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketOwnershipControlsRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_ownership: str):
        """
        :param str object_ownership: Object ownership. Valid values: `BucketOwnerPreferred` or `ObjectWriter`
        """
        pulumi.set(__self__, "object_ownership", object_ownership)

    @property
    @pulumi.getter(name="objectOwnership")
    def object_ownership(self) -> str:
        """
        Object ownership. Valid values: `BucketOwnerPreferred` or `ObjectWriter`
        """
        return pulumi.get(self, "object_ownership")


@pulumi.output_type
class BucketReplicationConfiguration(dict):
    def __init__(__self__, *,
                 role: str,
                 rules: Sequence['outputs.BucketReplicationConfigurationRule']):
        """
        :param str role: The ARN of the IAM role for Amazon S3 to assume when replicating the objects.
        :param Sequence['BucketReplicationConfigurationRuleArgs'] rules: Specifies the rules managing the replication (documented below).
        """
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        The ARN of the IAM role for Amazon S3 to assume when replicating the objects.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.BucketReplicationConfigurationRule']:
        """
        Specifies the rules managing the replication (documented below).
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class BucketReplicationConfigurationRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deleteMarkerReplicationStatus":
            suggest = "delete_marker_replication_status"
        elif key == "sourceSelectionCriteria":
            suggest = "source_selection_criteria"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketReplicationConfigurationRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketReplicationConfigurationRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketReplicationConfigurationRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination: 'outputs.BucketReplicationConfigurationRuleDestination',
                 status: str,
                 delete_marker_replication_status: Optional[str] = None,
                 filter: Optional['outputs.BucketReplicationConfigurationRuleFilter'] = None,
                 id: Optional[str] = None,
                 prefix: Optional[str] = None,
                 priority: Optional[int] = None,
                 source_selection_criteria: Optional['outputs.BucketReplicationConfigurationRuleSourceSelectionCriteria'] = None):
        """
        :param 'BucketReplicationConfigurationRuleDestinationArgs' destination: Specifies the destination for the rule (documented below).
        :param str status: The status of the rule. Either `Enabled` or `Disabled`. The rule is ignored if status is not Enabled.
        :param str delete_marker_replication_status: Whether delete markers are replicated. The only valid value is `Enabled`. To disable, omit this argument. This argument is only valid with V2 replication configurations (i.e., when `filter` is used).
        :param 'BucketReplicationConfigurationRuleFilterArgs' filter: Filter that identifies subset of objects to which the replication rule applies (documented below).
        :param str id: Unique identifier for the rule. Must be less than or equal to 255 characters in length.
        :param str prefix: Object keyname prefix identifying one or more objects to which the rule applies. Must be less than or equal to 1024 characters in length.
        :param int priority: The priority associated with the rule. Priority should only be set if `filter` is configured. If not provided, defaults to `0`. Priority must be unique between multiple rules.
        :param 'BucketReplicationConfigurationRuleSourceSelectionCriteriaArgs' source_selection_criteria: Specifies special object selection criteria (documented below).
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "status", status)
        if delete_marker_replication_status is not None:
            pulumi.set(__self__, "delete_marker_replication_status", delete_marker_replication_status)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if source_selection_criteria is not None:
            pulumi.set(__self__, "source_selection_criteria", source_selection_criteria)

    @property
    @pulumi.getter
    def destination(self) -> 'outputs.BucketReplicationConfigurationRuleDestination':
        """
        Specifies the destination for the rule (documented below).
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the rule. Either `Enabled` or `Disabled`. The rule is ignored if status is not Enabled.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="deleteMarkerReplicationStatus")
    def delete_marker_replication_status(self) -> Optional[str]:
        """
        Whether delete markers are replicated. The only valid value is `Enabled`. To disable, omit this argument. This argument is only valid with V2 replication configurations (i.e., when `filter` is used).
        """
        return pulumi.get(self, "delete_marker_replication_status")

    @property
    @pulumi.getter
    def filter(self) -> Optional['outputs.BucketReplicationConfigurationRuleFilter']:
        """
        Filter that identifies subset of objects to which the replication rule applies (documented below).
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Unique identifier for the rule. Must be less than or equal to 255 characters in length.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        Object keyname prefix identifying one or more objects to which the rule applies. Must be less than or equal to 1024 characters in length.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        The priority associated with the rule. Priority should only be set if `filter` is configured. If not provided, defaults to `0`. Priority must be unique between multiple rules.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="sourceSelectionCriteria")
    def source_selection_criteria(self) -> Optional['outputs.BucketReplicationConfigurationRuleSourceSelectionCriteria']:
        """
        Specifies special object selection criteria (documented below).
        """
        return pulumi.get(self, "source_selection_criteria")


@pulumi.output_type
class BucketReplicationConfigurationRuleDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessControlTranslation":
            suggest = "access_control_translation"
        elif key == "accountId":
            suggest = "account_id"
        elif key == "replicaKmsKeyId":
            suggest = "replica_kms_key_id"
        elif key == "storageClass":
            suggest = "storage_class"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketReplicationConfigurationRuleDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketReplicationConfigurationRuleDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketReplicationConfigurationRuleDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: str,
                 access_control_translation: Optional['outputs.BucketReplicationConfigurationRuleDestinationAccessControlTranslation'] = None,
                 account_id: Optional[str] = None,
                 replica_kms_key_id: Optional[str] = None,
                 storage_class: Optional[str] = None):
        """
        :param str bucket: The ARN of the S3 bucket where you want Amazon S3 to store replicas of the object identified by the rule.
        :param 'BucketReplicationConfigurationRuleDestinationAccessControlTranslationArgs' access_control_translation: Specifies the overrides to use for object owners on replication. Must be used in conjunction with `account_id` owner override configuration.
        :param str account_id: The Account ID to use for overriding the object owner on replication. Must be used in conjunction with `access_control_translation` override configuration.
        :param str replica_kms_key_id: Destination KMS encryption key ARN for SSE-KMS replication. Must be used in conjunction with
               `sse_kms_encrypted_objects` source selection criteria.
        :param str storage_class: The class of storage used to store the object. Can be `STANDARD`, `REDUCED_REDUNDANCY`, `STANDARD_IA`, `ONEZONE_IA`, `INTELLIGENT_TIERING`, `GLACIER`, or `DEEP_ARCHIVE`.
        """
        pulumi.set(__self__, "bucket", bucket)
        if access_control_translation is not None:
            pulumi.set(__self__, "access_control_translation", access_control_translation)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if replica_kms_key_id is not None:
            pulumi.set(__self__, "replica_kms_key_id", replica_kms_key_id)
        if storage_class is not None:
            pulumi.set(__self__, "storage_class", storage_class)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The ARN of the S3 bucket where you want Amazon S3 to store replicas of the object identified by the rule.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="accessControlTranslation")
    def access_control_translation(self) -> Optional['outputs.BucketReplicationConfigurationRuleDestinationAccessControlTranslation']:
        """
        Specifies the overrides to use for object owners on replication. Must be used in conjunction with `account_id` owner override configuration.
        """
        return pulumi.get(self, "access_control_translation")

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[str]:
        """
        The Account ID to use for overriding the object owner on replication. Must be used in conjunction with `access_control_translation` override configuration.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="replicaKmsKeyId")
    def replica_kms_key_id(self) -> Optional[str]:
        """
        Destination KMS encryption key ARN for SSE-KMS replication. Must be used in conjunction with
        `sse_kms_encrypted_objects` source selection criteria.
        """
        return pulumi.get(self, "replica_kms_key_id")

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> Optional[str]:
        """
        The class of storage used to store the object. Can be `STANDARD`, `REDUCED_REDUNDANCY`, `STANDARD_IA`, `ONEZONE_IA`, `INTELLIGENT_TIERING`, `GLACIER`, or `DEEP_ARCHIVE`.
        """
        return pulumi.get(self, "storage_class")


@pulumi.output_type
class BucketReplicationConfigurationRuleDestinationAccessControlTranslation(dict):
    def __init__(__self__, *,
                 owner: str):
        """
        :param str owner: The override value for the owner on replicated objects. Currently only `Destination` is supported.
        """
        pulumi.set(__self__, "owner", owner)

    @property
    @pulumi.getter
    def owner(self) -> str:
        """
        The override value for the owner on replicated objects. Currently only `Destination` is supported.
        """
        return pulumi.get(self, "owner")


@pulumi.output_type
class BucketReplicationConfigurationRuleFilter(dict):
    def __init__(__self__, *,
                 prefix: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        :param str prefix: Object keyname prefix that identifies subset of objects to which the rule applies. Must be less than or equal to 1024 characters in length.
        :param Mapping[str, str] tags: A map of tags that identifies subset of objects to which the rule applies.
               The rule applies only to objects having all the tags in its tagset.
        """
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        Object keyname prefix that identifies subset of objects to which the rule applies. Must be less than or equal to 1024 characters in length.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        A map of tags that identifies subset of objects to which the rule applies.
        The rule applies only to objects having all the tags in its tagset.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class BucketReplicationConfigurationRuleSourceSelectionCriteria(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sseKmsEncryptedObjects":
            suggest = "sse_kms_encrypted_objects"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketReplicationConfigurationRuleSourceSelectionCriteria. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketReplicationConfigurationRuleSourceSelectionCriteria.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketReplicationConfigurationRuleSourceSelectionCriteria.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sse_kms_encrypted_objects: Optional['outputs.BucketReplicationConfigurationRuleSourceSelectionCriteriaSseKmsEncryptedObjects'] = None):
        """
        :param 'BucketReplicationConfigurationRuleSourceSelectionCriteriaSseKmsEncryptedObjectsArgs' sse_kms_encrypted_objects: Match SSE-KMS encrypted objects (documented below). If specified, `replica_kms_key_id`
               in `destination` must be specified as well.
        """
        if sse_kms_encrypted_objects is not None:
            pulumi.set(__self__, "sse_kms_encrypted_objects", sse_kms_encrypted_objects)

    @property
    @pulumi.getter(name="sseKmsEncryptedObjects")
    def sse_kms_encrypted_objects(self) -> Optional['outputs.BucketReplicationConfigurationRuleSourceSelectionCriteriaSseKmsEncryptedObjects']:
        """
        Match SSE-KMS encrypted objects (documented below). If specified, `replica_kms_key_id`
        in `destination` must be specified as well.
        """
        return pulumi.get(self, "sse_kms_encrypted_objects")


@pulumi.output_type
class BucketReplicationConfigurationRuleSourceSelectionCriteriaSseKmsEncryptedObjects(dict):
    def __init__(__self__, *,
                 enabled: bool):
        """
        :param bool enabled: Boolean which indicates if this criteria is enabled.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Boolean which indicates if this criteria is enabled.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class BucketServerSideEncryptionConfiguration(dict):
    def __init__(__self__, *,
                 rule: 'outputs.BucketServerSideEncryptionConfigurationRule'):
        """
        :param 'BucketServerSideEncryptionConfigurationRuleArgs' rule: A single object for server-side encryption by default configuration. (documented below)
        """
        pulumi.set(__self__, "rule", rule)

    @property
    @pulumi.getter
    def rule(self) -> 'outputs.BucketServerSideEncryptionConfigurationRule':
        """
        A single object for server-side encryption by default configuration. (documented below)
        """
        return pulumi.get(self, "rule")


@pulumi.output_type
class BucketServerSideEncryptionConfigurationRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applyServerSideEncryptionByDefault":
            suggest = "apply_server_side_encryption_by_default"
        elif key == "bucketKeyEnabled":
            suggest = "bucket_key_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketServerSideEncryptionConfigurationRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketServerSideEncryptionConfigurationRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketServerSideEncryptionConfigurationRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 apply_server_side_encryption_by_default: 'outputs.BucketServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefault',
                 bucket_key_enabled: Optional[bool] = None):
        """
        :param 'BucketServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefaultArgs' apply_server_side_encryption_by_default: A single object for setting server-side encryption by default. (documented below)
        :param bool bucket_key_enabled: Whether or not to use [Amazon S3 Bucket Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html) for SSE-KMS.
        """
        pulumi.set(__self__, "apply_server_side_encryption_by_default", apply_server_side_encryption_by_default)
        if bucket_key_enabled is not None:
            pulumi.set(__self__, "bucket_key_enabled", bucket_key_enabled)

    @property
    @pulumi.getter(name="applyServerSideEncryptionByDefault")
    def apply_server_side_encryption_by_default(self) -> 'outputs.BucketServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefault':
        """
        A single object for setting server-side encryption by default. (documented below)
        """
        return pulumi.get(self, "apply_server_side_encryption_by_default")

    @property
    @pulumi.getter(name="bucketKeyEnabled")
    def bucket_key_enabled(self) -> Optional[bool]:
        """
        Whether or not to use [Amazon S3 Bucket Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html) for SSE-KMS.
        """
        return pulumi.get(self, "bucket_key_enabled")


@pulumi.output_type
class BucketServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefault(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sseAlgorithm":
            suggest = "sse_algorithm"
        elif key == "kmsMasterKeyId":
            suggest = "kms_master_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefault. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefault.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefault.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sse_algorithm: str,
                 kms_master_key_id: Optional[str] = None):
        """
        :param str sse_algorithm: The server-side encryption algorithm to use. Valid values are `AES256` and `aws:kms`
        :param str kms_master_key_id: The AWS KMS master key ID used for the SSE-KMS encryption. This can only be used when you set the value of `sse_algorithm` as `aws:kms`. The default `aws/s3` AWS KMS master key is used if this element is absent while the `sse_algorithm` is `aws:kms`.
        """
        pulumi.set(__self__, "sse_algorithm", sse_algorithm)
        if kms_master_key_id is not None:
            pulumi.set(__self__, "kms_master_key_id", kms_master_key_id)

    @property
    @pulumi.getter(name="sseAlgorithm")
    def sse_algorithm(self) -> str:
        """
        The server-side encryption algorithm to use. Valid values are `AES256` and `aws:kms`
        """
        return pulumi.get(self, "sse_algorithm")

    @property
    @pulumi.getter(name="kmsMasterKeyId")
    def kms_master_key_id(self) -> Optional[str]:
        """
        The AWS KMS master key ID used for the SSE-KMS encryption. This can only be used when you set the value of `sse_algorithm` as `aws:kms`. The default `aws/s3` AWS KMS master key is used if this element is absent while the `sse_algorithm` is `aws:kms`.
        """
        return pulumi.get(self, "kms_master_key_id")


@pulumi.output_type
class BucketVersioning(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mfaDelete":
            suggest = "mfa_delete"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketVersioning. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketVersioning.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketVersioning.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 mfa_delete: Optional[bool] = None):
        """
        :param bool enabled: Enable versioning. Once you version-enable a bucket, it can never return to an unversioned state. You can, however, suspend versioning on that bucket.
        :param bool mfa_delete: Enable MFA delete for either `Change the versioning state of your bucket` or `Permanently delete an object version`. Default is `false`. This cannot be used to toggle this setting but is available to allow managed buckets to reflect the state in AWS
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if mfa_delete is not None:
            pulumi.set(__self__, "mfa_delete", mfa_delete)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Enable versioning. Once you version-enable a bucket, it can never return to an unversioned state. You can, however, suspend versioning on that bucket.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="mfaDelete")
    def mfa_delete(self) -> Optional[bool]:
        """
        Enable MFA delete for either `Change the versioning state of your bucket` or `Permanently delete an object version`. Default is `false`. This cannot be used to toggle this setting but is available to allow managed buckets to reflect the state in AWS
        """
        return pulumi.get(self, "mfa_delete")


@pulumi.output_type
class BucketWebsite(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorDocument":
            suggest = "error_document"
        elif key == "indexDocument":
            suggest = "index_document"
        elif key == "redirectAllRequestsTo":
            suggest = "redirect_all_requests_to"
        elif key == "routingRules":
            suggest = "routing_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketWebsite. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketWebsite.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketWebsite.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_document: Optional[str] = None,
                 index_document: Optional[str] = None,
                 redirect_all_requests_to: Optional[str] = None,
                 routing_rules: Optional[str] = None):
        """
        :param str error_document: An absolute path to the document to return in case of a 4XX error.
        :param str index_document: Amazon S3 returns this index document when requests are made to the root domain or any of the subfolders.
        :param str redirect_all_requests_to: A hostname to redirect all website requests for this bucket to. Hostname can optionally be prefixed with a protocol (`http://` or `https://`) to use when redirecting requests. The default is the protocol that is used in the original request.
        :param Union[str, Sequence[str]] routing_rules: A json array containing [routing rules](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html)
               describing redirect behavior and when redirects are applied.
        """
        if error_document is not None:
            pulumi.set(__self__, "error_document", error_document)
        if index_document is not None:
            pulumi.set(__self__, "index_document", index_document)
        if redirect_all_requests_to is not None:
            pulumi.set(__self__, "redirect_all_requests_to", redirect_all_requests_to)
        if routing_rules is not None:
            pulumi.set(__self__, "routing_rules", routing_rules)

    @property
    @pulumi.getter(name="errorDocument")
    def error_document(self) -> Optional[str]:
        """
        An absolute path to the document to return in case of a 4XX error.
        """
        return pulumi.get(self, "error_document")

    @property
    @pulumi.getter(name="indexDocument")
    def index_document(self) -> Optional[str]:
        """
        Amazon S3 returns this index document when requests are made to the root domain or any of the subfolders.
        """
        return pulumi.get(self, "index_document")

    @property
    @pulumi.getter(name="redirectAllRequestsTo")
    def redirect_all_requests_to(self) -> Optional[str]:
        """
        A hostname to redirect all website requests for this bucket to. Hostname can optionally be prefixed with a protocol (`http://` or `https://`) to use when redirecting requests. The default is the protocol that is used in the original request.
        """
        return pulumi.get(self, "redirect_all_requests_to")

    @property
    @pulumi.getter(name="routingRules")
    def routing_rules(self) -> Optional[str]:
        """
        A json array containing [routing rules](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html)
        describing redirect behavior and when redirects are applied.
        """
        return pulumi.get(self, "routing_rules")


@pulumi.output_type
class InventoryDestination(dict):
    def __init__(__self__, *,
                 bucket: 'outputs.InventoryDestinationBucket'):
        """
        :param 'InventoryDestinationBucketArgs' bucket: The S3 bucket configuration where inventory results are published (documented below).
        """
        pulumi.set(__self__, "bucket", bucket)

    @property
    @pulumi.getter
    def bucket(self) -> 'outputs.InventoryDestinationBucket':
        """
        The S3 bucket configuration where inventory results are published (documented below).
        """
        return pulumi.get(self, "bucket")


@pulumi.output_type
class InventoryDestinationBucket(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketArn":
            suggest = "bucket_arn"
        elif key == "accountId":
            suggest = "account_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InventoryDestinationBucket. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InventoryDestinationBucket.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InventoryDestinationBucket.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_arn: str,
                 format: str,
                 account_id: Optional[str] = None,
                 encryption: Optional['outputs.InventoryDestinationBucketEncryption'] = None,
                 prefix: Optional[str] = None):
        """
        :param str bucket_arn: The Amazon S3 bucket ARN of the destination.
        :param str format: Specifies the output format of the inventory results. Can be `CSV`, [`ORC`](https://orc.apache.org/) or [`Parquet`](https://parquet.apache.org/).
        :param str account_id: The ID of the account that owns the destination bucket. Recommended to be set to prevent problems if the destination bucket ownership changes.
        :param 'InventoryDestinationBucketEncryptionArgs' encryption: Contains the type of server-side encryption to use to encrypt the inventory (documented below).
        :param str prefix: The prefix that is prepended to all inventory results.
        """
        pulumi.set(__self__, "bucket_arn", bucket_arn)
        pulumi.set(__self__, "format", format)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter(name="bucketArn")
    def bucket_arn(self) -> str:
        """
        The Amazon S3 bucket ARN of the destination.
        """
        return pulumi.get(self, "bucket_arn")

    @property
    @pulumi.getter
    def format(self) -> str:
        """
        Specifies the output format of the inventory results. Can be `CSV`, [`ORC`](https://orc.apache.org/) or [`Parquet`](https://parquet.apache.org/).
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[str]:
        """
        The ID of the account that owns the destination bucket. Recommended to be set to prevent problems if the destination bucket ownership changes.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def encryption(self) -> Optional['outputs.InventoryDestinationBucketEncryption']:
        """
        Contains the type of server-side encryption to use to encrypt the inventory (documented below).
        """
        return pulumi.get(self, "encryption")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        The prefix that is prepended to all inventory results.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class InventoryDestinationBucketEncryption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sseKms":
            suggest = "sse_kms"
        elif key == "sseS3":
            suggest = "sse_s3"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InventoryDestinationBucketEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InventoryDestinationBucketEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InventoryDestinationBucketEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sse_kms: Optional['outputs.InventoryDestinationBucketEncryptionSseKms'] = None,
                 sse_s3: Optional['outputs.InventoryDestinationBucketEncryptionSseS3'] = None):
        """
        :param 'InventoryDestinationBucketEncryptionSseKmsArgs' sse_kms: Specifies to use server-side encryption with AWS KMS-managed keys to encrypt the inventory file (documented below).
        :param 'InventoryDestinationBucketEncryptionSseS3Args' sse_s3: Specifies to use server-side encryption with Amazon S3-managed keys (SSE-S3) to encrypt the inventory file.
        """
        if sse_kms is not None:
            pulumi.set(__self__, "sse_kms", sse_kms)
        if sse_s3 is not None:
            pulumi.set(__self__, "sse_s3", sse_s3)

    @property
    @pulumi.getter(name="sseKms")
    def sse_kms(self) -> Optional['outputs.InventoryDestinationBucketEncryptionSseKms']:
        """
        Specifies to use server-side encryption with AWS KMS-managed keys to encrypt the inventory file (documented below).
        """
        return pulumi.get(self, "sse_kms")

    @property
    @pulumi.getter(name="sseS3")
    def sse_s3(self) -> Optional['outputs.InventoryDestinationBucketEncryptionSseS3']:
        """
        Specifies to use server-side encryption with Amazon S3-managed keys (SSE-S3) to encrypt the inventory file.
        """
        return pulumi.get(self, "sse_s3")


@pulumi.output_type
class InventoryDestinationBucketEncryptionSseKms(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyId":
            suggest = "key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InventoryDestinationBucketEncryptionSseKms. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InventoryDestinationBucketEncryptionSseKms.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InventoryDestinationBucketEncryptionSseKms.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_id: str):
        """
        :param str key_id: The ARN of the KMS customer master key (CMK) used to encrypt the inventory file.
        """
        pulumi.set(__self__, "key_id", key_id)

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> str:
        """
        The ARN of the KMS customer master key (CMK) used to encrypt the inventory file.
        """
        return pulumi.get(self, "key_id")


@pulumi.output_type
class InventoryDestinationBucketEncryptionSseS3(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class InventoryFilter(dict):
    def __init__(__self__, *,
                 prefix: Optional[str] = None):
        """
        :param str prefix: The prefix that an object must have to be included in the inventory results.
        """
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        The prefix that an object must have to be included in the inventory results.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class InventorySchedule(dict):
    def __init__(__self__, *,
                 frequency: str):
        """
        :param str frequency: Specifies how frequently inventory results are produced. Valid values: `Daily`, `Weekly`.
        """
        pulumi.set(__self__, "frequency", frequency)

    @property
    @pulumi.getter
    def frequency(self) -> str:
        """
        Specifies how frequently inventory results are produced. Valid values: `Daily`, `Weekly`.
        """
        return pulumi.get(self, "frequency")


@pulumi.output_type
class ObjectCopyGrant(dict):
    def __init__(__self__, *,
                 permissions: Sequence[str],
                 type: str,
                 email: Optional[str] = None,
                 id: Optional[str] = None,
                 uri: Optional[str] = None):
        """
        :param Sequence[str] permissions: List of permissions to grant to grantee. Valid values are `READ`, `READ_ACP`, `WRITE_ACP`, `FULL_CONTROL`.
        :param str type: - Type of grantee. Valid values are `CanonicalUser`, `Group`, and `AmazonCustomerByEmail`.
        :param str email: Email address of the grantee. Used only when `type` is `AmazonCustomerByEmail`.
        :param str id: The canonical user ID of the grantee. Used only when `type` is `CanonicalUser`.
        :param str uri: URI of the grantee group. Used only when `type` is `Group`.
        """
        pulumi.set(__self__, "permissions", permissions)
        pulumi.set(__self__, "type", type)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def permissions(self) -> Sequence[str]:
        """
        List of permissions to grant to grantee. Valid values are `READ`, `READ_ACP`, `WRITE_ACP`, `FULL_CONTROL`.
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        - Type of grantee. Valid values are `CanonicalUser`, `Group`, and `AmazonCustomerByEmail`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def email(self) -> Optional[str]:
        """
        Email address of the grantee. Used only when `type` is `AmazonCustomerByEmail`.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The canonical user ID of the grantee. Used only when `type` is `CanonicalUser`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def uri(self) -> Optional[str]:
        """
        URI of the grantee group. Used only when `type` is `Group`.
        """
        return pulumi.get(self, "uri")


