# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'AccessPointPublicAccessBlockConfigurationArgs',
    'AccessPointVpcConfigurationArgs',
    'AnalyticsConfigurationFilterArgs',
    'AnalyticsConfigurationStorageClassAnalysisArgs',
    'AnalyticsConfigurationStorageClassAnalysisDataExportArgs',
    'AnalyticsConfigurationStorageClassAnalysisDataExportDestinationArgs',
    'AnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestinationArgs',
    'BucketCorsRuleArgs',
    'BucketGrantArgs',
    'BucketLifecycleRuleArgs',
    'BucketLifecycleRuleExpirationArgs',
    'BucketLifecycleRuleNoncurrentVersionExpirationArgs',
    'BucketLifecycleRuleNoncurrentVersionTransitionArgs',
    'BucketLifecycleRuleTransitionArgs',
    'BucketLoggingArgs',
    'BucketMetricFilterArgs',
    'BucketNotificationLambdaFunctionArgs',
    'BucketNotificationQueueArgs',
    'BucketNotificationTopicArgs',
    'BucketObjectLockConfigurationArgs',
    'BucketObjectLockConfigurationRuleArgs',
    'BucketObjectLockConfigurationRuleDefaultRetentionArgs',
    'BucketOwnershipControlsRuleArgs',
    'BucketReplicationConfigurationArgs',
    'BucketReplicationConfigurationRuleArgs',
    'BucketReplicationConfigurationRuleDestinationArgs',
    'BucketReplicationConfigurationRuleDestinationAccessControlTranslationArgs',
    'BucketReplicationConfigurationRuleFilterArgs',
    'BucketReplicationConfigurationRuleSourceSelectionCriteriaArgs',
    'BucketReplicationConfigurationRuleSourceSelectionCriteriaSseKmsEncryptedObjectsArgs',
    'BucketServerSideEncryptionConfigurationArgs',
    'BucketServerSideEncryptionConfigurationRuleArgs',
    'BucketServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefaultArgs',
    'BucketVersioningArgs',
    'BucketWebsiteArgs',
    'InventoryDestinationArgs',
    'InventoryDestinationBucketArgs',
    'InventoryDestinationBucketEncryptionArgs',
    'InventoryDestinationBucketEncryptionSseKmsArgs',
    'InventoryDestinationBucketEncryptionSseS3Args',
    'InventoryFilterArgs',
    'InventoryScheduleArgs',
    'ObjectCopyGrantArgs',
]

@pulumi.input_type
class AccessPointPublicAccessBlockConfigurationArgs:
    def __init__(__self__, *,
                 block_public_acls: Optional[pulumi.Input[bool]] = None,
                 block_public_policy: Optional[pulumi.Input[bool]] = None,
                 ignore_public_acls: Optional[pulumi.Input[bool]] = None,
                 restrict_public_buckets: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] block_public_acls: Whether Amazon S3 should block public ACLs for buckets in this account. Defaults to `true`. Enabling this setting does not affect existing policies or ACLs. When set to `true` causes the following behavior:
               * PUT Bucket acl and PUT Object acl calls fail if the specified ACL is public.
               * PUT Object calls fail if the request includes a public ACL.
               * PUT Bucket calls fail if the request includes a public ACL.
        :param pulumi.Input[bool] block_public_policy: Whether Amazon S3 should block public bucket policies for buckets in this account. Defaults to `true`. Enabling this setting does not affect existing bucket policies. When set to `true` causes Amazon S3 to:
               * Reject calls to PUT Bucket policy if the specified bucket policy allows public access.
        :param pulumi.Input[bool] ignore_public_acls: Whether Amazon S3 should ignore public ACLs for buckets in this account. Defaults to `true`. Enabling this setting does not affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set. When set to `true` causes Amazon S3 to:
               * Ignore all public ACLs on buckets in this account and any objects that they contain.
        :param pulumi.Input[bool] restrict_public_buckets: Whether Amazon S3 should restrict public bucket policies for buckets in this account. Defaults to `true`. Enabling this setting does not affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked. When set to `true`:
               * Only the bucket owner and AWS Services can access buckets with public policies.
        """
        if block_public_acls is not None:
            pulumi.set(__self__, "block_public_acls", block_public_acls)
        if block_public_policy is not None:
            pulumi.set(__self__, "block_public_policy", block_public_policy)
        if ignore_public_acls is not None:
            pulumi.set(__self__, "ignore_public_acls", ignore_public_acls)
        if restrict_public_buckets is not None:
            pulumi.set(__self__, "restrict_public_buckets", restrict_public_buckets)

    @property
    @pulumi.getter(name="blockPublicAcls")
    def block_public_acls(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether Amazon S3 should block public ACLs for buckets in this account. Defaults to `true`. Enabling this setting does not affect existing policies or ACLs. When set to `true` causes the following behavior:
        * PUT Bucket acl and PUT Object acl calls fail if the specified ACL is public.
        * PUT Object calls fail if the request includes a public ACL.
        * PUT Bucket calls fail if the request includes a public ACL.
        """
        return pulumi.get(self, "block_public_acls")

    @block_public_acls.setter
    def block_public_acls(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_public_acls", value)

    @property
    @pulumi.getter(name="blockPublicPolicy")
    def block_public_policy(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether Amazon S3 should block public bucket policies for buckets in this account. Defaults to `true`. Enabling this setting does not affect existing bucket policies. When set to `true` causes Amazon S3 to:
        * Reject calls to PUT Bucket policy if the specified bucket policy allows public access.
        """
        return pulumi.get(self, "block_public_policy")

    @block_public_policy.setter
    def block_public_policy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_public_policy", value)

    @property
    @pulumi.getter(name="ignorePublicAcls")
    def ignore_public_acls(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether Amazon S3 should ignore public ACLs for buckets in this account. Defaults to `true`. Enabling this setting does not affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set. When set to `true` causes Amazon S3 to:
        * Ignore all public ACLs on buckets in this account and any objects that they contain.
        """
        return pulumi.get(self, "ignore_public_acls")

    @ignore_public_acls.setter
    def ignore_public_acls(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_public_acls", value)

    @property
    @pulumi.getter(name="restrictPublicBuckets")
    def restrict_public_buckets(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether Amazon S3 should restrict public bucket policies for buckets in this account. Defaults to `true`. Enabling this setting does not affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked. When set to `true`:
        * Only the bucket owner and AWS Services can access buckets with public policies.
        """
        return pulumi.get(self, "restrict_public_buckets")

    @restrict_public_buckets.setter
    def restrict_public_buckets(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "restrict_public_buckets", value)


@pulumi.input_type
class AccessPointVpcConfigurationArgs:
    def __init__(__self__, *,
                 vpc_id: pulumi.Input[str]):
        """
        :param pulumi.Input[str] vpc_id: This access point will only allow connections from the specified VPC ID.
        """
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        This access point will only allow connections from the specified VPC ID.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)


@pulumi.input_type
class AnalyticsConfigurationFilterArgs:
    def __init__(__self__, *,
                 prefix: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] prefix: Object prefix for filtering.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Set of object tags for filtering.
        """
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Object prefix for filtering.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prefix", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Set of object tags for filtering.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class AnalyticsConfigurationStorageClassAnalysisArgs:
    def __init__(__self__, *,
                 data_export: pulumi.Input['AnalyticsConfigurationStorageClassAnalysisDataExportArgs']):
        """
        :param pulumi.Input['AnalyticsConfigurationStorageClassAnalysisDataExportArgs'] data_export: Data export configuration (documented below).
        """
        pulumi.set(__self__, "data_export", data_export)

    @property
    @pulumi.getter(name="dataExport")
    def data_export(self) -> pulumi.Input['AnalyticsConfigurationStorageClassAnalysisDataExportArgs']:
        """
        Data export configuration (documented below).
        """
        return pulumi.get(self, "data_export")

    @data_export.setter
    def data_export(self, value: pulumi.Input['AnalyticsConfigurationStorageClassAnalysisDataExportArgs']):
        pulumi.set(self, "data_export", value)


@pulumi.input_type
class AnalyticsConfigurationStorageClassAnalysisDataExportArgs:
    def __init__(__self__, *,
                 destination: pulumi.Input['AnalyticsConfigurationStorageClassAnalysisDataExportDestinationArgs'],
                 output_schema_version: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input['AnalyticsConfigurationStorageClassAnalysisDataExportDestinationArgs'] destination: Specifies the destination for the exported analytics data (documented below).
        :param pulumi.Input[str] output_schema_version: The schema version of exported analytics data. Allowed values: `V_1`. Default value: `V_1`.
        """
        pulumi.set(__self__, "destination", destination)
        if output_schema_version is not None:
            pulumi.set(__self__, "output_schema_version", output_schema_version)

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Input['AnalyticsConfigurationStorageClassAnalysisDataExportDestinationArgs']:
        """
        Specifies the destination for the exported analytics data (documented below).
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input['AnalyticsConfigurationStorageClassAnalysisDataExportDestinationArgs']):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter(name="outputSchemaVersion")
    def output_schema_version(self) -> Optional[pulumi.Input[str]]:
        """
        The schema version of exported analytics data. Allowed values: `V_1`. Default value: `V_1`.
        """
        return pulumi.get(self, "output_schema_version")

    @output_schema_version.setter
    def output_schema_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "output_schema_version", value)


@pulumi.input_type
class AnalyticsConfigurationStorageClassAnalysisDataExportDestinationArgs:
    def __init__(__self__, *,
                 s3_bucket_destination: pulumi.Input['AnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestinationArgs']):
        """
        :param pulumi.Input['AnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestinationArgs'] s3_bucket_destination: Analytics data export currently only supports an S3 bucket destination (documented below).
        """
        pulumi.set(__self__, "s3_bucket_destination", s3_bucket_destination)

    @property
    @pulumi.getter(name="s3BucketDestination")
    def s3_bucket_destination(self) -> pulumi.Input['AnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestinationArgs']:
        """
        Analytics data export currently only supports an S3 bucket destination (documented below).
        """
        return pulumi.get(self, "s3_bucket_destination")

    @s3_bucket_destination.setter
    def s3_bucket_destination(self, value: pulumi.Input['AnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestinationArgs']):
        pulumi.set(self, "s3_bucket_destination", value)


@pulumi.input_type
class AnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestinationArgs:
    def __init__(__self__, *,
                 bucket_arn: pulumi.Input[str],
                 bucket_account_id: Optional[pulumi.Input[str]] = None,
                 format: Optional[pulumi.Input[str]] = None,
                 prefix: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] bucket_arn: The ARN of the destination bucket.
        :param pulumi.Input[str] bucket_account_id: The account ID that owns the destination bucket.
        :param pulumi.Input[str] format: The output format of exported analytics data. Allowed values: `CSV`. Default value: `CSV`.
        :param pulumi.Input[str] prefix: Object prefix for filtering.
        """
        pulumi.set(__self__, "bucket_arn", bucket_arn)
        if bucket_account_id is not None:
            pulumi.set(__self__, "bucket_account_id", bucket_account_id)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter(name="bucketArn")
    def bucket_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the destination bucket.
        """
        return pulumi.get(self, "bucket_arn")

    @bucket_arn.setter
    def bucket_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket_arn", value)

    @property
    @pulumi.getter(name="bucketAccountId")
    def bucket_account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The account ID that owns the destination bucket.
        """
        return pulumi.get(self, "bucket_account_id")

    @bucket_account_id.setter
    def bucket_account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket_account_id", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[str]]:
        """
        The output format of exported analytics data. Allowed values: `CSV`. Default value: `CSV`.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Object prefix for filtering.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prefix", value)


@pulumi.input_type
class BucketCorsRuleArgs:
    def __init__(__self__, *,
                 allowed_methods: pulumi.Input[Sequence[pulumi.Input[str]]],
                 allowed_origins: pulumi.Input[Sequence[pulumi.Input[str]]],
                 allowed_headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 expose_headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 max_age_seconds: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_methods: Specifies which methods are allowed. Can be `GET`, `PUT`, `POST`, `DELETE` or `HEAD`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_origins: Specifies which origins are allowed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_headers: Specifies which headers are allowed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] expose_headers: Specifies expose header in the response.
        :param pulumi.Input[int] max_age_seconds: Specifies time in seconds that browser can cache the response for a preflight request.
        """
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        if allowed_headers is not None:
            pulumi.set(__self__, "allowed_headers", allowed_headers)
        if expose_headers is not None:
            pulumi.set(__self__, "expose_headers", expose_headers)
        if max_age_seconds is not None:
            pulumi.set(__self__, "max_age_seconds", max_age_seconds)

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Specifies which methods are allowed. Can be `GET`, `PUT`, `POST`, `DELETE` or `HEAD`.
        """
        return pulumi.get(self, "allowed_methods")

    @allowed_methods.setter
    def allowed_methods(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "allowed_methods", value)

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Specifies which origins are allowed.
        """
        return pulumi.get(self, "allowed_origins")

    @allowed_origins.setter
    def allowed_origins(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "allowed_origins", value)

    @property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies which headers are allowed.
        """
        return pulumi.get(self, "allowed_headers")

    @allowed_headers.setter
    def allowed_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_headers", value)

    @property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies expose header in the response.
        """
        return pulumi.get(self, "expose_headers")

    @expose_headers.setter
    def expose_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "expose_headers", value)

    @property
    @pulumi.getter(name="maxAgeSeconds")
    def max_age_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies time in seconds that browser can cache the response for a preflight request.
        """
        return pulumi.get(self, "max_age_seconds")

    @max_age_seconds.setter
    def max_age_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_age_seconds", value)


@pulumi.input_type
class BucketGrantArgs:
    def __init__(__self__, *,
                 permissions: pulumi.Input[Sequence[pulumi.Input[str]]],
                 type: pulumi.Input[str],
                 id: Optional[pulumi.Input[str]] = None,
                 uri: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] permissions: List of permissions to apply for grantee. Valid values are `READ`, `WRITE`, `READ_ACP`, `WRITE_ACP`, `FULL_CONTROL`.
        :param pulumi.Input[str] type: - Type of grantee to apply for. Valid values are `CanonicalUser` and `Group`. `AmazonCustomerByEmail` is not supported.
        :param pulumi.Input[str] id: Canonical user id to grant for. Used only when `type` is `CanonicalUser`.
        :param pulumi.Input[str] uri: Uri address to grant for. Used only when `type` is `Group`.
        """
        pulumi.set(__self__, "permissions", permissions)
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def permissions(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of permissions to apply for grantee. Valid values are `READ`, `WRITE`, `READ_ACP`, `WRITE_ACP`, `FULL_CONTROL`.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "permissions", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        - Type of grantee to apply for. Valid values are `CanonicalUser` and `Group`. `AmazonCustomerByEmail` is not supported.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Canonical user id to grant for. Used only when `type` is `CanonicalUser`.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        """
        Uri address to grant for. Used only when `type` is `Group`.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)


@pulumi.input_type
class BucketLifecycleRuleArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 abort_incomplete_multipart_upload_days: Optional[pulumi.Input[int]] = None,
                 expiration: Optional[pulumi.Input['BucketLifecycleRuleExpirationArgs']] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 noncurrent_version_expiration: Optional[pulumi.Input['BucketLifecycleRuleNoncurrentVersionExpirationArgs']] = None,
                 noncurrent_version_transitions: Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleNoncurrentVersionTransitionArgs']]]] = None,
                 prefix: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 transitions: Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleTransitionArgs']]]] = None):
        """
        :param pulumi.Input[bool] enabled: Specifies lifecycle rule status.
        :param pulumi.Input[int] abort_incomplete_multipart_upload_days: Specifies the number of days after initiating a multipart upload when the multipart upload must be completed.
        :param pulumi.Input['BucketLifecycleRuleExpirationArgs'] expiration: Specifies a period in the object's expire (documented below).
        :param pulumi.Input[str] id: Unique identifier for the rule. Must be less than or equal to 255 characters in length.
        :param pulumi.Input['BucketLifecycleRuleNoncurrentVersionExpirationArgs'] noncurrent_version_expiration: Specifies when noncurrent object versions expire (documented below).
        :param pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleNoncurrentVersionTransitionArgs']]] noncurrent_version_transitions: Specifies when noncurrent object versions transitions (documented below).
        :param pulumi.Input[str] prefix: Object key prefix identifying one or more objects to which the rule applies.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies object tags key and value.
        :param pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleTransitionArgs']]] transitions: Specifies a period in the object's transitions (documented below).
        """
        pulumi.set(__self__, "enabled", enabled)
        if abort_incomplete_multipart_upload_days is not None:
            pulumi.set(__self__, "abort_incomplete_multipart_upload_days", abort_incomplete_multipart_upload_days)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if noncurrent_version_expiration is not None:
            pulumi.set(__self__, "noncurrent_version_expiration", noncurrent_version_expiration)
        if noncurrent_version_transitions is not None:
            pulumi.set(__self__, "noncurrent_version_transitions", noncurrent_version_transitions)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if transitions is not None:
            pulumi.set(__self__, "transitions", transitions)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Specifies lifecycle rule status.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="abortIncompleteMultipartUploadDays")
    def abort_incomplete_multipart_upload_days(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the number of days after initiating a multipart upload when the multipart upload must be completed.
        """
        return pulumi.get(self, "abort_incomplete_multipart_upload_days")

    @abort_incomplete_multipart_upload_days.setter
    def abort_incomplete_multipart_upload_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "abort_incomplete_multipart_upload_days", value)

    @property
    @pulumi.getter
    def expiration(self) -> Optional[pulumi.Input['BucketLifecycleRuleExpirationArgs']]:
        """
        Specifies a period in the object's expire (documented below).
        """
        return pulumi.get(self, "expiration")

    @expiration.setter
    def expiration(self, value: Optional[pulumi.Input['BucketLifecycleRuleExpirationArgs']]):
        pulumi.set(self, "expiration", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier for the rule. Must be less than or equal to 255 characters in length.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="noncurrentVersionExpiration")
    def noncurrent_version_expiration(self) -> Optional[pulumi.Input['BucketLifecycleRuleNoncurrentVersionExpirationArgs']]:
        """
        Specifies when noncurrent object versions expire (documented below).
        """
        return pulumi.get(self, "noncurrent_version_expiration")

    @noncurrent_version_expiration.setter
    def noncurrent_version_expiration(self, value: Optional[pulumi.Input['BucketLifecycleRuleNoncurrentVersionExpirationArgs']]):
        pulumi.set(self, "noncurrent_version_expiration", value)

    @property
    @pulumi.getter(name="noncurrentVersionTransitions")
    def noncurrent_version_transitions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleNoncurrentVersionTransitionArgs']]]]:
        """
        Specifies when noncurrent object versions transitions (documented below).
        """
        return pulumi.get(self, "noncurrent_version_transitions")

    @noncurrent_version_transitions.setter
    def noncurrent_version_transitions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleNoncurrentVersionTransitionArgs']]]]):
        pulumi.set(self, "noncurrent_version_transitions", value)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Object key prefix identifying one or more objects to which the rule applies.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prefix", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies object tags key and value.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def transitions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleTransitionArgs']]]]:
        """
        Specifies a period in the object's transitions (documented below).
        """
        return pulumi.get(self, "transitions")

    @transitions.setter
    def transitions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleTransitionArgs']]]]):
        pulumi.set(self, "transitions", value)


@pulumi.input_type
class BucketLifecycleRuleExpirationArgs:
    def __init__(__self__, *,
                 date: Optional[pulumi.Input[str]] = None,
                 days: Optional[pulumi.Input[int]] = None,
                 expired_object_delete_marker: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] date: Specifies the date after which you want the corresponding action to take effect.
        :param pulumi.Input[int] days: Specifies the number of days after object creation when the specific rule action takes effect.
        :param pulumi.Input[bool] expired_object_delete_marker: On a versioned bucket (versioning-enabled or versioning-suspended bucket), you can add this element in the lifecycle configuration to direct Amazon S3 to delete expired object delete markers. This cannot be specified with Days or Date in a Lifecycle Expiration Policy.
        """
        if date is not None:
            pulumi.set(__self__, "date", date)
        if days is not None:
            pulumi.set(__self__, "days", days)
        if expired_object_delete_marker is not None:
            pulumi.set(__self__, "expired_object_delete_marker", expired_object_delete_marker)

    @property
    @pulumi.getter
    def date(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the date after which you want the corresponding action to take effect.
        """
        return pulumi.get(self, "date")

    @date.setter
    def date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "date", value)

    @property
    @pulumi.getter
    def days(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the number of days after object creation when the specific rule action takes effect.
        """
        return pulumi.get(self, "days")

    @days.setter
    def days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "days", value)

    @property
    @pulumi.getter(name="expiredObjectDeleteMarker")
    def expired_object_delete_marker(self) -> Optional[pulumi.Input[bool]]:
        """
        On a versioned bucket (versioning-enabled or versioning-suspended bucket), you can add this element in the lifecycle configuration to direct Amazon S3 to delete expired object delete markers. This cannot be specified with Days or Date in a Lifecycle Expiration Policy.
        """
        return pulumi.get(self, "expired_object_delete_marker")

    @expired_object_delete_marker.setter
    def expired_object_delete_marker(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "expired_object_delete_marker", value)


@pulumi.input_type
class BucketLifecycleRuleNoncurrentVersionExpirationArgs:
    def __init__(__self__, *,
                 days: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] days: Specifies the number of days noncurrent object versions expire.
        """
        if days is not None:
            pulumi.set(__self__, "days", days)

    @property
    @pulumi.getter
    def days(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the number of days noncurrent object versions expire.
        """
        return pulumi.get(self, "days")

    @days.setter
    def days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "days", value)


@pulumi.input_type
class BucketLifecycleRuleNoncurrentVersionTransitionArgs:
    def __init__(__self__, *,
                 storage_class: pulumi.Input[str],
                 days: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] storage_class: Specifies the Amazon S3 storage class to which you want the noncurrent object versions to transition. Can be `ONEZONE_IA`, `STANDARD_IA`, `INTELLIGENT_TIERING`, `GLACIER`, or `DEEP_ARCHIVE`.
        :param pulumi.Input[int] days: Specifies the number of days noncurrent object versions transition.
        """
        pulumi.set(__self__, "storage_class", storage_class)
        if days is not None:
            pulumi.set(__self__, "days", days)

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> pulumi.Input[str]:
        """
        Specifies the Amazon S3 storage class to which you want the noncurrent object versions to transition. Can be `ONEZONE_IA`, `STANDARD_IA`, `INTELLIGENT_TIERING`, `GLACIER`, or `DEEP_ARCHIVE`.
        """
        return pulumi.get(self, "storage_class")

    @storage_class.setter
    def storage_class(self, value: pulumi.Input[str]):
        pulumi.set(self, "storage_class", value)

    @property
    @pulumi.getter
    def days(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the number of days noncurrent object versions transition.
        """
        return pulumi.get(self, "days")

    @days.setter
    def days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "days", value)


@pulumi.input_type
class BucketLifecycleRuleTransitionArgs:
    def __init__(__self__, *,
                 storage_class: pulumi.Input[str],
                 date: Optional[pulumi.Input[str]] = None,
                 days: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] storage_class: Specifies the Amazon S3 storage class to which you want the object to transition. Can be `ONEZONE_IA`, `STANDARD_IA`, `INTELLIGENT_TIERING`, `GLACIER`, or `DEEP_ARCHIVE`.
        :param pulumi.Input[str] date: Specifies the date after which you want the corresponding action to take effect.
        :param pulumi.Input[int] days: Specifies the number of days after object creation when the specific rule action takes effect.
        """
        pulumi.set(__self__, "storage_class", storage_class)
        if date is not None:
            pulumi.set(__self__, "date", date)
        if days is not None:
            pulumi.set(__self__, "days", days)

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> pulumi.Input[str]:
        """
        Specifies the Amazon S3 storage class to which you want the object to transition. Can be `ONEZONE_IA`, `STANDARD_IA`, `INTELLIGENT_TIERING`, `GLACIER`, or `DEEP_ARCHIVE`.
        """
        return pulumi.get(self, "storage_class")

    @storage_class.setter
    def storage_class(self, value: pulumi.Input[str]):
        pulumi.set(self, "storage_class", value)

    @property
    @pulumi.getter
    def date(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the date after which you want the corresponding action to take effect.
        """
        return pulumi.get(self, "date")

    @date.setter
    def date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "date", value)

    @property
    @pulumi.getter
    def days(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the number of days after object creation when the specific rule action takes effect.
        """
        return pulumi.get(self, "days")

    @days.setter
    def days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "days", value)


@pulumi.input_type
class BucketLoggingArgs:
    def __init__(__self__, *,
                 target_bucket: pulumi.Input[str],
                 target_prefix: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] target_bucket: The name of the bucket that will receive the log objects.
        :param pulumi.Input[str] target_prefix: To specify a key prefix for log objects.
        """
        pulumi.set(__self__, "target_bucket", target_bucket)
        if target_prefix is not None:
            pulumi.set(__self__, "target_prefix", target_prefix)

    @property
    @pulumi.getter(name="targetBucket")
    def target_bucket(self) -> pulumi.Input[str]:
        """
        The name of the bucket that will receive the log objects.
        """
        return pulumi.get(self, "target_bucket")

    @target_bucket.setter
    def target_bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_bucket", value)

    @property
    @pulumi.getter(name="targetPrefix")
    def target_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        To specify a key prefix for log objects.
        """
        return pulumi.get(self, "target_prefix")

    @target_prefix.setter
    def target_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_prefix", value)


@pulumi.input_type
class BucketMetricFilterArgs:
    def __init__(__self__, *,
                 prefix: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] prefix: Object prefix for filtering (singular).
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Object tags for filtering (up to 10).
        """
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Object prefix for filtering (singular).
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prefix", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Object tags for filtering (up to 10).
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class BucketNotificationLambdaFunctionArgs:
    def __init__(__self__, *,
                 events: pulumi.Input[Sequence[pulumi.Input[str]]],
                 filter_prefix: Optional[pulumi.Input[str]] = None,
                 filter_suffix: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 lambda_function_arn: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] events: Specifies [event](http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html#notification-how-to-event-types-and-destinations) for which to send notifications.
        :param pulumi.Input[str] filter_prefix: Specifies object key name prefix.
        :param pulumi.Input[str] filter_suffix: Specifies object key name suffix.
        :param pulumi.Input[str] id: Specifies unique identifier for each of the notification configurations.
        :param pulumi.Input[str] lambda_function_arn: Specifies Amazon Lambda function ARN.
        """
        pulumi.set(__self__, "events", events)
        if filter_prefix is not None:
            pulumi.set(__self__, "filter_prefix", filter_prefix)
        if filter_suffix is not None:
            pulumi.set(__self__, "filter_suffix", filter_suffix)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if lambda_function_arn is not None:
            pulumi.set(__self__, "lambda_function_arn", lambda_function_arn)

    @property
    @pulumi.getter
    def events(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Specifies [event](http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html#notification-how-to-event-types-and-destinations) for which to send notifications.
        """
        return pulumi.get(self, "events")

    @events.setter
    def events(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "events", value)

    @property
    @pulumi.getter(name="filterPrefix")
    def filter_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies object key name prefix.
        """
        return pulumi.get(self, "filter_prefix")

    @filter_prefix.setter
    def filter_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filter_prefix", value)

    @property
    @pulumi.getter(name="filterSuffix")
    def filter_suffix(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies object key name suffix.
        """
        return pulumi.get(self, "filter_suffix")

    @filter_suffix.setter
    def filter_suffix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filter_suffix", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies unique identifier for each of the notification configurations.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="lambdaFunctionArn")
    def lambda_function_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies Amazon Lambda function ARN.
        """
        return pulumi.get(self, "lambda_function_arn")

    @lambda_function_arn.setter
    def lambda_function_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lambda_function_arn", value)


@pulumi.input_type
class BucketNotificationQueueArgs:
    def __init__(__self__, *,
                 events: pulumi.Input[Sequence[pulumi.Input[str]]],
                 queue_arn: pulumi.Input[str],
                 filter_prefix: Optional[pulumi.Input[str]] = None,
                 filter_suffix: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] events: Specifies [event](http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html#notification-how-to-event-types-and-destinations) for which to send notifications.
        :param pulumi.Input[str] queue_arn: Specifies Amazon SQS queue ARN.
        :param pulumi.Input[str] filter_prefix: Specifies object key name prefix.
        :param pulumi.Input[str] filter_suffix: Specifies object key name suffix.
        :param pulumi.Input[str] id: Specifies unique identifier for each of the notification configurations.
        """
        pulumi.set(__self__, "events", events)
        pulumi.set(__self__, "queue_arn", queue_arn)
        if filter_prefix is not None:
            pulumi.set(__self__, "filter_prefix", filter_prefix)
        if filter_suffix is not None:
            pulumi.set(__self__, "filter_suffix", filter_suffix)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def events(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Specifies [event](http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html#notification-how-to-event-types-and-destinations) for which to send notifications.
        """
        return pulumi.get(self, "events")

    @events.setter
    def events(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "events", value)

    @property
    @pulumi.getter(name="queueArn")
    def queue_arn(self) -> pulumi.Input[str]:
        """
        Specifies Amazon SQS queue ARN.
        """
        return pulumi.get(self, "queue_arn")

    @queue_arn.setter
    def queue_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "queue_arn", value)

    @property
    @pulumi.getter(name="filterPrefix")
    def filter_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies object key name prefix.
        """
        return pulumi.get(self, "filter_prefix")

    @filter_prefix.setter
    def filter_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filter_prefix", value)

    @property
    @pulumi.getter(name="filterSuffix")
    def filter_suffix(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies object key name suffix.
        """
        return pulumi.get(self, "filter_suffix")

    @filter_suffix.setter
    def filter_suffix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filter_suffix", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies unique identifier for each of the notification configurations.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class BucketNotificationTopicArgs:
    def __init__(__self__, *,
                 events: pulumi.Input[Sequence[pulumi.Input[str]]],
                 topic_arn: pulumi.Input[str],
                 filter_prefix: Optional[pulumi.Input[str]] = None,
                 filter_suffix: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] events: Specifies [event](http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html#notification-how-to-event-types-and-destinations) for which to send notifications.
        :param pulumi.Input[str] topic_arn: Specifies Amazon SNS topic ARN.
        :param pulumi.Input[str] filter_prefix: Specifies object key name prefix.
        :param pulumi.Input[str] filter_suffix: Specifies object key name suffix.
        :param pulumi.Input[str] id: Specifies unique identifier for each of the notification configurations.
        """
        pulumi.set(__self__, "events", events)
        pulumi.set(__self__, "topic_arn", topic_arn)
        if filter_prefix is not None:
            pulumi.set(__self__, "filter_prefix", filter_prefix)
        if filter_suffix is not None:
            pulumi.set(__self__, "filter_suffix", filter_suffix)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def events(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Specifies [event](http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html#notification-how-to-event-types-and-destinations) for which to send notifications.
        """
        return pulumi.get(self, "events")

    @events.setter
    def events(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "events", value)

    @property
    @pulumi.getter(name="topicArn")
    def topic_arn(self) -> pulumi.Input[str]:
        """
        Specifies Amazon SNS topic ARN.
        """
        return pulumi.get(self, "topic_arn")

    @topic_arn.setter
    def topic_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "topic_arn", value)

    @property
    @pulumi.getter(name="filterPrefix")
    def filter_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies object key name prefix.
        """
        return pulumi.get(self, "filter_prefix")

    @filter_prefix.setter
    def filter_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filter_prefix", value)

    @property
    @pulumi.getter(name="filterSuffix")
    def filter_suffix(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies object key name suffix.
        """
        return pulumi.get(self, "filter_suffix")

    @filter_suffix.setter
    def filter_suffix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filter_suffix", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies unique identifier for each of the notification configurations.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class BucketObjectLockConfigurationArgs:
    def __init__(__self__, *,
                 object_lock_enabled: pulumi.Input[str],
                 rule: Optional[pulumi.Input['BucketObjectLockConfigurationRuleArgs']] = None):
        """
        :param pulumi.Input[str] object_lock_enabled: Indicates whether this bucket has an Object Lock configuration enabled. Valid value is `Enabled`.
        :param pulumi.Input['BucketObjectLockConfigurationRuleArgs'] rule: The Object Lock rule in place for this bucket.
        """
        pulumi.set(__self__, "object_lock_enabled", object_lock_enabled)
        if rule is not None:
            pulumi.set(__self__, "rule", rule)

    @property
    @pulumi.getter(name="objectLockEnabled")
    def object_lock_enabled(self) -> pulumi.Input[str]:
        """
        Indicates whether this bucket has an Object Lock configuration enabled. Valid value is `Enabled`.
        """
        return pulumi.get(self, "object_lock_enabled")

    @object_lock_enabled.setter
    def object_lock_enabled(self, value: pulumi.Input[str]):
        pulumi.set(self, "object_lock_enabled", value)

    @property
    @pulumi.getter
    def rule(self) -> Optional[pulumi.Input['BucketObjectLockConfigurationRuleArgs']]:
        """
        The Object Lock rule in place for this bucket.
        """
        return pulumi.get(self, "rule")

    @rule.setter
    def rule(self, value: Optional[pulumi.Input['BucketObjectLockConfigurationRuleArgs']]):
        pulumi.set(self, "rule", value)


@pulumi.input_type
class BucketObjectLockConfigurationRuleArgs:
    def __init__(__self__, *,
                 default_retention: pulumi.Input['BucketObjectLockConfigurationRuleDefaultRetentionArgs']):
        """
        :param pulumi.Input['BucketObjectLockConfigurationRuleDefaultRetentionArgs'] default_retention: The default retention period that you want to apply to new objects placed in this bucket.
        """
        pulumi.set(__self__, "default_retention", default_retention)

    @property
    @pulumi.getter(name="defaultRetention")
    def default_retention(self) -> pulumi.Input['BucketObjectLockConfigurationRuleDefaultRetentionArgs']:
        """
        The default retention period that you want to apply to new objects placed in this bucket.
        """
        return pulumi.get(self, "default_retention")

    @default_retention.setter
    def default_retention(self, value: pulumi.Input['BucketObjectLockConfigurationRuleDefaultRetentionArgs']):
        pulumi.set(self, "default_retention", value)


@pulumi.input_type
class BucketObjectLockConfigurationRuleDefaultRetentionArgs:
    def __init__(__self__, *,
                 mode: pulumi.Input[str],
                 days: Optional[pulumi.Input[int]] = None,
                 years: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] mode: The default Object Lock retention mode you want to apply to new objects placed in this bucket. Valid values are `GOVERNANCE` and `COMPLIANCE`.
        :param pulumi.Input[int] days: The number of days that you want to specify for the default retention period.
        :param pulumi.Input[int] years: The number of years that you want to specify for the default retention period.
        """
        pulumi.set(__self__, "mode", mode)
        if days is not None:
            pulumi.set(__self__, "days", days)
        if years is not None:
            pulumi.set(__self__, "years", years)

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Input[str]:
        """
        The default Object Lock retention mode you want to apply to new objects placed in this bucket. Valid values are `GOVERNANCE` and `COMPLIANCE`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: pulumi.Input[str]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def days(self) -> Optional[pulumi.Input[int]]:
        """
        The number of days that you want to specify for the default retention period.
        """
        return pulumi.get(self, "days")

    @days.setter
    def days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "days", value)

    @property
    @pulumi.getter
    def years(self) -> Optional[pulumi.Input[int]]:
        """
        The number of years that you want to specify for the default retention period.
        """
        return pulumi.get(self, "years")

    @years.setter
    def years(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "years", value)


@pulumi.input_type
class BucketOwnershipControlsRuleArgs:
    def __init__(__self__, *,
                 object_ownership: pulumi.Input[str]):
        """
        :param pulumi.Input[str] object_ownership: Object ownership. Valid values: `BucketOwnerPreferred` or `ObjectWriter`
        """
        pulumi.set(__self__, "object_ownership", object_ownership)

    @property
    @pulumi.getter(name="objectOwnership")
    def object_ownership(self) -> pulumi.Input[str]:
        """
        Object ownership. Valid values: `BucketOwnerPreferred` or `ObjectWriter`
        """
        return pulumi.get(self, "object_ownership")

    @object_ownership.setter
    def object_ownership(self, value: pulumi.Input[str]):
        pulumi.set(self, "object_ownership", value)


@pulumi.input_type
class BucketReplicationConfigurationArgs:
    def __init__(__self__, *,
                 role: pulumi.Input[str],
                 rules: pulumi.Input[Sequence[pulumi.Input['BucketReplicationConfigurationRuleArgs']]]):
        """
        :param pulumi.Input[str] role: The ARN of the IAM role for Amazon S3 to assume when replicating the objects.
        :param pulumi.Input[Sequence[pulumi.Input['BucketReplicationConfigurationRuleArgs']]] rules: Specifies the rules managing the replication (documented below).
        """
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def role(self) -> pulumi.Input[str]:
        """
        The ARN of the IAM role for Amazon S3 to assume when replicating the objects.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: pulumi.Input[str]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Input[Sequence[pulumi.Input['BucketReplicationConfigurationRuleArgs']]]:
        """
        Specifies the rules managing the replication (documented below).
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: pulumi.Input[Sequence[pulumi.Input['BucketReplicationConfigurationRuleArgs']]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class BucketReplicationConfigurationRuleArgs:
    def __init__(__self__, *,
                 destination: pulumi.Input['BucketReplicationConfigurationRuleDestinationArgs'],
                 status: pulumi.Input[str],
                 delete_marker_replication_status: Optional[pulumi.Input[str]] = None,
                 filter: Optional[pulumi.Input['BucketReplicationConfigurationRuleFilterArgs']] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 prefix: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 source_selection_criteria: Optional[pulumi.Input['BucketReplicationConfigurationRuleSourceSelectionCriteriaArgs']] = None):
        """
        :param pulumi.Input['BucketReplicationConfigurationRuleDestinationArgs'] destination: Specifies the destination for the rule (documented below).
        :param pulumi.Input[str] status: The status of the rule. Either `Enabled` or `Disabled`. The rule is ignored if status is not Enabled.
        :param pulumi.Input[str] delete_marker_replication_status: Whether delete markers are replicated. The only valid value is `Enabled`. To disable, omit this argument. This argument is only valid with V2 replication configurations (i.e., when `filter` is used).
        :param pulumi.Input['BucketReplicationConfigurationRuleFilterArgs'] filter: Filter that identifies subset of objects to which the replication rule applies (documented below).
        :param pulumi.Input[str] id: Unique identifier for the rule. Must be less than or equal to 255 characters in length.
        :param pulumi.Input[str] prefix: Object keyname prefix identifying one or more objects to which the rule applies. Must be less than or equal to 1024 characters in length.
        :param pulumi.Input[int] priority: The priority associated with the rule. Priority should only be set if `filter` is configured. If not provided, defaults to `0`. Priority must be unique between multiple rules.
        :param pulumi.Input['BucketReplicationConfigurationRuleSourceSelectionCriteriaArgs'] source_selection_criteria: Specifies special object selection criteria (documented below).
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "status", status)
        if delete_marker_replication_status is not None:
            pulumi.set(__self__, "delete_marker_replication_status", delete_marker_replication_status)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if source_selection_criteria is not None:
            pulumi.set(__self__, "source_selection_criteria", source_selection_criteria)

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Input['BucketReplicationConfigurationRuleDestinationArgs']:
        """
        Specifies the destination for the rule (documented below).
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input['BucketReplicationConfigurationRuleDestinationArgs']):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Input[str]:
        """
        The status of the rule. Either `Enabled` or `Disabled`. The rule is ignored if status is not Enabled.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[str]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="deleteMarkerReplicationStatus")
    def delete_marker_replication_status(self) -> Optional[pulumi.Input[str]]:
        """
        Whether delete markers are replicated. The only valid value is `Enabled`. To disable, omit this argument. This argument is only valid with V2 replication configurations (i.e., when `filter` is used).
        """
        return pulumi.get(self, "delete_marker_replication_status")

    @delete_marker_replication_status.setter
    def delete_marker_replication_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delete_marker_replication_status", value)

    @property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input['BucketReplicationConfigurationRuleFilterArgs']]:
        """
        Filter that identifies subset of objects to which the replication rule applies (documented below).
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input['BucketReplicationConfigurationRuleFilterArgs']]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier for the rule. Must be less than or equal to 255 characters in length.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Object keyname prefix identifying one or more objects to which the rule applies. Must be less than or equal to 1024 characters in length.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prefix", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        The priority associated with the rule. Priority should only be set if `filter` is configured. If not provided, defaults to `0`. Priority must be unique between multiple rules.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="sourceSelectionCriteria")
    def source_selection_criteria(self) -> Optional[pulumi.Input['BucketReplicationConfigurationRuleSourceSelectionCriteriaArgs']]:
        """
        Specifies special object selection criteria (documented below).
        """
        return pulumi.get(self, "source_selection_criteria")

    @source_selection_criteria.setter
    def source_selection_criteria(self, value: Optional[pulumi.Input['BucketReplicationConfigurationRuleSourceSelectionCriteriaArgs']]):
        pulumi.set(self, "source_selection_criteria", value)


@pulumi.input_type
class BucketReplicationConfigurationRuleDestinationArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[str],
                 access_control_translation: Optional[pulumi.Input['BucketReplicationConfigurationRuleDestinationAccessControlTranslationArgs']] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 replica_kms_key_id: Optional[pulumi.Input[str]] = None,
                 storage_class: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] bucket: The ARN of the S3 bucket where you want Amazon S3 to store replicas of the object identified by the rule.
        :param pulumi.Input['BucketReplicationConfigurationRuleDestinationAccessControlTranslationArgs'] access_control_translation: Specifies the overrides to use for object owners on replication. Must be used in conjunction with `account_id` owner override configuration.
        :param pulumi.Input[str] account_id: The Account ID to use for overriding the object owner on replication. Must be used in conjunction with `access_control_translation` override configuration.
        :param pulumi.Input[str] replica_kms_key_id: Destination KMS encryption key ARN for SSE-KMS replication. Must be used in conjunction with
               `sse_kms_encrypted_objects` source selection criteria.
        :param pulumi.Input[str] storage_class: The class of storage used to store the object. Can be `STANDARD`, `REDUCED_REDUNDANCY`, `STANDARD_IA`, `ONEZONE_IA`, `INTELLIGENT_TIERING`, `GLACIER`, or `DEEP_ARCHIVE`.
        """
        pulumi.set(__self__, "bucket", bucket)
        if access_control_translation is not None:
            pulumi.set(__self__, "access_control_translation", access_control_translation)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if replica_kms_key_id is not None:
            pulumi.set(__self__, "replica_kms_key_id", replica_kms_key_id)
        if storage_class is not None:
            pulumi.set(__self__, "storage_class", storage_class)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        """
        The ARN of the S3 bucket where you want Amazon S3 to store replicas of the object identified by the rule.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="accessControlTranslation")
    def access_control_translation(self) -> Optional[pulumi.Input['BucketReplicationConfigurationRuleDestinationAccessControlTranslationArgs']]:
        """
        Specifies the overrides to use for object owners on replication. Must be used in conjunction with `account_id` owner override configuration.
        """
        return pulumi.get(self, "access_control_translation")

    @access_control_translation.setter
    def access_control_translation(self, value: Optional[pulumi.Input['BucketReplicationConfigurationRuleDestinationAccessControlTranslationArgs']]):
        pulumi.set(self, "access_control_translation", value)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Account ID to use for overriding the object owner on replication. Must be used in conjunction with `access_control_translation` override configuration.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="replicaKmsKeyId")
    def replica_kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        Destination KMS encryption key ARN for SSE-KMS replication. Must be used in conjunction with
        `sse_kms_encrypted_objects` source selection criteria.
        """
        return pulumi.get(self, "replica_kms_key_id")

    @replica_kms_key_id.setter
    def replica_kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replica_kms_key_id", value)

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> Optional[pulumi.Input[str]]:
        """
        The class of storage used to store the object. Can be `STANDARD`, `REDUCED_REDUNDANCY`, `STANDARD_IA`, `ONEZONE_IA`, `INTELLIGENT_TIERING`, `GLACIER`, or `DEEP_ARCHIVE`.
        """
        return pulumi.get(self, "storage_class")

    @storage_class.setter
    def storage_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_class", value)


@pulumi.input_type
class BucketReplicationConfigurationRuleDestinationAccessControlTranslationArgs:
    def __init__(__self__, *,
                 owner: pulumi.Input[str]):
        """
        :param pulumi.Input[str] owner: The override value for the owner on replicated objects. Currently only `Destination` is supported.
        """
        pulumi.set(__self__, "owner", owner)

    @property
    @pulumi.getter
    def owner(self) -> pulumi.Input[str]:
        """
        The override value for the owner on replicated objects. Currently only `Destination` is supported.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: pulumi.Input[str]):
        pulumi.set(self, "owner", value)


@pulumi.input_type
class BucketReplicationConfigurationRuleFilterArgs:
    def __init__(__self__, *,
                 prefix: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] prefix: Object keyname prefix that identifies subset of objects to which the rule applies. Must be less than or equal to 1024 characters in length.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags that identifies subset of objects to which the rule applies.
               The rule applies only to objects having all the tags in its tagset.
        """
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Object keyname prefix that identifies subset of objects to which the rule applies. Must be less than or equal to 1024 characters in length.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prefix", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags that identifies subset of objects to which the rule applies.
        The rule applies only to objects having all the tags in its tagset.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class BucketReplicationConfigurationRuleSourceSelectionCriteriaArgs:
    def __init__(__self__, *,
                 sse_kms_encrypted_objects: Optional[pulumi.Input['BucketReplicationConfigurationRuleSourceSelectionCriteriaSseKmsEncryptedObjectsArgs']] = None):
        """
        :param pulumi.Input['BucketReplicationConfigurationRuleSourceSelectionCriteriaSseKmsEncryptedObjectsArgs'] sse_kms_encrypted_objects: Match SSE-KMS encrypted objects (documented below). If specified, `replica_kms_key_id`
               in `destination` must be specified as well.
        """
        if sse_kms_encrypted_objects is not None:
            pulumi.set(__self__, "sse_kms_encrypted_objects", sse_kms_encrypted_objects)

    @property
    @pulumi.getter(name="sseKmsEncryptedObjects")
    def sse_kms_encrypted_objects(self) -> Optional[pulumi.Input['BucketReplicationConfigurationRuleSourceSelectionCriteriaSseKmsEncryptedObjectsArgs']]:
        """
        Match SSE-KMS encrypted objects (documented below). If specified, `replica_kms_key_id`
        in `destination` must be specified as well.
        """
        return pulumi.get(self, "sse_kms_encrypted_objects")

    @sse_kms_encrypted_objects.setter
    def sse_kms_encrypted_objects(self, value: Optional[pulumi.Input['BucketReplicationConfigurationRuleSourceSelectionCriteriaSseKmsEncryptedObjectsArgs']]):
        pulumi.set(self, "sse_kms_encrypted_objects", value)


@pulumi.input_type
class BucketReplicationConfigurationRuleSourceSelectionCriteriaSseKmsEncryptedObjectsArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool]):
        """
        :param pulumi.Input[bool] enabled: Boolean which indicates if this criteria is enabled.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Boolean which indicates if this criteria is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class BucketServerSideEncryptionConfigurationArgs:
    def __init__(__self__, *,
                 rule: pulumi.Input['BucketServerSideEncryptionConfigurationRuleArgs']):
        """
        :param pulumi.Input['BucketServerSideEncryptionConfigurationRuleArgs'] rule: A single object for server-side encryption by default configuration. (documented below)
        """
        pulumi.set(__self__, "rule", rule)

    @property
    @pulumi.getter
    def rule(self) -> pulumi.Input['BucketServerSideEncryptionConfigurationRuleArgs']:
        """
        A single object for server-side encryption by default configuration. (documented below)
        """
        return pulumi.get(self, "rule")

    @rule.setter
    def rule(self, value: pulumi.Input['BucketServerSideEncryptionConfigurationRuleArgs']):
        pulumi.set(self, "rule", value)


@pulumi.input_type
class BucketServerSideEncryptionConfigurationRuleArgs:
    def __init__(__self__, *,
                 apply_server_side_encryption_by_default: pulumi.Input['BucketServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefaultArgs'],
                 bucket_key_enabled: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input['BucketServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefaultArgs'] apply_server_side_encryption_by_default: A single object for setting server-side encryption by default. (documented below)
        :param pulumi.Input[bool] bucket_key_enabled: Whether or not to use [Amazon S3 Bucket Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html) for SSE-KMS.
        """
        pulumi.set(__self__, "apply_server_side_encryption_by_default", apply_server_side_encryption_by_default)
        if bucket_key_enabled is not None:
            pulumi.set(__self__, "bucket_key_enabled", bucket_key_enabled)

    @property
    @pulumi.getter(name="applyServerSideEncryptionByDefault")
    def apply_server_side_encryption_by_default(self) -> pulumi.Input['BucketServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefaultArgs']:
        """
        A single object for setting server-side encryption by default. (documented below)
        """
        return pulumi.get(self, "apply_server_side_encryption_by_default")

    @apply_server_side_encryption_by_default.setter
    def apply_server_side_encryption_by_default(self, value: pulumi.Input['BucketServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefaultArgs']):
        pulumi.set(self, "apply_server_side_encryption_by_default", value)

    @property
    @pulumi.getter(name="bucketKeyEnabled")
    def bucket_key_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to use [Amazon S3 Bucket Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html) for SSE-KMS.
        """
        return pulumi.get(self, "bucket_key_enabled")

    @bucket_key_enabled.setter
    def bucket_key_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "bucket_key_enabled", value)


@pulumi.input_type
class BucketServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefaultArgs:
    def __init__(__self__, *,
                 sse_algorithm: pulumi.Input[str],
                 kms_master_key_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] sse_algorithm: The server-side encryption algorithm to use. Valid values are `AES256` and `aws:kms`
        :param pulumi.Input[str] kms_master_key_id: The AWS KMS master key ID used for the SSE-KMS encryption. This can only be used when you set the value of `sse_algorithm` as `aws:kms`. The default `aws/s3` AWS KMS master key is used if this element is absent while the `sse_algorithm` is `aws:kms`.
        """
        pulumi.set(__self__, "sse_algorithm", sse_algorithm)
        if kms_master_key_id is not None:
            pulumi.set(__self__, "kms_master_key_id", kms_master_key_id)

    @property
    @pulumi.getter(name="sseAlgorithm")
    def sse_algorithm(self) -> pulumi.Input[str]:
        """
        The server-side encryption algorithm to use. Valid values are `AES256` and `aws:kms`
        """
        return pulumi.get(self, "sse_algorithm")

    @sse_algorithm.setter
    def sse_algorithm(self, value: pulumi.Input[str]):
        pulumi.set(self, "sse_algorithm", value)

    @property
    @pulumi.getter(name="kmsMasterKeyId")
    def kms_master_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS KMS master key ID used for the SSE-KMS encryption. This can only be used when you set the value of `sse_algorithm` as `aws:kms`. The default `aws/s3` AWS KMS master key is used if this element is absent while the `sse_algorithm` is `aws:kms`.
        """
        return pulumi.get(self, "kms_master_key_id")

    @kms_master_key_id.setter
    def kms_master_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_master_key_id", value)


@pulumi.input_type
class BucketVersioningArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 mfa_delete: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] enabled: Enable versioning. Once you version-enable a bucket, it can never return to an unversioned state. You can, however, suspend versioning on that bucket.
        :param pulumi.Input[bool] mfa_delete: Enable MFA delete for either `Change the versioning state of your bucket` or `Permanently delete an object version`. Default is `false`. This cannot be used to toggle this setting but is available to allow managed buckets to reflect the state in AWS
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if mfa_delete is not None:
            pulumi.set(__self__, "mfa_delete", mfa_delete)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable versioning. Once you version-enable a bucket, it can never return to an unversioned state. You can, however, suspend versioning on that bucket.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="mfaDelete")
    def mfa_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable MFA delete for either `Change the versioning state of your bucket` or `Permanently delete an object version`. Default is `false`. This cannot be used to toggle this setting but is available to allow managed buckets to reflect the state in AWS
        """
        return pulumi.get(self, "mfa_delete")

    @mfa_delete.setter
    def mfa_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "mfa_delete", value)


@pulumi.input_type
class BucketWebsiteArgs:
    def __init__(__self__, *,
                 error_document: Optional[pulumi.Input[str]] = None,
                 index_document: Optional[pulumi.Input[str]] = None,
                 redirect_all_requests_to: Optional[pulumi.Input[str]] = None,
                 routing_rules: Optional[pulumi.Input[Union[str, Sequence[pulumi.Input[str]]]]] = None):
        """
        :param pulumi.Input[str] error_document: An absolute path to the document to return in case of a 4XX error.
        :param pulumi.Input[str] index_document: Amazon S3 returns this index document when requests are made to the root domain or any of the subfolders.
        :param pulumi.Input[str] redirect_all_requests_to: A hostname to redirect all website requests for this bucket to. Hostname can optionally be prefixed with a protocol (`http://` or `https://`) to use when redirecting requests. The default is the protocol that is used in the original request.
        :param pulumi.Input[Union[str, Sequence[pulumi.Input[str]]]] routing_rules: A json array containing [routing rules](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html)
               describing redirect behavior and when redirects are applied.
        """
        if error_document is not None:
            pulumi.set(__self__, "error_document", error_document)
        if index_document is not None:
            pulumi.set(__self__, "index_document", index_document)
        if redirect_all_requests_to is not None:
            pulumi.set(__self__, "redirect_all_requests_to", redirect_all_requests_to)
        if routing_rules is not None:
            pulumi.set(__self__, "routing_rules", routing_rules)

    @property
    @pulumi.getter(name="errorDocument")
    def error_document(self) -> Optional[pulumi.Input[str]]:
        """
        An absolute path to the document to return in case of a 4XX error.
        """
        return pulumi.get(self, "error_document")

    @error_document.setter
    def error_document(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "error_document", value)

    @property
    @pulumi.getter(name="indexDocument")
    def index_document(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon S3 returns this index document when requests are made to the root domain or any of the subfolders.
        """
        return pulumi.get(self, "index_document")

    @index_document.setter
    def index_document(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "index_document", value)

    @property
    @pulumi.getter(name="redirectAllRequestsTo")
    def redirect_all_requests_to(self) -> Optional[pulumi.Input[str]]:
        """
        A hostname to redirect all website requests for this bucket to. Hostname can optionally be prefixed with a protocol (`http://` or `https://`) to use when redirecting requests. The default is the protocol that is used in the original request.
        """
        return pulumi.get(self, "redirect_all_requests_to")

    @redirect_all_requests_to.setter
    def redirect_all_requests_to(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "redirect_all_requests_to", value)

    @property
    @pulumi.getter(name="routingRules")
    def routing_rules(self) -> Optional[pulumi.Input[Union[str, Sequence[pulumi.Input[str]]]]]:
        """
        A json array containing [routing rules](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html)
        describing redirect behavior and when redirects are applied.
        """
        return pulumi.get(self, "routing_rules")

    @routing_rules.setter
    def routing_rules(self, value: Optional[pulumi.Input[Union[str, Sequence[pulumi.Input[str]]]]]):
        pulumi.set(self, "routing_rules", value)


@pulumi.input_type
class InventoryDestinationArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input['InventoryDestinationBucketArgs']):
        """
        :param pulumi.Input['InventoryDestinationBucketArgs'] bucket: The S3 bucket configuration where inventory results are published (documented below).
        """
        pulumi.set(__self__, "bucket", bucket)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input['InventoryDestinationBucketArgs']:
        """
        The S3 bucket configuration where inventory results are published (documented below).
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input['InventoryDestinationBucketArgs']):
        pulumi.set(self, "bucket", value)


@pulumi.input_type
class InventoryDestinationBucketArgs:
    def __init__(__self__, *,
                 bucket_arn: pulumi.Input[str],
                 format: pulumi.Input[str],
                 account_id: Optional[pulumi.Input[str]] = None,
                 encryption: Optional[pulumi.Input['InventoryDestinationBucketEncryptionArgs']] = None,
                 prefix: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] bucket_arn: The Amazon S3 bucket ARN of the destination.
        :param pulumi.Input[str] format: Specifies the output format of the inventory results. Can be `CSV`, [`ORC`](https://orc.apache.org/) or [`Parquet`](https://parquet.apache.org/).
        :param pulumi.Input[str] account_id: The ID of the account that owns the destination bucket. Recommended to be set to prevent problems if the destination bucket ownership changes.
        :param pulumi.Input['InventoryDestinationBucketEncryptionArgs'] encryption: Contains the type of server-side encryption to use to encrypt the inventory (documented below).
        :param pulumi.Input[str] prefix: The prefix that is prepended to all inventory results.
        """
        pulumi.set(__self__, "bucket_arn", bucket_arn)
        pulumi.set(__self__, "format", format)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter(name="bucketArn")
    def bucket_arn(self) -> pulumi.Input[str]:
        """
        The Amazon S3 bucket ARN of the destination.
        """
        return pulumi.get(self, "bucket_arn")

    @bucket_arn.setter
    def bucket_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket_arn", value)

    @property
    @pulumi.getter
    def format(self) -> pulumi.Input[str]:
        """
        Specifies the output format of the inventory results. Can be `CSV`, [`ORC`](https://orc.apache.org/) or [`Parquet`](https://parquet.apache.org/).
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: pulumi.Input[str]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the account that owns the destination bucket. Recommended to be set to prevent problems if the destination bucket ownership changes.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input['InventoryDestinationBucketEncryptionArgs']]:
        """
        Contains the type of server-side encryption to use to encrypt the inventory (documented below).
        """
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input['InventoryDestinationBucketEncryptionArgs']]):
        pulumi.set(self, "encryption", value)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The prefix that is prepended to all inventory results.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prefix", value)


@pulumi.input_type
class InventoryDestinationBucketEncryptionArgs:
    def __init__(__self__, *,
                 sse_kms: Optional[pulumi.Input['InventoryDestinationBucketEncryptionSseKmsArgs']] = None,
                 sse_s3: Optional[pulumi.Input['InventoryDestinationBucketEncryptionSseS3Args']] = None):
        """
        :param pulumi.Input['InventoryDestinationBucketEncryptionSseKmsArgs'] sse_kms: Specifies to use server-side encryption with AWS KMS-managed keys to encrypt the inventory file (documented below).
        :param pulumi.Input['InventoryDestinationBucketEncryptionSseS3Args'] sse_s3: Specifies to use server-side encryption with Amazon S3-managed keys (SSE-S3) to encrypt the inventory file.
        """
        if sse_kms is not None:
            pulumi.set(__self__, "sse_kms", sse_kms)
        if sse_s3 is not None:
            pulumi.set(__self__, "sse_s3", sse_s3)

    @property
    @pulumi.getter(name="sseKms")
    def sse_kms(self) -> Optional[pulumi.Input['InventoryDestinationBucketEncryptionSseKmsArgs']]:
        """
        Specifies to use server-side encryption with AWS KMS-managed keys to encrypt the inventory file (documented below).
        """
        return pulumi.get(self, "sse_kms")

    @sse_kms.setter
    def sse_kms(self, value: Optional[pulumi.Input['InventoryDestinationBucketEncryptionSseKmsArgs']]):
        pulumi.set(self, "sse_kms", value)

    @property
    @pulumi.getter(name="sseS3")
    def sse_s3(self) -> Optional[pulumi.Input['InventoryDestinationBucketEncryptionSseS3Args']]:
        """
        Specifies to use server-side encryption with Amazon S3-managed keys (SSE-S3) to encrypt the inventory file.
        """
        return pulumi.get(self, "sse_s3")

    @sse_s3.setter
    def sse_s3(self, value: Optional[pulumi.Input['InventoryDestinationBucketEncryptionSseS3Args']]):
        pulumi.set(self, "sse_s3", value)


@pulumi.input_type
class InventoryDestinationBucketEncryptionSseKmsArgs:
    def __init__(__self__, *,
                 key_id: pulumi.Input[str]):
        """
        :param pulumi.Input[str] key_id: The ARN of the KMS customer master key (CMK) used to encrypt the inventory file.
        """
        pulumi.set(__self__, "key_id", key_id)

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> pulumi.Input[str]:
        """
        The ARN of the KMS customer master key (CMK) used to encrypt the inventory file.
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_id", value)


@pulumi.input_type
class InventoryDestinationBucketEncryptionSseS3Args:
    def __init__(__self__):
        pass


@pulumi.input_type
class InventoryFilterArgs:
    def __init__(__self__, *,
                 prefix: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] prefix: The prefix that an object must have to be included in the inventory results.
        """
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The prefix that an object must have to be included in the inventory results.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prefix", value)


@pulumi.input_type
class InventoryScheduleArgs:
    def __init__(__self__, *,
                 frequency: pulumi.Input[str]):
        """
        :param pulumi.Input[str] frequency: Specifies how frequently inventory results are produced. Valid values: `Daily`, `Weekly`.
        """
        pulumi.set(__self__, "frequency", frequency)

    @property
    @pulumi.getter
    def frequency(self) -> pulumi.Input[str]:
        """
        Specifies how frequently inventory results are produced. Valid values: `Daily`, `Weekly`.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: pulumi.Input[str]):
        pulumi.set(self, "frequency", value)


@pulumi.input_type
class ObjectCopyGrantArgs:
    def __init__(__self__, *,
                 permissions: pulumi.Input[Sequence[pulumi.Input[str]]],
                 type: pulumi.Input[str],
                 email: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 uri: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] permissions: List of permissions to grant to grantee. Valid values are `READ`, `READ_ACP`, `WRITE_ACP`, `FULL_CONTROL`.
        :param pulumi.Input[str] type: - Type of grantee. Valid values are `CanonicalUser`, `Group`, and `AmazonCustomerByEmail`.
        :param pulumi.Input[str] email: Email address of the grantee. Used only when `type` is `AmazonCustomerByEmail`.
        :param pulumi.Input[str] id: The canonical user ID of the grantee. Used only when `type` is `CanonicalUser`.
        :param pulumi.Input[str] uri: URI of the grantee group. Used only when `type` is `Group`.
        """
        pulumi.set(__self__, "permissions", permissions)
        pulumi.set(__self__, "type", type)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def permissions(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of permissions to grant to grantee. Valid values are `READ`, `READ_ACP`, `WRITE_ACP`, `FULL_CONTROL`.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "permissions", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        - Type of grantee. Valid values are `CanonicalUser`, `Group`, and `AmazonCustomerByEmail`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        Email address of the grantee. Used only when `type` is `AmazonCustomerByEmail`.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The canonical user ID of the grantee. Used only when `type` is `CanonicalUser`.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        """
        URI of the grantee group. Used only when `type` is `Group`.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)


