# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetOrderableDbInstanceResult',
    'AwaitableGetOrderableDbInstanceResult',
    'get_orderable_db_instance',
]

@pulumi.output_type
class GetOrderableDbInstanceResult:
    """
    A collection of values returned by getOrderableDbInstance.
    """
    def __init__(__self__, availability_zone_group=None, availability_zones=None, engine=None, engine_version=None, id=None, instance_class=None, license_model=None, max_iops_per_db_instance=None, max_iops_per_gib=None, max_storage_size=None, min_iops_per_db_instance=None, min_iops_per_gib=None, min_storage_size=None, multi_az_capable=None, outpost_capable=None, preferred_engine_versions=None, preferred_instance_classes=None, read_replica_capable=None, storage_type=None, supported_engine_modes=None, supports_enhanced_monitoring=None, supports_global_databases=None, supports_iam_database_authentication=None, supports_iops=None, supports_kerberos_authentication=None, supports_performance_insights=None, supports_storage_autoscaling=None, supports_storage_encryption=None, vpc=None):
        if availability_zone_group and not isinstance(availability_zone_group, str):
            raise TypeError("Expected argument 'availability_zone_group' to be a str")
        pulumi.set(__self__, "availability_zone_group", availability_zone_group)
        if availability_zones and not isinstance(availability_zones, list):
            raise TypeError("Expected argument 'availability_zones' to be a list")
        pulumi.set(__self__, "availability_zones", availability_zones)
        if engine and not isinstance(engine, str):
            raise TypeError("Expected argument 'engine' to be a str")
        pulumi.set(__self__, "engine", engine)
        if engine_version and not isinstance(engine_version, str):
            raise TypeError("Expected argument 'engine_version' to be a str")
        pulumi.set(__self__, "engine_version", engine_version)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_class and not isinstance(instance_class, str):
            raise TypeError("Expected argument 'instance_class' to be a str")
        pulumi.set(__self__, "instance_class", instance_class)
        if license_model and not isinstance(license_model, str):
            raise TypeError("Expected argument 'license_model' to be a str")
        pulumi.set(__self__, "license_model", license_model)
        if max_iops_per_db_instance and not isinstance(max_iops_per_db_instance, int):
            raise TypeError("Expected argument 'max_iops_per_db_instance' to be a int")
        pulumi.set(__self__, "max_iops_per_db_instance", max_iops_per_db_instance)
        if max_iops_per_gib and not isinstance(max_iops_per_gib, float):
            raise TypeError("Expected argument 'max_iops_per_gib' to be a float")
        pulumi.set(__self__, "max_iops_per_gib", max_iops_per_gib)
        if max_storage_size and not isinstance(max_storage_size, int):
            raise TypeError("Expected argument 'max_storage_size' to be a int")
        pulumi.set(__self__, "max_storage_size", max_storage_size)
        if min_iops_per_db_instance and not isinstance(min_iops_per_db_instance, int):
            raise TypeError("Expected argument 'min_iops_per_db_instance' to be a int")
        pulumi.set(__self__, "min_iops_per_db_instance", min_iops_per_db_instance)
        if min_iops_per_gib and not isinstance(min_iops_per_gib, float):
            raise TypeError("Expected argument 'min_iops_per_gib' to be a float")
        pulumi.set(__self__, "min_iops_per_gib", min_iops_per_gib)
        if min_storage_size and not isinstance(min_storage_size, int):
            raise TypeError("Expected argument 'min_storage_size' to be a int")
        pulumi.set(__self__, "min_storage_size", min_storage_size)
        if multi_az_capable and not isinstance(multi_az_capable, bool):
            raise TypeError("Expected argument 'multi_az_capable' to be a bool")
        pulumi.set(__self__, "multi_az_capable", multi_az_capable)
        if outpost_capable and not isinstance(outpost_capable, bool):
            raise TypeError("Expected argument 'outpost_capable' to be a bool")
        pulumi.set(__self__, "outpost_capable", outpost_capable)
        if preferred_engine_versions and not isinstance(preferred_engine_versions, list):
            raise TypeError("Expected argument 'preferred_engine_versions' to be a list")
        pulumi.set(__self__, "preferred_engine_versions", preferred_engine_versions)
        if preferred_instance_classes and not isinstance(preferred_instance_classes, list):
            raise TypeError("Expected argument 'preferred_instance_classes' to be a list")
        pulumi.set(__self__, "preferred_instance_classes", preferred_instance_classes)
        if read_replica_capable and not isinstance(read_replica_capable, bool):
            raise TypeError("Expected argument 'read_replica_capable' to be a bool")
        pulumi.set(__self__, "read_replica_capable", read_replica_capable)
        if storage_type and not isinstance(storage_type, str):
            raise TypeError("Expected argument 'storage_type' to be a str")
        pulumi.set(__self__, "storage_type", storage_type)
        if supported_engine_modes and not isinstance(supported_engine_modes, list):
            raise TypeError("Expected argument 'supported_engine_modes' to be a list")
        pulumi.set(__self__, "supported_engine_modes", supported_engine_modes)
        if supports_enhanced_monitoring and not isinstance(supports_enhanced_monitoring, bool):
            raise TypeError("Expected argument 'supports_enhanced_monitoring' to be a bool")
        pulumi.set(__self__, "supports_enhanced_monitoring", supports_enhanced_monitoring)
        if supports_global_databases and not isinstance(supports_global_databases, bool):
            raise TypeError("Expected argument 'supports_global_databases' to be a bool")
        pulumi.set(__self__, "supports_global_databases", supports_global_databases)
        if supports_iam_database_authentication and not isinstance(supports_iam_database_authentication, bool):
            raise TypeError("Expected argument 'supports_iam_database_authentication' to be a bool")
        pulumi.set(__self__, "supports_iam_database_authentication", supports_iam_database_authentication)
        if supports_iops and not isinstance(supports_iops, bool):
            raise TypeError("Expected argument 'supports_iops' to be a bool")
        pulumi.set(__self__, "supports_iops", supports_iops)
        if supports_kerberos_authentication and not isinstance(supports_kerberos_authentication, bool):
            raise TypeError("Expected argument 'supports_kerberos_authentication' to be a bool")
        pulumi.set(__self__, "supports_kerberos_authentication", supports_kerberos_authentication)
        if supports_performance_insights and not isinstance(supports_performance_insights, bool):
            raise TypeError("Expected argument 'supports_performance_insights' to be a bool")
        pulumi.set(__self__, "supports_performance_insights", supports_performance_insights)
        if supports_storage_autoscaling and not isinstance(supports_storage_autoscaling, bool):
            raise TypeError("Expected argument 'supports_storage_autoscaling' to be a bool")
        pulumi.set(__self__, "supports_storage_autoscaling", supports_storage_autoscaling)
        if supports_storage_encryption and not isinstance(supports_storage_encryption, bool):
            raise TypeError("Expected argument 'supports_storage_encryption' to be a bool")
        pulumi.set(__self__, "supports_storage_encryption", supports_storage_encryption)
        if vpc and not isinstance(vpc, bool):
            raise TypeError("Expected argument 'vpc' to be a bool")
        pulumi.set(__self__, "vpc", vpc)

    @property
    @pulumi.getter(name="availabilityZoneGroup")
    def availability_zone_group(self) -> str:
        return pulumi.get(self, "availability_zone_group")

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Sequence[str]:
        """
        Availability zones where the instance is available.
        """
        return pulumi.get(self, "availability_zones")

    @property
    @pulumi.getter
    def engine(self) -> str:
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> str:
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> str:
        return pulumi.get(self, "instance_class")

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> str:
        return pulumi.get(self, "license_model")

    @property
    @pulumi.getter(name="maxIopsPerDbInstance")
    def max_iops_per_db_instance(self) -> int:
        """
        Maximum total provisioned IOPS for a DB instance.
        """
        return pulumi.get(self, "max_iops_per_db_instance")

    @property
    @pulumi.getter(name="maxIopsPerGib")
    def max_iops_per_gib(self) -> float:
        """
        Maximum provisioned IOPS per GiB for a DB instance.
        """
        return pulumi.get(self, "max_iops_per_gib")

    @property
    @pulumi.getter(name="maxStorageSize")
    def max_storage_size(self) -> int:
        """
        Maximum storage size for a DB instance.
        """
        return pulumi.get(self, "max_storage_size")

    @property
    @pulumi.getter(name="minIopsPerDbInstance")
    def min_iops_per_db_instance(self) -> int:
        """
        Minimum total provisioned IOPS for a DB instance.
        """
        return pulumi.get(self, "min_iops_per_db_instance")

    @property
    @pulumi.getter(name="minIopsPerGib")
    def min_iops_per_gib(self) -> float:
        """
        Minimum provisioned IOPS per GiB for a DB instance.
        """
        return pulumi.get(self, "min_iops_per_gib")

    @property
    @pulumi.getter(name="minStorageSize")
    def min_storage_size(self) -> int:
        """
        Minimum storage size for a DB instance.
        """
        return pulumi.get(self, "min_storage_size")

    @property
    @pulumi.getter(name="multiAzCapable")
    def multi_az_capable(self) -> bool:
        """
        Whether a DB instance is Multi-AZ capable.
        """
        return pulumi.get(self, "multi_az_capable")

    @property
    @pulumi.getter(name="outpostCapable")
    def outpost_capable(self) -> bool:
        """
        Whether a DB instance supports RDS on Outposts.
        """
        return pulumi.get(self, "outpost_capable")

    @property
    @pulumi.getter(name="preferredEngineVersions")
    def preferred_engine_versions(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "preferred_engine_versions")

    @property
    @pulumi.getter(name="preferredInstanceClasses")
    def preferred_instance_classes(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "preferred_instance_classes")

    @property
    @pulumi.getter(name="readReplicaCapable")
    def read_replica_capable(self) -> bool:
        """
        Whether a DB instance can have a read replica.
        """
        return pulumi.get(self, "read_replica_capable")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> str:
        return pulumi.get(self, "storage_type")

    @property
    @pulumi.getter(name="supportedEngineModes")
    def supported_engine_modes(self) -> Sequence[str]:
        """
        A list of the supported DB engine modes.
        """
        return pulumi.get(self, "supported_engine_modes")

    @property
    @pulumi.getter(name="supportsEnhancedMonitoring")
    def supports_enhanced_monitoring(self) -> bool:
        return pulumi.get(self, "supports_enhanced_monitoring")

    @property
    @pulumi.getter(name="supportsGlobalDatabases")
    def supports_global_databases(self) -> bool:
        return pulumi.get(self, "supports_global_databases")

    @property
    @pulumi.getter(name="supportsIamDatabaseAuthentication")
    def supports_iam_database_authentication(self) -> bool:
        return pulumi.get(self, "supports_iam_database_authentication")

    @property
    @pulumi.getter(name="supportsIops")
    def supports_iops(self) -> bool:
        return pulumi.get(self, "supports_iops")

    @property
    @pulumi.getter(name="supportsKerberosAuthentication")
    def supports_kerberos_authentication(self) -> bool:
        return pulumi.get(self, "supports_kerberos_authentication")

    @property
    @pulumi.getter(name="supportsPerformanceInsights")
    def supports_performance_insights(self) -> bool:
        return pulumi.get(self, "supports_performance_insights")

    @property
    @pulumi.getter(name="supportsStorageAutoscaling")
    def supports_storage_autoscaling(self) -> bool:
        return pulumi.get(self, "supports_storage_autoscaling")

    @property
    @pulumi.getter(name="supportsStorageEncryption")
    def supports_storage_encryption(self) -> bool:
        return pulumi.get(self, "supports_storage_encryption")

    @property
    @pulumi.getter
    def vpc(self) -> bool:
        return pulumi.get(self, "vpc")


class AwaitableGetOrderableDbInstanceResult(GetOrderableDbInstanceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOrderableDbInstanceResult(
            availability_zone_group=self.availability_zone_group,
            availability_zones=self.availability_zones,
            engine=self.engine,
            engine_version=self.engine_version,
            id=self.id,
            instance_class=self.instance_class,
            license_model=self.license_model,
            max_iops_per_db_instance=self.max_iops_per_db_instance,
            max_iops_per_gib=self.max_iops_per_gib,
            max_storage_size=self.max_storage_size,
            min_iops_per_db_instance=self.min_iops_per_db_instance,
            min_iops_per_gib=self.min_iops_per_gib,
            min_storage_size=self.min_storage_size,
            multi_az_capable=self.multi_az_capable,
            outpost_capable=self.outpost_capable,
            preferred_engine_versions=self.preferred_engine_versions,
            preferred_instance_classes=self.preferred_instance_classes,
            read_replica_capable=self.read_replica_capable,
            storage_type=self.storage_type,
            supported_engine_modes=self.supported_engine_modes,
            supports_enhanced_monitoring=self.supports_enhanced_monitoring,
            supports_global_databases=self.supports_global_databases,
            supports_iam_database_authentication=self.supports_iam_database_authentication,
            supports_iops=self.supports_iops,
            supports_kerberos_authentication=self.supports_kerberos_authentication,
            supports_performance_insights=self.supports_performance_insights,
            supports_storage_autoscaling=self.supports_storage_autoscaling,
            supports_storage_encryption=self.supports_storage_encryption,
            vpc=self.vpc)


def get_orderable_db_instance(availability_zone_group: Optional[str] = None,
                              engine: Optional[str] = None,
                              engine_version: Optional[str] = None,
                              instance_class: Optional[str] = None,
                              license_model: Optional[str] = None,
                              preferred_engine_versions: Optional[Sequence[str]] = None,
                              preferred_instance_classes: Optional[Sequence[str]] = None,
                              storage_type: Optional[str] = None,
                              supports_enhanced_monitoring: Optional[bool] = None,
                              supports_global_databases: Optional[bool] = None,
                              supports_iam_database_authentication: Optional[bool] = None,
                              supports_iops: Optional[bool] = None,
                              supports_kerberos_authentication: Optional[bool] = None,
                              supports_performance_insights: Optional[bool] = None,
                              supports_storage_autoscaling: Optional[bool] = None,
                              supports_storage_encryption: Optional[bool] = None,
                              vpc: Optional[bool] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOrderableDbInstanceResult:
    """
    Information about RDS orderable DB instances and valid parameter combinations.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.rds.get_orderable_db_instance(engine="mysql",
        engine_version="5.7.22",
        license_model="general-public-license",
        preferred_instance_classes=[
            "db.r6.xlarge",
            "db.m4.large",
            "db.t3.small",
        ],
        storage_type="standard")
    ```

    Valid parameter combinations can also be found with `preferred_engine_versions` and/or `preferred_instance_classes`.

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.rds.get_orderable_db_instance(engine="mysql",
        license_model="general-public-license",
        preferred_engine_versions=[
            "5.6.35",
            "5.6.41",
            "5.6.44",
        ],
        preferred_instance_classes=[
            "db.t2.small",
            "db.t3.medium",
            "db.t3.large",
        ])
    ```


    :param str availability_zone_group: Availability zone group.
    :param str engine: DB engine. Engine values include `aurora`, `aurora-mysql`, `aurora-postgresql`, `docdb`, `mariadb`, `mysql`, `neptune`, `oracle-ee`, `oracle-se`, `oracle-se1`, `oracle-se2`, `postgres`, `sqlserver-ee`, `sqlserver-ex`, `sqlserver-se`, and `sqlserver-web`.
    :param str engine_version: Version of the DB engine. If none is provided, the AWS-defined default version will be used.
    :param str instance_class: DB instance class. Examples of classes are `db.m3.2xlarge`, `db.t2.small`, and `db.m3.medium`.
    :param str license_model: License model. Examples of license models are `general-public-license`, `bring-your-own-license`, and `amazon-license`.
    :param Sequence[str] preferred_engine_versions: Ordered list of preferred RDS DB instance engine versions. The first match in this list will be returned. If no preferred matches are found and the original search returned more than one result, an error is returned.
    :param Sequence[str] preferred_instance_classes: Ordered list of preferred RDS DB instance classes. The first match in this list will be returned. If no preferred matches are found and the original search returned more than one result, an error is returned.
    :param str storage_type: Storage types. Examples of storage types are `standard`, `io1`, `gp2`, and `aurora`.
    :param bool supports_enhanced_monitoring: Enable this to ensure a DB instance supports Enhanced Monitoring at intervals from 1 to 60 seconds.
    :param bool supports_global_databases: Enable this to ensure a DB instance supports Aurora global databases with a specific combination of other DB engine attributes.
    :param bool supports_iam_database_authentication: Enable this to ensure a DB instance supports IAM database authentication.
    :param bool supports_iops: Enable this to ensure a DB instance supports provisioned IOPS.
    :param bool supports_kerberos_authentication: Enable this to ensure a DB instance supports Kerberos Authentication.
    :param bool supports_performance_insights: Enable this to ensure a DB instance supports Performance Insights.
    :param bool supports_storage_autoscaling: Enable this to ensure Amazon RDS can automatically scale storage for DB instances that use the specified DB instance class.
    :param bool supports_storage_encryption: Enable this to ensure a DB instance supports encrypted storage.
    :param bool vpc: Boolean that indicates whether to show only VPC or non-VPC offerings.
    """
    __args__ = dict()
    __args__['availabilityZoneGroup'] = availability_zone_group
    __args__['engine'] = engine
    __args__['engineVersion'] = engine_version
    __args__['instanceClass'] = instance_class
    __args__['licenseModel'] = license_model
    __args__['preferredEngineVersions'] = preferred_engine_versions
    __args__['preferredInstanceClasses'] = preferred_instance_classes
    __args__['storageType'] = storage_type
    __args__['supportsEnhancedMonitoring'] = supports_enhanced_monitoring
    __args__['supportsGlobalDatabases'] = supports_global_databases
    __args__['supportsIamDatabaseAuthentication'] = supports_iam_database_authentication
    __args__['supportsIops'] = supports_iops
    __args__['supportsKerberosAuthentication'] = supports_kerberos_authentication
    __args__['supportsPerformanceInsights'] = supports_performance_insights
    __args__['supportsStorageAutoscaling'] = supports_storage_autoscaling
    __args__['supportsStorageEncryption'] = supports_storage_encryption
    __args__['vpc'] = vpc
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws:rds/getOrderableDbInstance:getOrderableDbInstance', __args__, opts=opts, typ=GetOrderableDbInstanceResult).value

    return AwaitableGetOrderableDbInstanceResult(
        availability_zone_group=__ret__.availability_zone_group,
        availability_zones=__ret__.availability_zones,
        engine=__ret__.engine,
        engine_version=__ret__.engine_version,
        id=__ret__.id,
        instance_class=__ret__.instance_class,
        license_model=__ret__.license_model,
        max_iops_per_db_instance=__ret__.max_iops_per_db_instance,
        max_iops_per_gib=__ret__.max_iops_per_gib,
        max_storage_size=__ret__.max_storage_size,
        min_iops_per_db_instance=__ret__.min_iops_per_db_instance,
        min_iops_per_gib=__ret__.min_iops_per_gib,
        min_storage_size=__ret__.min_storage_size,
        multi_az_capable=__ret__.multi_az_capable,
        outpost_capable=__ret__.outpost_capable,
        preferred_engine_versions=__ret__.preferred_engine_versions,
        preferred_instance_classes=__ret__.preferred_instance_classes,
        read_replica_capable=__ret__.read_replica_capable,
        storage_type=__ret__.storage_type,
        supported_engine_modes=__ret__.supported_engine_modes,
        supports_enhanced_monitoring=__ret__.supports_enhanced_monitoring,
        supports_global_databases=__ret__.supports_global_databases,
        supports_iam_database_authentication=__ret__.supports_iam_database_authentication,
        supports_iops=__ret__.supports_iops,
        supports_kerberos_authentication=__ret__.supports_kerberos_authentication,
        supports_performance_insights=__ret__.supports_performance_insights,
        supports_storage_autoscaling=__ret__.supports_storage_autoscaling,
        supports_storage_encryption=__ret__.supports_storage_encryption,
        vpc=__ret__.vpc)
