# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetCertificateResult',
    'AwaitableGetCertificateResult',
    'get_certificate',
]

@pulumi.output_type
class GetCertificateResult:
    """
    A collection of values returned by getCertificate.
    """
    def __init__(__self__, arn=None, certificate_type=None, customer_override=None, customer_override_valid_till=None, id=None, latest_valid_till=None, thumbprint=None, valid_from=None, valid_till=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if certificate_type and not isinstance(certificate_type, str):
            raise TypeError("Expected argument 'certificate_type' to be a str")
        pulumi.set(__self__, "certificate_type", certificate_type)
        if customer_override and not isinstance(customer_override, bool):
            raise TypeError("Expected argument 'customer_override' to be a bool")
        pulumi.set(__self__, "customer_override", customer_override)
        if customer_override_valid_till and not isinstance(customer_override_valid_till, str):
            raise TypeError("Expected argument 'customer_override_valid_till' to be a str")
        pulumi.set(__self__, "customer_override_valid_till", customer_override_valid_till)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if latest_valid_till and not isinstance(latest_valid_till, bool):
            raise TypeError("Expected argument 'latest_valid_till' to be a bool")
        pulumi.set(__self__, "latest_valid_till", latest_valid_till)
        if thumbprint and not isinstance(thumbprint, str):
            raise TypeError("Expected argument 'thumbprint' to be a str")
        pulumi.set(__self__, "thumbprint", thumbprint)
        if valid_from and not isinstance(valid_from, str):
            raise TypeError("Expected argument 'valid_from' to be a str")
        pulumi.set(__self__, "valid_from", valid_from)
        if valid_till and not isinstance(valid_till, str):
            raise TypeError("Expected argument 'valid_till' to be a str")
        pulumi.set(__self__, "valid_till", valid_till)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        Amazon Resource Name (ARN) of the certificate.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="certificateType")
    def certificate_type(self) -> str:
        """
        Type of certificate. For example, `CA`.
        """
        return pulumi.get(self, "certificate_type")

    @property
    @pulumi.getter(name="customerOverride")
    def customer_override(self) -> bool:
        """
        Boolean whether there is an override for the default certificate identifier.
        """
        return pulumi.get(self, "customer_override")

    @property
    @pulumi.getter(name="customerOverrideValidTill")
    def customer_override_valid_till(self) -> str:
        """
        If there is an override for the default certificate identifier, when the override expires.
        """
        return pulumi.get(self, "customer_override_valid_till")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="latestValidTill")
    def latest_valid_till(self) -> Optional[bool]:
        return pulumi.get(self, "latest_valid_till")

    @property
    @pulumi.getter
    def thumbprint(self) -> str:
        """
        Thumbprint of the certificate.
        """
        return pulumi.get(self, "thumbprint")

    @property
    @pulumi.getter(name="validFrom")
    def valid_from(self) -> str:
        """
        [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) of certificate starting validity date.
        """
        return pulumi.get(self, "valid_from")

    @property
    @pulumi.getter(name="validTill")
    def valid_till(self) -> str:
        """
        [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) of certificate ending validity date.
        """
        return pulumi.get(self, "valid_till")


class AwaitableGetCertificateResult(GetCertificateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCertificateResult(
            arn=self.arn,
            certificate_type=self.certificate_type,
            customer_override=self.customer_override,
            customer_override_valid_till=self.customer_override_valid_till,
            id=self.id,
            latest_valid_till=self.latest_valid_till,
            thumbprint=self.thumbprint,
            valid_from=self.valid_from,
            valid_till=self.valid_till)


def get_certificate(id: Optional[str] = None,
                    latest_valid_till: Optional[bool] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCertificateResult:
    """
    Information about an RDS Certificate.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.rds.get_certificate(latest_valid_till=True)
    ```


    :param str id: Certificate identifier. For example, `rds-ca-2019`.
    :param bool latest_valid_till: When enabled, returns the certificate with the latest `ValidTill`.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['latestValidTill'] = latest_valid_till
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws:rds/getCertificate:getCertificate', __args__, opts=opts, typ=GetCertificateResult).value

    return AwaitableGetCertificateResult(
        arn=__ret__.arn,
        certificate_type=__ret__.certificate_type,
        customer_override=__ret__.customer_override,
        customer_override_valid_till=__ret__.customer_override_valid_till,
        id=__ret__.id,
        latest_valid_till=__ret__.latest_valid_till,
        thumbprint=__ret__.thumbprint,
        valid_from=__ret__.valid_from,
        valid_till=__ret__.valid_till)
