# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'ApplicationAppSource',
    'ApplicationEnvironment',
    'ApplicationSslConfiguration',
    'CustomLayerEbsVolume',
    'GangliaLayerEbsVolume',
    'HaproxyLayerEbsVolume',
    'InstanceEbsBlockDevice',
    'InstanceEphemeralBlockDevice',
    'InstanceRootBlockDevice',
    'JavaAppLayerEbsVolume',
    'MemcachedLayerEbsVolume',
    'MysqlLayerEbsVolume',
    'NodejsAppLayerEbsVolume',
    'PhpAppLayerEbsVolume',
    'RailsAppLayerEbsVolume',
    'StackCustomCookbooksSource',
    'StaticWebLayerEbsVolume',
]

@pulumi.output_type
class ApplicationAppSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sshKey":
            suggest = "ssh_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationAppSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationAppSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationAppSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 password: Optional[str] = None,
                 revision: Optional[str] = None,
                 ssh_key: Optional[str] = None,
                 url: Optional[str] = None,
                 username: Optional[str] = None):
        """
        :param str type: The type of source to use. For example, "archive".
        :param str password: Password to use when authenticating to the source. This provider cannot perform drift detection of this configuration.
        :param str revision: For sources that are version-aware, the revision to use.
        :param str ssh_key: SSH key to use when authenticating to the source. This provider cannot perform drift detection of this configuration.
        :param str url: The URL where the app resource can be found.
        :param str username: Username to use when authenticating to the source.
        """
        pulumi.set(__self__, "type", type)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)
        if ssh_key is not None:
            pulumi.set(__self__, "ssh_key", ssh_key)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of source to use. For example, "archive".
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password to use when authenticating to the source. This provider cannot perform drift detection of this configuration.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def revision(self) -> Optional[str]:
        """
        For sources that are version-aware, the revision to use.
        """
        return pulumi.get(self, "revision")

    @property
    @pulumi.getter(name="sshKey")
    def ssh_key(self) -> Optional[str]:
        """
        SSH key to use when authenticating to the source. This provider cannot perform drift detection of this configuration.
        """
        return pulumi.get(self, "ssh_key")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        The URL where the app resource can be found.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Username to use when authenticating to the source.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ApplicationEnvironment(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str,
                 secure: Optional[bool] = None):
        """
        :param str key: Variable name.
        :param str value: Variable value.
        :param bool secure: Set visibility of the variable value to `true` or `false`.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)
        if secure is not None:
            pulumi.set(__self__, "secure", secure)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Variable name.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Variable value.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def secure(self) -> Optional[bool]:
        """
        Set visibility of the variable value to `true` or `false`.
        """
        return pulumi.get(self, "secure")


@pulumi.output_type
class ApplicationSslConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateKey":
            suggest = "private_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationSslConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationSslConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationSslConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate: str,
                 private_key: str,
                 chain: Optional[str] = None):
        """
        :param str certificate: The contents of the certificate's domain.crt file.
        :param str private_key: The private key; the contents of the certificate's domain.key file.
        :param str chain: Can be used to specify an intermediate certificate authority key or client authentication.
        """
        pulumi.set(__self__, "certificate", certificate)
        pulumi.set(__self__, "private_key", private_key)
        if chain is not None:
            pulumi.set(__self__, "chain", chain)

    @property
    @pulumi.getter
    def certificate(self) -> str:
        """
        The contents of the certificate's domain.crt file.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> str:
        """
        The private key; the contents of the certificate's domain.key file.
        """
        return pulumi.get(self, "private_key")

    @property
    @pulumi.getter
    def chain(self) -> Optional[str]:
        """
        Can be used to specify an intermediate certificate authority key or client authentication.
        """
        return pulumi.get(self, "chain")


@pulumi.output_type
class CustomLayerEbsVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPoint":
            suggest = "mount_point"
        elif key == "numberOfDisks":
            suggest = "number_of_disks"
        elif key == "raidLevel":
            suggest = "raid_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomLayerEbsVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomLayerEbsVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomLayerEbsVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_point: str,
                 number_of_disks: int,
                 size: int,
                 encrypted: Optional[bool] = None,
                 iops: Optional[int] = None,
                 raid_level: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str mount_point: The path to mount the EBS volume on the layer's instances.
        :param int number_of_disks: The number of disks to use for the EBS volume.
        :param int size: The size of the volume in gigabytes.
        :param bool encrypted: Encrypt the volume.
        :param int iops: For PIOPS volumes, the IOPS per disk.
        :param str raid_level: The RAID level to use for the volume.
        :param str type: The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        pulumi.set(__self__, "mount_point", mount_point)
        pulumi.set(__self__, "number_of_disks", number_of_disks)
        pulumi.set(__self__, "size", size)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if raid_level is not None:
            pulumi.set(__self__, "raid_level", raid_level)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="mountPoint")
    def mount_point(self) -> str:
        """
        The path to mount the EBS volume on the layer's instances.
        """
        return pulumi.get(self, "mount_point")

    @property
    @pulumi.getter(name="numberOfDisks")
    def number_of_disks(self) -> int:
        """
        The number of disks to use for the EBS volume.
        """
        return pulumi.get(self, "number_of_disks")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        The size of the volume in gigabytes.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[bool]:
        """
        Encrypt the volume.
        """
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        """
        For PIOPS volumes, the IOPS per disk.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="raidLevel")
    def raid_level(self) -> Optional[str]:
        """
        The RAID level to use for the volume.
        """
        return pulumi.get(self, "raid_level")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GangliaLayerEbsVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPoint":
            suggest = "mount_point"
        elif key == "numberOfDisks":
            suggest = "number_of_disks"
        elif key == "raidLevel":
            suggest = "raid_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GangliaLayerEbsVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GangliaLayerEbsVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GangliaLayerEbsVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_point: str,
                 number_of_disks: int,
                 size: int,
                 encrypted: Optional[bool] = None,
                 iops: Optional[int] = None,
                 raid_level: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str mount_point: The path to mount the EBS volume on the layer's instances.
        :param int number_of_disks: The number of disks to use for the EBS volume.
        :param int size: The size of the volume in gigabytes.
        :param int iops: For PIOPS volumes, the IOPS per disk.
        :param str raid_level: The RAID level to use for the volume.
        :param str type: The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        pulumi.set(__self__, "mount_point", mount_point)
        pulumi.set(__self__, "number_of_disks", number_of_disks)
        pulumi.set(__self__, "size", size)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if raid_level is not None:
            pulumi.set(__self__, "raid_level", raid_level)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="mountPoint")
    def mount_point(self) -> str:
        """
        The path to mount the EBS volume on the layer's instances.
        """
        return pulumi.get(self, "mount_point")

    @property
    @pulumi.getter(name="numberOfDisks")
    def number_of_disks(self) -> int:
        """
        The number of disks to use for the EBS volume.
        """
        return pulumi.get(self, "number_of_disks")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        The size of the volume in gigabytes.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[bool]:
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        """
        For PIOPS volumes, the IOPS per disk.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="raidLevel")
    def raid_level(self) -> Optional[str]:
        """
        The RAID level to use for the volume.
        """
        return pulumi.get(self, "raid_level")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class HaproxyLayerEbsVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPoint":
            suggest = "mount_point"
        elif key == "numberOfDisks":
            suggest = "number_of_disks"
        elif key == "raidLevel":
            suggest = "raid_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HaproxyLayerEbsVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HaproxyLayerEbsVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HaproxyLayerEbsVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_point: str,
                 number_of_disks: int,
                 size: int,
                 encrypted: Optional[bool] = None,
                 iops: Optional[int] = None,
                 raid_level: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str mount_point: The path to mount the EBS volume on the layer's instances.
        :param int number_of_disks: The number of disks to use for the EBS volume.
        :param int size: The size of the volume in gigabytes.
        :param int iops: For PIOPS volumes, the IOPS per disk.
        :param str raid_level: The RAID level to use for the volume.
        :param str type: The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        pulumi.set(__self__, "mount_point", mount_point)
        pulumi.set(__self__, "number_of_disks", number_of_disks)
        pulumi.set(__self__, "size", size)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if raid_level is not None:
            pulumi.set(__self__, "raid_level", raid_level)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="mountPoint")
    def mount_point(self) -> str:
        """
        The path to mount the EBS volume on the layer's instances.
        """
        return pulumi.get(self, "mount_point")

    @property
    @pulumi.getter(name="numberOfDisks")
    def number_of_disks(self) -> int:
        """
        The number of disks to use for the EBS volume.
        """
        return pulumi.get(self, "number_of_disks")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        The size of the volume in gigabytes.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[bool]:
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        """
        For PIOPS volumes, the IOPS per disk.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="raidLevel")
    def raid_level(self) -> Optional[str]:
        """
        The RAID level to use for the volume.
        """
        return pulumi.get(self, "raid_level")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class InstanceEbsBlockDevice(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deviceName":
            suggest = "device_name"
        elif key == "deleteOnTermination":
            suggest = "delete_on_termination"
        elif key == "snapshotId":
            suggest = "snapshot_id"
        elif key == "volumeSize":
            suggest = "volume_size"
        elif key == "volumeType":
            suggest = "volume_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceEbsBlockDevice. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceEbsBlockDevice.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceEbsBlockDevice.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_name: str,
                 delete_on_termination: Optional[bool] = None,
                 iops: Optional[int] = None,
                 snapshot_id: Optional[str] = None,
                 volume_size: Optional[int] = None,
                 volume_type: Optional[str] = None):
        pulumi.set(__self__, "device_name", device_name)
        if delete_on_termination is not None:
            pulumi.set(__self__, "delete_on_termination", delete_on_termination)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if volume_size is not None:
            pulumi.set(__self__, "volume_size", volume_size)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> str:
        return pulumi.get(self, "device_name")

    @property
    @pulumi.getter(name="deleteOnTermination")
    def delete_on_termination(self) -> Optional[bool]:
        return pulumi.get(self, "delete_on_termination")

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[str]:
        return pulumi.get(self, "snapshot_id")

    @property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> Optional[int]:
        return pulumi.get(self, "volume_size")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[str]:
        return pulumi.get(self, "volume_type")


@pulumi.output_type
class InstanceEphemeralBlockDevice(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deviceName":
            suggest = "device_name"
        elif key == "virtualName":
            suggest = "virtual_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceEphemeralBlockDevice. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceEphemeralBlockDevice.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceEphemeralBlockDevice.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_name: str,
                 virtual_name: str):
        pulumi.set(__self__, "device_name", device_name)
        pulumi.set(__self__, "virtual_name", virtual_name)

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> str:
        return pulumi.get(self, "device_name")

    @property
    @pulumi.getter(name="virtualName")
    def virtual_name(self) -> str:
        return pulumi.get(self, "virtual_name")


@pulumi.output_type
class InstanceRootBlockDevice(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deleteOnTermination":
            suggest = "delete_on_termination"
        elif key == "volumeSize":
            suggest = "volume_size"
        elif key == "volumeType":
            suggest = "volume_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceRootBlockDevice. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceRootBlockDevice.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceRootBlockDevice.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delete_on_termination: Optional[bool] = None,
                 iops: Optional[int] = None,
                 volume_size: Optional[int] = None,
                 volume_type: Optional[str] = None):
        if delete_on_termination is not None:
            pulumi.set(__self__, "delete_on_termination", delete_on_termination)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if volume_size is not None:
            pulumi.set(__self__, "volume_size", volume_size)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter(name="deleteOnTermination")
    def delete_on_termination(self) -> Optional[bool]:
        return pulumi.get(self, "delete_on_termination")

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> Optional[int]:
        return pulumi.get(self, "volume_size")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[str]:
        return pulumi.get(self, "volume_type")


@pulumi.output_type
class JavaAppLayerEbsVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPoint":
            suggest = "mount_point"
        elif key == "numberOfDisks":
            suggest = "number_of_disks"
        elif key == "raidLevel":
            suggest = "raid_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JavaAppLayerEbsVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JavaAppLayerEbsVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JavaAppLayerEbsVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_point: str,
                 number_of_disks: int,
                 size: int,
                 encrypted: Optional[bool] = None,
                 iops: Optional[int] = None,
                 raid_level: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str mount_point: The path to mount the EBS volume on the layer's instances.
        :param int number_of_disks: The number of disks to use for the EBS volume.
        :param int size: The size of the volume in gigabytes.
        :param int iops: For PIOPS volumes, the IOPS per disk.
        :param str raid_level: The RAID level to use for the volume.
        :param str type: The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        pulumi.set(__self__, "mount_point", mount_point)
        pulumi.set(__self__, "number_of_disks", number_of_disks)
        pulumi.set(__self__, "size", size)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if raid_level is not None:
            pulumi.set(__self__, "raid_level", raid_level)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="mountPoint")
    def mount_point(self) -> str:
        """
        The path to mount the EBS volume on the layer's instances.
        """
        return pulumi.get(self, "mount_point")

    @property
    @pulumi.getter(name="numberOfDisks")
    def number_of_disks(self) -> int:
        """
        The number of disks to use for the EBS volume.
        """
        return pulumi.get(self, "number_of_disks")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        The size of the volume in gigabytes.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[bool]:
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        """
        For PIOPS volumes, the IOPS per disk.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="raidLevel")
    def raid_level(self) -> Optional[str]:
        """
        The RAID level to use for the volume.
        """
        return pulumi.get(self, "raid_level")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class MemcachedLayerEbsVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPoint":
            suggest = "mount_point"
        elif key == "numberOfDisks":
            suggest = "number_of_disks"
        elif key == "raidLevel":
            suggest = "raid_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MemcachedLayerEbsVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MemcachedLayerEbsVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MemcachedLayerEbsVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_point: str,
                 number_of_disks: int,
                 size: int,
                 encrypted: Optional[bool] = None,
                 iops: Optional[int] = None,
                 raid_level: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str mount_point: The path to mount the EBS volume on the layer's instances.
        :param int number_of_disks: The number of disks to use for the EBS volume.
        :param int size: The size of the volume in gigabytes.
        :param int iops: For PIOPS volumes, the IOPS per disk.
        :param str raid_level: The RAID level to use for the volume.
        :param str type: The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        pulumi.set(__self__, "mount_point", mount_point)
        pulumi.set(__self__, "number_of_disks", number_of_disks)
        pulumi.set(__self__, "size", size)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if raid_level is not None:
            pulumi.set(__self__, "raid_level", raid_level)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="mountPoint")
    def mount_point(self) -> str:
        """
        The path to mount the EBS volume on the layer's instances.
        """
        return pulumi.get(self, "mount_point")

    @property
    @pulumi.getter(name="numberOfDisks")
    def number_of_disks(self) -> int:
        """
        The number of disks to use for the EBS volume.
        """
        return pulumi.get(self, "number_of_disks")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        The size of the volume in gigabytes.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[bool]:
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        """
        For PIOPS volumes, the IOPS per disk.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="raidLevel")
    def raid_level(self) -> Optional[str]:
        """
        The RAID level to use for the volume.
        """
        return pulumi.get(self, "raid_level")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class MysqlLayerEbsVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPoint":
            suggest = "mount_point"
        elif key == "numberOfDisks":
            suggest = "number_of_disks"
        elif key == "raidLevel":
            suggest = "raid_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlLayerEbsVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlLayerEbsVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlLayerEbsVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_point: str,
                 number_of_disks: int,
                 size: int,
                 encrypted: Optional[bool] = None,
                 iops: Optional[int] = None,
                 raid_level: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str mount_point: The path to mount the EBS volume on the layer's instances.
        :param int number_of_disks: The number of disks to use for the EBS volume.
        :param int size: The size of the volume in gigabytes.
        :param int iops: For PIOPS volumes, the IOPS per disk.
        :param str raid_level: The RAID level to use for the volume.
        :param str type: The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        pulumi.set(__self__, "mount_point", mount_point)
        pulumi.set(__self__, "number_of_disks", number_of_disks)
        pulumi.set(__self__, "size", size)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if raid_level is not None:
            pulumi.set(__self__, "raid_level", raid_level)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="mountPoint")
    def mount_point(self) -> str:
        """
        The path to mount the EBS volume on the layer's instances.
        """
        return pulumi.get(self, "mount_point")

    @property
    @pulumi.getter(name="numberOfDisks")
    def number_of_disks(self) -> int:
        """
        The number of disks to use for the EBS volume.
        """
        return pulumi.get(self, "number_of_disks")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        The size of the volume in gigabytes.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[bool]:
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        """
        For PIOPS volumes, the IOPS per disk.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="raidLevel")
    def raid_level(self) -> Optional[str]:
        """
        The RAID level to use for the volume.
        """
        return pulumi.get(self, "raid_level")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class NodejsAppLayerEbsVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPoint":
            suggest = "mount_point"
        elif key == "numberOfDisks":
            suggest = "number_of_disks"
        elif key == "raidLevel":
            suggest = "raid_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodejsAppLayerEbsVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodejsAppLayerEbsVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodejsAppLayerEbsVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_point: str,
                 number_of_disks: int,
                 size: int,
                 encrypted: Optional[bool] = None,
                 iops: Optional[int] = None,
                 raid_level: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str mount_point: The path to mount the EBS volume on the layer's instances.
        :param int number_of_disks: The number of disks to use for the EBS volume.
        :param int size: The size of the volume in gigabytes.
        :param int iops: For PIOPS volumes, the IOPS per disk.
        :param str raid_level: The RAID level to use for the volume.
        :param str type: The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        pulumi.set(__self__, "mount_point", mount_point)
        pulumi.set(__self__, "number_of_disks", number_of_disks)
        pulumi.set(__self__, "size", size)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if raid_level is not None:
            pulumi.set(__self__, "raid_level", raid_level)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="mountPoint")
    def mount_point(self) -> str:
        """
        The path to mount the EBS volume on the layer's instances.
        """
        return pulumi.get(self, "mount_point")

    @property
    @pulumi.getter(name="numberOfDisks")
    def number_of_disks(self) -> int:
        """
        The number of disks to use for the EBS volume.
        """
        return pulumi.get(self, "number_of_disks")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        The size of the volume in gigabytes.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[bool]:
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        """
        For PIOPS volumes, the IOPS per disk.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="raidLevel")
    def raid_level(self) -> Optional[str]:
        """
        The RAID level to use for the volume.
        """
        return pulumi.get(self, "raid_level")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PhpAppLayerEbsVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPoint":
            suggest = "mount_point"
        elif key == "numberOfDisks":
            suggest = "number_of_disks"
        elif key == "raidLevel":
            suggest = "raid_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PhpAppLayerEbsVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PhpAppLayerEbsVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PhpAppLayerEbsVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_point: str,
                 number_of_disks: int,
                 size: int,
                 encrypted: Optional[bool] = None,
                 iops: Optional[int] = None,
                 raid_level: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str mount_point: The path to mount the EBS volume on the layer's instances.
        :param int number_of_disks: The number of disks to use for the EBS volume.
        :param int size: The size of the volume in gigabytes.
        :param int iops: For PIOPS volumes, the IOPS per disk.
        :param str raid_level: The RAID level to use for the volume.
        :param str type: The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        pulumi.set(__self__, "mount_point", mount_point)
        pulumi.set(__self__, "number_of_disks", number_of_disks)
        pulumi.set(__self__, "size", size)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if raid_level is not None:
            pulumi.set(__self__, "raid_level", raid_level)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="mountPoint")
    def mount_point(self) -> str:
        """
        The path to mount the EBS volume on the layer's instances.
        """
        return pulumi.get(self, "mount_point")

    @property
    @pulumi.getter(name="numberOfDisks")
    def number_of_disks(self) -> int:
        """
        The number of disks to use for the EBS volume.
        """
        return pulumi.get(self, "number_of_disks")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        The size of the volume in gigabytes.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[bool]:
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        """
        For PIOPS volumes, the IOPS per disk.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="raidLevel")
    def raid_level(self) -> Optional[str]:
        """
        The RAID level to use for the volume.
        """
        return pulumi.get(self, "raid_level")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class RailsAppLayerEbsVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPoint":
            suggest = "mount_point"
        elif key == "numberOfDisks":
            suggest = "number_of_disks"
        elif key == "raidLevel":
            suggest = "raid_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RailsAppLayerEbsVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RailsAppLayerEbsVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RailsAppLayerEbsVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_point: str,
                 number_of_disks: int,
                 size: int,
                 encrypted: Optional[bool] = None,
                 iops: Optional[int] = None,
                 raid_level: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str mount_point: The path to mount the EBS volume on the layer's instances.
        :param int number_of_disks: The number of disks to use for the EBS volume.
        :param int size: The size of the volume in gigabytes.
        :param int iops: For PIOPS volumes, the IOPS per disk.
        :param str raid_level: The RAID level to use for the volume.
        :param str type: The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        pulumi.set(__self__, "mount_point", mount_point)
        pulumi.set(__self__, "number_of_disks", number_of_disks)
        pulumi.set(__self__, "size", size)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if raid_level is not None:
            pulumi.set(__self__, "raid_level", raid_level)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="mountPoint")
    def mount_point(self) -> str:
        """
        The path to mount the EBS volume on the layer's instances.
        """
        return pulumi.get(self, "mount_point")

    @property
    @pulumi.getter(name="numberOfDisks")
    def number_of_disks(self) -> int:
        """
        The number of disks to use for the EBS volume.
        """
        return pulumi.get(self, "number_of_disks")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        The size of the volume in gigabytes.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[bool]:
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        """
        For PIOPS volumes, the IOPS per disk.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="raidLevel")
    def raid_level(self) -> Optional[str]:
        """
        The RAID level to use for the volume.
        """
        return pulumi.get(self, "raid_level")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class StackCustomCookbooksSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sshKey":
            suggest = "ssh_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StackCustomCookbooksSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StackCustomCookbooksSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StackCustomCookbooksSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 url: str,
                 password: Optional[str] = None,
                 revision: Optional[str] = None,
                 ssh_key: Optional[str] = None,
                 username: Optional[str] = None):
        """
        :param str type: The type of source to use. For example, "archive".
        :param str url: The URL where the cookbooks resource can be found.
        :param str password: Password to use when authenticating to the source. The provider cannot perform drift detection of this configuration.
        :param str revision: For sources that are version-aware, the revision to use.
        :param str ssh_key: SSH key to use when authenticating to the source. The provider cannot perform drift detection of this configuration.
        :param str username: Username to use when authenticating to the source.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "url", url)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)
        if ssh_key is not None:
            pulumi.set(__self__, "ssh_key", ssh_key)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of source to use. For example, "archive".
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The URL where the cookbooks resource can be found.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password to use when authenticating to the source. The provider cannot perform drift detection of this configuration.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def revision(self) -> Optional[str]:
        """
        For sources that are version-aware, the revision to use.
        """
        return pulumi.get(self, "revision")

    @property
    @pulumi.getter(name="sshKey")
    def ssh_key(self) -> Optional[str]:
        """
        SSH key to use when authenticating to the source. The provider cannot perform drift detection of this configuration.
        """
        return pulumi.get(self, "ssh_key")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Username to use when authenticating to the source.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class StaticWebLayerEbsVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPoint":
            suggest = "mount_point"
        elif key == "numberOfDisks":
            suggest = "number_of_disks"
        elif key == "raidLevel":
            suggest = "raid_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StaticWebLayerEbsVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StaticWebLayerEbsVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StaticWebLayerEbsVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_point: str,
                 number_of_disks: int,
                 size: int,
                 encrypted: Optional[bool] = None,
                 iops: Optional[int] = None,
                 raid_level: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str mount_point: The path to mount the EBS volume on the layer's instances.
        :param int number_of_disks: The number of disks to use for the EBS volume.
        :param int size: The size of the volume in gigabytes.
        :param int iops: For PIOPS volumes, the IOPS per disk.
        :param str raid_level: The RAID level to use for the volume.
        :param str type: The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        pulumi.set(__self__, "mount_point", mount_point)
        pulumi.set(__self__, "number_of_disks", number_of_disks)
        pulumi.set(__self__, "size", size)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if raid_level is not None:
            pulumi.set(__self__, "raid_level", raid_level)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="mountPoint")
    def mount_point(self) -> str:
        """
        The path to mount the EBS volume on the layer's instances.
        """
        return pulumi.get(self, "mount_point")

    @property
    @pulumi.getter(name="numberOfDisks")
    def number_of_disks(self) -> int:
        """
        The number of disks to use for the EBS volume.
        """
        return pulumi.get(self, "number_of_disks")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        The size of the volume in gigabytes.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[bool]:
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        """
        For PIOPS volumes, the IOPS per disk.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="raidLevel")
    def raid_level(self) -> Optional[str]:
        """
        The RAID level to use for the volume.
        """
        return pulumi.get(self, "raid_level")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        return pulumi.get(self, "type")


