# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'ApplicationAppSourceArgs',
    'ApplicationEnvironmentArgs',
    'ApplicationSslConfigurationArgs',
    'CustomLayerEbsVolumeArgs',
    'GangliaLayerEbsVolumeArgs',
    'HaproxyLayerEbsVolumeArgs',
    'InstanceEbsBlockDeviceArgs',
    'InstanceEphemeralBlockDeviceArgs',
    'InstanceRootBlockDeviceArgs',
    'JavaAppLayerEbsVolumeArgs',
    'MemcachedLayerEbsVolumeArgs',
    'MysqlLayerEbsVolumeArgs',
    'NodejsAppLayerEbsVolumeArgs',
    'PhpAppLayerEbsVolumeArgs',
    'RailsAppLayerEbsVolumeArgs',
    'StackCustomCookbooksSourceArgs',
    'StaticWebLayerEbsVolumeArgs',
]

@pulumi.input_type
class ApplicationAppSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 password: Optional[pulumi.Input[str]] = None,
                 revision: Optional[pulumi.Input[str]] = None,
                 ssh_key: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] type: The type of source to use. For example, "archive".
        :param pulumi.Input[str] password: Password to use when authenticating to the source. This provider cannot perform drift detection of this configuration.
        :param pulumi.Input[str] revision: For sources that are version-aware, the revision to use.
        :param pulumi.Input[str] ssh_key: SSH key to use when authenticating to the source. This provider cannot perform drift detection of this configuration.
        :param pulumi.Input[str] url: The URL where the app resource can be found.
        :param pulumi.Input[str] username: Username to use when authenticating to the source.
        """
        pulumi.set(__self__, "type", type)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)
        if ssh_key is not None:
            pulumi.set(__self__, "ssh_key", ssh_key)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of source to use. For example, "archive".
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password to use when authenticating to the source. This provider cannot perform drift detection of this configuration.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def revision(self) -> Optional[pulumi.Input[str]]:
        """
        For sources that are version-aware, the revision to use.
        """
        return pulumi.get(self, "revision")

    @revision.setter
    def revision(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "revision", value)

    @property
    @pulumi.getter(name="sshKey")
    def ssh_key(self) -> Optional[pulumi.Input[str]]:
        """
        SSH key to use when authenticating to the source. This provider cannot perform drift detection of this configuration.
        """
        return pulumi.get(self, "ssh_key")

    @ssh_key.setter
    def ssh_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssh_key", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL where the app resource can be found.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Username to use when authenticating to the source.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class ApplicationEnvironmentArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str],
                 secure: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] key: Variable name.
        :param pulumi.Input[str] value: Variable value.
        :param pulumi.Input[bool] secure: Set visibility of the variable value to `true` or `false`.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)
        if secure is not None:
            pulumi.set(__self__, "secure", secure)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        Variable name.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Variable value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def secure(self) -> Optional[pulumi.Input[bool]]:
        """
        Set visibility of the variable value to `true` or `false`.
        """
        return pulumi.get(self, "secure")

    @secure.setter
    def secure(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "secure", value)


@pulumi.input_type
class ApplicationSslConfigurationArgs:
    def __init__(__self__, *,
                 certificate: pulumi.Input[str],
                 private_key: pulumi.Input[str],
                 chain: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] certificate: The contents of the certificate's domain.crt file.
        :param pulumi.Input[str] private_key: The private key; the contents of the certificate's domain.key file.
        :param pulumi.Input[str] chain: Can be used to specify an intermediate certificate authority key or client authentication.
        """
        pulumi.set(__self__, "certificate", certificate)
        pulumi.set(__self__, "private_key", private_key)
        if chain is not None:
            pulumi.set(__self__, "chain", chain)

    @property
    @pulumi.getter
    def certificate(self) -> pulumi.Input[str]:
        """
        The contents of the certificate's domain.crt file.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: pulumi.Input[str]):
        pulumi.set(self, "certificate", value)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Input[str]:
        """
        The private key; the contents of the certificate's domain.key file.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "private_key", value)

    @property
    @pulumi.getter
    def chain(self) -> Optional[pulumi.Input[str]]:
        """
        Can be used to specify an intermediate certificate authority key or client authentication.
        """
        return pulumi.get(self, "chain")

    @chain.setter
    def chain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "chain", value)


@pulumi.input_type
class CustomLayerEbsVolumeArgs:
    def __init__(__self__, *,
                 mount_point: pulumi.Input[str],
                 number_of_disks: pulumi.Input[int],
                 size: pulumi.Input[int],
                 encrypted: Optional[pulumi.Input[bool]] = None,
                 iops: Optional[pulumi.Input[int]] = None,
                 raid_level: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] mount_point: The path to mount the EBS volume on the layer's instances.
        :param pulumi.Input[int] number_of_disks: The number of disks to use for the EBS volume.
        :param pulumi.Input[int] size: The size of the volume in gigabytes.
        :param pulumi.Input[bool] encrypted: Encrypt the volume.
        :param pulumi.Input[int] iops: For PIOPS volumes, the IOPS per disk.
        :param pulumi.Input[str] raid_level: The RAID level to use for the volume.
        :param pulumi.Input[str] type: The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        pulumi.set(__self__, "mount_point", mount_point)
        pulumi.set(__self__, "number_of_disks", number_of_disks)
        pulumi.set(__self__, "size", size)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if raid_level is not None:
            pulumi.set(__self__, "raid_level", raid_level)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="mountPoint")
    def mount_point(self) -> pulumi.Input[str]:
        """
        The path to mount the EBS volume on the layer's instances.
        """
        return pulumi.get(self, "mount_point")

    @mount_point.setter
    def mount_point(self, value: pulumi.Input[str]):
        pulumi.set(self, "mount_point", value)

    @property
    @pulumi.getter(name="numberOfDisks")
    def number_of_disks(self) -> pulumi.Input[int]:
        """
        The number of disks to use for the EBS volume.
        """
        return pulumi.get(self, "number_of_disks")

    @number_of_disks.setter
    def number_of_disks(self, value: pulumi.Input[int]):
        pulumi.set(self, "number_of_disks", value)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[int]:
        """
        The size of the volume in gigabytes.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[int]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[pulumi.Input[bool]]:
        """
        Encrypt the volume.
        """
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypted", value)

    @property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[int]]:
        """
        For PIOPS volumes, the IOPS per disk.
        """
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "iops", value)

    @property
    @pulumi.getter(name="raidLevel")
    def raid_level(self) -> Optional[pulumi.Input[str]]:
        """
        The RAID level to use for the volume.
        """
        return pulumi.get(self, "raid_level")

    @raid_level.setter
    def raid_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "raid_level", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class GangliaLayerEbsVolumeArgs:
    def __init__(__self__, *,
                 mount_point: pulumi.Input[str],
                 number_of_disks: pulumi.Input[int],
                 size: pulumi.Input[int],
                 encrypted: Optional[pulumi.Input[bool]] = None,
                 iops: Optional[pulumi.Input[int]] = None,
                 raid_level: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] mount_point: The path to mount the EBS volume on the layer's instances.
        :param pulumi.Input[int] number_of_disks: The number of disks to use for the EBS volume.
        :param pulumi.Input[int] size: The size of the volume in gigabytes.
        :param pulumi.Input[int] iops: For PIOPS volumes, the IOPS per disk.
        :param pulumi.Input[str] raid_level: The RAID level to use for the volume.
        :param pulumi.Input[str] type: The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        pulumi.set(__self__, "mount_point", mount_point)
        pulumi.set(__self__, "number_of_disks", number_of_disks)
        pulumi.set(__self__, "size", size)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if raid_level is not None:
            pulumi.set(__self__, "raid_level", raid_level)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="mountPoint")
    def mount_point(self) -> pulumi.Input[str]:
        """
        The path to mount the EBS volume on the layer's instances.
        """
        return pulumi.get(self, "mount_point")

    @mount_point.setter
    def mount_point(self, value: pulumi.Input[str]):
        pulumi.set(self, "mount_point", value)

    @property
    @pulumi.getter(name="numberOfDisks")
    def number_of_disks(self) -> pulumi.Input[int]:
        """
        The number of disks to use for the EBS volume.
        """
        return pulumi.get(self, "number_of_disks")

    @number_of_disks.setter
    def number_of_disks(self, value: pulumi.Input[int]):
        pulumi.set(self, "number_of_disks", value)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[int]:
        """
        The size of the volume in gigabytes.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[int]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypted", value)

    @property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[int]]:
        """
        For PIOPS volumes, the IOPS per disk.
        """
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "iops", value)

    @property
    @pulumi.getter(name="raidLevel")
    def raid_level(self) -> Optional[pulumi.Input[str]]:
        """
        The RAID level to use for the volume.
        """
        return pulumi.get(self, "raid_level")

    @raid_level.setter
    def raid_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "raid_level", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class HaproxyLayerEbsVolumeArgs:
    def __init__(__self__, *,
                 mount_point: pulumi.Input[str],
                 number_of_disks: pulumi.Input[int],
                 size: pulumi.Input[int],
                 encrypted: Optional[pulumi.Input[bool]] = None,
                 iops: Optional[pulumi.Input[int]] = None,
                 raid_level: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] mount_point: The path to mount the EBS volume on the layer's instances.
        :param pulumi.Input[int] number_of_disks: The number of disks to use for the EBS volume.
        :param pulumi.Input[int] size: The size of the volume in gigabytes.
        :param pulumi.Input[int] iops: For PIOPS volumes, the IOPS per disk.
        :param pulumi.Input[str] raid_level: The RAID level to use for the volume.
        :param pulumi.Input[str] type: The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        pulumi.set(__self__, "mount_point", mount_point)
        pulumi.set(__self__, "number_of_disks", number_of_disks)
        pulumi.set(__self__, "size", size)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if raid_level is not None:
            pulumi.set(__self__, "raid_level", raid_level)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="mountPoint")
    def mount_point(self) -> pulumi.Input[str]:
        """
        The path to mount the EBS volume on the layer's instances.
        """
        return pulumi.get(self, "mount_point")

    @mount_point.setter
    def mount_point(self, value: pulumi.Input[str]):
        pulumi.set(self, "mount_point", value)

    @property
    @pulumi.getter(name="numberOfDisks")
    def number_of_disks(self) -> pulumi.Input[int]:
        """
        The number of disks to use for the EBS volume.
        """
        return pulumi.get(self, "number_of_disks")

    @number_of_disks.setter
    def number_of_disks(self, value: pulumi.Input[int]):
        pulumi.set(self, "number_of_disks", value)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[int]:
        """
        The size of the volume in gigabytes.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[int]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypted", value)

    @property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[int]]:
        """
        For PIOPS volumes, the IOPS per disk.
        """
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "iops", value)

    @property
    @pulumi.getter(name="raidLevel")
    def raid_level(self) -> Optional[pulumi.Input[str]]:
        """
        The RAID level to use for the volume.
        """
        return pulumi.get(self, "raid_level")

    @raid_level.setter
    def raid_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "raid_level", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class InstanceEbsBlockDeviceArgs:
    def __init__(__self__, *,
                 device_name: pulumi.Input[str],
                 delete_on_termination: Optional[pulumi.Input[bool]] = None,
                 iops: Optional[pulumi.Input[int]] = None,
                 snapshot_id: Optional[pulumi.Input[str]] = None,
                 volume_size: Optional[pulumi.Input[int]] = None,
                 volume_type: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "device_name", device_name)
        if delete_on_termination is not None:
            pulumi.set(__self__, "delete_on_termination", delete_on_termination)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if volume_size is not None:
            pulumi.set(__self__, "volume_size", volume_size)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "device_name")

    @device_name.setter
    def device_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "device_name", value)

    @property
    @pulumi.getter(name="deleteOnTermination")
    def delete_on_termination(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "delete_on_termination")

    @delete_on_termination.setter
    def delete_on_termination(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_on_termination", value)

    @property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "iops", value)

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_id", value)

    @property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "volume_size")

    @volume_size.setter
    def volume_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "volume_size", value)

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_type", value)


@pulumi.input_type
class InstanceEphemeralBlockDeviceArgs:
    def __init__(__self__, *,
                 device_name: pulumi.Input[str],
                 virtual_name: pulumi.Input[str]):
        pulumi.set(__self__, "device_name", device_name)
        pulumi.set(__self__, "virtual_name", virtual_name)

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "device_name")

    @device_name.setter
    def device_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "device_name", value)

    @property
    @pulumi.getter(name="virtualName")
    def virtual_name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "virtual_name")

    @virtual_name.setter
    def virtual_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "virtual_name", value)


@pulumi.input_type
class InstanceRootBlockDeviceArgs:
    def __init__(__self__, *,
                 delete_on_termination: Optional[pulumi.Input[bool]] = None,
                 iops: Optional[pulumi.Input[int]] = None,
                 volume_size: Optional[pulumi.Input[int]] = None,
                 volume_type: Optional[pulumi.Input[str]] = None):
        if delete_on_termination is not None:
            pulumi.set(__self__, "delete_on_termination", delete_on_termination)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if volume_size is not None:
            pulumi.set(__self__, "volume_size", volume_size)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter(name="deleteOnTermination")
    def delete_on_termination(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "delete_on_termination")

    @delete_on_termination.setter
    def delete_on_termination(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_on_termination", value)

    @property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "iops", value)

    @property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "volume_size")

    @volume_size.setter
    def volume_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "volume_size", value)

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_type", value)


@pulumi.input_type
class JavaAppLayerEbsVolumeArgs:
    def __init__(__self__, *,
                 mount_point: pulumi.Input[str],
                 number_of_disks: pulumi.Input[int],
                 size: pulumi.Input[int],
                 encrypted: Optional[pulumi.Input[bool]] = None,
                 iops: Optional[pulumi.Input[int]] = None,
                 raid_level: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] mount_point: The path to mount the EBS volume on the layer's instances.
        :param pulumi.Input[int] number_of_disks: The number of disks to use for the EBS volume.
        :param pulumi.Input[int] size: The size of the volume in gigabytes.
        :param pulumi.Input[int] iops: For PIOPS volumes, the IOPS per disk.
        :param pulumi.Input[str] raid_level: The RAID level to use for the volume.
        :param pulumi.Input[str] type: The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        pulumi.set(__self__, "mount_point", mount_point)
        pulumi.set(__self__, "number_of_disks", number_of_disks)
        pulumi.set(__self__, "size", size)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if raid_level is not None:
            pulumi.set(__self__, "raid_level", raid_level)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="mountPoint")
    def mount_point(self) -> pulumi.Input[str]:
        """
        The path to mount the EBS volume on the layer's instances.
        """
        return pulumi.get(self, "mount_point")

    @mount_point.setter
    def mount_point(self, value: pulumi.Input[str]):
        pulumi.set(self, "mount_point", value)

    @property
    @pulumi.getter(name="numberOfDisks")
    def number_of_disks(self) -> pulumi.Input[int]:
        """
        The number of disks to use for the EBS volume.
        """
        return pulumi.get(self, "number_of_disks")

    @number_of_disks.setter
    def number_of_disks(self, value: pulumi.Input[int]):
        pulumi.set(self, "number_of_disks", value)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[int]:
        """
        The size of the volume in gigabytes.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[int]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypted", value)

    @property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[int]]:
        """
        For PIOPS volumes, the IOPS per disk.
        """
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "iops", value)

    @property
    @pulumi.getter(name="raidLevel")
    def raid_level(self) -> Optional[pulumi.Input[str]]:
        """
        The RAID level to use for the volume.
        """
        return pulumi.get(self, "raid_level")

    @raid_level.setter
    def raid_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "raid_level", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class MemcachedLayerEbsVolumeArgs:
    def __init__(__self__, *,
                 mount_point: pulumi.Input[str],
                 number_of_disks: pulumi.Input[int],
                 size: pulumi.Input[int],
                 encrypted: Optional[pulumi.Input[bool]] = None,
                 iops: Optional[pulumi.Input[int]] = None,
                 raid_level: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] mount_point: The path to mount the EBS volume on the layer's instances.
        :param pulumi.Input[int] number_of_disks: The number of disks to use for the EBS volume.
        :param pulumi.Input[int] size: The size of the volume in gigabytes.
        :param pulumi.Input[int] iops: For PIOPS volumes, the IOPS per disk.
        :param pulumi.Input[str] raid_level: The RAID level to use for the volume.
        :param pulumi.Input[str] type: The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        pulumi.set(__self__, "mount_point", mount_point)
        pulumi.set(__self__, "number_of_disks", number_of_disks)
        pulumi.set(__self__, "size", size)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if raid_level is not None:
            pulumi.set(__self__, "raid_level", raid_level)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="mountPoint")
    def mount_point(self) -> pulumi.Input[str]:
        """
        The path to mount the EBS volume on the layer's instances.
        """
        return pulumi.get(self, "mount_point")

    @mount_point.setter
    def mount_point(self, value: pulumi.Input[str]):
        pulumi.set(self, "mount_point", value)

    @property
    @pulumi.getter(name="numberOfDisks")
    def number_of_disks(self) -> pulumi.Input[int]:
        """
        The number of disks to use for the EBS volume.
        """
        return pulumi.get(self, "number_of_disks")

    @number_of_disks.setter
    def number_of_disks(self, value: pulumi.Input[int]):
        pulumi.set(self, "number_of_disks", value)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[int]:
        """
        The size of the volume in gigabytes.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[int]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypted", value)

    @property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[int]]:
        """
        For PIOPS volumes, the IOPS per disk.
        """
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "iops", value)

    @property
    @pulumi.getter(name="raidLevel")
    def raid_level(self) -> Optional[pulumi.Input[str]]:
        """
        The RAID level to use for the volume.
        """
        return pulumi.get(self, "raid_level")

    @raid_level.setter
    def raid_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "raid_level", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class MysqlLayerEbsVolumeArgs:
    def __init__(__self__, *,
                 mount_point: pulumi.Input[str],
                 number_of_disks: pulumi.Input[int],
                 size: pulumi.Input[int],
                 encrypted: Optional[pulumi.Input[bool]] = None,
                 iops: Optional[pulumi.Input[int]] = None,
                 raid_level: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] mount_point: The path to mount the EBS volume on the layer's instances.
        :param pulumi.Input[int] number_of_disks: The number of disks to use for the EBS volume.
        :param pulumi.Input[int] size: The size of the volume in gigabytes.
        :param pulumi.Input[int] iops: For PIOPS volumes, the IOPS per disk.
        :param pulumi.Input[str] raid_level: The RAID level to use for the volume.
        :param pulumi.Input[str] type: The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        pulumi.set(__self__, "mount_point", mount_point)
        pulumi.set(__self__, "number_of_disks", number_of_disks)
        pulumi.set(__self__, "size", size)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if raid_level is not None:
            pulumi.set(__self__, "raid_level", raid_level)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="mountPoint")
    def mount_point(self) -> pulumi.Input[str]:
        """
        The path to mount the EBS volume on the layer's instances.
        """
        return pulumi.get(self, "mount_point")

    @mount_point.setter
    def mount_point(self, value: pulumi.Input[str]):
        pulumi.set(self, "mount_point", value)

    @property
    @pulumi.getter(name="numberOfDisks")
    def number_of_disks(self) -> pulumi.Input[int]:
        """
        The number of disks to use for the EBS volume.
        """
        return pulumi.get(self, "number_of_disks")

    @number_of_disks.setter
    def number_of_disks(self, value: pulumi.Input[int]):
        pulumi.set(self, "number_of_disks", value)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[int]:
        """
        The size of the volume in gigabytes.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[int]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypted", value)

    @property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[int]]:
        """
        For PIOPS volumes, the IOPS per disk.
        """
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "iops", value)

    @property
    @pulumi.getter(name="raidLevel")
    def raid_level(self) -> Optional[pulumi.Input[str]]:
        """
        The RAID level to use for the volume.
        """
        return pulumi.get(self, "raid_level")

    @raid_level.setter
    def raid_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "raid_level", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class NodejsAppLayerEbsVolumeArgs:
    def __init__(__self__, *,
                 mount_point: pulumi.Input[str],
                 number_of_disks: pulumi.Input[int],
                 size: pulumi.Input[int],
                 encrypted: Optional[pulumi.Input[bool]] = None,
                 iops: Optional[pulumi.Input[int]] = None,
                 raid_level: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] mount_point: The path to mount the EBS volume on the layer's instances.
        :param pulumi.Input[int] number_of_disks: The number of disks to use for the EBS volume.
        :param pulumi.Input[int] size: The size of the volume in gigabytes.
        :param pulumi.Input[int] iops: For PIOPS volumes, the IOPS per disk.
        :param pulumi.Input[str] raid_level: The RAID level to use for the volume.
        :param pulumi.Input[str] type: The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        pulumi.set(__self__, "mount_point", mount_point)
        pulumi.set(__self__, "number_of_disks", number_of_disks)
        pulumi.set(__self__, "size", size)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if raid_level is not None:
            pulumi.set(__self__, "raid_level", raid_level)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="mountPoint")
    def mount_point(self) -> pulumi.Input[str]:
        """
        The path to mount the EBS volume on the layer's instances.
        """
        return pulumi.get(self, "mount_point")

    @mount_point.setter
    def mount_point(self, value: pulumi.Input[str]):
        pulumi.set(self, "mount_point", value)

    @property
    @pulumi.getter(name="numberOfDisks")
    def number_of_disks(self) -> pulumi.Input[int]:
        """
        The number of disks to use for the EBS volume.
        """
        return pulumi.get(self, "number_of_disks")

    @number_of_disks.setter
    def number_of_disks(self, value: pulumi.Input[int]):
        pulumi.set(self, "number_of_disks", value)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[int]:
        """
        The size of the volume in gigabytes.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[int]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypted", value)

    @property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[int]]:
        """
        For PIOPS volumes, the IOPS per disk.
        """
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "iops", value)

    @property
    @pulumi.getter(name="raidLevel")
    def raid_level(self) -> Optional[pulumi.Input[str]]:
        """
        The RAID level to use for the volume.
        """
        return pulumi.get(self, "raid_level")

    @raid_level.setter
    def raid_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "raid_level", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class PhpAppLayerEbsVolumeArgs:
    def __init__(__self__, *,
                 mount_point: pulumi.Input[str],
                 number_of_disks: pulumi.Input[int],
                 size: pulumi.Input[int],
                 encrypted: Optional[pulumi.Input[bool]] = None,
                 iops: Optional[pulumi.Input[int]] = None,
                 raid_level: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] mount_point: The path to mount the EBS volume on the layer's instances.
        :param pulumi.Input[int] number_of_disks: The number of disks to use for the EBS volume.
        :param pulumi.Input[int] size: The size of the volume in gigabytes.
        :param pulumi.Input[int] iops: For PIOPS volumes, the IOPS per disk.
        :param pulumi.Input[str] raid_level: The RAID level to use for the volume.
        :param pulumi.Input[str] type: The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        pulumi.set(__self__, "mount_point", mount_point)
        pulumi.set(__self__, "number_of_disks", number_of_disks)
        pulumi.set(__self__, "size", size)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if raid_level is not None:
            pulumi.set(__self__, "raid_level", raid_level)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="mountPoint")
    def mount_point(self) -> pulumi.Input[str]:
        """
        The path to mount the EBS volume on the layer's instances.
        """
        return pulumi.get(self, "mount_point")

    @mount_point.setter
    def mount_point(self, value: pulumi.Input[str]):
        pulumi.set(self, "mount_point", value)

    @property
    @pulumi.getter(name="numberOfDisks")
    def number_of_disks(self) -> pulumi.Input[int]:
        """
        The number of disks to use for the EBS volume.
        """
        return pulumi.get(self, "number_of_disks")

    @number_of_disks.setter
    def number_of_disks(self, value: pulumi.Input[int]):
        pulumi.set(self, "number_of_disks", value)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[int]:
        """
        The size of the volume in gigabytes.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[int]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypted", value)

    @property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[int]]:
        """
        For PIOPS volumes, the IOPS per disk.
        """
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "iops", value)

    @property
    @pulumi.getter(name="raidLevel")
    def raid_level(self) -> Optional[pulumi.Input[str]]:
        """
        The RAID level to use for the volume.
        """
        return pulumi.get(self, "raid_level")

    @raid_level.setter
    def raid_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "raid_level", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class RailsAppLayerEbsVolumeArgs:
    def __init__(__self__, *,
                 mount_point: pulumi.Input[str],
                 number_of_disks: pulumi.Input[int],
                 size: pulumi.Input[int],
                 encrypted: Optional[pulumi.Input[bool]] = None,
                 iops: Optional[pulumi.Input[int]] = None,
                 raid_level: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] mount_point: The path to mount the EBS volume on the layer's instances.
        :param pulumi.Input[int] number_of_disks: The number of disks to use for the EBS volume.
        :param pulumi.Input[int] size: The size of the volume in gigabytes.
        :param pulumi.Input[int] iops: For PIOPS volumes, the IOPS per disk.
        :param pulumi.Input[str] raid_level: The RAID level to use for the volume.
        :param pulumi.Input[str] type: The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        pulumi.set(__self__, "mount_point", mount_point)
        pulumi.set(__self__, "number_of_disks", number_of_disks)
        pulumi.set(__self__, "size", size)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if raid_level is not None:
            pulumi.set(__self__, "raid_level", raid_level)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="mountPoint")
    def mount_point(self) -> pulumi.Input[str]:
        """
        The path to mount the EBS volume on the layer's instances.
        """
        return pulumi.get(self, "mount_point")

    @mount_point.setter
    def mount_point(self, value: pulumi.Input[str]):
        pulumi.set(self, "mount_point", value)

    @property
    @pulumi.getter(name="numberOfDisks")
    def number_of_disks(self) -> pulumi.Input[int]:
        """
        The number of disks to use for the EBS volume.
        """
        return pulumi.get(self, "number_of_disks")

    @number_of_disks.setter
    def number_of_disks(self, value: pulumi.Input[int]):
        pulumi.set(self, "number_of_disks", value)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[int]:
        """
        The size of the volume in gigabytes.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[int]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypted", value)

    @property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[int]]:
        """
        For PIOPS volumes, the IOPS per disk.
        """
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "iops", value)

    @property
    @pulumi.getter(name="raidLevel")
    def raid_level(self) -> Optional[pulumi.Input[str]]:
        """
        The RAID level to use for the volume.
        """
        return pulumi.get(self, "raid_level")

    @raid_level.setter
    def raid_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "raid_level", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class StackCustomCookbooksSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 url: pulumi.Input[str],
                 password: Optional[pulumi.Input[str]] = None,
                 revision: Optional[pulumi.Input[str]] = None,
                 ssh_key: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] type: The type of source to use. For example, "archive".
        :param pulumi.Input[str] url: The URL where the cookbooks resource can be found.
        :param pulumi.Input[str] password: Password to use when authenticating to the source. The provider cannot perform drift detection of this configuration.
        :param pulumi.Input[str] revision: For sources that are version-aware, the revision to use.
        :param pulumi.Input[str] ssh_key: SSH key to use when authenticating to the source. The provider cannot perform drift detection of this configuration.
        :param pulumi.Input[str] username: Username to use when authenticating to the source.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "url", url)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)
        if ssh_key is not None:
            pulumi.set(__self__, "ssh_key", ssh_key)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of source to use. For example, "archive".
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        The URL where the cookbooks resource can be found.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password to use when authenticating to the source. The provider cannot perform drift detection of this configuration.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def revision(self) -> Optional[pulumi.Input[str]]:
        """
        For sources that are version-aware, the revision to use.
        """
        return pulumi.get(self, "revision")

    @revision.setter
    def revision(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "revision", value)

    @property
    @pulumi.getter(name="sshKey")
    def ssh_key(self) -> Optional[pulumi.Input[str]]:
        """
        SSH key to use when authenticating to the source. The provider cannot perform drift detection of this configuration.
        """
        return pulumi.get(self, "ssh_key")

    @ssh_key.setter
    def ssh_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssh_key", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Username to use when authenticating to the source.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class StaticWebLayerEbsVolumeArgs:
    def __init__(__self__, *,
                 mount_point: pulumi.Input[str],
                 number_of_disks: pulumi.Input[int],
                 size: pulumi.Input[int],
                 encrypted: Optional[pulumi.Input[bool]] = None,
                 iops: Optional[pulumi.Input[int]] = None,
                 raid_level: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] mount_point: The path to mount the EBS volume on the layer's instances.
        :param pulumi.Input[int] number_of_disks: The number of disks to use for the EBS volume.
        :param pulumi.Input[int] size: The size of the volume in gigabytes.
        :param pulumi.Input[int] iops: For PIOPS volumes, the IOPS per disk.
        :param pulumi.Input[str] raid_level: The RAID level to use for the volume.
        :param pulumi.Input[str] type: The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        pulumi.set(__self__, "mount_point", mount_point)
        pulumi.set(__self__, "number_of_disks", number_of_disks)
        pulumi.set(__self__, "size", size)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if raid_level is not None:
            pulumi.set(__self__, "raid_level", raid_level)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="mountPoint")
    def mount_point(self) -> pulumi.Input[str]:
        """
        The path to mount the EBS volume on the layer's instances.
        """
        return pulumi.get(self, "mount_point")

    @mount_point.setter
    def mount_point(self, value: pulumi.Input[str]):
        pulumi.set(self, "mount_point", value)

    @property
    @pulumi.getter(name="numberOfDisks")
    def number_of_disks(self) -> pulumi.Input[int]:
        """
        The number of disks to use for the EBS volume.
        """
        return pulumi.get(self, "number_of_disks")

    @number_of_disks.setter
    def number_of_disks(self, value: pulumi.Input[int]):
        pulumi.set(self, "number_of_disks", value)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[int]:
        """
        The size of the volume in gigabytes.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[int]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypted", value)

    @property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[int]]:
        """
        For PIOPS volumes, the IOPS per disk.
        """
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "iops", value)

    @property
    @pulumi.getter(name="raidLevel")
    def raid_level(self) -> Optional[pulumi.Input[str]]:
        """
        The RAID level to use for the volume.
        """
        return pulumi.get(self, "raid_level")

    @raid_level.setter
    def raid_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "raid_level", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


