# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['AssociationArgs', 'Association']

@pulumi.input_type
class AssociationArgs:
    def __init__(__self__, *,
                 license_configuration_arn: pulumi.Input[str],
                 resource_arn: pulumi.Input[str]):
        """
        The set of arguments for constructing a Association resource.
        :param pulumi.Input[str] license_configuration_arn: ARN of the license configuration.
        :param pulumi.Input[str] resource_arn: ARN of the resource associated with the license configuration.
        """
        pulumi.set(__self__, "license_configuration_arn", license_configuration_arn)
        pulumi.set(__self__, "resource_arn", resource_arn)

    @property
    @pulumi.getter(name="licenseConfigurationArn")
    def license_configuration_arn(self) -> pulumi.Input[str]:
        """
        ARN of the license configuration.
        """
        return pulumi.get(self, "license_configuration_arn")

    @license_configuration_arn.setter
    def license_configuration_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "license_configuration_arn", value)

    @property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> pulumi.Input[str]:
        """
        ARN of the resource associated with the license configuration.
        """
        return pulumi.get(self, "resource_arn")

    @resource_arn.setter
    def resource_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_arn", value)


@pulumi.input_type
class _AssociationState:
    def __init__(__self__, *,
                 license_configuration_arn: Optional[pulumi.Input[str]] = None,
                 resource_arn: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Association resources.
        :param pulumi.Input[str] license_configuration_arn: ARN of the license configuration.
        :param pulumi.Input[str] resource_arn: ARN of the resource associated with the license configuration.
        """
        if license_configuration_arn is not None:
            pulumi.set(__self__, "license_configuration_arn", license_configuration_arn)
        if resource_arn is not None:
            pulumi.set(__self__, "resource_arn", resource_arn)

    @property
    @pulumi.getter(name="licenseConfigurationArn")
    def license_configuration_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the license configuration.
        """
        return pulumi.get(self, "license_configuration_arn")

    @license_configuration_arn.setter
    def license_configuration_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_configuration_arn", value)

    @property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the resource associated with the license configuration.
        """
        return pulumi.get(self, "resource_arn")

    @resource_arn.setter
    def resource_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_arn", value)


class Association(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 license_configuration_arn: Optional[pulumi.Input[str]] = None,
                 resource_arn: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a License Manager association.

        > **Note:** License configurations can also be associated with launch templates by specifying the `license_specifications` block for an `ec2.LaunchTemplate`.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example_ami = aws.ec2.get_ami(most_recent=True,
            owners=["amazon"],
            filters=[aws.ec2.GetAmiFilterArgs(
                name="name",
                values=["amzn-ami-vpc-nat*"],
            )])
        example_instance = aws.ec2.Instance("exampleInstance",
            ami=example_ami.id,
            instance_type="t2.micro")
        example_license_configuration = aws.licensemanager.LicenseConfiguration("exampleLicenseConfiguration", license_counting_type="Instance")
        example_association = aws.licensemanager.Association("exampleAssociation",
            license_configuration_arn=example_license_configuration.arn,
            resource_arn=example_instance.arn)
        ```

        ## Import

        License configurations can be imported in the form `resource_arn,license_configuration_arn`, e.g.

        ```sh
         $ pulumi import aws:licensemanager/association:Association example arn:aws:ec2:eu-west-1:123456789012:image/ami-123456789abcdef01,arn:aws:license-manager:eu-west-1:123456789012:license-configuration:lic-0123456789abcdef0123456789abcdef
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] license_configuration_arn: ARN of the license configuration.
        :param pulumi.Input[str] resource_arn: ARN of the resource associated with the license configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a License Manager association.

        > **Note:** License configurations can also be associated with launch templates by specifying the `license_specifications` block for an `ec2.LaunchTemplate`.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example_ami = aws.ec2.get_ami(most_recent=True,
            owners=["amazon"],
            filters=[aws.ec2.GetAmiFilterArgs(
                name="name",
                values=["amzn-ami-vpc-nat*"],
            )])
        example_instance = aws.ec2.Instance("exampleInstance",
            ami=example_ami.id,
            instance_type="t2.micro")
        example_license_configuration = aws.licensemanager.LicenseConfiguration("exampleLicenseConfiguration", license_counting_type="Instance")
        example_association = aws.licensemanager.Association("exampleAssociation",
            license_configuration_arn=example_license_configuration.arn,
            resource_arn=example_instance.arn)
        ```

        ## Import

        License configurations can be imported in the form `resource_arn,license_configuration_arn`, e.g.

        ```sh
         $ pulumi import aws:licensemanager/association:Association example arn:aws:ec2:eu-west-1:123456789012:image/ami-123456789abcdef01,arn:aws:license-manager:eu-west-1:123456789012:license-configuration:lic-0123456789abcdef0123456789abcdef
        ```

        :param str resource_name: The name of the resource.
        :param AssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 license_configuration_arn: Optional[pulumi.Input[str]] = None,
                 resource_arn: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AssociationArgs.__new__(AssociationArgs)

            if license_configuration_arn is None and not opts.urn:
                raise TypeError("Missing required property 'license_configuration_arn'")
            __props__.__dict__["license_configuration_arn"] = license_configuration_arn
            if resource_arn is None and not opts.urn:
                raise TypeError("Missing required property 'resource_arn'")
            __props__.__dict__["resource_arn"] = resource_arn
        super(Association, __self__).__init__(
            'aws:licensemanager/association:Association',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            license_configuration_arn: Optional[pulumi.Input[str]] = None,
            resource_arn: Optional[pulumi.Input[str]] = None) -> 'Association':
        """
        Get an existing Association resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] license_configuration_arn: ARN of the license configuration.
        :param pulumi.Input[str] resource_arn: ARN of the resource associated with the license configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AssociationState.__new__(_AssociationState)

        __props__.__dict__["license_configuration_arn"] = license_configuration_arn
        __props__.__dict__["resource_arn"] = resource_arn
        return Association(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="licenseConfigurationArn")
    def license_configuration_arn(self) -> pulumi.Output[str]:
        """
        ARN of the license configuration.
        """
        return pulumi.get(self, "license_configuration_arn")

    @property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> pulumi.Output[str]:
        """
        ARN of the resource associated with the license configuration.
        """
        return pulumi.get(self, "resource_arn")

