# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetDataLakeSettingsResult',
    'AwaitableGetDataLakeSettingsResult',
    'get_data_lake_settings',
]

@pulumi.output_type
class GetDataLakeSettingsResult:
    """
    A collection of values returned by getDataLakeSettings.
    """
    def __init__(__self__, admins=None, catalog_id=None, create_database_default_permissions=None, create_table_default_permissions=None, id=None, trusted_resource_owners=None):
        if admins and not isinstance(admins, list):
            raise TypeError("Expected argument 'admins' to be a list")
        pulumi.set(__self__, "admins", admins)
        if catalog_id and not isinstance(catalog_id, str):
            raise TypeError("Expected argument 'catalog_id' to be a str")
        pulumi.set(__self__, "catalog_id", catalog_id)
        if create_database_default_permissions and not isinstance(create_database_default_permissions, list):
            raise TypeError("Expected argument 'create_database_default_permissions' to be a list")
        pulumi.set(__self__, "create_database_default_permissions", create_database_default_permissions)
        if create_table_default_permissions and not isinstance(create_table_default_permissions, list):
            raise TypeError("Expected argument 'create_table_default_permissions' to be a list")
        pulumi.set(__self__, "create_table_default_permissions", create_table_default_permissions)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if trusted_resource_owners and not isinstance(trusted_resource_owners, list):
            raise TypeError("Expected argument 'trusted_resource_owners' to be a list")
        pulumi.set(__self__, "trusted_resource_owners", trusted_resource_owners)

    @property
    @pulumi.getter
    def admins(self) -> Sequence[str]:
        """
        List of ARNs of AWS Lake Formation principals (IAM users or roles).
        """
        return pulumi.get(self, "admins")

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[str]:
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter(name="createDatabaseDefaultPermissions")
    def create_database_default_permissions(self) -> Sequence['outputs.GetDataLakeSettingsCreateDatabaseDefaultPermissionResult']:
        """
        Up to three configuration blocks of principal permissions for default create database permissions. Detailed below.
        """
        return pulumi.get(self, "create_database_default_permissions")

    @property
    @pulumi.getter(name="createTableDefaultPermissions")
    def create_table_default_permissions(self) -> Sequence['outputs.GetDataLakeSettingsCreateTableDefaultPermissionResult']:
        """
        Up to three configuration blocks of principal permissions for default create table permissions. Detailed below.
        """
        return pulumi.get(self, "create_table_default_permissions")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="trustedResourceOwners")
    def trusted_resource_owners(self) -> Sequence[str]:
        """
        List of the resource-owning account IDs that the caller's account can use to share their user access details (user ARNs).
        """
        return pulumi.get(self, "trusted_resource_owners")


class AwaitableGetDataLakeSettingsResult(GetDataLakeSettingsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDataLakeSettingsResult(
            admins=self.admins,
            catalog_id=self.catalog_id,
            create_database_default_permissions=self.create_database_default_permissions,
            create_table_default_permissions=self.create_table_default_permissions,
            id=self.id,
            trusted_resource_owners=self.trusted_resource_owners)


def get_data_lake_settings(catalog_id: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDataLakeSettingsResult:
    """
    Get Lake Formation principals designated as data lake administrators and lists of principal permission entries for default create database and default create table permissions.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.lakeformation.get_data_lake_settings(catalog_id="14916253649")
    ```


    :param str catalog_id: Identifier for the Data Catalog. By default, the account ID.
    """
    __args__ = dict()
    __args__['catalogId'] = catalog_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws:lakeformation/getDataLakeSettings:getDataLakeSettings', __args__, opts=opts, typ=GetDataLakeSettingsResult).value

    return AwaitableGetDataLakeSettingsResult(
        admins=__ret__.admins,
        catalog_id=__ret__.catalog_id,
        create_database_default_permissions=__ret__.create_database_default_permissions,
        create_table_default_permissions=__ret__.create_table_default_permissions,
        id=__ret__.id,
        trusted_resource_owners=__ret__.trusted_resource_owners)
