# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetStreamConsumerResult',
    'AwaitableGetStreamConsumerResult',
    'get_stream_consumer',
]

@pulumi.output_type
class GetStreamConsumerResult:
    """
    A collection of values returned by getStreamConsumer.
    """
    def __init__(__self__, arn=None, creation_timestamp=None, id=None, name=None, status=None, stream_arn=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if creation_timestamp and not isinstance(creation_timestamp, str):
            raise TypeError("Expected argument 'creation_timestamp' to be a str")
        pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if stream_arn and not isinstance(stream_arn, str):
            raise TypeError("Expected argument 'stream_arn' to be a str")
        pulumi.set(__self__, "stream_arn", stream_arn)

    @property
    @pulumi.getter
    def arn(self) -> str:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> str:
        """
        Approximate timestamp in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) of when the stream consumer was created.
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The current status of the stream consumer.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="streamArn")
    def stream_arn(self) -> str:
        return pulumi.get(self, "stream_arn")


class AwaitableGetStreamConsumerResult(GetStreamConsumerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStreamConsumerResult(
            arn=self.arn,
            creation_timestamp=self.creation_timestamp,
            id=self.id,
            name=self.name,
            status=self.status,
            stream_arn=self.stream_arn)


def get_stream_consumer(arn: Optional[str] = None,
                        name: Optional[str] = None,
                        stream_arn: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStreamConsumerResult:
    """
    Provides details about a Kinesis Stream Consumer.

    For more details, see the [Amazon Kinesis Stream Consumer Documentation](https://docs.aws.amazon.com/streams/latest/dev/amazon-kinesis-consumers.html).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.kinesis.get_stream_consumer(name="example-consumer",
        stream_arn=aws_kinesis_stream["example"]["arn"])
    ```


    :param str arn: Amazon Resource Name (ARN) of the stream consumer.
    :param str name: Name of the stream consumer.
    :param str stream_arn: Amazon Resource Name (ARN) of the data stream the consumer is registered with.
    """
    __args__ = dict()
    __args__['arn'] = arn
    __args__['name'] = name
    __args__['streamArn'] = stream_arn
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws:kinesis/getStreamConsumer:getStreamConsumer', __args__, opts=opts, typ=GetStreamConsumerResult).value

    return AwaitableGetStreamConsumerResult(
        arn=__ret__.arn,
        creation_timestamp=__ret__.creation_timestamp,
        id=__ret__.id,
        name=__ret__.name,
        status=__ret__.status,
        stream_arn=__ret__.stream_arn)
