# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetGroupResult',
    'AwaitableGetGroupResult',
    'get_group',
]

@pulumi.output_type
class GetGroupResult:
    """
    A collection of values returned by getGroup.
    """
    def __init__(__self__, display_name=None, filters=None, group_id=None, id=None, identity_store_id=None):
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if group_id and not isinstance(group_id, str):
            raise TypeError("Expected argument 'group_id' to be a str")
        pulumi.set(__self__, "group_id", group_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identity_store_id and not isinstance(identity_store_id, str):
            raise TypeError("Expected argument 'identity_store_id' to be a str")
        pulumi.set(__self__, "identity_store_id", identity_store_id)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The group's display name value.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Sequence['outputs.GetGroupFilterResult']:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> str:
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="identityStoreId")
    def identity_store_id(self) -> str:
        return pulumi.get(self, "identity_store_id")


class AwaitableGetGroupResult(GetGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGroupResult(
            display_name=self.display_name,
            filters=self.filters,
            group_id=self.group_id,
            id=self.id,
            identity_store_id=self.identity_store_id)


def get_group(filters: Optional[Sequence[pulumi.InputType['GetGroupFilterArgs']]] = None,
              group_id: Optional[str] = None,
              identity_store_id: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGroupResult:
    """
    Use this data source to get an Identity Store Group.


    :param Sequence[pulumi.InputType['GetGroupFilterArgs']] filters: Configuration block(s) for filtering. Currently, the AWS Identity Store API supports only 1 filter. Detailed below.
    :param str group_id: The identifier for a group in the Identity Store.
    :param str identity_store_id: The Identity Store ID associated with the Single Sign-On Instance.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['groupId'] = group_id
    __args__['identityStoreId'] = identity_store_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws:identitystore/getGroup:getGroup', __args__, opts=opts, typ=GetGroupResult).value

    return AwaitableGetGroupResult(
        display_name=__ret__.display_name,
        filters=__ret__.filters,
        group_id=__ret__.group_id,
        id=__ret__.id,
        identity_store_id=__ret__.identity_store_id)
