# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'DetectorDatasources',
    'DetectorDatasourcesS3Logs',
    'FilterFindingCriteria',
    'FilterFindingCriteriaCriterion',
    'OrganizationConfigurationDatasources',
    'OrganizationConfigurationDatasourcesS3Logs',
]

@pulumi.output_type
class DetectorDatasources(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Logs":
            suggest = "s3_logs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorDatasources. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorDatasources.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorDatasources.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_logs: Optional['outputs.DetectorDatasourcesS3Logs'] = None):
        """
        :param 'DetectorDatasourcesS3LogsArgs' s3_logs: Describes whether S3 data event logs are enabled as a data source. See S3 Logs below for more details.
        """
        if s3_logs is not None:
            pulumi.set(__self__, "s3_logs", s3_logs)

    @property
    @pulumi.getter(name="s3Logs")
    def s3_logs(self) -> Optional['outputs.DetectorDatasourcesS3Logs']:
        """
        Describes whether S3 data event logs are enabled as a data source. See S3 Logs below for more details.
        """
        return pulumi.get(self, "s3_logs")


@pulumi.output_type
class DetectorDatasourcesS3Logs(dict):
    def __init__(__self__, *,
                 enable: bool):
        """
        :param bool enable: If true, enables [S3 Protection](https://docs.aws.amazon.com/guardduty/latest/ug/s3_detection.html). Defaults to `true`.
        """
        pulumi.set(__self__, "enable", enable)

    @property
    @pulumi.getter
    def enable(self) -> bool:
        """
        If true, enables [S3 Protection](https://docs.aws.amazon.com/guardduty/latest/ug/s3_detection.html). Defaults to `true`.
        """
        return pulumi.get(self, "enable")


@pulumi.output_type
class FilterFindingCriteria(dict):
    def __init__(__self__, *,
                 criterions: Sequence['outputs.FilterFindingCriteriaCriterion']):
        pulumi.set(__self__, "criterions", criterions)

    @property
    @pulumi.getter
    def criterions(self) -> Sequence['outputs.FilterFindingCriteriaCriterion']:
        return pulumi.get(self, "criterions")


@pulumi.output_type
class FilterFindingCriteriaCriterion(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "greaterThan":
            suggest = "greater_than"
        elif key == "greaterThanOrEqual":
            suggest = "greater_than_or_equal"
        elif key == "lessThan":
            suggest = "less_than"
        elif key == "lessThanOrEqual":
            suggest = "less_than_or_equal"
        elif key == "notEquals":
            suggest = "not_equals"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FilterFindingCriteriaCriterion. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FilterFindingCriteriaCriterion.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FilterFindingCriteriaCriterion.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field: str,
                 equals: Optional[Sequence[str]] = None,
                 greater_than: Optional[str] = None,
                 greater_than_or_equal: Optional[str] = None,
                 less_than: Optional[str] = None,
                 less_than_or_equal: Optional[str] = None,
                 not_equals: Optional[Sequence[str]] = None):
        """
        :param str field: The name of the field to be evaluated. The full list of field names can be found in [AWS documentation](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_filter-findings.html#filter_criteria).
        :param Sequence[str] equals: List of string values to be evaluated.
        :param str greater_than: A value to be evaluated. Accepts either an integer or a date in [RFC 3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        :param str greater_than_or_equal: A value to be evaluated. Accepts either an integer or a date in [RFC 3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        :param str less_than: A value to be evaluated. Accepts either an integer or a date in [RFC 3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        :param str less_than_or_equal: A value to be evaluated. Accepts either an integer or a date in [RFC 3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        :param Sequence[str] not_equals: List of string values to be evaluated.
        """
        pulumi.set(__self__, "field", field)
        if equals is not None:
            pulumi.set(__self__, "equals", equals)
        if greater_than is not None:
            pulumi.set(__self__, "greater_than", greater_than)
        if greater_than_or_equal is not None:
            pulumi.set(__self__, "greater_than_or_equal", greater_than_or_equal)
        if less_than is not None:
            pulumi.set(__self__, "less_than", less_than)
        if less_than_or_equal is not None:
            pulumi.set(__self__, "less_than_or_equal", less_than_or_equal)
        if not_equals is not None:
            pulumi.set(__self__, "not_equals", not_equals)

    @property
    @pulumi.getter
    def field(self) -> str:
        """
        The name of the field to be evaluated. The full list of field names can be found in [AWS documentation](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_filter-findings.html#filter_criteria).
        """
        return pulumi.get(self, "field")

    @property
    @pulumi.getter
    def equals(self) -> Optional[Sequence[str]]:
        """
        List of string values to be evaluated.
        """
        return pulumi.get(self, "equals")

    @property
    @pulumi.getter(name="greaterThan")
    def greater_than(self) -> Optional[str]:
        """
        A value to be evaluated. Accepts either an integer or a date in [RFC 3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        """
        return pulumi.get(self, "greater_than")

    @property
    @pulumi.getter(name="greaterThanOrEqual")
    def greater_than_or_equal(self) -> Optional[str]:
        """
        A value to be evaluated. Accepts either an integer or a date in [RFC 3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        """
        return pulumi.get(self, "greater_than_or_equal")

    @property
    @pulumi.getter(name="lessThan")
    def less_than(self) -> Optional[str]:
        """
        A value to be evaluated. Accepts either an integer or a date in [RFC 3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        """
        return pulumi.get(self, "less_than")

    @property
    @pulumi.getter(name="lessThanOrEqual")
    def less_than_or_equal(self) -> Optional[str]:
        """
        A value to be evaluated. Accepts either an integer or a date in [RFC 3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        """
        return pulumi.get(self, "less_than_or_equal")

    @property
    @pulumi.getter(name="notEquals")
    def not_equals(self) -> Optional[Sequence[str]]:
        """
        List of string values to be evaluated.
        """
        return pulumi.get(self, "not_equals")


@pulumi.output_type
class OrganizationConfigurationDatasources(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Logs":
            suggest = "s3_logs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrganizationConfigurationDatasources. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrganizationConfigurationDatasources.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrganizationConfigurationDatasources.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_logs: Optional['outputs.OrganizationConfigurationDatasourcesS3Logs'] = None):
        """
        :param 'OrganizationConfigurationDatasourcesS3LogsArgs' s3_logs: Configuration for the builds to store logs to S3.
        """
        if s3_logs is not None:
            pulumi.set(__self__, "s3_logs", s3_logs)

    @property
    @pulumi.getter(name="s3Logs")
    def s3_logs(self) -> Optional['outputs.OrganizationConfigurationDatasourcesS3Logs']:
        """
        Configuration for the builds to store logs to S3.
        """
        return pulumi.get(self, "s3_logs")


@pulumi.output_type
class OrganizationConfigurationDatasourcesS3Logs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoEnable":
            suggest = "auto_enable"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrganizationConfigurationDatasourcesS3Logs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrganizationConfigurationDatasourcesS3Logs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrganizationConfigurationDatasourcesS3Logs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_enable: bool):
        """
        :param bool auto_enable: When this setting is enabled, all new accounts that are created in, or added to, the organization are added as a member accounts of the organization’s GuardDuty delegated administrator and GuardDuty is enabled in that AWS Region.
        """
        pulumi.set(__self__, "auto_enable", auto_enable)

    @property
    @pulumi.getter(name="autoEnable")
    def auto_enable(self) -> bool:
        """
        When this setting is enabled, all new accounts that are created in, or added to, the organization are added as a member accounts of the organization’s GuardDuty delegated administrator and GuardDuty is enabled in that AWS Region.
        """
        return pulumi.get(self, "auto_enable")


