# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MLTransformArgs', 'MLTransform']

@pulumi.input_type
class MLTransformArgs:
    def __init__(__self__, *,
                 input_record_tables: pulumi.Input[Sequence[pulumi.Input['MLTransformInputRecordTableArgs']]],
                 parameters: pulumi.Input['MLTransformParametersArgs'],
                 role_arn: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 glue_version: Optional[pulumi.Input[str]] = None,
                 max_capacity: Optional[pulumi.Input[float]] = None,
                 max_retries: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 number_of_workers: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 worker_type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a MLTransform resource.
        :param pulumi.Input[Sequence[pulumi.Input['MLTransformInputRecordTableArgs']]] input_record_tables: A list of AWS Glue table definitions used by the transform. see Input Record Tables.
        :param pulumi.Input['MLTransformParametersArgs'] parameters: The algorithmic parameters that are specific to the transform type used. Conditionally dependent on the transform type. see Parameters.
        :param pulumi.Input[str] role_arn: The ARN of the IAM role associated with this ML Transform.
        :param pulumi.Input[str] description: Description of the ML Transform.
        :param pulumi.Input[str] glue_version: The version of glue to use, for example "1.0". For information about available versions, see the [AWS Glue Release Notes](https://docs.aws.amazon.com/glue/latest/dg/release-notes.html).
        :param pulumi.Input[float] max_capacity: The number of AWS Glue data processing units (DPUs) that are allocated to task runs for this transform. You can allocate from `2` to `100` DPUs; the default is `10`. `max_capacity` is a mutually exclusive option with `number_of_workers` and `worker_type`.
        :param pulumi.Input[int] max_retries: The maximum number of times to retry this ML Transform if it fails.
        :param pulumi.Input[str] name: The name you assign to this ML Transform. It must be unique in your account.
        :param pulumi.Input[int] number_of_workers: The number of workers of a defined `worker_type` that are allocated when an ML Transform runs. Required with `worker_type`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[int] timeout: The ML Transform timeout in minutes. The default is 2880 minutes (48 hours).
        :param pulumi.Input[str] worker_type: The type of predefined worker that is allocated when an ML Transform runs. Accepts a value of `Standard`, `G.1X`, or `G.2X`. Required with `number_of_workers`.
        """
        pulumi.set(__self__, "input_record_tables", input_record_tables)
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "role_arn", role_arn)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if glue_version is not None:
            pulumi.set(__self__, "glue_version", glue_version)
        if max_capacity is not None:
            pulumi.set(__self__, "max_capacity", max_capacity)
        if max_retries is not None:
            pulumi.set(__self__, "max_retries", max_retries)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if number_of_workers is not None:
            pulumi.set(__self__, "number_of_workers", number_of_workers)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if worker_type is not None:
            pulumi.set(__self__, "worker_type", worker_type)

    @property
    @pulumi.getter(name="inputRecordTables")
    def input_record_tables(self) -> pulumi.Input[Sequence[pulumi.Input['MLTransformInputRecordTableArgs']]]:
        """
        A list of AWS Glue table definitions used by the transform. see Input Record Tables.
        """
        return pulumi.get(self, "input_record_tables")

    @input_record_tables.setter
    def input_record_tables(self, value: pulumi.Input[Sequence[pulumi.Input['MLTransformInputRecordTableArgs']]]):
        pulumi.set(self, "input_record_tables", value)

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Input['MLTransformParametersArgs']:
        """
        The algorithmic parameters that are specific to the transform type used. Conditionally dependent on the transform type. see Parameters.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: pulumi.Input['MLTransformParametersArgs']):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the IAM role associated with this ML Transform.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the ML Transform.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="glueVersion")
    def glue_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of glue to use, for example "1.0". For information about available versions, see the [AWS Glue Release Notes](https://docs.aws.amazon.com/glue/latest/dg/release-notes.html).
        """
        return pulumi.get(self, "glue_version")

    @glue_version.setter
    def glue_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "glue_version", value)

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> Optional[pulumi.Input[float]]:
        """
        The number of AWS Glue data processing units (DPUs) that are allocated to task runs for this transform. You can allocate from `2` to `100` DPUs; the default is `10`. `max_capacity` is a mutually exclusive option with `number_of_workers` and `worker_type`.
        """
        return pulumi.get(self, "max_capacity")

    @max_capacity.setter
    def max_capacity(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "max_capacity", value)

    @property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of times to retry this ML Transform if it fails.
        """
        return pulumi.get(self, "max_retries")

    @max_retries.setter
    def max_retries(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_retries", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name you assign to this ML Transform. It must be unique in your account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="numberOfWorkers")
    def number_of_workers(self) -> Optional[pulumi.Input[int]]:
        """
        The number of workers of a defined `worker_type` that are allocated when an ML Transform runs. Required with `worker_type`.
        """
        return pulumi.get(self, "number_of_workers")

    @number_of_workers.setter
    def number_of_workers(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "number_of_workers", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The ML Transform timeout in minutes. The default is 2880 minutes (48 hours).
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter(name="workerType")
    def worker_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of predefined worker that is allocated when an ML Transform runs. Accepts a value of `Standard`, `G.1X`, or `G.2X`. Required with `number_of_workers`.
        """
        return pulumi.get(self, "worker_type")

    @worker_type.setter
    def worker_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "worker_type", value)


@pulumi.input_type
class _MLTransformState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 glue_version: Optional[pulumi.Input[str]] = None,
                 input_record_tables: Optional[pulumi.Input[Sequence[pulumi.Input['MLTransformInputRecordTableArgs']]]] = None,
                 label_count: Optional[pulumi.Input[int]] = None,
                 max_capacity: Optional[pulumi.Input[float]] = None,
                 max_retries: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 number_of_workers: Optional[pulumi.Input[int]] = None,
                 parameters: Optional[pulumi.Input['MLTransformParametersArgs']] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input['MLTransformSchemaArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 worker_type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering MLTransform resources.
        :param pulumi.Input[str] arn: Amazon Resource Name (ARN) of Glue ML Transform.
        :param pulumi.Input[str] description: Description of the ML Transform.
        :param pulumi.Input[str] glue_version: The version of glue to use, for example "1.0". For information about available versions, see the [AWS Glue Release Notes](https://docs.aws.amazon.com/glue/latest/dg/release-notes.html).
        :param pulumi.Input[Sequence[pulumi.Input['MLTransformInputRecordTableArgs']]] input_record_tables: A list of AWS Glue table definitions used by the transform. see Input Record Tables.
        :param pulumi.Input[int] label_count: The number of labels available for this transform.
        :param pulumi.Input[float] max_capacity: The number of AWS Glue data processing units (DPUs) that are allocated to task runs for this transform. You can allocate from `2` to `100` DPUs; the default is `10`. `max_capacity` is a mutually exclusive option with `number_of_workers` and `worker_type`.
        :param pulumi.Input[int] max_retries: The maximum number of times to retry this ML Transform if it fails.
        :param pulumi.Input[str] name: The name you assign to this ML Transform. It must be unique in your account.
        :param pulumi.Input[int] number_of_workers: The number of workers of a defined `worker_type` that are allocated when an ML Transform runs. Required with `worker_type`.
        :param pulumi.Input['MLTransformParametersArgs'] parameters: The algorithmic parameters that are specific to the transform type used. Conditionally dependent on the transform type. see Parameters.
        :param pulumi.Input[str] role_arn: The ARN of the IAM role associated with this ML Transform.
        :param pulumi.Input[Sequence[pulumi.Input['MLTransformSchemaArgs']]] schemas: The object that represents the schema that this transform accepts. see Schema.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[int] timeout: The ML Transform timeout in minutes. The default is 2880 minutes (48 hours).
        :param pulumi.Input[str] worker_type: The type of predefined worker that is allocated when an ML Transform runs. Accepts a value of `Standard`, `G.1X`, or `G.2X`. Required with `number_of_workers`.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if glue_version is not None:
            pulumi.set(__self__, "glue_version", glue_version)
        if input_record_tables is not None:
            pulumi.set(__self__, "input_record_tables", input_record_tables)
        if label_count is not None:
            pulumi.set(__self__, "label_count", label_count)
        if max_capacity is not None:
            pulumi.set(__self__, "max_capacity", max_capacity)
        if max_retries is not None:
            pulumi.set(__self__, "max_retries", max_retries)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if number_of_workers is not None:
            pulumi.set(__self__, "number_of_workers", number_of_workers)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if schemas is not None:
            pulumi.set(__self__, "schemas", schemas)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if worker_type is not None:
            pulumi.set(__self__, "worker_type", worker_type)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name (ARN) of Glue ML Transform.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the ML Transform.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="glueVersion")
    def glue_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of glue to use, for example "1.0". For information about available versions, see the [AWS Glue Release Notes](https://docs.aws.amazon.com/glue/latest/dg/release-notes.html).
        """
        return pulumi.get(self, "glue_version")

    @glue_version.setter
    def glue_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "glue_version", value)

    @property
    @pulumi.getter(name="inputRecordTables")
    def input_record_tables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MLTransformInputRecordTableArgs']]]]:
        """
        A list of AWS Glue table definitions used by the transform. see Input Record Tables.
        """
        return pulumi.get(self, "input_record_tables")

    @input_record_tables.setter
    def input_record_tables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MLTransformInputRecordTableArgs']]]]):
        pulumi.set(self, "input_record_tables", value)

    @property
    @pulumi.getter(name="labelCount")
    def label_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of labels available for this transform.
        """
        return pulumi.get(self, "label_count")

    @label_count.setter
    def label_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "label_count", value)

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> Optional[pulumi.Input[float]]:
        """
        The number of AWS Glue data processing units (DPUs) that are allocated to task runs for this transform. You can allocate from `2` to `100` DPUs; the default is `10`. `max_capacity` is a mutually exclusive option with `number_of_workers` and `worker_type`.
        """
        return pulumi.get(self, "max_capacity")

    @max_capacity.setter
    def max_capacity(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "max_capacity", value)

    @property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of times to retry this ML Transform if it fails.
        """
        return pulumi.get(self, "max_retries")

    @max_retries.setter
    def max_retries(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_retries", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name you assign to this ML Transform. It must be unique in your account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="numberOfWorkers")
    def number_of_workers(self) -> Optional[pulumi.Input[int]]:
        """
        The number of workers of a defined `worker_type` that are allocated when an ML Transform runs. Required with `worker_type`.
        """
        return pulumi.get(self, "number_of_workers")

    @number_of_workers.setter
    def number_of_workers(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "number_of_workers", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input['MLTransformParametersArgs']]:
        """
        The algorithmic parameters that are specific to the transform type used. Conditionally dependent on the transform type. see Parameters.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input['MLTransformParametersArgs']]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the IAM role associated with this ML Transform.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter
    def schemas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MLTransformSchemaArgs']]]]:
        """
        The object that represents the schema that this transform accepts. see Schema.
        """
        return pulumi.get(self, "schemas")

    @schemas.setter
    def schemas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MLTransformSchemaArgs']]]]):
        pulumi.set(self, "schemas", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The ML Transform timeout in minutes. The default is 2880 minutes (48 hours).
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter(name="workerType")
    def worker_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of predefined worker that is allocated when an ML Transform runs. Accepts a value of `Standard`, `G.1X`, or `G.2X`. Required with `number_of_workers`.
        """
        return pulumi.get(self, "worker_type")

    @worker_type.setter
    def worker_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "worker_type", value)


class MLTransform(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 glue_version: Optional[pulumi.Input[str]] = None,
                 input_record_tables: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MLTransformInputRecordTableArgs']]]]] = None,
                 max_capacity: Optional[pulumi.Input[float]] = None,
                 max_retries: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 number_of_workers: Optional[pulumi.Input[int]] = None,
                 parameters: Optional[pulumi.Input[pulumi.InputType['MLTransformParametersArgs']]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 worker_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Glue ML Transform resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test_catalog_database = aws.glue.CatalogDatabase("testCatalogDatabase", name="example")
        test_catalog_table = aws.glue.CatalogTable("testCatalogTable",
            name="example",
            database_name=test_catalog_database.name,
            owner="my_owner",
            retention=1,
            table_type="VIRTUAL_VIEW",
            view_expanded_text="view_expanded_text_1",
            view_original_text="view_original_text_1",
            storage_descriptor=aws.glue.CatalogTableStorageDescriptorArgs(
                bucket_columns=["bucket_column_1"],
                compressed=False,
                input_format="SequenceFileInputFormat",
                location="my_location",
                number_of_buckets=1,
                output_format="SequenceFileInputFormat",
                stored_as_sub_directories=False,
                parameters={
                    "param1": "param1_val",
                },
                columns=[
                    aws.glue.CatalogTableStorageDescriptorColumnArgs(
                        name="my_column_1",
                        type="int",
                        comment="my_column1_comment",
                    ),
                    aws.glue.CatalogTableStorageDescriptorColumnArgs(
                        name="my_column_2",
                        type="string",
                        comment="my_column2_comment",
                    ),
                ],
                ser_de_info=aws.glue.CatalogTableStorageDescriptorSerDeInfoArgs(
                    name="ser_de_name",
                    parameters={
                        "param1": "param_val_1",
                    },
                    serialization_library="org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe",
                ),
                sort_columns=[aws.glue.CatalogTableStorageDescriptorSortColumnArgs(
                    column="my_column_1",
                    sort_order=1,
                )],
                skewed_info=aws.glue.CatalogTableStorageDescriptorSkewedInfoArgs(
                    skewed_column_names=["my_column_1"],
                    skewed_column_value_location_maps={
                        "my_column_1": "my_column_1_val_loc_map",
                    },
                    skewed_column_values=["skewed_val_1"],
                ),
            ),
            partition_keys=[
                aws.glue.CatalogTablePartitionKeyArgs(
                    name="my_column_1",
                    type="int",
                    comment="my_column_1_comment",
                ),
                aws.glue.CatalogTablePartitionKeyArgs(
                    name="my_column_2",
                    type="string",
                    comment="my_column_2_comment",
                ),
            ],
            parameters={
                "param1": "param1_val",
            })
        test_ml_transform = aws.glue.MLTransform("testMLTransform",
            role_arn=aws_iam_role["test"]["arn"],
            input_record_tables=[aws.glue.MLTransformInputRecordTableArgs(
                database_name=test_catalog_table.database_name,
                table_name=test_catalog_table.name,
            )],
            parameters=aws.glue.MLTransformParametersArgs(
                transform_type="FIND_MATCHES",
                find_matches_parameters=aws.glue.MLTransformParametersFindMatchesParametersArgs(
                    primary_key_column_name="my_column_1",
                ),
            ),
            opts=pulumi.ResourceOptions(depends_on=[aws_iam_role_policy_attachment["test"]]))
        ```

        ## Import

        Glue ML Transforms can be imported using `id`, e.g.

        ```sh
         $ pulumi import aws:glue/mLTransform:MLTransform example tfm-c2cafbe83b1c575f49eaca9939220e2fcd58e2d5
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description of the ML Transform.
        :param pulumi.Input[str] glue_version: The version of glue to use, for example "1.0". For information about available versions, see the [AWS Glue Release Notes](https://docs.aws.amazon.com/glue/latest/dg/release-notes.html).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MLTransformInputRecordTableArgs']]]] input_record_tables: A list of AWS Glue table definitions used by the transform. see Input Record Tables.
        :param pulumi.Input[float] max_capacity: The number of AWS Glue data processing units (DPUs) that are allocated to task runs for this transform. You can allocate from `2` to `100` DPUs; the default is `10`. `max_capacity` is a mutually exclusive option with `number_of_workers` and `worker_type`.
        :param pulumi.Input[int] max_retries: The maximum number of times to retry this ML Transform if it fails.
        :param pulumi.Input[str] name: The name you assign to this ML Transform. It must be unique in your account.
        :param pulumi.Input[int] number_of_workers: The number of workers of a defined `worker_type` that are allocated when an ML Transform runs. Required with `worker_type`.
        :param pulumi.Input[pulumi.InputType['MLTransformParametersArgs']] parameters: The algorithmic parameters that are specific to the transform type used. Conditionally dependent on the transform type. see Parameters.
        :param pulumi.Input[str] role_arn: The ARN of the IAM role associated with this ML Transform.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[int] timeout: The ML Transform timeout in minutes. The default is 2880 minutes (48 hours).
        :param pulumi.Input[str] worker_type: The type of predefined worker that is allocated when an ML Transform runs. Accepts a value of `Standard`, `G.1X`, or `G.2X`. Required with `number_of_workers`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MLTransformArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Glue ML Transform resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test_catalog_database = aws.glue.CatalogDatabase("testCatalogDatabase", name="example")
        test_catalog_table = aws.glue.CatalogTable("testCatalogTable",
            name="example",
            database_name=test_catalog_database.name,
            owner="my_owner",
            retention=1,
            table_type="VIRTUAL_VIEW",
            view_expanded_text="view_expanded_text_1",
            view_original_text="view_original_text_1",
            storage_descriptor=aws.glue.CatalogTableStorageDescriptorArgs(
                bucket_columns=["bucket_column_1"],
                compressed=False,
                input_format="SequenceFileInputFormat",
                location="my_location",
                number_of_buckets=1,
                output_format="SequenceFileInputFormat",
                stored_as_sub_directories=False,
                parameters={
                    "param1": "param1_val",
                },
                columns=[
                    aws.glue.CatalogTableStorageDescriptorColumnArgs(
                        name="my_column_1",
                        type="int",
                        comment="my_column1_comment",
                    ),
                    aws.glue.CatalogTableStorageDescriptorColumnArgs(
                        name="my_column_2",
                        type="string",
                        comment="my_column2_comment",
                    ),
                ],
                ser_de_info=aws.glue.CatalogTableStorageDescriptorSerDeInfoArgs(
                    name="ser_de_name",
                    parameters={
                        "param1": "param_val_1",
                    },
                    serialization_library="org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe",
                ),
                sort_columns=[aws.glue.CatalogTableStorageDescriptorSortColumnArgs(
                    column="my_column_1",
                    sort_order=1,
                )],
                skewed_info=aws.glue.CatalogTableStorageDescriptorSkewedInfoArgs(
                    skewed_column_names=["my_column_1"],
                    skewed_column_value_location_maps={
                        "my_column_1": "my_column_1_val_loc_map",
                    },
                    skewed_column_values=["skewed_val_1"],
                ),
            ),
            partition_keys=[
                aws.glue.CatalogTablePartitionKeyArgs(
                    name="my_column_1",
                    type="int",
                    comment="my_column_1_comment",
                ),
                aws.glue.CatalogTablePartitionKeyArgs(
                    name="my_column_2",
                    type="string",
                    comment="my_column_2_comment",
                ),
            ],
            parameters={
                "param1": "param1_val",
            })
        test_ml_transform = aws.glue.MLTransform("testMLTransform",
            role_arn=aws_iam_role["test"]["arn"],
            input_record_tables=[aws.glue.MLTransformInputRecordTableArgs(
                database_name=test_catalog_table.database_name,
                table_name=test_catalog_table.name,
            )],
            parameters=aws.glue.MLTransformParametersArgs(
                transform_type="FIND_MATCHES",
                find_matches_parameters=aws.glue.MLTransformParametersFindMatchesParametersArgs(
                    primary_key_column_name="my_column_1",
                ),
            ),
            opts=pulumi.ResourceOptions(depends_on=[aws_iam_role_policy_attachment["test"]]))
        ```

        ## Import

        Glue ML Transforms can be imported using `id`, e.g.

        ```sh
         $ pulumi import aws:glue/mLTransform:MLTransform example tfm-c2cafbe83b1c575f49eaca9939220e2fcd58e2d5
        ```

        :param str resource_name: The name of the resource.
        :param MLTransformArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MLTransformArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 glue_version: Optional[pulumi.Input[str]] = None,
                 input_record_tables: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MLTransformInputRecordTableArgs']]]]] = None,
                 max_capacity: Optional[pulumi.Input[float]] = None,
                 max_retries: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 number_of_workers: Optional[pulumi.Input[int]] = None,
                 parameters: Optional[pulumi.Input[pulumi.InputType['MLTransformParametersArgs']]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 worker_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MLTransformArgs.__new__(MLTransformArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["glue_version"] = glue_version
            if input_record_tables is None and not opts.urn:
                raise TypeError("Missing required property 'input_record_tables'")
            __props__.__dict__["input_record_tables"] = input_record_tables
            __props__.__dict__["max_capacity"] = max_capacity
            __props__.__dict__["max_retries"] = max_retries
            __props__.__dict__["name"] = name
            __props__.__dict__["number_of_workers"] = number_of_workers
            if parameters is None and not opts.urn:
                raise TypeError("Missing required property 'parameters'")
            __props__.__dict__["parameters"] = parameters
            if role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'role_arn'")
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tags_all"] = tags_all
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["worker_type"] = worker_type
            __props__.__dict__["arn"] = None
            __props__.__dict__["label_count"] = None
            __props__.__dict__["schemas"] = None
        super(MLTransform, __self__).__init__(
            'aws:glue/mLTransform:MLTransform',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            glue_version: Optional[pulumi.Input[str]] = None,
            input_record_tables: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MLTransformInputRecordTableArgs']]]]] = None,
            label_count: Optional[pulumi.Input[int]] = None,
            max_capacity: Optional[pulumi.Input[float]] = None,
            max_retries: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            number_of_workers: Optional[pulumi.Input[int]] = None,
            parameters: Optional[pulumi.Input[pulumi.InputType['MLTransformParametersArgs']]] = None,
            role_arn: Optional[pulumi.Input[str]] = None,
            schemas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MLTransformSchemaArgs']]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            timeout: Optional[pulumi.Input[int]] = None,
            worker_type: Optional[pulumi.Input[str]] = None) -> 'MLTransform':
        """
        Get an existing MLTransform resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: Amazon Resource Name (ARN) of Glue ML Transform.
        :param pulumi.Input[str] description: Description of the ML Transform.
        :param pulumi.Input[str] glue_version: The version of glue to use, for example "1.0". For information about available versions, see the [AWS Glue Release Notes](https://docs.aws.amazon.com/glue/latest/dg/release-notes.html).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MLTransformInputRecordTableArgs']]]] input_record_tables: A list of AWS Glue table definitions used by the transform. see Input Record Tables.
        :param pulumi.Input[int] label_count: The number of labels available for this transform.
        :param pulumi.Input[float] max_capacity: The number of AWS Glue data processing units (DPUs) that are allocated to task runs for this transform. You can allocate from `2` to `100` DPUs; the default is `10`. `max_capacity` is a mutually exclusive option with `number_of_workers` and `worker_type`.
        :param pulumi.Input[int] max_retries: The maximum number of times to retry this ML Transform if it fails.
        :param pulumi.Input[str] name: The name you assign to this ML Transform. It must be unique in your account.
        :param pulumi.Input[int] number_of_workers: The number of workers of a defined `worker_type` that are allocated when an ML Transform runs. Required with `worker_type`.
        :param pulumi.Input[pulumi.InputType['MLTransformParametersArgs']] parameters: The algorithmic parameters that are specific to the transform type used. Conditionally dependent on the transform type. see Parameters.
        :param pulumi.Input[str] role_arn: The ARN of the IAM role associated with this ML Transform.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MLTransformSchemaArgs']]]] schemas: The object that represents the schema that this transform accepts. see Schema.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[int] timeout: The ML Transform timeout in minutes. The default is 2880 minutes (48 hours).
        :param pulumi.Input[str] worker_type: The type of predefined worker that is allocated when an ML Transform runs. Accepts a value of `Standard`, `G.1X`, or `G.2X`. Required with `number_of_workers`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MLTransformState.__new__(_MLTransformState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["description"] = description
        __props__.__dict__["glue_version"] = glue_version
        __props__.__dict__["input_record_tables"] = input_record_tables
        __props__.__dict__["label_count"] = label_count
        __props__.__dict__["max_capacity"] = max_capacity
        __props__.__dict__["max_retries"] = max_retries
        __props__.__dict__["name"] = name
        __props__.__dict__["number_of_workers"] = number_of_workers
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["role_arn"] = role_arn
        __props__.__dict__["schemas"] = schemas
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timeout"] = timeout
        __props__.__dict__["worker_type"] = worker_type
        return MLTransform(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        Amazon Resource Name (ARN) of Glue ML Transform.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the ML Transform.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="glueVersion")
    def glue_version(self) -> pulumi.Output[str]:
        """
        The version of glue to use, for example "1.0". For information about available versions, see the [AWS Glue Release Notes](https://docs.aws.amazon.com/glue/latest/dg/release-notes.html).
        """
        return pulumi.get(self, "glue_version")

    @property
    @pulumi.getter(name="inputRecordTables")
    def input_record_tables(self) -> pulumi.Output[Sequence['outputs.MLTransformInputRecordTable']]:
        """
        A list of AWS Glue table definitions used by the transform. see Input Record Tables.
        """
        return pulumi.get(self, "input_record_tables")

    @property
    @pulumi.getter(name="labelCount")
    def label_count(self) -> pulumi.Output[int]:
        """
        The number of labels available for this transform.
        """
        return pulumi.get(self, "label_count")

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> pulumi.Output[float]:
        """
        The number of AWS Glue data processing units (DPUs) that are allocated to task runs for this transform. You can allocate from `2` to `100` DPUs; the default is `10`. `max_capacity` is a mutually exclusive option with `number_of_workers` and `worker_type`.
        """
        return pulumi.get(self, "max_capacity")

    @property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum number of times to retry this ML Transform if it fails.
        """
        return pulumi.get(self, "max_retries")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name you assign to this ML Transform. It must be unique in your account.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="numberOfWorkers")
    def number_of_workers(self) -> pulumi.Output[Optional[int]]:
        """
        The number of workers of a defined `worker_type` that are allocated when an ML Transform runs. Required with `worker_type`.
        """
        return pulumi.get(self, "number_of_workers")

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Output['outputs.MLTransformParameters']:
        """
        The algorithmic parameters that are specific to the transform type used. Conditionally dependent on the transform type. see Parameters.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[str]:
        """
        The ARN of the IAM role associated with this ML Transform.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def schemas(self) -> pulumi.Output[Sequence['outputs.MLTransformSchema']]:
        """
        The object that represents the schema that this transform accepts. see Schema.
        """
        return pulumi.get(self, "schemas")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[Optional[int]]:
        """
        The ML Transform timeout in minutes. The default is 2880 minutes (48 hours).
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter(name="workerType")
    def worker_type(self) -> pulumi.Output[Optional[str]]:
        """
        The type of predefined worker that is allocated when an ML Transform runs. Accepts a value of `Standard`, `G.1X`, or `G.2X`. Required with `number_of_workers`.
        """
        return pulumi.get(self, "worker_type")

