# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CatalogTableArgs', 'CatalogTable']

@pulumi.input_type
class CatalogTableArgs:
    def __init__(__self__, *,
                 database_name: pulumi.Input[str],
                 catalog_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 owner: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 partition_indices: Optional[pulumi.Input[Sequence[pulumi.Input['CatalogTablePartitionIndexArgs']]]] = None,
                 partition_keys: Optional[pulumi.Input[Sequence[pulumi.Input['CatalogTablePartitionKeyArgs']]]] = None,
                 retention: Optional[pulumi.Input[int]] = None,
                 storage_descriptor: Optional[pulumi.Input['CatalogTableStorageDescriptorArgs']] = None,
                 table_type: Optional[pulumi.Input[str]] = None,
                 target_table: Optional[pulumi.Input['CatalogTableTargetTableArgs']] = None,
                 view_expanded_text: Optional[pulumi.Input[str]] = None,
                 view_original_text: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a CatalogTable resource.
        :param pulumi.Input[str] database_name: Name of the catalog database that contains the target table.
        :param pulumi.Input[str] catalog_id: ID of the Data Catalog in which the table resides.
        :param pulumi.Input[str] description: Description of the table.
        :param pulumi.Input[str] name: Name of the target table.
        :param pulumi.Input[str] owner: Owner of the table.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] parameters: Map of initialization parameters for the SerDe, in key-value form.
        :param pulumi.Input[Sequence[pulumi.Input['CatalogTablePartitionIndexArgs']]] partition_indices: Configuration block for a maximum of 3 partition indexes. See `partition_index` below.
        :param pulumi.Input[Sequence[pulumi.Input['CatalogTablePartitionKeyArgs']]] partition_keys: Configuration block of columns by which the table is partitioned. Only primitive types are supported as partition keys. See `partition_keys` below.
        :param pulumi.Input[int] retention: Retention time for this table.
        :param pulumi.Input['CatalogTableStorageDescriptorArgs'] storage_descriptor: Configuration block for information about the physical storage of this table. For more information, refer to the [Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-StorageDescriptor). See `storage_descriptor` below.
        :param pulumi.Input[str] table_type: Type of this table (EXTERNAL_TABLE, VIRTUAL_VIEW, etc.). While optional, some Athena DDL queries such as `ALTER TABLE` and `SHOW CREATE TABLE` will fail if this argument is empty.
        :param pulumi.Input['CatalogTableTargetTableArgs'] target_table: Configuration block of a target table for resource linking. See `target_table` below.
        :param pulumi.Input[str] view_expanded_text: If the table is a view, the expanded text of the view; otherwise null.
        :param pulumi.Input[str] view_original_text: If the table is a view, the original text of the view; otherwise null.
        """
        pulumi.set(__self__, "database_name", database_name)
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if partition_indices is not None:
            pulumi.set(__self__, "partition_indices", partition_indices)
        if partition_keys is not None:
            pulumi.set(__self__, "partition_keys", partition_keys)
        if retention is not None:
            pulumi.set(__self__, "retention", retention)
        if storage_descriptor is not None:
            pulumi.set(__self__, "storage_descriptor", storage_descriptor)
        if table_type is not None:
            pulumi.set(__self__, "table_type", table_type)
        if target_table is not None:
            pulumi.set(__self__, "target_table", target_table)
        if view_expanded_text is not None:
            pulumi.set(__self__, "view_expanded_text", view_expanded_text)
        if view_original_text is not None:
            pulumi.set(__self__, "view_original_text", view_original_text)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[str]:
        """
        Name of the catalog database that contains the target table.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the Data Catalog in which the table resides.
        """
        return pulumi.get(self, "catalog_id")

    @catalog_id.setter
    def catalog_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "catalog_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the table.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the target table.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[str]]:
        """
        Owner of the table.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of initialization parameters for the SerDe, in key-value form.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="partitionIndices")
    def partition_indices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CatalogTablePartitionIndexArgs']]]]:
        """
        Configuration block for a maximum of 3 partition indexes. See `partition_index` below.
        """
        return pulumi.get(self, "partition_indices")

    @partition_indices.setter
    def partition_indices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CatalogTablePartitionIndexArgs']]]]):
        pulumi.set(self, "partition_indices", value)

    @property
    @pulumi.getter(name="partitionKeys")
    def partition_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CatalogTablePartitionKeyArgs']]]]:
        """
        Configuration block of columns by which the table is partitioned. Only primitive types are supported as partition keys. See `partition_keys` below.
        """
        return pulumi.get(self, "partition_keys")

    @partition_keys.setter
    def partition_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CatalogTablePartitionKeyArgs']]]]):
        pulumi.set(self, "partition_keys", value)

    @property
    @pulumi.getter
    def retention(self) -> Optional[pulumi.Input[int]]:
        """
        Retention time for this table.
        """
        return pulumi.get(self, "retention")

    @retention.setter
    def retention(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retention", value)

    @property
    @pulumi.getter(name="storageDescriptor")
    def storage_descriptor(self) -> Optional[pulumi.Input['CatalogTableStorageDescriptorArgs']]:
        """
        Configuration block for information about the physical storage of this table. For more information, refer to the [Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-StorageDescriptor). See `storage_descriptor` below.
        """
        return pulumi.get(self, "storage_descriptor")

    @storage_descriptor.setter
    def storage_descriptor(self, value: Optional[pulumi.Input['CatalogTableStorageDescriptorArgs']]):
        pulumi.set(self, "storage_descriptor", value)

    @property
    @pulumi.getter(name="tableType")
    def table_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of this table (EXTERNAL_TABLE, VIRTUAL_VIEW, etc.). While optional, some Athena DDL queries such as `ALTER TABLE` and `SHOW CREATE TABLE` will fail if this argument is empty.
        """
        return pulumi.get(self, "table_type")

    @table_type.setter
    def table_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "table_type", value)

    @property
    @pulumi.getter(name="targetTable")
    def target_table(self) -> Optional[pulumi.Input['CatalogTableTargetTableArgs']]:
        """
        Configuration block of a target table for resource linking. See `target_table` below.
        """
        return pulumi.get(self, "target_table")

    @target_table.setter
    def target_table(self, value: Optional[pulumi.Input['CatalogTableTargetTableArgs']]):
        pulumi.set(self, "target_table", value)

    @property
    @pulumi.getter(name="viewExpandedText")
    def view_expanded_text(self) -> Optional[pulumi.Input[str]]:
        """
        If the table is a view, the expanded text of the view; otherwise null.
        """
        return pulumi.get(self, "view_expanded_text")

    @view_expanded_text.setter
    def view_expanded_text(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "view_expanded_text", value)

    @property
    @pulumi.getter(name="viewOriginalText")
    def view_original_text(self) -> Optional[pulumi.Input[str]]:
        """
        If the table is a view, the original text of the view; otherwise null.
        """
        return pulumi.get(self, "view_original_text")

    @view_original_text.setter
    def view_original_text(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "view_original_text", value)


@pulumi.input_type
class _CatalogTableState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 catalog_id: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 owner: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 partition_indices: Optional[pulumi.Input[Sequence[pulumi.Input['CatalogTablePartitionIndexArgs']]]] = None,
                 partition_keys: Optional[pulumi.Input[Sequence[pulumi.Input['CatalogTablePartitionKeyArgs']]]] = None,
                 retention: Optional[pulumi.Input[int]] = None,
                 storage_descriptor: Optional[pulumi.Input['CatalogTableStorageDescriptorArgs']] = None,
                 table_type: Optional[pulumi.Input[str]] = None,
                 target_table: Optional[pulumi.Input['CatalogTableTargetTableArgs']] = None,
                 view_expanded_text: Optional[pulumi.Input[str]] = None,
                 view_original_text: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering CatalogTable resources.
        :param pulumi.Input[str] arn: The ARN of the Glue Table.
        :param pulumi.Input[str] catalog_id: ID of the Data Catalog in which the table resides.
        :param pulumi.Input[str] database_name: Name of the catalog database that contains the target table.
        :param pulumi.Input[str] description: Description of the table.
        :param pulumi.Input[str] name: Name of the target table.
        :param pulumi.Input[str] owner: Owner of the table.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] parameters: Map of initialization parameters for the SerDe, in key-value form.
        :param pulumi.Input[Sequence[pulumi.Input['CatalogTablePartitionIndexArgs']]] partition_indices: Configuration block for a maximum of 3 partition indexes. See `partition_index` below.
        :param pulumi.Input[Sequence[pulumi.Input['CatalogTablePartitionKeyArgs']]] partition_keys: Configuration block of columns by which the table is partitioned. Only primitive types are supported as partition keys. See `partition_keys` below.
        :param pulumi.Input[int] retention: Retention time for this table.
        :param pulumi.Input['CatalogTableStorageDescriptorArgs'] storage_descriptor: Configuration block for information about the physical storage of this table. For more information, refer to the [Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-StorageDescriptor). See `storage_descriptor` below.
        :param pulumi.Input[str] table_type: Type of this table (EXTERNAL_TABLE, VIRTUAL_VIEW, etc.). While optional, some Athena DDL queries such as `ALTER TABLE` and `SHOW CREATE TABLE` will fail if this argument is empty.
        :param pulumi.Input['CatalogTableTargetTableArgs'] target_table: Configuration block of a target table for resource linking. See `target_table` below.
        :param pulumi.Input[str] view_expanded_text: If the table is a view, the expanded text of the view; otherwise null.
        :param pulumi.Input[str] view_original_text: If the table is a view, the original text of the view; otherwise null.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if partition_indices is not None:
            pulumi.set(__self__, "partition_indices", partition_indices)
        if partition_keys is not None:
            pulumi.set(__self__, "partition_keys", partition_keys)
        if retention is not None:
            pulumi.set(__self__, "retention", retention)
        if storage_descriptor is not None:
            pulumi.set(__self__, "storage_descriptor", storage_descriptor)
        if table_type is not None:
            pulumi.set(__self__, "table_type", table_type)
        if target_table is not None:
            pulumi.set(__self__, "target_table", target_table)
        if view_expanded_text is not None:
            pulumi.set(__self__, "view_expanded_text", view_expanded_text)
        if view_original_text is not None:
            pulumi.set(__self__, "view_original_text", view_original_text)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the Glue Table.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the Data Catalog in which the table resides.
        """
        return pulumi.get(self, "catalog_id")

    @catalog_id.setter
    def catalog_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "catalog_id", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the catalog database that contains the target table.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the table.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the target table.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[str]]:
        """
        Owner of the table.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of initialization parameters for the SerDe, in key-value form.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="partitionIndices")
    def partition_indices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CatalogTablePartitionIndexArgs']]]]:
        """
        Configuration block for a maximum of 3 partition indexes. See `partition_index` below.
        """
        return pulumi.get(self, "partition_indices")

    @partition_indices.setter
    def partition_indices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CatalogTablePartitionIndexArgs']]]]):
        pulumi.set(self, "partition_indices", value)

    @property
    @pulumi.getter(name="partitionKeys")
    def partition_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CatalogTablePartitionKeyArgs']]]]:
        """
        Configuration block of columns by which the table is partitioned. Only primitive types are supported as partition keys. See `partition_keys` below.
        """
        return pulumi.get(self, "partition_keys")

    @partition_keys.setter
    def partition_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CatalogTablePartitionKeyArgs']]]]):
        pulumi.set(self, "partition_keys", value)

    @property
    @pulumi.getter
    def retention(self) -> Optional[pulumi.Input[int]]:
        """
        Retention time for this table.
        """
        return pulumi.get(self, "retention")

    @retention.setter
    def retention(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retention", value)

    @property
    @pulumi.getter(name="storageDescriptor")
    def storage_descriptor(self) -> Optional[pulumi.Input['CatalogTableStorageDescriptorArgs']]:
        """
        Configuration block for information about the physical storage of this table. For more information, refer to the [Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-StorageDescriptor). See `storage_descriptor` below.
        """
        return pulumi.get(self, "storage_descriptor")

    @storage_descriptor.setter
    def storage_descriptor(self, value: Optional[pulumi.Input['CatalogTableStorageDescriptorArgs']]):
        pulumi.set(self, "storage_descriptor", value)

    @property
    @pulumi.getter(name="tableType")
    def table_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of this table (EXTERNAL_TABLE, VIRTUAL_VIEW, etc.). While optional, some Athena DDL queries such as `ALTER TABLE` and `SHOW CREATE TABLE` will fail if this argument is empty.
        """
        return pulumi.get(self, "table_type")

    @table_type.setter
    def table_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "table_type", value)

    @property
    @pulumi.getter(name="targetTable")
    def target_table(self) -> Optional[pulumi.Input['CatalogTableTargetTableArgs']]:
        """
        Configuration block of a target table for resource linking. See `target_table` below.
        """
        return pulumi.get(self, "target_table")

    @target_table.setter
    def target_table(self, value: Optional[pulumi.Input['CatalogTableTargetTableArgs']]):
        pulumi.set(self, "target_table", value)

    @property
    @pulumi.getter(name="viewExpandedText")
    def view_expanded_text(self) -> Optional[pulumi.Input[str]]:
        """
        If the table is a view, the expanded text of the view; otherwise null.
        """
        return pulumi.get(self, "view_expanded_text")

    @view_expanded_text.setter
    def view_expanded_text(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "view_expanded_text", value)

    @property
    @pulumi.getter(name="viewOriginalText")
    def view_original_text(self) -> Optional[pulumi.Input[str]]:
        """
        If the table is a view, the original text of the view; otherwise null.
        """
        return pulumi.get(self, "view_original_text")

    @view_original_text.setter
    def view_original_text(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "view_original_text", value)


class CatalogTable(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 catalog_id: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 owner: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 partition_indices: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CatalogTablePartitionIndexArgs']]]]] = None,
                 partition_keys: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CatalogTablePartitionKeyArgs']]]]] = None,
                 retention: Optional[pulumi.Input[int]] = None,
                 storage_descriptor: Optional[pulumi.Input[pulumi.InputType['CatalogTableStorageDescriptorArgs']]] = None,
                 table_type: Optional[pulumi.Input[str]] = None,
                 target_table: Optional[pulumi.Input[pulumi.InputType['CatalogTableTargetTableArgs']]] = None,
                 view_expanded_text: Optional[pulumi.Input[str]] = None,
                 view_original_text: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Glue Catalog Table Resource. You can refer to the [Glue Developer Guide](http://docs.aws.amazon.com/glue/latest/dg/populate-data-catalog.html) for a full explanation of the Glue Data Catalog functionality.

        ## Example Usage
        ### Basic Table

        ```python
        import pulumi
        import pulumi_aws as aws

        aws_glue_catalog_table = aws.glue.CatalogTable("awsGlueCatalogTable",
            database_name="MyCatalogDatabase",
            name="MyCatalogTable")
        ```
        ### Parquet Table for Athena

        ```python
        import pulumi
        import pulumi_aws as aws

        aws_glue_catalog_table = aws.glue.CatalogTable("awsGlueCatalogTable",
            database_name="MyCatalogDatabase",
            name="MyCatalogTable",
            parameters={
                "EXTERNAL": "TRUE",
                "parquet.compression": "SNAPPY",
            },
            storage_descriptor=aws.glue.CatalogTableStorageDescriptorArgs(
                columns=[
                    aws.glue.CatalogTableStorageDescriptorColumnArgs(
                        name="my_string",
                        type="string",
                    ),
                    aws.glue.CatalogTableStorageDescriptorColumnArgs(
                        name="my_double",
                        type="double",
                    ),
                    aws.glue.CatalogTableStorageDescriptorColumnArgs(
                        comment="",
                        name="my_date",
                        type="date",
                    ),
                    aws.glue.CatalogTableStorageDescriptorColumnArgs(
                        comment="",
                        name="my_bigint",
                        type="bigint",
                    ),
                    aws.glue.CatalogTableStorageDescriptorColumnArgs(
                        comment="",
                        name="my_struct",
                        type="struct<my_nested_string:string>",
                    ),
                ],
                input_format="org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat",
                location="s3://my-bucket/event-streams/my-stream",
                output_format="org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat",
                ser_de_info=aws.glue.CatalogTableStorageDescriptorSerDeInfoArgs(
                    name="my-stream",
                    parameters={
                        "serialization.format": "1",
                    },
                    serialization_library="org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe",
                ),
            ),
            table_type="EXTERNAL_TABLE")
        ```

        ## Import

        Glue Tables can be imported with their catalog ID (usually AWS account ID), database name, and table name, e.g.

        ```sh
         $ pulumi import aws:glue/catalogTable:CatalogTable MyTable 123456789012:MyDatabase:MyTable
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] catalog_id: ID of the Data Catalog in which the table resides.
        :param pulumi.Input[str] database_name: Name of the catalog database that contains the target table.
        :param pulumi.Input[str] description: Description of the table.
        :param pulumi.Input[str] name: Name of the target table.
        :param pulumi.Input[str] owner: Owner of the table.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] parameters: Map of initialization parameters for the SerDe, in key-value form.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CatalogTablePartitionIndexArgs']]]] partition_indices: Configuration block for a maximum of 3 partition indexes. See `partition_index` below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CatalogTablePartitionKeyArgs']]]] partition_keys: Configuration block of columns by which the table is partitioned. Only primitive types are supported as partition keys. See `partition_keys` below.
        :param pulumi.Input[int] retention: Retention time for this table.
        :param pulumi.Input[pulumi.InputType['CatalogTableStorageDescriptorArgs']] storage_descriptor: Configuration block for information about the physical storage of this table. For more information, refer to the [Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-StorageDescriptor). See `storage_descriptor` below.
        :param pulumi.Input[str] table_type: Type of this table (EXTERNAL_TABLE, VIRTUAL_VIEW, etc.). While optional, some Athena DDL queries such as `ALTER TABLE` and `SHOW CREATE TABLE` will fail if this argument is empty.
        :param pulumi.Input[pulumi.InputType['CatalogTableTargetTableArgs']] target_table: Configuration block of a target table for resource linking. See `target_table` below.
        :param pulumi.Input[str] view_expanded_text: If the table is a view, the expanded text of the view; otherwise null.
        :param pulumi.Input[str] view_original_text: If the table is a view, the original text of the view; otherwise null.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CatalogTableArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Glue Catalog Table Resource. You can refer to the [Glue Developer Guide](http://docs.aws.amazon.com/glue/latest/dg/populate-data-catalog.html) for a full explanation of the Glue Data Catalog functionality.

        ## Example Usage
        ### Basic Table

        ```python
        import pulumi
        import pulumi_aws as aws

        aws_glue_catalog_table = aws.glue.CatalogTable("awsGlueCatalogTable",
            database_name="MyCatalogDatabase",
            name="MyCatalogTable")
        ```
        ### Parquet Table for Athena

        ```python
        import pulumi
        import pulumi_aws as aws

        aws_glue_catalog_table = aws.glue.CatalogTable("awsGlueCatalogTable",
            database_name="MyCatalogDatabase",
            name="MyCatalogTable",
            parameters={
                "EXTERNAL": "TRUE",
                "parquet.compression": "SNAPPY",
            },
            storage_descriptor=aws.glue.CatalogTableStorageDescriptorArgs(
                columns=[
                    aws.glue.CatalogTableStorageDescriptorColumnArgs(
                        name="my_string",
                        type="string",
                    ),
                    aws.glue.CatalogTableStorageDescriptorColumnArgs(
                        name="my_double",
                        type="double",
                    ),
                    aws.glue.CatalogTableStorageDescriptorColumnArgs(
                        comment="",
                        name="my_date",
                        type="date",
                    ),
                    aws.glue.CatalogTableStorageDescriptorColumnArgs(
                        comment="",
                        name="my_bigint",
                        type="bigint",
                    ),
                    aws.glue.CatalogTableStorageDescriptorColumnArgs(
                        comment="",
                        name="my_struct",
                        type="struct<my_nested_string:string>",
                    ),
                ],
                input_format="org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat",
                location="s3://my-bucket/event-streams/my-stream",
                output_format="org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat",
                ser_de_info=aws.glue.CatalogTableStorageDescriptorSerDeInfoArgs(
                    name="my-stream",
                    parameters={
                        "serialization.format": "1",
                    },
                    serialization_library="org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe",
                ),
            ),
            table_type="EXTERNAL_TABLE")
        ```

        ## Import

        Glue Tables can be imported with their catalog ID (usually AWS account ID), database name, and table name, e.g.

        ```sh
         $ pulumi import aws:glue/catalogTable:CatalogTable MyTable 123456789012:MyDatabase:MyTable
        ```

        :param str resource_name: The name of the resource.
        :param CatalogTableArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CatalogTableArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 catalog_id: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 owner: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 partition_indices: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CatalogTablePartitionIndexArgs']]]]] = None,
                 partition_keys: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CatalogTablePartitionKeyArgs']]]]] = None,
                 retention: Optional[pulumi.Input[int]] = None,
                 storage_descriptor: Optional[pulumi.Input[pulumi.InputType['CatalogTableStorageDescriptorArgs']]] = None,
                 table_type: Optional[pulumi.Input[str]] = None,
                 target_table: Optional[pulumi.Input[pulumi.InputType['CatalogTableTargetTableArgs']]] = None,
                 view_expanded_text: Optional[pulumi.Input[str]] = None,
                 view_original_text: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CatalogTableArgs.__new__(CatalogTableArgs)

            __props__.__dict__["catalog_id"] = catalog_id
            if database_name is None and not opts.urn:
                raise TypeError("Missing required property 'database_name'")
            __props__.__dict__["database_name"] = database_name
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["owner"] = owner
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["partition_indices"] = partition_indices
            __props__.__dict__["partition_keys"] = partition_keys
            __props__.__dict__["retention"] = retention
            __props__.__dict__["storage_descriptor"] = storage_descriptor
            __props__.__dict__["table_type"] = table_type
            __props__.__dict__["target_table"] = target_table
            __props__.__dict__["view_expanded_text"] = view_expanded_text
            __props__.__dict__["view_original_text"] = view_original_text
            __props__.__dict__["arn"] = None
        super(CatalogTable, __self__).__init__(
            'aws:glue/catalogTable:CatalogTable',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            catalog_id: Optional[pulumi.Input[str]] = None,
            database_name: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            owner: Optional[pulumi.Input[str]] = None,
            parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            partition_indices: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CatalogTablePartitionIndexArgs']]]]] = None,
            partition_keys: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CatalogTablePartitionKeyArgs']]]]] = None,
            retention: Optional[pulumi.Input[int]] = None,
            storage_descriptor: Optional[pulumi.Input[pulumi.InputType['CatalogTableStorageDescriptorArgs']]] = None,
            table_type: Optional[pulumi.Input[str]] = None,
            target_table: Optional[pulumi.Input[pulumi.InputType['CatalogTableTargetTableArgs']]] = None,
            view_expanded_text: Optional[pulumi.Input[str]] = None,
            view_original_text: Optional[pulumi.Input[str]] = None) -> 'CatalogTable':
        """
        Get an existing CatalogTable resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: The ARN of the Glue Table.
        :param pulumi.Input[str] catalog_id: ID of the Data Catalog in which the table resides.
        :param pulumi.Input[str] database_name: Name of the catalog database that contains the target table.
        :param pulumi.Input[str] description: Description of the table.
        :param pulumi.Input[str] name: Name of the target table.
        :param pulumi.Input[str] owner: Owner of the table.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] parameters: Map of initialization parameters for the SerDe, in key-value form.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CatalogTablePartitionIndexArgs']]]] partition_indices: Configuration block for a maximum of 3 partition indexes. See `partition_index` below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CatalogTablePartitionKeyArgs']]]] partition_keys: Configuration block of columns by which the table is partitioned. Only primitive types are supported as partition keys. See `partition_keys` below.
        :param pulumi.Input[int] retention: Retention time for this table.
        :param pulumi.Input[pulumi.InputType['CatalogTableStorageDescriptorArgs']] storage_descriptor: Configuration block for information about the physical storage of this table. For more information, refer to the [Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-StorageDescriptor). See `storage_descriptor` below.
        :param pulumi.Input[str] table_type: Type of this table (EXTERNAL_TABLE, VIRTUAL_VIEW, etc.). While optional, some Athena DDL queries such as `ALTER TABLE` and `SHOW CREATE TABLE` will fail if this argument is empty.
        :param pulumi.Input[pulumi.InputType['CatalogTableTargetTableArgs']] target_table: Configuration block of a target table for resource linking. See `target_table` below.
        :param pulumi.Input[str] view_expanded_text: If the table is a view, the expanded text of the view; otherwise null.
        :param pulumi.Input[str] view_original_text: If the table is a view, the original text of the view; otherwise null.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CatalogTableState.__new__(_CatalogTableState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["catalog_id"] = catalog_id
        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["owner"] = owner
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["partition_indices"] = partition_indices
        __props__.__dict__["partition_keys"] = partition_keys
        __props__.__dict__["retention"] = retention
        __props__.__dict__["storage_descriptor"] = storage_descriptor
        __props__.__dict__["table_type"] = table_type
        __props__.__dict__["target_table"] = target_table
        __props__.__dict__["view_expanded_text"] = view_expanded_text
        __props__.__dict__["view_original_text"] = view_original_text
        return CatalogTable(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the Glue Table.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> pulumi.Output[str]:
        """
        ID of the Data Catalog in which the table resides.
        """
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[str]:
        """
        Name of the catalog database that contains the target table.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the table.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the target table.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def owner(self) -> pulumi.Output[Optional[str]]:
        """
        Owner of the table.
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Map of initialization parameters for the SerDe, in key-value form.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="partitionIndices")
    def partition_indices(self) -> pulumi.Output[Optional[Sequence['outputs.CatalogTablePartitionIndex']]]:
        """
        Configuration block for a maximum of 3 partition indexes. See `partition_index` below.
        """
        return pulumi.get(self, "partition_indices")

    @property
    @pulumi.getter(name="partitionKeys")
    def partition_keys(self) -> pulumi.Output[Optional[Sequence['outputs.CatalogTablePartitionKey']]]:
        """
        Configuration block of columns by which the table is partitioned. Only primitive types are supported as partition keys. See `partition_keys` below.
        """
        return pulumi.get(self, "partition_keys")

    @property
    @pulumi.getter
    def retention(self) -> pulumi.Output[Optional[int]]:
        """
        Retention time for this table.
        """
        return pulumi.get(self, "retention")

    @property
    @pulumi.getter(name="storageDescriptor")
    def storage_descriptor(self) -> pulumi.Output[Optional['outputs.CatalogTableStorageDescriptor']]:
        """
        Configuration block for information about the physical storage of this table. For more information, refer to the [Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-StorageDescriptor). See `storage_descriptor` below.
        """
        return pulumi.get(self, "storage_descriptor")

    @property
    @pulumi.getter(name="tableType")
    def table_type(self) -> pulumi.Output[Optional[str]]:
        """
        Type of this table (EXTERNAL_TABLE, VIRTUAL_VIEW, etc.). While optional, some Athena DDL queries such as `ALTER TABLE` and `SHOW CREATE TABLE` will fail if this argument is empty.
        """
        return pulumi.get(self, "table_type")

    @property
    @pulumi.getter(name="targetTable")
    def target_table(self) -> pulumi.Output[Optional['outputs.CatalogTableTargetTable']]:
        """
        Configuration block of a target table for resource linking. See `target_table` below.
        """
        return pulumi.get(self, "target_table")

    @property
    @pulumi.getter(name="viewExpandedText")
    def view_expanded_text(self) -> pulumi.Output[Optional[str]]:
        """
        If the table is a view, the expanded text of the view; otherwise null.
        """
        return pulumi.get(self, "view_expanded_text")

    @property
    @pulumi.getter(name="viewOriginalText")
    def view_original_text(self) -> pulumi.Output[Optional[str]]:
        """
        If the table is a view, the original text of the view; otherwise null.
        """
        return pulumi.get(self, "view_original_text")

