# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'ClusterBootstrapAction',
    'ClusterCoreInstanceFleet',
    'ClusterCoreInstanceFleetInstanceTypeConfig',
    'ClusterCoreInstanceFleetInstanceTypeConfigConfiguration',
    'ClusterCoreInstanceFleetInstanceTypeConfigEbsConfig',
    'ClusterCoreInstanceFleetLaunchSpecifications',
    'ClusterCoreInstanceFleetLaunchSpecificationsOnDemandSpecification',
    'ClusterCoreInstanceFleetLaunchSpecificationsSpotSpecification',
    'ClusterCoreInstanceGroup',
    'ClusterCoreInstanceGroupEbsConfig',
    'ClusterEc2Attributes',
    'ClusterKerberosAttributes',
    'ClusterMasterInstanceFleet',
    'ClusterMasterInstanceFleetInstanceTypeConfig',
    'ClusterMasterInstanceFleetInstanceTypeConfigConfiguration',
    'ClusterMasterInstanceFleetInstanceTypeConfigEbsConfig',
    'ClusterMasterInstanceFleetLaunchSpecifications',
    'ClusterMasterInstanceFleetLaunchSpecificationsOnDemandSpecification',
    'ClusterMasterInstanceFleetLaunchSpecificationsSpotSpecification',
    'ClusterMasterInstanceGroup',
    'ClusterMasterInstanceGroupEbsConfig',
    'ClusterStep',
    'ClusterStepHadoopJarStep',
    'InstanceFleetInstanceTypeConfig',
    'InstanceFleetInstanceTypeConfigConfiguration',
    'InstanceFleetInstanceTypeConfigEbsConfig',
    'InstanceFleetLaunchSpecifications',
    'InstanceFleetLaunchSpecificationsOnDemandSpecification',
    'InstanceFleetLaunchSpecificationsSpotSpecification',
    'InstanceGroupEbsConfig',
    'ManagedScalingPolicyComputeLimit',
]

@pulumi.output_type
class ClusterBootstrapAction(dict):
    def __init__(__self__, *,
                 name: str,
                 path: str,
                 args: Optional[Sequence[str]] = None):
        """
        :param str name: Friendly name given to the instance fleet.
        :param str path: Location of the script to run during a bootstrap action. Can be either a location in Amazon S3 or on a local file system
        :param Sequence[str] args: List of command line arguments passed to the JAR file's main function when executed.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)
        if args is not None:
            pulumi.set(__self__, "args", args)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Friendly name given to the instance fleet.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Location of the script to run during a bootstrap action. Can be either a location in Amazon S3 or on a local file system
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def args(self) -> Optional[Sequence[str]]:
        """
        List of command line arguments passed to the JAR file's main function when executed.
        """
        return pulumi.get(self, "args")


@pulumi.output_type
class ClusterCoreInstanceFleet(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceTypeConfigs":
            suggest = "instance_type_configs"
        elif key == "launchSpecifications":
            suggest = "launch_specifications"
        elif key == "provisionedOnDemandCapacity":
            suggest = "provisioned_on_demand_capacity"
        elif key == "provisionedSpotCapacity":
            suggest = "provisioned_spot_capacity"
        elif key == "targetOnDemandCapacity":
            suggest = "target_on_demand_capacity"
        elif key == "targetSpotCapacity":
            suggest = "target_spot_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCoreInstanceFleet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCoreInstanceFleet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCoreInstanceFleet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: Optional[str] = None,
                 instance_type_configs: Optional[Sequence['outputs.ClusterCoreInstanceFleetInstanceTypeConfig']] = None,
                 launch_specifications: Optional['outputs.ClusterCoreInstanceFleetLaunchSpecifications'] = None,
                 name: Optional[str] = None,
                 provisioned_on_demand_capacity: Optional[int] = None,
                 provisioned_spot_capacity: Optional[int] = None,
                 target_on_demand_capacity: Optional[int] = None,
                 target_spot_capacity: Optional[int] = None):
        """
        :param str id: The ID of the EMR Cluster
        :param Sequence['ClusterCoreInstanceFleetInstanceTypeConfigArgs'] instance_type_configs: Configuration block for instance fleet
        :param 'ClusterCoreInstanceFleetLaunchSpecificationsArgs' launch_specifications: Configuration block for launch specification
        :param str name: Friendly name given to the instance fleet.
        :param int target_on_demand_capacity: The target capacity of On-Demand units for the instance fleet, which determines how many On-Demand instances to provision.
        :param int target_spot_capacity: The target capacity of Spot units for the instance fleet, which determines how many Spot instances to provision.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if instance_type_configs is not None:
            pulumi.set(__self__, "instance_type_configs", instance_type_configs)
        if launch_specifications is not None:
            pulumi.set(__self__, "launch_specifications", launch_specifications)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if provisioned_on_demand_capacity is not None:
            pulumi.set(__self__, "provisioned_on_demand_capacity", provisioned_on_demand_capacity)
        if provisioned_spot_capacity is not None:
            pulumi.set(__self__, "provisioned_spot_capacity", provisioned_spot_capacity)
        if target_on_demand_capacity is not None:
            pulumi.set(__self__, "target_on_demand_capacity", target_on_demand_capacity)
        if target_spot_capacity is not None:
            pulumi.set(__self__, "target_spot_capacity", target_spot_capacity)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The ID of the EMR Cluster
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceTypeConfigs")
    def instance_type_configs(self) -> Optional[Sequence['outputs.ClusterCoreInstanceFleetInstanceTypeConfig']]:
        """
        Configuration block for instance fleet
        """
        return pulumi.get(self, "instance_type_configs")

    @property
    @pulumi.getter(name="launchSpecifications")
    def launch_specifications(self) -> Optional['outputs.ClusterCoreInstanceFleetLaunchSpecifications']:
        """
        Configuration block for launch specification
        """
        return pulumi.get(self, "launch_specifications")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Friendly name given to the instance fleet.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisionedOnDemandCapacity")
    def provisioned_on_demand_capacity(self) -> Optional[int]:
        return pulumi.get(self, "provisioned_on_demand_capacity")

    @property
    @pulumi.getter(name="provisionedSpotCapacity")
    def provisioned_spot_capacity(self) -> Optional[int]:
        return pulumi.get(self, "provisioned_spot_capacity")

    @property
    @pulumi.getter(name="targetOnDemandCapacity")
    def target_on_demand_capacity(self) -> Optional[int]:
        """
        The target capacity of On-Demand units for the instance fleet, which determines how many On-Demand instances to provision.
        """
        return pulumi.get(self, "target_on_demand_capacity")

    @property
    @pulumi.getter(name="targetSpotCapacity")
    def target_spot_capacity(self) -> Optional[int]:
        """
        The target capacity of Spot units for the instance fleet, which determines how many Spot instances to provision.
        """
        return pulumi.get(self, "target_spot_capacity")


@pulumi.output_type
class ClusterCoreInstanceFleetInstanceTypeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "bidPrice":
            suggest = "bid_price"
        elif key == "bidPriceAsPercentageOfOnDemandPrice":
            suggest = "bid_price_as_percentage_of_on_demand_price"
        elif key == "ebsConfigs":
            suggest = "ebs_configs"
        elif key == "weightedCapacity":
            suggest = "weighted_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCoreInstanceFleetInstanceTypeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCoreInstanceFleetInstanceTypeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCoreInstanceFleetInstanceTypeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: str,
                 bid_price: Optional[str] = None,
                 bid_price_as_percentage_of_on_demand_price: Optional[float] = None,
                 configurations: Optional[Sequence['outputs.ClusterCoreInstanceFleetInstanceTypeConfigConfiguration']] = None,
                 ebs_configs: Optional[Sequence['outputs.ClusterCoreInstanceFleetInstanceTypeConfigEbsConfig']] = None,
                 weighted_capacity: Optional[int] = None):
        """
        :param str instance_type: An EC2 instance type, such as m4.xlarge.
        :param str bid_price: The bid price for each EC2 Spot instance type as defined by `instance_type`. Expressed in USD. If neither `bid_price` nor `bid_price_as_percentage_of_on_demand_price` is provided, `bid_price_as_percentage_of_on_demand_price` defaults to 100%.
        :param float bid_price_as_percentage_of_on_demand_price: The bid price, as a percentage of On-Demand price, for each EC2 Spot instance as defined by `instance_type`. Expressed as a number (for example, 20 specifies 20%). If neither `bid_price` nor `bid_price_as_percentage_of_on_demand_price` is provided, `bid_price_as_percentage_of_on_demand_price` defaults to 100%.
        :param Sequence['ClusterCoreInstanceFleetInstanceTypeConfigConfigurationArgs'] configurations: A configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster. List of `configuration` blocks.
        :param Sequence['ClusterCoreInstanceFleetInstanceTypeConfigEbsConfigArgs'] ebs_configs: Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
        :param int weighted_capacity: The number of units that a provisioned instance of this type provides toward fulfilling the target capacities defined in `emr.InstanceFleet`.
        """
        pulumi.set(__self__, "instance_type", instance_type)
        if bid_price is not None:
            pulumi.set(__self__, "bid_price", bid_price)
        if bid_price_as_percentage_of_on_demand_price is not None:
            pulumi.set(__self__, "bid_price_as_percentage_of_on_demand_price", bid_price_as_percentage_of_on_demand_price)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)
        if ebs_configs is not None:
            pulumi.set(__self__, "ebs_configs", ebs_configs)
        if weighted_capacity is not None:
            pulumi.set(__self__, "weighted_capacity", weighted_capacity)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        An EC2 instance type, such as m4.xlarge.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="bidPrice")
    def bid_price(self) -> Optional[str]:
        """
        The bid price for each EC2 Spot instance type as defined by `instance_type`. Expressed in USD. If neither `bid_price` nor `bid_price_as_percentage_of_on_demand_price` is provided, `bid_price_as_percentage_of_on_demand_price` defaults to 100%.
        """
        return pulumi.get(self, "bid_price")

    @property
    @pulumi.getter(name="bidPriceAsPercentageOfOnDemandPrice")
    def bid_price_as_percentage_of_on_demand_price(self) -> Optional[float]:
        """
        The bid price, as a percentage of On-Demand price, for each EC2 Spot instance as defined by `instance_type`. Expressed as a number (for example, 20 specifies 20%). If neither `bid_price` nor `bid_price_as_percentage_of_on_demand_price` is provided, `bid_price_as_percentage_of_on_demand_price` defaults to 100%.
        """
        return pulumi.get(self, "bid_price_as_percentage_of_on_demand_price")

    @property
    @pulumi.getter
    def configurations(self) -> Optional[Sequence['outputs.ClusterCoreInstanceFleetInstanceTypeConfigConfiguration']]:
        """
        A configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster. List of `configuration` blocks.
        """
        return pulumi.get(self, "configurations")

    @property
    @pulumi.getter(name="ebsConfigs")
    def ebs_configs(self) -> Optional[Sequence['outputs.ClusterCoreInstanceFleetInstanceTypeConfigEbsConfig']]:
        """
        Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
        """
        return pulumi.get(self, "ebs_configs")

    @property
    @pulumi.getter(name="weightedCapacity")
    def weighted_capacity(self) -> Optional[int]:
        """
        The number of units that a provisioned instance of this type provides toward fulfilling the target capacities defined in `emr.InstanceFleet`.
        """
        return pulumi.get(self, "weighted_capacity")


@pulumi.output_type
class ClusterCoreInstanceFleetInstanceTypeConfigConfiguration(dict):
    def __init__(__self__, *,
                 classification: Optional[str] = None,
                 properties: Optional[Mapping[str, Any]] = None):
        """
        :param str classification: The classification within a configuration.
        :param Mapping[str, Any] properties: A map of properties specified within a configuration classification
        """
        if classification is not None:
            pulumi.set(__self__, "classification", classification)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def classification(self) -> Optional[str]:
        """
        The classification within a configuration.
        """
        return pulumi.get(self, "classification")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, Any]]:
        """
        A map of properties specified within a configuration classification
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class ClusterCoreInstanceFleetInstanceTypeConfigEbsConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "volumesPerInstance":
            suggest = "volumes_per_instance"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCoreInstanceFleetInstanceTypeConfigEbsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCoreInstanceFleetInstanceTypeConfigEbsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCoreInstanceFleetInstanceTypeConfigEbsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 size: int,
                 type: str,
                 iops: Optional[int] = None,
                 volumes_per_instance: Optional[int] = None):
        """
        :param int size: The volume size, in gibibytes (GiB).
        :param str type: The volume type. Valid options are `gp2`, `io1`, `standard` and `st1`. See [EBS Volume Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html).
        :param int iops: The number of I/O operations per second (IOPS) that the volume supports
        :param int volumes_per_instance: The number of EBS volumes with this configuration to attach to each EC2 instance in the instance group (default is 1)
        """
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "type", type)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if volumes_per_instance is not None:
            pulumi.set(__self__, "volumes_per_instance", volumes_per_instance)

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        The volume size, in gibibytes (GiB).
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The volume type. Valid options are `gp2`, `io1`, `standard` and `st1`. See [EBS Volume Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html).
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        """
        The number of I/O operations per second (IOPS) that the volume supports
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="volumesPerInstance")
    def volumes_per_instance(self) -> Optional[int]:
        """
        The number of EBS volumes with this configuration to attach to each EC2 instance in the instance group (default is 1)
        """
        return pulumi.get(self, "volumes_per_instance")


@pulumi.output_type
class ClusterCoreInstanceFleetLaunchSpecifications(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "onDemandSpecifications":
            suggest = "on_demand_specifications"
        elif key == "spotSpecifications":
            suggest = "spot_specifications"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCoreInstanceFleetLaunchSpecifications. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCoreInstanceFleetLaunchSpecifications.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCoreInstanceFleetLaunchSpecifications.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 on_demand_specifications: Optional[Sequence['outputs.ClusterCoreInstanceFleetLaunchSpecificationsOnDemandSpecification']] = None,
                 spot_specifications: Optional[Sequence['outputs.ClusterCoreInstanceFleetLaunchSpecificationsSpotSpecification']] = None):
        """
        :param Sequence['ClusterCoreInstanceFleetLaunchSpecificationsOnDemandSpecificationArgs'] on_demand_specifications: Configuration block for on demand instances launch specifications
        :param Sequence['ClusterCoreInstanceFleetLaunchSpecificationsSpotSpecificationArgs'] spot_specifications: Configuration block for spot instances launch specifications
        """
        if on_demand_specifications is not None:
            pulumi.set(__self__, "on_demand_specifications", on_demand_specifications)
        if spot_specifications is not None:
            pulumi.set(__self__, "spot_specifications", spot_specifications)

    @property
    @pulumi.getter(name="onDemandSpecifications")
    def on_demand_specifications(self) -> Optional[Sequence['outputs.ClusterCoreInstanceFleetLaunchSpecificationsOnDemandSpecification']]:
        """
        Configuration block for on demand instances launch specifications
        """
        return pulumi.get(self, "on_demand_specifications")

    @property
    @pulumi.getter(name="spotSpecifications")
    def spot_specifications(self) -> Optional[Sequence['outputs.ClusterCoreInstanceFleetLaunchSpecificationsSpotSpecification']]:
        """
        Configuration block for spot instances launch specifications
        """
        return pulumi.get(self, "spot_specifications")


@pulumi.output_type
class ClusterCoreInstanceFleetLaunchSpecificationsOnDemandSpecification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allocationStrategy":
            suggest = "allocation_strategy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCoreInstanceFleetLaunchSpecificationsOnDemandSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCoreInstanceFleetLaunchSpecificationsOnDemandSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCoreInstanceFleetLaunchSpecificationsOnDemandSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allocation_strategy: str):
        """
        :param str allocation_strategy: Specifies the strategy to use in launching Spot instance fleets. Currently, the only option is `capacity-optimized` (the default), which launches instances from Spot instance pools with optimal capacity for the number of instances that are launching.
        """
        pulumi.set(__self__, "allocation_strategy", allocation_strategy)

    @property
    @pulumi.getter(name="allocationStrategy")
    def allocation_strategy(self) -> str:
        """
        Specifies the strategy to use in launching Spot instance fleets. Currently, the only option is `capacity-optimized` (the default), which launches instances from Spot instance pools with optimal capacity for the number of instances that are launching.
        """
        return pulumi.get(self, "allocation_strategy")


@pulumi.output_type
class ClusterCoreInstanceFleetLaunchSpecificationsSpotSpecification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allocationStrategy":
            suggest = "allocation_strategy"
        elif key == "timeoutAction":
            suggest = "timeout_action"
        elif key == "timeoutDurationMinutes":
            suggest = "timeout_duration_minutes"
        elif key == "blockDurationMinutes":
            suggest = "block_duration_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCoreInstanceFleetLaunchSpecificationsSpotSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCoreInstanceFleetLaunchSpecificationsSpotSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCoreInstanceFleetLaunchSpecificationsSpotSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allocation_strategy: str,
                 timeout_action: str,
                 timeout_duration_minutes: int,
                 block_duration_minutes: Optional[int] = None):
        """
        :param str allocation_strategy: Specifies the strategy to use in launching Spot instance fleets. Currently, the only option is `capacity-optimized` (the default), which launches instances from Spot instance pools with optimal capacity for the number of instances that are launching.
        :param str timeout_action: The action to take when TargetSpotCapacity has not been fulfilled when the TimeoutDurationMinutes has expired; that is, when all Spot instances could not be provisioned within the Spot provisioning timeout. Valid values are `TERMINATE_CLUSTER` and `SWITCH_TO_ON_DEMAND`. SWITCH_TO_ON_DEMAND specifies that if no Spot instances are available, On-Demand Instances should be provisioned to fulfill any remaining Spot capacity.
        :param int timeout_duration_minutes: The spot provisioning timeout period in minutes. If Spot instances are not provisioned within this time period, the TimeOutAction is taken. Minimum value is 5 and maximum value is 1440. The timeout applies only during initial provisioning, when the cluster is first created.
        :param int block_duration_minutes: The defined duration for Spot instances (also known as Spot blocks) in minutes. When specified, the Spot instance does not terminate before the defined duration expires, and defined duration pricing for Spot instances applies. Valid values are 60, 120, 180, 240, 300, or 360. The duration period starts as soon as a Spot instance receives its instance ID. At the end of the duration, Amazon EC2 marks the Spot instance for termination and provides a Spot instance termination notice, which gives the instance a two-minute warning before it terminates.
        """
        pulumi.set(__self__, "allocation_strategy", allocation_strategy)
        pulumi.set(__self__, "timeout_action", timeout_action)
        pulumi.set(__self__, "timeout_duration_minutes", timeout_duration_minutes)
        if block_duration_minutes is not None:
            pulumi.set(__self__, "block_duration_minutes", block_duration_minutes)

    @property
    @pulumi.getter(name="allocationStrategy")
    def allocation_strategy(self) -> str:
        """
        Specifies the strategy to use in launching Spot instance fleets. Currently, the only option is `capacity-optimized` (the default), which launches instances from Spot instance pools with optimal capacity for the number of instances that are launching.
        """
        return pulumi.get(self, "allocation_strategy")

    @property
    @pulumi.getter(name="timeoutAction")
    def timeout_action(self) -> str:
        """
        The action to take when TargetSpotCapacity has not been fulfilled when the TimeoutDurationMinutes has expired; that is, when all Spot instances could not be provisioned within the Spot provisioning timeout. Valid values are `TERMINATE_CLUSTER` and `SWITCH_TO_ON_DEMAND`. SWITCH_TO_ON_DEMAND specifies that if no Spot instances are available, On-Demand Instances should be provisioned to fulfill any remaining Spot capacity.
        """
        return pulumi.get(self, "timeout_action")

    @property
    @pulumi.getter(name="timeoutDurationMinutes")
    def timeout_duration_minutes(self) -> int:
        """
        The spot provisioning timeout period in minutes. If Spot instances are not provisioned within this time period, the TimeOutAction is taken. Minimum value is 5 and maximum value is 1440. The timeout applies only during initial provisioning, when the cluster is first created.
        """
        return pulumi.get(self, "timeout_duration_minutes")

    @property
    @pulumi.getter(name="blockDurationMinutes")
    def block_duration_minutes(self) -> Optional[int]:
        """
        The defined duration for Spot instances (also known as Spot blocks) in minutes. When specified, the Spot instance does not terminate before the defined duration expires, and defined duration pricing for Spot instances applies. Valid values are 60, 120, 180, 240, 300, or 360. The duration period starts as soon as a Spot instance receives its instance ID. At the end of the duration, Amazon EC2 marks the Spot instance for termination and provides a Spot instance termination notice, which gives the instance a two-minute warning before it terminates.
        """
        return pulumi.get(self, "block_duration_minutes")


@pulumi.output_type
class ClusterCoreInstanceGroup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "autoscalingPolicy":
            suggest = "autoscaling_policy"
        elif key == "bidPrice":
            suggest = "bid_price"
        elif key == "ebsConfigs":
            suggest = "ebs_configs"
        elif key == "instanceCount":
            suggest = "instance_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCoreInstanceGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCoreInstanceGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCoreInstanceGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: str,
                 autoscaling_policy: Optional[str] = None,
                 bid_price: Optional[str] = None,
                 ebs_configs: Optional[Sequence['outputs.ClusterCoreInstanceGroupEbsConfig']] = None,
                 id: Optional[str] = None,
                 instance_count: Optional[int] = None,
                 name: Optional[str] = None):
        """
        :param str instance_type: An EC2 instance type, such as m4.xlarge.
        :param str autoscaling_policy: String containing the [EMR Auto Scaling Policy](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-automatic-scaling.html) JSON.
        :param str bid_price: The bid price for each EC2 Spot instance type as defined by `instance_type`. Expressed in USD. If neither `bid_price` nor `bid_price_as_percentage_of_on_demand_price` is provided, `bid_price_as_percentage_of_on_demand_price` defaults to 100%.
        :param Sequence['ClusterCoreInstanceGroupEbsConfigArgs'] ebs_configs: Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
        :param str id: The ID of the EMR Cluster
        :param int instance_count: Target number of instances for the instance group. Must be 1 or 3. Defaults to 1. Launching with multiple master nodes is only supported in EMR version 5.23.0+, and requires this resource's `core_instance_group` to be configured. Public (Internet accessible) instances must be created in VPC subnets that have `map public IP on launch` enabled. Termination protection is automatically enabled when launched with multiple master nodes and this provider must have the `termination_protection = false` configuration applied before destroying this resource.
        :param str name: Friendly name given to the instance fleet.
        """
        pulumi.set(__self__, "instance_type", instance_type)
        if autoscaling_policy is not None:
            pulumi.set(__self__, "autoscaling_policy", autoscaling_policy)
        if bid_price is not None:
            pulumi.set(__self__, "bid_price", bid_price)
        if ebs_configs is not None:
            pulumi.set(__self__, "ebs_configs", ebs_configs)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        An EC2 instance type, such as m4.xlarge.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="autoscalingPolicy")
    def autoscaling_policy(self) -> Optional[str]:
        """
        String containing the [EMR Auto Scaling Policy](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-automatic-scaling.html) JSON.
        """
        return pulumi.get(self, "autoscaling_policy")

    @property
    @pulumi.getter(name="bidPrice")
    def bid_price(self) -> Optional[str]:
        """
        The bid price for each EC2 Spot instance type as defined by `instance_type`. Expressed in USD. If neither `bid_price` nor `bid_price_as_percentage_of_on_demand_price` is provided, `bid_price_as_percentage_of_on_demand_price` defaults to 100%.
        """
        return pulumi.get(self, "bid_price")

    @property
    @pulumi.getter(name="ebsConfigs")
    def ebs_configs(self) -> Optional[Sequence['outputs.ClusterCoreInstanceGroupEbsConfig']]:
        """
        Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
        """
        return pulumi.get(self, "ebs_configs")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The ID of the EMR Cluster
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[int]:
        """
        Target number of instances for the instance group. Must be 1 or 3. Defaults to 1. Launching with multiple master nodes is only supported in EMR version 5.23.0+, and requires this resource's `core_instance_group` to be configured. Public (Internet accessible) instances must be created in VPC subnets that have `map public IP on launch` enabled. Termination protection is automatically enabled when launched with multiple master nodes and this provider must have the `termination_protection = false` configuration applied before destroying this resource.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Friendly name given to the instance fleet.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ClusterCoreInstanceGroupEbsConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "volumesPerInstance":
            suggest = "volumes_per_instance"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCoreInstanceGroupEbsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCoreInstanceGroupEbsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCoreInstanceGroupEbsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 size: int,
                 type: str,
                 iops: Optional[int] = None,
                 volumes_per_instance: Optional[int] = None):
        """
        :param int size: The volume size, in gibibytes (GiB).
        :param str type: The volume type. Valid options are `gp2`, `io1`, `standard` and `st1`. See [EBS Volume Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html).
        :param int iops: The number of I/O operations per second (IOPS) that the volume supports
        :param int volumes_per_instance: The number of EBS volumes with this configuration to attach to each EC2 instance in the instance group (default is 1)
        """
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "type", type)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if volumes_per_instance is not None:
            pulumi.set(__self__, "volumes_per_instance", volumes_per_instance)

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        The volume size, in gibibytes (GiB).
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The volume type. Valid options are `gp2`, `io1`, `standard` and `st1`. See [EBS Volume Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html).
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        """
        The number of I/O operations per second (IOPS) that the volume supports
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="volumesPerInstance")
    def volumes_per_instance(self) -> Optional[int]:
        """
        The number of EBS volumes with this configuration to attach to each EC2 instance in the instance group (default is 1)
        """
        return pulumi.get(self, "volumes_per_instance")


@pulumi.output_type
class ClusterEc2Attributes(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceProfile":
            suggest = "instance_profile"
        elif key == "additionalMasterSecurityGroups":
            suggest = "additional_master_security_groups"
        elif key == "additionalSlaveSecurityGroups":
            suggest = "additional_slave_security_groups"
        elif key == "emrManagedMasterSecurityGroup":
            suggest = "emr_managed_master_security_group"
        elif key == "emrManagedSlaveSecurityGroup":
            suggest = "emr_managed_slave_security_group"
        elif key == "keyName":
            suggest = "key_name"
        elif key == "serviceAccessSecurityGroup":
            suggest = "service_access_security_group"
        elif key == "subnetId":
            suggest = "subnet_id"
        elif key == "subnetIds":
            suggest = "subnet_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterEc2Attributes. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterEc2Attributes.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterEc2Attributes.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_profile: str,
                 additional_master_security_groups: Optional[str] = None,
                 additional_slave_security_groups: Optional[str] = None,
                 emr_managed_master_security_group: Optional[str] = None,
                 emr_managed_slave_security_group: Optional[str] = None,
                 key_name: Optional[str] = None,
                 service_access_security_group: Optional[str] = None,
                 subnet_id: Optional[str] = None,
                 subnet_ids: Optional[Sequence[str]] = None):
        """
        :param str instance_profile: Instance Profile for EC2 instances of the cluster assume this role
        :param str additional_master_security_groups: String containing a comma separated list of additional Amazon EC2 security group IDs for the master node
        :param str additional_slave_security_groups: String containing a comma separated list of additional Amazon EC2 security group IDs for the slave nodes as a comma separated string
        :param str emr_managed_master_security_group: Identifier of the Amazon EC2 EMR-Managed security group for the master node
        :param str emr_managed_slave_security_group: Identifier of the Amazon EC2 EMR-Managed security group for the slave nodes
        :param str key_name: Amazon EC2 key pair that can be used to ssh to the master node as the user called `hadoop`
        :param str service_access_security_group: Identifier of the Amazon EC2 service-access security group - required when the cluster runs on a private subnet
        :param str subnet_id: VPC subnet id where you want the job flow to launch. Cannot specify the `cc1.4xlarge` instance type for nodes of a job flow launched in a Amazon VPC
        :param Sequence[str] subnet_ids: List of VPC subnet id-s where you want the job flow to launch.  Amazon EMR identifies the best Availability Zone to launch instances according to your fleet specifications
        """
        pulumi.set(__self__, "instance_profile", instance_profile)
        if additional_master_security_groups is not None:
            pulumi.set(__self__, "additional_master_security_groups", additional_master_security_groups)
        if additional_slave_security_groups is not None:
            pulumi.set(__self__, "additional_slave_security_groups", additional_slave_security_groups)
        if emr_managed_master_security_group is not None:
            pulumi.set(__self__, "emr_managed_master_security_group", emr_managed_master_security_group)
        if emr_managed_slave_security_group is not None:
            pulumi.set(__self__, "emr_managed_slave_security_group", emr_managed_slave_security_group)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if service_access_security_group is not None:
            pulumi.set(__self__, "service_access_security_group", service_access_security_group)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)

    @property
    @pulumi.getter(name="instanceProfile")
    def instance_profile(self) -> str:
        """
        Instance Profile for EC2 instances of the cluster assume this role
        """
        return pulumi.get(self, "instance_profile")

    @property
    @pulumi.getter(name="additionalMasterSecurityGroups")
    def additional_master_security_groups(self) -> Optional[str]:
        """
        String containing a comma separated list of additional Amazon EC2 security group IDs for the master node
        """
        return pulumi.get(self, "additional_master_security_groups")

    @property
    @pulumi.getter(name="additionalSlaveSecurityGroups")
    def additional_slave_security_groups(self) -> Optional[str]:
        """
        String containing a comma separated list of additional Amazon EC2 security group IDs for the slave nodes as a comma separated string
        """
        return pulumi.get(self, "additional_slave_security_groups")

    @property
    @pulumi.getter(name="emrManagedMasterSecurityGroup")
    def emr_managed_master_security_group(self) -> Optional[str]:
        """
        Identifier of the Amazon EC2 EMR-Managed security group for the master node
        """
        return pulumi.get(self, "emr_managed_master_security_group")

    @property
    @pulumi.getter(name="emrManagedSlaveSecurityGroup")
    def emr_managed_slave_security_group(self) -> Optional[str]:
        """
        Identifier of the Amazon EC2 EMR-Managed security group for the slave nodes
        """
        return pulumi.get(self, "emr_managed_slave_security_group")

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[str]:
        """
        Amazon EC2 key pair that can be used to ssh to the master node as the user called `hadoop`
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter(name="serviceAccessSecurityGroup")
    def service_access_security_group(self) -> Optional[str]:
        """
        Identifier of the Amazon EC2 service-access security group - required when the cluster runs on a private subnet
        """
        return pulumi.get(self, "service_access_security_group")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[str]:
        """
        VPC subnet id where you want the job flow to launch. Cannot specify the `cc1.4xlarge` instance type for nodes of a job flow launched in a Amazon VPC
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[Sequence[str]]:
        """
        List of VPC subnet id-s where you want the job flow to launch.  Amazon EMR identifies the best Availability Zone to launch instances according to your fleet specifications
        """
        return pulumi.get(self, "subnet_ids")


@pulumi.output_type
class ClusterKerberosAttributes(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kdcAdminPassword":
            suggest = "kdc_admin_password"
        elif key == "adDomainJoinPassword":
            suggest = "ad_domain_join_password"
        elif key == "adDomainJoinUser":
            suggest = "ad_domain_join_user"
        elif key == "crossRealmTrustPrincipalPassword":
            suggest = "cross_realm_trust_principal_password"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterKerberosAttributes. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterKerberosAttributes.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterKerberosAttributes.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kdc_admin_password: str,
                 realm: str,
                 ad_domain_join_password: Optional[str] = None,
                 ad_domain_join_user: Optional[str] = None,
                 cross_realm_trust_principal_password: Optional[str] = None):
        """
        :param str kdc_admin_password: The password used within the cluster for the kadmin service on the cluster-dedicated KDC, which maintains Kerberos principals, password policies, and keytabs for the cluster. This provider cannot perform drift detection of this configuration.
        :param str realm: The name of the Kerberos realm to which all nodes in a cluster belong. For example, `EC2.INTERNAL`
        :param str ad_domain_join_password: The Active Directory password for `ad_domain_join_user`. This provider cannot perform drift detection of this configuration.
        :param str ad_domain_join_user: Required only when establishing a cross-realm trust with an Active Directory domain. A user with sufficient privileges to join resources to the domain. This provider cannot perform drift detection of this configuration.
        :param str cross_realm_trust_principal_password: Required only when establishing a cross-realm trust with a KDC in a different realm. The cross-realm principal password, which must be identical across realms. This provider cannot perform drift detection of this configuration.
        """
        pulumi.set(__self__, "kdc_admin_password", kdc_admin_password)
        pulumi.set(__self__, "realm", realm)
        if ad_domain_join_password is not None:
            pulumi.set(__self__, "ad_domain_join_password", ad_domain_join_password)
        if ad_domain_join_user is not None:
            pulumi.set(__self__, "ad_domain_join_user", ad_domain_join_user)
        if cross_realm_trust_principal_password is not None:
            pulumi.set(__self__, "cross_realm_trust_principal_password", cross_realm_trust_principal_password)

    @property
    @pulumi.getter(name="kdcAdminPassword")
    def kdc_admin_password(self) -> str:
        """
        The password used within the cluster for the kadmin service on the cluster-dedicated KDC, which maintains Kerberos principals, password policies, and keytabs for the cluster. This provider cannot perform drift detection of this configuration.
        """
        return pulumi.get(self, "kdc_admin_password")

    @property
    @pulumi.getter
    def realm(self) -> str:
        """
        The name of the Kerberos realm to which all nodes in a cluster belong. For example, `EC2.INTERNAL`
        """
        return pulumi.get(self, "realm")

    @property
    @pulumi.getter(name="adDomainJoinPassword")
    def ad_domain_join_password(self) -> Optional[str]:
        """
        The Active Directory password for `ad_domain_join_user`. This provider cannot perform drift detection of this configuration.
        """
        return pulumi.get(self, "ad_domain_join_password")

    @property
    @pulumi.getter(name="adDomainJoinUser")
    def ad_domain_join_user(self) -> Optional[str]:
        """
        Required only when establishing a cross-realm trust with an Active Directory domain. A user with sufficient privileges to join resources to the domain. This provider cannot perform drift detection of this configuration.
        """
        return pulumi.get(self, "ad_domain_join_user")

    @property
    @pulumi.getter(name="crossRealmTrustPrincipalPassword")
    def cross_realm_trust_principal_password(self) -> Optional[str]:
        """
        Required only when establishing a cross-realm trust with a KDC in a different realm. The cross-realm principal password, which must be identical across realms. This provider cannot perform drift detection of this configuration.
        """
        return pulumi.get(self, "cross_realm_trust_principal_password")


@pulumi.output_type
class ClusterMasterInstanceFleet(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceTypeConfigs":
            suggest = "instance_type_configs"
        elif key == "launchSpecifications":
            suggest = "launch_specifications"
        elif key == "provisionedOnDemandCapacity":
            suggest = "provisioned_on_demand_capacity"
        elif key == "provisionedSpotCapacity":
            suggest = "provisioned_spot_capacity"
        elif key == "targetOnDemandCapacity":
            suggest = "target_on_demand_capacity"
        elif key == "targetSpotCapacity":
            suggest = "target_spot_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterMasterInstanceFleet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterMasterInstanceFleet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterMasterInstanceFleet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: Optional[str] = None,
                 instance_type_configs: Optional[Sequence['outputs.ClusterMasterInstanceFleetInstanceTypeConfig']] = None,
                 launch_specifications: Optional['outputs.ClusterMasterInstanceFleetLaunchSpecifications'] = None,
                 name: Optional[str] = None,
                 provisioned_on_demand_capacity: Optional[int] = None,
                 provisioned_spot_capacity: Optional[int] = None,
                 target_on_demand_capacity: Optional[int] = None,
                 target_spot_capacity: Optional[int] = None):
        """
        :param str id: The ID of the EMR Cluster
        :param Sequence['ClusterMasterInstanceFleetInstanceTypeConfigArgs'] instance_type_configs: Configuration block for instance fleet
        :param 'ClusterMasterInstanceFleetLaunchSpecificationsArgs' launch_specifications: Configuration block for launch specification
        :param str name: Friendly name given to the instance fleet.
        :param int target_on_demand_capacity: The target capacity of On-Demand units for the instance fleet, which determines how many On-Demand instances to provision.
        :param int target_spot_capacity: The target capacity of Spot units for the instance fleet, which determines how many Spot instances to provision.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if instance_type_configs is not None:
            pulumi.set(__self__, "instance_type_configs", instance_type_configs)
        if launch_specifications is not None:
            pulumi.set(__self__, "launch_specifications", launch_specifications)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if provisioned_on_demand_capacity is not None:
            pulumi.set(__self__, "provisioned_on_demand_capacity", provisioned_on_demand_capacity)
        if provisioned_spot_capacity is not None:
            pulumi.set(__self__, "provisioned_spot_capacity", provisioned_spot_capacity)
        if target_on_demand_capacity is not None:
            pulumi.set(__self__, "target_on_demand_capacity", target_on_demand_capacity)
        if target_spot_capacity is not None:
            pulumi.set(__self__, "target_spot_capacity", target_spot_capacity)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The ID of the EMR Cluster
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceTypeConfigs")
    def instance_type_configs(self) -> Optional[Sequence['outputs.ClusterMasterInstanceFleetInstanceTypeConfig']]:
        """
        Configuration block for instance fleet
        """
        return pulumi.get(self, "instance_type_configs")

    @property
    @pulumi.getter(name="launchSpecifications")
    def launch_specifications(self) -> Optional['outputs.ClusterMasterInstanceFleetLaunchSpecifications']:
        """
        Configuration block for launch specification
        """
        return pulumi.get(self, "launch_specifications")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Friendly name given to the instance fleet.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisionedOnDemandCapacity")
    def provisioned_on_demand_capacity(self) -> Optional[int]:
        return pulumi.get(self, "provisioned_on_demand_capacity")

    @property
    @pulumi.getter(name="provisionedSpotCapacity")
    def provisioned_spot_capacity(self) -> Optional[int]:
        return pulumi.get(self, "provisioned_spot_capacity")

    @property
    @pulumi.getter(name="targetOnDemandCapacity")
    def target_on_demand_capacity(self) -> Optional[int]:
        """
        The target capacity of On-Demand units for the instance fleet, which determines how many On-Demand instances to provision.
        """
        return pulumi.get(self, "target_on_demand_capacity")

    @property
    @pulumi.getter(name="targetSpotCapacity")
    def target_spot_capacity(self) -> Optional[int]:
        """
        The target capacity of Spot units for the instance fleet, which determines how many Spot instances to provision.
        """
        return pulumi.get(self, "target_spot_capacity")


@pulumi.output_type
class ClusterMasterInstanceFleetInstanceTypeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "bidPrice":
            suggest = "bid_price"
        elif key == "bidPriceAsPercentageOfOnDemandPrice":
            suggest = "bid_price_as_percentage_of_on_demand_price"
        elif key == "ebsConfigs":
            suggest = "ebs_configs"
        elif key == "weightedCapacity":
            suggest = "weighted_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterMasterInstanceFleetInstanceTypeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterMasterInstanceFleetInstanceTypeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterMasterInstanceFleetInstanceTypeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: str,
                 bid_price: Optional[str] = None,
                 bid_price_as_percentage_of_on_demand_price: Optional[float] = None,
                 configurations: Optional[Sequence['outputs.ClusterMasterInstanceFleetInstanceTypeConfigConfiguration']] = None,
                 ebs_configs: Optional[Sequence['outputs.ClusterMasterInstanceFleetInstanceTypeConfigEbsConfig']] = None,
                 weighted_capacity: Optional[int] = None):
        """
        :param str instance_type: An EC2 instance type, such as m4.xlarge.
        :param str bid_price: The bid price for each EC2 Spot instance type as defined by `instance_type`. Expressed in USD. If neither `bid_price` nor `bid_price_as_percentage_of_on_demand_price` is provided, `bid_price_as_percentage_of_on_demand_price` defaults to 100%.
        :param float bid_price_as_percentage_of_on_demand_price: The bid price, as a percentage of On-Demand price, for each EC2 Spot instance as defined by `instance_type`. Expressed as a number (for example, 20 specifies 20%). If neither `bid_price` nor `bid_price_as_percentage_of_on_demand_price` is provided, `bid_price_as_percentage_of_on_demand_price` defaults to 100%.
        :param Sequence['ClusterMasterInstanceFleetInstanceTypeConfigConfigurationArgs'] configurations: A configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster. List of `configuration` blocks.
        :param Sequence['ClusterMasterInstanceFleetInstanceTypeConfigEbsConfigArgs'] ebs_configs: Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
        :param int weighted_capacity: The number of units that a provisioned instance of this type provides toward fulfilling the target capacities defined in `emr.InstanceFleet`.
        """
        pulumi.set(__self__, "instance_type", instance_type)
        if bid_price is not None:
            pulumi.set(__self__, "bid_price", bid_price)
        if bid_price_as_percentage_of_on_demand_price is not None:
            pulumi.set(__self__, "bid_price_as_percentage_of_on_demand_price", bid_price_as_percentage_of_on_demand_price)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)
        if ebs_configs is not None:
            pulumi.set(__self__, "ebs_configs", ebs_configs)
        if weighted_capacity is not None:
            pulumi.set(__self__, "weighted_capacity", weighted_capacity)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        An EC2 instance type, such as m4.xlarge.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="bidPrice")
    def bid_price(self) -> Optional[str]:
        """
        The bid price for each EC2 Spot instance type as defined by `instance_type`. Expressed in USD. If neither `bid_price` nor `bid_price_as_percentage_of_on_demand_price` is provided, `bid_price_as_percentage_of_on_demand_price` defaults to 100%.
        """
        return pulumi.get(self, "bid_price")

    @property
    @pulumi.getter(name="bidPriceAsPercentageOfOnDemandPrice")
    def bid_price_as_percentage_of_on_demand_price(self) -> Optional[float]:
        """
        The bid price, as a percentage of On-Demand price, for each EC2 Spot instance as defined by `instance_type`. Expressed as a number (for example, 20 specifies 20%). If neither `bid_price` nor `bid_price_as_percentage_of_on_demand_price` is provided, `bid_price_as_percentage_of_on_demand_price` defaults to 100%.
        """
        return pulumi.get(self, "bid_price_as_percentage_of_on_demand_price")

    @property
    @pulumi.getter
    def configurations(self) -> Optional[Sequence['outputs.ClusterMasterInstanceFleetInstanceTypeConfigConfiguration']]:
        """
        A configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster. List of `configuration` blocks.
        """
        return pulumi.get(self, "configurations")

    @property
    @pulumi.getter(name="ebsConfigs")
    def ebs_configs(self) -> Optional[Sequence['outputs.ClusterMasterInstanceFleetInstanceTypeConfigEbsConfig']]:
        """
        Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
        """
        return pulumi.get(self, "ebs_configs")

    @property
    @pulumi.getter(name="weightedCapacity")
    def weighted_capacity(self) -> Optional[int]:
        """
        The number of units that a provisioned instance of this type provides toward fulfilling the target capacities defined in `emr.InstanceFleet`.
        """
        return pulumi.get(self, "weighted_capacity")


@pulumi.output_type
class ClusterMasterInstanceFleetInstanceTypeConfigConfiguration(dict):
    def __init__(__self__, *,
                 classification: Optional[str] = None,
                 properties: Optional[Mapping[str, Any]] = None):
        """
        :param str classification: The classification within a configuration.
        :param Mapping[str, Any] properties: A map of properties specified within a configuration classification
        """
        if classification is not None:
            pulumi.set(__self__, "classification", classification)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def classification(self) -> Optional[str]:
        """
        The classification within a configuration.
        """
        return pulumi.get(self, "classification")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, Any]]:
        """
        A map of properties specified within a configuration classification
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class ClusterMasterInstanceFleetInstanceTypeConfigEbsConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "volumesPerInstance":
            suggest = "volumes_per_instance"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterMasterInstanceFleetInstanceTypeConfigEbsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterMasterInstanceFleetInstanceTypeConfigEbsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterMasterInstanceFleetInstanceTypeConfigEbsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 size: int,
                 type: str,
                 iops: Optional[int] = None,
                 volumes_per_instance: Optional[int] = None):
        """
        :param int size: The volume size, in gibibytes (GiB).
        :param str type: The volume type. Valid options are `gp2`, `io1`, `standard` and `st1`. See [EBS Volume Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html).
        :param int iops: The number of I/O operations per second (IOPS) that the volume supports
        :param int volumes_per_instance: The number of EBS volumes with this configuration to attach to each EC2 instance in the instance group (default is 1)
        """
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "type", type)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if volumes_per_instance is not None:
            pulumi.set(__self__, "volumes_per_instance", volumes_per_instance)

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        The volume size, in gibibytes (GiB).
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The volume type. Valid options are `gp2`, `io1`, `standard` and `st1`. See [EBS Volume Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html).
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        """
        The number of I/O operations per second (IOPS) that the volume supports
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="volumesPerInstance")
    def volumes_per_instance(self) -> Optional[int]:
        """
        The number of EBS volumes with this configuration to attach to each EC2 instance in the instance group (default is 1)
        """
        return pulumi.get(self, "volumes_per_instance")


@pulumi.output_type
class ClusterMasterInstanceFleetLaunchSpecifications(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "onDemandSpecifications":
            suggest = "on_demand_specifications"
        elif key == "spotSpecifications":
            suggest = "spot_specifications"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterMasterInstanceFleetLaunchSpecifications. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterMasterInstanceFleetLaunchSpecifications.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterMasterInstanceFleetLaunchSpecifications.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 on_demand_specifications: Optional[Sequence['outputs.ClusterMasterInstanceFleetLaunchSpecificationsOnDemandSpecification']] = None,
                 spot_specifications: Optional[Sequence['outputs.ClusterMasterInstanceFleetLaunchSpecificationsSpotSpecification']] = None):
        """
        :param Sequence['ClusterMasterInstanceFleetLaunchSpecificationsOnDemandSpecificationArgs'] on_demand_specifications: Configuration block for on demand instances launch specifications
        :param Sequence['ClusterMasterInstanceFleetLaunchSpecificationsSpotSpecificationArgs'] spot_specifications: Configuration block for spot instances launch specifications
        """
        if on_demand_specifications is not None:
            pulumi.set(__self__, "on_demand_specifications", on_demand_specifications)
        if spot_specifications is not None:
            pulumi.set(__self__, "spot_specifications", spot_specifications)

    @property
    @pulumi.getter(name="onDemandSpecifications")
    def on_demand_specifications(self) -> Optional[Sequence['outputs.ClusterMasterInstanceFleetLaunchSpecificationsOnDemandSpecification']]:
        """
        Configuration block for on demand instances launch specifications
        """
        return pulumi.get(self, "on_demand_specifications")

    @property
    @pulumi.getter(name="spotSpecifications")
    def spot_specifications(self) -> Optional[Sequence['outputs.ClusterMasterInstanceFleetLaunchSpecificationsSpotSpecification']]:
        """
        Configuration block for spot instances launch specifications
        """
        return pulumi.get(self, "spot_specifications")


@pulumi.output_type
class ClusterMasterInstanceFleetLaunchSpecificationsOnDemandSpecification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allocationStrategy":
            suggest = "allocation_strategy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterMasterInstanceFleetLaunchSpecificationsOnDemandSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterMasterInstanceFleetLaunchSpecificationsOnDemandSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterMasterInstanceFleetLaunchSpecificationsOnDemandSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allocation_strategy: str):
        """
        :param str allocation_strategy: Specifies the strategy to use in launching Spot instance fleets. Currently, the only option is `capacity-optimized` (the default), which launches instances from Spot instance pools with optimal capacity for the number of instances that are launching.
        """
        pulumi.set(__self__, "allocation_strategy", allocation_strategy)

    @property
    @pulumi.getter(name="allocationStrategy")
    def allocation_strategy(self) -> str:
        """
        Specifies the strategy to use in launching Spot instance fleets. Currently, the only option is `capacity-optimized` (the default), which launches instances from Spot instance pools with optimal capacity for the number of instances that are launching.
        """
        return pulumi.get(self, "allocation_strategy")


@pulumi.output_type
class ClusterMasterInstanceFleetLaunchSpecificationsSpotSpecification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allocationStrategy":
            suggest = "allocation_strategy"
        elif key == "timeoutAction":
            suggest = "timeout_action"
        elif key == "timeoutDurationMinutes":
            suggest = "timeout_duration_minutes"
        elif key == "blockDurationMinutes":
            suggest = "block_duration_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterMasterInstanceFleetLaunchSpecificationsSpotSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterMasterInstanceFleetLaunchSpecificationsSpotSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterMasterInstanceFleetLaunchSpecificationsSpotSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allocation_strategy: str,
                 timeout_action: str,
                 timeout_duration_minutes: int,
                 block_duration_minutes: Optional[int] = None):
        """
        :param str allocation_strategy: Specifies the strategy to use in launching Spot instance fleets. Currently, the only option is `capacity-optimized` (the default), which launches instances from Spot instance pools with optimal capacity for the number of instances that are launching.
        :param str timeout_action: The action to take when TargetSpotCapacity has not been fulfilled when the TimeoutDurationMinutes has expired; that is, when all Spot instances could not be provisioned within the Spot provisioning timeout. Valid values are `TERMINATE_CLUSTER` and `SWITCH_TO_ON_DEMAND`. SWITCH_TO_ON_DEMAND specifies that if no Spot instances are available, On-Demand Instances should be provisioned to fulfill any remaining Spot capacity.
        :param int timeout_duration_minutes: The spot provisioning timeout period in minutes. If Spot instances are not provisioned within this time period, the TimeOutAction is taken. Minimum value is 5 and maximum value is 1440. The timeout applies only during initial provisioning, when the cluster is first created.
        :param int block_duration_minutes: The defined duration for Spot instances (also known as Spot blocks) in minutes. When specified, the Spot instance does not terminate before the defined duration expires, and defined duration pricing for Spot instances applies. Valid values are 60, 120, 180, 240, 300, or 360. The duration period starts as soon as a Spot instance receives its instance ID. At the end of the duration, Amazon EC2 marks the Spot instance for termination and provides a Spot instance termination notice, which gives the instance a two-minute warning before it terminates.
        """
        pulumi.set(__self__, "allocation_strategy", allocation_strategy)
        pulumi.set(__self__, "timeout_action", timeout_action)
        pulumi.set(__self__, "timeout_duration_minutes", timeout_duration_minutes)
        if block_duration_minutes is not None:
            pulumi.set(__self__, "block_duration_minutes", block_duration_minutes)

    @property
    @pulumi.getter(name="allocationStrategy")
    def allocation_strategy(self) -> str:
        """
        Specifies the strategy to use in launching Spot instance fleets. Currently, the only option is `capacity-optimized` (the default), which launches instances from Spot instance pools with optimal capacity for the number of instances that are launching.
        """
        return pulumi.get(self, "allocation_strategy")

    @property
    @pulumi.getter(name="timeoutAction")
    def timeout_action(self) -> str:
        """
        The action to take when TargetSpotCapacity has not been fulfilled when the TimeoutDurationMinutes has expired; that is, when all Spot instances could not be provisioned within the Spot provisioning timeout. Valid values are `TERMINATE_CLUSTER` and `SWITCH_TO_ON_DEMAND`. SWITCH_TO_ON_DEMAND specifies that if no Spot instances are available, On-Demand Instances should be provisioned to fulfill any remaining Spot capacity.
        """
        return pulumi.get(self, "timeout_action")

    @property
    @pulumi.getter(name="timeoutDurationMinutes")
    def timeout_duration_minutes(self) -> int:
        """
        The spot provisioning timeout period in minutes. If Spot instances are not provisioned within this time period, the TimeOutAction is taken. Minimum value is 5 and maximum value is 1440. The timeout applies only during initial provisioning, when the cluster is first created.
        """
        return pulumi.get(self, "timeout_duration_minutes")

    @property
    @pulumi.getter(name="blockDurationMinutes")
    def block_duration_minutes(self) -> Optional[int]:
        """
        The defined duration for Spot instances (also known as Spot blocks) in minutes. When specified, the Spot instance does not terminate before the defined duration expires, and defined duration pricing for Spot instances applies. Valid values are 60, 120, 180, 240, 300, or 360. The duration period starts as soon as a Spot instance receives its instance ID. At the end of the duration, Amazon EC2 marks the Spot instance for termination and provides a Spot instance termination notice, which gives the instance a two-minute warning before it terminates.
        """
        return pulumi.get(self, "block_duration_minutes")


@pulumi.output_type
class ClusterMasterInstanceGroup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "bidPrice":
            suggest = "bid_price"
        elif key == "ebsConfigs":
            suggest = "ebs_configs"
        elif key == "instanceCount":
            suggest = "instance_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterMasterInstanceGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterMasterInstanceGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterMasterInstanceGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: str,
                 bid_price: Optional[str] = None,
                 ebs_configs: Optional[Sequence['outputs.ClusterMasterInstanceGroupEbsConfig']] = None,
                 id: Optional[str] = None,
                 instance_count: Optional[int] = None,
                 name: Optional[str] = None):
        """
        :param str instance_type: An EC2 instance type, such as m4.xlarge.
        :param str bid_price: The bid price for each EC2 Spot instance type as defined by `instance_type`. Expressed in USD. If neither `bid_price` nor `bid_price_as_percentage_of_on_demand_price` is provided, `bid_price_as_percentage_of_on_demand_price` defaults to 100%.
        :param Sequence['ClusterMasterInstanceGroupEbsConfigArgs'] ebs_configs: Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
        :param str id: The ID of the EMR Cluster
        :param int instance_count: Target number of instances for the instance group. Must be 1 or 3. Defaults to 1. Launching with multiple master nodes is only supported in EMR version 5.23.0+, and requires this resource's `core_instance_group` to be configured. Public (Internet accessible) instances must be created in VPC subnets that have `map public IP on launch` enabled. Termination protection is automatically enabled when launched with multiple master nodes and this provider must have the `termination_protection = false` configuration applied before destroying this resource.
        :param str name: Friendly name given to the instance fleet.
        """
        pulumi.set(__self__, "instance_type", instance_type)
        if bid_price is not None:
            pulumi.set(__self__, "bid_price", bid_price)
        if ebs_configs is not None:
            pulumi.set(__self__, "ebs_configs", ebs_configs)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        An EC2 instance type, such as m4.xlarge.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="bidPrice")
    def bid_price(self) -> Optional[str]:
        """
        The bid price for each EC2 Spot instance type as defined by `instance_type`. Expressed in USD. If neither `bid_price` nor `bid_price_as_percentage_of_on_demand_price` is provided, `bid_price_as_percentage_of_on_demand_price` defaults to 100%.
        """
        return pulumi.get(self, "bid_price")

    @property
    @pulumi.getter(name="ebsConfigs")
    def ebs_configs(self) -> Optional[Sequence['outputs.ClusterMasterInstanceGroupEbsConfig']]:
        """
        Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
        """
        return pulumi.get(self, "ebs_configs")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The ID of the EMR Cluster
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[int]:
        """
        Target number of instances for the instance group. Must be 1 or 3. Defaults to 1. Launching with multiple master nodes is only supported in EMR version 5.23.0+, and requires this resource's `core_instance_group` to be configured. Public (Internet accessible) instances must be created in VPC subnets that have `map public IP on launch` enabled. Termination protection is automatically enabled when launched with multiple master nodes and this provider must have the `termination_protection = false` configuration applied before destroying this resource.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Friendly name given to the instance fleet.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ClusterMasterInstanceGroupEbsConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "volumesPerInstance":
            suggest = "volumes_per_instance"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterMasterInstanceGroupEbsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterMasterInstanceGroupEbsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterMasterInstanceGroupEbsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 size: int,
                 type: str,
                 iops: Optional[int] = None,
                 volumes_per_instance: Optional[int] = None):
        """
        :param int size: The volume size, in gibibytes (GiB).
        :param str type: The volume type. Valid options are `gp2`, `io1`, `standard` and `st1`. See [EBS Volume Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html).
        :param int iops: The number of I/O operations per second (IOPS) that the volume supports
        :param int volumes_per_instance: The number of EBS volumes with this configuration to attach to each EC2 instance in the instance group (default is 1)
        """
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "type", type)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if volumes_per_instance is not None:
            pulumi.set(__self__, "volumes_per_instance", volumes_per_instance)

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        The volume size, in gibibytes (GiB).
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The volume type. Valid options are `gp2`, `io1`, `standard` and `st1`. See [EBS Volume Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html).
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        """
        The number of I/O operations per second (IOPS) that the volume supports
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="volumesPerInstance")
    def volumes_per_instance(self) -> Optional[int]:
        """
        The number of EBS volumes with this configuration to attach to each EC2 instance in the instance group (default is 1)
        """
        return pulumi.get(self, "volumes_per_instance")


@pulumi.output_type
class ClusterStep(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionOnFailure":
            suggest = "action_on_failure"
        elif key == "hadoopJarStep":
            suggest = "hadoop_jar_step"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterStep. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterStep.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterStep.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action_on_failure: str,
                 hadoop_jar_step: 'outputs.ClusterStepHadoopJarStep',
                 name: str):
        """
        :param str action_on_failure: The action to take if the step fails. Valid values: `TERMINATE_JOB_FLOW`, `TERMINATE_CLUSTER`, `CANCEL_AND_WAIT`, and `CONTINUE`
        :param 'ClusterStepHadoopJarStepArgs' hadoop_jar_step: The JAR file used for the step. Defined below.
        :param str name: Friendly name given to the instance fleet.
        """
        pulumi.set(__self__, "action_on_failure", action_on_failure)
        pulumi.set(__self__, "hadoop_jar_step", hadoop_jar_step)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="actionOnFailure")
    def action_on_failure(self) -> str:
        """
        The action to take if the step fails. Valid values: `TERMINATE_JOB_FLOW`, `TERMINATE_CLUSTER`, `CANCEL_AND_WAIT`, and `CONTINUE`
        """
        return pulumi.get(self, "action_on_failure")

    @property
    @pulumi.getter(name="hadoopJarStep")
    def hadoop_jar_step(self) -> 'outputs.ClusterStepHadoopJarStep':
        """
        The JAR file used for the step. Defined below.
        """
        return pulumi.get(self, "hadoop_jar_step")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Friendly name given to the instance fleet.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ClusterStepHadoopJarStep(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mainClass":
            suggest = "main_class"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterStepHadoopJarStep. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterStepHadoopJarStep.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterStepHadoopJarStep.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 jar: str,
                 args: Optional[Sequence[str]] = None,
                 main_class: Optional[str] = None,
                 properties: Optional[Mapping[str, str]] = None):
        """
        :param str jar: Path to a JAR file run during the step.
        :param Sequence[str] args: List of command line arguments passed to the JAR file's main function when executed.
        :param str main_class: Name of the main class in the specified Java file. If not specified, the JAR file should specify a Main-Class in its manifest file.
        :param Mapping[str, str] properties: A map of properties specified within a configuration classification
        """
        pulumi.set(__self__, "jar", jar)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if main_class is not None:
            pulumi.set(__self__, "main_class", main_class)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def jar(self) -> str:
        """
        Path to a JAR file run during the step.
        """
        return pulumi.get(self, "jar")

    @property
    @pulumi.getter
    def args(self) -> Optional[Sequence[str]]:
        """
        List of command line arguments passed to the JAR file's main function when executed.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter(name="mainClass")
    def main_class(self) -> Optional[str]:
        """
        Name of the main class in the specified Java file. If not specified, the JAR file should specify a Main-Class in its manifest file.
        """
        return pulumi.get(self, "main_class")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        A map of properties specified within a configuration classification
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class InstanceFleetInstanceTypeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "bidPrice":
            suggest = "bid_price"
        elif key == "bidPriceAsPercentageOfOnDemandPrice":
            suggest = "bid_price_as_percentage_of_on_demand_price"
        elif key == "ebsConfigs":
            suggest = "ebs_configs"
        elif key == "weightedCapacity":
            suggest = "weighted_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceFleetInstanceTypeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceFleetInstanceTypeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceFleetInstanceTypeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: str,
                 bid_price: Optional[str] = None,
                 bid_price_as_percentage_of_on_demand_price: Optional[float] = None,
                 configurations: Optional[Sequence['outputs.InstanceFleetInstanceTypeConfigConfiguration']] = None,
                 ebs_configs: Optional[Sequence['outputs.InstanceFleetInstanceTypeConfigEbsConfig']] = None,
                 weighted_capacity: Optional[int] = None):
        """
        :param str instance_type: An EC2 instance type, such as m4.xlarge.
        :param str bid_price: The bid price for each EC2 Spot instance type as defined by `instance_type`. Expressed in USD. If neither `bid_price` nor `bid_price_as_percentage_of_on_demand_price` is provided, `bid_price_as_percentage_of_on_demand_price` defaults to 100%.
        :param float bid_price_as_percentage_of_on_demand_price: The bid price, as a percentage of On-Demand price, for each EC2 Spot instance as defined by `instance_type`. Expressed as a number (for example, 20 specifies 20%). If neither `bid_price` nor `bid_price_as_percentage_of_on_demand_price` is provided, `bid_price_as_percentage_of_on_demand_price` defaults to 100%.
        :param Sequence['InstanceFleetInstanceTypeConfigConfigurationArgs'] configurations: A configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster. List of `configuration` blocks.
        :param Sequence['InstanceFleetInstanceTypeConfigEbsConfigArgs'] ebs_configs: Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
        :param int weighted_capacity: The number of units that a provisioned instance of this type provides toward fulfilling the target capacities defined in `emr.InstanceFleet`.
        """
        pulumi.set(__self__, "instance_type", instance_type)
        if bid_price is not None:
            pulumi.set(__self__, "bid_price", bid_price)
        if bid_price_as_percentage_of_on_demand_price is not None:
            pulumi.set(__self__, "bid_price_as_percentage_of_on_demand_price", bid_price_as_percentage_of_on_demand_price)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)
        if ebs_configs is not None:
            pulumi.set(__self__, "ebs_configs", ebs_configs)
        if weighted_capacity is not None:
            pulumi.set(__self__, "weighted_capacity", weighted_capacity)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        An EC2 instance type, such as m4.xlarge.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="bidPrice")
    def bid_price(self) -> Optional[str]:
        """
        The bid price for each EC2 Spot instance type as defined by `instance_type`. Expressed in USD. If neither `bid_price` nor `bid_price_as_percentage_of_on_demand_price` is provided, `bid_price_as_percentage_of_on_demand_price` defaults to 100%.
        """
        return pulumi.get(self, "bid_price")

    @property
    @pulumi.getter(name="bidPriceAsPercentageOfOnDemandPrice")
    def bid_price_as_percentage_of_on_demand_price(self) -> Optional[float]:
        """
        The bid price, as a percentage of On-Demand price, for each EC2 Spot instance as defined by `instance_type`. Expressed as a number (for example, 20 specifies 20%). If neither `bid_price` nor `bid_price_as_percentage_of_on_demand_price` is provided, `bid_price_as_percentage_of_on_demand_price` defaults to 100%.
        """
        return pulumi.get(self, "bid_price_as_percentage_of_on_demand_price")

    @property
    @pulumi.getter
    def configurations(self) -> Optional[Sequence['outputs.InstanceFleetInstanceTypeConfigConfiguration']]:
        """
        A configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster. List of `configuration` blocks.
        """
        return pulumi.get(self, "configurations")

    @property
    @pulumi.getter(name="ebsConfigs")
    def ebs_configs(self) -> Optional[Sequence['outputs.InstanceFleetInstanceTypeConfigEbsConfig']]:
        """
        Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
        """
        return pulumi.get(self, "ebs_configs")

    @property
    @pulumi.getter(name="weightedCapacity")
    def weighted_capacity(self) -> Optional[int]:
        """
        The number of units that a provisioned instance of this type provides toward fulfilling the target capacities defined in `emr.InstanceFleet`.
        """
        return pulumi.get(self, "weighted_capacity")


@pulumi.output_type
class InstanceFleetInstanceTypeConfigConfiguration(dict):
    def __init__(__self__, *,
                 classification: Optional[str] = None,
                 properties: Optional[Mapping[str, Any]] = None):
        """
        :param str classification: The classification within a configuration.
        :param Mapping[str, Any] properties: A map of properties specified within a configuration classification
        """
        if classification is not None:
            pulumi.set(__self__, "classification", classification)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def classification(self) -> Optional[str]:
        """
        The classification within a configuration.
        """
        return pulumi.get(self, "classification")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, Any]]:
        """
        A map of properties specified within a configuration classification
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class InstanceFleetInstanceTypeConfigEbsConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "volumesPerInstance":
            suggest = "volumes_per_instance"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceFleetInstanceTypeConfigEbsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceFleetInstanceTypeConfigEbsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceFleetInstanceTypeConfigEbsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 size: int,
                 type: str,
                 iops: Optional[int] = None,
                 volumes_per_instance: Optional[int] = None):
        """
        :param int size: The volume size, in gibibytes (GiB).
        :param str type: The volume type. Valid options are `gp2`, `io1`, `standard` and `st1`. See [EBS Volume Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html).
        :param int iops: The number of I/O operations per second (IOPS) that the volume supports
        :param int volumes_per_instance: The number of EBS volumes with this configuration to attach to each EC2 instance in the instance group (default is 1)
        """
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "type", type)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if volumes_per_instance is not None:
            pulumi.set(__self__, "volumes_per_instance", volumes_per_instance)

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        The volume size, in gibibytes (GiB).
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The volume type. Valid options are `gp2`, `io1`, `standard` and `st1`. See [EBS Volume Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html).
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        """
        The number of I/O operations per second (IOPS) that the volume supports
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="volumesPerInstance")
    def volumes_per_instance(self) -> Optional[int]:
        """
        The number of EBS volumes with this configuration to attach to each EC2 instance in the instance group (default is 1)
        """
        return pulumi.get(self, "volumes_per_instance")


@pulumi.output_type
class InstanceFleetLaunchSpecifications(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "onDemandSpecifications":
            suggest = "on_demand_specifications"
        elif key == "spotSpecifications":
            suggest = "spot_specifications"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceFleetLaunchSpecifications. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceFleetLaunchSpecifications.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceFleetLaunchSpecifications.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 on_demand_specifications: Optional[Sequence['outputs.InstanceFleetLaunchSpecificationsOnDemandSpecification']] = None,
                 spot_specifications: Optional[Sequence['outputs.InstanceFleetLaunchSpecificationsSpotSpecification']] = None):
        """
        :param Sequence['InstanceFleetLaunchSpecificationsOnDemandSpecificationArgs'] on_demand_specifications: Configuration block for on demand instances launch specifications
        :param Sequence['InstanceFleetLaunchSpecificationsSpotSpecificationArgs'] spot_specifications: Configuration block for spot instances launch specifications
        """
        if on_demand_specifications is not None:
            pulumi.set(__self__, "on_demand_specifications", on_demand_specifications)
        if spot_specifications is not None:
            pulumi.set(__self__, "spot_specifications", spot_specifications)

    @property
    @pulumi.getter(name="onDemandSpecifications")
    def on_demand_specifications(self) -> Optional[Sequence['outputs.InstanceFleetLaunchSpecificationsOnDemandSpecification']]:
        """
        Configuration block for on demand instances launch specifications
        """
        return pulumi.get(self, "on_demand_specifications")

    @property
    @pulumi.getter(name="spotSpecifications")
    def spot_specifications(self) -> Optional[Sequence['outputs.InstanceFleetLaunchSpecificationsSpotSpecification']]:
        """
        Configuration block for spot instances launch specifications
        """
        return pulumi.get(self, "spot_specifications")


@pulumi.output_type
class InstanceFleetLaunchSpecificationsOnDemandSpecification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allocationStrategy":
            suggest = "allocation_strategy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceFleetLaunchSpecificationsOnDemandSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceFleetLaunchSpecificationsOnDemandSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceFleetLaunchSpecificationsOnDemandSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allocation_strategy: str):
        """
        :param str allocation_strategy: Specifies the strategy to use in launching Spot instance fleets. Currently, the only option is `capacity-optimized` (the default), which launches instances from Spot instance pools with optimal capacity for the number of instances that are launching.
        """
        pulumi.set(__self__, "allocation_strategy", allocation_strategy)

    @property
    @pulumi.getter(name="allocationStrategy")
    def allocation_strategy(self) -> str:
        """
        Specifies the strategy to use in launching Spot instance fleets. Currently, the only option is `capacity-optimized` (the default), which launches instances from Spot instance pools with optimal capacity for the number of instances that are launching.
        """
        return pulumi.get(self, "allocation_strategy")


@pulumi.output_type
class InstanceFleetLaunchSpecificationsSpotSpecification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allocationStrategy":
            suggest = "allocation_strategy"
        elif key == "timeoutAction":
            suggest = "timeout_action"
        elif key == "timeoutDurationMinutes":
            suggest = "timeout_duration_minutes"
        elif key == "blockDurationMinutes":
            suggest = "block_duration_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceFleetLaunchSpecificationsSpotSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceFleetLaunchSpecificationsSpotSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceFleetLaunchSpecificationsSpotSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allocation_strategy: str,
                 timeout_action: str,
                 timeout_duration_minutes: int,
                 block_duration_minutes: Optional[int] = None):
        """
        :param str allocation_strategy: Specifies the strategy to use in launching Spot instance fleets. Currently, the only option is `capacity-optimized` (the default), which launches instances from Spot instance pools with optimal capacity for the number of instances that are launching.
        :param str timeout_action: The action to take when TargetSpotCapacity has not been fulfilled when the TimeoutDurationMinutes has expired; that is, when all Spot instances could not be provisioned within the Spot provisioning timeout. Valid values are `TERMINATE_CLUSTER` and `SWITCH_TO_ON_DEMAND`. SWITCH_TO_ON_DEMAND specifies that if no Spot instances are available, On-Demand Instances should be provisioned to fulfill any remaining Spot capacity.
        :param int timeout_duration_minutes: The spot provisioning timeout period in minutes. If Spot instances are not provisioned within this time period, the TimeOutAction is taken. Minimum value is 5 and maximum value is 1440. The timeout applies only during initial provisioning, when the cluster is first created.
        :param int block_duration_minutes: The defined duration for Spot instances (also known as Spot blocks) in minutes. When specified, the Spot instance does not terminate before the defined duration expires, and defined duration pricing for Spot instances applies. Valid values are 60, 120, 180, 240, 300, or 360. The duration period starts as soon as a Spot instance receives its instance ID. At the end of the duration, Amazon EC2 marks the Spot instance for termination and provides a Spot instance termination notice, which gives the instance a two-minute warning before it terminates.
        """
        pulumi.set(__self__, "allocation_strategy", allocation_strategy)
        pulumi.set(__self__, "timeout_action", timeout_action)
        pulumi.set(__self__, "timeout_duration_minutes", timeout_duration_minutes)
        if block_duration_minutes is not None:
            pulumi.set(__self__, "block_duration_minutes", block_duration_minutes)

    @property
    @pulumi.getter(name="allocationStrategy")
    def allocation_strategy(self) -> str:
        """
        Specifies the strategy to use in launching Spot instance fleets. Currently, the only option is `capacity-optimized` (the default), which launches instances from Spot instance pools with optimal capacity for the number of instances that are launching.
        """
        return pulumi.get(self, "allocation_strategy")

    @property
    @pulumi.getter(name="timeoutAction")
    def timeout_action(self) -> str:
        """
        The action to take when TargetSpotCapacity has not been fulfilled when the TimeoutDurationMinutes has expired; that is, when all Spot instances could not be provisioned within the Spot provisioning timeout. Valid values are `TERMINATE_CLUSTER` and `SWITCH_TO_ON_DEMAND`. SWITCH_TO_ON_DEMAND specifies that if no Spot instances are available, On-Demand Instances should be provisioned to fulfill any remaining Spot capacity.
        """
        return pulumi.get(self, "timeout_action")

    @property
    @pulumi.getter(name="timeoutDurationMinutes")
    def timeout_duration_minutes(self) -> int:
        """
        The spot provisioning timeout period in minutes. If Spot instances are not provisioned within this time period, the TimeOutAction is taken. Minimum value is 5 and maximum value is 1440. The timeout applies only during initial provisioning, when the cluster is first created.
        """
        return pulumi.get(self, "timeout_duration_minutes")

    @property
    @pulumi.getter(name="blockDurationMinutes")
    def block_duration_minutes(self) -> Optional[int]:
        """
        The defined duration for Spot instances (also known as Spot blocks) in minutes. When specified, the Spot instance does not terminate before the defined duration expires, and defined duration pricing for Spot instances applies. Valid values are 60, 120, 180, 240, 300, or 360. The duration period starts as soon as a Spot instance receives its instance ID. At the end of the duration, Amazon EC2 marks the Spot instance for termination and provides a Spot instance termination notice, which gives the instance a two-minute warning before it terminates.
        """
        return pulumi.get(self, "block_duration_minutes")


@pulumi.output_type
class InstanceGroupEbsConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "volumesPerInstance":
            suggest = "volumes_per_instance"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceGroupEbsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceGroupEbsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceGroupEbsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 size: int,
                 type: str,
                 iops: Optional[int] = None,
                 volumes_per_instance: Optional[int] = None):
        """
        :param int size: The volume size, in gibibytes (GiB). This can be a number from 1 - 1024. If the volume type is EBS-optimized, the minimum value is 10.
        :param str type: The volume type. Valid options are 'gp2', 'io1' and 'standard'.
        :param int iops: The number of I/O operations per second (IOPS) that the volume supports.
        :param int volumes_per_instance: The number of EBS Volumes to attach per instance.
        """
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "type", type)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if volumes_per_instance is not None:
            pulumi.set(__self__, "volumes_per_instance", volumes_per_instance)

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        The volume size, in gibibytes (GiB). This can be a number from 1 - 1024. If the volume type is EBS-optimized, the minimum value is 10.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The volume type. Valid options are 'gp2', 'io1' and 'standard'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        """
        The number of I/O operations per second (IOPS) that the volume supports.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="volumesPerInstance")
    def volumes_per_instance(self) -> Optional[int]:
        """
        The number of EBS Volumes to attach per instance.
        """
        return pulumi.get(self, "volumes_per_instance")


@pulumi.output_type
class ManagedScalingPolicyComputeLimit(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maximumCapacityUnits":
            suggest = "maximum_capacity_units"
        elif key == "minimumCapacityUnits":
            suggest = "minimum_capacity_units"
        elif key == "unitType":
            suggest = "unit_type"
        elif key == "maximumCoreCapacityUnits":
            suggest = "maximum_core_capacity_units"
        elif key == "maximumOndemandCapacityUnits":
            suggest = "maximum_ondemand_capacity_units"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedScalingPolicyComputeLimit. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedScalingPolicyComputeLimit.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedScalingPolicyComputeLimit.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 maximum_capacity_units: int,
                 minimum_capacity_units: int,
                 unit_type: str,
                 maximum_core_capacity_units: Optional[int] = None,
                 maximum_ondemand_capacity_units: Optional[int] = None):
        """
        :param int maximum_capacity_units: The upper boundary of EC2 units. It is measured through VCPU cores or instances for instance groups and measured through units for instance fleets. Managed scaling activities are not allowed beyond this boundary. The limit only applies to the core and task nodes. The master node cannot be scaled after initial configuration.
        :param int minimum_capacity_units: The lower boundary of EC2 units. It is measured through VCPU cores or instances for instance groups and measured through units for instance fleets. Managed scaling activities are not allowed beyond this boundary. The limit only applies to the core and task nodes. The master node cannot be scaled after initial configuration.
        :param str unit_type: The unit type used for specifying a managed scaling policy. Valid Values: `InstanceFleetUnits` | `Instances` | `VCPU`
        :param int maximum_core_capacity_units: The upper boundary of EC2 units for core node type in a cluster. It is measured through VCPU cores or instances for instance groups and measured through units for instance fleets. The core units are not allowed to scale beyond this boundary. The parameter is used to split capacity allocation between core and task nodes.
        :param int maximum_ondemand_capacity_units: The upper boundary of On-Demand EC2 units. It is measured through VCPU cores or instances for instance groups and measured through units for instance fleets. The On-Demand units are not allowed to scale beyond this boundary. The parameter is used to split capacity allocation between On-Demand and Spot instances.
        """
        pulumi.set(__self__, "maximum_capacity_units", maximum_capacity_units)
        pulumi.set(__self__, "minimum_capacity_units", minimum_capacity_units)
        pulumi.set(__self__, "unit_type", unit_type)
        if maximum_core_capacity_units is not None:
            pulumi.set(__self__, "maximum_core_capacity_units", maximum_core_capacity_units)
        if maximum_ondemand_capacity_units is not None:
            pulumi.set(__self__, "maximum_ondemand_capacity_units", maximum_ondemand_capacity_units)

    @property
    @pulumi.getter(name="maximumCapacityUnits")
    def maximum_capacity_units(self) -> int:
        """
        The upper boundary of EC2 units. It is measured through VCPU cores or instances for instance groups and measured through units for instance fleets. Managed scaling activities are not allowed beyond this boundary. The limit only applies to the core and task nodes. The master node cannot be scaled after initial configuration.
        """
        return pulumi.get(self, "maximum_capacity_units")

    @property
    @pulumi.getter(name="minimumCapacityUnits")
    def minimum_capacity_units(self) -> int:
        """
        The lower boundary of EC2 units. It is measured through VCPU cores or instances for instance groups and measured through units for instance fleets. Managed scaling activities are not allowed beyond this boundary. The limit only applies to the core and task nodes. The master node cannot be scaled after initial configuration.
        """
        return pulumi.get(self, "minimum_capacity_units")

    @property
    @pulumi.getter(name="unitType")
    def unit_type(self) -> str:
        """
        The unit type used for specifying a managed scaling policy. Valid Values: `InstanceFleetUnits` | `Instances` | `VCPU`
        """
        return pulumi.get(self, "unit_type")

    @property
    @pulumi.getter(name="maximumCoreCapacityUnits")
    def maximum_core_capacity_units(self) -> Optional[int]:
        """
        The upper boundary of EC2 units for core node type in a cluster. It is measured through VCPU cores or instances for instance groups and measured through units for instance fleets. The core units are not allowed to scale beyond this boundary. The parameter is used to split capacity allocation between core and task nodes.
        """
        return pulumi.get(self, "maximum_core_capacity_units")

    @property
    @pulumi.getter(name="maximumOndemandCapacityUnits")
    def maximum_ondemand_capacity_units(self) -> Optional[int]:
        """
        The upper boundary of On-Demand EC2 units. It is measured through VCPU cores or instances for instance groups and measured through units for instance fleets. The On-Demand units are not allowed to scale beyond this boundary. The parameter is used to split capacity allocation between On-Demand and Spot instances.
        """
        return pulumi.get(self, "maximum_ondemand_capacity_units")


